// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --unique --version 5
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,+real-true16 -show-encoding %s | FileCheck --check-prefix=GFX12 %s

v_bfrev_b32_e64 v5, v1
// GFX12: v_bfrev_b32_e64 v5, v1                  ; encoding: [0x05,0x00,0xb8,0xd5,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, v255
// GFX12: v_bfrev_b32_e64 v5, v255                ; encoding: [0x05,0x00,0xb8,0xd5,0xff,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, s1
// GFX12: v_bfrev_b32_e64 v5, s1                  ; encoding: [0x05,0x00,0xb8,0xd5,0x01,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, s105
// GFX12: v_bfrev_b32_e64 v5, s105                ; encoding: [0x05,0x00,0xb8,0xd5,0x69,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_lo
// GFX12: v_bfrev_b32_e64 v5, vcc_lo              ; encoding: [0x05,0x00,0xb8,0xd5,0x6a,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_hi
// GFX12: v_bfrev_b32_e64 v5, vcc_hi              ; encoding: [0x05,0x00,0xb8,0xd5,0x6b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, ttmp15
// GFX12: v_bfrev_b32_e64 v5, ttmp15              ; encoding: [0x05,0x00,0xb8,0xd5,0x7b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, m0
// GFX12: v_bfrev_b32_e64 v5, m0                  ; encoding: [0x05,0x00,0xb8,0xd5,0x7d,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_lo
// GFX12: v_bfrev_b32_e64 v5, exec_lo             ; encoding: [0x05,0x00,0xb8,0xd5,0x7e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_hi
// GFX12: v_bfrev_b32_e64 v5, exec_hi             ; encoding: [0x05,0x00,0xb8,0xd5,0x7f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, null
// GFX12: v_bfrev_b32_e64 v5, null                ; encoding: [0x05,0x00,0xb8,0xd5,0x7c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -1
// GFX12: v_bfrev_b32_e64 v5, -1                  ; encoding: [0x05,0x00,0xb8,0xd5,0xc1,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0.5
// GFX12: v_bfrev_b32_e64 v5, 0.5                 ; encoding: [0x05,0x00,0xb8,0xd5,0xf0,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, src_scc
// GFX12: v_bfrev_b32_e64 v5, src_scc             ; encoding: [0x05,0x00,0xb8,0xd5,0xfd,0x00,0x00,0x00]

v_bfrev_b32_e64 v255, 0xaf123456
// GFX12: v_bfrev_b32_e64 v255, 0xaf123456        ; encoding: [0xff,0x00,0xb8,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_ceil_f16_e64 v5, v1
// GFX12: v_ceil_f16_e64 v5, v1                   ; encoding: [0x05,0x00,0xdc,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f16_e64 v5, v255
// GFX12: v_ceil_f16_e64 v5, v255                 ; encoding: [0x05,0x00,0xdc,0xd5,0xff,0x01,0x00,0x00]

v_ceil_f16_e64 v5, s1
// GFX12: v_ceil_f16_e64 v5, s1                   ; encoding: [0x05,0x00,0xdc,0xd5,0x01,0x00,0x00,0x00]

v_ceil_f16_e64 v5, s105
// GFX12: v_ceil_f16_e64 v5, s105                 ; encoding: [0x05,0x00,0xdc,0xd5,0x69,0x00,0x00,0x00]

v_ceil_f16_e64 v5, vcc_lo
// GFX12: v_ceil_f16_e64 v5, vcc_lo               ; encoding: [0x05,0x00,0xdc,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f16_e64 v5, vcc_hi
// GFX12: v_ceil_f16_e64 v5, vcc_hi               ; encoding: [0x05,0x00,0xdc,0xd5,0x6b,0x00,0x00,0x00]

v_ceil_f16_e64 v5, ttmp15
// GFX12: v_ceil_f16_e64 v5, ttmp15               ; encoding: [0x05,0x00,0xdc,0xd5,0x7b,0x00,0x00,0x00]

v_ceil_f16_e64 v5, m0
// GFX12: v_ceil_f16_e64 v5, m0                   ; encoding: [0x05,0x00,0xdc,0xd5,0x7d,0x00,0x00,0x00]

v_ceil_f16_e64 v5, exec_lo
// GFX12: v_ceil_f16_e64 v5, exec_lo              ; encoding: [0x05,0x00,0xdc,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f16_e64 v5, exec_hi
// GFX12: v_ceil_f16_e64 v5, exec_hi              ; encoding: [0x05,0x00,0xdc,0xd5,0x7f,0x00,0x00,0x00]

v_ceil_f16_e64 v5, null
// GFX12: v_ceil_f16_e64 v5, null                 ; encoding: [0x05,0x00,0xdc,0xd5,0x7c,0x00,0x00,0x00]

v_ceil_f16_e64 v5, -1
// GFX12: v_ceil_f16_e64 v5, -1                   ; encoding: [0x05,0x00,0xdc,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f16_e64 v5, 0.5 mul:2
// GFX12: v_ceil_f16_e64 v5, 0.5 mul:2            ; encoding: [0x05,0x00,0xdc,0xd5,0xf0,0x00,0x00,0x08]

v_ceil_f16_e64 v5, src_scc mul:4
// GFX12: v_ceil_f16_e64 v5, src_scc mul:4        ; encoding: [0x05,0x00,0xdc,0xd5,0xfd,0x00,0x00,0x10]

v_ceil_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_ceil_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xdc,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_ceil_f32_e64 v5, v1
// GFX12: v_ceil_f32_e64 v5, v1                   ; encoding: [0x05,0x00,0xa2,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v255
// GFX12: v_ceil_f32_e64 v5, v255                 ; encoding: [0x05,0x00,0xa2,0xd5,0xff,0x01,0x00,0x00]

v_ceil_f32_e64 v5, s1
// GFX12: v_ceil_f32_e64 v5, s1                   ; encoding: [0x05,0x00,0xa2,0xd5,0x01,0x00,0x00,0x00]

v_ceil_f32_e64 v5, s105
// GFX12: v_ceil_f32_e64 v5, s105                 ; encoding: [0x05,0x00,0xa2,0xd5,0x69,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_lo
// GFX12: v_ceil_f32_e64 v5, vcc_lo               ; encoding: [0x05,0x00,0xa2,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_hi
// GFX12: v_ceil_f32_e64 v5, vcc_hi               ; encoding: [0x05,0x00,0xa2,0xd5,0x6b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, ttmp15
// GFX12: v_ceil_f32_e64 v5, ttmp15               ; encoding: [0x05,0x00,0xa2,0xd5,0x7b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, m0
// GFX12: v_ceil_f32_e64 v5, m0                   ; encoding: [0x05,0x00,0xa2,0xd5,0x7d,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_lo
// GFX12: v_ceil_f32_e64 v5, exec_lo              ; encoding: [0x05,0x00,0xa2,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_hi
// GFX12: v_ceil_f32_e64 v5, exec_hi              ; encoding: [0x05,0x00,0xa2,0xd5,0x7f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, null
// GFX12: v_ceil_f32_e64 v5, null                 ; encoding: [0x05,0x00,0xa2,0xd5,0x7c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -1
// GFX12: v_ceil_f32_e64 v5, -1                   ; encoding: [0x05,0x00,0xa2,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0.5 mul:2
// GFX12: v_ceil_f32_e64 v5, 0.5 mul:2            ; encoding: [0x05,0x00,0xa2,0xd5,0xf0,0x00,0x00,0x08]

v_ceil_f32_e64 v5, src_scc mul:4
// GFX12: v_ceil_f32_e64 v5, src_scc mul:4        ; encoding: [0x05,0x00,0xa2,0xd5,0xfd,0x00,0x00,0x10]

v_ceil_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_ceil_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xa2,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_ceil_f64_e64 v[5:6], v[1:2]
// GFX12: v_ceil_f64_e64 v[5:6], v[1:2]           ; encoding: [0x05,0x00,0x98,0xd5,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[254:255]
// GFX12: v_ceil_f64_e64 v[5:6], v[254:255]       ; encoding: [0x05,0x00,0x98,0xd5,0xfe,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[2:3]
// GFX12: v_ceil_f64_e64 v[5:6], s[2:3]           ; encoding: [0x05,0x00,0x98,0xd5,0x02,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[104:105]
// GFX12: v_ceil_f64_e64 v[5:6], s[104:105]       ; encoding: [0x05,0x00,0x98,0xd5,0x68,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], vcc
// GFX12: v_ceil_f64_e64 v[5:6], vcc              ; encoding: [0x05,0x00,0x98,0xd5,0x6a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_ceil_f64_e64 v[5:6], ttmp[14:15]      ; encoding: [0x05,0x00,0x98,0xd5,0x7a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], exec
// GFX12: v_ceil_f64_e64 v[5:6], exec             ; encoding: [0x05,0x00,0x98,0xd5,0x7e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], null
// GFX12: v_ceil_f64_e64 v[5:6], null             ; encoding: [0x05,0x00,0x98,0xd5,0x7c,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -1
// GFX12: v_ceil_f64_e64 v[5:6], -1               ; encoding: [0x05,0x00,0x98,0xd5,0xc1,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_ceil_f64_e64 v[5:6], 0.5 mul:2        ; encoding: [0x05,0x00,0x98,0xd5,0xf0,0x00,0x00,0x08]

v_ceil_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_ceil_f64_e64 v[5:6], -|src_scc| mul:4 ; encoding: [0x05,0x01,0x98,0xd5,0xfd,0x00,0x00,0x30]

v_ceil_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_ceil_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0x98,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cls_i32_e64 v5, v1
// GFX12: v_cls_i32_e64 v5, v1                    ; encoding: [0x05,0x00,0xbb,0xd5,0x01,0x01,0x00,0x00]

v_cls_i32_e64 v5, v255
// GFX12: v_cls_i32_e64 v5, v255                  ; encoding: [0x05,0x00,0xbb,0xd5,0xff,0x01,0x00,0x00]

v_cls_i32_e64 v5, s1
// GFX12: v_cls_i32_e64 v5, s1                    ; encoding: [0x05,0x00,0xbb,0xd5,0x01,0x00,0x00,0x00]

v_cls_i32_e64 v5, s105
// GFX12: v_cls_i32_e64 v5, s105                  ; encoding: [0x05,0x00,0xbb,0xd5,0x69,0x00,0x00,0x00]

v_cls_i32_e64 v5, vcc_lo
// GFX12: v_cls_i32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xbb,0xd5,0x6a,0x00,0x00,0x00]

v_cls_i32_e64 v5, vcc_hi
// GFX12: v_cls_i32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xbb,0xd5,0x6b,0x00,0x00,0x00]

v_cls_i32_e64 v5, ttmp15
// GFX12: v_cls_i32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xbb,0xd5,0x7b,0x00,0x00,0x00]

v_cls_i32_e64 v5, m0
// GFX12: v_cls_i32_e64 v5, m0                    ; encoding: [0x05,0x00,0xbb,0xd5,0x7d,0x00,0x00,0x00]

v_cls_i32_e64 v5, exec_lo
// GFX12: v_cls_i32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xbb,0xd5,0x7e,0x00,0x00,0x00]

v_cls_i32_e64 v5, exec_hi
// GFX12: v_cls_i32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xbb,0xd5,0x7f,0x00,0x00,0x00]

v_cls_i32_e64 v5, null
// GFX12: v_cls_i32_e64 v5, null                  ; encoding: [0x05,0x00,0xbb,0xd5,0x7c,0x00,0x00,0x00]

v_cls_i32_e64 v5, -1
// GFX12: v_cls_i32_e64 v5, -1                    ; encoding: [0x05,0x00,0xbb,0xd5,0xc1,0x00,0x00,0x00]

v_cls_i32_e64 v5, 0.5
// GFX12: v_cls_i32_e64 v5, 0.5                   ; encoding: [0x05,0x00,0xbb,0xd5,0xf0,0x00,0x00,0x00]

v_cls_i32_e64 v5, src_scc
// GFX12: v_cls_i32_e64 v5, src_scc               ; encoding: [0x05,0x00,0xbb,0xd5,0xfd,0x00,0x00,0x00]

v_cls_i32_e64 v255, 0xaf123456
// GFX12: v_cls_i32_e64 v255, 0xaf123456          ; encoding: [0xff,0x00,0xbb,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_clz_i32_u32_e64 v5, v1
// GFX12: v_clz_i32_u32_e64 v5, v1                ; encoding: [0x05,0x00,0xb9,0xd5,0x01,0x01,0x00,0x00]

v_clz_i32_u32_e64 v5, v255
// GFX12: v_clz_i32_u32_e64 v5, v255              ; encoding: [0x05,0x00,0xb9,0xd5,0xff,0x01,0x00,0x00]

v_clz_i32_u32_e64 v5, s1
// GFX12: v_clz_i32_u32_e64 v5, s1                ; encoding: [0x05,0x00,0xb9,0xd5,0x01,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, s105
// GFX12: v_clz_i32_u32_e64 v5, s105              ; encoding: [0x05,0x00,0xb9,0xd5,0x69,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, vcc_lo
// GFX12: v_clz_i32_u32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0xb9,0xd5,0x6a,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, vcc_hi
// GFX12: v_clz_i32_u32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0xb9,0xd5,0x6b,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, ttmp15
// GFX12: v_clz_i32_u32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0xb9,0xd5,0x7b,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, m0
// GFX12: v_clz_i32_u32_e64 v5, m0                ; encoding: [0x05,0x00,0xb9,0xd5,0x7d,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, exec_lo
// GFX12: v_clz_i32_u32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0xb9,0xd5,0x7e,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, exec_hi
// GFX12: v_clz_i32_u32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0xb9,0xd5,0x7f,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, null
// GFX12: v_clz_i32_u32_e64 v5, null              ; encoding: [0x05,0x00,0xb9,0xd5,0x7c,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, -1
// GFX12: v_clz_i32_u32_e64 v5, -1                ; encoding: [0x05,0x00,0xb9,0xd5,0xc1,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, 0.5
// GFX12: v_clz_i32_u32_e64 v5, 0.5               ; encoding: [0x05,0x00,0xb9,0xd5,0xf0,0x00,0x00,0x00]

v_clz_i32_u32_e64 v5, src_scc
// GFX12: v_clz_i32_u32_e64 v5, src_scc           ; encoding: [0x05,0x00,0xb9,0xd5,0xfd,0x00,0x00,0x00]

v_clz_i32_u32_e64 v255, 0xaf123456
// GFX12: v_clz_i32_u32_e64 v255, 0xaf123456      ; encoding: [0xff,0x00,0xb9,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cos_f16_e64 v5.l, v1.l
// GFX12: v_cos_f16_e64 v5.l, v1.l                ; encoding: [0x05,0x00,0xe1,0xd5,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v5.l, v255.l
// GFX12: v_cos_f16_e64 v5.l, v255.l              ; encoding: [0x05,0x00,0xe1,0xd5,0xff,0x01,0x00,0x00]

v_cos_f16_e64 v5.l, s1
// GFX12: v_cos_f16_e64 v5.l, s1                  ; encoding: [0x05,0x00,0xe1,0xd5,0x01,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, s105
// GFX12: v_cos_f16_e64 v5.l, s105                ; encoding: [0x05,0x00,0xe1,0xd5,0x69,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, vcc_lo
// GFX12: v_cos_f16_e64 v5.l, vcc_lo              ; encoding: [0x05,0x00,0xe1,0xd5,0x6a,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, vcc_hi
// GFX12: v_cos_f16_e64 v5.l, vcc_hi              ; encoding: [0x05,0x00,0xe1,0xd5,0x6b,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, ttmp15
// GFX12: v_cos_f16_e64 v5.l, ttmp15              ; encoding: [0x05,0x00,0xe1,0xd5,0x7b,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, m0
// GFX12: v_cos_f16_e64 v5.l, m0                  ; encoding: [0x05,0x00,0xe1,0xd5,0x7d,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, exec_lo
// GFX12: v_cos_f16_e64 v5.l, exec_lo             ; encoding: [0x05,0x00,0xe1,0xd5,0x7e,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, exec_hi
// GFX12: v_cos_f16_e64 v5.l, exec_hi             ; encoding: [0x05,0x00,0xe1,0xd5,0x7f,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, null
// GFX12: v_cos_f16_e64 v5.l, null                ; encoding: [0x05,0x00,0xe1,0xd5,0x7c,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, -1
// GFX12: v_cos_f16_e64 v5.l, -1                  ; encoding: [0x05,0x00,0xe1,0xd5,0xc1,0x00,0x00,0x00]

v_cos_f16_e64 v5.l, 0.5 mul:2
// GFX12: v_cos_f16_e64 v5.l, 0.5 mul:2           ; encoding: [0x05,0x00,0xe1,0xd5,0xf0,0x00,0x00,0x08]

v_cos_f16_e64 v5.l, src_scc mul:4
// GFX12: v_cos_f16_e64 v5.l, src_scc mul:4       ; encoding: [0x05,0x00,0xe1,0xd5,0xfd,0x00,0x00,0x10]

v_cos_f16_e64 v255.l, -|0xfe0b| clamp div:2
// GFX12: v_cos_f16_e64 v255.l, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xe1,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_cos_f16_e64 v5.h, v1.h
// GFX12: v_cos_f16_e64 v5.h, v1.h op_sel:[1,1]   ; encoding: [0x05,0x48,0xe1,0xd5,0x01,0x01,0x00,0x00]

v_cos_f16_e64 v5.l, v255.h
// GFX12: v_cos_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xe1,0xd5,0xff,0x01,0x00,0x00]

v_cos_f16_e64 v255.h, -|0xfe0b| clamp div:2
// GFX12: v_cos_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc1,0xe1,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_cos_f32_e64 v5, v1
// GFX12: v_cos_f32_e64 v5, v1                    ; encoding: [0x05,0x00,0xb6,0xd5,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v255
// GFX12: v_cos_f32_e64 v5, v255                  ; encoding: [0x05,0x00,0xb6,0xd5,0xff,0x01,0x00,0x00]

v_cos_f32_e64 v5, s1
// GFX12: v_cos_f32_e64 v5, s1                    ; encoding: [0x05,0x00,0xb6,0xd5,0x01,0x00,0x00,0x00]

v_cos_f32_e64 v5, s105
// GFX12: v_cos_f32_e64 v5, s105                  ; encoding: [0x05,0x00,0xb6,0xd5,0x69,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_lo
// GFX12: v_cos_f32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xb6,0xd5,0x6a,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_hi
// GFX12: v_cos_f32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xb6,0xd5,0x6b,0x00,0x00,0x00]

v_cos_f32_e64 v5, ttmp15
// GFX12: v_cos_f32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xb6,0xd5,0x7b,0x00,0x00,0x00]

v_cos_f32_e64 v5, m0
// GFX12: v_cos_f32_e64 v5, m0                    ; encoding: [0x05,0x00,0xb6,0xd5,0x7d,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_lo
// GFX12: v_cos_f32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xb6,0xd5,0x7e,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_hi
// GFX12: v_cos_f32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xb6,0xd5,0x7f,0x00,0x00,0x00]

v_cos_f32_e64 v5, null
// GFX12: v_cos_f32_e64 v5, null                  ; encoding: [0x05,0x00,0xb6,0xd5,0x7c,0x00,0x00,0x00]

v_cos_f32_e64 v5, -1
// GFX12: v_cos_f32_e64 v5, -1                    ; encoding: [0x05,0x00,0xb6,0xd5,0xc1,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0.5 mul:2
// GFX12: v_cos_f32_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xb6,0xd5,0xf0,0x00,0x00,0x08]

v_cos_f32_e64 v5, src_scc mul:4
// GFX12: v_cos_f32_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xb6,0xd5,0xfd,0x00,0x00,0x10]

v_cos_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_cos_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xb6,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_ctz_i32_b32_e64 v5, v1
// GFX12: v_ctz_i32_b32_e64 v5, v1                ; encoding: [0x05,0x00,0xba,0xd5,0x01,0x01,0x00,0x00]

v_ctz_i32_b32_e64 v5, v255
// GFX12: v_ctz_i32_b32_e64 v5, v255              ; encoding: [0x05,0x00,0xba,0xd5,0xff,0x01,0x00,0x00]

v_ctz_i32_b32_e64 v5, s1
// GFX12: v_ctz_i32_b32_e64 v5, s1                ; encoding: [0x05,0x00,0xba,0xd5,0x01,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, s105
// GFX12: v_ctz_i32_b32_e64 v5, s105              ; encoding: [0x05,0x00,0xba,0xd5,0x69,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, vcc_lo
// GFX12: v_ctz_i32_b32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0xba,0xd5,0x6a,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, vcc_hi
// GFX12: v_ctz_i32_b32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0xba,0xd5,0x6b,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, ttmp15
// GFX12: v_ctz_i32_b32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0xba,0xd5,0x7b,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, m0
// GFX12: v_ctz_i32_b32_e64 v5, m0                ; encoding: [0x05,0x00,0xba,0xd5,0x7d,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, exec_lo
// GFX12: v_ctz_i32_b32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0xba,0xd5,0x7e,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, exec_hi
// GFX12: v_ctz_i32_b32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0xba,0xd5,0x7f,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, null
// GFX12: v_ctz_i32_b32_e64 v5, null              ; encoding: [0x05,0x00,0xba,0xd5,0x7c,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, -1
// GFX12: v_ctz_i32_b32_e64 v5, -1                ; encoding: [0x05,0x00,0xba,0xd5,0xc1,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, 0.5
// GFX12: v_ctz_i32_b32_e64 v5, 0.5               ; encoding: [0x05,0x00,0xba,0xd5,0xf0,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v5, src_scc
// GFX12: v_ctz_i32_b32_e64 v5, src_scc           ; encoding: [0x05,0x00,0xba,0xd5,0xfd,0x00,0x00,0x00]

v_ctz_i32_b32_e64 v255, 0xaf123456
// GFX12: v_ctz_i32_b32_e64 v255, 0xaf123456      ; encoding: [0xff,0x00,0xba,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cvt_f32_bf8_e64 v1, s3
// GFX12: v_cvt_f32_bf8_e64 v1, s3                ; encoding: [0x01,0x00,0xed,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, s3 byte_sel:1
// GFX12: v_cvt_f32_bf8_e64 v1, s3 byte_sel:1     ; encoding: [0x01,0x10,0xed,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, s3 byte_sel:2
// GFX12: v_cvt_f32_bf8_e64 v1, s3 byte_sel:2     ; encoding: [0x01,0x08,0xed,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, s3 byte_sel:3
// GFX12: v_cvt_f32_bf8_e64 v1, s3 byte_sel:3     ; encoding: [0x01,0x18,0xed,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, 3
// GFX12: v_cvt_f32_bf8_e64 v1, 3                 ; encoding: [0x01,0x00,0xed,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, 3 byte_sel:1
// GFX12: v_cvt_f32_bf8_e64 v1, 3 byte_sel:1      ; encoding: [0x01,0x10,0xed,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, 3 byte_sel:2
// GFX12: v_cvt_f32_bf8_e64 v1, 3 byte_sel:2      ; encoding: [0x01,0x08,0xed,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, 3 byte_sel:3
// GFX12: v_cvt_f32_bf8_e64 v1, 3 byte_sel:3      ; encoding: [0x01,0x18,0xed,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_bf8_e64 v1, v3
// GFX12: v_cvt_f32_bf8_e64 v1, v3                ; encoding: [0x01,0x00,0xed,0xd5,0x03,0x01,0x00,0x00]

v_cvt_f32_bf8_e64 v1, v3 byte_sel:1
// GFX12: v_cvt_f32_bf8_e64 v1, v3 byte_sel:1     ; encoding: [0x01,0x10,0xed,0xd5,0x03,0x01,0x00,0x00]

v_cvt_f32_bf8_e64 v1, v3 byte_sel:2
// GFX12: v_cvt_f32_bf8_e64 v1, v3 byte_sel:2     ; encoding: [0x01,0x08,0xed,0xd5,0x03,0x01,0x00,0x00]

v_cvt_f32_bf8_e64 v1, v3 byte_sel:3
// GFX12: v_cvt_f32_bf8_e64 v1, v3 byte_sel:3     ; encoding: [0x01,0x18,0xed,0xd5,0x03,0x01,0x00,0x00]

v_cvt_f32_fp8_e64 v1, s3
// GFX12: v_cvt_f32_fp8_e64 v1, s3                ; encoding: [0x01,0x00,0xec,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, s3 byte_sel:1
// GFX12: v_cvt_f32_fp8_e64 v1, s3 byte_sel:1     ; encoding: [0x01,0x10,0xec,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, s3 byte_sel:2
// GFX12: v_cvt_f32_fp8_e64 v1, s3 byte_sel:2     ; encoding: [0x01,0x08,0xec,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, s3 byte_sel:3
// GFX12: v_cvt_f32_fp8_e64 v1, s3 byte_sel:3     ; encoding: [0x01,0x18,0xec,0xd5,0x03,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, 3
// GFX12: v_cvt_f32_fp8_e64 v1, 3                 ; encoding: [0x01,0x00,0xec,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, 3 byte_sel:1
// GFX12: v_cvt_f32_fp8_e64 v1, 3 byte_sel:1      ; encoding: [0x01,0x10,0xec,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, 3 byte_sel:2
// GFX12: v_cvt_f32_fp8_e64 v1, 3 byte_sel:2      ; encoding: [0x01,0x08,0xec,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, 3 byte_sel:3
// GFX12: v_cvt_f32_fp8_e64 v1, 3 byte_sel:3      ; encoding: [0x01,0x18,0xec,0xd5,0x83,0x00,0x00,0x00]

v_cvt_f32_fp8_e64 v1, v3
// GFX12: v_cvt_f32_fp8_e64 v1, v3                ; encoding: [0x01,0x00,0xec,0xd5,0x03,0x01,0x00,0x00]

v_cvt_f32_fp8_e64 v1, v3 byte_sel:1
// GFX12: v_cvt_f32_fp8_e64 v1, v3 byte_sel:1     ; encoding: [0x01,0x10,0xec,0xd5,0x03,0x01,0x00,0x00]

v_cvt_f32_fp8_e64 v1, v3 byte_sel:2
// GFX12: v_cvt_f32_fp8_e64 v1, v3 byte_sel:2     ; encoding: [0x01,0x08,0xec,0xd5,0x03,0x01,0x00,0x00]

v_cvt_f32_fp8_e64 v1, v3 byte_sel:3
// GFX12: v_cvt_f32_fp8_e64 v1, v3 byte_sel:3     ; encoding: [0x01,0x18,0xec,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], s3
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], s3         ; encoding: [0x02,0x00,0xef,0xd5,0x03,0x00,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], s3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], s3 op_sel:[1,0] ; encoding: [0x02,0x08,0xef,0xd5,0x03,0x00,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], 3
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], 3          ; encoding: [0x02,0x00,0xef,0xd5,0x83,0x00,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], 3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], 3 op_sel:[1,0] ; encoding: [0x02,0x08,0xef,0xd5,0x83,0x00,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], v3
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], v3         ; encoding: [0x02,0x00,0xef,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], v3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], v3 op_sel:[1,0] ; encoding: [0x02,0x08,0xef,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], v3.h
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], v3.h op_sel:[1,0] ; encoding: [0x02,0x08,0xef,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[2:3], v255.h
// GFX12: v_cvt_pk_f32_bf8_e64 v[2:3], v255.h op_sel:[1,0] ; encoding: [0x02,0x08,0xef,0xd5,0xff,0x01,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[2:3], s3
// GFX12: v_cvt_pk_f32_fp8_e64 v[2:3], s3         ; encoding: [0x02,0x00,0xee,0xd5,0x03,0x00,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[2:3], s3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_fp8_e64 v[2:3], s3 op_sel:[1,0] ; encoding: [0x02,0x08,0xee,0xd5,0x03,0x00,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[2:3], 3
// GFX12: v_cvt_pk_f32_fp8_e64 v[2:3], 3          ; encoding: [0x02,0x00,0xee,0xd5,0x83,0x00,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[2:3], 3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_fp8_e64 v[2:3], 3 op_sel:[1,0] ; encoding: [0x02,0x08,0xee,0xd5,0x83,0x00,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[2:3], v3
// GFX12: v_cvt_pk_f32_fp8_e64 v[2:3], v3         ; encoding: [0x02,0x00,0xee,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[2:3], v3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_fp8_e64 v[2:3], v3 op_sel:[1,0] ; encoding: [0x02,0x08,0xee,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[3:4], s3
// GFX12: v_cvt_pk_f32_bf8_e64 v[3:4], s3         ; encoding: [0x03,0x00,0xef,0xd5,0x03,0x00,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[3:4], s3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_bf8_e64 v[3:4], s3 op_sel:[1,0] ; encoding: [0x03,0x08,0xef,0xd5,0x03,0x00,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[3:4], 3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_bf8_e64 v[3:4], 3 op_sel:[1,0] ; encoding: [0x03,0x08,0xef,0xd5,0x83,0x00,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[3:4], v3
// GFX12: v_cvt_pk_f32_bf8_e64 v[3:4], v3         ; encoding: [0x03,0x00,0xef,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_bf8_e64 v[3:4], v3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_bf8_e64 v[3:4], v3 op_sel:[1,0] ; encoding: [0x03,0x08,0xef,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[3:4], s3
// GFX12: v_cvt_pk_f32_fp8_e64 v[3:4], s3         ; encoding: [0x03,0x00,0xee,0xd5,0x03,0x00,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[3:4], 3
// GFX12: v_cvt_pk_f32_fp8_e64 v[3:4], 3          ; encoding: [0x03,0x00,0xee,0xd5,0x83,0x00,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[3:4], 3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_fp8_e64 v[3:4], 3 op_sel:[1,0] ; encoding: [0x03,0x08,0xee,0xd5,0x83,0x00,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[3:4], v3
// GFX12: v_cvt_pk_f32_fp8_e64 v[3:4], v3         ; encoding: [0x03,0x00,0xee,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[3:4], v3 op_sel:[1,0]
// GFX12: v_cvt_pk_f32_fp8_e64 v[3:4], v3 op_sel:[1,0] ; encoding: [0x03,0x08,0xee,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[3:4], v3.h
// GFX12: v_cvt_pk_f32_fp8_e64 v[3:4], v3.h op_sel:[1,0] ; encoding: [0x03,0x08,0xee,0xd5,0x03,0x01,0x00,0x00]

v_cvt_pk_f32_fp8_e64 v[3:4], v255.h
// GFX12: v_cvt_pk_f32_fp8_e64 v[3:4], v255.h op_sel:[1,0] ; encoding: [0x03,0x08,0xee,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5.l, v1
// GFX12: v_cvt_f16_f32_e64 v5.l, v1              ; encoding: [0x05,0x00,0x8a,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5.l, v255
// GFX12: v_cvt_f16_f32_e64 v5.l, v255            ; encoding: [0x05,0x00,0x8a,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, s1
// GFX12: v_cvt_f16_f32_e64 v5, s1                ; encoding: [0x05,0x00,0x8a,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, s105
// GFX12: v_cvt_f16_f32_e64 v5, s105              ; encoding: [0x05,0x00,0x8a,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_lo
// GFX12: v_cvt_f16_f32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0x8a,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_hi
// GFX12: v_cvt_f16_f32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0x8a,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, ttmp15
// GFX12: v_cvt_f16_f32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0x8a,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, m0
// GFX12: v_cvt_f16_f32_e64 v5, m0                ; encoding: [0x05,0x00,0x8a,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_lo
// GFX12: v_cvt_f16_f32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0x8a,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_hi
// GFX12: v_cvt_f16_f32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0x8a,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, null
// GFX12: v_cvt_f16_f32_e64 v5, null              ; encoding: [0x05,0x00,0x8a,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -1
// GFX12: v_cvt_f16_f32_e64 v5, -1                ; encoding: [0x05,0x00,0x8a,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f16_f32_e64 v5, 0.5 mul:2         ; encoding: [0x05,0x00,0x8a,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f16_f32_e64 v5, src_scc mul:4
// GFX12: v_cvt_f16_f32_e64 v5, src_scc mul:4     ; encoding: [0x05,0x00,0x8a,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f16_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_cvt_f16_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0x8a,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_cvt_f16_f32_e64 v255.h, -|0xaf123456| clamp div:2
// GFX12: v_cvt_f16_f32_e64 v255.h, -|0xaf123456| op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc1,0x8a,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_cvt_f16_i16_e64 v5.l, v1.l
// GFX12: v_cvt_f16_i16_e64 v5.l, v1.l            ; encoding: [0x05,0x00,0xd1,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, v255.l
// GFX12: v_cvt_f16_i16_e64 v5.l, v255.l          ; encoding: [0x05,0x00,0xd1,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, s1
// GFX12: v_cvt_f16_i16_e64 v5.l, s1              ; encoding: [0x05,0x00,0xd1,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, s105
// GFX12: v_cvt_f16_i16_e64 v5.l, s105            ; encoding: [0x05,0x00,0xd1,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, vcc_lo
// GFX12: v_cvt_f16_i16_e64 v5.l, vcc_lo          ; encoding: [0x05,0x00,0xd1,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, vcc_hi
// GFX12: v_cvt_f16_i16_e64 v5.l, vcc_hi          ; encoding: [0x05,0x00,0xd1,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, ttmp15
// GFX12: v_cvt_f16_i16_e64 v5.l, ttmp15          ; encoding: [0x05,0x00,0xd1,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, m0
// GFX12: v_cvt_f16_i16_e64 v5.l, m0              ; encoding: [0x05,0x00,0xd1,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, exec_lo
// GFX12: v_cvt_f16_i16_e64 v5.l, exec_lo         ; encoding: [0x05,0x00,0xd1,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, exec_hi
// GFX12: v_cvt_f16_i16_e64 v5.l, exec_hi         ; encoding: [0x05,0x00,0xd1,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, null
// GFX12: v_cvt_f16_i16_e64 v5.l, null            ; encoding: [0x05,0x00,0xd1,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, -1
// GFX12: v_cvt_f16_i16_e64 v5.l, -1              ; encoding: [0x05,0x00,0xd1,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, 0.5 mul:2
// GFX12: v_cvt_f16_i16_e64 v5.l, 0.5 mul:2       ; encoding: [0x05,0x00,0xd1,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f16_i16_e64 v5.l, src_scc mul:4
// GFX12: v_cvt_f16_i16_e64 v5.l, src_scc mul:4   ; encoding: [0x05,0x00,0xd1,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f16_i16_e64 v255.l, 0xfe0b clamp div:2
// GFX12: v_cvt_f16_i16_e64 v255.l, 0xfe0b clamp div:2 ; encoding: [0xff,0x80,0xd1,0xd5,0xff,0x00,0x00,0x18,0x0b,0xfe,0x00,0x00]

v_cvt_f16_i16_e64 v5.h, v1.h
// GFX12: v_cvt_f16_i16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xd1,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v5.l, v255.h
// GFX12: v_cvt_f16_i16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xd1,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_i16_e64 v255.h, 0xfe0b clamp div:2
// GFX12: v_cvt_f16_i16_e64 v255.h, 0xfe0b op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc0,0xd1,0xd5,0xff,0x00,0x00,0x18,0x0b,0xfe,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, v1.l
// GFX12: v_cvt_f16_u16_e64 v5.l, v1.l            ; encoding: [0x05,0x00,0xd0,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, v255.l
// GFX12: v_cvt_f16_u16_e64 v5.l, v255.l          ; encoding: [0x05,0x00,0xd0,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, s1
// GFX12: v_cvt_f16_u16_e64 v5.l, s1              ; encoding: [0x05,0x00,0xd0,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, s105
// GFX12: v_cvt_f16_u16_e64 v5.l, s105            ; encoding: [0x05,0x00,0xd0,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, vcc_lo
// GFX12: v_cvt_f16_u16_e64 v5.l, vcc_lo          ; encoding: [0x05,0x00,0xd0,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, vcc_hi
// GFX12: v_cvt_f16_u16_e64 v5.l, vcc_hi          ; encoding: [0x05,0x00,0xd0,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, ttmp15
// GFX12: v_cvt_f16_u16_e64 v5.l, ttmp15          ; encoding: [0x05,0x00,0xd0,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, m0
// GFX12: v_cvt_f16_u16_e64 v5.l, m0              ; encoding: [0x05,0x00,0xd0,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, exec_lo
// GFX12: v_cvt_f16_u16_e64 v5.l, exec_lo         ; encoding: [0x05,0x00,0xd0,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, exec_hi
// GFX12: v_cvt_f16_u16_e64 v5.l, exec_hi         ; encoding: [0x05,0x00,0xd0,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, null
// GFX12: v_cvt_f16_u16_e64 v5.l, null            ; encoding: [0x05,0x00,0xd0,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, -1
// GFX12: v_cvt_f16_u16_e64 v5.l, -1              ; encoding: [0x05,0x00,0xd0,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, 0.5 mul:2
// GFX12: v_cvt_f16_u16_e64 v5.l, 0.5 mul:2       ; encoding: [0x05,0x00,0xd0,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f16_u16_e64 v5.l, src_scc mul:4
// GFX12: v_cvt_f16_u16_e64 v5.l, src_scc mul:4   ; encoding: [0x05,0x00,0xd0,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f16_u16_e64 v255.l, 0xfe0b clamp div:2
// GFX12: v_cvt_f16_u16_e64 v255.l, 0xfe0b clamp div:2 ; encoding: [0xff,0x80,0xd0,0xd5,0xff,0x00,0x00,0x18,0x0b,0xfe,0x00,0x00]

v_cvt_f16_u16_e64 v5.h, v1.h
// GFX12: v_cvt_f16_u16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xd0,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v5.l, v255.h
// GFX12: v_cvt_f16_u16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xd0,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f16_u16_e64 v255.h, 0xfe0b clamp div:2
// GFX12: v_cvt_f16_u16_e64 v255.h, 0xfe0b op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc0,0xd0,0xd5,0xff,0x00,0x00,0x18,0x0b,0xfe,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1.l
// GFX12: v_cvt_f32_f16_e64 v5, v1.l              ; encoding: [0x05,0x00,0x8b,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v255.l
// GFX12: v_cvt_f32_f16_e64 v5, v255.l            ; encoding: [0x05,0x00,0x8b,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, s1
// GFX12: v_cvt_f32_f16_e64 v5, s1                ; encoding: [0x05,0x00,0x8b,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, s105
// GFX12: v_cvt_f32_f16_e64 v5, s105              ; encoding: [0x05,0x00,0x8b,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_lo
// GFX12: v_cvt_f32_f16_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0x8b,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_hi
// GFX12: v_cvt_f32_f16_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0x8b,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, ttmp15
// GFX12: v_cvt_f32_f16_e64 v5, ttmp15            ; encoding: [0x05,0x00,0x8b,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, m0
// GFX12: v_cvt_f32_f16_e64 v5, m0                ; encoding: [0x05,0x00,0x8b,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_lo
// GFX12: v_cvt_f32_f16_e64 v5, exec_lo           ; encoding: [0x05,0x00,0x8b,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_hi
// GFX12: v_cvt_f32_f16_e64 v5, exec_hi           ; encoding: [0x05,0x00,0x8b,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, null
// GFX12: v_cvt_f32_f16_e64 v5, null              ; encoding: [0x05,0x00,0x8b,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, -1
// GFX12: v_cvt_f32_f16_e64 v5, -1                ; encoding: [0x05,0x00,0x8b,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_f16_e64 v5, 0.5 mul:2         ; encoding: [0x05,0x00,0x8b,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_f16_e64 v5, src_scc mul:4
// GFX12: v_cvt_f32_f16_e64 v5, src_scc mul:4     ; encoding: [0x05,0x00,0x8b,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f32_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_cvt_f32_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0x8b,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_cvt_f32_f16_e64 v5, v255.h
// GFX12: v_cvt_f32_f16_e64 v5, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0x8b,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2]
// GFX12: v_cvt_f32_f64_e64 v5, v[1:2]            ; encoding: [0x05,0x00,0x8f,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[254:255]
// GFX12: v_cvt_f32_f64_e64 v5, v[254:255]        ; encoding: [0x05,0x00,0x8f,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[2:3]
// GFX12: v_cvt_f32_f64_e64 v5, s[2:3]            ; encoding: [0x05,0x00,0x8f,0xd5,0x02,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[104:105]
// GFX12: v_cvt_f32_f64_e64 v5, s[104:105]        ; encoding: [0x05,0x00,0x8f,0xd5,0x68,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, vcc
// GFX12: v_cvt_f32_f64_e64 v5, vcc               ; encoding: [0x05,0x00,0x8f,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, ttmp[14:15]
// GFX12: v_cvt_f32_f64_e64 v5, ttmp[14:15]       ; encoding: [0x05,0x00,0x8f,0xd5,0x7a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, exec
// GFX12: v_cvt_f32_f64_e64 v5, exec              ; encoding: [0x05,0x00,0x8f,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, null
// GFX12: v_cvt_f32_f64_e64 v5, null              ; encoding: [0x05,0x00,0x8f,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -1
// GFX12: v_cvt_f32_f64_e64 v5, -1                ; encoding: [0x05,0x00,0x8f,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_f64_e64 v5, 0.5 mul:2         ; encoding: [0x05,0x00,0x8f,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_f64_e64 v5, -|src_scc| mul:4
// GFX12: v_cvt_f32_f64_e64 v5, -|src_scc| mul:4  ; encoding: [0x05,0x01,0x8f,0xd5,0xfd,0x00,0x00,0x30]

v_cvt_f32_f64_e64 v255, 0xaf123456 clamp div:2
// GFX12: v_cvt_f32_f64_e64 v255, 0xaf123456 clamp div:2 ; encoding: [0xff,0x80,0x8f,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f32_i32_e64 v5, v1
// GFX12: v_cvt_f32_i32_e64 v5, v1                ; encoding: [0x05,0x00,0x85,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v255
// GFX12: v_cvt_f32_i32_e64 v5, v255              ; encoding: [0x05,0x00,0x85,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, s1
// GFX12: v_cvt_f32_i32_e64 v5, s1                ; encoding: [0x05,0x00,0x85,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, s105
// GFX12: v_cvt_f32_i32_e64 v5, s105              ; encoding: [0x05,0x00,0x85,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_lo
// GFX12: v_cvt_f32_i32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0x85,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_hi
// GFX12: v_cvt_f32_i32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0x85,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, ttmp15
// GFX12: v_cvt_f32_i32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0x85,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, m0
// GFX12: v_cvt_f32_i32_e64 v5, m0                ; encoding: [0x05,0x00,0x85,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_lo
// GFX12: v_cvt_f32_i32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0x85,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_hi
// GFX12: v_cvt_f32_i32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0x85,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, null
// GFX12: v_cvt_f32_i32_e64 v5, null              ; encoding: [0x05,0x00,0x85,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -1
// GFX12: v_cvt_f32_i32_e64 v5, -1                ; encoding: [0x05,0x00,0x85,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_i32_e64 v5, 0.5 mul:2         ; encoding: [0x05,0x00,0x85,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_i32_e64 v5, src_scc mul:4
// GFX12: v_cvt_f32_i32_e64 v5, src_scc mul:4     ; encoding: [0x05,0x00,0x85,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f32_i32_e64 v255, 0xaf123456 clamp div:2
// GFX12: v_cvt_f32_i32_e64 v255, 0xaf123456 clamp div:2 ; encoding: [0xff,0x80,0x85,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f32_u32_e64 v5, v1
// GFX12: v_cvt_f32_u32_e64 v5, v1                ; encoding: [0x05,0x00,0x86,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v255
// GFX12: v_cvt_f32_u32_e64 v5, v255              ; encoding: [0x05,0x00,0x86,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, s1
// GFX12: v_cvt_f32_u32_e64 v5, s1                ; encoding: [0x05,0x00,0x86,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, s105
// GFX12: v_cvt_f32_u32_e64 v5, s105              ; encoding: [0x05,0x00,0x86,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_lo
// GFX12: v_cvt_f32_u32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0x86,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_hi
// GFX12: v_cvt_f32_u32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0x86,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, ttmp15
// GFX12: v_cvt_f32_u32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0x86,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, m0
// GFX12: v_cvt_f32_u32_e64 v5, m0                ; encoding: [0x05,0x00,0x86,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_lo
// GFX12: v_cvt_f32_u32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0x86,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_hi
// GFX12: v_cvt_f32_u32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0x86,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, null
// GFX12: v_cvt_f32_u32_e64 v5, null              ; encoding: [0x05,0x00,0x86,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -1
// GFX12: v_cvt_f32_u32_e64 v5, -1                ; encoding: [0x05,0x00,0x86,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_u32_e64 v5, 0.5 mul:2         ; encoding: [0x05,0x00,0x86,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_u32_e64 v5, src_scc mul:4
// GFX12: v_cvt_f32_u32_e64 v5, src_scc mul:4     ; encoding: [0x05,0x00,0x86,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f32_u32_e64 v255, 0xaf123456 clamp div:2
// GFX12: v_cvt_f32_u32_e64 v255, 0xaf123456 clamp div:2 ; encoding: [0xff,0x80,0x86,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte0_e64 v5, v1
// GFX12: v_cvt_f32_ubyte0_e64 v5, v1             ; encoding: [0x05,0x00,0x91,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v255
// GFX12: v_cvt_f32_ubyte0_e64 v5, v255           ; encoding: [0x05,0x00,0x91,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s1
// GFX12: v_cvt_f32_ubyte0_e64 v5, s1             ; encoding: [0x05,0x00,0x91,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s105
// GFX12: v_cvt_f32_ubyte0_e64 v5, s105           ; encoding: [0x05,0x00,0x91,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_lo
// GFX12: v_cvt_f32_ubyte0_e64 v5, vcc_lo         ; encoding: [0x05,0x00,0x91,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_hi
// GFX12: v_cvt_f32_ubyte0_e64 v5, vcc_hi         ; encoding: [0x05,0x00,0x91,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, ttmp15
// GFX12: v_cvt_f32_ubyte0_e64 v5, ttmp15         ; encoding: [0x05,0x00,0x91,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, m0
// GFX12: v_cvt_f32_ubyte0_e64 v5, m0             ; encoding: [0x05,0x00,0x91,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_lo
// GFX12: v_cvt_f32_ubyte0_e64 v5, exec_lo        ; encoding: [0x05,0x00,0x91,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_hi
// GFX12: v_cvt_f32_ubyte0_e64 v5, exec_hi        ; encoding: [0x05,0x00,0x91,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, null
// GFX12: v_cvt_f32_ubyte0_e64 v5, null           ; encoding: [0x05,0x00,0x91,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -1
// GFX12: v_cvt_f32_ubyte0_e64 v5, -1             ; encoding: [0x05,0x00,0x91,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_ubyte0_e64 v5, 0.5 mul:2      ; encoding: [0x05,0x00,0x91,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_ubyte0_e64 v5, src_scc mul:4
// GFX12: v_cvt_f32_ubyte0_e64 v5, src_scc mul:4  ; encoding: [0x05,0x00,0x91,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f32_ubyte0_e64 v255, 0xaf123456 clamp div:2
// GFX12: v_cvt_f32_ubyte0_e64 v255, 0xaf123456 clamp div:2 ; encoding: [0xff,0x80,0x91,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte1_e64 v5, v1
// GFX12: v_cvt_f32_ubyte1_e64 v5, v1             ; encoding: [0x05,0x00,0x92,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v255
// GFX12: v_cvt_f32_ubyte1_e64 v5, v255           ; encoding: [0x05,0x00,0x92,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s1
// GFX12: v_cvt_f32_ubyte1_e64 v5, s1             ; encoding: [0x05,0x00,0x92,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s105
// GFX12: v_cvt_f32_ubyte1_e64 v5, s105           ; encoding: [0x05,0x00,0x92,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_lo
// GFX12: v_cvt_f32_ubyte1_e64 v5, vcc_lo         ; encoding: [0x05,0x00,0x92,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_hi
// GFX12: v_cvt_f32_ubyte1_e64 v5, vcc_hi         ; encoding: [0x05,0x00,0x92,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, ttmp15
// GFX12: v_cvt_f32_ubyte1_e64 v5, ttmp15         ; encoding: [0x05,0x00,0x92,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, m0
// GFX12: v_cvt_f32_ubyte1_e64 v5, m0             ; encoding: [0x05,0x00,0x92,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_lo
// GFX12: v_cvt_f32_ubyte1_e64 v5, exec_lo        ; encoding: [0x05,0x00,0x92,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_hi
// GFX12: v_cvt_f32_ubyte1_e64 v5, exec_hi        ; encoding: [0x05,0x00,0x92,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, null
// GFX12: v_cvt_f32_ubyte1_e64 v5, null           ; encoding: [0x05,0x00,0x92,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -1
// GFX12: v_cvt_f32_ubyte1_e64 v5, -1             ; encoding: [0x05,0x00,0x92,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_ubyte1_e64 v5, 0.5 mul:2      ; encoding: [0x05,0x00,0x92,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_ubyte1_e64 v5, src_scc mul:4
// GFX12: v_cvt_f32_ubyte1_e64 v5, src_scc mul:4  ; encoding: [0x05,0x00,0x92,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f32_ubyte1_e64 v255, 0xaf123456 clamp div:2
// GFX12: v_cvt_f32_ubyte1_e64 v255, 0xaf123456 clamp div:2 ; encoding: [0xff,0x80,0x92,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte2_e64 v5, v1
// GFX12: v_cvt_f32_ubyte2_e64 v5, v1             ; encoding: [0x05,0x00,0x93,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v255
// GFX12: v_cvt_f32_ubyte2_e64 v5, v255           ; encoding: [0x05,0x00,0x93,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s1
// GFX12: v_cvt_f32_ubyte2_e64 v5, s1             ; encoding: [0x05,0x00,0x93,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s105
// GFX12: v_cvt_f32_ubyte2_e64 v5, s105           ; encoding: [0x05,0x00,0x93,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_lo
// GFX12: v_cvt_f32_ubyte2_e64 v5, vcc_lo         ; encoding: [0x05,0x00,0x93,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_hi
// GFX12: v_cvt_f32_ubyte2_e64 v5, vcc_hi         ; encoding: [0x05,0x00,0x93,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, ttmp15
// GFX12: v_cvt_f32_ubyte2_e64 v5, ttmp15         ; encoding: [0x05,0x00,0x93,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, m0
// GFX12: v_cvt_f32_ubyte2_e64 v5, m0             ; encoding: [0x05,0x00,0x93,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_lo
// GFX12: v_cvt_f32_ubyte2_e64 v5, exec_lo        ; encoding: [0x05,0x00,0x93,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_hi
// GFX12: v_cvt_f32_ubyte2_e64 v5, exec_hi        ; encoding: [0x05,0x00,0x93,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, null
// GFX12: v_cvt_f32_ubyte2_e64 v5, null           ; encoding: [0x05,0x00,0x93,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -1
// GFX12: v_cvt_f32_ubyte2_e64 v5, -1             ; encoding: [0x05,0x00,0x93,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_ubyte2_e64 v5, 0.5 mul:2      ; encoding: [0x05,0x00,0x93,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_ubyte2_e64 v5, src_scc mul:4
// GFX12: v_cvt_f32_ubyte2_e64 v5, src_scc mul:4  ; encoding: [0x05,0x00,0x93,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f32_ubyte2_e64 v255, 0xaf123456 clamp div:2
// GFX12: v_cvt_f32_ubyte2_e64 v255, 0xaf123456 clamp div:2 ; encoding: [0xff,0x80,0x93,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte3_e64 v5, v1
// GFX12: v_cvt_f32_ubyte3_e64 v5, v1             ; encoding: [0x05,0x00,0x94,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v255
// GFX12: v_cvt_f32_ubyte3_e64 v5, v255           ; encoding: [0x05,0x00,0x94,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s1
// GFX12: v_cvt_f32_ubyte3_e64 v5, s1             ; encoding: [0x05,0x00,0x94,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s105
// GFX12: v_cvt_f32_ubyte3_e64 v5, s105           ; encoding: [0x05,0x00,0x94,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_lo
// GFX12: v_cvt_f32_ubyte3_e64 v5, vcc_lo         ; encoding: [0x05,0x00,0x94,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_hi
// GFX12: v_cvt_f32_ubyte3_e64 v5, vcc_hi         ; encoding: [0x05,0x00,0x94,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, ttmp15
// GFX12: v_cvt_f32_ubyte3_e64 v5, ttmp15         ; encoding: [0x05,0x00,0x94,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, m0
// GFX12: v_cvt_f32_ubyte3_e64 v5, m0             ; encoding: [0x05,0x00,0x94,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_lo
// GFX12: v_cvt_f32_ubyte3_e64 v5, exec_lo        ; encoding: [0x05,0x00,0x94,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_hi
// GFX12: v_cvt_f32_ubyte3_e64 v5, exec_hi        ; encoding: [0x05,0x00,0x94,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, null
// GFX12: v_cvt_f32_ubyte3_e64 v5, null           ; encoding: [0x05,0x00,0x94,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -1
// GFX12: v_cvt_f32_ubyte3_e64 v5, -1             ; encoding: [0x05,0x00,0x94,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0.5 mul:2
// GFX12: v_cvt_f32_ubyte3_e64 v5, 0.5 mul:2      ; encoding: [0x05,0x00,0x94,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f32_ubyte3_e64 v5, src_scc mul:4
// GFX12: v_cvt_f32_ubyte3_e64 v5, src_scc mul:4  ; encoding: [0x05,0x00,0x94,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f32_ubyte3_e64 v255, 0xaf123456 clamp div:2
// GFX12: v_cvt_f32_ubyte3_e64 v255, 0xaf123456 clamp div:2 ; encoding: [0xff,0x80,0x94,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f64_f32_e64 v[5:6], v1
// GFX12: v_cvt_f64_f32_e64 v[5:6], v1            ; encoding: [0x05,0x00,0x90,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v255
// GFX12: v_cvt_f64_f32_e64 v[5:6], v255          ; encoding: [0x05,0x00,0x90,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s1
// GFX12: v_cvt_f64_f32_e64 v[5:6], s1            ; encoding: [0x05,0x00,0x90,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s105
// GFX12: v_cvt_f64_f32_e64 v[5:6], s105          ; encoding: [0x05,0x00,0x90,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_lo
// GFX12: v_cvt_f64_f32_e64 v[5:6], vcc_lo        ; encoding: [0x05,0x00,0x90,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_hi
// GFX12: v_cvt_f64_f32_e64 v[5:6], vcc_hi        ; encoding: [0x05,0x00,0x90,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], ttmp15
// GFX12: v_cvt_f64_f32_e64 v[5:6], ttmp15        ; encoding: [0x05,0x00,0x90,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], m0
// GFX12: v_cvt_f64_f32_e64 v[5:6], m0            ; encoding: [0x05,0x00,0x90,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_lo
// GFX12: v_cvt_f64_f32_e64 v[5:6], exec_lo       ; encoding: [0x05,0x00,0x90,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_hi
// GFX12: v_cvt_f64_f32_e64 v[5:6], exec_hi       ; encoding: [0x05,0x00,0x90,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], null
// GFX12: v_cvt_f64_f32_e64 v[5:6], null          ; encoding: [0x05,0x00,0x90,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -1
// GFX12: v_cvt_f64_f32_e64 v[5:6], -1            ; encoding: [0x05,0x00,0x90,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0.5 mul:2
// GFX12: v_cvt_f64_f32_e64 v[5:6], 0.5 mul:2     ; encoding: [0x05,0x00,0x90,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f64_f32_e64 v[5:6], src_scc mul:4
// GFX12: v_cvt_f64_f32_e64 v[5:6], src_scc mul:4 ; encoding: [0x05,0x00,0x90,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f64_f32_e64 v[254:255], -|0xaf123456| clamp div:2
// GFX12: v_cvt_f64_f32_e64 v[254:255], -|0xaf123456| clamp div:2 ; encoding: [0xfe,0x81,0x90,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_cvt_f64_i32_e64 v[5:6], v1
// GFX12: v_cvt_f64_i32_e64 v[5:6], v1            ; encoding: [0x05,0x00,0x84,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v255
// GFX12: v_cvt_f64_i32_e64 v[5:6], v255          ; encoding: [0x05,0x00,0x84,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s1
// GFX12: v_cvt_f64_i32_e64 v[5:6], s1            ; encoding: [0x05,0x00,0x84,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s105
// GFX12: v_cvt_f64_i32_e64 v[5:6], s105          ; encoding: [0x05,0x00,0x84,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_lo
// GFX12: v_cvt_f64_i32_e64 v[5:6], vcc_lo        ; encoding: [0x05,0x00,0x84,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_hi
// GFX12: v_cvt_f64_i32_e64 v[5:6], vcc_hi        ; encoding: [0x05,0x00,0x84,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], ttmp15
// GFX12: v_cvt_f64_i32_e64 v[5:6], ttmp15        ; encoding: [0x05,0x00,0x84,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], m0
// GFX12: v_cvt_f64_i32_e64 v[5:6], m0            ; encoding: [0x05,0x00,0x84,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_lo
// GFX12: v_cvt_f64_i32_e64 v[5:6], exec_lo       ; encoding: [0x05,0x00,0x84,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_hi
// GFX12: v_cvt_f64_i32_e64 v[5:6], exec_hi       ; encoding: [0x05,0x00,0x84,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], null
// GFX12: v_cvt_f64_i32_e64 v[5:6], null          ; encoding: [0x05,0x00,0x84,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -1
// GFX12: v_cvt_f64_i32_e64 v[5:6], -1            ; encoding: [0x05,0x00,0x84,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0.5 mul:2
// GFX12: v_cvt_f64_i32_e64 v[5:6], 0.5 mul:2     ; encoding: [0x05,0x00,0x84,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f64_i32_e64 v[5:6], src_scc mul:4
// GFX12: v_cvt_f64_i32_e64 v[5:6], src_scc mul:4 ; encoding: [0x05,0x00,0x84,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f64_i32_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_cvt_f64_i32_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0x84,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_f64_u32_e64 v[5:6], v1
// GFX12: v_cvt_f64_u32_e64 v[5:6], v1            ; encoding: [0x05,0x00,0x96,0xd5,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v255
// GFX12: v_cvt_f64_u32_e64 v[5:6], v255          ; encoding: [0x05,0x00,0x96,0xd5,0xff,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s1
// GFX12: v_cvt_f64_u32_e64 v[5:6], s1            ; encoding: [0x05,0x00,0x96,0xd5,0x01,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s105
// GFX12: v_cvt_f64_u32_e64 v[5:6], s105          ; encoding: [0x05,0x00,0x96,0xd5,0x69,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_lo
// GFX12: v_cvt_f64_u32_e64 v[5:6], vcc_lo        ; encoding: [0x05,0x00,0x96,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_hi
// GFX12: v_cvt_f64_u32_e64 v[5:6], vcc_hi        ; encoding: [0x05,0x00,0x96,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], ttmp15
// GFX12: v_cvt_f64_u32_e64 v[5:6], ttmp15        ; encoding: [0x05,0x00,0x96,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], m0
// GFX12: v_cvt_f64_u32_e64 v[5:6], m0            ; encoding: [0x05,0x00,0x96,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_lo
// GFX12: v_cvt_f64_u32_e64 v[5:6], exec_lo       ; encoding: [0x05,0x00,0x96,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_hi
// GFX12: v_cvt_f64_u32_e64 v[5:6], exec_hi       ; encoding: [0x05,0x00,0x96,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], null
// GFX12: v_cvt_f64_u32_e64 v[5:6], null          ; encoding: [0x05,0x00,0x96,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -1
// GFX12: v_cvt_f64_u32_e64 v[5:6], -1            ; encoding: [0x05,0x00,0x96,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0.5 mul:2
// GFX12: v_cvt_f64_u32_e64 v[5:6], 0.5 mul:2     ; encoding: [0x05,0x00,0x96,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_f64_u32_e64 v[5:6], src_scc mul:4
// GFX12: v_cvt_f64_u32_e64 v[5:6], src_scc mul:4 ; encoding: [0x05,0x00,0x96,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_f64_u32_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_cvt_f64_u32_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0x96,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_cvt_floor_i32_f32_e64 v5, v1
// GFX12: v_cvt_floor_i32_f32_e64 v5, v1          ; encoding: [0x05,0x00,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, v255
// GFX12: v_cvt_floor_i32_f32_e64 v5, v255        ; encoding: [0x05,0x00,0x8d,0xd5,0xff,0x01,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, s1
// GFX12: v_cvt_floor_i32_f32_e64 v5, s1          ; encoding: [0x05,0x00,0x8d,0xd5,0x01,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, s105
// GFX12: v_cvt_floor_i32_f32_e64 v5, s105        ; encoding: [0x05,0x00,0x8d,0xd5,0x69,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, vcc_lo
// GFX12: v_cvt_floor_i32_f32_e64 v5, vcc_lo      ; encoding: [0x05,0x00,0x8d,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, vcc_hi
// GFX12: v_cvt_floor_i32_f32_e64 v5, vcc_hi      ; encoding: [0x05,0x00,0x8d,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, ttmp15
// GFX12: v_cvt_floor_i32_f32_e64 v5, ttmp15      ; encoding: [0x05,0x00,0x8d,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, m0
// GFX12: v_cvt_floor_i32_f32_e64 v5, m0          ; encoding: [0x05,0x00,0x8d,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, exec_lo
// GFX12: v_cvt_floor_i32_f32_e64 v5, exec_lo     ; encoding: [0x05,0x00,0x8d,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, exec_hi
// GFX12: v_cvt_floor_i32_f32_e64 v5, exec_hi     ; encoding: [0x05,0x00,0x8d,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, null
// GFX12: v_cvt_floor_i32_f32_e64 v5, null        ; encoding: [0x05,0x00,0x8d,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, -1
// GFX12: v_cvt_floor_i32_f32_e64 v5, -1          ; encoding: [0x05,0x00,0x8d,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, 0.5
// GFX12: v_cvt_floor_i32_f32_e64 v5, 0.5         ; encoding: [0x05,0x00,0x8d,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v5, src_scc
// GFX12: v_cvt_floor_i32_f32_e64 v5, src_scc     ; encoding: [0x05,0x00,0x8d,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_floor_i32_f32_e64 v255, -|0xaf123456|
// GFX12: v_cvt_floor_i32_f32_e64 v255, -|0xaf123456| ; encoding: [0xff,0x01,0x8d,0xd5,0xff,0x00,0x00,0x20,0x56,0x34,0x12,0xaf]

v_cvt_flr_i32_f32_e64 v5, v1
// GFX12: v_cvt_floor_i32_f32_e64 v5, v1          ; encoding: [0x05,0x00,0x8d,0xd5,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v255
// GFX12: v_cvt_floor_i32_f32_e64 v5, v255        ; encoding: [0x05,0x00,0x8d,0xd5,0xff,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s1
// GFX12: v_cvt_floor_i32_f32_e64 v5, s1          ; encoding: [0x05,0x00,0x8d,0xd5,0x01,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s105
// GFX12: v_cvt_floor_i32_f32_e64 v5, s105        ; encoding: [0x05,0x00,0x8d,0xd5,0x69,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_lo
// GFX12: v_cvt_floor_i32_f32_e64 v5, vcc_lo      ; encoding: [0x05,0x00,0x8d,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_hi
// GFX12: v_cvt_floor_i32_f32_e64 v5, vcc_hi      ; encoding: [0x05,0x00,0x8d,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, ttmp15
// GFX12: v_cvt_floor_i32_f32_e64 v5, ttmp15      ; encoding: [0x05,0x00,0x8d,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, m0
// GFX12: v_cvt_floor_i32_f32_e64 v5, m0          ; encoding: [0x05,0x00,0x8d,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_lo
// GFX12: v_cvt_floor_i32_f32_e64 v5, exec_lo     ; encoding: [0x05,0x00,0x8d,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_hi
// GFX12: v_cvt_floor_i32_f32_e64 v5, exec_hi     ; encoding: [0x05,0x00,0x8d,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, null
// GFX12: v_cvt_floor_i32_f32_e64 v5, null        ; encoding: [0x05,0x00,0x8d,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -1
// GFX12: v_cvt_floor_i32_f32_e64 v5, -1          ; encoding: [0x05,0x00,0x8d,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0.5
// GFX12: v_cvt_floor_i32_f32_e64 v5, 0.5         ; encoding: [0x05,0x00,0x8d,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, src_scc
// GFX12: v_cvt_floor_i32_f32_e64 v5, src_scc     ; encoding: [0x05,0x00,0x8d,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v255, -|0xaf123456|
// GFX12: v_cvt_floor_i32_f32_e64 v255, -|0xaf123456| ; encoding: [0xff,0x01,0x8d,0xd5,0xff,0x00,0x00,0x20,0x56,0x34,0x12,0xaf]

v_cvt_i16_f16_e64 v5.l, v1.l
// GFX12: v_cvt_i16_f16_e64 v5.l, v1.l            ; encoding: [0x05,0x00,0xd3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, v255.l
// GFX12: v_cvt_i16_f16_e64 v5.l, v255.l          ; encoding: [0x05,0x00,0xd3,0xd5,0xff,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, s1
// GFX12: v_cvt_i16_f16_e64 v5.l, s1              ; encoding: [0x05,0x00,0xd3,0xd5,0x01,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, s105
// GFX12: v_cvt_i16_f16_e64 v5.l, s105            ; encoding: [0x05,0x00,0xd3,0xd5,0x69,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, vcc_lo
// GFX12: v_cvt_i16_f16_e64 v5.l, vcc_lo          ; encoding: [0x05,0x00,0xd3,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, vcc_hi
// GFX12: v_cvt_i16_f16_e64 v5.l, vcc_hi          ; encoding: [0x05,0x00,0xd3,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, ttmp15
// GFX12: v_cvt_i16_f16_e64 v5.l, ttmp15          ; encoding: [0x05,0x00,0xd3,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, m0
// GFX12: v_cvt_i16_f16_e64 v5.l, m0              ; encoding: [0x05,0x00,0xd3,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, exec_lo
// GFX12: v_cvt_i16_f16_e64 v5.l, exec_lo         ; encoding: [0x05,0x00,0xd3,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, exec_hi
// GFX12: v_cvt_i16_f16_e64 v5.l, exec_hi         ; encoding: [0x05,0x00,0xd3,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, null
// GFX12: v_cvt_i16_f16_e64 v5.l, null            ; encoding: [0x05,0x00,0xd3,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, -1
// GFX12: v_cvt_i16_f16_e64 v5.l, -1              ; encoding: [0x05,0x00,0xd3,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, 0.5
// GFX12: v_cvt_i16_f16_e64 v5.l, 0.5             ; encoding: [0x05,0x00,0xd3,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, src_scc
// GFX12: v_cvt_i16_f16_e64 v5.l, src_scc         ; encoding: [0x05,0x00,0xd3,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_i16_f16_e64 v255.l, -|0xfe0b| clamp
// GFX12: v_cvt_i16_f16_e64 v255.l, -|0xfe0b| clamp ; encoding: [0xff,0x81,0xd3,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_i16_f16_e64 v5.h, v1.h
// GFX12: v_cvt_i16_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xd3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v5.l, v255.h
// GFX12: v_cvt_i16_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xd3,0xd5,0xff,0x01,0x00,0x00]

v_cvt_i16_f16_e64 v255.h, -|0xfe0b| clamp
// GFX12: v_cvt_i16_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp ; encoding: [0xff,0xc1,0xd3,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_i32_f32_e64 v5, v1
// GFX12: v_cvt_i32_f32_e64 v5, v1                ; encoding: [0x05,0x00,0x88,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v255
// GFX12: v_cvt_i32_f32_e64 v5, v255              ; encoding: [0x05,0x00,0x88,0xd5,0xff,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, s1
// GFX12: v_cvt_i32_f32_e64 v5, s1                ; encoding: [0x05,0x00,0x88,0xd5,0x01,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, s105
// GFX12: v_cvt_i32_f32_e64 v5, s105              ; encoding: [0x05,0x00,0x88,0xd5,0x69,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_lo
// GFX12: v_cvt_i32_f32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0x88,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_hi
// GFX12: v_cvt_i32_f32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0x88,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, ttmp15
// GFX12: v_cvt_i32_f32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0x88,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, m0
// GFX12: v_cvt_i32_f32_e64 v5, m0                ; encoding: [0x05,0x00,0x88,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_lo
// GFX12: v_cvt_i32_f32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0x88,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_hi
// GFX12: v_cvt_i32_f32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0x88,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, null
// GFX12: v_cvt_i32_f32_e64 v5, null              ; encoding: [0x05,0x00,0x88,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -1
// GFX12: v_cvt_i32_f32_e64 v5, -1                ; encoding: [0x05,0x00,0x88,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0.5
// GFX12: v_cvt_i32_f32_e64 v5, 0.5               ; encoding: [0x05,0x00,0x88,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, src_scc
// GFX12: v_cvt_i32_f32_e64 v5, src_scc           ; encoding: [0x05,0x00,0x88,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v255, -|0xaf123456| clamp
// GFX12: v_cvt_i32_f32_e64 v255, -|0xaf123456| clamp ; encoding: [0xff,0x81,0x88,0xd5,0xff,0x00,0x00,0x20,0x56,0x34,0x12,0xaf]

v_cvt_i32_f64_e64 v5, v[1:2]
// GFX12: v_cvt_i32_f64_e64 v5, v[1:2]            ; encoding: [0x05,0x00,0x83,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[254:255]
// GFX12: v_cvt_i32_f64_e64 v5, v[254:255]        ; encoding: [0x05,0x00,0x83,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[2:3]
// GFX12: v_cvt_i32_f64_e64 v5, s[2:3]            ; encoding: [0x05,0x00,0x83,0xd5,0x02,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[104:105]
// GFX12: v_cvt_i32_f64_e64 v5, s[104:105]        ; encoding: [0x05,0x00,0x83,0xd5,0x68,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, vcc
// GFX12: v_cvt_i32_f64_e64 v5, vcc               ; encoding: [0x05,0x00,0x83,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, ttmp[14:15]
// GFX12: v_cvt_i32_f64_e64 v5, ttmp[14:15]       ; encoding: [0x05,0x00,0x83,0xd5,0x7a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, exec
// GFX12: v_cvt_i32_f64_e64 v5, exec              ; encoding: [0x05,0x00,0x83,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, null
// GFX12: v_cvt_i32_f64_e64 v5, null              ; encoding: [0x05,0x00,0x83,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -1
// GFX12: v_cvt_i32_f64_e64 v5, -1                ; encoding: [0x05,0x00,0x83,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0.5
// GFX12: v_cvt_i32_f64_e64 v5, 0.5               ; encoding: [0x05,0x00,0x83,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -|src_scc|
// GFX12: v_cvt_i32_f64_e64 v5, -|src_scc|        ; encoding: [0x05,0x01,0x83,0xd5,0xfd,0x00,0x00,0x20]

v_cvt_i32_f64_e64 v255, 0xaf123456 clamp
// GFX12: v_cvt_i32_f64_e64 v255, 0xaf123456 clamp ; encoding: [0xff,0x80,0x83,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cvt_i32_i16_e64 v5, v1.l
// GFX12: v_cvt_i32_i16_e64 v5, v1.l              ; encoding: [0x05,0x00,0xea,0xd5,0x01,0x01,0x00,0x00]

v_cvt_i32_i16_e64 v5, v255.l
// GFX12: v_cvt_i32_i16_e64 v5, v255.l            ; encoding: [0x05,0x00,0xea,0xd5,0xff,0x01,0x00,0x00]

v_cvt_i32_i16_e64 v5, s1
// GFX12: v_cvt_i32_i16_e64 v5, s1                ; encoding: [0x05,0x00,0xea,0xd5,0x01,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, s105
// GFX12: v_cvt_i32_i16_e64 v5, s105              ; encoding: [0x05,0x00,0xea,0xd5,0x69,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, vcc_lo
// GFX12: v_cvt_i32_i16_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0xea,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, vcc_hi
// GFX12: v_cvt_i32_i16_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0xea,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, ttmp15
// GFX12: v_cvt_i32_i16_e64 v5, ttmp15            ; encoding: [0x05,0x00,0xea,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, m0
// GFX12: v_cvt_i32_i16_e64 v5, m0                ; encoding: [0x05,0x00,0xea,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, exec_lo
// GFX12: v_cvt_i32_i16_e64 v5, exec_lo           ; encoding: [0x05,0x00,0xea,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, exec_hi
// GFX12: v_cvt_i32_i16_e64 v5, exec_hi           ; encoding: [0x05,0x00,0xea,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, null
// GFX12: v_cvt_i32_i16_e64 v5, null              ; encoding: [0x05,0x00,0xea,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, -1
// GFX12: v_cvt_i32_i16_e64 v5, -1                ; encoding: [0x05,0x00,0xea,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, 0.5
// GFX12: v_cvt_i32_i16_e64 v5, 0.5               ; encoding: [0x05,0x00,0xea,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v5, src_scc
// GFX12: v_cvt_i32_i16_e64 v5, src_scc           ; encoding: [0x05,0x00,0xea,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_i32_i16_e64 v255, 0xfe0b
// GFX12: v_cvt_i32_i16_e64 v255, 0xfe0b          ; encoding: [0xff,0x00,0xea,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_i32_i16_e64 v5, v255.h
// GFX12: v_cvt_i32_i16_e64 v5, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xea,0xd5,0xff,0x01,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, v1
// GFX12: v_cvt_nearest_i32_f32_e64 v5, v1        ; encoding: [0x05,0x00,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, v255
// GFX12: v_cvt_nearest_i32_f32_e64 v5, v255      ; encoding: [0x05,0x00,0x8c,0xd5,0xff,0x01,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, s1
// GFX12: v_cvt_nearest_i32_f32_e64 v5, s1        ; encoding: [0x05,0x00,0x8c,0xd5,0x01,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, s105
// GFX12: v_cvt_nearest_i32_f32_e64 v5, s105      ; encoding: [0x05,0x00,0x8c,0xd5,0x69,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, vcc_lo
// GFX12: v_cvt_nearest_i32_f32_e64 v5, vcc_lo    ; encoding: [0x05,0x00,0x8c,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, vcc_hi
// GFX12: v_cvt_nearest_i32_f32_e64 v5, vcc_hi    ; encoding: [0x05,0x00,0x8c,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, ttmp15
// GFX12: v_cvt_nearest_i32_f32_e64 v5, ttmp15    ; encoding: [0x05,0x00,0x8c,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, m0
// GFX12: v_cvt_nearest_i32_f32_e64 v5, m0        ; encoding: [0x05,0x00,0x8c,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, exec_lo
// GFX12: v_cvt_nearest_i32_f32_e64 v5, exec_lo   ; encoding: [0x05,0x00,0x8c,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, exec_hi
// GFX12: v_cvt_nearest_i32_f32_e64 v5, exec_hi   ; encoding: [0x05,0x00,0x8c,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, null
// GFX12: v_cvt_nearest_i32_f32_e64 v5, null      ; encoding: [0x05,0x00,0x8c,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, -1
// GFX12: v_cvt_nearest_i32_f32_e64 v5, -1        ; encoding: [0x05,0x00,0x8c,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, 0.5
// GFX12: v_cvt_nearest_i32_f32_e64 v5, 0.5       ; encoding: [0x05,0x00,0x8c,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v5, src_scc
// GFX12: v_cvt_nearest_i32_f32_e64 v5, src_scc   ; encoding: [0x05,0x00,0x8c,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_nearest_i32_f32_e64 v255, -|0xaf123456|
// GFX12: v_cvt_nearest_i32_f32_e64 v255, -|0xaf123456| ; encoding: [0xff,0x01,0x8c,0xd5,0xff,0x00,0x00,0x20,0x56,0x34,0x12,0xaf]

v_cvt_norm_i16_f16_e64 v5.l, v1.l
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, v1.l       ; encoding: [0x05,0x00,0xe3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, v255.l
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, v255.l     ; encoding: [0x05,0x00,0xe3,0xd5,0xff,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, s1
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, s1         ; encoding: [0x05,0x00,0xe3,0xd5,0x01,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, s105
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, s105       ; encoding: [0x05,0x00,0xe3,0xd5,0x69,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, vcc_lo
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, vcc_lo     ; encoding: [0x05,0x00,0xe3,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, vcc_hi
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, vcc_hi     ; encoding: [0x05,0x00,0xe3,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, ttmp15
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, ttmp15     ; encoding: [0x05,0x00,0xe3,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, m0
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, m0         ; encoding: [0x05,0x00,0xe3,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, exec_lo
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, exec_lo    ; encoding: [0x05,0x00,0xe3,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, exec_hi
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, exec_hi    ; encoding: [0x05,0x00,0xe3,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, null
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, null       ; encoding: [0x05,0x00,0xe3,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, -1
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, -1         ; encoding: [0x05,0x00,0xe3,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, 0.5
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, 0.5        ; encoding: [0x05,0x00,0xe3,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, src_scc
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, src_scc    ; encoding: [0x05,0x00,0xe3,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_norm_i16_f16_e64 v255.l, -|0xfe0b|
// GFX12: v_cvt_norm_i16_f16_e64 v255.l, -|0xfe0b| ; encoding: [0xff,0x01,0xe3,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.h, v1.h
// GFX12: v_cvt_norm_i16_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xe3,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v5.l, v255.h
// GFX12: v_cvt_norm_i16_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xe3,0xd5,0xff,0x01,0x00,0x00]

v_cvt_norm_i16_f16_e64 v255.h, -|0xfe0b|
// GFX12: v_cvt_norm_i16_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] ; encoding: [0xff,0x41,0xe3,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, v1.l
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, v1.l       ; encoding: [0x05,0x00,0xe4,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, v255.l
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, v255.l     ; encoding: [0x05,0x00,0xe4,0xd5,0xff,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, s1
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, s1         ; encoding: [0x05,0x00,0xe4,0xd5,0x01,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, s105
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, s105       ; encoding: [0x05,0x00,0xe4,0xd5,0x69,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, vcc_lo
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, vcc_lo     ; encoding: [0x05,0x00,0xe4,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, vcc_hi
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, vcc_hi     ; encoding: [0x05,0x00,0xe4,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, ttmp15
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, ttmp15     ; encoding: [0x05,0x00,0xe4,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, m0
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, m0         ; encoding: [0x05,0x00,0xe4,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, exec_lo
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, exec_lo    ; encoding: [0x05,0x00,0xe4,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, exec_hi
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, exec_hi    ; encoding: [0x05,0x00,0xe4,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, null
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, null       ; encoding: [0x05,0x00,0xe4,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, -1
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, -1         ; encoding: [0x05,0x00,0xe4,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, 0.5
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, 0.5        ; encoding: [0x05,0x00,0xe4,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, src_scc
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, src_scc    ; encoding: [0x05,0x00,0xe4,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_norm_u16_f16_e64 v255.l, -|0xfe0b|
// GFX12: v_cvt_norm_u16_f16_e64 v255.l, -|0xfe0b| ; encoding: [0xff,0x01,0xe4,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.h, v1.h
// GFX12: v_cvt_norm_u16_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xe4,0xd5,0x01,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v5.l, v255.h
// GFX12: v_cvt_norm_u16_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xe4,0xd5,0xff,0x01,0x00,0x00]

v_cvt_norm_u16_f16_e64 v255.h, -|0xfe0b|
// GFX12: v_cvt_norm_u16_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] ; encoding: [0xff,0x41,0xe4,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1
// GFX12: v_cvt_off_f32_i4_e64 v5, v1             ; encoding: [0x05,0x00,0x8e,0xd5,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v255
// GFX12: v_cvt_off_f32_i4_e64 v5, v255           ; encoding: [0x05,0x00,0x8e,0xd5,0xff,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s1
// GFX12: v_cvt_off_f32_i4_e64 v5, s1             ; encoding: [0x05,0x00,0x8e,0xd5,0x01,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s105
// GFX12: v_cvt_off_f32_i4_e64 v5, s105           ; encoding: [0x05,0x00,0x8e,0xd5,0x69,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_lo
// GFX12: v_cvt_off_f32_i4_e64 v5, vcc_lo         ; encoding: [0x05,0x00,0x8e,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_hi
// GFX12: v_cvt_off_f32_i4_e64 v5, vcc_hi         ; encoding: [0x05,0x00,0x8e,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, ttmp15
// GFX12: v_cvt_off_f32_i4_e64 v5, ttmp15         ; encoding: [0x05,0x00,0x8e,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, m0
// GFX12: v_cvt_off_f32_i4_e64 v5, m0             ; encoding: [0x05,0x00,0x8e,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_lo
// GFX12: v_cvt_off_f32_i4_e64 v5, exec_lo        ; encoding: [0x05,0x00,0x8e,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_hi
// GFX12: v_cvt_off_f32_i4_e64 v5, exec_hi        ; encoding: [0x05,0x00,0x8e,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, null
// GFX12: v_cvt_off_f32_i4_e64 v5, null           ; encoding: [0x05,0x00,0x8e,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -1
// GFX12: v_cvt_off_f32_i4_e64 v5, -1             ; encoding: [0x05,0x00,0x8e,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0.5 mul:2
// GFX12: v_cvt_off_f32_i4_e64 v5, 0.5 mul:2      ; encoding: [0x05,0x00,0x8e,0xd5,0xf0,0x00,0x00,0x08]

v_cvt_off_f32_i4_e64 v5, src_scc mul:4
// GFX12: v_cvt_off_f32_i4_e64 v5, src_scc mul:4  ; encoding: [0x05,0x00,0x8e,0xd5,0xfd,0x00,0x00,0x10]

v_cvt_off_f32_i4_e64 v255, 0x4f clamp div:2
// GFX12: v_cvt_off_f32_i4_e64 v255, 0x4f clamp div:2 ; encoding: [0xff,0x80,0x8e,0xd5,0xff,0x00,0x00,0x18,0x4f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v1
// GFX12: v_cvt_nearest_i32_f32_e64 v5, v1        ; encoding: [0x05,0x00,0x8c,0xd5,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v255
// GFX12: v_cvt_nearest_i32_f32_e64 v5, v255      ; encoding: [0x05,0x00,0x8c,0xd5,0xff,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s1
// GFX12: v_cvt_nearest_i32_f32_e64 v5, s1        ; encoding: [0x05,0x00,0x8c,0xd5,0x01,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s105
// GFX12: v_cvt_nearest_i32_f32_e64 v5, s105      ; encoding: [0x05,0x00,0x8c,0xd5,0x69,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_lo
// GFX12: v_cvt_nearest_i32_f32_e64 v5, vcc_lo    ; encoding: [0x05,0x00,0x8c,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_hi
// GFX12: v_cvt_nearest_i32_f32_e64 v5, vcc_hi    ; encoding: [0x05,0x00,0x8c,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, ttmp15
// GFX12: v_cvt_nearest_i32_f32_e64 v5, ttmp15    ; encoding: [0x05,0x00,0x8c,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, m0
// GFX12: v_cvt_nearest_i32_f32_e64 v5, m0        ; encoding: [0x05,0x00,0x8c,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_lo
// GFX12: v_cvt_nearest_i32_f32_e64 v5, exec_lo   ; encoding: [0x05,0x00,0x8c,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_hi
// GFX12: v_cvt_nearest_i32_f32_e64 v5, exec_hi   ; encoding: [0x05,0x00,0x8c,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, null
// GFX12: v_cvt_nearest_i32_f32_e64 v5, null      ; encoding: [0x05,0x00,0x8c,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -1
// GFX12: v_cvt_nearest_i32_f32_e64 v5, -1        ; encoding: [0x05,0x00,0x8c,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0.5
// GFX12: v_cvt_nearest_i32_f32_e64 v5, 0.5       ; encoding: [0x05,0x00,0x8c,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, src_scc
// GFX12: v_cvt_nearest_i32_f32_e64 v5, src_scc   ; encoding: [0x05,0x00,0x8c,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v255, -|0xaf123456|
// GFX12: v_cvt_nearest_i32_f32_e64 v255, -|0xaf123456| ; encoding: [0xff,0x01,0x8c,0xd5,0xff,0x00,0x00,0x20,0x56,0x34,0x12,0xaf]

v_cvt_u16_f16_e64 v5.l, v1.l
// GFX12: v_cvt_u16_f16_e64 v5.l, v1.l            ; encoding: [0x05,0x00,0xd2,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, v255.l
// GFX12: v_cvt_u16_f16_e64 v5.l, v255.l          ; encoding: [0x05,0x00,0xd2,0xd5,0xff,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, s1
// GFX12: v_cvt_u16_f16_e64 v5.l, s1              ; encoding: [0x05,0x00,0xd2,0xd5,0x01,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, s105
// GFX12: v_cvt_u16_f16_e64 v5.l, s105            ; encoding: [0x05,0x00,0xd2,0xd5,0x69,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, vcc_lo
// GFX12: v_cvt_u16_f16_e64 v5.l, vcc_lo          ; encoding: [0x05,0x00,0xd2,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, vcc_hi
// GFX12: v_cvt_u16_f16_e64 v5.l, vcc_hi          ; encoding: [0x05,0x00,0xd2,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, ttmp15
// GFX12: v_cvt_u16_f16_e64 v5.l, ttmp15          ; encoding: [0x05,0x00,0xd2,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, m0
// GFX12: v_cvt_u16_f16_e64 v5.l, m0              ; encoding: [0x05,0x00,0xd2,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, exec_lo
// GFX12: v_cvt_u16_f16_e64 v5.l, exec_lo         ; encoding: [0x05,0x00,0xd2,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, exec_hi
// GFX12: v_cvt_u16_f16_e64 v5.l, exec_hi         ; encoding: [0x05,0x00,0xd2,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, null
// GFX12: v_cvt_u16_f16_e64 v5.l, null            ; encoding: [0x05,0x00,0xd2,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, -1
// GFX12: v_cvt_u16_f16_e64 v5.l, -1              ; encoding: [0x05,0x00,0xd2,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, 0.5
// GFX12: v_cvt_u16_f16_e64 v5.l, 0.5             ; encoding: [0x05,0x00,0xd2,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, src_scc
// GFX12: v_cvt_u16_f16_e64 v5.l, src_scc         ; encoding: [0x05,0x00,0xd2,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_u16_f16_e64 v255.l, -|0xfe0b| clamp
// GFX12: v_cvt_u16_f16_e64 v255.l, -|0xfe0b| clamp ; encoding: [0xff,0x81,0xd2,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_u16_f16_e64 v5.h, v1.h
// GFX12: v_cvt_u16_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xd2,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v5.l, v255.h
// GFX12: v_cvt_u16_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xd2,0xd5,0xff,0x01,0x00,0x00]

v_cvt_u16_f16_e64 v255.h, -|0xfe0b| clamp
// GFX12: v_cvt_u16_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp ; encoding: [0xff,0xc1,0xd2,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cvt_u32_f32_e64 v5, v1
// GFX12: v_cvt_u32_f32_e64 v5, v1                ; encoding: [0x05,0x00,0x87,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v255
// GFX12: v_cvt_u32_f32_e64 v5, v255              ; encoding: [0x05,0x00,0x87,0xd5,0xff,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, s1
// GFX12: v_cvt_u32_f32_e64 v5, s1                ; encoding: [0x05,0x00,0x87,0xd5,0x01,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, s105
// GFX12: v_cvt_u32_f32_e64 v5, s105              ; encoding: [0x05,0x00,0x87,0xd5,0x69,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_lo
// GFX12: v_cvt_u32_f32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0x87,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_hi
// GFX12: v_cvt_u32_f32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0x87,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, ttmp15
// GFX12: v_cvt_u32_f32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0x87,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, m0
// GFX12: v_cvt_u32_f32_e64 v5, m0                ; encoding: [0x05,0x00,0x87,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_lo
// GFX12: v_cvt_u32_f32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0x87,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_hi
// GFX12: v_cvt_u32_f32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0x87,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, null
// GFX12: v_cvt_u32_f32_e64 v5, null              ; encoding: [0x05,0x00,0x87,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -1
// GFX12: v_cvt_u32_f32_e64 v5, -1                ; encoding: [0x05,0x00,0x87,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0.5
// GFX12: v_cvt_u32_f32_e64 v5, 0.5               ; encoding: [0x05,0x00,0x87,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, src_scc
// GFX12: v_cvt_u32_f32_e64 v5, src_scc           ; encoding: [0x05,0x00,0x87,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v255, -|0xaf123456| clamp
// GFX12: v_cvt_u32_f32_e64 v255, -|0xaf123456| clamp ; encoding: [0xff,0x81,0x87,0xd5,0xff,0x00,0x00,0x20,0x56,0x34,0x12,0xaf]

v_cvt_u32_f64_e64 v5, v[1:2]
// GFX12: v_cvt_u32_f64_e64 v5, v[1:2]            ; encoding: [0x05,0x00,0x95,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[254:255]
// GFX12: v_cvt_u32_f64_e64 v5, v[254:255]        ; encoding: [0x05,0x00,0x95,0xd5,0xfe,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[2:3]
// GFX12: v_cvt_u32_f64_e64 v5, s[2:3]            ; encoding: [0x05,0x00,0x95,0xd5,0x02,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[104:105]
// GFX12: v_cvt_u32_f64_e64 v5, s[104:105]        ; encoding: [0x05,0x00,0x95,0xd5,0x68,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, vcc
// GFX12: v_cvt_u32_f64_e64 v5, vcc               ; encoding: [0x05,0x00,0x95,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, ttmp[14:15]
// GFX12: v_cvt_u32_f64_e64 v5, ttmp[14:15]       ; encoding: [0x05,0x00,0x95,0xd5,0x7a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, exec
// GFX12: v_cvt_u32_f64_e64 v5, exec              ; encoding: [0x05,0x00,0x95,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, null
// GFX12: v_cvt_u32_f64_e64 v5, null              ; encoding: [0x05,0x00,0x95,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -1
// GFX12: v_cvt_u32_f64_e64 v5, -1                ; encoding: [0x05,0x00,0x95,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0.5
// GFX12: v_cvt_u32_f64_e64 v5, 0.5               ; encoding: [0x05,0x00,0x95,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -|src_scc|
// GFX12: v_cvt_u32_f64_e64 v5, -|src_scc|        ; encoding: [0x05,0x01,0x95,0xd5,0xfd,0x00,0x00,0x20]

v_cvt_u32_f64_e64 v255, 0xaf123456 clamp
// GFX12: v_cvt_u32_f64_e64 v255, 0xaf123456 clamp ; encoding: [0xff,0x80,0x95,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cvt_u32_u16_e64 v5, v1.l
// GFX12: v_cvt_u32_u16_e64 v5, v1.l              ; encoding: [0x05,0x00,0xeb,0xd5,0x01,0x01,0x00,0x00]

v_cvt_u32_u16_e64 v5, v255.l
// GFX12: v_cvt_u32_u16_e64 v5, v255.l            ; encoding: [0x05,0x00,0xeb,0xd5,0xff,0x01,0x00,0x00]

v_cvt_u32_u16_e64 v5, s1
// GFX12: v_cvt_u32_u16_e64 v5, s1                ; encoding: [0x05,0x00,0xeb,0xd5,0x01,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, s105
// GFX12: v_cvt_u32_u16_e64 v5, s105              ; encoding: [0x05,0x00,0xeb,0xd5,0x69,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, vcc_lo
// GFX12: v_cvt_u32_u16_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0xeb,0xd5,0x6a,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, vcc_hi
// GFX12: v_cvt_u32_u16_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0xeb,0xd5,0x6b,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, ttmp15
// GFX12: v_cvt_u32_u16_e64 v5, ttmp15            ; encoding: [0x05,0x00,0xeb,0xd5,0x7b,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, m0
// GFX12: v_cvt_u32_u16_e64 v5, m0                ; encoding: [0x05,0x00,0xeb,0xd5,0x7d,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, exec_lo
// GFX12: v_cvt_u32_u16_e64 v5, exec_lo           ; encoding: [0x05,0x00,0xeb,0xd5,0x7e,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, exec_hi
// GFX12: v_cvt_u32_u16_e64 v5, exec_hi           ; encoding: [0x05,0x00,0xeb,0xd5,0x7f,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, null
// GFX12: v_cvt_u32_u16_e64 v5, null              ; encoding: [0x05,0x00,0xeb,0xd5,0x7c,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, -1
// GFX12: v_cvt_u32_u16_e64 v5, -1                ; encoding: [0x05,0x00,0xeb,0xd5,0xc1,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, 0.5
// GFX12: v_cvt_u32_u16_e64 v5, 0.5               ; encoding: [0x05,0x00,0xeb,0xd5,0xf0,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v5, src_scc
// GFX12: v_cvt_u32_u16_e64 v5, src_scc           ; encoding: [0x05,0x00,0xeb,0xd5,0xfd,0x00,0x00,0x00]

v_cvt_u32_u16_e64 v255, 0xfe0b
// GFX12: v_cvt_u32_u16_e64 v255, 0xfe0b          ; encoding: [0xff,0x00,0xeb,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cvt_u32_u16_e64 v5, v255.h
// GFX12: v_cvt_u32_u16_e64 v5, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xeb,0xd5,0xff,0x01,0x00,0x00]

v_exp_f16_e64 v5, v1
// GFX12: v_exp_f16_e64 v5, v1                    ; encoding: [0x05,0x00,0xd8,0xd5,0x01,0x01,0x00,0x00]

v_exp_f16_e64 v5, v255
// GFX12: v_exp_f16_e64 v5, v255                  ; encoding: [0x05,0x00,0xd8,0xd5,0xff,0x01,0x00,0x00]

v_exp_f16_e64 v5, s1
// GFX12: v_exp_f16_e64 v5, s1                    ; encoding: [0x05,0x00,0xd8,0xd5,0x01,0x00,0x00,0x00]

v_exp_f16_e64 v5, s105
// GFX12: v_exp_f16_e64 v5, s105                  ; encoding: [0x05,0x00,0xd8,0xd5,0x69,0x00,0x00,0x00]

v_exp_f16_e64 v5, vcc_lo
// GFX12: v_exp_f16_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xd8,0xd5,0x6a,0x00,0x00,0x00]

v_exp_f16_e64 v5, vcc_hi
// GFX12: v_exp_f16_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xd8,0xd5,0x6b,0x00,0x00,0x00]

v_exp_f16_e64 v5, ttmp15
// GFX12: v_exp_f16_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xd8,0xd5,0x7b,0x00,0x00,0x00]

v_exp_f16_e64 v5, m0
// GFX12: v_exp_f16_e64 v5, m0                    ; encoding: [0x05,0x00,0xd8,0xd5,0x7d,0x00,0x00,0x00]

v_exp_f16_e64 v5, exec_lo
// GFX12: v_exp_f16_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xd8,0xd5,0x7e,0x00,0x00,0x00]

v_exp_f16_e64 v5, exec_hi
// GFX12: v_exp_f16_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xd8,0xd5,0x7f,0x00,0x00,0x00]

v_exp_f16_e64 v5, null
// GFX12: v_exp_f16_e64 v5, null                  ; encoding: [0x05,0x00,0xd8,0xd5,0x7c,0x00,0x00,0x00]

v_exp_f16_e64 v5, -1
// GFX12: v_exp_f16_e64 v5, -1                    ; encoding: [0x05,0x00,0xd8,0xd5,0xc1,0x00,0x00,0x00]

v_exp_f16_e64 v5, 0.5 mul:2
// GFX12: v_exp_f16_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xd8,0xd5,0xf0,0x00,0x00,0x08]

v_exp_f16_e64 v5, src_scc mul:4
// GFX12: v_exp_f16_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xd8,0xd5,0xfd,0x00,0x00,0x10]

v_exp_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_exp_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xd8,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_exp_f32_e64 v5, v1
// GFX12: v_exp_f32_e64 v5, v1                    ; encoding: [0x05,0x00,0xa5,0xd5,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v255
// GFX12: v_exp_f32_e64 v5, v255                  ; encoding: [0x05,0x00,0xa5,0xd5,0xff,0x01,0x00,0x00]

v_exp_f32_e64 v5, s1
// GFX12: v_exp_f32_e64 v5, s1                    ; encoding: [0x05,0x00,0xa5,0xd5,0x01,0x00,0x00,0x00]

v_exp_f32_e64 v5, s105
// GFX12: v_exp_f32_e64 v5, s105                  ; encoding: [0x05,0x00,0xa5,0xd5,0x69,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_lo
// GFX12: v_exp_f32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xa5,0xd5,0x6a,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_hi
// GFX12: v_exp_f32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xa5,0xd5,0x6b,0x00,0x00,0x00]

v_exp_f32_e64 v5, ttmp15
// GFX12: v_exp_f32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xa5,0xd5,0x7b,0x00,0x00,0x00]

v_exp_f32_e64 v5, m0
// GFX12: v_exp_f32_e64 v5, m0                    ; encoding: [0x05,0x00,0xa5,0xd5,0x7d,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_lo
// GFX12: v_exp_f32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xa5,0xd5,0x7e,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_hi
// GFX12: v_exp_f32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xa5,0xd5,0x7f,0x00,0x00,0x00]

v_exp_f32_e64 v5, null
// GFX12: v_exp_f32_e64 v5, null                  ; encoding: [0x05,0x00,0xa5,0xd5,0x7c,0x00,0x00,0x00]

v_exp_f32_e64 v5, -1
// GFX12: v_exp_f32_e64 v5, -1                    ; encoding: [0x05,0x00,0xa5,0xd5,0xc1,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0.5 mul:2
// GFX12: v_exp_f32_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xa5,0xd5,0xf0,0x00,0x00,0x08]

v_exp_f32_e64 v5, src_scc mul:4
// GFX12: v_exp_f32_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xa5,0xd5,0xfd,0x00,0x00,0x10]

v_exp_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_exp_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xa5,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_ffbh_i32_e64 v5, v1
// GFX12: v_cls_i32_e64 v5, v1                    ; encoding: [0x05,0x00,0xbb,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, v255
// GFX12: v_cls_i32_e64 v5, v255                  ; encoding: [0x05,0x00,0xbb,0xd5,0xff,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, s1
// GFX12: v_cls_i32_e64 v5, s1                    ; encoding: [0x05,0x00,0xbb,0xd5,0x01,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, s105
// GFX12: v_cls_i32_e64 v5, s105                  ; encoding: [0x05,0x00,0xbb,0xd5,0x69,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_lo
// GFX12: v_cls_i32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xbb,0xd5,0x6a,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_hi
// GFX12: v_cls_i32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xbb,0xd5,0x6b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, ttmp15
// GFX12: v_cls_i32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xbb,0xd5,0x7b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, m0
// GFX12: v_cls_i32_e64 v5, m0                    ; encoding: [0x05,0x00,0xbb,0xd5,0x7d,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_lo
// GFX12: v_cls_i32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xbb,0xd5,0x7e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_hi
// GFX12: v_cls_i32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xbb,0xd5,0x7f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, null
// GFX12: v_cls_i32_e64 v5, null                  ; encoding: [0x05,0x00,0xbb,0xd5,0x7c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -1
// GFX12: v_cls_i32_e64 v5, -1                    ; encoding: [0x05,0x00,0xbb,0xd5,0xc1,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0.5
// GFX12: v_cls_i32_e64 v5, 0.5                   ; encoding: [0x05,0x00,0xbb,0xd5,0xf0,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, src_scc
// GFX12: v_cls_i32_e64 v5, src_scc               ; encoding: [0x05,0x00,0xbb,0xd5,0xfd,0x00,0x00,0x00]

v_ffbh_i32_e64 v255, 0xaf123456
// GFX12: v_cls_i32_e64 v255, 0xaf123456          ; encoding: [0xff,0x00,0xbb,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_ffbh_u32_e64 v5, v1
// GFX12: v_clz_i32_u32_e64 v5, v1                ; encoding: [0x05,0x00,0xb9,0xd5,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, v255
// GFX12: v_clz_i32_u32_e64 v5, v255              ; encoding: [0x05,0x00,0xb9,0xd5,0xff,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, s1
// GFX12: v_clz_i32_u32_e64 v5, s1                ; encoding: [0x05,0x00,0xb9,0xd5,0x01,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, s105
// GFX12: v_clz_i32_u32_e64 v5, s105              ; encoding: [0x05,0x00,0xb9,0xd5,0x69,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_lo
// GFX12: v_clz_i32_u32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0xb9,0xd5,0x6a,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_hi
// GFX12: v_clz_i32_u32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0xb9,0xd5,0x6b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, ttmp15
// GFX12: v_clz_i32_u32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0xb9,0xd5,0x7b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, m0
// GFX12: v_clz_i32_u32_e64 v5, m0                ; encoding: [0x05,0x00,0xb9,0xd5,0x7d,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_lo
// GFX12: v_clz_i32_u32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0xb9,0xd5,0x7e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_hi
// GFX12: v_clz_i32_u32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0xb9,0xd5,0x7f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, null
// GFX12: v_clz_i32_u32_e64 v5, null              ; encoding: [0x05,0x00,0xb9,0xd5,0x7c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -1
// GFX12: v_clz_i32_u32_e64 v5, -1                ; encoding: [0x05,0x00,0xb9,0xd5,0xc1,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0.5
// GFX12: v_clz_i32_u32_e64 v5, 0.5               ; encoding: [0x05,0x00,0xb9,0xd5,0xf0,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, src_scc
// GFX12: v_clz_i32_u32_e64 v5, src_scc           ; encoding: [0x05,0x00,0xb9,0xd5,0xfd,0x00,0x00,0x00]

v_ffbh_u32_e64 v255, 0xaf123456
// GFX12: v_clz_i32_u32_e64 v255, 0xaf123456      ; encoding: [0xff,0x00,0xb9,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_ffbl_b32_e64 v5, v1
// GFX12: v_ctz_i32_b32_e64 v5, v1                ; encoding: [0x05,0x00,0xba,0xd5,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, v255
// GFX12: v_ctz_i32_b32_e64 v5, v255              ; encoding: [0x05,0x00,0xba,0xd5,0xff,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, s1
// GFX12: v_ctz_i32_b32_e64 v5, s1                ; encoding: [0x05,0x00,0xba,0xd5,0x01,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, s105
// GFX12: v_ctz_i32_b32_e64 v5, s105              ; encoding: [0x05,0x00,0xba,0xd5,0x69,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_lo
// GFX12: v_ctz_i32_b32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0xba,0xd5,0x6a,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_hi
// GFX12: v_ctz_i32_b32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0xba,0xd5,0x6b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, ttmp15
// GFX12: v_ctz_i32_b32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0xba,0xd5,0x7b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, m0
// GFX12: v_ctz_i32_b32_e64 v5, m0                ; encoding: [0x05,0x00,0xba,0xd5,0x7d,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_lo
// GFX12: v_ctz_i32_b32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0xba,0xd5,0x7e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_hi
// GFX12: v_ctz_i32_b32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0xba,0xd5,0x7f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, null
// GFX12: v_ctz_i32_b32_e64 v5, null              ; encoding: [0x05,0x00,0xba,0xd5,0x7c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -1
// GFX12: v_ctz_i32_b32_e64 v5, -1                ; encoding: [0x05,0x00,0xba,0xd5,0xc1,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0.5
// GFX12: v_ctz_i32_b32_e64 v5, 0.5               ; encoding: [0x05,0x00,0xba,0xd5,0xf0,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, src_scc
// GFX12: v_ctz_i32_b32_e64 v5, src_scc           ; encoding: [0x05,0x00,0xba,0xd5,0xfd,0x00,0x00,0x00]

v_ffbl_b32_e64 v255, 0xaf123456
// GFX12: v_ctz_i32_b32_e64 v255, 0xaf123456      ; encoding: [0xff,0x00,0xba,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_floor_f16_e64 v5, v1
// GFX12: v_floor_f16_e64 v5, v1                  ; encoding: [0x05,0x00,0xdb,0xd5,0x01,0x01,0x00,0x00]

v_floor_f16_e64 v5, v255
// GFX12: v_floor_f16_e64 v5, v255                ; encoding: [0x05,0x00,0xdb,0xd5,0xff,0x01,0x00,0x00]

v_floor_f16_e64 v5, s1
// GFX12: v_floor_f16_e64 v5, s1                  ; encoding: [0x05,0x00,0xdb,0xd5,0x01,0x00,0x00,0x00]

v_floor_f16_e64 v5, s105
// GFX12: v_floor_f16_e64 v5, s105                ; encoding: [0x05,0x00,0xdb,0xd5,0x69,0x00,0x00,0x00]

v_floor_f16_e64 v5, vcc_lo
// GFX12: v_floor_f16_e64 v5, vcc_lo              ; encoding: [0x05,0x00,0xdb,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f16_e64 v5, vcc_hi
// GFX12: v_floor_f16_e64 v5, vcc_hi              ; encoding: [0x05,0x00,0xdb,0xd5,0x6b,0x00,0x00,0x00]

v_floor_f16_e64 v5, ttmp15
// GFX12: v_floor_f16_e64 v5, ttmp15              ; encoding: [0x05,0x00,0xdb,0xd5,0x7b,0x00,0x00,0x00]

v_floor_f16_e64 v5, m0
// GFX12: v_floor_f16_e64 v5, m0                  ; encoding: [0x05,0x00,0xdb,0xd5,0x7d,0x00,0x00,0x00]

v_floor_f16_e64 v5, exec_lo
// GFX12: v_floor_f16_e64 v5, exec_lo             ; encoding: [0x05,0x00,0xdb,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f16_e64 v5, exec_hi
// GFX12: v_floor_f16_e64 v5, exec_hi             ; encoding: [0x05,0x00,0xdb,0xd5,0x7f,0x00,0x00,0x00]

v_floor_f16_e64 v5, null
// GFX12: v_floor_f16_e64 v5, null                ; encoding: [0x05,0x00,0xdb,0xd5,0x7c,0x00,0x00,0x00]

v_floor_f16_e64 v5, -1
// GFX12: v_floor_f16_e64 v5, -1                  ; encoding: [0x05,0x00,0xdb,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f16_e64 v5, 0.5 mul:2
// GFX12: v_floor_f16_e64 v5, 0.5 mul:2           ; encoding: [0x05,0x00,0xdb,0xd5,0xf0,0x00,0x00,0x08]

v_floor_f16_e64 v5, src_scc mul:4
// GFX12: v_floor_f16_e64 v5, src_scc mul:4       ; encoding: [0x05,0x00,0xdb,0xd5,0xfd,0x00,0x00,0x10]

v_floor_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_floor_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xdb,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_floor_f32_e64 v5, v1
// GFX12: v_floor_f32_e64 v5, v1                  ; encoding: [0x05,0x00,0xa4,0xd5,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v255
// GFX12: v_floor_f32_e64 v5, v255                ; encoding: [0x05,0x00,0xa4,0xd5,0xff,0x01,0x00,0x00]

v_floor_f32_e64 v5, s1
// GFX12: v_floor_f32_e64 v5, s1                  ; encoding: [0x05,0x00,0xa4,0xd5,0x01,0x00,0x00,0x00]

v_floor_f32_e64 v5, s105
// GFX12: v_floor_f32_e64 v5, s105                ; encoding: [0x05,0x00,0xa4,0xd5,0x69,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_lo
// GFX12: v_floor_f32_e64 v5, vcc_lo              ; encoding: [0x05,0x00,0xa4,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_hi
// GFX12: v_floor_f32_e64 v5, vcc_hi              ; encoding: [0x05,0x00,0xa4,0xd5,0x6b,0x00,0x00,0x00]

v_floor_f32_e64 v5, ttmp15
// GFX12: v_floor_f32_e64 v5, ttmp15              ; encoding: [0x05,0x00,0xa4,0xd5,0x7b,0x00,0x00,0x00]

v_floor_f32_e64 v5, m0
// GFX12: v_floor_f32_e64 v5, m0                  ; encoding: [0x05,0x00,0xa4,0xd5,0x7d,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_lo
// GFX12: v_floor_f32_e64 v5, exec_lo             ; encoding: [0x05,0x00,0xa4,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_hi
// GFX12: v_floor_f32_e64 v5, exec_hi             ; encoding: [0x05,0x00,0xa4,0xd5,0x7f,0x00,0x00,0x00]

v_floor_f32_e64 v5, null
// GFX12: v_floor_f32_e64 v5, null                ; encoding: [0x05,0x00,0xa4,0xd5,0x7c,0x00,0x00,0x00]

v_floor_f32_e64 v5, -1
// GFX12: v_floor_f32_e64 v5, -1                  ; encoding: [0x05,0x00,0xa4,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0.5 mul:2
// GFX12: v_floor_f32_e64 v5, 0.5 mul:2           ; encoding: [0x05,0x00,0xa4,0xd5,0xf0,0x00,0x00,0x08]

v_floor_f32_e64 v5, src_scc mul:4
// GFX12: v_floor_f32_e64 v5, src_scc mul:4       ; encoding: [0x05,0x00,0xa4,0xd5,0xfd,0x00,0x00,0x10]

v_floor_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_floor_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xa4,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_floor_f64_e64 v[5:6], v[1:2]
// GFX12: v_floor_f64_e64 v[5:6], v[1:2]          ; encoding: [0x05,0x00,0x9a,0xd5,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[254:255]
// GFX12: v_floor_f64_e64 v[5:6], v[254:255]      ; encoding: [0x05,0x00,0x9a,0xd5,0xfe,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], s[2:3]
// GFX12: v_floor_f64_e64 v[5:6], s[2:3]          ; encoding: [0x05,0x00,0x9a,0xd5,0x02,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[104:105]
// GFX12: v_floor_f64_e64 v[5:6], s[104:105]      ; encoding: [0x05,0x00,0x9a,0xd5,0x68,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], vcc
// GFX12: v_floor_f64_e64 v[5:6], vcc             ; encoding: [0x05,0x00,0x9a,0xd5,0x6a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_floor_f64_e64 v[5:6], ttmp[14:15]     ; encoding: [0x05,0x00,0x9a,0xd5,0x7a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], exec
// GFX12: v_floor_f64_e64 v[5:6], exec            ; encoding: [0x05,0x00,0x9a,0xd5,0x7e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], null
// GFX12: v_floor_f64_e64 v[5:6], null            ; encoding: [0x05,0x00,0x9a,0xd5,0x7c,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -1
// GFX12: v_floor_f64_e64 v[5:6], -1              ; encoding: [0x05,0x00,0x9a,0xd5,0xc1,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_floor_f64_e64 v[5:6], 0.5 mul:2       ; encoding: [0x05,0x00,0x9a,0xd5,0xf0,0x00,0x00,0x08]

v_floor_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_floor_f64_e64 v[5:6], -|src_scc| mul:4 ; encoding: [0x05,0x01,0x9a,0xd5,0xfd,0x00,0x00,0x30]

v_floor_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_floor_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0x9a,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_fract_f16_e64 v5.l, v1.l
// GFX12: v_fract_f16_e64 v5.l, v1.l              ; encoding: [0x05,0x00,0xdf,0xd5,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v5.l, v255.l
// GFX12: v_fract_f16_e64 v5.l, v255.l            ; encoding: [0x05,0x00,0xdf,0xd5,0xff,0x01,0x00,0x00]

v_fract_f16_e64 v5.l, s1
// GFX12: v_fract_f16_e64 v5.l, s1                ; encoding: [0x05,0x00,0xdf,0xd5,0x01,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, s105
// GFX12: v_fract_f16_e64 v5.l, s105              ; encoding: [0x05,0x00,0xdf,0xd5,0x69,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, vcc_lo
// GFX12: v_fract_f16_e64 v5.l, vcc_lo            ; encoding: [0x05,0x00,0xdf,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, vcc_hi
// GFX12: v_fract_f16_e64 v5.l, vcc_hi            ; encoding: [0x05,0x00,0xdf,0xd5,0x6b,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, ttmp15
// GFX12: v_fract_f16_e64 v5.l, ttmp15            ; encoding: [0x05,0x00,0xdf,0xd5,0x7b,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, m0
// GFX12: v_fract_f16_e64 v5.l, m0                ; encoding: [0x05,0x00,0xdf,0xd5,0x7d,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, exec_lo
// GFX12: v_fract_f16_e64 v5.l, exec_lo           ; encoding: [0x05,0x00,0xdf,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, exec_hi
// GFX12: v_fract_f16_e64 v5.l, exec_hi           ; encoding: [0x05,0x00,0xdf,0xd5,0x7f,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, null
// GFX12: v_fract_f16_e64 v5.l, null              ; encoding: [0x05,0x00,0xdf,0xd5,0x7c,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, -1
// GFX12: v_fract_f16_e64 v5.l, -1                ; encoding: [0x05,0x00,0xdf,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f16_e64 v5.l, 0.5 mul:2
// GFX12: v_fract_f16_e64 v5.l, 0.5 mul:2         ; encoding: [0x05,0x00,0xdf,0xd5,0xf0,0x00,0x00,0x08]

v_fract_f16_e64 v5.l, src_scc mul:4
// GFX12: v_fract_f16_e64 v5.l, src_scc mul:4     ; encoding: [0x05,0x00,0xdf,0xd5,0xfd,0x00,0x00,0x10]

v_fract_f16_e64 v255.l, -|0xfe0b| clamp div:2
// GFX12: v_fract_f16_e64 v255.l, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xdf,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_fract_f16_e64 v5.h, v1.h
// GFX12: v_fract_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xdf,0xd5,0x01,0x01,0x00,0x00]

v_fract_f16_e64 v5.l, v255.h
// GFX12: v_fract_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xdf,0xd5,0xff,0x01,0x00,0x00]

v_fract_f16_e64 v255.h, -|0xfe0b| clamp div:2
// GFX12: v_fract_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc1,0xdf,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_fract_f32_e64 v5, v1
// GFX12: v_fract_f32_e64 v5, v1                  ; encoding: [0x05,0x00,0xa0,0xd5,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v255
// GFX12: v_fract_f32_e64 v5, v255                ; encoding: [0x05,0x00,0xa0,0xd5,0xff,0x01,0x00,0x00]

v_fract_f32_e64 v5, s1
// GFX12: v_fract_f32_e64 v5, s1                  ; encoding: [0x05,0x00,0xa0,0xd5,0x01,0x00,0x00,0x00]

v_fract_f32_e64 v5, s105
// GFX12: v_fract_f32_e64 v5, s105                ; encoding: [0x05,0x00,0xa0,0xd5,0x69,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_lo
// GFX12: v_fract_f32_e64 v5, vcc_lo              ; encoding: [0x05,0x00,0xa0,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_hi
// GFX12: v_fract_f32_e64 v5, vcc_hi              ; encoding: [0x05,0x00,0xa0,0xd5,0x6b,0x00,0x00,0x00]

v_fract_f32_e64 v5, ttmp15
// GFX12: v_fract_f32_e64 v5, ttmp15              ; encoding: [0x05,0x00,0xa0,0xd5,0x7b,0x00,0x00,0x00]

v_fract_f32_e64 v5, m0
// GFX12: v_fract_f32_e64 v5, m0                  ; encoding: [0x05,0x00,0xa0,0xd5,0x7d,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_lo
// GFX12: v_fract_f32_e64 v5, exec_lo             ; encoding: [0x05,0x00,0xa0,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_hi
// GFX12: v_fract_f32_e64 v5, exec_hi             ; encoding: [0x05,0x00,0xa0,0xd5,0x7f,0x00,0x00,0x00]

v_fract_f32_e64 v5, null
// GFX12: v_fract_f32_e64 v5, null                ; encoding: [0x05,0x00,0xa0,0xd5,0x7c,0x00,0x00,0x00]

v_fract_f32_e64 v5, -1
// GFX12: v_fract_f32_e64 v5, -1                  ; encoding: [0x05,0x00,0xa0,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0.5 mul:2
// GFX12: v_fract_f32_e64 v5, 0.5 mul:2           ; encoding: [0x05,0x00,0xa0,0xd5,0xf0,0x00,0x00,0x08]

v_fract_f32_e64 v5, src_scc mul:4
// GFX12: v_fract_f32_e64 v5, src_scc mul:4       ; encoding: [0x05,0x00,0xa0,0xd5,0xfd,0x00,0x00,0x10]

v_fract_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_fract_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xa0,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_fract_f64_e64 v[5:6], v[1:2]
// GFX12: v_fract_f64_e64 v[5:6], v[1:2]          ; encoding: [0x05,0x00,0xbe,0xd5,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[254:255]
// GFX12: v_fract_f64_e64 v[5:6], v[254:255]      ; encoding: [0x05,0x00,0xbe,0xd5,0xfe,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], s[2:3]
// GFX12: v_fract_f64_e64 v[5:6], s[2:3]          ; encoding: [0x05,0x00,0xbe,0xd5,0x02,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[104:105]
// GFX12: v_fract_f64_e64 v[5:6], s[104:105]      ; encoding: [0x05,0x00,0xbe,0xd5,0x68,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], vcc
// GFX12: v_fract_f64_e64 v[5:6], vcc             ; encoding: [0x05,0x00,0xbe,0xd5,0x6a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_fract_f64_e64 v[5:6], ttmp[14:15]     ; encoding: [0x05,0x00,0xbe,0xd5,0x7a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], exec
// GFX12: v_fract_f64_e64 v[5:6], exec            ; encoding: [0x05,0x00,0xbe,0xd5,0x7e,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], null
// GFX12: v_fract_f64_e64 v[5:6], null            ; encoding: [0x05,0x00,0xbe,0xd5,0x7c,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -1
// GFX12: v_fract_f64_e64 v[5:6], -1              ; encoding: [0x05,0x00,0xbe,0xd5,0xc1,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_fract_f64_e64 v[5:6], 0.5 mul:2       ; encoding: [0x05,0x00,0xbe,0xd5,0xf0,0x00,0x00,0x08]

v_fract_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_fract_f64_e64 v[5:6], -|src_scc| mul:4 ; encoding: [0x05,0x01,0xbe,0xd5,0xfd,0x00,0x00,0x30]

v_fract_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_fract_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0xbe,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_frexp_exp_i16_f16_e64 v5.l, v1.l
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, v1.l      ; encoding: [0x05,0x00,0xda,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, v255.l
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, v255.l    ; encoding: [0x05,0x00,0xda,0xd5,0xff,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, s1
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, s1        ; encoding: [0x05,0x00,0xda,0xd5,0x01,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, s105
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, s105      ; encoding: [0x05,0x00,0xda,0xd5,0x69,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, vcc_lo
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, vcc_lo    ; encoding: [0x05,0x00,0xda,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, vcc_hi
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, vcc_hi    ; encoding: [0x05,0x00,0xda,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, ttmp15
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, ttmp15    ; encoding: [0x05,0x00,0xda,0xd5,0x7b,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, m0
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, m0        ; encoding: [0x05,0x00,0xda,0xd5,0x7d,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, exec_lo
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, exec_lo   ; encoding: [0x05,0x00,0xda,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, exec_hi
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, exec_hi   ; encoding: [0x05,0x00,0xda,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, null
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, null      ; encoding: [0x05,0x00,0xda,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, -1
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, -1        ; encoding: [0x05,0x00,0xda,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, 0.5
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, 0.5       ; encoding: [0x05,0x00,0xda,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, src_scc
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, src_scc   ; encoding: [0x05,0x00,0xda,0xd5,0xfd,0x00,0x00,0x00]

v_frexp_exp_i16_f16_e64 v255.l, -|0xfe0b|
// GFX12: v_frexp_exp_i16_f16_e64 v255.l, -|0xfe0b| ; encoding: [0xff,0x01,0xda,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.h, v1.h
// GFX12: v_frexp_exp_i16_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xda,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v5.l, v255.h
// GFX12: v_frexp_exp_i16_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xda,0xd5,0xff,0x01,0x00,0x00]

v_frexp_exp_i16_f16_e64 v255.h, -|0xfe0b|
// GFX12: v_frexp_exp_i16_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] ; encoding: [0xff,0x41,0xda,0xd5,0xff,0x00,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, v1
// GFX12: v_frexp_exp_i32_f32_e64 v5, v1          ; encoding: [0x05,0x00,0xbf,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, v255
// GFX12: v_frexp_exp_i32_f32_e64 v5, v255        ; encoding: [0x05,0x00,0xbf,0xd5,0xff,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s1
// GFX12: v_frexp_exp_i32_f32_e64 v5, s1          ; encoding: [0x05,0x00,0xbf,0xd5,0x01,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s105
// GFX12: v_frexp_exp_i32_f32_e64 v5, s105        ; encoding: [0x05,0x00,0xbf,0xd5,0x69,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_lo
// GFX12: v_frexp_exp_i32_f32_e64 v5, vcc_lo      ; encoding: [0x05,0x00,0xbf,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_hi
// GFX12: v_frexp_exp_i32_f32_e64 v5, vcc_hi      ; encoding: [0x05,0x00,0xbf,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, ttmp15
// GFX12: v_frexp_exp_i32_f32_e64 v5, ttmp15      ; encoding: [0x05,0x00,0xbf,0xd5,0x7b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, m0
// GFX12: v_frexp_exp_i32_f32_e64 v5, m0          ; encoding: [0x05,0x00,0xbf,0xd5,0x7d,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_lo
// GFX12: v_frexp_exp_i32_f32_e64 v5, exec_lo     ; encoding: [0x05,0x00,0xbf,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_hi
// GFX12: v_frexp_exp_i32_f32_e64 v5, exec_hi     ; encoding: [0x05,0x00,0xbf,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, null
// GFX12: v_frexp_exp_i32_f32_e64 v5, null        ; encoding: [0x05,0x00,0xbf,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -1
// GFX12: v_frexp_exp_i32_f32_e64 v5, -1          ; encoding: [0x05,0x00,0xbf,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0.5
// GFX12: v_frexp_exp_i32_f32_e64 v5, 0.5         ; encoding: [0x05,0x00,0xbf,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, src_scc
// GFX12: v_frexp_exp_i32_f32_e64 v5, src_scc     ; encoding: [0x05,0x00,0xbf,0xd5,0xfd,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v255, -|0xaf123456|
// GFX12: v_frexp_exp_i32_f32_e64 v255, -|0xaf123456| ; encoding: [0xff,0x01,0xbf,0xd5,0xff,0x00,0x00,0x20,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f64_e64 v5, v[1:2]
// GFX12: v_frexp_exp_i32_f64_e64 v5, v[1:2]      ; encoding: [0x05,0x00,0xbc,0xd5,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[254:255]
// GFX12: v_frexp_exp_i32_f64_e64 v5, v[254:255]  ; encoding: [0x05,0x00,0xbc,0xd5,0xfe,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[2:3]
// GFX12: v_frexp_exp_i32_f64_e64 v5, s[2:3]      ; encoding: [0x05,0x00,0xbc,0xd5,0x02,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[104:105]
// GFX12: v_frexp_exp_i32_f64_e64 v5, s[104:105]  ; encoding: [0x05,0x00,0xbc,0xd5,0x68,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, vcc
// GFX12: v_frexp_exp_i32_f64_e64 v5, vcc         ; encoding: [0x05,0x00,0xbc,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, ttmp[14:15]
// GFX12: v_frexp_exp_i32_f64_e64 v5, ttmp[14:15] ; encoding: [0x05,0x00,0xbc,0xd5,0x7a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, exec
// GFX12: v_frexp_exp_i32_f64_e64 v5, exec        ; encoding: [0x05,0x00,0xbc,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, null
// GFX12: v_frexp_exp_i32_f64_e64 v5, null        ; encoding: [0x05,0x00,0xbc,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -1
// GFX12: v_frexp_exp_i32_f64_e64 v5, -1          ; encoding: [0x05,0x00,0xbc,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0.5
// GFX12: v_frexp_exp_i32_f64_e64 v5, 0.5         ; encoding: [0x05,0x00,0xbc,0xd5,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -|src_scc|
// GFX12: v_frexp_exp_i32_f64_e64 v5, -|src_scc|  ; encoding: [0x05,0x01,0xbc,0xd5,0xfd,0x00,0x00,0x20]

v_frexp_exp_i32_f64_e64 v255, 0xaf123456
// GFX12: v_frexp_exp_i32_f64_e64 v255, 0xaf123456 ; encoding: [0xff,0x00,0xbc,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_frexp_mant_f16_e64 v5.l, v1.l
// GFX12: v_frexp_mant_f16_e64 v5.l, v1.l         ; encoding: [0x05,0x00,0xd9,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, v255.l
// GFX12: v_frexp_mant_f16_e64 v5.l, v255.l       ; encoding: [0x05,0x00,0xd9,0xd5,0xff,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, s1
// GFX12: v_frexp_mant_f16_e64 v5.l, s1           ; encoding: [0x05,0x00,0xd9,0xd5,0x01,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, s105
// GFX12: v_frexp_mant_f16_e64 v5.l, s105         ; encoding: [0x05,0x00,0xd9,0xd5,0x69,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, vcc_lo
// GFX12: v_frexp_mant_f16_e64 v5.l, vcc_lo       ; encoding: [0x05,0x00,0xd9,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, vcc_hi
// GFX12: v_frexp_mant_f16_e64 v5.l, vcc_hi       ; encoding: [0x05,0x00,0xd9,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, ttmp15
// GFX12: v_frexp_mant_f16_e64 v5.l, ttmp15       ; encoding: [0x05,0x00,0xd9,0xd5,0x7b,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, m0
// GFX12: v_frexp_mant_f16_e64 v5.l, m0           ; encoding: [0x05,0x00,0xd9,0xd5,0x7d,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, exec_lo
// GFX12: v_frexp_mant_f16_e64 v5.l, exec_lo      ; encoding: [0x05,0x00,0xd9,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, exec_hi
// GFX12: v_frexp_mant_f16_e64 v5.l, exec_hi      ; encoding: [0x05,0x00,0xd9,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, null
// GFX12: v_frexp_mant_f16_e64 v5.l, null         ; encoding: [0x05,0x00,0xd9,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, -1
// GFX12: v_frexp_mant_f16_e64 v5.l, -1           ; encoding: [0x05,0x00,0xd9,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, 0.5 mul:2
// GFX12: v_frexp_mant_f16_e64 v5.l, 0.5 mul:2    ; encoding: [0x05,0x00,0xd9,0xd5,0xf0,0x00,0x00,0x08]

v_frexp_mant_f16_e64 v5.l, src_scc mul:4
// GFX12: v_frexp_mant_f16_e64 v5.l, src_scc mul:4 ; encoding: [0x05,0x00,0xd9,0xd5,0xfd,0x00,0x00,0x10]

v_frexp_mant_f16_e64 v255.l, -|0xfe0b| clamp div:2
// GFX12: v_frexp_mant_f16_e64 v255.l, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xd9,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_frexp_mant_f16_e64 v5.h, v1.h
// GFX12: v_frexp_mant_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xd9,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v5.l, v255.h
// GFX12: v_frexp_mant_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xd9,0xd5,0xff,0x01,0x00,0x00]

v_frexp_mant_f16_e64 v255.h, -|0xfe0b| clamp div:2
// GFX12: v_frexp_mant_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc1,0xd9,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_frexp_mant_f32_e64 v5, v1
// GFX12: v_frexp_mant_f32_e64 v5, v1             ; encoding: [0x05,0x00,0xc0,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v255
// GFX12: v_frexp_mant_f32_e64 v5, v255           ; encoding: [0x05,0x00,0xc0,0xd5,0xff,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, s1
// GFX12: v_frexp_mant_f32_e64 v5, s1             ; encoding: [0x05,0x00,0xc0,0xd5,0x01,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, s105
// GFX12: v_frexp_mant_f32_e64 v5, s105           ; encoding: [0x05,0x00,0xc0,0xd5,0x69,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_lo
// GFX12: v_frexp_mant_f32_e64 v5, vcc_lo         ; encoding: [0x05,0x00,0xc0,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_hi
// GFX12: v_frexp_mant_f32_e64 v5, vcc_hi         ; encoding: [0x05,0x00,0xc0,0xd5,0x6b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, ttmp15
// GFX12: v_frexp_mant_f32_e64 v5, ttmp15         ; encoding: [0x05,0x00,0xc0,0xd5,0x7b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, m0
// GFX12: v_frexp_mant_f32_e64 v5, m0             ; encoding: [0x05,0x00,0xc0,0xd5,0x7d,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_lo
// GFX12: v_frexp_mant_f32_e64 v5, exec_lo        ; encoding: [0x05,0x00,0xc0,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_hi
// GFX12: v_frexp_mant_f32_e64 v5, exec_hi        ; encoding: [0x05,0x00,0xc0,0xd5,0x7f,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, null
// GFX12: v_frexp_mant_f32_e64 v5, null           ; encoding: [0x05,0x00,0xc0,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -1
// GFX12: v_frexp_mant_f32_e64 v5, -1             ; encoding: [0x05,0x00,0xc0,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0.5 mul:2
// GFX12: v_frexp_mant_f32_e64 v5, 0.5 mul:2      ; encoding: [0x05,0x00,0xc0,0xd5,0xf0,0x00,0x00,0x08]

v_frexp_mant_f32_e64 v5, src_scc mul:4
// GFX12: v_frexp_mant_f32_e64 v5, src_scc mul:4  ; encoding: [0x05,0x00,0xc0,0xd5,0xfd,0x00,0x00,0x10]

v_frexp_mant_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_frexp_mant_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xc0,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_frexp_mant_f64_e64 v[5:6], v[1:2]
// GFX12: v_frexp_mant_f64_e64 v[5:6], v[1:2]     ; encoding: [0x05,0x00,0xbd,0xd5,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[254:255]
// GFX12: v_frexp_mant_f64_e64 v[5:6], v[254:255] ; encoding: [0x05,0x00,0xbd,0xd5,0xfe,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[2:3]
// GFX12: v_frexp_mant_f64_e64 v[5:6], s[2:3]     ; encoding: [0x05,0x00,0xbd,0xd5,0x02,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[104:105]
// GFX12: v_frexp_mant_f64_e64 v[5:6], s[104:105] ; encoding: [0x05,0x00,0xbd,0xd5,0x68,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], vcc
// GFX12: v_frexp_mant_f64_e64 v[5:6], vcc        ; encoding: [0x05,0x00,0xbd,0xd5,0x6a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_frexp_mant_f64_e64 v[5:6], ttmp[14:15] ; encoding: [0x05,0x00,0xbd,0xd5,0x7a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], exec
// GFX12: v_frexp_mant_f64_e64 v[5:6], exec       ; encoding: [0x05,0x00,0xbd,0xd5,0x7e,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], null
// GFX12: v_frexp_mant_f64_e64 v[5:6], null       ; encoding: [0x05,0x00,0xbd,0xd5,0x7c,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -1
// GFX12: v_frexp_mant_f64_e64 v[5:6], -1         ; encoding: [0x05,0x00,0xbd,0xd5,0xc1,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_frexp_mant_f64_e64 v[5:6], 0.5 mul:2  ; encoding: [0x05,0x00,0xbd,0xd5,0xf0,0x00,0x00,0x08]

v_frexp_mant_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_frexp_mant_f64_e64 v[5:6], -|src_scc| mul:4 ; encoding: [0x05,0x01,0xbd,0xd5,0xfd,0x00,0x00,0x30]

v_frexp_mant_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_frexp_mant_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0xbd,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_log_f16_e64 v5, v1
// GFX12: v_log_f16_e64 v5, v1                    ; encoding: [0x05,0x00,0xd7,0xd5,0x01,0x01,0x00,0x00]

v_log_f16_e64 v5, v255
// GFX12: v_log_f16_e64 v5, v255                  ; encoding: [0x05,0x00,0xd7,0xd5,0xff,0x01,0x00,0x00]

v_log_f16_e64 v5, s1
// GFX12: v_log_f16_e64 v5, s1                    ; encoding: [0x05,0x00,0xd7,0xd5,0x01,0x00,0x00,0x00]

v_log_f16_e64 v5, s105
// GFX12: v_log_f16_e64 v5, s105                  ; encoding: [0x05,0x00,0xd7,0xd5,0x69,0x00,0x00,0x00]

v_log_f16_e64 v5, vcc_lo
// GFX12: v_log_f16_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xd7,0xd5,0x6a,0x00,0x00,0x00]

v_log_f16_e64 v5, vcc_hi
// GFX12: v_log_f16_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xd7,0xd5,0x6b,0x00,0x00,0x00]

v_log_f16_e64 v5, ttmp15
// GFX12: v_log_f16_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xd7,0xd5,0x7b,0x00,0x00,0x00]

v_log_f16_e64 v5, m0
// GFX12: v_log_f16_e64 v5, m0                    ; encoding: [0x05,0x00,0xd7,0xd5,0x7d,0x00,0x00,0x00]

v_log_f16_e64 v5, exec_lo
// GFX12: v_log_f16_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xd7,0xd5,0x7e,0x00,0x00,0x00]

v_log_f16_e64 v5, exec_hi
// GFX12: v_log_f16_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xd7,0xd5,0x7f,0x00,0x00,0x00]

v_log_f16_e64 v5, null
// GFX12: v_log_f16_e64 v5, null                  ; encoding: [0x05,0x00,0xd7,0xd5,0x7c,0x00,0x00,0x00]

v_log_f16_e64 v5, -1
// GFX12: v_log_f16_e64 v5, -1                    ; encoding: [0x05,0x00,0xd7,0xd5,0xc1,0x00,0x00,0x00]

v_log_f16_e64 v5, 0.5 mul:2
// GFX12: v_log_f16_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xd7,0xd5,0xf0,0x00,0x00,0x08]

v_log_f16_e64 v5, src_scc mul:4
// GFX12: v_log_f16_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xd7,0xd5,0xfd,0x00,0x00,0x10]

v_log_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_log_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xd7,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_log_f32_e64 v5, v1
// GFX12: v_log_f32_e64 v5, v1                    ; encoding: [0x05,0x00,0xa7,0xd5,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v255
// GFX12: v_log_f32_e64 v5, v255                  ; encoding: [0x05,0x00,0xa7,0xd5,0xff,0x01,0x00,0x00]

v_log_f32_e64 v5, s1
// GFX12: v_log_f32_e64 v5, s1                    ; encoding: [0x05,0x00,0xa7,0xd5,0x01,0x00,0x00,0x00]

v_log_f32_e64 v5, s105
// GFX12: v_log_f32_e64 v5, s105                  ; encoding: [0x05,0x00,0xa7,0xd5,0x69,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_lo
// GFX12: v_log_f32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xa7,0xd5,0x6a,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_hi
// GFX12: v_log_f32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xa7,0xd5,0x6b,0x00,0x00,0x00]

v_log_f32_e64 v5, ttmp15
// GFX12: v_log_f32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xa7,0xd5,0x7b,0x00,0x00,0x00]

v_log_f32_e64 v5, m0
// GFX12: v_log_f32_e64 v5, m0                    ; encoding: [0x05,0x00,0xa7,0xd5,0x7d,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_lo
// GFX12: v_log_f32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xa7,0xd5,0x7e,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_hi
// GFX12: v_log_f32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xa7,0xd5,0x7f,0x00,0x00,0x00]

v_log_f32_e64 v5, null
// GFX12: v_log_f32_e64 v5, null                  ; encoding: [0x05,0x00,0xa7,0xd5,0x7c,0x00,0x00,0x00]

v_log_f32_e64 v5, -1
// GFX12: v_log_f32_e64 v5, -1                    ; encoding: [0x05,0x00,0xa7,0xd5,0xc1,0x00,0x00,0x00]

v_log_f32_e64 v5, 0.5 mul:2
// GFX12: v_log_f32_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xa7,0xd5,0xf0,0x00,0x00,0x08]

v_log_f32_e64 v5, src_scc mul:4
// GFX12: v_log_f32_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xa7,0xd5,0xfd,0x00,0x00,0x10]

v_log_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_log_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xa7,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_mov_b32_e64 v5, v1
// GFX12: v_mov_b32_e64 v5, v1                    ; encoding: [0x05,0x00,0x81,0xd5,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v5, v255
// GFX12: v_mov_b32_e64 v5, v255                  ; encoding: [0x05,0x00,0x81,0xd5,0xff,0x01,0x00,0x00]

v_mov_b32_e64 v5, s1
// GFX12: v_mov_b32_e64 v5, s1                    ; encoding: [0x05,0x00,0x81,0xd5,0x01,0x00,0x00,0x00]

v_mov_b32_e64 v5, s105
// GFX12: v_mov_b32_e64 v5, s105                  ; encoding: [0x05,0x00,0x81,0xd5,0x69,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_lo
// GFX12: v_mov_b32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0x81,0xd5,0x6a,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_hi
// GFX12: v_mov_b32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0x81,0xd5,0x6b,0x00,0x00,0x00]

v_mov_b32_e64 v5, ttmp15
// GFX12: v_mov_b32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0x81,0xd5,0x7b,0x00,0x00,0x00]

v_mov_b32_e64 v5, m0
// GFX12: v_mov_b32_e64 v5, m0                    ; encoding: [0x05,0x00,0x81,0xd5,0x7d,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_lo
// GFX12: v_mov_b32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0x81,0xd5,0x7e,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_hi
// GFX12: v_mov_b32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0x81,0xd5,0x7f,0x00,0x00,0x00]

v_mov_b32_e64 v5, null
// GFX12: v_mov_b32_e64 v5, null                  ; encoding: [0x05,0x00,0x81,0xd5,0x7c,0x00,0x00,0x00]

v_mov_b32_e64 v5, -1
// GFX12: v_mov_b32_e64 v5, -1                    ; encoding: [0x05,0x00,0x81,0xd5,0xc1,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0.5
// GFX12: v_mov_b32_e64 v5, 0.5                   ; encoding: [0x05,0x00,0x81,0xd5,0xf0,0x00,0x00,0x00]

v_mov_b32_e64 v5, src_scc
// GFX12: v_mov_b32_e64 v5, src_scc               ; encoding: [0x05,0x00,0x81,0xd5,0xfd,0x00,0x00,0x00]

v_mov_b32_e64 v255, 0xaf123456
// GFX12: v_mov_b32_e64 v255, 0xaf123456          ; encoding: [0xff,0x00,0x81,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_movreld_b32_e64 v5, v1
// GFX12: v_movreld_b32_e64 v5, v1                ; encoding: [0x05,0x00,0xc2,0xd5,0x01,0x01,0x00,0x00]

v_movreld_b32_e64 v5, v255
// GFX12: v_movreld_b32_e64 v5, v255              ; encoding: [0x05,0x00,0xc2,0xd5,0xff,0x01,0x00,0x00]

v_movreld_b32_e64 v5, s1
// GFX12: v_movreld_b32_e64 v5, s1                ; encoding: [0x05,0x00,0xc2,0xd5,0x01,0x00,0x00,0x00]

v_movreld_b32_e64 v5, s105
// GFX12: v_movreld_b32_e64 v5, s105              ; encoding: [0x05,0x00,0xc2,0xd5,0x69,0x00,0x00,0x00]

v_movreld_b32_e64 v5, vcc_lo
// GFX12: v_movreld_b32_e64 v5, vcc_lo            ; encoding: [0x05,0x00,0xc2,0xd5,0x6a,0x00,0x00,0x00]

v_movreld_b32_e64 v5, vcc_hi
// GFX12: v_movreld_b32_e64 v5, vcc_hi            ; encoding: [0x05,0x00,0xc2,0xd5,0x6b,0x00,0x00,0x00]

v_movreld_b32_e64 v5, ttmp15
// GFX12: v_movreld_b32_e64 v5, ttmp15            ; encoding: [0x05,0x00,0xc2,0xd5,0x7b,0x00,0x00,0x00]

v_movreld_b32_e64 v5, m0
// GFX12: v_movreld_b32_e64 v5, m0                ; encoding: [0x05,0x00,0xc2,0xd5,0x7d,0x00,0x00,0x00]

v_movreld_b32_e64 v5, exec_lo
// GFX12: v_movreld_b32_e64 v5, exec_lo           ; encoding: [0x05,0x00,0xc2,0xd5,0x7e,0x00,0x00,0x00]

v_movreld_b32_e64 v5, exec_hi
// GFX12: v_movreld_b32_e64 v5, exec_hi           ; encoding: [0x05,0x00,0xc2,0xd5,0x7f,0x00,0x00,0x00]

v_movreld_b32_e64 v5, null
// GFX12: v_movreld_b32_e64 v5, null              ; encoding: [0x05,0x00,0xc2,0xd5,0x7c,0x00,0x00,0x00]

v_movreld_b32_e64 v5, -1
// GFX12: v_movreld_b32_e64 v5, -1                ; encoding: [0x05,0x00,0xc2,0xd5,0xc1,0x00,0x00,0x00]

v_movreld_b32_e64 v5, 0.5
// GFX12: v_movreld_b32_e64 v5, 0.5               ; encoding: [0x05,0x00,0xc2,0xd5,0xf0,0x00,0x00,0x00]

v_movreld_b32_e64 v5, src_scc
// GFX12: v_movreld_b32_e64 v5, src_scc           ; encoding: [0x05,0x00,0xc2,0xd5,0xfd,0x00,0x00,0x00]

v_movreld_b32_e64 v255, 0xaf123456
// GFX12: v_movreld_b32_e64 v255, 0xaf123456      ; encoding: [0xff,0x00,0xc2,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_movrels_b32_e64 v5, v1
// GFX12: v_movrels_b32_e64 v5, v1                ; encoding: [0x05,0x00,0xc3,0xd5,0x01,0x01,0x00,0x00]

v_movrels_b32_e64 v255, v255
// GFX12: v_movrels_b32_e64 v255, v255            ; encoding: [0xff,0x00,0xc3,0xd5,0xff,0x01,0x00,0x00]

v_movrelsd_2_b32_e64 v5, v1
// GFX12: v_movrelsd_2_b32_e64 v5, v1             ; encoding: [0x05,0x00,0xc8,0xd5,0x01,0x01,0x00,0x00]

v_movrelsd_2_b32_e64 v255, v255
// GFX12: v_movrelsd_2_b32_e64 v255, v255         ; encoding: [0xff,0x00,0xc8,0xd5,0xff,0x01,0x00,0x00]

v_movrelsd_b32_e64 v5, v1
// GFX12: v_movrelsd_b32_e64 v5, v1               ; encoding: [0x05,0x00,0xc4,0xd5,0x01,0x01,0x00,0x00]

v_movrelsd_b32_e64 v255, v255
// GFX12: v_movrelsd_b32_e64 v255, v255           ; encoding: [0xff,0x00,0xc4,0xd5,0xff,0x01,0x00,0x00]

v_nop_e64
// GFX12: v_nop                                   ; encoding: [0x00,0x00,0x80,0xd5,0x00,0x00,0x00,0x00]

v_not_b16_e64 v5.l, v1.l
// GFX12: v_not_b16_e64 v5.l, v1.l                ; encoding: [0x05,0x00,0xe9,0xd5,0x01,0x01,0x00,0x00]

v_not_b16_e64 v5.l, v255.l
// GFX12: v_not_b16_e64 v5.l, v255.l              ; encoding: [0x05,0x00,0xe9,0xd5,0xff,0x01,0x00,0x00]

v_not_b16_e64 v5.l, s1
// GFX12: v_not_b16_e64 v5.l, s1                  ; encoding: [0x05,0x00,0xe9,0xd5,0x01,0x00,0x00,0x00]

v_not_b16_e64 v5.l, s105
// GFX12: v_not_b16_e64 v5.l, s105                ; encoding: [0x05,0x00,0xe9,0xd5,0x69,0x00,0x00,0x00]

v_not_b16_e64 v5.l, vcc_lo
// GFX12: v_not_b16_e64 v5.l, vcc_lo              ; encoding: [0x05,0x00,0xe9,0xd5,0x6a,0x00,0x00,0x00]

v_not_b16_e64 v5.l, vcc_hi
// GFX12: v_not_b16_e64 v5.l, vcc_hi              ; encoding: [0x05,0x00,0xe9,0xd5,0x6b,0x00,0x00,0x00]

v_not_b16_e64 v5.l, ttmp15
// GFX12: v_not_b16_e64 v5.l, ttmp15              ; encoding: [0x05,0x00,0xe9,0xd5,0x7b,0x00,0x00,0x00]

v_not_b16_e64 v5.l, m0
// GFX12: v_not_b16_e64 v5.l, m0                  ; encoding: [0x05,0x00,0xe9,0xd5,0x7d,0x00,0x00,0x00]

v_not_b16_e64 v5.l, exec_lo
// GFX12: v_not_b16_e64 v5.l, exec_lo             ; encoding: [0x05,0x00,0xe9,0xd5,0x7e,0x00,0x00,0x00]

v_not_b16_e64 v5.l, exec_hi
// GFX12: v_not_b16_e64 v5.l, exec_hi             ; encoding: [0x05,0x00,0xe9,0xd5,0x7f,0x00,0x00,0x00]

v_not_b16_e64 v5.l, null
// GFX12: v_not_b16_e64 v5.l, null                ; encoding: [0x05,0x00,0xe9,0xd5,0x7c,0x00,0x00,0x00]

v_not_b16_e64 v5.l, -1
// GFX12: v_not_b16_e64 v5.l, -1                  ; encoding: [0x05,0x00,0xe9,0xd5,0xc1,0x00,0x00,0x00]

v_not_b16_e64 v5.l, 0.5
// GFX12: v_not_b16_e64 v5.l, 0.5                 ; encoding: [0x05,0x00,0xe9,0xd5,0xf0,0x00,0x00,0x00]

v_not_b16_e64 v5.l, src_scc
// GFX12: v_not_b16_e64 v5.l, src_scc             ; encoding: [0x05,0x00,0xe9,0xd5,0xfd,0x00,0x00,0x00]

v_not_b16_e64 v255.l, 0xfe0b
// GFX12: v_not_b16_e64 v255.l, 0xfe0b            ; encoding: [0xff,0x00,0xe9,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_not_b16_e64 v5.h, v1.h
// GFX12: v_not_b16_e64 v5.h, v1.h op_sel:[1,1]   ; encoding: [0x05,0x48,0xe9,0xd5,0x01,0x01,0x00,0x00]

v_not_b16_e64 v5.l, v255.h
// GFX12: v_not_b16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xe9,0xd5,0xff,0x01,0x00,0x00]

v_not_b16_e64 v255.h, 0xfe0b
// GFX12: v_not_b16_e64 v255.h, 0xfe0b op_sel:[0,1] ; encoding: [0xff,0x40,0xe9,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_not_b32_e64 v5, v1
// GFX12: v_not_b32_e64 v5, v1                    ; encoding: [0x05,0x00,0xb7,0xd5,0x01,0x01,0x00,0x00]

v_not_b32_e64 v5, v255
// GFX12: v_not_b32_e64 v5, v255                  ; encoding: [0x05,0x00,0xb7,0xd5,0xff,0x01,0x00,0x00]

v_not_b32_e64 v5, s1
// GFX12: v_not_b32_e64 v5, s1                    ; encoding: [0x05,0x00,0xb7,0xd5,0x01,0x00,0x00,0x00]

v_not_b32_e64 v5, s105
// GFX12: v_not_b32_e64 v5, s105                  ; encoding: [0x05,0x00,0xb7,0xd5,0x69,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_lo
// GFX12: v_not_b32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xb7,0xd5,0x6a,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_hi
// GFX12: v_not_b32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xb7,0xd5,0x6b,0x00,0x00,0x00]

v_not_b32_e64 v5, ttmp15
// GFX12: v_not_b32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xb7,0xd5,0x7b,0x00,0x00,0x00]

v_not_b32_e64 v5, m0
// GFX12: v_not_b32_e64 v5, m0                    ; encoding: [0x05,0x00,0xb7,0xd5,0x7d,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_lo
// GFX12: v_not_b32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xb7,0xd5,0x7e,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_hi
// GFX12: v_not_b32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xb7,0xd5,0x7f,0x00,0x00,0x00]

v_not_b32_e64 v5, null
// GFX12: v_not_b32_e64 v5, null                  ; encoding: [0x05,0x00,0xb7,0xd5,0x7c,0x00,0x00,0x00]

v_not_b32_e64 v5, -1
// GFX12: v_not_b32_e64 v5, -1                    ; encoding: [0x05,0x00,0xb7,0xd5,0xc1,0x00,0x00,0x00]

v_not_b32_e64 v5, 0.5
// GFX12: v_not_b32_e64 v5, 0.5                   ; encoding: [0x05,0x00,0xb7,0xd5,0xf0,0x00,0x00,0x00]

v_not_b32_e64 v5, src_scc
// GFX12: v_not_b32_e64 v5, src_scc               ; encoding: [0x05,0x00,0xb7,0xd5,0xfd,0x00,0x00,0x00]

v_not_b32_e64 v255, 0xaf123456
// GFX12: v_not_b32_e64 v255, 0xaf123456          ; encoding: [0xff,0x00,0xb7,0xd5,0xff,0x00,0x00,0x00,0x56,0x34,0x12,0xaf]

v_pipeflush_e64
// GFX12: v_pipeflush                             ; encoding: [0x00,0x00,0x9b,0xd5,0x00,0x00,0x00,0x00]

v_rcp_f16_e64 v5, v1
// GFX12: v_rcp_f16_e64 v5, v1                    ; encoding: [0x05,0x00,0xd4,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f16_e64 v5, v255
// GFX12: v_rcp_f16_e64 v5, v255                  ; encoding: [0x05,0x00,0xd4,0xd5,0xff,0x01,0x00,0x00]

v_rcp_f16_e64 v5, s1
// GFX12: v_rcp_f16_e64 v5, s1                    ; encoding: [0x05,0x00,0xd4,0xd5,0x01,0x00,0x00,0x00]

v_rcp_f16_e64 v5, s105
// GFX12: v_rcp_f16_e64 v5, s105                  ; encoding: [0x05,0x00,0xd4,0xd5,0x69,0x00,0x00,0x00]

v_rcp_f16_e64 v5, vcc_lo
// GFX12: v_rcp_f16_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xd4,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f16_e64 v5, vcc_hi
// GFX12: v_rcp_f16_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xd4,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_f16_e64 v5, ttmp15
// GFX12: v_rcp_f16_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xd4,0xd5,0x7b,0x00,0x00,0x00]

v_rcp_f16_e64 v5, m0
// GFX12: v_rcp_f16_e64 v5, m0                    ; encoding: [0x05,0x00,0xd4,0xd5,0x7d,0x00,0x00,0x00]

v_rcp_f16_e64 v5, exec_lo
// GFX12: v_rcp_f16_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xd4,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f16_e64 v5, exec_hi
// GFX12: v_rcp_f16_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xd4,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_f16_e64 v5, null
// GFX12: v_rcp_f16_e64 v5, null                  ; encoding: [0x05,0x00,0xd4,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_f16_e64 v5, -1
// GFX12: v_rcp_f16_e64 v5, -1                    ; encoding: [0x05,0x00,0xd4,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f16_e64 v5, 0.5 mul:2
// GFX12: v_rcp_f16_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xd4,0xd5,0xf0,0x00,0x00,0x08]

v_rcp_f16_e64 v5, src_scc mul:4
// GFX12: v_rcp_f16_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xd4,0xd5,0xfd,0x00,0x00,0x10]

v_rcp_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_rcp_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xd4,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_rcp_f32_e64 v5, v1
// GFX12: v_rcp_f32_e64 v5, v1                    ; encoding: [0x05,0x00,0xaa,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v255
// GFX12: v_rcp_f32_e64 v5, v255                  ; encoding: [0x05,0x00,0xaa,0xd5,0xff,0x01,0x00,0x00]

v_rcp_f32_e64 v5, s1
// GFX12: v_rcp_f32_e64 v5, s1                    ; encoding: [0x05,0x00,0xaa,0xd5,0x01,0x00,0x00,0x00]

v_rcp_f32_e64 v5, s105
// GFX12: v_rcp_f32_e64 v5, s105                  ; encoding: [0x05,0x00,0xaa,0xd5,0x69,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_lo
// GFX12: v_rcp_f32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xaa,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_hi
// GFX12: v_rcp_f32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xaa,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, ttmp15
// GFX12: v_rcp_f32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xaa,0xd5,0x7b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, m0
// GFX12: v_rcp_f32_e64 v5, m0                    ; encoding: [0x05,0x00,0xaa,0xd5,0x7d,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_lo
// GFX12: v_rcp_f32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xaa,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_hi
// GFX12: v_rcp_f32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xaa,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, null
// GFX12: v_rcp_f32_e64 v5, null                  ; encoding: [0x05,0x00,0xaa,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -1
// GFX12: v_rcp_f32_e64 v5, -1                    ; encoding: [0x05,0x00,0xaa,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0.5 mul:2
// GFX12: v_rcp_f32_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xaa,0xd5,0xf0,0x00,0x00,0x08]

v_rcp_f32_e64 v5, src_scc mul:4
// GFX12: v_rcp_f32_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xaa,0xd5,0xfd,0x00,0x00,0x10]

v_rcp_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_rcp_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xaa,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_rcp_f64_e64 v[5:6], v[1:2]
// GFX12: v_rcp_f64_e64 v[5:6], v[1:2]            ; encoding: [0x05,0x00,0xaf,0xd5,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[254:255]
// GFX12: v_rcp_f64_e64 v[5:6], v[254:255]        ; encoding: [0x05,0x00,0xaf,0xd5,0xfe,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[2:3]
// GFX12: v_rcp_f64_e64 v[5:6], s[2:3]            ; encoding: [0x05,0x00,0xaf,0xd5,0x02,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[104:105]
// GFX12: v_rcp_f64_e64 v[5:6], s[104:105]        ; encoding: [0x05,0x00,0xaf,0xd5,0x68,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], vcc
// GFX12: v_rcp_f64_e64 v[5:6], vcc               ; encoding: [0x05,0x00,0xaf,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_rcp_f64_e64 v[5:6], ttmp[14:15]       ; encoding: [0x05,0x00,0xaf,0xd5,0x7a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], exec
// GFX12: v_rcp_f64_e64 v[5:6], exec              ; encoding: [0x05,0x00,0xaf,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], null
// GFX12: v_rcp_f64_e64 v[5:6], null              ; encoding: [0x05,0x00,0xaf,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -1
// GFX12: v_rcp_f64_e64 v[5:6], -1                ; encoding: [0x05,0x00,0xaf,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_rcp_f64_e64 v[5:6], 0.5 mul:2         ; encoding: [0x05,0x00,0xaf,0xd5,0xf0,0x00,0x00,0x08]

v_rcp_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_rcp_f64_e64 v[5:6], -|src_scc| mul:4  ; encoding: [0x05,0x01,0xaf,0xd5,0xfd,0x00,0x00,0x30]

v_rcp_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_rcp_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0xaf,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_rcp_iflag_f32_e64 v5, v1
// GFX12: v_rcp_iflag_f32_e64 v5, v1              ; encoding: [0x05,0x00,0xab,0xd5,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v255
// GFX12: v_rcp_iflag_f32_e64 v5, v255            ; encoding: [0x05,0x00,0xab,0xd5,0xff,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s1
// GFX12: v_rcp_iflag_f32_e64 v5, s1              ; encoding: [0x05,0x00,0xab,0xd5,0x01,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s105
// GFX12: v_rcp_iflag_f32_e64 v5, s105            ; encoding: [0x05,0x00,0xab,0xd5,0x69,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_lo
// GFX12: v_rcp_iflag_f32_e64 v5, vcc_lo          ; encoding: [0x05,0x00,0xab,0xd5,0x6a,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_hi
// GFX12: v_rcp_iflag_f32_e64 v5, vcc_hi          ; encoding: [0x05,0x00,0xab,0xd5,0x6b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, ttmp15
// GFX12: v_rcp_iflag_f32_e64 v5, ttmp15          ; encoding: [0x05,0x00,0xab,0xd5,0x7b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, m0
// GFX12: v_rcp_iflag_f32_e64 v5, m0              ; encoding: [0x05,0x00,0xab,0xd5,0x7d,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_lo
// GFX12: v_rcp_iflag_f32_e64 v5, exec_lo         ; encoding: [0x05,0x00,0xab,0xd5,0x7e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_hi
// GFX12: v_rcp_iflag_f32_e64 v5, exec_hi         ; encoding: [0x05,0x00,0xab,0xd5,0x7f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, null
// GFX12: v_rcp_iflag_f32_e64 v5, null            ; encoding: [0x05,0x00,0xab,0xd5,0x7c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -1
// GFX12: v_rcp_iflag_f32_e64 v5, -1              ; encoding: [0x05,0x00,0xab,0xd5,0xc1,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0.5 mul:2
// GFX12: v_rcp_iflag_f32_e64 v5, 0.5 mul:2       ; encoding: [0x05,0x00,0xab,0xd5,0xf0,0x00,0x00,0x08]

v_rcp_iflag_f32_e64 v5, src_scc mul:4
// GFX12: v_rcp_iflag_f32_e64 v5, src_scc mul:4   ; encoding: [0x05,0x00,0xab,0xd5,0xfd,0x00,0x00,0x10]

v_rcp_iflag_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_rcp_iflag_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xab,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_rndne_f16_e64 v5.l, v1.l
// GFX12: v_rndne_f16_e64 v5.l, v1.l              ; encoding: [0x05,0x00,0xde,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v5.l, v255.l
// GFX12: v_rndne_f16_e64 v5.l, v255.l            ; encoding: [0x05,0x00,0xde,0xd5,0xff,0x01,0x00,0x00]

v_rndne_f16_e64 v5.l, s1
// GFX12: v_rndne_f16_e64 v5.l, s1                ; encoding: [0x05,0x00,0xde,0xd5,0x01,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, s105
// GFX12: v_rndne_f16_e64 v5.l, s105              ; encoding: [0x05,0x00,0xde,0xd5,0x69,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, vcc_lo
// GFX12: v_rndne_f16_e64 v5.l, vcc_lo            ; encoding: [0x05,0x00,0xde,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, vcc_hi
// GFX12: v_rndne_f16_e64 v5.l, vcc_hi            ; encoding: [0x05,0x00,0xde,0xd5,0x6b,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, ttmp15
// GFX12: v_rndne_f16_e64 v5.l, ttmp15            ; encoding: [0x05,0x00,0xde,0xd5,0x7b,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, m0
// GFX12: v_rndne_f16_e64 v5.l, m0                ; encoding: [0x05,0x00,0xde,0xd5,0x7d,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, exec_lo
// GFX12: v_rndne_f16_e64 v5.l, exec_lo           ; encoding: [0x05,0x00,0xde,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, exec_hi
// GFX12: v_rndne_f16_e64 v5.l, exec_hi           ; encoding: [0x05,0x00,0xde,0xd5,0x7f,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, null
// GFX12: v_rndne_f16_e64 v5.l, null              ; encoding: [0x05,0x00,0xde,0xd5,0x7c,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, -1
// GFX12: v_rndne_f16_e64 v5.l, -1                ; encoding: [0x05,0x00,0xde,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f16_e64 v5.l, 0.5 mul:2
// GFX12: v_rndne_f16_e64 v5.l, 0.5 mul:2         ; encoding: [0x05,0x00,0xde,0xd5,0xf0,0x00,0x00,0x08]

v_rndne_f16_e64 v5.l, src_scc mul:4
// GFX12: v_rndne_f16_e64 v5.l, src_scc mul:4     ; encoding: [0x05,0x00,0xde,0xd5,0xfd,0x00,0x00,0x10]

v_rndne_f16_e64 v255.l, -|0xfe0b| clamp div:2
// GFX12: v_rndne_f16_e64 v255.l, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xde,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_rndne_f16_e64 v5.h, v1.h
// GFX12: v_rndne_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xde,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f16_e64 v5.l, v255.h
// GFX12: v_rndne_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xde,0xd5,0xff,0x01,0x00,0x00]

v_rndne_f16_e64 v255.h, -|0xfe0b| clamp div:2
// GFX12: v_rndne_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc1,0xde,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_rndne_f32_e64 v5, v1
// GFX12: v_rndne_f32_e64 v5, v1                  ; encoding: [0x05,0x00,0xa3,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v255
// GFX12: v_rndne_f32_e64 v5, v255                ; encoding: [0x05,0x00,0xa3,0xd5,0xff,0x01,0x00,0x00]

v_rndne_f32_e64 v5, s1
// GFX12: v_rndne_f32_e64 v5, s1                  ; encoding: [0x05,0x00,0xa3,0xd5,0x01,0x00,0x00,0x00]

v_rndne_f32_e64 v5, s105
// GFX12: v_rndne_f32_e64 v5, s105                ; encoding: [0x05,0x00,0xa3,0xd5,0x69,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_lo
// GFX12: v_rndne_f32_e64 v5, vcc_lo              ; encoding: [0x05,0x00,0xa3,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_hi
// GFX12: v_rndne_f32_e64 v5, vcc_hi              ; encoding: [0x05,0x00,0xa3,0xd5,0x6b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, ttmp15
// GFX12: v_rndne_f32_e64 v5, ttmp15              ; encoding: [0x05,0x00,0xa3,0xd5,0x7b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, m0
// GFX12: v_rndne_f32_e64 v5, m0                  ; encoding: [0x05,0x00,0xa3,0xd5,0x7d,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_lo
// GFX12: v_rndne_f32_e64 v5, exec_lo             ; encoding: [0x05,0x00,0xa3,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_hi
// GFX12: v_rndne_f32_e64 v5, exec_hi             ; encoding: [0x05,0x00,0xa3,0xd5,0x7f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, null
// GFX12: v_rndne_f32_e64 v5, null                ; encoding: [0x05,0x00,0xa3,0xd5,0x7c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -1
// GFX12: v_rndne_f32_e64 v5, -1                  ; encoding: [0x05,0x00,0xa3,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0.5 mul:2
// GFX12: v_rndne_f32_e64 v5, 0.5 mul:2           ; encoding: [0x05,0x00,0xa3,0xd5,0xf0,0x00,0x00,0x08]

v_rndne_f32_e64 v5, src_scc mul:4
// GFX12: v_rndne_f32_e64 v5, src_scc mul:4       ; encoding: [0x05,0x00,0xa3,0xd5,0xfd,0x00,0x00,0x10]

v_rndne_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_rndne_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xa3,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_rndne_f64_e64 v[5:6], v[1:2]
// GFX12: v_rndne_f64_e64 v[5:6], v[1:2]          ; encoding: [0x05,0x00,0x99,0xd5,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[254:255]
// GFX12: v_rndne_f64_e64 v[5:6], v[254:255]      ; encoding: [0x05,0x00,0x99,0xd5,0xfe,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[2:3]
// GFX12: v_rndne_f64_e64 v[5:6], s[2:3]          ; encoding: [0x05,0x00,0x99,0xd5,0x02,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[104:105]
// GFX12: v_rndne_f64_e64 v[5:6], s[104:105]      ; encoding: [0x05,0x00,0x99,0xd5,0x68,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], vcc
// GFX12: v_rndne_f64_e64 v[5:6], vcc             ; encoding: [0x05,0x00,0x99,0xd5,0x6a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_rndne_f64_e64 v[5:6], ttmp[14:15]     ; encoding: [0x05,0x00,0x99,0xd5,0x7a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], exec
// GFX12: v_rndne_f64_e64 v[5:6], exec            ; encoding: [0x05,0x00,0x99,0xd5,0x7e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], null
// GFX12: v_rndne_f64_e64 v[5:6], null            ; encoding: [0x05,0x00,0x99,0xd5,0x7c,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -1
// GFX12: v_rndne_f64_e64 v[5:6], -1              ; encoding: [0x05,0x00,0x99,0xd5,0xc1,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_rndne_f64_e64 v[5:6], 0.5 mul:2       ; encoding: [0x05,0x00,0x99,0xd5,0xf0,0x00,0x00,0x08]

v_rndne_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_rndne_f64_e64 v[5:6], -|src_scc| mul:4 ; encoding: [0x05,0x01,0x99,0xd5,0xfd,0x00,0x00,0x30]

v_rndne_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_rndne_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0x99,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_rsq_f16_e64 v5, v1
// GFX12: v_rsq_f16_e64 v5, v1                    ; encoding: [0x05,0x00,0xd6,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f16_e64 v5, v255
// GFX12: v_rsq_f16_e64 v5, v255                  ; encoding: [0x05,0x00,0xd6,0xd5,0xff,0x01,0x00,0x00]

v_rsq_f16_e64 v5, s1
// GFX12: v_rsq_f16_e64 v5, s1                    ; encoding: [0x05,0x00,0xd6,0xd5,0x01,0x00,0x00,0x00]

v_rsq_f16_e64 v5, s105
// GFX12: v_rsq_f16_e64 v5, s105                  ; encoding: [0x05,0x00,0xd6,0xd5,0x69,0x00,0x00,0x00]

v_rsq_f16_e64 v5, vcc_lo
// GFX12: v_rsq_f16_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xd6,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f16_e64 v5, vcc_hi
// GFX12: v_rsq_f16_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xd6,0xd5,0x6b,0x00,0x00,0x00]

v_rsq_f16_e64 v5, ttmp15
// GFX12: v_rsq_f16_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xd6,0xd5,0x7b,0x00,0x00,0x00]

v_rsq_f16_e64 v5, m0
// GFX12: v_rsq_f16_e64 v5, m0                    ; encoding: [0x05,0x00,0xd6,0xd5,0x7d,0x00,0x00,0x00]

v_rsq_f16_e64 v5, exec_lo
// GFX12: v_rsq_f16_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xd6,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f16_e64 v5, exec_hi
// GFX12: v_rsq_f16_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xd6,0xd5,0x7f,0x00,0x00,0x00]

v_rsq_f16_e64 v5, null
// GFX12: v_rsq_f16_e64 v5, null                  ; encoding: [0x05,0x00,0xd6,0xd5,0x7c,0x00,0x00,0x00]

v_rsq_f16_e64 v5, -1
// GFX12: v_rsq_f16_e64 v5, -1                    ; encoding: [0x05,0x00,0xd6,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f16_e64 v5, 0.5 mul:2
// GFX12: v_rsq_f16_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xd6,0xd5,0xf0,0x00,0x00,0x08]

v_rsq_f16_e64 v5, src_scc mul:4
// GFX12: v_rsq_f16_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xd6,0xd5,0xfd,0x00,0x00,0x10]

v_rsq_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_rsq_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xd6,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_rsq_f32_e64 v5, v1
// GFX12: v_rsq_f32_e64 v5, v1                    ; encoding: [0x05,0x00,0xae,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v255
// GFX12: v_rsq_f32_e64 v5, v255                  ; encoding: [0x05,0x00,0xae,0xd5,0xff,0x01,0x00,0x00]

v_rsq_f32_e64 v5, s1
// GFX12: v_rsq_f32_e64 v5, s1                    ; encoding: [0x05,0x00,0xae,0xd5,0x01,0x00,0x00,0x00]

v_rsq_f32_e64 v5, s105
// GFX12: v_rsq_f32_e64 v5, s105                  ; encoding: [0x05,0x00,0xae,0xd5,0x69,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_lo
// GFX12: v_rsq_f32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xae,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_hi
// GFX12: v_rsq_f32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xae,0xd5,0x6b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, ttmp15
// GFX12: v_rsq_f32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xae,0xd5,0x7b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, m0
// GFX12: v_rsq_f32_e64 v5, m0                    ; encoding: [0x05,0x00,0xae,0xd5,0x7d,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_lo
// GFX12: v_rsq_f32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xae,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_hi
// GFX12: v_rsq_f32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xae,0xd5,0x7f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, null
// GFX12: v_rsq_f32_e64 v5, null                  ; encoding: [0x05,0x00,0xae,0xd5,0x7c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -1
// GFX12: v_rsq_f32_e64 v5, -1                    ; encoding: [0x05,0x00,0xae,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0.5 mul:2
// GFX12: v_rsq_f32_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xae,0xd5,0xf0,0x00,0x00,0x08]

v_rsq_f32_e64 v5, src_scc mul:4
// GFX12: v_rsq_f32_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xae,0xd5,0xfd,0x00,0x00,0x10]

v_rsq_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_rsq_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xae,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_rsq_f64_e64 v[5:6], v[1:2]
// GFX12: v_rsq_f64_e64 v[5:6], v[1:2]            ; encoding: [0x05,0x00,0xb1,0xd5,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[254:255]
// GFX12: v_rsq_f64_e64 v[5:6], v[254:255]        ; encoding: [0x05,0x00,0xb1,0xd5,0xfe,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[2:3]
// GFX12: v_rsq_f64_e64 v[5:6], s[2:3]            ; encoding: [0x05,0x00,0xb1,0xd5,0x02,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[104:105]
// GFX12: v_rsq_f64_e64 v[5:6], s[104:105]        ; encoding: [0x05,0x00,0xb1,0xd5,0x68,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], vcc
// GFX12: v_rsq_f64_e64 v[5:6], vcc               ; encoding: [0x05,0x00,0xb1,0xd5,0x6a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_rsq_f64_e64 v[5:6], ttmp[14:15]       ; encoding: [0x05,0x00,0xb1,0xd5,0x7a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], exec
// GFX12: v_rsq_f64_e64 v[5:6], exec              ; encoding: [0x05,0x00,0xb1,0xd5,0x7e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], null
// GFX12: v_rsq_f64_e64 v[5:6], null              ; encoding: [0x05,0x00,0xb1,0xd5,0x7c,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -1
// GFX12: v_rsq_f64_e64 v[5:6], -1                ; encoding: [0x05,0x00,0xb1,0xd5,0xc1,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_rsq_f64_e64 v[5:6], 0.5 mul:2         ; encoding: [0x05,0x00,0xb1,0xd5,0xf0,0x00,0x00,0x08]

v_rsq_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_rsq_f64_e64 v[5:6], -|src_scc| mul:4  ; encoding: [0x05,0x01,0xb1,0xd5,0xfd,0x00,0x00,0x30]

v_rsq_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_rsq_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0xb1,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_sat_pk_u8_i16_e64 v5, v1
// GFX12: v_sat_pk_u8_i16_e64 v5, v1              ; encoding: [0x05,0x00,0xe2,0xd5,0x01,0x01,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, v255
// GFX12: v_sat_pk_u8_i16_e64 v5, v255            ; encoding: [0x05,0x00,0xe2,0xd5,0xff,0x01,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, s1
// GFX12: v_sat_pk_u8_i16_e64 v5, s1              ; encoding: [0x05,0x00,0xe2,0xd5,0x01,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, s105
// GFX12: v_sat_pk_u8_i16_e64 v5, s105            ; encoding: [0x05,0x00,0xe2,0xd5,0x69,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, vcc_lo
// GFX12: v_sat_pk_u8_i16_e64 v5, vcc_lo          ; encoding: [0x05,0x00,0xe2,0xd5,0x6a,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, vcc_hi
// GFX12: v_sat_pk_u8_i16_e64 v5, vcc_hi          ; encoding: [0x05,0x00,0xe2,0xd5,0x6b,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, ttmp15
// GFX12: v_sat_pk_u8_i16_e64 v5, ttmp15          ; encoding: [0x05,0x00,0xe2,0xd5,0x7b,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, m0
// GFX12: v_sat_pk_u8_i16_e64 v5, m0              ; encoding: [0x05,0x00,0xe2,0xd5,0x7d,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, exec_lo
// GFX12: v_sat_pk_u8_i16_e64 v5, exec_lo         ; encoding: [0x05,0x00,0xe2,0xd5,0x7e,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, exec_hi
// GFX12: v_sat_pk_u8_i16_e64 v5, exec_hi         ; encoding: [0x05,0x00,0xe2,0xd5,0x7f,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, null
// GFX12: v_sat_pk_u8_i16_e64 v5, null            ; encoding: [0x05,0x00,0xe2,0xd5,0x7c,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, -1
// GFX12: v_sat_pk_u8_i16_e64 v5, -1              ; encoding: [0x05,0x00,0xe2,0xd5,0xc1,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, 0.5
// GFX12: v_sat_pk_u8_i16_e64 v5, 0.5             ; encoding: [0x05,0x00,0xe2,0xd5,0xf0,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v5, src_scc
// GFX12: v_sat_pk_u8_i16_e64 v5, src_scc         ; encoding: [0x05,0x00,0xe2,0xd5,0xfd,0x00,0x00,0x00]

v_sat_pk_u8_i16_e64 v255, 0xfe0b
// GFX12: v_sat_pk_u8_i16_e64 v255, 0xfe0b        ; encoding: [0xff,0x00,0xe2,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_sat_pk_u8_i16_e64 v255.h, 0xfe0b
// GFX12: v_sat_pk_u8_i16_e64 v255.h, 0xfe0b op_sel:[0,1] ; encoding: [0xff,0x40,0xe2,0xd5,0xff,0x00,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_sin_f16_e64 v5.l, v1.l
// GFX12: v_sin_f16_e64 v5.l, v1.l                ; encoding: [0x05,0x00,0xe0,0xd5,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v5.l, v255.l
// GFX12: v_sin_f16_e64 v5.l, v255.l              ; encoding: [0x05,0x00,0xe0,0xd5,0xff,0x01,0x00,0x00]

v_sin_f16_e64 v5.l, s1
// GFX12: v_sin_f16_e64 v5.l, s1                  ; encoding: [0x05,0x00,0xe0,0xd5,0x01,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, s105
// GFX12: v_sin_f16_e64 v5.l, s105                ; encoding: [0x05,0x00,0xe0,0xd5,0x69,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, vcc_lo
// GFX12: v_sin_f16_e64 v5.l, vcc_lo              ; encoding: [0x05,0x00,0xe0,0xd5,0x6a,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, vcc_hi
// GFX12: v_sin_f16_e64 v5.l, vcc_hi              ; encoding: [0x05,0x00,0xe0,0xd5,0x6b,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, ttmp15
// GFX12: v_sin_f16_e64 v5.l, ttmp15              ; encoding: [0x05,0x00,0xe0,0xd5,0x7b,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, m0
// GFX12: v_sin_f16_e64 v5.l, m0                  ; encoding: [0x05,0x00,0xe0,0xd5,0x7d,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, exec_lo
// GFX12: v_sin_f16_e64 v5.l, exec_lo             ; encoding: [0x05,0x00,0xe0,0xd5,0x7e,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, exec_hi
// GFX12: v_sin_f16_e64 v5.l, exec_hi             ; encoding: [0x05,0x00,0xe0,0xd5,0x7f,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, null
// GFX12: v_sin_f16_e64 v5.l, null                ; encoding: [0x05,0x00,0xe0,0xd5,0x7c,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, -1
// GFX12: v_sin_f16_e64 v5.l, -1                  ; encoding: [0x05,0x00,0xe0,0xd5,0xc1,0x00,0x00,0x00]

v_sin_f16_e64 v5.l, 0.5 mul:2
// GFX12: v_sin_f16_e64 v5.l, 0.5 mul:2           ; encoding: [0x05,0x00,0xe0,0xd5,0xf0,0x00,0x00,0x08]

v_sin_f16_e64 v5.l, src_scc mul:4
// GFX12: v_sin_f16_e64 v5.l, src_scc mul:4       ; encoding: [0x05,0x00,0xe0,0xd5,0xfd,0x00,0x00,0x10]

v_sin_f16_e64 v255.l, -|0xfe0b| clamp div:2
// GFX12: v_sin_f16_e64 v255.l, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xe0,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_sin_f16_e64 v5.h, v1.h
// GFX12: v_sin_f16_e64 v5.h, v1.h op_sel:[1,1]   ; encoding: [0x05,0x48,0xe0,0xd5,0x01,0x01,0x00,0x00]

v_sin_f16_e64 v5.l, v255.h
// GFX12: v_sin_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xe0,0xd5,0xff,0x01,0x00,0x00]

v_sin_f16_e64 v255.h, -|0xfe0b| clamp div:2
// GFX12: v_sin_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc1,0xe0,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_sin_f32_e64 v5, v1
// GFX12: v_sin_f32_e64 v5, v1                    ; encoding: [0x05,0x00,0xb5,0xd5,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v255
// GFX12: v_sin_f32_e64 v5, v255                  ; encoding: [0x05,0x00,0xb5,0xd5,0xff,0x01,0x00,0x00]

v_sin_f32_e64 v5, s1
// GFX12: v_sin_f32_e64 v5, s1                    ; encoding: [0x05,0x00,0xb5,0xd5,0x01,0x00,0x00,0x00]

v_sin_f32_e64 v5, s105
// GFX12: v_sin_f32_e64 v5, s105                  ; encoding: [0x05,0x00,0xb5,0xd5,0x69,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_lo
// GFX12: v_sin_f32_e64 v5, vcc_lo                ; encoding: [0x05,0x00,0xb5,0xd5,0x6a,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_hi
// GFX12: v_sin_f32_e64 v5, vcc_hi                ; encoding: [0x05,0x00,0xb5,0xd5,0x6b,0x00,0x00,0x00]

v_sin_f32_e64 v5, ttmp15
// GFX12: v_sin_f32_e64 v5, ttmp15                ; encoding: [0x05,0x00,0xb5,0xd5,0x7b,0x00,0x00,0x00]

v_sin_f32_e64 v5, m0
// GFX12: v_sin_f32_e64 v5, m0                    ; encoding: [0x05,0x00,0xb5,0xd5,0x7d,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_lo
// GFX12: v_sin_f32_e64 v5, exec_lo               ; encoding: [0x05,0x00,0xb5,0xd5,0x7e,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_hi
// GFX12: v_sin_f32_e64 v5, exec_hi               ; encoding: [0x05,0x00,0xb5,0xd5,0x7f,0x00,0x00,0x00]

v_sin_f32_e64 v5, null
// GFX12: v_sin_f32_e64 v5, null                  ; encoding: [0x05,0x00,0xb5,0xd5,0x7c,0x00,0x00,0x00]

v_sin_f32_e64 v5, -1
// GFX12: v_sin_f32_e64 v5, -1                    ; encoding: [0x05,0x00,0xb5,0xd5,0xc1,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0.5 mul:2
// GFX12: v_sin_f32_e64 v5, 0.5 mul:2             ; encoding: [0x05,0x00,0xb5,0xd5,0xf0,0x00,0x00,0x08]

v_sin_f32_e64 v5, src_scc mul:4
// GFX12: v_sin_f32_e64 v5, src_scc mul:4         ; encoding: [0x05,0x00,0xb5,0xd5,0xfd,0x00,0x00,0x10]

v_sin_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_sin_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xb5,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_sqrt_f16_e64 v5, v1
// GFX12: v_sqrt_f16_e64 v5, v1                   ; encoding: [0x05,0x00,0xd5,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, v255
// GFX12: v_sqrt_f16_e64 v5, v255                 ; encoding: [0x05,0x00,0xd5,0xd5,0xff,0x01,0x00,0x00]

v_sqrt_f16_e64 v5, s1
// GFX12: v_sqrt_f16_e64 v5, s1                   ; encoding: [0x05,0x00,0xd5,0xd5,0x01,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, s105
// GFX12: v_sqrt_f16_e64 v5, s105                 ; encoding: [0x05,0x00,0xd5,0xd5,0x69,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, vcc_lo
// GFX12: v_sqrt_f16_e64 v5, vcc_lo               ; encoding: [0x05,0x00,0xd5,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, vcc_hi
// GFX12: v_sqrt_f16_e64 v5, vcc_hi               ; encoding: [0x05,0x00,0xd5,0xd5,0x6b,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, ttmp15
// GFX12: v_sqrt_f16_e64 v5, ttmp15               ; encoding: [0x05,0x00,0xd5,0xd5,0x7b,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, m0
// GFX12: v_sqrt_f16_e64 v5, m0                   ; encoding: [0x05,0x00,0xd5,0xd5,0x7d,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, exec_lo
// GFX12: v_sqrt_f16_e64 v5, exec_lo              ; encoding: [0x05,0x00,0xd5,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, exec_hi
// GFX12: v_sqrt_f16_e64 v5, exec_hi              ; encoding: [0x05,0x00,0xd5,0xd5,0x7f,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, null
// GFX12: v_sqrt_f16_e64 v5, null                 ; encoding: [0x05,0x00,0xd5,0xd5,0x7c,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, -1
// GFX12: v_sqrt_f16_e64 v5, -1                   ; encoding: [0x05,0x00,0xd5,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f16_e64 v5, 0.5 mul:2
// GFX12: v_sqrt_f16_e64 v5, 0.5 mul:2            ; encoding: [0x05,0x00,0xd5,0xd5,0xf0,0x00,0x00,0x08]

v_sqrt_f16_e64 v5, src_scc mul:4
// GFX12: v_sqrt_f16_e64 v5, src_scc mul:4        ; encoding: [0x05,0x00,0xd5,0xd5,0xfd,0x00,0x00,0x10]

v_sqrt_f16_e64 v255, -|0xfe0b| clamp div:2
// GFX12: v_sqrt_f16_e64 v255, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xd5,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_sqrt_f32_e64 v5, v1
// GFX12: v_sqrt_f32_e64 v5, v1                   ; encoding: [0x05,0x00,0xb3,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v255
// GFX12: v_sqrt_f32_e64 v5, v255                 ; encoding: [0x05,0x00,0xb3,0xd5,0xff,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, s1
// GFX12: v_sqrt_f32_e64 v5, s1                   ; encoding: [0x05,0x00,0xb3,0xd5,0x01,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, s105
// GFX12: v_sqrt_f32_e64 v5, s105                 ; encoding: [0x05,0x00,0xb3,0xd5,0x69,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_lo
// GFX12: v_sqrt_f32_e64 v5, vcc_lo               ; encoding: [0x05,0x00,0xb3,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_hi
// GFX12: v_sqrt_f32_e64 v5, vcc_hi               ; encoding: [0x05,0x00,0xb3,0xd5,0x6b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, ttmp15
// GFX12: v_sqrt_f32_e64 v5, ttmp15               ; encoding: [0x05,0x00,0xb3,0xd5,0x7b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, m0
// GFX12: v_sqrt_f32_e64 v5, m0                   ; encoding: [0x05,0x00,0xb3,0xd5,0x7d,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_lo
// GFX12: v_sqrt_f32_e64 v5, exec_lo              ; encoding: [0x05,0x00,0xb3,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_hi
// GFX12: v_sqrt_f32_e64 v5, exec_hi              ; encoding: [0x05,0x00,0xb3,0xd5,0x7f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, null
// GFX12: v_sqrt_f32_e64 v5, null                 ; encoding: [0x05,0x00,0xb3,0xd5,0x7c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -1
// GFX12: v_sqrt_f32_e64 v5, -1                   ; encoding: [0x05,0x00,0xb3,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0.5 mul:2
// GFX12: v_sqrt_f32_e64 v5, 0.5 mul:2            ; encoding: [0x05,0x00,0xb3,0xd5,0xf0,0x00,0x00,0x08]

v_sqrt_f32_e64 v5, src_scc mul:4
// GFX12: v_sqrt_f32_e64 v5, src_scc mul:4        ; encoding: [0x05,0x00,0xb3,0xd5,0xfd,0x00,0x00,0x10]

v_sqrt_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_sqrt_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xb3,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_sqrt_f64_e64 v[5:6], v[1:2]
// GFX12: v_sqrt_f64_e64 v[5:6], v[1:2]           ; encoding: [0x05,0x00,0xb4,0xd5,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[254:255]
// GFX12: v_sqrt_f64_e64 v[5:6], v[254:255]       ; encoding: [0x05,0x00,0xb4,0xd5,0xfe,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[2:3]
// GFX12: v_sqrt_f64_e64 v[5:6], s[2:3]           ; encoding: [0x05,0x00,0xb4,0xd5,0x02,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[104:105]
// GFX12: v_sqrt_f64_e64 v[5:6], s[104:105]       ; encoding: [0x05,0x00,0xb4,0xd5,0x68,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], vcc
// GFX12: v_sqrt_f64_e64 v[5:6], vcc              ; encoding: [0x05,0x00,0xb4,0xd5,0x6a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_sqrt_f64_e64 v[5:6], ttmp[14:15]      ; encoding: [0x05,0x00,0xb4,0xd5,0x7a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], exec
// GFX12: v_sqrt_f64_e64 v[5:6], exec             ; encoding: [0x05,0x00,0xb4,0xd5,0x7e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], null
// GFX12: v_sqrt_f64_e64 v[5:6], null             ; encoding: [0x05,0x00,0xb4,0xd5,0x7c,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -1
// GFX12: v_sqrt_f64_e64 v[5:6], -1               ; encoding: [0x05,0x00,0xb4,0xd5,0xc1,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_sqrt_f64_e64 v[5:6], 0.5 mul:2        ; encoding: [0x05,0x00,0xb4,0xd5,0xf0,0x00,0x00,0x08]

v_sqrt_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_sqrt_f64_e64 v[5:6], -|src_scc| mul:4 ; encoding: [0x05,0x01,0xb4,0xd5,0xfd,0x00,0x00,0x30]

v_sqrt_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_sqrt_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0xb4,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]

v_trunc_f16_e64 v5.l, v1.l
// GFX12: v_trunc_f16_e64 v5.l, v1.l              ; encoding: [0x05,0x00,0xdd,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v5.l, v255.l
// GFX12: v_trunc_f16_e64 v5.l, v255.l            ; encoding: [0x05,0x00,0xdd,0xd5,0xff,0x01,0x00,0x00]

v_trunc_f16_e64 v5.l, s1
// GFX12: v_trunc_f16_e64 v5.l, s1                ; encoding: [0x05,0x00,0xdd,0xd5,0x01,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, s105
// GFX12: v_trunc_f16_e64 v5.l, s105              ; encoding: [0x05,0x00,0xdd,0xd5,0x69,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, vcc_lo
// GFX12: v_trunc_f16_e64 v5.l, vcc_lo            ; encoding: [0x05,0x00,0xdd,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, vcc_hi
// GFX12: v_trunc_f16_e64 v5.l, vcc_hi            ; encoding: [0x05,0x00,0xdd,0xd5,0x6b,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, ttmp15
// GFX12: v_trunc_f16_e64 v5.l, ttmp15            ; encoding: [0x05,0x00,0xdd,0xd5,0x7b,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, m0
// GFX12: v_trunc_f16_e64 v5.l, m0                ; encoding: [0x05,0x00,0xdd,0xd5,0x7d,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, exec_lo
// GFX12: v_trunc_f16_e64 v5.l, exec_lo           ; encoding: [0x05,0x00,0xdd,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, exec_hi
// GFX12: v_trunc_f16_e64 v5.l, exec_hi           ; encoding: [0x05,0x00,0xdd,0xd5,0x7f,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, null
// GFX12: v_trunc_f16_e64 v5.l, null              ; encoding: [0x05,0x00,0xdd,0xd5,0x7c,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, -1
// GFX12: v_trunc_f16_e64 v5.l, -1                ; encoding: [0x05,0x00,0xdd,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f16_e64 v5.l, 0.5 mul:2
// GFX12: v_trunc_f16_e64 v5.l, 0.5 mul:2         ; encoding: [0x05,0x00,0xdd,0xd5,0xf0,0x00,0x00,0x08]

v_trunc_f16_e64 v5.l, src_scc mul:4
// GFX12: v_trunc_f16_e64 v5.l, src_scc mul:4     ; encoding: [0x05,0x00,0xdd,0xd5,0xfd,0x00,0x00,0x10]

v_trunc_f16_e64 v255.l, -|0xfe0b| clamp div:2
// GFX12: v_trunc_f16_e64 v255.l, -|0xfe0b| clamp div:2 ; encoding: [0xff,0x81,0xdd,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_trunc_f16_e64 v5.h, v1.h
// GFX12: v_trunc_f16_e64 v5.h, v1.h op_sel:[1,1] ; encoding: [0x05,0x48,0xdd,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f16_e64 v5.l, v255.h
// GFX12: v_trunc_f16_e64 v5.l, v255.h op_sel:[1,0] ; encoding: [0x05,0x08,0xdd,0xd5,0xff,0x01,0x00,0x00]

v_trunc_f16_e64 v255.h, -|0xfe0b| clamp div:2
// GFX12: v_trunc_f16_e64 v255.h, -|0xfe0b| op_sel:[0,1] clamp div:2 ; encoding: [0xff,0xc1,0xdd,0xd5,0xff,0x00,0x00,0x38,0x0b,0xfe,0x00,0x00]

v_trunc_f32_e64 v5, v1
// GFX12: v_trunc_f32_e64 v5, v1                  ; encoding: [0x05,0x00,0xa1,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v255
// GFX12: v_trunc_f32_e64 v5, v255                ; encoding: [0x05,0x00,0xa1,0xd5,0xff,0x01,0x00,0x00]

v_trunc_f32_e64 v5, s1
// GFX12: v_trunc_f32_e64 v5, s1                  ; encoding: [0x05,0x00,0xa1,0xd5,0x01,0x00,0x00,0x00]

v_trunc_f32_e64 v5, s105
// GFX12: v_trunc_f32_e64 v5, s105                ; encoding: [0x05,0x00,0xa1,0xd5,0x69,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_lo
// GFX12: v_trunc_f32_e64 v5, vcc_lo              ; encoding: [0x05,0x00,0xa1,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_hi
// GFX12: v_trunc_f32_e64 v5, vcc_hi              ; encoding: [0x05,0x00,0xa1,0xd5,0x6b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, ttmp15
// GFX12: v_trunc_f32_e64 v5, ttmp15              ; encoding: [0x05,0x00,0xa1,0xd5,0x7b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, m0
// GFX12: v_trunc_f32_e64 v5, m0                  ; encoding: [0x05,0x00,0xa1,0xd5,0x7d,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_lo
// GFX12: v_trunc_f32_e64 v5, exec_lo             ; encoding: [0x05,0x00,0xa1,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_hi
// GFX12: v_trunc_f32_e64 v5, exec_hi             ; encoding: [0x05,0x00,0xa1,0xd5,0x7f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, null
// GFX12: v_trunc_f32_e64 v5, null                ; encoding: [0x05,0x00,0xa1,0xd5,0x7c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -1
// GFX12: v_trunc_f32_e64 v5, -1                  ; encoding: [0x05,0x00,0xa1,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0.5 mul:2
// GFX12: v_trunc_f32_e64 v5, 0.5 mul:2           ; encoding: [0x05,0x00,0xa1,0xd5,0xf0,0x00,0x00,0x08]

v_trunc_f32_e64 v5, src_scc mul:4
// GFX12: v_trunc_f32_e64 v5, src_scc mul:4       ; encoding: [0x05,0x00,0xa1,0xd5,0xfd,0x00,0x00,0x10]

v_trunc_f32_e64 v255, -|0xaf123456| clamp div:2
// GFX12: v_trunc_f32_e64 v255, -|0xaf123456| clamp div:2 ; encoding: [0xff,0x81,0xa1,0xd5,0xff,0x00,0x00,0x38,0x56,0x34,0x12,0xaf]

v_trunc_f64_e64 v[5:6], v[1:2]
// GFX12: v_trunc_f64_e64 v[5:6], v[1:2]          ; encoding: [0x05,0x00,0x97,0xd5,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[254:255]
// GFX12: v_trunc_f64_e64 v[5:6], v[254:255]      ; encoding: [0x05,0x00,0x97,0xd5,0xfe,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[2:3]
// GFX12: v_trunc_f64_e64 v[5:6], s[2:3]          ; encoding: [0x05,0x00,0x97,0xd5,0x02,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[104:105]
// GFX12: v_trunc_f64_e64 v[5:6], s[104:105]      ; encoding: [0x05,0x00,0x97,0xd5,0x68,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], vcc
// GFX12: v_trunc_f64_e64 v[5:6], vcc             ; encoding: [0x05,0x00,0x97,0xd5,0x6a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], ttmp[14:15]
// GFX12: v_trunc_f64_e64 v[5:6], ttmp[14:15]     ; encoding: [0x05,0x00,0x97,0xd5,0x7a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], exec
// GFX12: v_trunc_f64_e64 v[5:6], exec            ; encoding: [0x05,0x00,0x97,0xd5,0x7e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], null
// GFX12: v_trunc_f64_e64 v[5:6], null            ; encoding: [0x05,0x00,0x97,0xd5,0x7c,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -1
// GFX12: v_trunc_f64_e64 v[5:6], -1              ; encoding: [0x05,0x00,0x97,0xd5,0xc1,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0.5 mul:2
// GFX12: v_trunc_f64_e64 v[5:6], 0.5 mul:2       ; encoding: [0x05,0x00,0x97,0xd5,0xf0,0x00,0x00,0x08]

v_trunc_f64_e64 v[5:6], -|src_scc| mul:4
// GFX12: v_trunc_f64_e64 v[5:6], -|src_scc| mul:4 ; encoding: [0x05,0x01,0x97,0xd5,0xfd,0x00,0x00,0x30]

v_trunc_f64_e64 v[254:255], 0xaf123456 clamp div:2
// GFX12: v_trunc_f64_e64 v[254:255], 0xaf123456 clamp div:2 ; encoding: [0xfe,0x80,0x97,0xd5,0xff,0x00,0x00,0x18,0x56,0x34,0x12,0xaf]
