/* $Id: texts.c,v 1.4 2005/09/05 10:45:48 pekberg Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff. Texts, titles and stuff.

   Copyright (C) 2004 Peter Ekberg	[peda@lysator.liu.se]
   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "directxwmh.h"

int GGIwmh_directx_settitle(ggi_visual *vis,const char *title)
{
	directx_priv *priv;
	priv=LIBGGI_PRIVATE(vis);

	GGI_directx_Lock(priv->cs);
	SetWindowText(priv->hWnd, title);
	GGI_directx_Unlock(priv->cs);

	return 0;
}

int GGIwmh_directx_seticontitle(ggi_visual *vis,const char *title)
{
	return GGI_ENOFUNC;
}

int GGIwmh_directx_iconify(ggi_visual *vis,int newstate)
{
	directx_priv *priv;                                                   
	priv=LIBGGI_PRIVATE(vis);

	GGI_directx_Lock(priv->cs);
	switch(newstate) {
		case GGI_WMH_MAPSTATE_NORMAL:
			ShowWindow(priv->hWnd, SW_RESTORE);
			break;
		case GGI_WMH_MAPSTATE_ICON:
			ShowWindow(priv->hWnd, SW_MINIMIZE);
			break;
		case GGI_WMH_MAPSTATE_WITHDRAWN:
			ShowWindow(priv->hWnd, SW_HIDE);
			break;
	}
	GGI_directx_Unlock(priv->cs);

	return 0;
}

