; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc %s -mtriple=aarch64 -o - | FileCheck %s --check-prefixes=CHECK,SDAG
; RUN: llc %s -mtriple=aarch64 -global-isel -o - | FileCheck %s --check-prefixes=CHECK,GI

; Tail calls which have stack arguments in the same offsets as the caller do not
; need to load and store the arguments from the stack.

declare void @func(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i32 %j)

define void @wrapper_func(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i32 %j) {
; CHECK-LABEL: wrapper_func:
; CHECK:       // %bb.0:
; CHECK-NEXT:    b func

  tail call void @func(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i32 %j)
  ret void
}

define void @wrapper_func_zero_arg(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i32 %j) {
; CHECK-LABEL: wrapper_func_zero_arg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str wzr, [sp, #8]
; CHECK-NEXT:    b func
  tail call void @func(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i32 0)
  ret void
}

define void @wrapper_func_overriden_arg(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i32 %j) {
; CHECK-LABEL: wrapper_func_overriden_arg:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr w8, [sp]
; CHECK-NEXT:    str wzr, [sp]
; CHECK-NEXT:    str w8, [sp, #8]
; CHECK-NEXT:    b func
  tail call void @func(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 0, i32 %i)
  ret void
}

declare void @func_i1(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i1 %j)

; FIXME: Support i1 passthrough stack arguments in GlobalISel.
define void @wrapper_func_i1(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i1 %j) {
; SDAG-LABEL: wrapper_func_i1:
; SDAG:       // %bb.0:
; SDAG-NEXT:    b func_i1
;
; GI-LABEL: wrapper_func_i1:
; GI:       // %bb.0:
; GI-NEXT:    ldrb w8, [sp, #8]
; GI-NEXT:    strb w8, [sp, #8]
; GI-NEXT:    b func_i1
  tail call void @func_i1(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i1 %j)
  ret void
}

declare void @func_signext_i1(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i1 signext %j)

; FIXME: Support zero/sign-extended stack arguments.
define void @wrapper_func_i8(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i1 signext %j) {
; CHECK-LABEL: wrapper_func_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldrsb w8, [sp, #8]
; CHECK-NEXT:    strb w8, [sp, #8]
; CHECK-NEXT:    b func_signext_i1
  tail call void @func_signext_i1(i32 %a, i32 %b, i32 %c, i32 %d, i32 %e, i32 %f, i32 %g, i32 %h, i32 %i, i1 signext %j)
  ret void
}
