; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=1 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL-GFX12 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn-amd-amdpal -mcpu=gfx1200 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=DAGISEL-GFX12 %s

declare amdgpu_cs_chain void @callee(<3 x i32> inreg, { i32, ptr addrspace(5), i32, i32 })
declare amdgpu_cs_chain_preserve void @callee_preserve(<3 x i32> inreg, { i32, ptr addrspace(5), i32, i32 })
declare void @llvm.amdgcn.cs.chain(ptr, i32, <3 x i32>, { i32, ptr addrspace(5), i32, i32 }, i32, ...) noreturn

; This test uses immediates for the EXEC masks and number of VGPRs, to make sure we don't use registers we don't need.
define amdgpu_cs_chain void @direct_callee_direct_fallback(<3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr) {
  ; GISEL-GFX12-LABEL: name: direct_callee_direct_fallback
  ; GISEL-GFX12: bb.1 (%ir-block.0):
  ; GISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX12-NEXT: {{  $}}
  ; GISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY8]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY9]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY3]]
  ; GISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY4]]
  ; GISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY5]]
  ; GISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY6]]
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @callee
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @callee
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[S_MOV_B32_]], %subreg.sub0, [[S_MOV_B32_1]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY10:%[0-9]+]]:ccr_sgpr_64 = COPY [[REG_SEQUENCE]]
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_2:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @retry_vgpr_alloc
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_3:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @retry_vgpr_alloc
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[S_MOV_B32_2]], %subreg.sub0, [[S_MOV_B32_3]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY11:%[0-9]+]]:ccr_sgpr_64 = COPY [[REG_SEQUENCE1]]
  ; GISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR [[COPY10]], 0, 0, 15, 64, -1, [[COPY11]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  ;
  ; DAGISEL-GFX12-LABEL: name: direct_callee_direct_fallback
  ; DAGISEL-GFX12: bb.0 (%ir-block.0):
  ; DAGISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; DAGISEL-GFX12-NEXT: {{  $}}
  ; DAGISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @retry_vgpr_alloc
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @retry_vgpr_alloc
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE killed [[S_MOV_B32_1]], %subreg.sub0, killed [[S_MOV_B32_]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_2:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @callee
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_3:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @callee
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE killed [[S_MOV_B32_3]], %subreg.sub0, killed [[S_MOV_B32_2]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY7]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY8]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY9]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; DAGISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; DAGISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; DAGISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY3]]
  ; DAGISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY2]]
  ; DAGISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY1]]
  ; DAGISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY]]
  ; DAGISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR killed [[REG_SEQUENCE1]], 0, 0, 15, 64, -1, killed [[REG_SEQUENCE]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  call void(ptr, i32, <3 x i32>, { i32, ptr addrspace(5), i32, i32 }, i32, ...) @llvm.amdgcn.cs.chain(ptr @callee, i32 15, <3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr, i32 1, i32 64, i32 inreg -1, ptr @retry_vgpr_alloc)
  unreachable
}

define amdgpu_cs_chain void @indirect_callee_direct_fallback(i32 inreg %exec, ptr inreg %callee, <3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr, i32 inreg %num_vgpr) {
  ; GISEL-GFX12-LABEL: name: indirect_callee_direct_fallback
  ; GISEL-GFX12: bb.1 (%ir-block.0):
  ; GISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX12-NEXT: {{  $}}
  ; GISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY2]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX12-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX12-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY11]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GISEL-GFX12-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY12]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GISEL-GFX12-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY13]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY6]]
  ; GISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY7]]
  ; GISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY8]]
  ; GISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY9]]
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @retry_vgpr_alloc
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @retry_vgpr_alloc
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[S_MOV_B32_]], %subreg.sub0, [[S_MOV_B32_1]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY14:%[0-9]+]]:ccr_sgpr_64 = COPY [[REG_SEQUENCE1]]
  ; GISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR [[REG_SEQUENCE]], 0, 0, [[COPY]], [[COPY10]], -1, [[COPY14]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  ;
  ; DAGISEL-GFX12-LABEL: name: indirect_callee_direct_fallback
  ; DAGISEL-GFX12: bb.0 (%ir-block.0):
  ; DAGISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $sgpr6
  ; DAGISEL-GFX12-NEXT: {{  $}}
  ; DAGISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX12-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[COPY9]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY11:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE]].sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 killed [[COPY12]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY13:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE]].sub0
  ; DAGISEL-GFX12-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 killed [[COPY14]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_1]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @retry_vgpr_alloc
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @retry_vgpr_alloc
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE killed [[S_MOV_B32_1]], %subreg.sub0, killed [[S_MOV_B32_]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY15]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY16]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY17]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_2]]
  ; DAGISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_3]]
  ; DAGISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_4]]
  ; DAGISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY4]]
  ; DAGISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY3]]
  ; DAGISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY2]]
  ; DAGISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY1]]
  ; DAGISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR killed [[REG_SEQUENCE1]], 0, 0, [[COPY10]], [[COPY]], -1, killed [[REG_SEQUENCE2]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  call void(ptr, i32, <3 x i32>, { i32, ptr addrspace(5), i32, i32 }, i32, ...) @llvm.amdgcn.cs.chain(ptr inreg %callee, i32 %exec, <3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr, i32 1, i32 inreg %num_vgpr, i32 inreg -1, ptr @retry_vgpr_alloc)
  unreachable
}

define amdgpu_cs_chain void @direct_callee_indirect_fallback(i32 inreg %exec, ptr inreg %retry, <3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr, i32 inreg %num_vgpr) {
  ; GISEL-GFX12-LABEL: name: direct_callee_indirect_fallback
  ; GISEL-GFX12: bb.1 (%ir-block.0):
  ; GISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX12-NEXT: {{  $}}
  ; GISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY2]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX12-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX12-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY11]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GISEL-GFX12-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY12]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GISEL-GFX12-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY13]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY6]]
  ; GISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY7]]
  ; GISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY8]]
  ; GISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY9]]
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @callee
  ; GISEL-GFX12-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @callee
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[S_MOV_B32_]], %subreg.sub0, [[S_MOV_B32_1]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY14:%[0-9]+]]:ccr_sgpr_64 = COPY [[REG_SEQUENCE1]]
  ; GISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR [[COPY14]], 0, 0, [[COPY]], [[COPY10]], -1, [[REG_SEQUENCE]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  ;
  ; DAGISEL-GFX12-LABEL: name: direct_callee_indirect_fallback
  ; DAGISEL-GFX12: bb.0 (%ir-block.0):
  ; DAGISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $sgpr6
  ; DAGISEL-GFX12-NEXT: {{  $}}
  ; DAGISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX12-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE [[COPY9]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-hi) @callee
  ; DAGISEL-GFX12-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 target-flags(amdgpu-abs32-lo) @callee
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE killed [[S_MOV_B32_1]], %subreg.sub0, killed [[S_MOV_B32_]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY11]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY12]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY13]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; DAGISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; DAGISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; DAGISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY4]]
  ; DAGISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY3]]
  ; DAGISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY2]]
  ; DAGISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY1]]
  ; DAGISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR killed [[REG_SEQUENCE1]], 0, 0, [[COPY10]], [[COPY]], -1, killed [[REG_SEQUENCE]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  call void(ptr, i32, <3 x i32>, { i32, ptr addrspace(5), i32, i32 }, i32, ...) @llvm.amdgcn.cs.chain(ptr @callee, i32 %exec, <3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr, i32 1, i32 inreg %num_vgpr, i32 inreg -1, ptr inreg %retry)
  unreachable
}

; This testcase uses registers for the EXEC masks and number of VGPRs, to make sure we can handle registers too.
define amdgpu_cs_chain void @indirect_callee_indirect_fallback(i32 inreg %exec, i32 inreg %retry_exec, ptr inreg %callee, ptr inreg %retry, <3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr, i32 inreg %num_vgpr) {
  ; GISEL-GFX12-LABEL: name: indirect_callee_indirect_fallback
  ; GISEL-GFX12: bb.1 (%ir-block.0):
  ; GISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX12-NEXT: {{  $}}
  ; GISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE [[COPY2]], %subreg.sub0, [[COPY3]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE [[COPY4]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; GISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:sreg_32 = COPY $sgpr7
  ; GISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:sreg_32 = COPY $sgpr8
  ; GISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX12-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX12-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX12-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX12-NEXT:   [[COPY13:%[0-9]+]]:sreg_32 = COPY $sgpr9
  ; GISEL-GFX12-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY14]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_]]
  ; GISEL-GFX12-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY15]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_1]]
  ; GISEL-GFX12-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY16]], implicit $exec
  ; GISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_2]]
  ; GISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY9]]
  ; GISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY10]]
  ; GISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY11]]
  ; GISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY12]]
  ; GISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR [[REG_SEQUENCE]], 0, 0, [[COPY]], [[COPY13]], [[COPY1]], [[REG_SEQUENCE1]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  ;
  ; DAGISEL-GFX12-LABEL: name: indirect_callee_indirect_fallback
  ; DAGISEL-GFX12: bb.0 (%ir-block.0):
  ; DAGISEL-GFX12-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $sgpr9
  ; DAGISEL-GFX12-NEXT: {{  $}}
  ; DAGISEL-GFX12-NEXT:   [[COPY:%[0-9]+]]:sgpr_32 = COPY $sgpr9
  ; DAGISEL-GFX12-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX12-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX12-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX12-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX12-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr8
  ; DAGISEL-GFX12-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX12-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX12-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX12-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX12-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX12-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX12-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX12-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE [[COPY9]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_64 = REG_SEQUENCE [[COPY11]], %subreg.sub0, [[COPY10]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY14:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE1]].sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY14]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 killed [[COPY15]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY16:%[0-9]+]]:sreg_32 = COPY [[REG_SEQUENCE1]].sub0
  ; DAGISEL-GFX12-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY16]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_1:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 killed [[COPY17]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:ccr_sgpr_64 = REG_SEQUENCE killed [[V_READFIRSTLANE_B32_1]], %subreg.sub0, killed [[V_READFIRSTLANE_B32_]], %subreg.sub1
  ; DAGISEL-GFX12-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_2:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY18]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_3:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY19]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; DAGISEL-GFX12-NEXT:   [[V_READFIRSTLANE_B32_4:%[0-9]+]]:sreg_32_xm0 = V_READFIRSTLANE_B32 [[COPY20]], implicit $exec
  ; DAGISEL-GFX12-NEXT:   $sgpr0 = COPY [[V_READFIRSTLANE_B32_2]]
  ; DAGISEL-GFX12-NEXT:   $sgpr1 = COPY [[V_READFIRSTLANE_B32_3]]
  ; DAGISEL-GFX12-NEXT:   $sgpr2 = COPY [[V_READFIRSTLANE_B32_4]]
  ; DAGISEL-GFX12-NEXT:   $vgpr8 = COPY [[COPY4]]
  ; DAGISEL-GFX12-NEXT:   $vgpr9 = COPY [[COPY3]]
  ; DAGISEL-GFX12-NEXT:   $vgpr10 = COPY [[COPY2]]
  ; DAGISEL-GFX12-NEXT:   $vgpr11 = COPY [[COPY1]]
  ; DAGISEL-GFX12-NEXT:   SI_CS_CHAIN_TC_W32_DVGPR killed [[REG_SEQUENCE2]], 0, 0, [[COPY13]], [[COPY]], [[COPY12]], killed [[REG_SEQUENCE]], amdgpu_allvgprs, implicit $sgpr0, implicit $sgpr1, implicit $sgpr2, implicit $vgpr8, implicit $vgpr9, implicit $vgpr10, implicit $vgpr11
  call void(ptr, i32, <3 x i32>, { i32, ptr addrspace(5), i32, i32 }, i32, ...) @llvm.amdgcn.cs.chain(ptr inreg %callee, i32 inreg %exec, <3 x i32> inreg %sgpr, { i32, ptr addrspace(5), i32, i32 } %vgpr, i32 1, i32 inreg %num_vgpr, i32 inreg %retry_exec, ptr inreg %retry)
  unreachable
}

declare amdgpu_cs_chain_preserve void @retry_vgpr_alloc(<3 x i32> inreg %sgpr)
