#!/usr/bin/perl
# $Id: image.pl,v 1.7.2.1 2001/05/16 12:25:50 york Exp $
#
# PDFlib client: image example in Perl
#

use pdflib_pl 4.0;

$p = PDF_new();

die "Couldn't open PDF file" if (PDF_open_file($p, "image.pdf") == -1);

PDF_set_info($p, "Creator", "image.pl");
PDF_set_info($p, "Author", "Thomas Merz");
PDF_set_info($p, "Title", "image sample (Perl)");

$imagefile = "../../test/nesrin.jpg";

$image = PDF_open_image_file($p, "jpeg", $imagefile, "", 0);
die "Couldn't open image '$imagefile'" if ($image == -1);

# See the PDFlib manual for more advanced image size calculations
$width = PDF_get_value($p, "imagewidth", $image);
$height = PDF_get_value($p, "imageheight", $image);

# We generate a page with the image's dimensions
PDF_begin_page($p, $width, $height);
PDF_place_image($p, $image, 0, 0, 1);
PDF_close_image($p, $image);
PDF_end_page($p);

PDF_close($p);

PDF_delete($p);
