// $Id: image.cpp,v 1.6.2.4 2001/08/07 15:48:20 york Exp $
// PDFlib client: image example in C++
//
//

#include <iostream>

#include "pdflib.hpp"

int
main(void)
{
#ifdef	PDF_THROWS_CPP_EXCEPTIONS
    try
    {
#endif
	PDFlib *p;			// pointer to the PDFlib class
	int image;
	float width, height;
	char *imagefile = (char *) "../../test/nesrin.jpg";

	p = new PDFlib();

	// Open new PDF file
	if (p->open("image.pdf") == -1) {
	    cerr << "Error: cannot open PDF file image.pdf" << endl;
	    return 99;
	}

	p->set_info("Creator", "image.cpp");
	p->set_info("Author", "Thomas Merz");
	p->set_info("Title", "image sample (C++)!");

	image = p->open_image_file("jpeg", imagefile, "", 0);

	if (image == -1) {
	    fprintf(stderr, "Error: couldn't open image file.\n");
	    exit(3);
	}

	// See the PDFlib manual for more advanced image size calculations
	width = p->get_value("imagewidth", (float) image);
	height = p->get_value("imageheight", (float) image);
	
	// We generate a page with the image's dimensions
	p->begin_page(width, height);
	p->place_image(image, (float) 0.0, (float) 0.0, (float) 1.0);
	p->close_image(image);
	p->end_page();				// finish page

	p->close();				// close PDF document
	delete p;

#ifdef	PDF_THROWS_CPP_EXCEPTIONS
    }
    catch (PDFlib::Exception &ex)
    {
	cerr << "PDFlib EXCEPTION: " << ex.get_message() << endl;
	return 99;
    }
#endif

    return 0;
}
