#!/bin/sh
#
# bbdef.sh
#
# BIG BROTHER DEFINITIONS AREA
# Sean MacGuire
# Version 1.9
# Mar 13th, 2002
#
# (c) Copyright Quest Software, Inc.  1997-2002  All rights reserved.
#

# OS TYPE
BBOSTYPE="linux"
export BBOSTYPE

# BB USER
BBUSER="bb"
export BBUSER

#
# NEW FOR 1.04... DISPLAY FULLY QUALIFED DOMAIN NAMES?
# i.e. aaa.bbb.com instead of just aaa
#
# FQDN="TRUE"		# YES...

FQDN="TRUE"

#
# PREVENT BB TO RUN AS root ?
#
STOPROOT="TRUE"
export STOPROOT

#
# USE lynx IF YOU MUST TEST PASSWORD PROTECTED PAGES
# OR https TESTING...
# LIKE Leif Ericksen <phantom@wwa.com>
# Can't put in bbsys.local as cUrl can also be defined as LYNX...
case $BBOSTYPE in
	caldera | debian | redhat )
		LYNXCMD="/usr/bin/lynx"
		;;
	* )
		LYNXCMD="/usr/local/bin/lynx"
		;;
esac
LYNX="$LYNXCMD -dump -head"

#
# OR USE curl, WHICH IS BETTER...
#

# LYNX="/usr/local/bin/curl -s -m 20 -I"



#
# INTERNET SERVICES YOU DON'T WANT TO GET PAGED ON
# WHEN THEY'RE DOWN... ASSUMPTION IS YOU WANT TO KNOW 
# ABOUT EVERYTHING RIGHT NOW... (pop3/smtp/ssh/...)
#

NONETPAGE=""
export NONETPAGE


#
# WHERE tmp FILES LIVE - THIS IS GOOD FOR SECURITY
# THANKS TO Alan Cox (alan@cymru.net)
#

BBTMP="$BBHOME/tmp"
export BBTMP

# LOCATION OF PIDs FILE
#
BBPID="$BBTMP/BBPID"
export BBPID

#
# LOCATION OF BBOUT FILE
#
BBOUT="$BBHOME/BBOUT"
export BBOUT

#
# REPORT FILE WARNING LEVEL
# WHEN REPORTS ARE RUN, AVAILABILITY < BBREPWARN = RED
# AND >= BBREPWARN IS YELLOW.
# THIS MUST BE AN INTEGER...
#

BBREPWARN="97"
export BBREPWARN

#
# LOCAL CLIENT MONITORING CONFIGURATION FOR bb-local.sh
#
# WARNING AND PANIC LEVELS FOR LOCAL SYSTEM INFOMRAION
# YOU CAN SET VALUES ON A SPECIFIC FILESYSTEM BY USING
#	THE etc/bb-dftab FILE
#

DFWARN=90				# (YELLOW) DISK % TO WARN
DFPANIC=95				# (RED) DISK % TO PANIC
export DFWARN DFPANIC


#
# CPU LEVELS ARE THE 5 MINUTE LOAD AVERAGE x 100
#

CPUWARN=400				# (YELLOW) WARN AT LOAD AVG OF 1.5
CPUPANIC=800				# (RED) PANIC AT LOAD AVG OF 3
DISPREALLOADAVG="TRUE"			# DISPLAY THE LOAD AVERAGE AS FOUND IN UPTIME
					# BB REMOVES THE '.' BY DEFAULT
export CPUPANIC CPUWARN DISPREALLOADAVG


#
# PROCESS MONITORING
# THESE VALUES ARE OVERRIDDEN BY THE etc/bb-proctab FILE
#

PROCS="bbrun"				# (YELLOW) WARN IF NOT RUNNING 
PAGEPROC="cron"				# (RED) PAGE IF NOT RUNNING
export PROCS PAGEPROC


#
# MESSAGE FILE MONITORING (/var/adm/messages or similar)
#
# SMM: NEW IN BB 1.4
# CHKMSGLEN IS SET TO TRUE BY DEFAULT.  IT WILL SCREAM IF IT FINDS
# AN EMPTY MESSAGES FILE.  BETTER SAFE THAN SORRY.
#
# NOTE: AS OF VERSION 1.8 YOU CAN USE etc/bb-msgstab TO
#       CONFIGURE THE VALUES OF PAGEMSG, MSGS AND IGNMSGS
# NOTE THAT KEYWORDS ARE SPACE SEPERATED HERE AS OPPOSED
# TO ';' SEPERTATED IN etc/bb-msgstab
#
CHKMSGLEN="TRUE"			# MAKE SURE MSG FILE IS NON-ZERO LEN
PAGEMSG="NOTICE"			# (RED) PAGE IF WE SEE THIS MESSAGE
MSGS="$PAGEMSG WARNING"			# (YELLOW) MESSAGES TO WATCH FOR 
					# NOTE: WORDS IN PAGEMSG *MUST ALSO*
					#       BE DEFINED IN MSGS
IGNMSGS=""              # List of messages to ignore if string(s) matches line
                        # delimit each message with ;
MSGEXPIRE="30:60"	# EXPIRE WARNINGS IN 30 MIN, PANICS IN 60
YELLOWMSGSLINES=10	# Return the XX most recent WARNING messages
REDMSGSLINES=20		# Return the XX most recent PANIC messages
OLDSTYLEBBMSGS="FALSE"	# Don't expire messages found 
			#   just like the old days (they must be cleared by hand)
export MSGS PAGEMSG IGNMSGS CHKMSGLEN MSGEXPIRE YELLOWMSGSLINES REDMSGSLINES OLDSTYLEBBMSGS

# 
# PATH TO WEB SERVER DISPLAY
# INSERT THE PATH TO YOUR BBDISPLAY WEB SERVER
# THIS IS USED ONLY IF YOU USE HTMLized STATUS LOGS
# BBWEB AND BBWEBHOST SHOULDN'T END WITH A "/"
#
BBWEB="/bb"
BBWEBHOST="http://hellion.fnal.gov"
export BBWEB BBWEBHOST

# BBWEB SHOULDN'T BE JUST "/", BECAUSE A LOT OF USE IN THE
# ${BBWEB}/... THAT WOULD EVALUATE TO //... WHICH CAN THROW OFF SOME WEB SERVERS
# BBWEB SHOULD START WITH A "/"
if [ "$BBWEB" != "" ]
then
	case "$BBWEB" in
		"/" )
			BBWEB=""
			;;
		/* )
			;;
		* )
			BBWEB="/${BBWEB}"	# MAKE SURE THERE'S A LEADING SLASH
			;;
	esac
fi

if [ "$BBWEB" = "" ]
then
	BBWEBHTMLLOGS="${BBWEBHOST}/html"
	BBWEBHOSTURL="${BBWEBHOST}"
else
	BBWEBHTMLLOGS="${BBWEBHOST}${BBWEB}/html"
	BBWEBHOSTURL="${BBWEBHOST}${BBWEB}"
fi
export BBWEBHTMLLOGS BBWEBHOSTURL

#
# If you need a different value than BBWEB in mkbbwml.sh
# just change the value here
BBWAP="${BBWEB}/wml"
export BBWAP

#
# URL OF THE CGI SCRIPTS
# SHOULDN'T END WITH A "/"
#
CGIBINURL="/cgi-bin"			# e.g. /cgi-bin
export CGIBINURL

#
# URL OF reports
#
BBREPURL="${BBWEB}/rep"
export BBREPURL

#
# Default colors to send notification messages on
#
PAGELEVELS="red purple"                 # Default red purple
                                        # purple is always sent by the
                                        # BBDISPLAY. Clients shouldn't
                                        # send purple
export PAGELEVELS                       # Will be overidden in bbinc.sh
                                        # with values found in
                                        # etc/bbwarnsetup.cfg

#
# GENERATE WEB BASED HISTORY OR USE HISTORY LOG FILE
#
WEBHISTORY="TRUE"			# TRUE will show a web display for history
					# otherwise just the text history log
BBHIST_IGNOREBLUE=FALSE			# Don't count down time from BLUE
export WEBHISTORY BBHIST_IGNOREBLUE

#
# SAVE THE NEW STATUS LOG IF IT CHANGES THE COLOR ?
# THEY ARE STORED IN $HISTLOGS (bbinc.sh)
#
SAVESTATUSLOG="TRUE"
export SAVESTATUSLOG

#
# BB creates a static HTML page for every incoming status ?
# Otherwise, the status is generated with $CGIBINURL/bb-hostsvc.sh dynamically
# values: STATIC/DYNAMIC/TEXT
# STATIC - create an HTMLized status log, reverts to TEXT if www/html directory
# 		is missing or unwritable
# DYNAMIC - create a HTMLized status log on the fly when the admin clicks on
# 		the colored dot in bb.html/bb2.html
# TEXT - A simple text page will be displayed
#	    If you chose this option then you must make a link
#	    from $BBLOGS to $BBHOME/www/logs
#	    ln -s $BBLOGS $BBHOME/www/logs
#           *NOTE* This option is not recommended, it represents
#	           a security risk. Only use if you are in
#		   a secure network and not attached to the Internet
# 
BBLOGSTATUS="STATIC"
export BBLOGSTATUS

# 
# HOW LONG BEFORE SENDING A PURPLE REPORT
# 

PURPLEDELAY="30"	# THIS MUST BE A POSITIVE VALUE !!! SINCE v1.4c
export PURPLEDELAY
if [ "$PURPLEDELAY" != "" -a "$PURPLEDELAY" -le 0 ]
then
	echo "PURPLEDELAY ($PURPLEDELAY) should be a positive value !!!"
fi

PINGTESTS=4		# How many tries for regular ping test
PINGSLEEPFCT=3		# Sleep factor, how long to sleep between each
			# ping test, it is incremented every test: 3,6,9,...
PINGWARN=1              # How many failed pings does it require
			# such the test wll be considered yellow ?
export PINGTESTS PINGSLEEPFCT PINGWARN

# Do you want clear dots for noping directive  & 0.0.0.0 hosts ?
# Set this to anything but TRUE and no clear dots will be
#  generated for hosts=0.0.0.0 and hosts with the noping directive
# You can leave this to TRUE and you can disable the clear button
# individually (by host) using the noconn directive on the host's line
NOPINGCLEAR="TRUE"
export NOPINGCLEAR

# Do you want to see your failed IP tests (done in bb-network.sh)
# to be displayed with a red dot or a clear dot
# *** ONLY *** if the connectivity to that host failed.
IPTEST_2_CLEAR_ON_FAILED_CONN="TRUE"
export IPTEST_2_CLEAR_ON_FAILED_CONN

# Specify scripts to execute while running bb-hist.sh
# Echo from them will be displayed on the generated web page
BBHISTEXT=""
export BBHISTEXT

# Specify scripts to execute while running mkbb.sh/mkbb2.sh
# Echo from them will be displayed on the generated web page
BBMKBBEXT=""
BBMKBB2EXT="eventlog.sh acklog.sh"
export BBMKBBEXT BBMKBB2EXT

# Do we keep historical info by host ? for all ?
BBHOSTHISTLOG=TRUE
BBALLHISTLOG=TRUE
export BBHOSTHISTLOG BBALLHISTLOG

# Should bb-network.sh run the conn test ?
CONNTEST=TRUE
export CONNTEST

#
# Can summaries set the background color
#
SUMMARY_SET_BKG=TRUE
export SUMMARY_SET_BKG

#
# How many concurrent bb-network.sh to run ?
#
BBNETTHREADS=1
export BBNETTHREADS

#
# What NET services to check (don't put in dns/dig/http)
#
BBNETSVCS="smtp telnet ftp pop pop3 pop-3 ssh imap ssh1 ssh2 imap2 imap3 imap4 pop2 pop-2 nntp"
export BBNETSVCS

#
# Generate WML output for WAP enabled phones ?
#
WML_OUTPUT=FALSE
WMLMAXCHARS=1500	# What's the most characters can you WAP device accept ?
export WML_OUTPUT WMLMAXCHARS

#
# Control the color of the cpu dot when a host reboots
# Note that the maximum of minutes definable is 60, anything over will be reset to 60
#
WARNMINSONREBOOT=60
WARNCOLORONREBOOT=yellow
export WARNMINSONREBOOT WARNCOLORONREBOOT

# 
# THIS SETS A VALUE FOR IF YOU THINK MACHINES SHOULD BE REBOOTED EVERY X DAYS
# 
BBTOOMANYDAYSUP=9999
export BBTOOMANYDAYSUP

#
# TIMERS FOR bbnet
# bbnet TRIES TO COMMUNICATE UP TO 3 TIMES USING
# INCREMENTAL TIMERS (by default).  YOU CAN CHANGE
# THE TIMEROUT VALUES IF SOME OF YOUR CONNECTIONS TAKE
# LONGER THAN THE CUMULATIVE TIMER VALUES (DEFAULT 20secs)
#
BBNETTIMER1=3		# WAIT UP TO 3  SECONDS
BBNETTIMER2=5		#            5  SECONDS
BBNETTIMER3=12		#            12 SECONDS
export BBNETTIMER1 BBNETTIMER2 BBNETTIMER3

#
# EXECUTE LOCAL SCRIPTS FROM HERE...
# SCRIPTS SHOULD LIVE IN $BBHOME/ext DIRECTORY
# BBEXT CONTAINS THE FILENAMES TO EXECUTE
# SEPERATE THE SCRIPTS WITH A SPACE:  BBEXT="ext1.sh ext2.sh"
# IT IS PREFERABLE THAT YOU USE THE etc/bb-bbexttab FILE
# INSTEAD OF THIS. IT IS KEPT FOR BACKWARD COMPATIBILITY
# 
BBEXT="bb-memory.sh bb-root.sh bb-top-3_2.sh"
BBDEFSLEEP=300                  # HOW OFTEN TO RUN EXTERNAL SCRIPTS (IN SECONDS)
export BBEXT BBDEFSLEEP

# 
# Variables to determine if local test is to be run
# and if so, does it send a msg anyway
# 
DOCPU="TRUE"
DOMSGS="TRUE"
DOPROCS="TRUE"
DODISK="TRUE"
NOCPUCOLOR="clear"	# Set to "" if you don't want a message sent
NOMSGSCOLOR="clear"	# anything else will send a message to BBDISPLAY
NODISKCOLOR="clear"
NOPROCSCOLOR="clear"
export DOMSGS DOPROCS DODISK DOCPU
export NOCPUCOLOR NOMSGSCOLOR NODISKCOLOR NOPROCSCOLOR

#
# What's the largest message size that can be sent out
# It should be the same value as in src/bb.h
#
MAXLINE=8192
export MAXLINE

#
# configuration variables associated with the combo message
#
DOCOMBO=TRUE		# Do we use the combo message ?
MAXCOMBOMSGS=999	# Maximum status logs in a single combo message
MAXCOMBOTTL=120		# combo workfile maximum Time to live, in seconds
export DOCOMBO MAXCOMBOMSGS MAXCOMBOTTL


. ${BBHOME}/etc/bbsys.sh		# INCLUDE SYSTEM DEFINITIONS
. ${BBHOME}/etc/bbinc.sh		# INCLUDE BB DEFINITIONS

export FQDN DF MSGFILE LYNX
