# From: Douwe Dijkstra (D.Dijkstra@Twinfo.nl)
SHELL = /bin/sh
MAKE = make
CC = cc
 
# SCO
# MISC COMPILER DIRECTIVES
# -DENABLE_DISABLE      - INCLUDE CODE TO TEMPORARELY DISABLE NOTIFICATIONS ON A HOST
# -DDATAMSG             - TO ALLOW data MESSAGES
# -DNOTESMSG            - TO ALLOW notes MESSAGES
# -DBZERO               - IF YOU DON'T HAVE bzero()
# -DZOMBIE              - IF zombie PROCESSES ARE GENERATED
# -DGETTIMEOFDAY        - TO GET DURATION STATISTICS
# -DREGEXEC             - IF YOUR COMPILER SUPPORTS regexec(),regcomp()
# -DREGEX               - IF YOUR COMPILER SUPPORTS regex(),regcmp()
# -DRE_EXEC             - IF YOUR COMPILER SUPPORTS re_exec(),re_comp()
# -DTIMEH               - IF YOUR OS HAS time.h INSTEAD OF sys/time.h
# -DSIGSETJMP           - IF YOUR OS SUPPORTS sigsetjmp() AND
#                               DOES NOT HANDLE SIGNALS PROPERLY
#                               WITH setjmp()
# -DDONTCLEANSTRING     - IF YOU DON'T WANT TO REMOVE THE CHARACTERS "`$;|&\"
#				FROM INCOMING MESSAGES
# -DNOTAMP              - IF YOU WISH TO KEEP INCOMING '&' IN MESSAGES
#                               WHILE REMOVING "`$;|\"
#				(useful with bbmrtg.sh and LARRD - see http://www.deadcat.net)

# SCO 5 should support regexec, -DREGEX did cause some problems.
CFLAGS=-D&BBOSTYPE -DTIMEH -DREGEXEC -O
LIBS = -lsocket 
 
all: bb bbd bbnet touchtime dumphostsvc getipaddr bbstat bbrun

bb: bb.o bbsend.o utils.o bb.h
	${CC} ${CFLAGS} -o $@ bb.o bbsend.o utils.o ${LIBS}

bbd: dohostsvc.o utils.o bbd.o bbpage.o bbsend.o bb.h
	${CC} ${CFLAGS} -o $@ bbd.o dohostsvc.o bbpage.o bbsend.o utils.o ${LIBS}

bbnet: bbnet.o utils.o bb.h
	${CC} ${CFLAGS} -o $@ bbnet.o utils.o ${LIBS}

touchtime: touchtime.o bb.h
	${CC} ${CFLAGS} -o $@ touchtime.o ${LIBS}

dumphostsvc: dohostsvc.o utils.o dumphostsvc.o bb.h
	${CC} ${CFLAGS} -o $@ dumphostsvc.o dohostsvc.o utils.o ${LIBS}

getipaddr: utils.o getipaddr.o bb.h
	${CC} ${CFLAGS} -o $@ getipaddr.o utils.o ${LIBS}

bbstat: bbstat.o bb.h
	${CC} ${CFLAGS} -o $@ bbstat.o ${LIBS}

bbrun: utils.o bbrun.o bb.h
	${CC} ${CFLAGS} -o $@ bbrun.o utils.o ${LIBS}

install:
	rm -f *.o
	mv bb bbd bbnet touchtime dumphostsvc getipaddr bbstat bbrun ../bin

clean:	
	rm -f *.o bb bbd bbnet touchtime dumphostsvc getipaddr bbstat bbrun
