ARCH=i386
CDISOAREA=/mnt/local/isos/SL/
BASEDIR=/mnt/src/scientific/5rolling/
FROMDIR=$BASEDIR/$ARCH/
DEFAULT=SL
VERSION=5.0
DATE=`date "+%m%d%y"`
if [ -d $CDISOAREA ] ; then
  echo "Creating CD iso images in $CDISOAREA"
else
  mkdir -p $CDISOAREA 
fi
TREE=/mnt/cdrom
BOOTIMG="isolinux/isolinux.bin"
BOOTCAT="isolinux/boot.cat"
BOOTOPTS="-no-emul-boot -boot-load-size 4 -boot-info-table"
#
CDNUM=1
umount $TREE
PUNGIBASENAME="$CDISOAREA/$DEFAULT-$VERSION-$ARCH"
#for PUNGIISOIMAGE in "$PUNGIBASENAME-disc1.iso"
for PUNGIISOIMAGE in $PUNGIBASENAME-DVD.iso
do
  if [ -s $PUNGIISOIMAGE ] ; then
    echo "Mounting $PUNGIISOIMAGE at $TREE"
    mount -o loop $PUNGIISOIMAGE $TREE
    CDNAME=$CDISOAREA/$DEFAULT-$VERSION-$DATE-$ARCH
    DEST="$CDNAME-DVD.iso"
  fi
#
  echo "Creating $DEST from $PUNGIISOIMAGE mounted at $TREE ..."
  cd $CDISOAREA
  if [ -d work ] ; then
     rm -r work
  else
     mkdir work
  fi
  cd work
  mkdir isolinux
  cp -af $TREE/isolinux/* isolinux/
  rm $BOOTIMG
  rm $BOOTCAT
  cp -af $FROMDIR/build/isolinux/isolinux.bin isolinux/
  ADDEDDIRS="$DEFAULT.documentation=$FROMDIR/$DEFAULT.documentation RPM-GPG-KEYs=$FROMDIR/RPM-GPG-KEYs build=$FROMDIR/build/scripts/"
  ADDEDFILES="/=$FROMDIR/GPL /=$FROMDIR/$DEFAULT.releasenote /=$FROMDIR/README "
  ADDEDSRPMS="SRPMS=$BASEDIR/SRPMS/SL/ SRPMS=$BASEDIR/SRPMS/contrib/"
  ADDEDCONTRIB="contrib=$FROMDIR/contrib"
  echo "Boot image is" $BOOTIMG

# Create the image (This is for disk 1)

  mkisofs \
	-A "$VERSION DVD" \
	-V "$DEFAULT $VERSION $ARCH" \
	-R -l -v -J \
	-x ./lost+found \
        -c $BOOTCAT $BOOTOPTS \
 	-b $BOOTIMG \
	-o $DEST \
        -graft-points isolinux=./isolinux images=$TREE/images /=$TREE/.discinfo SL=$TREE/SL $ADDEDDIRS $ADDEDFILES $ADDEDSRPMS $ADDEDCONTRIB
  echo "implanting md5sum in $DEST now"
  /usr/lib/anaconda-runtime/implantisomd5 $DEST
  dd if=/dev/zero count=15 bs=2048 >> $DEST
  cd $CDISOAREA
  echo "Making SHA1SUMS now, this will take a while"
  sha1sum $DEFAULT-$VERSION-$DATE-$ARCH-*.iso > $DEFAULT-$VERSION-$DATE-$ARCH.SHA1SUM
  cd /
  umount /mnt/cdrom
done
