#! /bin/sh

. $MYPWD/../locations.include

# Hacked by bv@bnl.gov from the originals at
# Hacked by csieh@fnal.gov from the originals at
# ftp://apt.tuxfamily.org/pub/ftp.tuxfamily.org/apt-rpm/scripts/
# to be more generic.

# Absolute directory containing the top of the apt repository 
APTDIR=$4
# Relative directory from the top of the apt repository to the top of the mirror
#MIRRORDIR=../mirror
MIRRORDIR=.

# Extra PATH for genbasedir/genpkglist etc
#export PATH=/data/www/org/y/l/tuxfamily.org/m/p/apt/htdocs/scripts:$PATH
export PATH=$APTDIR/scripts:$PATH

# The idea of full/all/quick is:
#	* the first time you create the apt repository, choose "full".
#	* each night (when updates are downloaded), relaunch with "quick"
#	* if extra packages are put in 'extra' repository, relaunch with "quick"
#	* if the main os packages change (should not), use "all"

if [ $# -ne 5 -o \( "$1" != "full" -a "$1" != "all" -a "$1" != "quick" \) ]; then
	echo "Usage: $0 <mode> <version-string> <default> <topdir>"
	echo "  <mode> is one of:"
	echo "        \"full\": full apt repository creation"
	echo "        \"all\": no apt repository creation, but full indexes regeneration"
	echo "        \"quick\": no apt repository creation, only updates indexes regeneration"
	echo "  <version> gives the version in canonical form"
	echo "	      (eg: \"lts30rolling\", \"hepl30rolling\")"
	exit 1
fi

MODE=$1
DEFAULT=$3
DISCNUM=$ARCH-disc$5

if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $APTDIR/${VERSIONDIR}/$DISCNUM/apt/base || exit 1

	# Create the main release file
	cat >$APTDIR/${VERSIONDIR}/$DISCNUM/apt/base/release <<EOF
Origin: ftp.scientificlinux.org
Label: ${VERSION}
Suite: ${VERSION}
Architectures: $ARCH
Components: os contrib 
Description: apt mirror of ${VERSION}
EOF

fi

###########################################################################
#### REDHAT I386 MAIN OS
###########################################################################

if [ -d $APTDIR/${VERSIONDIR}/$DISCNUM/$DEFAULT/RPMS ] ; then
  if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $APTDIR/${VERSIONDIR}/$DISCNUM/apt/base || exit 1

	# Create the release files
	cat >$APTDIR/${VERSIONDIR}/$DISCNUM/apt/base/release.os <<EOF
Archive: stable
Component: os
Version: ${VERSION}
Origin: ftp.scientificlinux.org
Label: ${VERSION}
Architecture: $ARCH
EOF

	# Put the symlinks for the base OS packages
	cd $APTDIR/${VERSIONDIR}/$DISCNUM/apt
	rm -f RPMS.os
	ln -sf ../$DEFAULT/RPMS RPMS.os
  fi

  if [ "$MODE" = "full" -o "$MODE" = "all" ]; then
	# Generate APT indexes
	genbasedir --flat --bloat $APTDIR/${VERSIONDIR}/$DISCNUM/apt os
  fi
fi

###########################################################################
#### contrib packages
###########################################################################

if [ -d $APTDIR/${VERSIONDIR}/$DISCNUM/contrib/RPMS ] ; then
   if [ "$MODE" = "full" ]; then
	  # Create directories
	  mkdir -p $APTDIR/${VERSIONDIR}/$DISCNUM/apt/base || exit 1
	  cd $APTDIR/${VERSIONDIR}/$DISCNUM/apt
	  rm -f SRPMS.contrib
	  ln -sf ../contrib/SRPMS/ SRPMS.contrib
	  cd $APTDIR/${VERSIONDIR}/$DISCNUM/apt
	  rm -f RPMS.contrib
	  ln -sf ../contrib/RPMS RPMS.contrib

	  # Create the release files
	  cat >$APTDIR/${VERSIONDIR}/$DISCNUM/apt/base/release.contrib <<EOF
Archive: stable
Component: contrib
Version: ${VERSION}
Origin: ftp.scientificlinux.org
Label: ${VERSION}
Architecture: $ARCH
EOF
   fi
# Regenerate the apt indexes
genbasedir --flat --bloat $APTDIR/${VERSIONDIR}/$DISCNUM/apt contrib 
fi


###########################################################################
#### notsupported packages
###########################################################################

if [ -d $APTDIR/${VERSIONDIR}/$DISCNUM/notsupported/RPMS ] ; then
   if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $APTDIR/${VERSIONDIR}/$DISCNUM/apt/base || exit 1
	cd $APTDIR/${VERSIONDIR}/$DISCNUM/apt
	rm -f RPMS.notsupported
	ln -sf ../notsupported/RPMS RPMS.notsupported

	# Create the release files
	cat >$APTDIR/${VERSIONDIR}/$DISCNUM/apt/base/release.notsupported <<EOF
Archive: stable
Component: notsupported
Version: ${VERSION}
Origin: ftp.scientificlinux.org
Label: ${VERSION}
Architecture: $ARCH
EOF

   fi
# Regenerate the apt indexes
genbasedir --flat --bloat $APTDIR/${VERSIONDIR}/$DISCNUM/apt notsupported 
fi

###########################################################################
#### SRPMS packages
###########################################################################

if [ -d $APTDIR/${VERSIONDIR}/$DISCNUM/SRPMS ] ; then
   if [ "$MODE" = "full" ]; then
	# Create directories
	mkdir -p $APTDIR/${VERSIONDIR}/$DISCNUM/apt/base || exit 1
	cd $APTDIR/${VERSIONDIR}/$DISCNUM/apt
	ln -sf ../SRPMS SRPMS.os

	# Create the release files
	cat >$APTDIR/${VERSIONDIR}/$DISCNUM/apt/base/release.srpms <<EOF
Archive: stable
Component: srpms 
Version: ${VERSION}
Origin: ftp.scientificlinux.org
Label: ${VERSION}
Architecture: $ARCH
EOF

   fi

# Regenerate the apt indexes
genbasedir --flat --bloat $APTDIR/${VERSIONDIR}/$DISCNUM/apt srpms 

fi
