/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.io;

import com.mysql.cj.api.io.ValueFactory;
import com.mysql.cj.core.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;

public class StringValueFactory
implements ValueFactory<String> {
    private String encoding;

    public StringValueFactory() {
    }

    public StringValueFactory(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String createFromDate(int year, int month, int day) {
        return String.format("%04d-%02d-%02d", year, month, day);
    }

    @Override
    public String createFromTime(int hours, int minutes, int seconds, int nanos) {
        if (nanos > 0) {
            return String.format("%02d:%02d:%02d.%d", hours, minutes, seconds, nanos);
        }
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    @Override
    public String createFromTimestamp(int year, int month, int day, int hours, int minutes, int seconds, int nanos) {
        return String.format("%s %s", this.createFromDate(year, month, day), this.createFromTime(hours, minutes, seconds, nanos));
    }

    @Override
    public String createFromLong(long l2) {
        return String.valueOf(l2);
    }

    @Override
    public String createFromBigInteger(BigInteger i2) {
        return i2.toString();
    }

    @Override
    public String createFromDouble(double d2) {
        return String.valueOf(d2);
    }

    @Override
    public String createFromBigDecimal(BigDecimal d2) {
        return d2.toString();
    }

    @Override
    public String createFromBytes(byte[] bytes, int offset, int length) {
        return StringUtils.toString(bytes, offset, length, this.encoding);
    }

    @Override
    public String createFromNull() {
        return null;
    }

    @Override
    public String getTargetTypeName() {
        return String.class.getName();
    }
}

