# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

PYTHON_COMPAT=( python3_{11..14} )

inherit gnome.org meson-multilib python-r1 systemd virtualx xdg

DESCRIPTION="D-Bus accessibility specifications and registration daemon"
HOMEPAGE="https://gitlab.gnome.org/GNOME/at-spi2-core"

LICENSE="LGPL-2.1+"
SLOT="2"
KEYWORDS="~alpha ~amd64 ~arm ~arm64 ~hppa ~loong ~mips ~ppc ~ppc64 ~riscv ~s390 ~sparc ~x86 ~x64-macos"
IUSE="X dbus-broker gtk-doc +introspection systemd"
REQUIRED_USE="
	${PYTHON_REQUIRED_USE}
	dbus-broker? ( systemd )
	gtk-doc? ( X )
"

DEPEND="
	>=sys-apps/dbus-1.5[${MULTILIB_USEDEP}]
	>=dev-libs/glib-2.67.4:2[${MULTILIB_USEDEP}]
	>=dev-libs/libxml2-2.9.1:2=[${MULTILIB_USEDEP}]
	introspection? ( >=dev-libs/gobject-introspection-1.82.0-r2:= )
	systemd? ( sys-apps/systemd[${MULTILIB_USEDEP}] )
	X? (
		x11-libs/libX11[${MULTILIB_USEDEP}]
		x11-libs/libXtst[${MULTILIB_USEDEP}]
		x11-libs/libXi[${MULTILIB_USEDEP}]
	)

	!<dev-libs/atk-2.46.0
"
RDEPEND="${DEPEND}
	dbus-broker? ( sys-apps/dbus-broker )
	${PYTHON_DEPS}
"
BDEPEND="
	dev-util/glib-utils
	gtk-doc? (
		dev-python/sphinx
		dev-util/gdbus-codegen
		>=dev-util/gi-docgen-2021.1
	)
	${PYTHON_DEPS}
	test? ( dev-python/pygobject[${PYTHON_USEDEP}] )
	>=sys-devel/gettext-0.19.8
	virtual/pkgconfig
"

multilib_src_configure() {
	python_setup

	local emesonargs=(
		-Ddefault_bus=$(usex dbus-broker dbus-broker dbus-daemon)
		$(meson_use systemd use_systemd)
		-Dgtk2_atk_adaptor=true
		-Dsystemd_user_dir="$(systemd_get_userunitdir)"
		$(meson_native_use_bool gtk-doc docs)
		$(meson_native_use_feature introspection)
		$(meson_feature X x11)
		-Datk_only=false
		-Dpython="${EPYTHON}"
	)
	meson_src_configure
}

multilib_src_test() {
	# Avoid locales using commas as decimal separators and breaking some
	# tests
	LC_ALL=C.UTF-8 virtx dbus-run-session meson test -C "${BUILD_DIR}" || die
}

multilib_src_install_all() {
	einstalldocs
	python_optimize

	if use gtk-doc; then
		mkdir -p "${ED}"/usr/share/gtk-doc/{libatspi,atk} || die
		mv "${ED}"/usr/share/doc/libatspi "${ED}"/usr/share/gtk-doc/libatspi/html || die
		mv "${ED}"/usr/share/doc/atk "${ED}"/usr/share/gtk-doc/atk/html || die
	fi
}
