/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ru.RussianLetterTokenizer;
import org.apache.lucene.analysis.ru.RussianStemFilter;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RussianAnalyzer
extends Analyzer {
    private static final String[] RUSSIAN_STOP_WORDS = new String[]{"\u0430", "\u0431\u0435\u0437", "\u0431\u043e\u043b\u0435\u0435", "\u0431\u044b", "\u0431\u044b\u043b", "\u0431\u044b\u043b\u0430", "\u0431\u044b\u043b\u0438", "\u0431\u044b\u043b\u043e", "\u0431\u044b\u0442\u044c", "\u0432", "\u0432\u0430\u043c", "\u0432\u0430\u0441", "\u0432\u0435\u0441\u044c", "\u0432\u043e", "\u0432\u043e\u0442", "\u0432\u0441\u0435", "\u0432\u0441\u0435\u0433\u043e", "\u0432\u0441\u0435\u0445", "\u0432\u044b", "\u0433\u0434\u0435", "\u0434\u0430", "\u0434\u0430\u0436\u0435", "\u0434\u043b\u044f", "\u0434\u043e", "\u0435\u0433\u043e", "\u0435\u0435", "\u0435\u0439", "\u0435\u044e", "\u0435\u0441\u043b\u0438", "\u0435\u0441\u0442\u044c", "\u0435\u0449\u0435", "\u0436\u0435", "\u0437\u0430", "\u0437\u0434\u0435\u0441\u044c", "\u0438", "\u0438\u0437", "\u0438\u043b\u0438", "\u0438\u043c", "\u0438\u0445", "\u043a", "\u043a\u0430\u043a", "\u043a\u043e", "\u043a\u043e\u0433\u0434\u0430", "\u043a\u0442\u043e", "\u043b\u0438", "\u043b\u0438\u0431\u043e", "\u043c\u043d\u0435", "\u043c\u043e\u0436\u0435\u0442", "\u043c\u044b", "\u043d\u0430", "\u043d\u0430\u0434\u043e", "\u043d\u0430\u0448", "\u043d\u0435", "\u043d\u0435\u0433\u043e", "\u043d\u0435\u0435", "\u043d\u0435\u0442", "\u043d\u0438", "\u043d\u0438\u0445", "\u043d\u043e", "\u043d\u0443", "\u043e", "\u043e\u0431", "\u043e\u0434\u043d\u0430\u043a\u043e", "\u043e\u043d", "\u043e\u043d\u0430", "\u043e\u043d\u0438", "\u043e\u043d\u043e", "\u043e\u0442", "\u043e\u0447\u0435\u043d\u044c", "\u043f\u043e", "\u043f\u043e\u0434", "\u043f\u0440\u0438", "\u0441", "\u0441\u043e", "\u0442\u0430\u043a", "\u0442\u0430\u043a\u0436\u0435", "\u0442\u0430\u043a\u043e\u0439", "\u0442\u0430\u043c", "\u0442\u0435", "\u0442\u0435\u043c", "\u0442\u043e", "\u0442\u043e\u0433\u043e", "\u0442\u043e\u0436\u0435", "\u0442\u043e\u0439", "\u0442\u043e\u043b\u044c\u043a\u043e", "\u0442\u043e\u043c", "\u0442\u044b", "\u0443", "\u0443\u0436\u0435", "\u0445\u043e\u0442\u044f", "\u0447\u0435\u0433\u043e", "\u0447\u0435\u0439", "\u0447\u0435\u043c", "\u0447\u0442\u043e", "\u0447\u0442\u043e\u0431\u044b", "\u0447\u044c\u0435", "\u0447\u044c\u044f", "\u044d\u0442\u0430", "\u044d\u0442\u0438", "\u044d\u0442\u043e", "\u044f"};
    private final Set<?> stopSet;
    private final Version matchVersion;

    public RussianAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public RussianAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet((String[])stopwords));
    }

    public RussianAnalyzer(Version matchVersion, Set<?> stopwords) {
        this.stopSet = CharArraySet.unmodifiableSet((CharArraySet)CharArraySet.copy(stopwords));
        this.matchVersion = matchVersion;
    }

    public RussianAnalyzer(Version matchVersion, Map<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new RussianLetterTokenizer(reader);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stopSet);
        result = new RussianStemFilter((TokenStream)result);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new RussianLetterTokenizer(reader);
            streams.result = new LowerCaseFilter((TokenStream)streams.source);
            streams.result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.result, this.stopSet);
            streams.result = new RussianStemFilter(streams.result);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    static /* synthetic */ String[] access$000() {
        return RUSSIAN_STOP_WORDS;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET = CharArraySet.unmodifiableSet((CharArraySet)new CharArraySet(Arrays.asList(RussianAnalyzer.access$000()), false));

        private DefaultSetHolder() {
        }
    }
}

