/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SingletonItem;

public class SingletonIterator
implements UnfailingIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private Item item;
    private int position = 0;

    private SingletonIterator(Item value) {
        this.item = value;
    }

    public static UnfailingIterator makeIterator(Item item) {
        if (item == null) {
            return EmptyIterator.getInstance();
        }
        return new SingletonIterator(item);
    }

    public boolean hasNext() {
        return this.position == 0;
    }

    public Item next() {
        if (this.position == 0) {
            this.position = 1;
            return this.item;
        }
        if (this.position == 1) {
            this.position = -1;
            return null;
        }
        return null;
    }

    public Item current() {
        if (this.position == 1) {
            return this.item;
        }
        return null;
    }

    public int position() {
        return this.position;
    }

    public int getLastPosition() {
        return 1;
    }

    public void close() {
    }

    public SequenceIterator getAnother() {
        return new SingletonIterator(this.item);
    }

    public SequenceIterator getReverseIterator() {
        return new SingletonIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    public GroundedValue materialize() {
        if (this.item instanceof AtomicValue) {
            return (AtomicValue)this.item;
        }
        return new SingletonItem(this.item);
    }

    public int getProperties() {
        return 7;
    }
}

