/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Pipeline;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.Step;
import java.util.Vector;

public class Environment {
    private Vector<Step> visibleSteps = new Vector();
    private Port defaultReadablePort = null;
    private Step pipeline = null;
    private Environment parent = null;

    public Environment(Step step) {
        this.pipeline = step;
        this.visibleSteps.add(step);
    }

    public Environment(Environment environment) {
        this.parent = environment;
        this.pipeline = environment.pipeline;
        this.defaultReadablePort = environment.defaultReadablePort;
    }

    public Environment getParent() {
        return this.parent;
    }

    protected void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
        this.addStep(pipeline);
    }

    public void addStep(Step step) {
        this.visibleSteps.add(step);
    }

    public void setDefaultReadablePort(Port port) {
        this.defaultReadablePort = port;
    }

    public Port getDefaultReadablePort() {
        return this.defaultReadablePort;
    }

    public int countVisibleSteps(String string) {
        int n = 0;
        for (Step step : this.visibleSteps) {
            if (!step.getName().equals(string)) continue;
            ++n;
        }
        if (this.parent != null) {
            n += this.parent.countVisibleSteps(string);
        }
        return n;
    }

    public Step visibleStep(String string) {
        for (Step step : this.visibleSteps) {
            if (!step.getName().equals(string)) continue;
            return step;
        }
        if (this.parent != null) {
            return this.parent.visibleStep(string);
        }
        return null;
    }

    public Output readablePort(String string, String string2) {
        Step step = this.visibleStep(string);
        if (step != null) {
            return step.getOutput(string2);
        }
        return null;
    }
}

