/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;
import com.icl.saxon.tinytree.TinyNodeImpl;

final class FollowingEnumeration
implements AxisEnumeration {
    private TinyDocumentImpl document;
    private TinyNodeImpl startNode;
    private int nextNodeNr;
    private NodeTest test;
    int last = -1;
    boolean includeDescendants;

    public FollowingEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.test = nodeTest;
        this.startNode = tinyNodeImpl;
        this.nextNodeNr = tinyNodeImpl.nodeNr;
        this.includeDescendants = bl;
        short s = tinyDocumentImpl.depth[this.nextNodeNr];
        if (bl) {
            ++this.nextNodeNr;
        } else {
            do {
                ++this.nextNodeNr;
                if (this.nextNodeNr < tinyDocumentImpl.numberOfNodes) continue;
                this.nextNodeNr = -1;
                return;
            } while (tinyDocumentImpl.depth[this.nextNodeNr] > s);
        }
        if (!this.test.matches(tinyDocumentImpl.nodeType[this.nextNodeNr], tinyDocumentImpl.nameCode[this.nextNodeNr])) {
            this.advance();
        }
    }

    private void advance() {
        do {
            ++this.nextNodeNr;
            if (this.nextNodeNr < this.document.numberOfNodes) continue;
            this.nextNodeNr = -1;
            return;
        } while (!this.test.matches(this.document.nodeType[this.nextNodeNr], this.document.nameCode[this.nextNodeNr]));
    }

    public boolean hasMoreElements() {
        return this.nextNodeNr >= 0;
    }

    public NodeInfo nextElement() {
        TinyNodeImpl tinyNodeImpl = this.document.getNode(this.nextNodeNr);
        this.advance();
        return tinyNodeImpl;
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return false;
    }

    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        FollowingEnumeration followingEnumeration = new FollowingEnumeration(this.document, this.startNode, this.test, this.includeDescendants);
        this.last = 0;
        while (followingEnumeration.hasMoreElements()) {
            followingEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

