/*
 * SSMFlagbyteDefinitions_en.cpp - SSM flagbyte definitions (en)
 *
 * Copyright (C) 2008-2019 Comer352L
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "SSMFlagbyteDefinitions_en.h"


// Measuring Blocks (data):
const QStringList SSMFlagbyteDefinitions_en::_MB_defs_en =
	QStringList()
	<< "1;1;3;00000F;00000E;Engine Speed;rpm;/4;0"
	<< "1;2;1;00000D;;Manifold Absolute Pressure;kPa;*1;0"
	<< "1;3;1;00000C;;Air/Fuel Learning #2;%;-128/128*100;1"
	<< "1;4;1;00000B;;Air/Fuel Correction #2;%;-128/128*100;1"
	<< "1;5;1;00000A;;Air/Fuel Learning #1;%;-128/128*100;1"
	<< "1;6;1;000009;;Air/Fuel Correction #1;%;-128/128*100;1"
	<< "1;7;1;000008;;Coolant Temperature;°C;-40;0"
	<< "1;8;1;000007;;Engine Load;%;/255*100;1"
	<< "2;1;1;00001B;00001A;Front O2 Sensor #2 Voltage;V;/200;3"
	<< "2;2;1;000019;000018;Rear O2 Sensor Voltage;V;/200;3"
	<< "2;3;1;000017;000016;Front O2 Sensor #1 Voltage;V;/200;3"
	<< "2;4;1;000015;;Throttle Opening Angle;%;/255*100;1"
	<< "2;5;1;000014;000013;Mass Air Flow;g/s;/100;2"
	<< "2;6;1;000012;;Intake Air Temperature;°C;-40;0"
	<< "2;7;1;000011;;Ignition Timing;deg;-128/2;1"
	<< "2;8;1;000010;;Vehicle Speed;km/h;*1;0"
	<< "3;1;1;000023;;Atmosphere Pressure;kPa;*1;0"
	<< "3;2;1;000022;;Knocking Correction;deg;-128/2;1"
	<< "3;3;1;000021;;Fuel Injection #2 Pulse;ms;*256/1000;2"
	<< "3;4;1;000020;;Fuel Injection #1 Pulse;ms;*256/1000;2"
	<< "3;5;1;00001F;;Differential Pressure Sensor Voltage;V;/50;2"
	<< "3;6;3;00001E;;Throttle Sensor Voltage;V;/50;2"
	<< "3;7;3;00001D;;Air Flow Sensor Voltage;V;/50;2"
	<< "3;8;3;00001C;;Battery Voltage;V;*2/25;1"
	<< "4;1;1;00002B;;Front O2 Sensor #1 Heater Current;A;/255*10;2"
	<< "4;2;1;00002A;;Fuel Temperature;°C;-40;0"
	<< "4;3;3;000029;;Accelerator Pedal Travel;%;/255*100;1"
	<< "4;4;1;000028;;Learned Ignition Timing;deg;-128/2;1"
	<< "4;5;1;000027;;CO Adjustment Voltage;V;/50;2"
	<< "4;6;1;000026;;Fuel Tank Pressure;kPa;-128/40;2"
	<< "4;7;1;000025;;Pressure Differential Sensor;kPa;-128;0"
	<< "4;8;1;000024;;Manifold Relative Pressure;kPa;-128;0"
	<< "5;1;1;000033;;Tumble Generator Valve (TGV) Position Sensor (Right);V;/50;2"
	<< "5;2;1;000032;;Canister Purge Control (CPC) Valve Duty Ratio;%;/255*100;0"
	<< "5;3;1;000031;;Secondary Wastegate Duty Cycle;%;/255*100;1"
	<< "5;4;1;000030;;Primary Wastegate Duty Cycle;%;/255*100;1"
	<< "5;5;1;00002F;;Radiator Fan Control;%;*1;0"
	<< "5;6;1;00002E;;Fuel Level Sensor Voltage;V;/50;2"
	<< "5;7;1;00002D;;Front O2 Sensor #2 Heater Current;A;/255*10;2"
	<< "5;8;1;00002C;;Rear O2 Sensor Heater Current;A;/255*10;2"
	<< "6;1;1;00003B;;Fuel Pump Duty;%;/255*100;0"
	<< "6;2;1;00003A;;Alternator Duty;%;*1;0"
	<< "6;3;1;000039;;Number of Exhaust Gas Recirculation (EGR) Steps;steps;*1;0"
	<< "6;4;1;000038;;Idle Speed Control (ISC) Valve Steps;steps;*1;0"
	<< "6;5;1;000037;;Air/Fuel Heater Duty;%;/255*100;1"
	<< "6;6;1;000036;;Air/Fuel Lean Correction;%;/255*100;0"
	<< "6;7;1;000035;;Idle Speed Control (ISC) Valve Duty Ratio;%;/2;1"
	<< "6;8;1;000034;;Tumble Generator Valve (TGV) Position Sensor (Left);V;/50;2"
	<< "7;1;1;000043;;Air/Fuel Sensor #2 Current;mA;-128/8;2"
	<< "7;2;1;000042;;Air/Fuel Sensor #1 Current;mA;-128/8;2"
	<< "7;3;1;000041;;Oil Flow Control Solenoid Valve (OCV) Current (Left, Intake);mA;*32;0"
	<< "7;4;1;000040;;Oil Flow Control Solenoid Valve (OCV) Current (Right, Intake);mA;*32;0"
	<< "7;5;1;00003F;;Oil Flow Control Solenoid Valve (OCV) Duty (Left, Intake);%;/255*100;1"
	<< "7;6;1;00003E;;Oil Flow Control Solenoid Valve (OCV) Duty (Right, Intake);%;/255*100;1"
	<< "7;7;1;00003D;;Variable Valve Timing (VVT) Advance Angle Amount (Left, Intake);deg;-50;0"
	<< "7;8;1;00003C;;Variable Valve Timing (VVT) Advance Angle Amount (Right, Intake);deg;-50;0"
	<< "8;1;1;0000D3;;Air/Fuel Adjust Voltage;V;/50;2"
	<< "8;2;1;0000D2;;Rear O2 Sensor Heater Voltage;V;/50;2"
	<< "8;3;1;0000D1;;Air/Fuel Learning #3;%;-128/128*100;2"
	<< "8;4;1;0000D0;;Air/Fuel Correction #3;%;-64/128*10;2"
	<< "8;5;1;000047;;Air/Fuel Sensor #2 Lambda;;/128;2"
	<< "8;6;1;000046;;Air/Fuel Sensor #1 Lambda;;/128;2"
	<< "8;7;1;000045;;Air/Fuel Sensor #2 Resistance;ohms;*1;0"
	<< "8;8;1;000044;;Air/Fuel Sensor #1 Resistance;ohms;*1;0"
	<< "9;1;2;00004F;;Turbine Revolution Speed;rpm;*32;0"
	<< "9;2;2;00004E;;Throttle Sensor Voltage;V;/45;2"
	<< "9;3;2;00004D;;Transfer Duty Ratio;%;/2;1"
	<< "9;4;2;00004C;;Lock Up Duty Ratio;%;/2;1"
	<< "9;5;2;00004B;;Line Pressure Duty Ratio;%;/2;1"
	<< "9;6;3;00004A;;Gear Position;gear;+1;0"
	<< "9;7;2;000049;;ATF Temperature;°C;0=-60,1=-60,2=-51,3=-45,4=-40,5=-37,6=-34,7=-31,8=-29,9=-27,10=-25,11=-23,12=-22,13=-20,14=-19,15=-17,16=-16,17=-15,18=-14,19=-13,20=-12,21=-10,22=-9,23=-9,24=-8,25=-7,26=-6,27=-5,28=-4,29=-3,30=-2,31=-2,32=-1,33=0,34=1,35=1,36=2,37=3,38=3,39=4,40=5,41=5,42=6,43=7,44=7,45=8,46=8,47=9,48=10,49=10,50=11,51=11,52=12,53=12,54=13,55=13,56=14,57=15,58=15,59=16,60=16,61=17,62=17,63=18,64=18,65=19,66=19,67=20,68=20,69=21,70=21,71=22,72=22,73=23,74=23,75=23,76=24,77=24,78=25,79=25,80=26,81=26,82=27,83=27,84=28,85=28,86=29,87=29,88=29,89=30,90=30,91=31,92=31,93=32,94=32,95=33,96=33,97=33,98=34,99=34,100=35,101=35,102=36,103=36,104=37,105=37,106=37,107=38,108=38,109=39,110=39,111=40,112=40,113=41,114=41,115=41,116=42,117=42,118=43,119=43,120=44,121=44,122=45,123=45,124=45,125=46,126=46,127=47,128=47,129=48,130=48,131=49,132=49,133=50,134=50,135=50,136=51,137=51,138=52,139=52,140=53,141=53,142=54,143=54,144=55,145=55,146=56,147=56,148=57,149=57,150=58,151=58,152=59,153=59,154=60,155=60,156=61,157=61,158=62,159=62,160=63,161=63,162=64,163=65,164=65,165=66,166=66,167=67,168=67,169=68,170=68,171=69,172=70,173=70,174=71,175=71,176=72,177=73,178=73,179=74,180=75,181=75,182=76,183=77,184=77,185=78,186=79,187=79,188=80,189=81,190=81,191=82,192=83,193=84,194=84,195=85,196=86,197=87,198=88,199=88,200=89,201=90,202=91,203=92,204=93,205=94,206=95,207=96,208=97,209=98,210=99,211=100,212=101,213=102,214=103,215=104,216=105,217=107,218=108,219=109,220=110,221=112,222=113,223=115,224=116,225=118,226=119,227=121,228=123,229=125,230=127,231=129,232=131,233=133,234=135,235=138,236=140,237=143,238=146,239=149,240=152,241=156,242=159,243=164,244=168,245=173,246=179,247=186,248=193,249=202,250=212,251=225,252=241,253=264,254=300,255=373;0"
	<< "9;8;2;000048;;Front Wheel Speed;km/h;*1;0"
	<< "10;1;2;000057;;Low Clutch Duty;%;/2;1"
	<< "10;2;2;000056;;ATF Temperature;°C;-50;0"
	<< "10;3;2;000055;;Lateral G Sensor Voltage;V;/50;2"
	<< "10;4;1;000054;;Air/Fuel Sensor #2 Heater Current;A;/10;1"
	<< "10;5;1;000053;;Air/Fuel Sensor #1 Heater Current;A;/10;1"
	<< "10;6;2;000052;;Manifold Pressure Sensor Voltage;V;/50;2"
	<< "10;7;2;000051;;Rear Wheel Speed;km/h;*1;0"
	<< "10;8;2;000050;;Brake Clutch Duty Ratio;%;/2;1"
	<< "11;1;2;00005F;;Center Differential Indicate Current;A;/32;2"
	<< "11;2;2;00005E;;Center Differential Real Current;A;/32;2"
	<< "11;3;2;00005D;;AT Turbine Speed 2;rpm;*32;0"
	<< "11;4;2;00005C;;AT Turbine Speed 1;rpm;*32;0"
	<< "11;5;2;00005B;;Voltage Center Differential Switch;V;/51;2"
	<< "11;6;2;00005A;;ATF Temperature 2;°C;-50;0"
	<< "11;7;2;000059;;Low & Reverse Brake (L&R B) Duty;%;/2;1"
	<< "11;8;2;000058;;High Clutch Duty;%;/2;1"
	<< "31;5;1;0000FB;;Throttle Motor Voltage;V;*2/25;1"
	<< "31;6;1;0000FA;;Throttle Motor Duty;%;-128/128*100;0"
	<< "31;7;1;00016B;;Throttle Sensor Closed Voltage;V;/50;2"
	<< "31;8;3;00016A;;SI-Drive Mode;;0=---,1=S,2=S#,3=I,8=S#,16=I;"
	<< "33;1;1;000107;;Exhaust Gas Temperature 2;°C;*5+200;0"
	<< "33;2;1;000106;;Exhaust Gas Temperature;°C;*5+200;0"
	<< "33;3;1;000105;;Fuel Pressure;kPa;*2;0"
	//<< "33;4;1;1;000104;;Brake Booster Pressure;kPa;*1;0"			// UNCONFIRMED !!!
	<< "33;5;1;000103;;Main-Accelerator Sensor Voltage;V;/50;2"
	<< "33;6;3;000102;;Sub-Accelerator Sensor Voltage;V;/50;2"
	<< "33;7;1;000101;;Main-Throttle Sensor Voltage;V;/50;2"
	<< "33;8;1;000100;;Sub-Throttle Sensor Voltage;V;/50;2"
	<< "34;1;1;000173;000172;Fuel Tank Air Presser Pressure;MPa;/100;1"
	<< "34;2;1;00010F;00010E;Odometer;km;*2;0"
	<< "34;3;1;00010D;;Fuel Level Sensor Resistance;ohms;*4/2;1"
	<< "34;4;1;00010C;;Air/Fuel Learning #4;%;-128/128*100;2"
	<< "34;5;1;00010B;;Air/Fuel Correction #4;%;-64/128*10;2"
	<< "34;6;1;00010A;;Memorized Cruise Speed;km/h;*1;0"
	<< "34;7;1;000183;000182;Secondary Air Flow;g/s;/100;2"
	<< "34;8;1;000108;;Secondary Air Piping Pressure;kPa;*1;0"
	<< "35;1;1;000117;;Oil Switching Solenoid Valve (OSV) Current (Left);mA;*32;0"
	<< "35;2;1;000116;;Oil Switching Solenoid Valve (OSV) Current (Right);mA;*32;0"
	<< "35;3;1;000115;;Oil Switching Solenoid Valve (OSV) Duty (Left);%;/255*100;1"
	<< "35;4;1;000114;;Oil Switching Solenoid Valve (OSV) Duty (Right);%;/255*100;1"
	<< "35;5;1;000113;;Oil Temperature;°C;-40;0"
	<< "36;2;1;00011E;;VVL Lift Mode;;*1;0"
	<< "36;3;1;00011D;;Oil Flow Control Solenoid Valve (OCV) Current (Left, Exhaust);mA;*32;0"
	<< "36;4;1;00011C;;Oil Flow Control Solenoid Valve (OCV) Current (Right, Exhaust);mA;*32;0"
	<< "36;5;1;00011B;;Oil Flow Control Solenoid Valve (OCV) Duty (Left, Exhaust);%;/255*100;1"
	<< "36;6;1;00011A;;Oil Flow Control Solenoid Valve (OCV) Duty (Right, Exhaust);%;/255*100;1"
	<< "36;7;1;000119;;Variable Valve Timing (VVT) Retard Angle (Left, Exhaust);deg;-50;0"
	<< "36;8;1;000118;;Variable Valve Timing (VVT) Retard Angle (Right, Exhaust);deg;-50;0"
	<< "43;1;2;000147;;Yaw Rate Sensor Voltage;V;/51;2"
	<< "43;2;2;000146;;AWD Solenoid Valve Current;A;/255;2"
	<< "43;3;2;000145;;L/U Solenoid Valve Current;A;/255;2"
	<< "43;4;2;000144;;P/L Solenoid Valve Current;A;/255;2"
	<< "43;5;2;000143;;I/C Solenoid Valve Current;A;/255;2"
	<< "43;6;2;000142;;F/B Solenoid Valve Current;A;/255;2"
	<< "43;7;2;000141;;D/C Solenoid Valve Current;A;/255;2"
	<< "43;8;2;000140;;H&LR/C Solenoid Valve Current;A;/255;2"
	<< "44;1;2;00014F;;Yaw Rate & G Sensor Reference Voltage;V;/51;2"
	<< "44;2;2;00014E;;AWD Solenoid Valve Pressure;kPa;*10;0"
	<< "44;3;2;00014D;;L/U Solenoid Valve Pressure;kPa;*10;0"
	<< "44;4;2;00014C;;P/L Solenoid Valve Pressure;kPa;*10;0"
	<< "44;5;2;00014B;;I/C Solenoid Valve Pressure;kPa;*10;0"
	<< "44;6;2;00014A;;F/B Solenoid Valve Pressure;kPa;*10;0"
	<< "44;7;2;000149;;D/C Solenoid Valve Pressure;kPa;*10;0"
	<< "44;8;2;000148;;H&LR/C Solenoid Valve Pressure;kPa;*10;0"
	<< "45;1;2;000186;;Fwd/B Solenoid Valve Target Pressure;kPa;*10;0"
	<< "45;2;2;000185;;Fwd/B Solenoid Valve Current;A;/255;2"
	<< "45;4;2;00015A;00008D;Steering Angle Sensor;deg;s16*1;0"
	<< "45;5;2;00013F;;Wheel Speed Rear Left;km/h;*1;0"
	<< "45;6;2;00013E;;Wheel Speed Rear Right;km/h;*1;0"
	<< "45;7;2;00013D;;Wheel Speed Front Left;km/h;*1;0"
	<< "45;8;2;00013C;;Wheel Speed Front Right;km/h;*1;0"
	<< "48;1;1;000199;;Knocking Correction;deg;-128/4;1"
	<< "48;2;1;0000F9;;Learned Ignition Timing Correction;deg;/16;1"
	<< "48;3;1;0000F8;;Roughness Monitor Cylinder #6;;*1;0"
	<< "48;4;1;0000EF;;Roughness Monitor Cylinder #5;;*1;0"
	<< "48;5;1;0000D9;;Roughness Monitor Cylinder #4;;*1;0"
	<< "48;6;1;0000D8;;Roughness Monitor Cylinder #3;;*1;0"
	<< "48;7;1;0000CF;;Roughness Monitor Cylinder #2;;*1;0"
	<< "48;8;1;0000CE;;Roughness Monitor Cylinder #1;;*1;0"
	<< "52;8;1;00019A;;Fuel Tank Pressure;kPa;-128/20;2"
	<< "53;1;1;0001E9;;Exhaust Gas Recirculation (EGR) Valve Opening Angle;deg;-50;0"
	<< "53;2;1;0001E8;;Exhaust Gas Recirculation (EGR) Target Valve Opening Angle;deg;-50;0"
	<< "53;3;1;0001E7;;Air Mass;mg/cyl;*10;0"
	<< "53;4;1;0001E6;;Target Intake Air Amount;mg/cyl;*10;0"
	<< "53;5;1;0001E5;;Target Intake Manifold Pressure;kPa;*1;0"
	<< "53;6;1;0001E4;;Number of Times Injected;;*1;0"
	<< "53;7;1;0001E3;0001E2;Final Injection Amount;mm³;/256;4"
	<< "53;8;1;0001E1;;Main Injection Period;°CA;/5-15;1"
	<< "54;1;1;0001F7;0001F6;Target Fuel Pump Current;mA;*1;0"
	<< "54;2;1;0001F5;;Electric Power Steering Current;A;*1;0"
	<< "54;3;1;0001F0;;Boost Pressure Feedback;%;-128;0"
	<< "54;4;1;0001EF;0001EE;Target Engine Speed;rpm;/4;0"
	<< "54;5;1;0001ED;;Intake Air Temperature (combined);°C;-40;0"
	<< "54;6;1;0001EC;;Common Rail Pressure;MPa;*1;0"
	<< "54;7;1;0001EB;;Common Rail Target Pressure;MPa;*1;0"
	<< "54;8;1;0001EA;;Exhaust Gas Recirculation (EGR) Duty;%;*1;0"
	<< "55;5;2;0001F4;;Drivers Control Center Differential (DCCD) Mode;;*1;0"
	<< "55;6;2;0001F3;;Drivers Control Center Differential (DCCD) Torque Allocation;;*1;0"
	<< "55;7;2;0001F2;;Lateral G;m/s²;s8*1.0862;2"
	<< "55;8;2;0001F1;;Yaw Rate;deg/s;s8*0.19118;0"
	<< "56;1;1;000260;;Quantity Correction Cylinder #4;ms;-100/100;2"
	<< "56;2;1;00025F;;Quantity Correction Cylinder #3;ms;-100/100;2"
	<< "56;3;1;00025E;;Quantity Correction Cylinder #2;ms;-100/100;2"
	<< "56;4;1;00025D;;Quantity Correction Cylinder #1;ms;-100/100;2"
	<< "56;5;1;000270;;Interior Heater;Steps;*1;0"
	<< "56;6;1;000205;000204;Mileage after Injector Replacement;km;*5;0"
	<< "56;7;1;0001FB;0001FA;Mileage after Injector Learning;km;*5;0"
	<< "56;8;1;0001F9;0001F8;Actual Fuel Pump Current;mA;*1;0"
	<< "57;6;1;000272;;Alternator Control Mode;;0=High,1=ExHigh,2=Low,3=Mid;0"
	<< "57;7;1;000273;;Battery Temperature;°C;-40;0"
	<< "57;8;1;000271;;Battery Current;A;-128;0"
	<< "63;1;1;00027C;;Oil Dilution Ratio;%;*1;0"
	<< "63;2;1;00027B;;Soot Accumulation Ratio;%;*1;0"
	<< "63;3;1;00027A;;Estimated Temperature of the Diesel Particulate Filter (DPF);°C;*5-40;0"
	<< "63;4;1;000279;;Estimated Catalyst Temperature;°C;*5-40;0"
	<< "63;5;1;000278;;Exhaust Gas Temperature at Diesel Particulate Filter (DPF) Inlet;°C;*5-40;0"
	<< "63;6;1;000277;;Exhaust Gas Temperature at Catalyst Inlet;°C;*5-40;0"
	<< "63;7;1;000276;;Pressure Difference between Diesel Particulate Filter (DPF) Inlet and Outlet;kPa;*1;0"
	<< "63;8;1;000275;;Cumulative Ash Ratio;%;*1;0"
	<< "64;5;2;000297;000296;Automatic Transmission Fluid (ATF) Deterioration Degree;%;*40/13107;0"
	<< "64;6;2;000295;;ABS/VDC Rear Wheel Mean Wheel Speed;km/h;*230/255;0"
	<< "64;7;2;000294;;ABS/VDC Front Wheel Mean Wheel Speed;km/h;*230/255;0"
	<< "64;8;2;000293;;Front-Rear Wheel Rotation Ratio;;/128;3"
	<< "65;1;1;00023E;;Micro-Quantity-Injection Final Learning Value 1-2;ms;-128/200;3"
	<< "65;2;1;00023D;;Micro-Quantity-Injection Final Learning Value 1-1;ms;-128/200;3"
	<< "65;3;1;00029E;00029D;Diesel Particulate Filter (DPF) Regeneration Count;Times;*1;0"
	<< "65;4;1;00029C;00029B;Running Distance since last Diesel Particulate Filter (DPF) Regeneration;km;*1;0"
	<< "65;5;1;00029A;;Estimated Distance to Oil Change;km;*100;0"
	<< "65;6;1;00021F;;Actual Common Rail Pressure (Time Syncronized);MPa;*1;0"
	<< "65;7;1;000299;;Accumulated Count of Overspeed Instances (High RPM);Time;*1;0"
	<< "65;8;1;000298;;Accumulated Count of Overspeed Instances (Very High RPM);Time;*1;0"
	<< "66;1;1;000246;;Micro-Quantity-Injection Final Learning Value 3-2;ms;-128/200;3"
	<< "66;2;1;000245;;Micro-Quantity-Injection Final Learning Value 3-1;ms;-128/200;3"
	<< "66;3;1;000244;;Micro-Quantity-Injection Final Learning Value 2-4;ms;-128/200;3"
	<< "66;4;1;000243;;Micro-Quantity-Injection Final Learning Value 2-3;ms;-128/200;3"
	<< "66;5;1;000242;;Micro-Quantity-Injection Final Learning Value 2-2;ms;-128/200;3"
	<< "66;6;1;000241;;Micro-Quantity-Injection Final Learning Value 2-1;ms;-128/200;3"
	<< "66;7;1;000240;;Micro-Quantity-Injection Final Learning Value 1-4;ms;-128/200;3"
	<< "66;8;1;00023F;;Micro-Quantity-Injection Final Learning Value 1-3;ms;-128/200;3"
	<< "67;1;1;00024E;;Micro-Quantity-Injection Final Learning Value 5-2;ms;-128/200;3"
	<< "67;2;1;00024D;;Micro-Quantity-Injection Final Learning Value 5-1;ms;-128/200;3"
	<< "67;3;1;00024C;;Micro-Quantity-Injection Final Learning Value 4-4;ms;-128/200;3"
	<< "67;4;1;00024B;;Micro-Quantity-Injection Final Learning Value 4-3;ms;-128/200;3"
	<< "67;5;1;00024A;;Micro-Quantity-Injection Final Learning Value 4-2;ms;-128/200;3"
	<< "67;6;1;000249;;Micro-Quantity-Injection Final Learning Value 4-1;ms;-128/200;3"
	<< "67;7;1;000248;;Micro-Quantity-Injection Final Learning Value 3-4;ms;-128/200;3"
	<< "67;8;1;000247;;Micro-Quantity-Injection Final Learning Value 3-3;ms;-128/200;3"
	<< "69;5;1;000258;000257;Final Main Injection Period;ms;/1000;3"
	<< "69;6;1;000239;000238;Individual Pump Difference Learning Value;mA;-1000;0"
	<< "69;7;1;000250;;Micro-Quantity-Injection Final Learning Value 5-4;ms;-128/200;3"
	<< "69;8;1;00024F;;Micro-Quantity-Injection Final Learning Value 5-3;ms;-128/200;3";


// Switches:
const QStringList SSMFlagbyteDefinitions_en::_SW_defs_en =
	QStringList()
	<< "12;1;1;000061;Clear Memory Terminal;Off/On"
	<< "12;2;1;000061;Delivery Mode (Test Mode) Connector;Off/On"
	<< "12;3;1;000061;D-Check Require Flag;Off/On"
	<< "12;5;1;000061;Read Memory Signal;Off/On"
	<< "12;6;1;000061;Test Mode Signal;Off/On"
	<< "12;7;1;000061;AT Vehicle ID;Off/On"
	<< "13;2;1;000062;Air Conditioning Switch;Off/On"
	<< "13;3;1;000062;Power Steering Switch;Off/On"
	<< "13;4;3;000062;Ignition Switch;Off/On"
	<< "13;5;1;000062;Intercooler Auto Washer Switch;Off/On"
	<< "13;7;1;000062;Idle Switch;Off/On"
	<< "13;8;3;000062;Neutral Position Switch;Off/On"
	<< "14;1;1;000063;Electrical Load Signal;Off/On"
	<< "14;2;1;000063;Knocking Signal #2;Off/On"
	<< "14;3;1;000063;Knocking Signal #1;Off/On"
	<< "14;4;1;000063;Front O2 Sensor #2 Rich Signal;Off/On"
	<< "14;5;1;000063;Rear O2 Sensor Rich Signal;Off/On"
	<< "14;6;1;000063;Front O2 Sensor #1 Rich Signal;Off/On"
	<< "14;7;1;000063;Starter Switch;Off/On"
	<< "14;8;1;000063;Handle Switch;High Input\\Low Input"
	<< "15;1;1;000064;Air Conditioning Mid Pressure Switch;Off/On"
	<< "15;2;1;000064;Air Conditioning Lock Signal;Off/On"
	<< "15;3;1;000064;Wiper Switch;Off/On"
	<< "15;4;1;000064;Light Switch;Off/On"
	<< "15;5;1;000064;Blower Fan Switch;Off/On"
	<< "15;6;1;000064;Rear Defogger Switch;Off/On"
	<< "15;7;1;000064;Camshaft Position Signal;Off/On"
	<< "15;8;1;000064;Crankshaft Position Signal;Off/On"
	<< "16;1;1;000065;Blow-By Leak Connector;Off/On"
	<< "16;2;1;000065;Canister Purge Control (CPC) Solenoid Valve;Off/On"
	<< "16;3;1;000065;Intercooler Auto Washer Relay;Off/On"
	<< "16;4;1;000065;Fuel Pump Relay;Off/On"
	<< "16;5;1;000065;Radiator Fan Relay #2;Off/On"
	<< "16;6;1;000065;Radiator Fan Relay #1;Off/On"
	<< "16;7;1;000065;Radiator Fan Relay #3;Off/On"
	<< "16;8;1;000065;Air Conditioning Compressor Signal;Off/On"
	<< "17;1;1;000066;Assist Air Solenoid Valve;Off/On"
	<< "17;2;1;000066;Power Steering Solenoid Valve;Off/On"
	<< "17;3;1;000066;Ventilation Solenoid Valve;Off/On"
	<< "17;4;1;000066;Pressure Sources Change;Off/On"
	<< "17;5;1;000066;Variable Intake Air Solenoid;Off/On"
	<< "17;6;1;000066;Tumble Generator Valve (TGV) Drive;Close/Open"
	<< "17;7;1;000066;Tumble Generator Valve (TGV) Output;Off/On"
	<< "17;8;1;000066;Positive Crankcase Ventilation (PCV) Solenoid Valve;Off/On"
	<< "18;1;1;000067;Muffler Control;Off/On"
	<< "18;2;1;000067;Intake Air Solenoid;Off/On"
	<< "18;3;1;000067;Exhaust Gas Negative Pressure;Off/On"
	<< "18;4;1;000067;Exhaust Gas Positive Pressure;Off/On"
	<< "18;5;1;000067;Traction Control System (TCS) Relief Valve Solenoid;Off/On"
	<< "18;6;1;000067;Relief Valve Solenoid #2;Off/On"
	<< "18;7;1;000067;Relief Valve Solenoid #1;Off/On"
	<< "18;8;1;000067;Tank Sensor Control Valve;Off/On"
	<< "19;1;1;000068;Request Torque Down VDC;Off/On"
	<< "19;2;1;000068;Ban of Torque Down;On\\Off"
	<< "19;3;1;000068;Fuel Cut Signal From AT;Off/On"
	<< "19;4;1;000068;Retard Signal From AT;Off/On"
	<< "19;5;1;000068;Canister Purge Control (CPC) Solenoid Valve #2;Off/On"
	<< "19;6;1;000068;Engine Oil Pressure Switch #2;Off/On"
	<< "19;7;1;000068;Engine Oil Pressure Switch #1;Off/On"
	<< "19;8;1;000068;Exhaust By-Pass Valve;Off/On"
	<< "20;1;1;000069;AT Engine Torque Request (AET) Signal;High\\Low"
	<< "20;2;1;000069;AT Cooperation Rich Spike Signal;Off/On"
	<< "20;3;1;000069;AT Cooperation Lean Burn Signal;Off/On"
	<< "20;4;1;000069;AT Cooperation Lock Up Signal;Off/On"
	<< "20;5;1;000069;Engine AT Masking Flag (EAM) Signal;High\\Low"
	<< "20;6;1;000069;Torque Permission Signal;Off/On"
	<< "20;7;1;000069;Torque Control Signal #2;Off/On"
	<< "20;8;1;000069;Torque Control Signal #1;Off/On"
	<< "21;1;2;00006A;Front Wheel Drive (FWD) Switch;Off/On"
	<< "21;2;3;00006A;Kick Down Switch;Off/On"
	<< "21;3;2;00006A;Upshift Switch;Off/On"
	<< "21;4;2;00006A;Stop Light Switch;Off/On"
	<< "21;5;2;00006A;Downshift Switch;Off/On"
	<< "21;6;2;00006A;ABS Signal;Off/On"
	<< "21;7;2;00006A;Cruise Control Signal;Off/On"
	<< "21;8;2;00006A;Tiptronic Mode Switch;Off/On"
	<< "22;1;2;00006B;N/P Range Signal;Off/On"
	<< "22;2;2;00006B;R Range Signal;Off/On"
	<< "22;3;2;00006B;D Range Signal;Off/On"
	<< "22;4;2;00006B;3rd Range Signal;Off/On"
	<< "22;5;2;00006B;2nd Range Signal;Off/On"
	<< "22;6;2;00006B;1st Range Signal;Off/On"
	<< "22;7;2;00006B;Hold Mode Switch;Off/On"
	<< "22;8;2;00006B;Power Mode Switch;Off/On"
	<< "23;1;2;00006C;Shift Solenoid #1;Off/On"
	<< "23;2;2;00006C;Shift Solenoid #2;Off/On"
	<< "23;3;2;00006C;Low Clutch Timing Solenoid;Off/On"
	<< "23;4;2;00006C;2-4 Brake Timing Solenoid;Off/On"
	<< "23;5;2;00006C;Torque Control Signal #2;Off/On"
	<< "23;6;2;00006C;Torque Control Signal #1;Off/On"
	<< "23;7;2;00006C;Tiptronic Solenoid;Off/On"
	<< "23;8;2;00006C;4th Range Signal;Off/On"
	<< "24;1;2;00006D;Shift Lock Solenoid;Off/On"
	<< "24;2;2;00006D;ATF Temperature Lamp;Off/On"
	<< "24;3;2;00006D;Rear Differential Oil Temperature Switch;Off/On"
	<< "24;4;2;00006D;Diagnosis Lamp;Off/On"
	<< "24;5;2;00006D;Shift Output 1;Off/On"
	<< "24;6;2;00006D;Shift Output 2;Off/On"
	<< "24;7;2;00006D;Shift Output 3;Off/On"
	<< "24;8;2;00006D;Shift Output 4;Off/On"
	<< "25;1;2;00006E;N Range;Off/On"
	<< "25;2;2;00006E;Hold Lamp;Off/On"
	<< "25;3;2;00006E;Traction Control System (TCS) Switch;Off/On"
	<< "25;4;2;00006E;P/N Signal;Off/On"
	<< "25;5;2;00006E;Torque Control Cut Signal;Off/On"
	<< "25;6;2;00006E;P Range;Off/On"
	<< "25;7;2;00006E;Power Mode Lamp;Off/On"
	<< "25;8;3;00006E;Economy Switch;Off/On"
	<< "28;1;2;0000D4;AT Power Relay;Off/On"
	<< "28;2;2;0000D4;Back Lamp Relay;Off/On"
	<< "28;3;2;0000D4;Inhibitor Switch #3 Monitor;Low/High"
	<< "28;4;2;0000D4;Inhibitor Switch #4;Low/High"
	<< "28;5;2;0000D4;Inhibitor Switch #3;Low/High"
	<< "28;6;2;0000D4;Inhibitor Switch #2;Low/High"
	<< "28;7;2;0000D4;Inhibitor Switch #1;Low/High"
	<< "28;8;2;0000D4;Judgement of All Wheel Drive (AWD);Off/On"
	<< "32;1;2;0000D5;Signal of Identified Electronic Control Module (ECM);Off/On"
	<< "32;2;2;0000D5;LC/B Fluid Pressure;Off/On"
	<< "32;3;2;0000D5;I/C Fluid Pressure;Off/On"
	<< "32;4;2;0000D5;F/B Fluid Pressure;Off/On"
	<< "32;5;2;0000D5;D/C Fluid Pressure;Off/On"
	<< "32;6;2;0000D5;H&LR/C Fluid Pressure;Off/On"
	<< "37;6;1;000120;Injector Driver Relay;Off/On"
	<< "37;7;1;000120;Electronic Throttle Control (ETC) Motor Relay;Off/On"
	<< "37;8;1;000120;Idle Switch;Off/On"
	<< "38;1;3;000121;Cruise Control Status;Off/On"
	<< "38;2;1;000121;Main (Cruise) Switch;Off/On"
	<< "38;3;1;000121;Inhibitor Switch;Off/On"
	<< "38;4;1;000121;Brake Switch;Off/On"
	<< "38;5;1;000121;Resume/Accelerate Switch;Off/On"
	<< "38;6;1;000121;Set/Coast Switch;Off/On"
	<< "38;7;1;000121;Stop Light Switch;Off/On"
	<< "38;8;1;000121;Clutch Switch;Off/On"
	<< "39;1;2;000122;Center Differential Lamp 6;Off/On"
	<< "39;2;2;000122;Center Differential Lamp 5;Off/On"
	<< "39;3;2;000122;Center Differential Lamp 4;Off/On"
	<< "39;4;2;000122;Center Differential Lamp 3;Off/On"
	<< "39;5;2;000122;Center Differential Lamp 2;Off/On"
	<< "39;6;2;000122;Center Differential Lamp 1;Off/On"
	<< "39;7;2;000122;LU&FWD/B Solenoid Valve;Off/On"
	<< "39;8;2;000122;LC/B Solenoid Valve;Off/On"
	<< "46;3;2;0000D6;Automatic Transmission Learning Process;Not Completed/Completed"
	<< "46;4;2;0000D6;Fwd/B Hydraulic Pressure Switch;Off/On"
	<< "46;5;2;0000D6;AUTO Mode Lamp;Off/On"
	<< "46;6;2;0000D6;AUTO/MANUAL Mode Switch;Off/On"
	<< "46;7;2;0000D6;Center Differential Relay;Off/On"
	<< "46;8;2;0000D6;Parking Position Switch;Off/On"
	<< "47;1;1;0000D7;Cruise Control Cancel Switch;Off/On"
	<< "47;2;1;0000D7;Distance Change Switch;Off/On"
	<< "47;3;1;0000D7;Secondary Air Combi Valve Relay #1;Off/On"
	<< "47;4;1;0000D7;Secondary Air Pump Relay;Off/On"
	<< "47;5;1;0000D7;Secondary Air Combi Valve Relay #2;Off/On"
	<< "47;7;1;0000D7;Body Integrated Unit Count;On\\Off"
	<< "47;8;1;0000D7;Body Integrated Unit Data;On\\Off"
	<< "49;6;1;000196;Oil Level Switch;Low Level/High Level"
	<< "49;7;1;000196;Fuel Pressure Switching Solenoid Valve;Off/On"
	<< "49;8;1;000196;Malfunction Indicator Light (MIL) ON Flag;Off/On"
	<< "50;1;1;000197;Injector Learning;Not Completed/Completed"
	<< "50;2;1;000197;Fuel Pump Learning;Not Completed/Completed"
	<< "50;3;1;000197;Request for ''Compressor ON'';Off/On"
	<< "50;4;1;000197;Sub Fuel Pump Relay;Off/On"
	<< "50;5;1;000197;Swirl Control Valve;Open\\Close"
	<< "50;6;1;000197;Glow Relay;Off/On"
	<< "50;7;1;000197;Exhaust Gas Recirculation (EGR) Control Mode;Open/Feedback"
	<< "50;8;1;000197;Boost Pressure Control Mode;Open/Feedback"
	<< "60;7;2;0001CD;Lock-Up ON/OFF Solenoid Valve;Off/On"
	<< "60;8;2;0001CD;Self-Shut Relay Output;Off/On"
	<< "62;4;1;0001CE;Diesel Particulate Filter (DPF) Regeneration;Not In Progress/In Progress"
	<< "62;5;1;0001CE;Clutch Switch for Smart-System;Off/On"
	<< "62;6;1;0001CE;Fuel Pump Mode;Open/Feedback"
	<< "62;7;1;0001CE;Fuel Cut;Not Requested/Requested"
	<< "62;8;1;0001CE;Exhaust Gas Recirculation (EGR) Learning;Not Completed/Completed";


// SUBARU-Trouble Codes:
const QStringList SSMFlagbyteDefinitions_en::_DTC_SUBARU_defs_en =
	QStringList()
	<< "00008E;0000A4;1;24;Idle Control System Malfunction"
	<< "00008E;0000A4;2;23;Mass Air Flow Sensor"
	<< "00008E;0000A4;3;22;Knock Sensor"
	<< "00008E;0000A4;4;21;Engine Coolant Temperature Sensor"
	<< "00008E;0000A4;5;18;Electric Load Signal"
	<< "00008E;0000A4;6;13;Camshaft Position Sensor"
	<< "00008E;0000A4;7;12;Starter Signal"
	<< "00008E;0000A4;8;11;Crankshaft Position Sensor"
	<< "00008F;0000A5;1;37;Rear O2 Sensor Circuit / Air/Fuel Sensor Circuit Malfunction"
	<< "00008F;0000A5;2;35;Canister Purge Control (CPC) System"
	<< "00008F;0000A5;3;33;Vehicle Speed Sensor (front)"
	<< "00008F;0000A5;4;32;Oxygen Sensor"
	<< "00008F;0000A5;5;31;Throttle Position Sensor"
	<< "00008F;0000A5;6;29;Crankshaft Position Sensor 2"
	<< "00008F;0000A5;7;28;Knock Sensor #2"
	<< "00008F;0000A5;8;26;Intake Air Temperature Sensor"
	<< "000090;0000A6;1;45;Pressure Sensor"
	<< "000090;0000A6;2;44;Turbocharging Pressure Control Output Signal"
	<< "000090;0000A6;3;43;Accelerator Pedal Switch"
	<< "000090;0000A6;4;42;Idle Switch"
	<< "000090;0000A6;5;39;Traction Control System (TCS)"
	<< "000090;0000A6;6;38;Torque Permission Signal"
	<< "000090;0000A6;7;38;Torque Control Signal #2"
	<< "000090;0000A6;8;38;Torque Control Signal #1"
	<< "000091;0000A7;1;62;Exhaust Manifold Negative Pressure Control Solenoid Valve"
	<< "000091;0000A7;2;61;Air Suction Control Solenoid Valve"
	<< "000091;0000A7;3;56;Exhaust Gas Recirculation (EGR) System"
	<< "000091;0000A7;4;55;EGR Valve Lift Sensor"
	<< "000091;0000A7;5;54;Air Intake System"
	<< "000091;0000A7;6;51;Neutral Position Switch"
	<< "000091;0000A7;7;49;CO Resistor"
	<< "000091;0000A7;8;48;Lean Burn System"
	<< "000092;0000A8;1;53;Anti-Quick Operation Mode"
	<< "000092;0000A8;2;66;Twin Turbocharger System (T)"
	<< "000092;0000A8;3;66;Twin Turbocharger System (S)"
	<< "000092;0000A8;4;66;Twin Turbocharger System (H)"
	<< "000092;0000A8;5;66;Two Stage Twin Turbocharger System"
	<< "000092;0000A8;6;65;Differential Pressure Sensor"
	<< "000092;0000A8;7;64;Relief Valve Control Solenoid Valve 1"
	<< "000092;0000A8;8;63;Relief Valve Control Solenoid Valve 2"
	<< "000093;0000A9;1;53;Immobilizer Control Module EEPROM"
	<< "000093;0000A9;2;53;Electronic Gasoline Injection (EGI) Control Module EEPROM"
	<< "000093;0000A9;3;53;Incorrect/Unregistered Immobilizer Key"
	<< "000093;0000A9;4;53;Key Communication Failure"
	<< "000093;0000A9;5;53;Communication Error (Time Over)"
	<< "000093;0000A9;6;53;Immobilizer Circuit Failure (Except Antenna Circuit)"
	<< "000093;0000A9;7;53;Reference Code Incompatibility"
	<< "000093;0000A9;8;53;Antenna"
	<< "000094;0000AA;1;89;Variable Valve Timing (VVT) Systems (right)"
	<< "000094;0000AA;2;88;Fuel Pump Circuit Malfunction"
	<< "000094;0000AA;3;87;Variable Induction Solenoid Valve Circuit Malfunction"
	<< "000094;0000AA;4;86;CAN Communication System"
	<< "000094;0000AA;5;85;Charger System Circuit Malfunction"
	<< "000094;0000AA;6;81;Torque Up Control Valve"
	<< "000094;0000AA;7;68;Turbocharging Pressure Control Output Signal #2"
	<< "000094;0000AA;8;67;Exhaust Manifold Positive Pressure Control Solenoid Valve"
	<< "000095;0000AB;1;89;Variable Valve Timing (VVT) Systems (left)"
	<< "000095;0000AB;3;24;Idle Speed Control (ISC) Valve Stuck"
	<< "000095;0000AB;4;24;Idle Speed Control (ISC) Valve Circuit Open/Short"
	<< "000095;0000AB;5;32;Air/Fuel Sensor #2 System"
	<< "000095;0000AB;6;32;Air/Fuel Sensor #1 System"
	<< "000095;0000AB;7;92;Electrical Generation Control Signal Circuit Malfunction"
	<< "000095;0000AB;8;91;Traction Control System (TCS) Relief Valve"
	<< "000096;0000AC;1;71;Shift Solenoid Valve #1"
	<< "000096;0000AC;2;72;Shift Solenoid Valve #2"
	<< "000096;0000AC;3;73;Low Clutch Timing Solenoid Valve"
	<< "000096;0000AC;4;74;Brake Clutch Timing Solenoid Valve"
	<< "000096;0000AC;5;77;Lock-Up Duty Solenoid Valve"
	<< "000096;0000AC;6;75;Line Pressure Duty Solenoid Valve"
	<< "000096;0000AC;7;76;Brake Clutch Pressure Duty Solenoid Valve"
	<< "000096;0000AC;8;79;Transfer Clutch Duty Solenoid Valve"
	<< "000097;0000AD;1;93;Vehicle Speed Sensor #1 (rear)"
	<< "000097;0000AD;2;27;ATF Temperature Sensor"
	<< "000097;0000AD;3;94;Lateral G Sensor Signal Circuit Malfunction"
	<< "000097;0000AD;4;11;Engine Speed Signal"
	<< "000097;0000AD;5;5-11;Coordination Signal Line"
	<< "000097;0000AD;6;38;Torque Control Signal System"
	<< "000097;0000AD;7;36;Torque Converter Turbine Speed Signal"
	<< "000097;0000AD;8;78;Tiptronic Solenoid Valve System";


// OBD Trouble Codes:
const QStringList SSMFlagbyteDefinitions_en::_DTC_OBD_defs_en =
	QStringList()
	<< "00008E;0000AE;1;P0335;Crankshaft Position Sensor A Circuit Malfunction"
	<< "00008E;0000AE;3;P0336;Crankshaft Position Sensor A Range/Performance Problem"
	<< "00008E;0000AE;4;P0341;Camshaft Position Sensor A Circuit Range/Performance"
	<< "00008E;0000AE;5;P0340;Camshaft Position Sensor A Circuit"
	<< "00008E;0000AE;7;P0604;Internal Control Module Random Access Memory Error"
	<< "00008E;0000AE;8;P0601;Internal Control Module Memory Check Sum Error"
	<< "00008F;0000AF;1;P0102;Mass or Volume Air Flow Circuit Low"
	<< "00008F;0000AF;2;P0103;Mass or Volume Air Flow Circuit High"
	<< "00008F;0000AF;3;P1141;Mass or Volume Air Flow Circuit Range/Performance (Low)"
	<< "00008F;0000AF;4;P0101;Mass or Volume Air Flow Circuit Range/Performance (High)"
	<< "00008F;0000AF;5;P0500;Vehicle Speed Sensor"
	<< "00008F;0000AF;6;P1540;Vehicle Speed Sensor Malfunction at Low Speed"
	<< "00008F;0000AF;7;P0332;Knock Sensor 2 Circuit Malfunction (Low Input)"
	<< "00008F;0000AF;8;P0333;Knock Sensor 2 Circuit Malfunction (High Input)"
	<< "000090;0000B0;1;P0325;Knock Sensor 1 Circuit Malfunction"
	<< "000090;0000B0;2;P0330;Knock Sensor 2 Circuit Malfunction"
	<< "000090;0000B0;3;P0327;Knock Sensor 1 Circuit Malfunction (Low Input)"
	<< "000090;0000B0;4;P0328;Knock Sensor 1 Circuit Malfunction (High Input)"
	<< "000090;0000B0;5;P0122;Throttle Position Sensor Low Input"
	<< "000090;0000B0;6;P0123;Throttle Position Sensor High Input"
	<< "000090;0000B0;7;P1142;Throttle Position Sensor Circuit Performance (Low Input)"
	<< "000090;0000B0;8;P0121;Throttle Position Sensor Circuit Performance (High Input)"
	<< "000091;0000B1;1;P0117;Engine Coolant Temperature Sensor Circuit Low Input"
	<< "000091;0000B1;2;P0118;Engine Coolant Temperature Sensor Circuit High Input"
	<< "000091;0000B1;3;P0464;Fuel Level Sensor Circuit Intermittent"
	<< "000091;0000B1;4;P0125;Insufficient Coolant Temperature for Closed Loop Fuel Control"
	<< "000091;0000B1;5;P0462;Fuel Level Sensor Circuit Low Input"
	<< "000091;0000B1;6;P0463;Fuel Level Sensor Circuit High Input"
	<< "000091;0000B1;7;P0461;Fuel Level Sensor Performance Problem"
	<< "000091;0000B1;8;P1442;Fuel Level Sensor Performance Problem (Travel Distance)"
	<< "000092;0000B2;1;P0107;Pressure Sensor Circuit Low Input"
	<< "000092;0000B2;2;P0108;Pressure Sensor Circuit High Input"
	<< "000092;0000B2;3;P1143;Pressure Sensor Circuit Range/Performance (Low)"
	<< "000092;0000B2;4;P1144;Pressure Sensor Circuit Range/Performance (High)"
	<< "000092;0000B2;5;P0106;Pressure Sensor Circuit Range/Performance"
	<< "000092;0000B2;6;P0350;Ignition Coil Primary/Secondary Circuit"
	<< "000092;0000B2;7;P1518;Starter Switch Circuit Low Input"
	<< "000092;0000B2;8;P0512;Starter Switch Circuit High Input"
	<< "000093;0000B3;1;P0452;Fuel Tank Pressure Sensor Circuit Low Input"
	<< "000093;0000B3;2;P0453;Fuel Tank Pressure Sensor Circuit High Input"
	<< "000093;0000B3;4;P0451;Fuel Tank Pressure Sensor Performance Problem"
	<< "000093;0000B3;5;P1237;Exhaust Control Valve Solenoid Circuit Low (Positive Pressure)"
	<< "000093;0000B3;6;P1238;Exhaust Control Valve Solenoid Circuit High (Positive Pressure)"
	<< "000093;0000B3;7;P1239;Exhaust Control Valve Solenoid Circuit Low (Negative Pressure)"
	<< "000093;0000B3;8;P1240;Exhaust Control Valve Solenoid Circuit High (Negative Pressure)"
	<< "000094;0000B4;1;P1590;Neutral Position Switch Circuit High Input for AT"
	<< "000094;0000B4;2;P1591;Neutral Position Switch Circuit Low Input for AT"
	<< "000094;0000B4;3;P1592;Neutral Position Switch Circuit Malfunction for MT"
	<< "000094;0000B4;4;P0851;Neutral Switch Input Circuit Low"
	<< "000094;0000B4;5;P0182;Fuel Temperature Sensor A Circuit Low Input"
	<< "000094;0000B4;6;P0183;Fuel Temperature Sensor A Circuit High Input"
	<< "000094;0000B4;7;P0181;Fuel Temperature Sensor A Performance Problem"
	<< "000094;0000B4;8;P0852;Neutral Switch Input Circuit High"
	<< "000095;0000B5;1;P1510;ISC Solenoid Valve Signal #1 Circuit Malfunction (Low Input)"
	<< "000095;0000B5;2;P1511;ISC Solenoid Valve Signal #1 Circuit Malfunction (High Input)"
	<< "000095;0000B5;3;P1512;ISC Solenoid Valve Signal #2 Circuit Malfunction (Low Input)"
	<< "000095;0000B5;4;P1513;ISC Solenoid Valve Signal #2 Circuit Malfunction (High Input)"
	<< "000095;0000B5;5;P1514;ISC Solenoid Valve Signal #3 Circuit Malfunction (Low Input)"
	<< "000095;0000B5;6;P1515;ISC Solenoid Valve Signal #3 Circuit Malfunction (High Input)"
	<< "000095;0000B5;7;P1516;ISC Solenoid Valve Signal #4 Circuit Malfunction (Low Input)"
	<< "000095;0000B5;8;P1517;ISC Solenoid Valve Signal #4 Circuit Malfunction (High Input)"
	<< "000096;0000B6;1;P1492;EGR Solenoid Valve Signal #1 Circuit Malfunction (Low Input)"
	<< "000096;0000B6;2;P1493;EGR Solenoid Valve Signal #1 Circuit Malfunction (High Input)"
	<< "000096;0000B6;3;P1494;EGR Solenoid Valve Signal #2 Circuit Malfunction (Low Input)"
	<< "000096;0000B6;4;P1495;EGR Solenoid Valve Signal #2 Circuit Malfunction (High Input)"
	<< "000096;0000B6;5;P1496;EGR Solenoid Valve Signal #3 Circuit Malfunction (Low Input)"
	<< "000096;0000B6;6;P1497;EGR Solenoid Valve Signal #3 Circuit Malfunction (High Input)"
	<< "000096;0000B6;7;P1498;EGR Solenoid Valve Signal #4 Circuit Malfunction (Low Input)"
	<< "000096;0000B6;8;P1499;EGR Solenoid Valve Signal #4 Circuit Malfunction (High Input)"
	<< "000097;0000B7;1;P1102;Pressure Sources Switching Solenoid Valve Circuit Low"
	<< "000097;0000B7;2;P1122;Pressure Sources Switching Solenoid Valve Circuit High"
	<< "000097;0000B7;3;P1446;Fuel Tank Sensor Control Valve Circuit Low"
	<< "000097;0000B7;4;P1447;Fuel Tank Sensor Control Valve Circuit High"
	<< "000097;0000B7;5;P1090;Tumble Generator Valve (TGV) System 1 (Valve Open)"
	<< "000097;0000B7;6;P1091;Tumble Generator Valve (TGV) System 1 (Valve Close)"
	<< "000097;0000B7;7;P1092;Tumble Generator Valve (TGV) System 2 (Valve Open)"
	<< "000097;0000B7;8;P1093;Tumble Generator Valve (TGV) System 2 (Valve Close)"
	<< "000098;0000B8;1;P0508;Idle Control System Circuit Low"
	<< "000098;0000B8;2;P0509;Idle Control System Circuit High"
	<< "000098;0000B8;3;P1507;Idle Control System Malfunction (Fail-safe)"
	<< "000098;0000B8;4;P0506;Idle Control System RPM Lower Than Expected"
	<< "000098;0000B8;5;P0507;Idle Control System RPM Higher Than Expected"
	<< "000098;0000B8;6;P1698;Engine Torque Control Cut Signal Circuit Malfunction (Low Input)"
	<< "000098;0000B8;7;P1699;Engine Torque Control Cut Signal Circuit Malfunction (High Input)"
	<< "000098;0000B8;8;P1448;Fuel Tank Sensor Control Valve Range/Performance"
	<< "000099;0000B9;1;P0444;Canister Purge Control (CPC) Solenoid Valve Circuit Low"
	<< "000099;0000B9;2;P0445;Canister Purge Control (CPC) Solenoid Valve Circuit High"
	<< "000099;0000B9;3;P0691;Cooling Fan Relay 1 Circuit Low"
	<< "000099;0000B9;4;P0692;Cooling Fan Relay 1 Circuit High"
	<< "000099;0000B9;5;P0480;Cooling Fan Relay 1 Circuit Low"
	<< "000099;0000B9;6;P1480;Cooling Fan Relay 1 Circuit High"
	<< "000099;0000B9;7;P0483;Cooling Fan Rationality Check Malfunction"
	<< "000099;0000B9;8;P0864;Transmission Control Module (TCM) Communication Circuit Range/Performance"
	<< "00009A;0000BA;1;P0365;Camshaft Position Sensor B Circuit (Bank 1)"
	<< "00009A;0000BA;2;P0390;Camshaft Position Sensor B Circuit (Bank 2)"
	<< "00009A;0000BA;3;P0011;A Camshaft Position System Performance (Bank 1)"
	<< "00009A;0000BA;4;P0021;A Camshaft Position System Performance (Bank 2)"
	<< "00009A;0000BA;5;P1400;Fuel Tank Pressure Control Solenoid Valve Circuit Low"
	<< "00009A;0000BA;6;P1420;Fuel Tank Pressure Control Solenoid Valve Circuit High"
	<< "00009A;0000BA;7;P0458;Canister Purge Control (CPC) Solenoid Valve Circuit Low"
	<< "00009A;0000BA;8;P0459;Canister Purge Control (CPC) Solenoid Valve Circuit High"
	<< "00009B;0000BB;1;P0865;Transmission Control Module (TCM) Communication Circuit Low"
	<< "00009B;0000BB;2;P0866;Transmission Control Module (TCM) Communication Circuit High"
	<< "00009B;0000BB;3;P1443;Ventilation Control Solenoid Valve Function Problem"
	<< "00009B;0000BB;4;P1559;Air Intake System"
	<< "00009B;0000BB;5;P0661;Intake Manifold Tuning Valve Circuit Low"
	<< "00009B;0000BB;6;P0662;Intake Manifold Tuning Valve Circuit High"
	<< "00009B;0000BB;7;P0447;Evaporative Emission Control System Ventilation Control Circuit Open"
	<< "00009B;0000BB;8;P0448;Evaporative Emission Control System Ventilation Control Circuit Short"
	<< "00009C;0000BC;1;P0720;AT Vehicle Speed Sensor Circuit Malfunction"
	<< "00009C;0000BC;2;P0725;Engine Speed Input Circuit Malfunction"
	<< "00009C;0000BC;3;P1700;Throttle Position Sensor Circuit Malfunction for AT"
	<< "00009C;0000BC;4;P0710;Automatic Transmission Fluid (ATF) Temperature Sensor Circuit Malfunction"
	<< "00009C;0000BC;5;P0705;AT Range Switch Circuit Malfunction"
	<< "00009C;0000BC;6;P1701;Cruise Control Set Signal Circuit Malfunction for AT"
	<< "00009C;0000BC;7;P0703;Brake Switch Circuit Malfunction for AT"
	<< "00009C;0000BC;8;P0741;Torque Converter Clutch Circuit Malfunction"
	<< "00009D;0000BD;1;P0753;Shift Solenoid A Electrical"
	<< "00009D;0000BD;2;P0758;Shift Solenoid B Electrical"
	<< "00009D;0000BD;3;P1706;AT Vehicle Speed Sensor Circuit Malfunction (Rear Wheel)"
	<< "00009D;0000BD;4;P0748;Pressure Control Solenoid Electrical (Duty Solenoid A)"
	<< "00009D;0000BD;5;P0743;Torque Converter Clutch Circuit Electrical (Duty Solenoid B)"
	<< "00009D;0000BD;6;P0731;Gear 1 Incorrect Ratio"
	<< "00009D;0000BD;7;P0732;Gear 2 Incorrect Ratio"
	<< "00009D;0000BD;8;P0733;Gear 3 Incorrect Ratio"
	<< "00009E;0000BE;1;P0734;Gear 4 Incorrect Ratio"
	<< "00009E;0000BE;2;P1707;AT AWD Solenoid Valve Circuit Malfunction"
	<< "00009E;0000BE;3;P1595;AT Diagnosis Input Signal Circuit Low Input"
	<< "00009E;0000BE;4;P1596;AT Diagnosis Input Signal Circuit High Input"
	<< "00009E;0000BE;5;P0135;O2 Sensor Heater Circuit (Bank 1 Sensor 1)"
	<< "00009E;0000BE;6;P0141;O2 Sensor Heater Circuit (Bank 1 Sensor 2)"
	<< "00009E;0000BE;7;P1593;Transmission Control Module (TCM) Communication Circuit Malfunction"
	<< "00009E;0000BE;8;P1594;AT Diagnosis Input Signal Circuit Malfunction"
	<< "00009F;0000BF;1;P0133;O2 Sensor Circuit Slow Response (Bank 1 Sensor 1)"
	<< "00009F;0000BF;2;P0130;O2 Sensor Circuit (Bank 1 Sensor 1)"
	<< "00009F;0000BF;3;P0139;O2 Sensor Circuit Slow Response (Bank 1 Sensor 2)"
	<< "00009F;0000BF;4;P0136;O2 Sensor Circuit (Bank 1 Sensor 2)"
	<< "00009F;0000BF;5;P1152;O2 Sensor Circuit Range/Performance (Low) (Bank 1 Sensor 1)"
	<< "00009F;0000BF;6;P1153;O2 Sensor Circuit Range/Performance (High) (Bank 1 Sensor 1)"
	<< "00009F;0000BF;7;P0174;System Too Lean (Bank 2)"
	<< "00009F;0000BF;8;P0175;System Too Rich (Bank 2)"
	<< "0000A0;0000C0;1;P0420;Catalyst System Efficiency Below Threshold"
	<< "0000A0;0000C0;2;P0442;Evaporative Emission Control System Leak Detected (Small Leak)"
	<< "0000A0;0000C0;3;P0170;Fuel Trim (Bank 1)"
	<< "0000A0;0000C0;4;P0456;Evaporative Emission Control System Leak Detected (Very Small Leak)"
	<< "0000A0;0000C0;5;P0400;Exhaust Gas Recirculation (EGR) System Malfunction"
	<< "0000A0;0000C0;6;P1230;Fuel Pump Controller"
	<< "0000A0;0000C0;7;P0171;System Too Lean (Bank 1)"
	<< "0000A0;0000C0;8;P0172;System Too Rich (Bank 1)"
	<< "0000A1;0000C1;1;P0301;Cylinder 1 Misfire Detected"
	<< "0000A1;0000C1;2;P0302;Cylinder 2 Misfire Detected"
	<< "0000A1;0000C1;3;P0303;Cylinder 3 Misfire Detected"
	<< "0000A1;0000C1;4;P0304;Cylinder 4 Misfire Detected"
	<< "0000A1;0000C1;5;P0305;Cylinder 5 Misfire Detected"
	<< "0000A1;0000C1;6;P0306;Cylinder 6 Misfire Detected"
	<< "0000A1;0000C1;7;P1301;Misfire Detected (High Temperature Exhaust Gas)"
	<< "0000A1;0000C1;8;P0457;Evaporative Emission Control System Leak Detected (Fuel Cap Loose/Off)"
	<< "0000A2;0000C2;1;;"	// => IGNORE
	<< "0000A2;0000C2;2;;"	// => IGNORE
	<< "0000A2;0000C2;3;P1235;Intake Control Valve Solenoid Circuit Low"
	<< "0000A2;0000C2;4;P1236;Intake Control Valve Solenoid Circuit High"
	<< "0000A2;0000C2;5;P1597;Traction Control System (TCS) Signal Circuit Low Input"
	<< "0000A2;0000C2;6;P1598;Traction Control System (TCS) Signal Circuit High Input"
	<< "0000A2;0000C2;7;P0034;Turbo Charger Bypass Valve Control Circuit Low"
	<< "0000A2;0000C2;8;P0035;Turbo Charger Bypass Valve Control Circuit High"
	<< "0000A3;0000C3;1;P0137;O2 Sensor Circuit Low Voltage (Bank 1 Sensor 2)"
	<< "0000A3;0000C3;2;P1134;Air/Fuel Sensor Micro-Computer Problem"
	<< "0000A3;0000C3;3;P0131;O2 Sensor Circuit Low Voltage (Bank 1 Sensor 1)"
	<< "0000A3;0000C3;4;P0151;O2 Sensor Circuit Low Voltage (Bank 2 Sensor 1)"
	<< "0000A3;0000C3;5;P0132;O2 Sensor Circuit High Voltage (Bank 1 Sensor 1)"
	<< "0000A3;0000C3;6;P0152;O2 Sensor Circuit High Voltage (Bank 2 Sensor 1)"
	<< "0000A3;0000C3;7;P0138;O2 Sensor Circuit High Voltage (Bank 1 Sensor 2)"
	<< "0000A3;0000C3;8;P0153;O2 Sensor Circuit Slow Response (Bank 2 Sensor 1)"
	<< "0000A4;0000C4;1;P0112;Intake Air Temperature Sensor Circuit Malfunction (Low Input)"
	<< "0000A4;0000C4;2;P0113;Intake Air Temperature Sensor Circuit Malfunction (High Input)"
	<< "0000A4;0000C4;3;P0111;Intake Air Temperature Sensor Range/Performance Problem"
	<< "0000A4;0000C4;4;P1546;Exhaust Gas Temperature Sensor 2 Circuit Malfunction (High Input)"
	<< "0000A4;0000C4;5;P0038;HO2S Heater Control Circuit High (Bank 1 Sensor 2)"
	<< "0000A4;0000C4;6;P0032;HO2S Heater Control Circuit High (Bank 1 Sensor 1)"
	<< "0000A4;0000C4;7;P0037;HO2S Heater Control Circuit Low (Bank 1 Sensor 2)"
	<< "0000A4;0000C4;8;P0031;HO2S Heater Control Circuit Low (Bank 1 Sensor 1)"
	<< "0000A5;0000C5;1;P1110;Atmospheric Pressure Sensor Circuit Malfunction (Low Input)"
	<< "0000A5;0000C5;2;P1111;Atmospheric Pressure Sensor Circuit Malfunction (High Input)"
	<< "0000A5;0000C5;3;P1112;Atmospheric Pressure Sensor Circuit Range/Performance"
	<< "0000A5;0000C5;4;P0106;Manifold Pressure Sensor Circuit Range/Performance Problem (Low)"
	<< "0000A5;0000C5;5;P0107;Manifold Pressure Sensor Circuit Malfunction (Low Input)"
	<< "0000A5;0000C5;6;P0108;Manifold Pressure Sensor Circuit Malfunction (High Input)"
	<< "0000A5;0000C5;7;P1545;Exhaust Gas Temperature Sensor 2 Circuit Malfunction (Low Input)"
	<< "0000A5;0000C5;8;P1146;Manifold Pressure Sensor Circuit Range/Performance Problem (High)"
	<< "0000A6;0000C6;1;P1139;O2 Sensor Heater Circuit Range/Performance (Bank 1 Sensor 1)"
	<< "0000A6;0000C6;2;P1140;O2 Sensor Heater Circuit Range/Performance (Bank 2 Sensor 1)"
	<< "0000A6;0000C6;3;P1711;Engine Torque Control Signal #1 Circuit Malfunction"
	<< "0000A6;0000C6;4;P1712;Engine Torque Control Signal #2 Circuit Malfunction"
	<< "0000A6;0000C6;5;P0715;Torque Converter Turbine Speed Signal Circuit Malfunction"
	<< "0000A6;0000C6;6;P1703;AT Low Clutch Timing Solenoid Valve Circuit Malfunction"
	<< "0000A6;0000C6;7;P0785;AT 2-4 Brake Timing Solenoid Valve Circuit Malfunction"
	<< "0000A6;0000C6;8;P0778;AT 2-4 Brake Pressure Solenoid Valve Circuit Malfunction"
	<< "0000A7;0000C7;1;P1130;O2 Sensor Circuit (Open) (Bank 1 Sensor 1)"
	<< "0000A7;0000C7;2;P1135;O2 Sensor Circuit (Open) (Bank 2 Sensor 1)"
	<< "0000A7;0000C7;3;P1131;O2 Sensor Circuit (Short) (Bank 1 Sensor 1)"
	<< "0000A7;0000C7;4;P1136;O2 Sensor Circuit (Short) (Bank 2 Sensor 1)"
	<< "0000A7;0000C7;5;P1154;O2 Sensor Circuit Range/Performance (Low) (Bank 2 Sensor 1)"
	<< "0000A7;0000C7;6;P1155;O2 Sensor Circuit Range/Performance (High) (Bank 2 Sensor 1)"
	<< "0000A7;0000C7;7;P0052;HO2S Heater Control Circuit High (Bank 2 Sensor 1)"
	<< "0000A7;0000C7;8;P0051;HO2S Heater Control Circuit Low  (Bank 2 Sensor 1)"
	<< "0000A8;0000C8;1;P0128;Coolant Thermostat"
	<< "0000A8;0000C8;2;P1491;Positive Crankcase Ventilation (PCV) Function Problem (Blow-by)"
	<< "0000A8;0000C8;3;P0066;Air Assisted Injector (AAI) Control Circuit or Circuit Low"
	<< "0000A8;0000C8;4;P0067;Air Assisted Injector (AAI) Control Circuit High"
	<< "0000A8;0000C8;5;P0065;Air Assisted Injector (AAI) Control Range/Performance"
	<< "0000A8;0000C8;6;P0130;O2 Sensor Circuit (Lean) (Bank 1 Sensor 1)"
	<< "0000A8;0000C8;7;P1137;O2 Sensor Circuit (Lambda=1) (Bank 1 Sensor 1)"
	<< "0000A8;0000C8;8;P1137;O2 Sensor Circuit (Mid) (Bank 1 Sensor 1)"
	<< "0000A9;0000C9;1;P1248;Relief Valve Control Solenoid 1 Circuit High"
	<< "0000A9;0000C9;2;P1249;Relief Valve Control Solenoid 2 Circuit Low"
	<< "0000A9;0000C9;3;P1250;Relief Valve Control Solenoid 2 Circuit High"
	<< "0000A9;0000C9;4;P1560;Back-up Voltage Circuit Malfunction"
	<< "0000A9;0000C9;5;P0192;Fuel Rail Pressure Sensor Circuit Low"
	<< "0000A9;0000C9;6;P0193;Fuel Rail Pressure Sensor Circuit High"
	<< "0000A9;0000C9;7;P0562;System Voltage Low"
	<< "0000A9;0000C9;8;P0563;System Voltage High"
	<< "0000AA;0000CA;1;P0245;Turbocharger Wastegate Solenoid A Low"
	<< "0000AA;0000CA;2;P0246;Turbocharger Wastegate Solenoid A High"
	<< "0000AA;0000CA;3;P1244;Turbocharger Wastegate Solenoid A Range/Performance (Low Input)"
	<< "0000AA;0000CA;4;P0244;Turbocharger Wastegate Solenoid A Range/Performance (High Input)"
	<< "0000AA;0000CA;5;P1245;Turbocharger Wastegate Solenoid A Range/Performance (Fail-safe)"
	<< "0000AA;0000CA;6;P0249;Turbocharger Wastegate Solenoid B Low"
	<< "0000AA;0000CA;7;P0250;Turbocharger Wastegate Solenoid B High"
	<< "0000AA;0000CA;8;P1247;Relief Valve Control Solenoid 1 Circuit Low"
	<< "0000AB;0000CB;1;P1577;Immobilizer Control Module EEPROM Error"
	<< "0000AB;0000CB;2;P1576;Electronic Gasoline Injection (EGI) Control Module EEPROM Error"
	<< "0000AB;0000CB;3;P0513;Incorrect Immobilizer Key"
	<< "0000AB;0000CB;4;P1574;Key Communication Failure"
	<< "0000AB;0000CB;5;P1578;Meter Failure"
	<< "0000AB;0000CB;6;P1572;Immobilzer Circuit Failure (Except Antenna Circuit)"
	<< "0000AB;0000CB;7;P1571;Reference Code Incompatibility"
	<< "0000AB;0000CB;8;P1570;Antenna"
	<< "0000AC;0000CC;1;P1095;Tumble Generator Valve (TGV) 1 Signal Circuit Malfunction (Short)"
	<< "0000AC;0000CC;2;P1097;Tumble Generator Valve (TGV) 2 Signal Circuit Malfunction (Short)"
	<< "0000AC;0000CC;3;P1094;Tumble Generator Valve (TGV) 1 Signal Circuit Malfunction (Open)"
	<< "0000AC;0000CC;4;P1096;Tumble Generator Valve (TGV) 2 Signal Circuit Malfunction (Open)"
	<< "0000AC;0000CC;5;P0261;Fuel Injector Cylinder #1 Circuit Low"
	<< "0000AC;0000CC;6;P0264;Fuel Injector Cylinder #2 Circuit Low"
	<< "0000AC;0000CC;7;P0267;Fuel Injector Cylinder #3 Circuit Low"
	<< "0000AC;0000CC;8;P0270;Fuel Injector Cylinder #4 Circuit Low"
	<< "0000AD;0000CD;1;P0545;Exhaust Gas Temperature Sensor Circuit Malfunction (Low Input)"
	<< "0000AD;0000CD;2;P0546;Exhaust Gas Temperature Sensor Circuit Malfunction (High Input)"
	<< "0000AD;0000CD;3;P1312;Exhaust Gas Temperature Sensor Malfunction"
	<< "0000AD;0000CD;4;P1544;Exhaust Gas Temperature Too High"
	<< "0000AD;0000CD;5;P1306;Oil Flow Control Solenoid Valve (OCV) 1 Signal Circuit Malfunction (Open)"
	<< "0000AD;0000CD;6;P1308;Oil Flow Control Solenoid Valve (OCV) 2 Signal Circuit Malfunction (Open)"
	<< "0000AD;0000CD;7;P1307;Oil Flow Control Solenoid Valve (OCV) 1 Signal Circuit Malfunction (Short)"
	<< "0000AD;0000CD;8;P1309;Oil Flow Control Solenoid Valve (OCV) 2 Signal Circuit Malfunction (Short)"
	<< "0000F0;0000F4;1;P1719;ECU Communication Circuit"
	<< "0000F0;0000F4;2;P1242;2-Stage Twin Turbo System (Twin)"
	<< "0000F0;0000F4;3;P1241;2-Stage Twin Turbo System (Single)"
	<< "0000F0;0000F4;4;P1199;Differential Pressure Sensor"
	<< "0000F0;0000F4;5;P1086;Tumble Generator Valve (TGV) Position Sensor 2 Circuit Low"
	<< "0000F0;0000F4;6;P1087;Tumble Generator Valve (TGV) Position Sensor 2 Circuit High"
	<< "0000F0;0000F4;7;P1088;Tumble Generator Valve (TGV) Position Sensor 1 Circuit Low"
	<< "0000F0;0000F4;8;P1089;Tumble Generator Valve (TGV) Position Sensor 1 Circuit High"
	<< "0000F1;0000F5;1;P0801;Reverse Inhibit Control Circuit"
	<< "0000F1;0000F5;2;P0768;Shift Solenoid D Electrical"
	<< "0000F1;0000F5;3;P0763;Shift Solenoid C Electrical"
	<< "0000F1;0000F5;4;P0736;Reverse Incorrect Ratio"
	<< "0000F1;0000F5;5;P0724;Brake Switch Circuit High"
	<< "0000F1;0000F5;6;P0719;Brake Switch Circuit Low"
	<< "0000F1;0000F5;7;P0713;ATF Temperature Sensor Circuit High"
	<< "0000F1;0000F5;8;P0712;ATF Temperature Sensor Circuit Low"
	<< "0000F2;0000F6;1;P1817;Sports Mode Switch Circuit (Manual Switch)"
	<< "0000F2;0000F6;2;P1762;Lateral Acceleration Sensor Circuit High"
	<< "0000F2;0000F6;3;P1761;Lateral Acceleration Sensor Circuit Low"
	<< "0000F2;0000F6;4;P1760;Lateral Acceleration Sensor Performance Problem"
	<< "0000F2;0000F6;5;P1718;AT CAN Communication Circuit"
	<< "0000F2;0000F6;6;P1714;Throttle Position Sensor Power Supply Circuit"
	<< "0000F2;0000F6;7;P1709;Throttle Position Sensor Circuit High Input"
	<< "0000F2;0000F6;8;P1708;Throttle Position Sensor Circuit Low Input"
	<< "0000F3;0000F7;1;P1600;Improper CAN Communication"
	<< "0000F3;0000F7;2;P2709;Shift Solenoid F Electrical"
	<< "0000F3;0000F7;3;P0773;Shift Solenoid E Electrical"
	<< "0000F3;0000F7;4;P0735;Gear 5 Incorrect Ratio"
	<< "0000F3;0000F7;5;P1799;Interlock"
	<< "0000F3;0000F7;6;P1798;Gear 1 Engine Breaks"
	<< "0000F3;0000F7;7;P1314;Misfire Detected Signal Circuit Low Input"
	<< "0000F3;0000F7;8;P1313;Misfire Detected Signal Circuit High Input"
	<< "000123;00012B;1;P1710;Torque Converter Turbine 2 Speed Signal Circuit Malfunction"
	<< "000123;00012B;2;P1717;Automatic Transmission Fluid (ATF) Temperature Sensor 2 Circuit High"
	<< "000123;00012B;3;P1716;Automatic Transmission Fluid (ATF) Temperature Sensor 2 Circuit Low"
	<< "000123;00012B;4;P0771;AT Low Clutch Timing Solenoid Valve Circuit Malfunction"
	<< "000123;00012B;5;P0716;Torque Converter Turbine Speed Signal Circuit Malfunction"
	<< "000123;00012B;6;P0726;Engine Speed Input Circuit Malfunction"
	<< "000123;00012B;7;P0720;AT Vehicle Speed Sensor Circuit High"
	<< "000123;00012B;8;P0722;AT Vehicle Speed Sensor Circuit Low"
	<< "000124;00012C;1;P2707;Shift Solenoid F Malfunction"
	<< "000124;00012C;2;P0771;Shift Solenoid E Malfunction"
	<< "000124;00012C;3;P0766;Shift Solenoid D Malfunction"
	<< "000124;00012C;4;P0761;Shift Solenoid C Malfunction"
	<< "000124;00012C;5;P0756;Shift Solenoid B Malfunction"
	<< "000124;00012C;6;P0751;Shift Solenoid A Malfunction"
	<< "000124;00012C;7;P1769;Yaw Rate and Lateral G Sensor Error"
	<< "000124;00012C;8;P1282;Positive Crankcase Ventilation (PCV) System Circuit (Open)"
	<< "000125;00012D;1;P1844;Transmission Fluid Pressure Sensor Switch E Circuit"
	<< "000125;00012D;2;P1843;Transmission Fluid Pressure Sensor Switch D Circuit"
	<< "000125;00012D;3;P1842;Transmission Fluid Pressure Sensor Switch C Circuit"
	<< "000125;00012D;4;P1841;Transmission Fluid Pressure Sensor Switch B Circuit"
	<< "000125;00012D;5;P1840;Transmission Fluid Pressure Sensor Switch A Circuit"
	<< "000125;00012D;6;P1875;Circuit of Center Differential"
	<< "000125;00012D;7;P0558;Alternator Circuit Low"
	<< "000125;00012D;8;P0559;Alternator Circuit High"
	<< "000126;00012E;1;P0502;Vehicle Speed Sensor Low Input"
	<< "000126;00012E;2;P0230;Fuel Pump Controller"
	<< "000126;00012E;3;P0565;Cruise Control System Set Signal"
	<< "000126;00012E;4;P0068;Manifold Pressure Sensor Range/Performance"
	<< "000126;00012E;5;P0129;Atmospheric Pressure Sensor Range/Performance"
	<< "000126;00012E;6;P0519;Idle Control System Malfunction (Fail-safe)"
	<< "000126;00012E;7;P0345;Camshaft Position Sensor A Circuit (Bank 2)"
	<< "000126;00012E;8;P0101;Mass or Volume Air Flow Circuit Range/Performance"
	<< "000127;00012F;1;P0154;O2 Sensor Circuit Open (Bank 2 Sensor 1)"
	<< "000127;00012F;2;P0134;O2 Sensor Circuit Open (Bank 1 Sensor 1)"
	<< "000127;00012F;3;P0150;O2 Sensor Circuit (Bank 2 Sensor 1)"
	<< "000127;00012F;4;P0130;O2 Sensor Circuit (Bank 1 Sensor 1)"
	<< "000127;00012F;5;P0050;O2 Sensor Heater Circuit Range/Performance (Bank 2 Sensor 1)"
	<< "000127;00012F;6;P0030;O2 Sensor Heater Circuit Range/Performance (Bank 1 Sensor 1)"
	<< "000127;00012F;7;P0501;Vehicle Speed Sensor Malfunction at Low Speed"
	<< "000127;00012F;8;P0503;Vehicle Speed Sensor High Speed"
	<< "000128;000130;1;P0142;O2 Sensor Circuit (Bank 1 Sensor 3)"
	<< "000128;000130;2;P0145;O2 Sensor Circuit Slow Response (Bank 1 Sensor 3)"
	<< "000128;000130;3;P0156;O2 Sensor Circuit (Bank 2 Sensor 2)"
	<< "000128;000130;4;P0159;O2 Sensor Circuit Slow Response (Bank 2 Sensor 2)"
	<< "000128;000130;5;P0162;O2 Sensor Circuit (Bank 2 Sensor 3)"
	<< "000128;000130;6;P0165;O2 Sensor Circuit Slow Response (Bank 2 Sensor 3)"
	<< "000128;000130;7;P0043;HO2S Heater Control Circuit Low (Bank 1 Sensor 3)"
	<< "000128;000130;8;P0044;H02S Heater Control Circuit High (Bank 1 Sensor 3)"
	<< "000129;000131;1;P0057;HO2S Heater Control Circuit Low (Bank 2 Sensor 2)"
	<< "000129;000131;2;P0058;HO2S Heater Control Circuit High (Bank 2 Sensor 2)"
	<< "000129;000131;3;P0063;HO2S Heater Control Circuit Low (Bank 2 Sensor 3)"
	<< "000129;000131;4;P0064;HO2S Heater Control Circuit High (Bank 2 Sensor 3)"
	<< "000129;000131;5;P0157;O2 Sensor Circuit Low Voltage (Bank 2 Sensor 2)"
	<< "000129;000131;6;P0158;O2 Sensor Circuit High Voltage (Bank 2 Sensor 2)"
	<< "000129;000131;7;P0143;O2 Sensor Circuit Low Voltage (Bank 1 Sensor 3)"
	<< "000129;000131;8;P0144;O2 Sensor Circuit High Voltage (Bank 1 Sensor 3)"
	<< "00012A;000132;1;P2109;Throttle Angle Sensor Closed Position Error"
	<< "00012A;000132;2;P1759;Lateral G Sensor System Circuit"
	<< "00012A;000132;3;P1873;Rear Right ABS Sensor Signal"
	<< "00012A;000132;4;P1872;Rear Left ABS Sensor Signal"
	<< "00012A;000132;5;P1871;Front Right ABS Sensor Signal"
	<< "00012A;000132;6;P1870;Front Left ABS Sensor Signal"
	<< "00012A;000132;7;P2125;Accelerator Position Sensor E"
	<< "00012A;000132;8;P1700;Throttle Position Sensor Circuit Malfunction"
	<< "000150;000155;1;P0222;Throttle Position Sensor B Low Input"
	<< "000150;000155;2;P0223;Throttle Position Sensor B High Input"
	<< "000150;000155;3;P1160;Return Spring Failure"
	<< "000150;000155;4;P2102;Throttle Control Motor Circuit Low Input"
	<< "000150;000155;5;P2103;Throttle Control Motor Circuit High Input"
	<< "000150;000155;6;P2101;Throttle Control Motor Circuit Range/Performance"
	<< "000150;000155;7;P2096;Post Catalyst Fuel Trim System Too Lean (Bank 1)"
	<< "000150;000155;8;P0638;Throttle Control Circuit Range/Performance Problem"
	<< "000151;000156;1;P0607;Throttle Control System Circuit Range/Performance"
	<< "000151;000156;2;P2138;Accelerator Position Sensor Circuit Range/Performance"
	<< "000151;000156;3;P2127;Accelerator Position Sensor E Low Input"
	<< "000151;000156;4;P2128;Accelerator Position Sensor E High Input"
	<< "000151;000156;5;P2122;Accelerator Position Sensor D Low Input"
	<< "000151;000156;6;P2123;Accelerator Position Sensor D High Input"
	<< "000151;000156;7;P2135;Throttle Position Sensor Circuit Range/Performance"
	<< "000151;000156;8;P2097;Post Catalyst Fuel Trim System Too Rich (Bank 1)"
	<< "000152;000157;1;P0600;Improper CAN Communication"
	<< "000152;000157;2;P0390;Camshaft Position Sensor B Circuit (Bank 2)"
	<< "000152;000157;3;P0365;Camshaft Position Sensor B Circuit (Bank 1)"
	<< "000152;000157;4;P0345;Camshaft Position Sensor A Circuit (Bank 2)"
	<< "000152;000157;5;P0340;Camshaft Position Sensor A Circuit (Bank 1)"
	<< "000152;000157;6;P0605;Internal Control Module Read Only Memory Error"
	<< "000152;000157;7;P1521;Brake Switch Circuit Range Performance Problem (High Input)"
	<< "000152;000157;8;P0579;Cruise Control Switch Circuit Range Performance Problem (High Input)"
	<< "000153;000158;1;P2095;OCV Solenoid Valve Signal B Circuit Short (Bank 2)"
	<< "000153;000158;2;P2094;OCV Solenoid Valve Signal B Circuit Open (Bank 2)"
	<< "000153;000158;3;P2091;OCV Solenoid Valve Signal B Circuit Short (Bank 1)"
	<< "000153;000158;4;P2090;OCV Solenoid Valve Signal B Circuit Open (Bank 1)"
	<< "000153;000158;5;P2093;OCV Solenoid Valve Signal A Circuit Short (Bank 2)"
	<< "000153;000158;6;P2092;OCV Solenoid Valve Signal A Circuit Open (Bank 2)"
	<< "000153;000158;7;P2089;OCV Solenoid Valve Signal A Circuit Short (Bank 1)"
	<< "000153;000158;8;P2088;OCV Solenoid Valve Signal A Circuit Open (Bank 1)"
	<< "000154;000159;1;P0197;Oil Temperature Sensor Circuit Malfunction (Low)"
	<< "000154;000159;2;P1547;Exhaust Gas Temperature Sensor Malfunction"
	<< "000154;000159;3;P1476;Exhaust By-pass Valve Solenoid Malfunction (High)"
	<< "000154;000159;4;P1475;Exhaust By-pass Valve Solenoid Malfunction (Low)"
	<< "000154;000159;5;P1477;Exhaust By-pass Valve Function"
	<< "000154;000159;6;P2099;Post Catalyst Fuel Trim System Too Rich (Bank 2)"
	<< "000154;000159;7;P2098;Post Catalyst Fuel Trim System Too Lean (Bank 2)"
	<< "000154;000159;8;P0700;Request AT Malfunction Indicator Light (MIL) On"
	<< "000160;000165;1;P0028;OSV Solenoid Valve (Left) Malfunction"
	<< "000160;000165;2;P0083;OSV Solenoid Valve (Left) Circuit Malfunction (High)"
	<< "000160;000165;3;P0082;OSV Solenoid Valve (Left) Circuit Malfunction (Low)"
	<< "000160;000165;4;P0026;OSV Solenoid Valve (Right) Malfunction"
	<< "000160;000165;5;P0077;OSV Solenoid Valve (Right) Circuit Malfunction (High)"
	<< "000160;000165;6;P0076;OSV Solenoid Valve (Right) Circuit Malfunction (Low)"
	<< "000160;000165;7;P0196;Oil Temperature Sensor Circuit Range/Performance Problem"
	<< "000160;000165;8;P0198;Oil Temperature Sensor Circuit Malfunction (High)"
	<< "000161;000166;1;P2100;Throttle Control Motor Circuit Open"
	<< "000161;000166;2;P2111;Throttle Valve Open Stick"
	<< "000161;000166;3;P2504;Alternator Circuit High"
	<< "000161;000166;4;P2503;Alternator Circuit Low"
	<< "000161;000166;5;P1462;Intercylinder Fuel Pressure Sensor System Circuit (Low)"
	<< "000161;000166;6;P1463;Intercylinder Fuel Pressure Sensor System Circuit (High)"
	<< "000161;000166;7;P1028;Variable Valve Lift (VVL) Systems 2 Performance"
	<< "000161;000166;8;P1026;Variable Valve Lift (VVL) Systems 1 Performance"
	<< "000162;000167;1;P0958;Backup Lamp Relay Output (High)"
	<< "000162;000167;2;P0957;Backup Lamp Relay Output (Low)"
	<< "000162;000167;3;P0955;Backup Lamp Relay Output (Open)"
	<< "000162;000167;4;P0883;PIVGN Power Supply (High)"
	<< "000162;000167;5;P0882;PIVGN Power Supply (Low)"
	<< "000162;000167;6;P0880;PIVGN Power Supply Circuit"
	<< "000162;000167;7;P0817;PN Signal Output Circuit"
	<< "000162;000167;8;P1601;Transmission Control Unit (TCU) Communication Malfunction"
	<< "000163;000168;1;P2004;Tumble Generator Valve (TGV) System 1 (Valve Open)"
	<< "000163;000168;2;P2006;Tumble Generator Valve (TGV) System 1 (Valve Close)"
	<< "000163;000168;3;P2005;Tumble Generator Valve (TGV) System 2 (Valve Open)"
	<< "000163;000168;4;P2007;Tumble Generator Valve (TGV) System 2 (Valve Close)"
	<< "000163;000168;5;P2227;Atmospheric Pressure Sensor Range/Performance"
	<< "000163;000168;6;P0126;Water Temperature"
	<< "000163;000168;7;P2229;Atmospheric Pressure Sensor Circuit Malfunction (High Input)"
	<< "000163;000168;8;P2228;Atmospheric Pressure Sensor Circuit Malfunction (Low Input)"
	<< "000164;000169;1;P2016;Tumble Generator Valve (TGV) Position Sensor 1 Circuit Low"
	<< "000164;000169;2;P2017;Tumble Generator Valve (TGV) Position Sensor 1 Circuit High"
	<< "000164;000169;3;P2021;Tumble Generator Valve (TGV) Position Sensor 2 Circuit Low"
	<< "000164;000169;4;P2022;Tumble Generator Valve (TGV) Position Sensor 2 Circuit High"
	<< "000164;000169;5;P2009;Tumble Generator Valve (TGV) Signal 1 Circuit Malfunction (Short)"
	<< "000164;000169;6;P2012;Tumble Generator Valve (TGV) Signal 2 Circuit Malfunction (Short)"
	<< "000164;000169;7;P2008;Tumble Generator Valve (TGV) Signal 1 Circuit Malfunction (Open)"
	<< "000164;000169;8;P2011;Tumble Generator Valve (TGV) Signal 2 Circuit Malfunction (Open)"
	<< "000174;00017B;1;P1579;Remote Control Starter Abnormal"
	<< "000175;00017C;1;P0850;Neutral Position Switch Circuit"
	<< "000175;00017C;2;P1721;DCCD Engine RPM Signal System Circuit"
	<< "000175;00017C;3;P1720;DCCD CAN System Circuit"
	<< "000175;00017C;4;P1765;Yaw Rate & Side G Sensor Reference System Circuit"
	<< "000175;00017C;5;P1764;Yaw Rate Sensor System Circuit"
	<< "000175;00017C;6;P1767;DCCD Steering Angle Sensor Circuit"
	<< "000175;00017C;7;P1723;Automatic Transmission Fluid (ATF) Temperature Sensor 2 Circuit Range/Performance"
	<< "000175;00017C;8;P0711;Automatic Transmission Fluid (ATF) Temperature Sensor Circuit Range/Performance"
	<< "000176;00017D;1;P2444;Secondary Air Pump ON Malfunction"
	<< "000176;00017D;2;P0411;Secondary Air Flow Abnormal"
	<< "000176;00017D;3;P0410;Secondary Air System Function"
	<< "000176;00017D;4;P2431;Secondary Air Pressure Sensor Property"
	<< "000176;00017D;5;P2433;Secondary Air Pressure Sensor (High)"
	<< "000176;00017D;6;P2432;Secondary Air Pressure Sensor (Low)"
	<< "000176;00017D;7;P0413;Secondary Air Combi Valve Relay Circuit 1 (Low)"
	<< "000176;00017D;8;P0418;Secondary Air Pump Relay (Low)"
	<< "000177;00017E;1;P0140;O2 Sensor Circuit Range/Performance (Bank 1 Sensor 2)"
	<< "000177;00017E;2;P0160;O2 Sensor Circuit Range/Performance (Bank 2 Sensor 2)"
	<< "000177;00017E;3;P0146;O2 Sensor Circuit Range/Performance (Bank 1 Sensor 3)"
	<< "000177;00017E;4;P1602;Control Module Programming Error"
	<< "000177;00017E;5;P0414;Secondary Air Combi Valve Relay Circuit 1 (High)"
	<< "000177;00017E;6;P1418;Secondary Air Pump Relay (High)"
	<< "000177;00017E;7;P0018;Crank and Cam Timing A Failure (Bank 2)"
	<< "000177;00017E;8;P0016;Crank and Cam Timing A Failure (Bank 1)"
	<< "000178;00017F;1;P0602;Control Module Programming Error"
	<< "000178;00017F;2;P1410;Secondary Air Combi Valve Open Seized"
	<< "000178;00017F;3;P2443;Secondary Air System Close Seized (Bank 2)"
	<< "000178;00017F;4;P2442;Secondary Air System Open Seized (Bank 2)"
	<< "000178;00017F;5;P2441;Secondary Air System Close Seized (Bank 1)"
	<< "000178;00017F;6;P2440;Secondary Air System Open Seized (Bank 1)"
	<< "000178;00017F;7;P0417;Secondary Air Combi Valve Relay Circuit 2 (High)"
	<< "000178;00017F;8;P0416;Secondary Air Combi Valve Relay Circuit 2 (Low)"
	<< "000179;000180;1;P0024;Exhaust Active Valve Control System (AVCS) System 2 (Range/Performance)"
	<< "000179;000180;2;P0014;Exhaust Active Valve Control System (AVCS) System 1 (Range/Performance)"
	<< "000179;000180;3;P1616;Starter Cut Relay System Circuit (Low)"
	<< "000179;000180;4;P1520;Starter Switch 2 System Circuit (ON)"
	<< "000179;000180;5;P1519;Starter Switch 2 System Circuit (OFF)"
	<< "000179;000180;6;P0441;Evaporative Emission Control System Incorrect Purge Flow"
	<< "000179;000180;7;P2419;Canister Purge Control (CPC) Solenoid Valve Circuit Low"
	<< "000179;000180;8;P2420;Canister Purge Control (CPC) Solenoid Valve Circuit High"
	<< "00017A;000181;1;P2634;Sub Fuel Pump Relay (High)"
	<< "00017A;000181;2;P2633;Sub Fuel Pump Relay (Low)"
	<< "00017A;000181;5;P0091;Fuel Pressure Switching Solenoid (Circuit Low)"
	<< "00017A;000181;6;P0092;Fuel Pressure Switching Solenoid (Circuit High)"
	<< "00017A;000181;7;P0019;Crank and Cam Timing B System Failure (Bank 2)"
	<< "00017A;000181;8;P0017;Crank and Cam Timing B System Failure (Bank 1)"
	<< "0001C5;0001CB;1;P0201;Injector #1 Circuit Malfunction"
	<< "0001C5;0001CB;2;P1213;Injector Driver (Low Charge)"
	<< "0001C5;0001CB;3;P2148;Injector Driver (Short-Circuit to Positive)"
	<< "0001C5;0001CB;4;P0704;Clutch Switch Circuit Malfunction"
	<< "0001C5;0001CB;5;P0096;Intake Air Temperature Sensor #2 Range/Performance Problem"
	<< "0001C5;0001CB;6;P0097;Intake Air Temperature Sensor #2 Circuit (Low)"
	<< "0001C5;0001CB;7;P0098;Intake Air Temperature Sensor #2 Circuit (High)"
	<< "0001C5;0001CB;8;P0116;Engine Coolant Temperature Sensor Circuit Range/Performance"
	<< "0001C6;0001CC;1;P0088;Fuel Rail Pressure Abnormal (Too High)"
	<< "0001C6;0001CC;2;P0191;Fuel Rail Pressure Sensor Circuit Range/Performance"
	<< "0001C6;0001CC;3;P1214;Injector Driver (Over Charge)"
	<< "0001C6;0001CC;4;P2149;Fuel Injector Power Supply B - Open Circuit"
	<< "0001C6;0001CC;5;P2146;Fuel Injector Power Supply A - Open Circuit"
	<< "0001C6;0001CC;6;P0204;Injector #4 Circuit Malfunction"
	<< "0001C6;0001CC;7;P0203;Injector #3 Circuit Malfunction"
	<< "0001C6;0001CC;8;P0202;Injector #2 Circuit Malfunction"
	<< "00020A;00020E;1;P0093;Fuel System Leak Detected (Large Leak)"
	<< "00020A;00020E;2;P1234;Fuel Pressure Abnormal (Fuel Pump Failure 2)"
	<< "00020A;00020E;3;P1233;Fuel Pressure Abnormal (Fuel Pump Failure 1)"
	<< "00020A;00020E;4;P1232;Fuel Pump Malfunction"
	<< "00020A;00020E;5;P2635;Fuel Pump Suction Control Valve Sticks"
	<< "00020A;00020E;6;P0628;Fuel Pump Suction Control Valve Circuit (Short-Circuit to Ground)"
	<< "00020A;00020E;7;P0629;Fuel Pump Suction Control Valve Circuit (Short-Circuit to Positive)"
	<< "00020A;00020E;8;P0089;Fuel Pressure Regulator Performance (Limiter Valve Opening Problem)"
	<< "00020B;00020F;1;P0401;Exhaust Gas Recirculation (EGR) Flow Insufficient Detected"
	<< "00020B;00020F;2;P0402;Exhaust Gas Recirculation (EGR) Flow Excessive Detected"
	<< "00020B;00020F;3;P0299;Boost Pressure Abnormal (Under-Boost)"
	<< "00020B;00020F;4;P0234;Boost Pressure Abnormal (Over-Boost)"
	<< "00020B;00020F;5;P0606;Control Unit Processor (CPU) Failure"
	<< "00020B;00020F;6;P1203;Injector Code Input Failure"
	<< "00020B;00020F;7;P1202;Injector Code Data Abnormal"
	<< "00020B;00020F;8;P1201;Injector Code Failure (Not Written)"
	<< "00020C;000210;1;P1382;Glow Relay Circuit (High)"
	<< "00020C;000210;2;P0219;Engine Overspeed Condition"
	<< "00020C;000210;3;P0046;Turbocharger Boost Control Solenoid Valve Circuit Range/Performance"
	<< "00020C;000210;4;P0404;Exhaust Gas Recirculation (EGR) Operation Circuit Abnormal"
	<< "00020C;000210;5;P0403;Exhaust Gas Recirculation (EGR) System Failure (Circuit Duty)"
	<< "00020C;000210;6;P0409;Exhaust Gas Recirculation (EGR) Position Sensor Performance"
	<< "00020C;000210;7;P0405;Exhaust Gas Recirculation (EGR) Position Sensor Circuit (Low)"
	<< "00020C;000210;8;P0406;Exhaust Gas Recirculation (EGR) Position Sensor Circuit (High)"
	<< "00020D;000211;2;P2413;Exhaust Gas Recirculation (EGR) Valve Sticking"
	<< "00020D;000211;3;P1009;Swirl Control Valve Circuit (Low)"
	<< "00020D;000211;4;P1607;Monitoring Circuit Abnormal"
	<< "00020D;000211;5;P2147;Injector Driver (Short-Circuit to Ground)"
	<< "00020D;000211;6;P2010;Swirl Control Valve Circuit (High)"
	<< "00020D;000211;7;P0687;Engine/Powertrain Control Module (ECM/PCM) Self-Shut Relay Failure"
	<< "00020D;000211;8;P1380;Glow Relay Circuit (Low)"
	<< "000263;000268;4;P1532;Charge Control System Abnormal"
	<< "000263;000268;5;P1531;Battery Current Sensor Circuit (High)"
	<< "000263;000268;6;P1530;Battery Current Sensor Circuit (Low)"
	<< "000263;000268;7;P0517;Battery Temperature Sensor Circuit (High)"
	<< "000263;000268;8;P0516;Battery Temperature Sensor Circuit (Low)"
	<< "000264;000269;8;P0161;Oxygen O2 Sensor Heater Circuit (Bank 2 Sensor 2)"
	<< "000265;00026A;1;P1468;Oil Dilution"
	<< "000265;00026A;2;P1467;Diesel Particulate Filter (DPF) Ash Overfill"
	<< "000265;00026A;3;P1466;Diesel Particulate Filter (DPF) Substrate Damaged"
	<< "000265;00026A;4;P1465;Diesel Particulate Filter (DPF) Particulate Overfill"
	<< "000265;00026A;5;P1473;Diesel Particulate Filter (DPF) Inlet/Outlet Pressure Deviation Sensor (High)"
	<< "000265;00026A;6;P1472;Diesel Particulate Filter (DPF) Inlet/Outlet Pressure Deviation Sensor (Low)"
	<< "000265;00026A;7;P2033;Exhaust Temperature Sensor 2 (high)"
	<< "000265;00026A;8;P2032;Exhaust Temperature Sensor 2 (low)"
	<< "000266;00026B;7;P1471;Diesel Particulate Filter (DPF) Differential Pressure Sensor Upstream Piping Trouble"
	<< "000266;00026B;8;P1469;Diesel Particulate Filter (DPF) Limp-Home Mode";


// Cancel codes of the integrated Cruise Control:
const QStringList SSMFlagbyteDefinitions_en::_CC_defs_en =
	QStringList()
	<< "000133;000137;1;22;Abnormality of Change in Vehicle Speed"
	<< "000133;000137;2;21;Abnormality of Switches when Ignition Switch ON"
	<< "000133;000137;3;16;Ignition Switch"
	<< "000133;000137;4;15;Cancel Switch"
	<< "000133;000137;5;14;Neutral Switch"
	<< "000133;000137;6;13;Clutch Switch"
	<< "000133;000137;7;12;Stop & Brake Switch"
	<< "000133;000137;8;11;Main Switch"
	<< "000134;000138;1;35;Prohibition of Cruise Control at Vehicle Speed F/B Malfunction"
	<< "000134;000138;2;34;Prohibition of Cruise Control at continuing big Accelerator Angle"
	<< "000134;000138;3;33;Prohibition of WAIT state after Accelerator Operation"
	<< "000134;000138;4;32;Cruise Control out of Range"
	<< "000134;000138;5;31;Abnormal Engine Speed Signal"
	<< "000134;000138;6;25;Abnormality of Input Circuit for Brake Switch"
	<< "000134;000138;7;24;Abnormality of Switches related to Cruise Control"
	<< "000134;000138;8;23;Abnormality of Sensors releated to Engine"
	<< "000135;000139;1;52;Active Driving Assist (ADA) Target Vehicle Speed Failure"
	<< "000135;000139;2;51;Active Driving Assist (ADA) Forced Cancel"
	<< "000135;000139;3;46;Powertrain Control Unit (PCU) Failure"
	<< "000135;000139;4;45;Meter Failure"
	<< "000135;000139;5;44;Body Integrated Unit Failure"
	<< "000135;000139;6;43;ABS/VDC Failure"
	<< "000135;000139;7;42;Improper High Speed CAN Communication"
	<< "000135;000139;8;41;VDC/TCS Operating"
	<< "000136;00013A;1;66;Cruise Control Calculation Error"
	<< "000136;00013A;2;25;Abnormality of Input Circuit for Brake Switch"
	<< "000136;00013A;3;65;Abnormality 1 of Switches related to Cruise Control"
	<< "000136;00013A;4;64;Engine Sensor Failure 1"
	<< "000136;00013A;5;63;Abnormality 1 of Change in Vehicle Speed"
	<< "000136;00013A;6;21;Abnormality of Switches when Ignition Switch ON"
	<< "000136;00013A;7;62;Neutral Switch Failure"
	<< "000136;00013A;8;61;Brake Switch Failure";


// Actuators:
const QStringList SSMFlagbyteDefinitions_en::_actuator_defs_en =
	QStringList()
	<< "29;7;000089;8;Fuel Pump Relay"
	<< "29;7;000089;7;Canister Purge Control (CPC) Solenoid Valve"
	<< "29;7;000089;6;Radiator Fan Relay"
	<< "29;7;000089;5;A/C Compressor Relay"
	<< "29;7;000089;4;Exhaust Gas Recirculation (EGR) Solenoid Valve"
	<< "29;7;000089;3;Air Suction Solenoid Valve (ASV)"
	<< "29;7;000089;2;Positive Crankcase Ventilation (PCV) Solenoid Valve"
	<< "29;7;000089;1;Ventilation Control Solenoid Valve"
	<< "29;7;00008A;8;Fast Idle Control Device (FICD) Solenoid"
	<< "29;7;00008A;7;Pressure Switching Solenoid 1"
	<< "29;7;00008A;6;Pressure Switching Solenoid 2"
	<< "29;7;00008A;5;Air Assist Injector (AAI) Solenoid Valve"
	<< "29;7;00008A;4;Fuel Tank Sensor Control Valve"
	<< "29;7;00008A;3;Turbocharger Wastegate Solenoid Valve"
	<< "29;7;00008A;2;Exhaust Bypass Control Permit Flag"
	<< "29;7;00008A;1;Secondary Air Combi Valve 1"
	<< "42;2;00018D;8;Secondary Air Combi Valve 2"
	<< "42;2;00018D;7;Secondary Air Pump Relay"
	<< "42;2;00018D;6;Canister Purge Control (CPC) Solenoid Valve 2"
	<< "42;2;00018D;5;Sub Fuel Pump Relay"
	<< "42;2;00018D;4;Fuel Pressure Switching Solenoid";


// Adjustments:
const QStringList SSMFlagbyteDefinitions_en::_adjustment_defs_en =
	QStringList()
	<< "26-5;0;6F;;Ignition Timing Correction;deg;0;5;0;*-1;0"
	<< "26-4;0;70;;Idle Speed Correction (AC off);rpm;124;140;128;-128*25;0"
	<< "26-3;0;71;;Idle Speed Correction (AC on);rpm;124;140;128;-128*25;0"
	<< "26-1;1;72;;Line Pressure Correction;%;90;110;100;-100;0"
	<< "A11020;1;73;;Gear Shift Line Pressure Correction - 1st to 2nd;kgf;90;110;100;-100/50;2"
	<< "A11020;1;74;;Gear Shift Line Pressure Correction - 2nd to 3rd;kgf;90;110;100;-100/50;2"
	<< "A11020;1;75;;Gear Shift Line Pressure Correction - 3rd to 4th;kgf;90;110;100;-100/50;2"
	<< "A11020;1;76;;Gear Shift Line Pressure Correction - 4th to 3rd;kgf;90;110;100;-100/50;2"
	<< "A11020;1;77;;Gear Shift Line Pressure Correction - 4th to 2nd;kgf;90;110;100;-100/50;2"
	<< "A11020;1;78;;Gear Shift Line Pressure Correction - 3rd to 2nd;kgf;90;110;100;-100/50;2"
	<< "27-8;1;79;;2-4-Brake Pressure 1 Correction;%;90;110;100;-100;0"
	<< "27-7;1;7A;;2-4-Brake Pressure 2 Correction - 1st to 2nd;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7B;;2-4-Brake Pressure 2 Correction - 2nd to 3rd;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7C;;2-4-Brake Pressure 2 Correction - 3rd to 4th;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7D;;2-4-Brake Pressure 2 Correction - 4th to 3rd;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7E;;2-4-Brake Pressure 2 Correction - 4th to 2nd;kgf;90;110;100;-100/50;2"
	<< "27-7;1;7F;;2-4-Brake Pressure 2 Correction - 3rd to 2nd;kgf;90;110;100;-100/50;2"
	<< "27-6;1;80;;Correction of Transfer Duty Ratio;%;90;110;100;-100;0"
	<< "27-5;1;81;;Slope Control;;0;1;0;0=Allowance,1=No Access;"
	<< "27-4;1;82;;Center Differential;%;50;150;100;*1;0"
	<< "27-3;1;171;170;Correction of AWD Clutch Torque;Nm;63535;2000;0;s16/50;0";


const QStringList SSMFlagbyteDefinitions_en::MBrawDefs()
{
	return _MB_defs_en;
}


const QStringList SSMFlagbyteDefinitions_en::SWrawDefs()
{
	return _SW_defs_en;
}


const QStringList SSMFlagbyteDefinitions_en::SUBDTCrawDefs()
{
	return _DTC_SUBARU_defs_en;
}


const QStringList SSMFlagbyteDefinitions_en::OBDDTCrawDefs()
{
	return _DTC_OBD_defs_en;
}


const QStringList SSMFlagbyteDefinitions_en::CCCCrawDefs()
{
	return _CC_defs_en;
}


const QStringList SSMFlagbyteDefinitions_en::ActuatorRawDefs()
{
	return _actuator_defs_en;
}


const QStringList SSMFlagbyteDefinitions_en::AdjustmentRawDefs()
{
	return _adjustment_defs_en;
}

