/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;

public class DefaultLocalVariantGraphResolveState
implements LocalVariantGraphResolveState {
    private final long instanceId;
    private final LocalVariantGraphResolveMetadata metadata;
    private final CalculatedValue<VariantDependencyMetadata> dependencies;
    private final DefaultLocalVariantArtifactResolveState artifactState;

    public DefaultLocalVariantGraphResolveState(long instanceId, LocalVariantGraphResolveMetadata metadata, CalculatedValue<VariantDependencyMetadata> dependencies, Set<LocalVariantMetadata> artifactSets) {
        this.instanceId = instanceId;
        this.metadata = metadata;
        this.dependencies = dependencies;
        this.artifactState = new DefaultLocalVariantArtifactResolveState(metadata.getId().getComponentId(), artifactSets);
    }

    @Override
    public long getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    public String toString() {
        return this.metadata.toString();
    }

    @Override
    public LocalVariantGraphResolveMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.metadata.getAttributes();
    }

    @Override
    public ImmutableCapabilities getCapabilities() {
        return this.metadata.getCapabilities();
    }

    @Override
    public Set<LocalFileDependencyMetadata> getFiles() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).files;
    }

    @Override
    public List<? extends DependencyMetadata> getDependencies() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).dependencies;
    }

    @Override
    public List<? extends ExcludeMetadata> getExcludes() {
        this.dependencies.finalizeIfNotAlready();
        return ((VariantDependencyMetadata)this.dependencies.get()).excludes;
    }

    @Override
    public VariantArtifactResolveState prepareForArtifactResolution() {
        return this.artifactState;
    }

    private static class DefaultLocalVariantArtifactResolveState
    implements VariantArtifactResolveState {
        private final ComponentIdentifier componentId;
        private final Set<LocalVariantMetadata> artifactSets;

        public DefaultLocalVariantArtifactResolveState(ComponentIdentifier componentId, Set<LocalVariantMetadata> artifactSets) {
            this.componentId = componentId;
            this.artifactSets = artifactSets;
        }

        @Override
        public ImmutableList<ComponentArtifactMetadata> getAdhocArtifacts(List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.getArtifactWithName(dependencyArtifact));
            }
            return artifacts.build();
        }

        private ComponentArtifactMetadata getArtifactWithName(IvyArtifactName ivyArtifactName) {
            for (VariantResolveMetadata variantResolveMetadata : this.getArtifactVariants()) {
                for (ComponentArtifactMetadata candidate : variantResolveMetadata.getArtifacts()) {
                    if (!candidate.getName().equals(ivyArtifactName)) continue;
                    return candidate;
                }
            }
            return new MissingLocalArtifactMetadata(this.componentId, ivyArtifactName);
        }

        public Set<LocalVariantMetadata> getArtifactVariants() {
            return this.artifactSets;
        }
    }

    public static class VariantDependencyMetadata {
        public final List<LocalOriginDependencyMetadata> dependencies;
        public final Set<LocalFileDependencyMetadata> files;
        public final ImmutableList<ExcludeMetadata> excludes;

        public VariantDependencyMetadata(List<LocalOriginDependencyMetadata> dependencies, Set<LocalFileDependencyMetadata> files, List<ExcludeMetadata> excludes) {
            this.dependencies = dependencies;
            this.files = files;
            this.excludes = ImmutableList.copyOf(excludes);
        }
    }
}

