---
icon: material/vector-combine
description: Integrations with test coverage tools, Miri, Criterion, cargo-mutants, and USDT probes.
---

# Integrations with other tools

Nextest integrates with a number of other tools in the Rust ecosystem and beyond:

- [Test coverage with llvm-cov](test-coverage.md)
- [The Miri interpreter for Rust](miri.md)
- [Debuggers and system call tracers](debuggers-tracers.md)
- [Criterion benchmarks](criterion.md)
- [Mutation testing with cargo-mutants](cargo-mutants.md)
- [USDT probes with bpftrace and DTrace](usdt.md)

!!! tip

    If your tool integrates with nextest, please feel free to [open an issue](https://github.com/nextest-rs/nextest/issues/new) to discuss including it in this section!
