/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ConversionException;
import org.mvel.ConversionHandler;
import org.mvel.conversion.Converter;

public class BigIntegerCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    @Override
    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    @Override
    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }

    static {
        CNV.put(Object.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return new BigInteger(String.valueOf(o));
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return (BigInteger)o;
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return ((BigDecimal)o).toBigInteger();
            }
        });
        CNV.put(String.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return new BigInteger((String)o);
            }
        });
        CNV.put(Short.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return new BigInteger(String.valueOf(o));
            }
        });
        CNV.put(Long.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return new BigInteger(String.valueOf(o));
            }
        });
        CNV.put(Integer.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return new BigInteger(String.valueOf(o));
            }
        });
        CNV.put(String.class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return new BigInteger((String)o);
            }
        });
        CNV.put(char[].class, new Converter(){

            @Override
            public BigInteger convert(Object o) {
                return new BigInteger(new String((char[])o));
            }
        });
    }
}

