// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package paymentcryptographyiface provides an interface to enable mocking the Payment Cryptography Control Plane service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package paymentcryptographyiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/paymentcryptography"
)

// PaymentCryptographyAPI provides an interface to enable mocking the
// paymentcryptography.PaymentCryptography service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Payment Cryptography Control Plane.
//	func myFunc(svc paymentcryptographyiface.PaymentCryptographyAPI) bool {
//	    // Make svc.CreateAlias request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := paymentcryptography.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockPaymentCryptographyClient struct {
//	    paymentcryptographyiface.PaymentCryptographyAPI
//	}
//	func (m *mockPaymentCryptographyClient) CreateAlias(input *paymentcryptography.CreateAliasInput) (*paymentcryptography.CreateAliasOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockPaymentCryptographyClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type PaymentCryptographyAPI interface {
	CreateAlias(*paymentcryptography.CreateAliasInput) (*paymentcryptography.CreateAliasOutput, error)
	CreateAliasWithContext(aws.Context, *paymentcryptography.CreateAliasInput, ...request.Option) (*paymentcryptography.CreateAliasOutput, error)
	CreateAliasRequest(*paymentcryptography.CreateAliasInput) (*request.Request, *paymentcryptography.CreateAliasOutput)

	CreateKey(*paymentcryptography.CreateKeyInput) (*paymentcryptography.CreateKeyOutput, error)
	CreateKeyWithContext(aws.Context, *paymentcryptography.CreateKeyInput, ...request.Option) (*paymentcryptography.CreateKeyOutput, error)
	CreateKeyRequest(*paymentcryptography.CreateKeyInput) (*request.Request, *paymentcryptography.CreateKeyOutput)

	DeleteAlias(*paymentcryptography.DeleteAliasInput) (*paymentcryptography.DeleteAliasOutput, error)
	DeleteAliasWithContext(aws.Context, *paymentcryptography.DeleteAliasInput, ...request.Option) (*paymentcryptography.DeleteAliasOutput, error)
	DeleteAliasRequest(*paymentcryptography.DeleteAliasInput) (*request.Request, *paymentcryptography.DeleteAliasOutput)

	DeleteKey(*paymentcryptography.DeleteKeyInput) (*paymentcryptography.DeleteKeyOutput, error)
	DeleteKeyWithContext(aws.Context, *paymentcryptography.DeleteKeyInput, ...request.Option) (*paymentcryptography.DeleteKeyOutput, error)
	DeleteKeyRequest(*paymentcryptography.DeleteKeyInput) (*request.Request, *paymentcryptography.DeleteKeyOutput)

	ExportKey(*paymentcryptography.ExportKeyInput) (*paymentcryptography.ExportKeyOutput, error)
	ExportKeyWithContext(aws.Context, *paymentcryptography.ExportKeyInput, ...request.Option) (*paymentcryptography.ExportKeyOutput, error)
	ExportKeyRequest(*paymentcryptography.ExportKeyInput) (*request.Request, *paymentcryptography.ExportKeyOutput)

	GetAlias(*paymentcryptography.GetAliasInput) (*paymentcryptography.GetAliasOutput, error)
	GetAliasWithContext(aws.Context, *paymentcryptography.GetAliasInput, ...request.Option) (*paymentcryptography.GetAliasOutput, error)
	GetAliasRequest(*paymentcryptography.GetAliasInput) (*request.Request, *paymentcryptography.GetAliasOutput)

	GetKey(*paymentcryptography.GetKeyInput) (*paymentcryptography.GetKeyOutput, error)
	GetKeyWithContext(aws.Context, *paymentcryptography.GetKeyInput, ...request.Option) (*paymentcryptography.GetKeyOutput, error)
	GetKeyRequest(*paymentcryptography.GetKeyInput) (*request.Request, *paymentcryptography.GetKeyOutput)

	GetParametersForExport(*paymentcryptography.GetParametersForExportInput) (*paymentcryptography.GetParametersForExportOutput, error)
	GetParametersForExportWithContext(aws.Context, *paymentcryptography.GetParametersForExportInput, ...request.Option) (*paymentcryptography.GetParametersForExportOutput, error)
	GetParametersForExportRequest(*paymentcryptography.GetParametersForExportInput) (*request.Request, *paymentcryptography.GetParametersForExportOutput)

	GetParametersForImport(*paymentcryptography.GetParametersForImportInput) (*paymentcryptography.GetParametersForImportOutput, error)
	GetParametersForImportWithContext(aws.Context, *paymentcryptography.GetParametersForImportInput, ...request.Option) (*paymentcryptography.GetParametersForImportOutput, error)
	GetParametersForImportRequest(*paymentcryptography.GetParametersForImportInput) (*request.Request, *paymentcryptography.GetParametersForImportOutput)

	GetPublicKeyCertificate(*paymentcryptography.GetPublicKeyCertificateInput) (*paymentcryptography.GetPublicKeyCertificateOutput, error)
	GetPublicKeyCertificateWithContext(aws.Context, *paymentcryptography.GetPublicKeyCertificateInput, ...request.Option) (*paymentcryptography.GetPublicKeyCertificateOutput, error)
	GetPublicKeyCertificateRequest(*paymentcryptography.GetPublicKeyCertificateInput) (*request.Request, *paymentcryptography.GetPublicKeyCertificateOutput)

	ImportKey(*paymentcryptography.ImportKeyInput) (*paymentcryptography.ImportKeyOutput, error)
	ImportKeyWithContext(aws.Context, *paymentcryptography.ImportKeyInput, ...request.Option) (*paymentcryptography.ImportKeyOutput, error)
	ImportKeyRequest(*paymentcryptography.ImportKeyInput) (*request.Request, *paymentcryptography.ImportKeyOutput)

	ListAliases(*paymentcryptography.ListAliasesInput) (*paymentcryptography.ListAliasesOutput, error)
	ListAliasesWithContext(aws.Context, *paymentcryptography.ListAliasesInput, ...request.Option) (*paymentcryptography.ListAliasesOutput, error)
	ListAliasesRequest(*paymentcryptography.ListAliasesInput) (*request.Request, *paymentcryptography.ListAliasesOutput)

	ListAliasesPages(*paymentcryptography.ListAliasesInput, func(*paymentcryptography.ListAliasesOutput, bool) bool) error
	ListAliasesPagesWithContext(aws.Context, *paymentcryptography.ListAliasesInput, func(*paymentcryptography.ListAliasesOutput, bool) bool, ...request.Option) error

	ListKeys(*paymentcryptography.ListKeysInput) (*paymentcryptography.ListKeysOutput, error)
	ListKeysWithContext(aws.Context, *paymentcryptography.ListKeysInput, ...request.Option) (*paymentcryptography.ListKeysOutput, error)
	ListKeysRequest(*paymentcryptography.ListKeysInput) (*request.Request, *paymentcryptography.ListKeysOutput)

	ListKeysPages(*paymentcryptography.ListKeysInput, func(*paymentcryptography.ListKeysOutput, bool) bool) error
	ListKeysPagesWithContext(aws.Context, *paymentcryptography.ListKeysInput, func(*paymentcryptography.ListKeysOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*paymentcryptography.ListTagsForResourceInput) (*paymentcryptography.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *paymentcryptography.ListTagsForResourceInput, ...request.Option) (*paymentcryptography.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*paymentcryptography.ListTagsForResourceInput) (*request.Request, *paymentcryptography.ListTagsForResourceOutput)

	ListTagsForResourcePages(*paymentcryptography.ListTagsForResourceInput, func(*paymentcryptography.ListTagsForResourceOutput, bool) bool) error
	ListTagsForResourcePagesWithContext(aws.Context, *paymentcryptography.ListTagsForResourceInput, func(*paymentcryptography.ListTagsForResourceOutput, bool) bool, ...request.Option) error

	RestoreKey(*paymentcryptography.RestoreKeyInput) (*paymentcryptography.RestoreKeyOutput, error)
	RestoreKeyWithContext(aws.Context, *paymentcryptography.RestoreKeyInput, ...request.Option) (*paymentcryptography.RestoreKeyOutput, error)
	RestoreKeyRequest(*paymentcryptography.RestoreKeyInput) (*request.Request, *paymentcryptography.RestoreKeyOutput)

	StartKeyUsage(*paymentcryptography.StartKeyUsageInput) (*paymentcryptography.StartKeyUsageOutput, error)
	StartKeyUsageWithContext(aws.Context, *paymentcryptography.StartKeyUsageInput, ...request.Option) (*paymentcryptography.StartKeyUsageOutput, error)
	StartKeyUsageRequest(*paymentcryptography.StartKeyUsageInput) (*request.Request, *paymentcryptography.StartKeyUsageOutput)

	StopKeyUsage(*paymentcryptography.StopKeyUsageInput) (*paymentcryptography.StopKeyUsageOutput, error)
	StopKeyUsageWithContext(aws.Context, *paymentcryptography.StopKeyUsageInput, ...request.Option) (*paymentcryptography.StopKeyUsageOutput, error)
	StopKeyUsageRequest(*paymentcryptography.StopKeyUsageInput) (*request.Request, *paymentcryptography.StopKeyUsageOutput)

	TagResource(*paymentcryptography.TagResourceInput) (*paymentcryptography.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *paymentcryptography.TagResourceInput, ...request.Option) (*paymentcryptography.TagResourceOutput, error)
	TagResourceRequest(*paymentcryptography.TagResourceInput) (*request.Request, *paymentcryptography.TagResourceOutput)

	UntagResource(*paymentcryptography.UntagResourceInput) (*paymentcryptography.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *paymentcryptography.UntagResourceInput, ...request.Option) (*paymentcryptography.UntagResourceOutput, error)
	UntagResourceRequest(*paymentcryptography.UntagResourceInput) (*request.Request, *paymentcryptography.UntagResourceOutput)

	UpdateAlias(*paymentcryptography.UpdateAliasInput) (*paymentcryptography.UpdateAliasOutput, error)
	UpdateAliasWithContext(aws.Context, *paymentcryptography.UpdateAliasInput, ...request.Option) (*paymentcryptography.UpdateAliasOutput, error)
	UpdateAliasRequest(*paymentcryptography.UpdateAliasInput) (*request.Request, *paymentcryptography.UpdateAliasOutput)
}

var _ PaymentCryptographyAPI = (*paymentcryptography.PaymentCryptography)(nil)
