// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package bedrockagent

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAgentKnowledgeBase = "AssociateAgentKnowledgeBase"

// AssociateAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAgentKnowledgeBase for more information on using the AssociateAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateAgentKnowledgeBaseRequest method.
//	req, resp := client.AssociateAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AssociateAgentKnowledgeBase
func (c *BedrockAgent) AssociateAgentKnowledgeBaseRequest(input *AssociateAgentKnowledgeBaseInput) (req *request.Request, output *AssociateAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opAssociateAgentKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/",
	}

	if input == nil {
		input = &AssociateAgentKnowledgeBaseInput{}
	}

	output = &AssociateAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Associates a knowledge base with an agent. If a knowledge base is associated
// and its indexState is set to Enabled, the agent queries the knowledge base
// for information to augment its response to the user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation AssociateAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/AssociateAgentKnowledgeBase
func (c *BedrockAgent) AssociateAgentKnowledgeBase(input *AssociateAgentKnowledgeBaseInput) (*AssociateAgentKnowledgeBaseOutput, error) {
	req, out := c.AssociateAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// AssociateAgentKnowledgeBaseWithContext is the same as AssociateAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) AssociateAgentKnowledgeBaseWithContext(ctx aws.Context, input *AssociateAgentKnowledgeBaseInput, opts ...request.Option) (*AssociateAgentKnowledgeBaseOutput, error) {
	req, out := c.AssociateAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgent = "CreateAgent"

// CreateAgentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgent for more information on using the CreateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentRequest method.
//	req, resp := client.CreateAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgent
func (c *BedrockAgent) CreateAgentRequest(input *CreateAgentInput) (req *request.Request, output *CreateAgentOutput) {
	op := &request.Operation{
		Name:       opCreateAgent,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/",
	}

	if input == nil {
		input = &CreateAgentInput{}
	}

	output = &CreateAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgent API operation for Agents for Amazon Bedrock.
//
// Creates an agent that orchestrates interactions between foundation models,
// data sources, software applications, user conversations, and APIs to carry
// out tasks to help customers.
//
//   - Specify the following fields for security purposes. agentResourceRoleArn
//     – The Amazon Resource Name (ARN) of the role with permissions to invoke
//     API operations on an agent. (Optional) customerEncryptionKeyArn – The
//     Amazon Resource Name (ARN) of a KMS key to encrypt the creation of the
//     agent. (Optional) idleSessionTTLinSeconds – Specify the number of seconds
//     for which the agent should maintain session information. After this time
//     expires, the subsequent InvokeAgent request begins a new session.
//
//   - To enable your agent to retain conversational context across multiple
//     sessions, include a memoryConfiguration object. For more information,
//     see Configure memory (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-configure-memory.html).
//
//   - To override the default prompt behavior for agent orchestration and
//     to use advanced prompts, include a promptOverrideConfiguration object.
//     For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
//
//   - If you agent fails to be created, the response returns a list of failureReasons
//     alongside a list of recommendedActions for you to troubleshoot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgent
func (c *BedrockAgent) CreateAgent(input *CreateAgentInput) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	return out, req.Send()
}

// CreateAgentWithContext is the same as CreateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateAgentWithContext(ctx aws.Context, input *CreateAgentInput, opts ...request.Option) (*CreateAgentOutput, error) {
	req, out := c.CreateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgentActionGroup = "CreateAgentActionGroup"

// CreateAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgentActionGroup for more information on using the CreateAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentActionGroupRequest method.
//	req, resp := client.CreateAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentActionGroup
func (c *BedrockAgent) CreateAgentActionGroupRequest(input *CreateAgentActionGroupInput) (req *request.Request, output *CreateAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opCreateAgentActionGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/",
	}

	if input == nil {
		input = &CreateAgentActionGroupInput{}
	}

	output = &CreateAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Creates an action group for an agent. An action group represents the actions
// that an agent can carry out for the customer by defining the APIs that an
// agent can call and the logic for calling them.
//
// To allow your agent to request the user for additional information when trying
// to complete a task, add an action group with the parentActionGroupSignature
// field set to AMAZON.UserInput.
//
// To allow your agent to generate, run, and troubleshoot code when trying to
// complete a task, add an action group with the parentActionGroupSignature
// field set to AMAZON.CodeInterpreter.
//
// You must leave the description, apiSchema, and actionGroupExecutor fields
// blank for this action group. During orchestration, if your agent determines
// that it needs to invoke an API in an action group, but doesn't have enough
// information to complete the API request, it will invoke this action group
// instead and return an Observation (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
// reprompting the user for more information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentActionGroup
func (c *BedrockAgent) CreateAgentActionGroup(input *CreateAgentActionGroupInput) (*CreateAgentActionGroupOutput, error) {
	req, out := c.CreateAgentActionGroupRequest(input)
	return out, req.Send()
}

// CreateAgentActionGroupWithContext is the same as CreateAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateAgentActionGroupWithContext(ctx aws.Context, input *CreateAgentActionGroupInput, opts ...request.Option) (*CreateAgentActionGroupOutput, error) {
	req, out := c.CreateAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgentAlias = "CreateAgentAlias"

// CreateAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgentAlias for more information on using the CreateAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentAliasRequest method.
//	req, resp := client.CreateAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentAlias
func (c *BedrockAgent) CreateAgentAliasRequest(input *CreateAgentAliasInput) (req *request.Request, output *CreateAgentAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAgentAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentaliases/",
	}

	if input == nil {
		input = &CreateAgentAliasInput{}
	}

	output = &CreateAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgentAlias API operation for Agents for Amazon Bedrock.
//
// Creates an alias of an agent that can be used to deploy the agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateAgentAlias
func (c *BedrockAgent) CreateAgentAlias(input *CreateAgentAliasInput) (*CreateAgentAliasOutput, error) {
	req, out := c.CreateAgentAliasRequest(input)
	return out, req.Send()
}

// CreateAgentAliasWithContext is the same as CreateAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateAgentAliasWithContext(ctx aws.Context, input *CreateAgentAliasInput, opts ...request.Option) (*CreateAgentAliasOutput, error) {
	req, out := c.CreateAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataSource = "CreateDataSource"

// CreateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataSource for more information on using the CreateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDataSourceRequest method.
//	req, resp := client.CreateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateDataSource
func (c *BedrockAgent) CreateDataSourceRequest(input *CreateDataSourceInput) (req *request.Request, output *CreateDataSourceOutput) {
	op := &request.Operation{
		Name:       opCreateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/",
	}

	if input == nil {
		input = &CreateDataSourceInput{}
	}

	output = &CreateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataSource API operation for Agents for Amazon Bedrock.
//
// Creates a data source connector for a knowledge base.
//
// You can't change the chunkingConfiguration after you create the data source
// connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateDataSource
func (c *BedrockAgent) CreateDataSource(input *CreateDataSourceInput) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	return out, req.Send()
}

// CreateDataSourceWithContext is the same as CreateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateDataSourceWithContext(ctx aws.Context, input *CreateDataSourceInput, opts ...request.Option) (*CreateDataSourceOutput, error) {
	req, out := c.CreateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlow = "CreateFlow"

// CreateFlowRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlow for more information on using the CreateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFlowRequest method.
//	req, resp := client.CreateFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateFlow
func (c *BedrockAgent) CreateFlowRequest(input *CreateFlowInput) (req *request.Request, output *CreateFlowOutput) {
	op := &request.Operation{
		Name:       opCreateFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/flows/",
	}

	if input == nil {
		input = &CreateFlowInput{}
	}

	output = &CreateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlow API operation for Agents for Amazon Bedrock.
//
// Creates a prompt flow that you can use to send an input through various steps
// to yield an output. Configure nodes, each of which corresponds to a step
// of the flow, and create connections between the nodes to create paths to
// different outputs. For more information, see How it works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html)
// and Create a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateFlow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateFlow
func (c *BedrockAgent) CreateFlow(input *CreateFlowInput) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	return out, req.Send()
}

// CreateFlowWithContext is the same as CreateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateFlowWithContext(ctx aws.Context, input *CreateFlowInput, opts ...request.Option) (*CreateFlowOutput, error) {
	req, out := c.CreateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlowAlias = "CreateFlowAlias"

// CreateFlowAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlowAlias for more information on using the CreateFlowAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFlowAliasRequest method.
//	req, resp := client.CreateFlowAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateFlowAlias
func (c *BedrockAgent) CreateFlowAliasRequest(input *CreateFlowAliasInput) (req *request.Request, output *CreateFlowAliasOutput) {
	op := &request.Operation{
		Name:       opCreateFlowAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/flows/{flowIdentifier}/aliases",
	}

	if input == nil {
		input = &CreateFlowAliasInput{}
	}

	output = &CreateFlowAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowAlias API operation for Agents for Amazon Bedrock.
//
// Creates an alias of a flow for deployment. For more information, see Deploy
// a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateFlowAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateFlowAlias
func (c *BedrockAgent) CreateFlowAlias(input *CreateFlowAliasInput) (*CreateFlowAliasOutput, error) {
	req, out := c.CreateFlowAliasRequest(input)
	return out, req.Send()
}

// CreateFlowAliasWithContext is the same as CreateFlowAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlowAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateFlowAliasWithContext(ctx aws.Context, input *CreateFlowAliasInput, opts ...request.Option) (*CreateFlowAliasOutput, error) {
	req, out := c.CreateFlowAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFlowVersion = "CreateFlowVersion"

// CreateFlowVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFlowVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFlowVersion for more information on using the CreateFlowVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFlowVersionRequest method.
//	req, resp := client.CreateFlowVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateFlowVersion
func (c *BedrockAgent) CreateFlowVersionRequest(input *CreateFlowVersionInput) (req *request.Request, output *CreateFlowVersionOutput) {
	op := &request.Operation{
		Name:       opCreateFlowVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/flows/{flowIdentifier}/versions",
	}

	if input == nil {
		input = &CreateFlowVersionInput{}
	}

	output = &CreateFlowVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFlowVersion API operation for Agents for Amazon Bedrock.
//
// Creates a version of the flow that you can deploy. For more information,
// see Deploy a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateFlowVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateFlowVersion
func (c *BedrockAgent) CreateFlowVersion(input *CreateFlowVersionInput) (*CreateFlowVersionOutput, error) {
	req, out := c.CreateFlowVersionRequest(input)
	return out, req.Send()
}

// CreateFlowVersionWithContext is the same as CreateFlowVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFlowVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateFlowVersionWithContext(ctx aws.Context, input *CreateFlowVersionInput, opts ...request.Option) (*CreateFlowVersionOutput, error) {
	req, out := c.CreateFlowVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateKnowledgeBase = "CreateKnowledgeBase"

// CreateKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateKnowledgeBase for more information on using the CreateKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateKnowledgeBaseRequest method.
//	req, resp := client.CreateKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateKnowledgeBase
func (c *BedrockAgent) CreateKnowledgeBaseRequest(input *CreateKnowledgeBaseInput) (req *request.Request, output *CreateKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opCreateKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/",
	}

	if input == nil {
		input = &CreateKnowledgeBaseInput{}
	}

	output = &CreateKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Creates a knowledge base that contains data sources from which information
// can be queried and used by LLMs. To create a knowledge base, you must first
// set up your data sources and configure a supported vector store. For more
// information, see Set up your data for ingestion (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup.html).
//
// If you prefer to let Amazon Bedrock create and manage a vector store for
// you in Amazon OpenSearch Service, use the console. For more information,
// see Create a knowledge base (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-create).
//
//   - Provide the name and an optional description.
//
//   - Provide the Amazon Resource Name (ARN) with permissions to create a
//     knowledge base in the roleArn field.
//
//   - Provide the embedding model to use in the embeddingModelArn field in
//     the knowledgeBaseConfiguration object.
//
//   - Provide the configuration for your vector store in the storageConfiguration
//     object. For an Amazon OpenSearch Service database, use the opensearchServerlessConfiguration
//     object. For more information, see Create a vector store in Amazon OpenSearch
//     Service (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html).
//     For an Amazon Aurora database, use the RdsConfiguration object. For more
//     information, see Create a vector store in Amazon Aurora (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html).
//     For a Pinecone database, use the pineconeConfiguration object. For more
//     information, see Create a vector store in Pinecone (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html).
//     For a Redis Enterprise Cloud database, use the redisEnterpriseCloudConfiguration
//     object. For more information, see Create a vector store in Redis Enterprise
//     Cloud (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-redis.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreateKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreateKnowledgeBase
func (c *BedrockAgent) CreateKnowledgeBase(input *CreateKnowledgeBaseInput) (*CreateKnowledgeBaseOutput, error) {
	req, out := c.CreateKnowledgeBaseRequest(input)
	return out, req.Send()
}

// CreateKnowledgeBaseWithContext is the same as CreateKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreateKnowledgeBaseWithContext(ctx aws.Context, input *CreateKnowledgeBaseInput, opts ...request.Option) (*CreateKnowledgeBaseOutput, error) {
	req, out := c.CreateKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePrompt = "CreatePrompt"

// CreatePromptRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrompt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePrompt for more information on using the CreatePrompt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePromptRequest method.
//	req, resp := client.CreatePromptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreatePrompt
func (c *BedrockAgent) CreatePromptRequest(input *CreatePromptInput) (req *request.Request, output *CreatePromptOutput) {
	op := &request.Operation{
		Name:       opCreatePrompt,
		HTTPMethod: "POST",
		HTTPPath:   "/prompts/",
	}

	if input == nil {
		input = &CreatePromptInput{}
	}

	output = &CreatePromptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrompt API operation for Agents for Amazon Bedrock.
//
// Creates a prompt in your prompt library that you can add to a flow. For more
// information, see Prompt management in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html),
// Create a prompt using Prompt management (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-create.html)
// and Prompt flows in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreatePrompt for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreatePrompt
func (c *BedrockAgent) CreatePrompt(input *CreatePromptInput) (*CreatePromptOutput, error) {
	req, out := c.CreatePromptRequest(input)
	return out, req.Send()
}

// CreatePromptWithContext is the same as CreatePrompt with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrompt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreatePromptWithContext(ctx aws.Context, input *CreatePromptInput, opts ...request.Option) (*CreatePromptOutput, error) {
	req, out := c.CreatePromptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePromptVersion = "CreatePromptVersion"

// CreatePromptVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePromptVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePromptVersion for more information on using the CreatePromptVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePromptVersionRequest method.
//	req, resp := client.CreatePromptVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreatePromptVersion
func (c *BedrockAgent) CreatePromptVersionRequest(input *CreatePromptVersionInput) (req *request.Request, output *CreatePromptVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePromptVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/prompts/{promptIdentifier}/versions",
	}

	if input == nil {
		input = &CreatePromptVersionInput{}
	}

	output = &CreatePromptVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePromptVersion API operation for Agents for Amazon Bedrock.
//
// Creates a static snapshot of your prompt that can be deployed to production.
// For more information, see Deploy prompts using Prompt management by creating
// versions (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation CreatePromptVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/CreatePromptVersion
func (c *BedrockAgent) CreatePromptVersion(input *CreatePromptVersionInput) (*CreatePromptVersionOutput, error) {
	req, out := c.CreatePromptVersionRequest(input)
	return out, req.Send()
}

// CreatePromptVersionWithContext is the same as CreatePromptVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePromptVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) CreatePromptVersionWithContext(ctx aws.Context, input *CreatePromptVersionInput, opts ...request.Option) (*CreatePromptVersionOutput, error) {
	req, out := c.CreatePromptVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgent = "DeleteAgent"

// DeleteAgentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgent for more information on using the DeleteAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentRequest method.
//	req, resp := client.DeleteAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgent
func (c *BedrockAgent) DeleteAgentRequest(input *DeleteAgentInput) (req *request.Request, output *DeleteAgentOutput) {
	op := &request.Operation{
		Name:       opDeleteAgent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &DeleteAgentInput{}
	}

	output = &DeleteAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAgent API operation for Agents for Amazon Bedrock.
//
// Deletes an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgent
func (c *BedrockAgent) DeleteAgent(input *DeleteAgentInput) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	return out, req.Send()
}

// DeleteAgentWithContext is the same as DeleteAgent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentWithContext(ctx aws.Context, input *DeleteAgentInput, opts ...request.Option) (*DeleteAgentOutput, error) {
	req, out := c.DeleteAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgentActionGroup = "DeleteAgentActionGroup"

// DeleteAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgentActionGroup for more information on using the DeleteAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentActionGroupRequest method.
//	req, resp := client.DeleteAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentActionGroup
func (c *BedrockAgent) DeleteAgentActionGroupRequest(input *DeleteAgentActionGroupInput) (req *request.Request, output *DeleteAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteAgentActionGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
	}

	if input == nil {
		input = &DeleteAgentActionGroupInput{}
	}

	output = &DeleteAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Deletes an action group in an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentActionGroup
func (c *BedrockAgent) DeleteAgentActionGroup(input *DeleteAgentActionGroupInput) (*DeleteAgentActionGroupOutput, error) {
	req, out := c.DeleteAgentActionGroupRequest(input)
	return out, req.Send()
}

// DeleteAgentActionGroupWithContext is the same as DeleteAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentActionGroupWithContext(ctx aws.Context, input *DeleteAgentActionGroupInput, opts ...request.Option) (*DeleteAgentActionGroupOutput, error) {
	req, out := c.DeleteAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgentAlias = "DeleteAgentAlias"

// DeleteAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgentAlias for more information on using the DeleteAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentAliasRequest method.
//	req, resp := client.DeleteAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentAlias
func (c *BedrockAgent) DeleteAgentAliasRequest(input *DeleteAgentAliasInput) (req *request.Request, output *DeleteAgentAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAgentAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentaliases/{agentAliasId}/",
	}

	if input == nil {
		input = &DeleteAgentAliasInput{}
	}

	output = &DeleteAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAgentAlias API operation for Agents for Amazon Bedrock.
//
// Deletes an alias of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentAlias
func (c *BedrockAgent) DeleteAgentAlias(input *DeleteAgentAliasInput) (*DeleteAgentAliasOutput, error) {
	req, out := c.DeleteAgentAliasRequest(input)
	return out, req.Send()
}

// DeleteAgentAliasWithContext is the same as DeleteAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentAliasWithContext(ctx aws.Context, input *DeleteAgentAliasInput, opts ...request.Option) (*DeleteAgentAliasOutput, error) {
	req, out := c.DeleteAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAgentVersion = "DeleteAgentVersion"

// DeleteAgentVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAgentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAgentVersion for more information on using the DeleteAgentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAgentVersionRequest method.
//	req, resp := client.DeleteAgentVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentVersion
func (c *BedrockAgent) DeleteAgentVersionRequest(input *DeleteAgentVersionInput) (req *request.Request, output *DeleteAgentVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteAgentVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/",
	}

	if input == nil {
		input = &DeleteAgentVersionInput{}
	}

	output = &DeleteAgentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAgentVersion API operation for Agents for Amazon Bedrock.
//
// Deletes a version of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteAgentVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteAgentVersion
func (c *BedrockAgent) DeleteAgentVersion(input *DeleteAgentVersionInput) (*DeleteAgentVersionOutput, error) {
	req, out := c.DeleteAgentVersionRequest(input)
	return out, req.Send()
}

// DeleteAgentVersionWithContext is the same as DeleteAgentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAgentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteAgentVersionWithContext(ctx aws.Context, input *DeleteAgentVersionInput, opts ...request.Option) (*DeleteAgentVersionOutput, error) {
	req, out := c.DeleteAgentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataSource for more information on using the DeleteDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDataSourceRequest method.
//	req, resp := client.DeleteDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteDataSource
func (c *BedrockAgent) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *request.Request, output *DeleteDataSourceOutput) {
	op := &request.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	output = &DeleteDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataSource API operation for Agents for Amazon Bedrock.
//
// Deletes a data source from a knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteDataSource
func (c *BedrockAgent) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	return out, req.Send()
}

// DeleteDataSourceWithContext is the same as DeleteDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteDataSourceWithContext(ctx aws.Context, input *DeleteDataSourceInput, opts ...request.Option) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlow = "DeleteFlow"

// DeleteFlowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlow for more information on using the DeleteFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFlowRequest method.
//	req, resp := client.DeleteFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteFlow
func (c *BedrockAgent) DeleteFlowRequest(input *DeleteFlowInput) (req *request.Request, output *DeleteFlowOutput) {
	op := &request.Operation{
		Name:       opDeleteFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/flows/{flowIdentifier}/",
	}

	if input == nil {
		input = &DeleteFlowInput{}
	}

	output = &DeleteFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlow API operation for Agents for Amazon Bedrock.
//
// Deletes a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteFlow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteFlow
func (c *BedrockAgent) DeleteFlow(input *DeleteFlowInput) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	return out, req.Send()
}

// DeleteFlowWithContext is the same as DeleteFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteFlowWithContext(ctx aws.Context, input *DeleteFlowInput, opts ...request.Option) (*DeleteFlowOutput, error) {
	req, out := c.DeleteFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlowAlias = "DeleteFlowAlias"

// DeleteFlowAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlowAlias for more information on using the DeleteFlowAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFlowAliasRequest method.
//	req, resp := client.DeleteFlowAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteFlowAlias
func (c *BedrockAgent) DeleteFlowAliasRequest(input *DeleteFlowAliasInput) (req *request.Request, output *DeleteFlowAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/flows/{flowIdentifier}/aliases/{aliasIdentifier}",
	}

	if input == nil {
		input = &DeleteFlowAliasInput{}
	}

	output = &DeleteFlowAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlowAlias API operation for Agents for Amazon Bedrock.
//
// Deletes an alias of a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteFlowAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteFlowAlias
func (c *BedrockAgent) DeleteFlowAlias(input *DeleteFlowAliasInput) (*DeleteFlowAliasOutput, error) {
	req, out := c.DeleteFlowAliasRequest(input)
	return out, req.Send()
}

// DeleteFlowAliasWithContext is the same as DeleteFlowAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlowAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteFlowAliasWithContext(ctx aws.Context, input *DeleteFlowAliasInput, opts ...request.Option) (*DeleteFlowAliasOutput, error) {
	req, out := c.DeleteFlowAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFlowVersion = "DeleteFlowVersion"

// DeleteFlowVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFlowVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFlowVersion for more information on using the DeleteFlowVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFlowVersionRequest method.
//	req, resp := client.DeleteFlowVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteFlowVersion
func (c *BedrockAgent) DeleteFlowVersionRequest(input *DeleteFlowVersionInput) (req *request.Request, output *DeleteFlowVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteFlowVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/flows/{flowIdentifier}/versions/{flowVersion}/",
	}

	if input == nil {
		input = &DeleteFlowVersionInput{}
	}

	output = &DeleteFlowVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFlowVersion API operation for Agents for Amazon Bedrock.
//
// Deletes a version of a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteFlowVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteFlowVersion
func (c *BedrockAgent) DeleteFlowVersion(input *DeleteFlowVersionInput) (*DeleteFlowVersionOutput, error) {
	req, out := c.DeleteFlowVersionRequest(input)
	return out, req.Send()
}

// DeleteFlowVersionWithContext is the same as DeleteFlowVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFlowVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteFlowVersionWithContext(ctx aws.Context, input *DeleteFlowVersionInput, opts ...request.Option) (*DeleteFlowVersionOutput, error) {
	req, out := c.DeleteFlowVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteKnowledgeBase = "DeleteKnowledgeBase"

// DeleteKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteKnowledgeBase for more information on using the DeleteKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteKnowledgeBaseRequest method.
//	req, resp := client.DeleteKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteKnowledgeBase
func (c *BedrockAgent) DeleteKnowledgeBaseRequest(input *DeleteKnowledgeBaseInput) (req *request.Request, output *DeleteKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opDeleteKnowledgeBase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &DeleteKnowledgeBaseInput{}
	}

	output = &DeleteKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Deletes a knowledge base. Before deleting a knowledge base, you should disassociate
// the knowledge base from any agents that it is associated with by making a
// DisassociateAgentKnowledgeBase (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_DisassociateAgentKnowledgeBase.html)
// request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeleteKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeleteKnowledgeBase
func (c *BedrockAgent) DeleteKnowledgeBase(input *DeleteKnowledgeBaseInput) (*DeleteKnowledgeBaseOutput, error) {
	req, out := c.DeleteKnowledgeBaseRequest(input)
	return out, req.Send()
}

// DeleteKnowledgeBaseWithContext is the same as DeleteKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeleteKnowledgeBaseWithContext(ctx aws.Context, input *DeleteKnowledgeBaseInput, opts ...request.Option) (*DeleteKnowledgeBaseOutput, error) {
	req, out := c.DeleteKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePrompt = "DeletePrompt"

// DeletePromptRequest generates a "aws/request.Request" representing the
// client's request for the DeletePrompt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePrompt for more information on using the DeletePrompt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePromptRequest method.
//	req, resp := client.DeletePromptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeletePrompt
func (c *BedrockAgent) DeletePromptRequest(input *DeletePromptInput) (req *request.Request, output *DeletePromptOutput) {
	op := &request.Operation{
		Name:       opDeletePrompt,
		HTTPMethod: "DELETE",
		HTTPPath:   "/prompts/{promptIdentifier}/",
	}

	if input == nil {
		input = &DeletePromptInput{}
	}

	output = &DeletePromptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePrompt API operation for Agents for Amazon Bedrock.
//
// Deletes a prompt or a prompt version from the Prompt management tool. For
// more information, see Delete prompts from the Prompt management tool (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-delete.html)
// and Delete a version of a prompt from the Prompt management tool (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html#prompt-management-versions-delete.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DeletePrompt for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DeletePrompt
func (c *BedrockAgent) DeletePrompt(input *DeletePromptInput) (*DeletePromptOutput, error) {
	req, out := c.DeletePromptRequest(input)
	return out, req.Send()
}

// DeletePromptWithContext is the same as DeletePrompt with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePrompt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DeletePromptWithContext(ctx aws.Context, input *DeletePromptInput, opts ...request.Option) (*DeletePromptOutput, error) {
	req, out := c.DeletePromptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAgentKnowledgeBase = "DisassociateAgentKnowledgeBase"

// DisassociateAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAgentKnowledgeBase for more information on using the DisassociateAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateAgentKnowledgeBaseRequest method.
//	req, resp := client.DisassociateAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DisassociateAgentKnowledgeBase
func (c *BedrockAgent) DisassociateAgentKnowledgeBaseRequest(input *DisassociateAgentKnowledgeBaseInput) (req *request.Request, output *DisassociateAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opDisassociateAgentKnowledgeBase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
	}

	if input == nil {
		input = &DisassociateAgentKnowledgeBaseInput{}
	}

	output = &DisassociateAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Disassociates a knowledge base from an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation DisassociateAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/DisassociateAgentKnowledgeBase
func (c *BedrockAgent) DisassociateAgentKnowledgeBase(input *DisassociateAgentKnowledgeBaseInput) (*DisassociateAgentKnowledgeBaseOutput, error) {
	req, out := c.DisassociateAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// DisassociateAgentKnowledgeBaseWithContext is the same as DisassociateAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) DisassociateAgentKnowledgeBaseWithContext(ctx aws.Context, input *DisassociateAgentKnowledgeBaseInput, opts ...request.Option) (*DisassociateAgentKnowledgeBaseOutput, error) {
	req, out := c.DisassociateAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgent = "GetAgent"

// GetAgentRequest generates a "aws/request.Request" representing the
// client's request for the GetAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgent for more information on using the GetAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentRequest method.
//	req, resp := client.GetAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgent
func (c *BedrockAgent) GetAgentRequest(input *GetAgentInput) (req *request.Request, output *GetAgentOutput) {
	op := &request.Operation{
		Name:       opGetAgent,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &GetAgentInput{}
	}

	output = &GetAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgent API operation for Agents for Amazon Bedrock.
//
// Gets information about an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgent
func (c *BedrockAgent) GetAgent(input *GetAgentInput) (*GetAgentOutput, error) {
	req, out := c.GetAgentRequest(input)
	return out, req.Send()
}

// GetAgentWithContext is the same as GetAgent with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentWithContext(ctx aws.Context, input *GetAgentInput, opts ...request.Option) (*GetAgentOutput, error) {
	req, out := c.GetAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentActionGroup = "GetAgentActionGroup"

// GetAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentActionGroup for more information on using the GetAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentActionGroupRequest method.
//	req, resp := client.GetAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentActionGroup
func (c *BedrockAgent) GetAgentActionGroupRequest(input *GetAgentActionGroupInput) (req *request.Request, output *GetAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opGetAgentActionGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
	}

	if input == nil {
		input = &GetAgentActionGroupInput{}
	}

	output = &GetAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Gets information about an action group for an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentActionGroup
func (c *BedrockAgent) GetAgentActionGroup(input *GetAgentActionGroupInput) (*GetAgentActionGroupOutput, error) {
	req, out := c.GetAgentActionGroupRequest(input)
	return out, req.Send()
}

// GetAgentActionGroupWithContext is the same as GetAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentActionGroupWithContext(ctx aws.Context, input *GetAgentActionGroupInput, opts ...request.Option) (*GetAgentActionGroupOutput, error) {
	req, out := c.GetAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentAlias = "GetAgentAlias"

// GetAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentAlias for more information on using the GetAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentAliasRequest method.
//	req, resp := client.GetAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentAlias
func (c *BedrockAgent) GetAgentAliasRequest(input *GetAgentAliasInput) (req *request.Request, output *GetAgentAliasOutput) {
	op := &request.Operation{
		Name:       opGetAgentAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentaliases/{agentAliasId}/",
	}

	if input == nil {
		input = &GetAgentAliasInput{}
	}

	output = &GetAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentAlias API operation for Agents for Amazon Bedrock.
//
// Gets information about an alias of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentAlias
func (c *BedrockAgent) GetAgentAlias(input *GetAgentAliasInput) (*GetAgentAliasOutput, error) {
	req, out := c.GetAgentAliasRequest(input)
	return out, req.Send()
}

// GetAgentAliasWithContext is the same as GetAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentAliasWithContext(ctx aws.Context, input *GetAgentAliasInput, opts ...request.Option) (*GetAgentAliasOutput, error) {
	req, out := c.GetAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentKnowledgeBase = "GetAgentKnowledgeBase"

// GetAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentKnowledgeBase for more information on using the GetAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentKnowledgeBaseRequest method.
//	req, resp := client.GetAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentKnowledgeBase
func (c *BedrockAgent) GetAgentKnowledgeBaseRequest(input *GetAgentKnowledgeBaseInput) (req *request.Request, output *GetAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opGetAgentKnowledgeBase,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
	}

	if input == nil {
		input = &GetAgentKnowledgeBaseInput{}
	}

	output = &GetAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Gets information about a knowledge base associated with an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentKnowledgeBase
func (c *BedrockAgent) GetAgentKnowledgeBase(input *GetAgentKnowledgeBaseInput) (*GetAgentKnowledgeBaseOutput, error) {
	req, out := c.GetAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// GetAgentKnowledgeBaseWithContext is the same as GetAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentKnowledgeBaseWithContext(ctx aws.Context, input *GetAgentKnowledgeBaseInput, opts ...request.Option) (*GetAgentKnowledgeBaseOutput, error) {
	req, out := c.GetAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAgentVersion = "GetAgentVersion"

// GetAgentVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetAgentVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAgentVersion for more information on using the GetAgentVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAgentVersionRequest method.
//	req, resp := client.GetAgentVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentVersion
func (c *BedrockAgent) GetAgentVersionRequest(input *GetAgentVersionInput) (req *request.Request, output *GetAgentVersionOutput) {
	op := &request.Operation{
		Name:       opGetAgentVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/",
	}

	if input == nil {
		input = &GetAgentVersionInput{}
	}

	output = &GetAgentVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAgentVersion API operation for Agents for Amazon Bedrock.
//
// Gets details about a version of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetAgentVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetAgentVersion
func (c *BedrockAgent) GetAgentVersion(input *GetAgentVersionInput) (*GetAgentVersionOutput, error) {
	req, out := c.GetAgentVersionRequest(input)
	return out, req.Send()
}

// GetAgentVersionWithContext is the same as GetAgentVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetAgentVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetAgentVersionWithContext(ctx aws.Context, input *GetAgentVersionInput, opts ...request.Option) (*GetAgentVersionOutput, error) {
	req, out := c.GetAgentVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the GetDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataSource for more information on using the GetDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDataSourceRequest method.
//	req, resp := client.GetDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetDataSource
func (c *BedrockAgent) GetDataSourceRequest(input *GetDataSourceInput) (req *request.Request, output *GetDataSourceOutput) {
	op := &request.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	output = &GetDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataSource API operation for Agents for Amazon Bedrock.
//
// Gets information about a data source.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetDataSource
func (c *BedrockAgent) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	return out, req.Send()
}

// GetDataSourceWithContext is the same as GetDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetDataSourceWithContext(ctx aws.Context, input *GetDataSourceInput, opts ...request.Option) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFlow = "GetFlow"

// GetFlowRequest generates a "aws/request.Request" representing the
// client's request for the GetFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFlow for more information on using the GetFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFlowRequest method.
//	req, resp := client.GetFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetFlow
func (c *BedrockAgent) GetFlowRequest(input *GetFlowInput) (req *request.Request, output *GetFlowOutput) {
	op := &request.Operation{
		Name:       opGetFlow,
		HTTPMethod: "GET",
		HTTPPath:   "/flows/{flowIdentifier}/",
	}

	if input == nil {
		input = &GetFlowInput{}
	}

	output = &GetFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFlow API operation for Agents for Amazon Bedrock.
//
// Retrieves information about a flow. For more information, see Manage a flow
// in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-manage.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetFlow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetFlow
func (c *BedrockAgent) GetFlow(input *GetFlowInput) (*GetFlowOutput, error) {
	req, out := c.GetFlowRequest(input)
	return out, req.Send()
}

// GetFlowWithContext is the same as GetFlow with the addition of
// the ability to pass a context and additional request options.
//
// See GetFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetFlowWithContext(ctx aws.Context, input *GetFlowInput, opts ...request.Option) (*GetFlowOutput, error) {
	req, out := c.GetFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFlowAlias = "GetFlowAlias"

// GetFlowAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetFlowAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFlowAlias for more information on using the GetFlowAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFlowAliasRequest method.
//	req, resp := client.GetFlowAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetFlowAlias
func (c *BedrockAgent) GetFlowAliasRequest(input *GetFlowAliasInput) (req *request.Request, output *GetFlowAliasOutput) {
	op := &request.Operation{
		Name:       opGetFlowAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/flows/{flowIdentifier}/aliases/{aliasIdentifier}",
	}

	if input == nil {
		input = &GetFlowAliasInput{}
	}

	output = &GetFlowAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFlowAlias API operation for Agents for Amazon Bedrock.
//
// Retrieves information about a flow. For more information, see Deploy a flow
// in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetFlowAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetFlowAlias
func (c *BedrockAgent) GetFlowAlias(input *GetFlowAliasInput) (*GetFlowAliasOutput, error) {
	req, out := c.GetFlowAliasRequest(input)
	return out, req.Send()
}

// GetFlowAliasWithContext is the same as GetFlowAlias with the addition of
// the ability to pass a context and additional request options.
//
// See GetFlowAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetFlowAliasWithContext(ctx aws.Context, input *GetFlowAliasInput, opts ...request.Option) (*GetFlowAliasOutput, error) {
	req, out := c.GetFlowAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFlowVersion = "GetFlowVersion"

// GetFlowVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetFlowVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFlowVersion for more information on using the GetFlowVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFlowVersionRequest method.
//	req, resp := client.GetFlowVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetFlowVersion
func (c *BedrockAgent) GetFlowVersionRequest(input *GetFlowVersionInput) (req *request.Request, output *GetFlowVersionOutput) {
	op := &request.Operation{
		Name:       opGetFlowVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/flows/{flowIdentifier}/versions/{flowVersion}/",
	}

	if input == nil {
		input = &GetFlowVersionInput{}
	}

	output = &GetFlowVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFlowVersion API operation for Agents for Amazon Bedrock.
//
// Retrieves information about a version of a flow. For more information, see
// Deploy a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetFlowVersion for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetFlowVersion
func (c *BedrockAgent) GetFlowVersion(input *GetFlowVersionInput) (*GetFlowVersionOutput, error) {
	req, out := c.GetFlowVersionRequest(input)
	return out, req.Send()
}

// GetFlowVersionWithContext is the same as GetFlowVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetFlowVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetFlowVersionWithContext(ctx aws.Context, input *GetFlowVersionInput, opts ...request.Option) (*GetFlowVersionOutput, error) {
	req, out := c.GetFlowVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIngestionJob = "GetIngestionJob"

// GetIngestionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetIngestionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIngestionJob for more information on using the GetIngestionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetIngestionJobRequest method.
//	req, resp := client.GetIngestionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetIngestionJob
func (c *BedrockAgent) GetIngestionJobRequest(input *GetIngestionJobInput) (req *request.Request, output *GetIngestionJobOutput) {
	op := &request.Operation{
		Name:       opGetIngestionJob,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/{ingestionJobId}",
	}

	if input == nil {
		input = &GetIngestionJobInput{}
	}

	output = &GetIngestionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIngestionJob API operation for Agents for Amazon Bedrock.
//
// Gets information about a ingestion job, in which a data source is added to
// a knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetIngestionJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetIngestionJob
func (c *BedrockAgent) GetIngestionJob(input *GetIngestionJobInput) (*GetIngestionJobOutput, error) {
	req, out := c.GetIngestionJobRequest(input)
	return out, req.Send()
}

// GetIngestionJobWithContext is the same as GetIngestionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetIngestionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetIngestionJobWithContext(ctx aws.Context, input *GetIngestionJobInput, opts ...request.Option) (*GetIngestionJobOutput, error) {
	req, out := c.GetIngestionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetKnowledgeBase = "GetKnowledgeBase"

// GetKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the GetKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetKnowledgeBase for more information on using the GetKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetKnowledgeBaseRequest method.
//	req, resp := client.GetKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetKnowledgeBase
func (c *BedrockAgent) GetKnowledgeBaseRequest(input *GetKnowledgeBaseInput) (req *request.Request, output *GetKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opGetKnowledgeBase,
		HTTPMethod: "GET",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &GetKnowledgeBaseInput{}
	}

	output = &GetKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Gets information about a knoweldge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetKnowledgeBase
func (c *BedrockAgent) GetKnowledgeBase(input *GetKnowledgeBaseInput) (*GetKnowledgeBaseOutput, error) {
	req, out := c.GetKnowledgeBaseRequest(input)
	return out, req.Send()
}

// GetKnowledgeBaseWithContext is the same as GetKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See GetKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetKnowledgeBaseWithContext(ctx aws.Context, input *GetKnowledgeBaseInput, opts ...request.Option) (*GetKnowledgeBaseOutput, error) {
	req, out := c.GetKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPrompt = "GetPrompt"

// GetPromptRequest generates a "aws/request.Request" representing the
// client's request for the GetPrompt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPrompt for more information on using the GetPrompt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPromptRequest method.
//	req, resp := client.GetPromptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetPrompt
func (c *BedrockAgent) GetPromptRequest(input *GetPromptInput) (req *request.Request, output *GetPromptOutput) {
	op := &request.Operation{
		Name:       opGetPrompt,
		HTTPMethod: "GET",
		HTTPPath:   "/prompts/{promptIdentifier}/",
	}

	if input == nil {
		input = &GetPromptInput{}
	}

	output = &GetPromptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPrompt API operation for Agents for Amazon Bedrock.
//
// Retrieves information about a prompt or a version of it. For more information,
// see View information about prompts using Prompt management (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-view.html)
// and View information about a version of your prompt (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-deploy.html#prompt-management-versions-view.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation GetPrompt for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/GetPrompt
func (c *BedrockAgent) GetPrompt(input *GetPromptInput) (*GetPromptOutput, error) {
	req, out := c.GetPromptRequest(input)
	return out, req.Send()
}

// GetPromptWithContext is the same as GetPrompt with the addition of
// the ability to pass a context and additional request options.
//
// See GetPrompt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) GetPromptWithContext(ctx aws.Context, input *GetPromptInput, opts ...request.Option) (*GetPromptOutput, error) {
	req, out := c.GetPromptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAgentActionGroups = "ListAgentActionGroups"

// ListAgentActionGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentActionGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentActionGroups for more information on using the ListAgentActionGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentActionGroupsRequest method.
//	req, resp := client.ListAgentActionGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups
func (c *BedrockAgent) ListAgentActionGroupsRequest(input *ListAgentActionGroupsInput) (req *request.Request, output *ListAgentActionGroupsOutput) {
	op := &request.Operation{
		Name:       opListAgentActionGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentActionGroupsInput{}
	}

	output = &ListAgentActionGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentActionGroups API operation for Agents for Amazon Bedrock.
//
// Lists the action groups for an agent and information about each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentActionGroups for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentActionGroups
func (c *BedrockAgent) ListAgentActionGroups(input *ListAgentActionGroupsInput) (*ListAgentActionGroupsOutput, error) {
	req, out := c.ListAgentActionGroupsRequest(input)
	return out, req.Send()
}

// ListAgentActionGroupsWithContext is the same as ListAgentActionGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentActionGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentActionGroupsWithContext(ctx aws.Context, input *ListAgentActionGroupsInput, opts ...request.Option) (*ListAgentActionGroupsOutput, error) {
	req, out := c.ListAgentActionGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentActionGroupsPages iterates over the pages of a ListAgentActionGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentActionGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentActionGroups operation.
//	pageNum := 0
//	err := client.ListAgentActionGroupsPages(params,
//	    func(page *bedrockagent.ListAgentActionGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentActionGroupsPages(input *ListAgentActionGroupsInput, fn func(*ListAgentActionGroupsOutput, bool) bool) error {
	return c.ListAgentActionGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentActionGroupsPagesWithContext same as ListAgentActionGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentActionGroupsPagesWithContext(ctx aws.Context, input *ListAgentActionGroupsInput, fn func(*ListAgentActionGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentActionGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentActionGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentActionGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgentAliases = "ListAgentAliases"

// ListAgentAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentAliases for more information on using the ListAgentAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentAliasesRequest method.
//	req, resp := client.ListAgentAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases
func (c *BedrockAgent) ListAgentAliasesRequest(input *ListAgentAliasesInput) (req *request.Request, output *ListAgentAliasesOutput) {
	op := &request.Operation{
		Name:       opListAgentAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentaliases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentAliasesInput{}
	}

	output = &ListAgentAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentAliases API operation for Agents for Amazon Bedrock.
//
// Lists the aliases of an agent and information about each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentAliases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentAliases
func (c *BedrockAgent) ListAgentAliases(input *ListAgentAliasesInput) (*ListAgentAliasesOutput, error) {
	req, out := c.ListAgentAliasesRequest(input)
	return out, req.Send()
}

// ListAgentAliasesWithContext is the same as ListAgentAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentAliasesWithContext(ctx aws.Context, input *ListAgentAliasesInput, opts ...request.Option) (*ListAgentAliasesOutput, error) {
	req, out := c.ListAgentAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentAliasesPages iterates over the pages of a ListAgentAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentAliases operation.
//	pageNum := 0
//	err := client.ListAgentAliasesPages(params,
//	    func(page *bedrockagent.ListAgentAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentAliasesPages(input *ListAgentAliasesInput, fn func(*ListAgentAliasesOutput, bool) bool) error {
	return c.ListAgentAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentAliasesPagesWithContext same as ListAgentAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentAliasesPagesWithContext(ctx aws.Context, input *ListAgentAliasesInput, fn func(*ListAgentAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgentKnowledgeBases = "ListAgentKnowledgeBases"

// ListAgentKnowledgeBasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentKnowledgeBases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentKnowledgeBases for more information on using the ListAgentKnowledgeBases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentKnowledgeBasesRequest method.
//	req, resp := client.ListAgentKnowledgeBasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases
func (c *BedrockAgent) ListAgentKnowledgeBasesRequest(input *ListAgentKnowledgeBasesInput) (req *request.Request, output *ListAgentKnowledgeBasesOutput) {
	op := &request.Operation{
		Name:       opListAgentKnowledgeBases,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentKnowledgeBasesInput{}
	}

	output = &ListAgentKnowledgeBasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentKnowledgeBases API operation for Agents for Amazon Bedrock.
//
// Lists knowledge bases associated with an agent and information about each
// one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentKnowledgeBases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentKnowledgeBases
func (c *BedrockAgent) ListAgentKnowledgeBases(input *ListAgentKnowledgeBasesInput) (*ListAgentKnowledgeBasesOutput, error) {
	req, out := c.ListAgentKnowledgeBasesRequest(input)
	return out, req.Send()
}

// ListAgentKnowledgeBasesWithContext is the same as ListAgentKnowledgeBases with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentKnowledgeBases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentKnowledgeBasesWithContext(ctx aws.Context, input *ListAgentKnowledgeBasesInput, opts ...request.Option) (*ListAgentKnowledgeBasesOutput, error) {
	req, out := c.ListAgentKnowledgeBasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentKnowledgeBasesPages iterates over the pages of a ListAgentKnowledgeBases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentKnowledgeBases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentKnowledgeBases operation.
//	pageNum := 0
//	err := client.ListAgentKnowledgeBasesPages(params,
//	    func(page *bedrockagent.ListAgentKnowledgeBasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentKnowledgeBasesPages(input *ListAgentKnowledgeBasesInput, fn func(*ListAgentKnowledgeBasesOutput, bool) bool) error {
	return c.ListAgentKnowledgeBasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentKnowledgeBasesPagesWithContext same as ListAgentKnowledgeBasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentKnowledgeBasesPagesWithContext(ctx aws.Context, input *ListAgentKnowledgeBasesInput, fn func(*ListAgentKnowledgeBasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentKnowledgeBasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentKnowledgeBasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentKnowledgeBasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgentVersions = "ListAgentVersions"

// ListAgentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentVersions for more information on using the ListAgentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentVersionsRequest method.
//	req, resp := client.ListAgentVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions
func (c *BedrockAgent) ListAgentVersionsRequest(input *ListAgentVersionsInput) (req *request.Request, output *ListAgentVersionsOutput) {
	op := &request.Operation{
		Name:       opListAgentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/agentversions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentVersionsInput{}
	}

	output = &ListAgentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentVersions API operation for Agents for Amazon Bedrock.
//
// Lists the versions of an agent and information about each version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgentVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgentVersions
func (c *BedrockAgent) ListAgentVersions(input *ListAgentVersionsInput) (*ListAgentVersionsOutput, error) {
	req, out := c.ListAgentVersionsRequest(input)
	return out, req.Send()
}

// ListAgentVersionsWithContext is the same as ListAgentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentVersionsWithContext(ctx aws.Context, input *ListAgentVersionsInput, opts ...request.Option) (*ListAgentVersionsOutput, error) {
	req, out := c.ListAgentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentVersionsPages iterates over the pages of a ListAgentVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentVersions operation.
//	pageNum := 0
//	err := client.ListAgentVersionsPages(params,
//	    func(page *bedrockagent.ListAgentVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentVersionsPages(input *ListAgentVersionsInput, fn func(*ListAgentVersionsOutput, bool) bool) error {
	return c.ListAgentVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentVersionsPagesWithContext same as ListAgentVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentVersionsPagesWithContext(ctx aws.Context, input *ListAgentVersionsInput, fn func(*ListAgentVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAgents = "ListAgents"

// ListAgentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAgents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgents for more information on using the ListAgents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentsRequest method.
//	req, resp := client.ListAgentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents
func (c *BedrockAgent) ListAgentsRequest(input *ListAgentsInput) (req *request.Request, output *ListAgentsOutput) {
	op := &request.Operation{
		Name:       opListAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentsInput{}
	}

	output = &ListAgentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgents API operation for Agents for Amazon Bedrock.
//
// Lists the agents belonging to an account and information about each agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListAgents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListAgents
func (c *BedrockAgent) ListAgents(input *ListAgentsInput) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	return out, req.Send()
}

// ListAgentsWithContext is the same as ListAgents with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentsWithContext(ctx aws.Context, input *ListAgentsInput, opts ...request.Option) (*ListAgentsOutput, error) {
	req, out := c.ListAgentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentsPages iterates over the pages of a ListAgents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgents operation.
//	pageNum := 0
//	err := client.ListAgentsPages(params,
//	    func(page *bedrockagent.ListAgentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListAgentsPages(input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool) error {
	return c.ListAgentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentsPagesWithContext same as ListAgentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListAgentsPagesWithContext(ctx aws.Context, input *ListAgentsInput, fn func(*ListAgentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataSources = "ListDataSources"

// ListDataSourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListDataSources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataSources for more information on using the ListDataSources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDataSourcesRequest method.
//	req, resp := client.ListDataSourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources
func (c *BedrockAgent) ListDataSourcesRequest(input *ListDataSourcesInput) (req *request.Request, output *ListDataSourcesOutput) {
	op := &request.Operation{
		Name:       opListDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataSourcesInput{}
	}

	output = &ListDataSourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataSources API operation for Agents for Amazon Bedrock.
//
// Lists the data sources in a knowledge base and information about each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListDataSources for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListDataSources
func (c *BedrockAgent) ListDataSources(input *ListDataSourcesInput) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	return out, req.Send()
}

// ListDataSourcesWithContext is the same as ListDataSources with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataSources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListDataSourcesWithContext(ctx aws.Context, input *ListDataSourcesInput, opts ...request.Option) (*ListDataSourcesOutput, error) {
	req, out := c.ListDataSourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataSourcesPages iterates over the pages of a ListDataSources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataSources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDataSources operation.
//	pageNum := 0
//	err := client.ListDataSourcesPages(params,
//	    func(page *bedrockagent.ListDataSourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListDataSourcesPages(input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool) error {
	return c.ListDataSourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataSourcesPagesWithContext same as ListDataSourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListDataSourcesPagesWithContext(ctx aws.Context, input *ListDataSourcesInput, fn func(*ListDataSourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataSourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataSourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataSourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlowAliases = "ListFlowAliases"

// ListFlowAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListFlowAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlowAliases for more information on using the ListFlowAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFlowAliasesRequest method.
//	req, resp := client.ListFlowAliasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListFlowAliases
func (c *BedrockAgent) ListFlowAliasesRequest(input *ListFlowAliasesInput) (req *request.Request, output *ListFlowAliasesOutput) {
	op := &request.Operation{
		Name:       opListFlowAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/flows/{flowIdentifier}/aliases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowAliasesInput{}
	}

	output = &ListFlowAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlowAliases API operation for Agents for Amazon Bedrock.
//
// Returns a list of aliases for a flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListFlowAliases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListFlowAliases
func (c *BedrockAgent) ListFlowAliases(input *ListFlowAliasesInput) (*ListFlowAliasesOutput, error) {
	req, out := c.ListFlowAliasesRequest(input)
	return out, req.Send()
}

// ListFlowAliasesWithContext is the same as ListFlowAliases with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlowAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListFlowAliasesWithContext(ctx aws.Context, input *ListFlowAliasesInput, opts ...request.Option) (*ListFlowAliasesOutput, error) {
	req, out := c.ListFlowAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowAliasesPages iterates over the pages of a ListFlowAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlowAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFlowAliases operation.
//	pageNum := 0
//	err := client.ListFlowAliasesPages(params,
//	    func(page *bedrockagent.ListFlowAliasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListFlowAliasesPages(input *ListFlowAliasesInput, fn func(*ListFlowAliasesOutput, bool) bool) error {
	return c.ListFlowAliasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowAliasesPagesWithContext same as ListFlowAliasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListFlowAliasesPagesWithContext(ctx aws.Context, input *ListFlowAliasesInput, fn func(*ListFlowAliasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowAliasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowAliasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowAliasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlowVersions = "ListFlowVersions"

// ListFlowVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlowVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlowVersions for more information on using the ListFlowVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFlowVersionsRequest method.
//	req, resp := client.ListFlowVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListFlowVersions
func (c *BedrockAgent) ListFlowVersionsRequest(input *ListFlowVersionsInput) (req *request.Request, output *ListFlowVersionsOutput) {
	op := &request.Operation{
		Name:       opListFlowVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/flows/{flowIdentifier}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowVersionsInput{}
	}

	output = &ListFlowVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlowVersions API operation for Agents for Amazon Bedrock.
//
// Returns a list of information about each flow. For more information, see
// Deploy a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListFlowVersions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListFlowVersions
func (c *BedrockAgent) ListFlowVersions(input *ListFlowVersionsInput) (*ListFlowVersionsOutput, error) {
	req, out := c.ListFlowVersionsRequest(input)
	return out, req.Send()
}

// ListFlowVersionsWithContext is the same as ListFlowVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlowVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListFlowVersionsWithContext(ctx aws.Context, input *ListFlowVersionsInput, opts ...request.Option) (*ListFlowVersionsOutput, error) {
	req, out := c.ListFlowVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowVersionsPages iterates over the pages of a ListFlowVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlowVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFlowVersions operation.
//	pageNum := 0
//	err := client.ListFlowVersionsPages(params,
//	    func(page *bedrockagent.ListFlowVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListFlowVersionsPages(input *ListFlowVersionsInput, fn func(*ListFlowVersionsOutput, bool) bool) error {
	return c.ListFlowVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowVersionsPagesWithContext same as ListFlowVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListFlowVersionsPagesWithContext(ctx aws.Context, input *ListFlowVersionsInput, fn func(*ListFlowVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFlows = "ListFlows"

// ListFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFlows for more information on using the ListFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFlowsRequest method.
//	req, resp := client.ListFlowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListFlows
func (c *BedrockAgent) ListFlowsRequest(input *ListFlowsInput) (req *request.Request, output *ListFlowsOutput) {
	op := &request.Operation{
		Name:       opListFlows,
		HTTPMethod: "GET",
		HTTPPath:   "/flows/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFlowsInput{}
	}

	output = &ListFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFlows API operation for Agents for Amazon Bedrock.
//
// Returns a list of flows and information about each flow. For more information,
// see Manage a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-manage.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListFlows for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListFlows
func (c *BedrockAgent) ListFlows(input *ListFlowsInput) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	return out, req.Send()
}

// ListFlowsWithContext is the same as ListFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListFlowsWithContext(ctx aws.Context, input *ListFlowsInput, opts ...request.Option) (*ListFlowsOutput, error) {
	req, out := c.ListFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFlowsPages iterates over the pages of a ListFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFlows operation.
//	pageNum := 0
//	err := client.ListFlowsPages(params,
//	    func(page *bedrockagent.ListFlowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListFlowsPages(input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool) error {
	return c.ListFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFlowsPagesWithContext same as ListFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListFlowsPagesWithContext(ctx aws.Context, input *ListFlowsInput, fn func(*ListFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFlowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIngestionJobs = "ListIngestionJobs"

// ListIngestionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListIngestionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIngestionJobs for more information on using the ListIngestionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIngestionJobsRequest method.
//	req, resp := client.ListIngestionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs
func (c *BedrockAgent) ListIngestionJobsRequest(input *ListIngestionJobsInput) (req *request.Request, output *ListIngestionJobsOutput) {
	op := &request.Operation{
		Name:       opListIngestionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIngestionJobsInput{}
	}

	output = &ListIngestionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIngestionJobs API operation for Agents for Amazon Bedrock.
//
// Lists the ingestion jobs for a data source and information about each of
// them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListIngestionJobs for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListIngestionJobs
func (c *BedrockAgent) ListIngestionJobs(input *ListIngestionJobsInput) (*ListIngestionJobsOutput, error) {
	req, out := c.ListIngestionJobsRequest(input)
	return out, req.Send()
}

// ListIngestionJobsWithContext is the same as ListIngestionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListIngestionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListIngestionJobsWithContext(ctx aws.Context, input *ListIngestionJobsInput, opts ...request.Option) (*ListIngestionJobsOutput, error) {
	req, out := c.ListIngestionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIngestionJobsPages iterates over the pages of a ListIngestionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIngestionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIngestionJobs operation.
//	pageNum := 0
//	err := client.ListIngestionJobsPages(params,
//	    func(page *bedrockagent.ListIngestionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListIngestionJobsPages(input *ListIngestionJobsInput, fn func(*ListIngestionJobsOutput, bool) bool) error {
	return c.ListIngestionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIngestionJobsPagesWithContext same as ListIngestionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListIngestionJobsPagesWithContext(ctx aws.Context, input *ListIngestionJobsInput, fn func(*ListIngestionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIngestionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIngestionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIngestionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKnowledgeBases = "ListKnowledgeBases"

// ListKnowledgeBasesRequest generates a "aws/request.Request" representing the
// client's request for the ListKnowledgeBases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKnowledgeBases for more information on using the ListKnowledgeBases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListKnowledgeBasesRequest method.
//	req, resp := client.ListKnowledgeBasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases
func (c *BedrockAgent) ListKnowledgeBasesRequest(input *ListKnowledgeBasesInput) (req *request.Request, output *ListKnowledgeBasesOutput) {
	op := &request.Operation{
		Name:       opListKnowledgeBases,
		HTTPMethod: "POST",
		HTTPPath:   "/knowledgebases/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKnowledgeBasesInput{}
	}

	output = &ListKnowledgeBasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKnowledgeBases API operation for Agents for Amazon Bedrock.
//
// Lists the knowledge bases in an account and information about each of them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListKnowledgeBases for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListKnowledgeBases
func (c *BedrockAgent) ListKnowledgeBases(input *ListKnowledgeBasesInput) (*ListKnowledgeBasesOutput, error) {
	req, out := c.ListKnowledgeBasesRequest(input)
	return out, req.Send()
}

// ListKnowledgeBasesWithContext is the same as ListKnowledgeBases with the addition of
// the ability to pass a context and additional request options.
//
// See ListKnowledgeBases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListKnowledgeBasesWithContext(ctx aws.Context, input *ListKnowledgeBasesInput, opts ...request.Option) (*ListKnowledgeBasesOutput, error) {
	req, out := c.ListKnowledgeBasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKnowledgeBasesPages iterates over the pages of a ListKnowledgeBases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKnowledgeBases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListKnowledgeBases operation.
//	pageNum := 0
//	err := client.ListKnowledgeBasesPages(params,
//	    func(page *bedrockagent.ListKnowledgeBasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListKnowledgeBasesPages(input *ListKnowledgeBasesInput, fn func(*ListKnowledgeBasesOutput, bool) bool) error {
	return c.ListKnowledgeBasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKnowledgeBasesPagesWithContext same as ListKnowledgeBasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListKnowledgeBasesPagesWithContext(ctx aws.Context, input *ListKnowledgeBasesInput, fn func(*ListKnowledgeBasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKnowledgeBasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKnowledgeBasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKnowledgeBasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPrompts = "ListPrompts"

// ListPromptsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrompts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrompts for more information on using the ListPrompts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPromptsRequest method.
//	req, resp := client.ListPromptsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListPrompts
func (c *BedrockAgent) ListPromptsRequest(input *ListPromptsInput) (req *request.Request, output *ListPromptsOutput) {
	op := &request.Operation{
		Name:       opListPrompts,
		HTTPMethod: "GET",
		HTTPPath:   "/prompts/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPromptsInput{}
	}

	output = &ListPromptsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrompts API operation for Agents for Amazon Bedrock.
//
// Returns a list of prompts from the Prompt management tool and information
// about each prompt. For more information, see View information about prompts
// using Prompt management (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-view.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListPrompts for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListPrompts
func (c *BedrockAgent) ListPrompts(input *ListPromptsInput) (*ListPromptsOutput, error) {
	req, out := c.ListPromptsRequest(input)
	return out, req.Send()
}

// ListPromptsWithContext is the same as ListPrompts with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrompts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListPromptsWithContext(ctx aws.Context, input *ListPromptsInput, opts ...request.Option) (*ListPromptsOutput, error) {
	req, out := c.ListPromptsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPromptsPages iterates over the pages of a ListPrompts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPrompts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPrompts operation.
//	pageNum := 0
//	err := client.ListPromptsPages(params,
//	    func(page *bedrockagent.ListPromptsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *BedrockAgent) ListPromptsPages(input *ListPromptsInput, fn func(*ListPromptsOutput, bool) bool) error {
	return c.ListPromptsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPromptsPagesWithContext same as ListPromptsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListPromptsPagesWithContext(ctx aws.Context, input *ListPromptsInput, fn func(*ListPromptsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPromptsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPromptsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPromptsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListTagsForResource
func (c *BedrockAgent) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Agents for Amazon Bedrock.
//
// List all the tags for the resource you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/ListTagsForResource
func (c *BedrockAgent) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPrepareAgent = "PrepareAgent"

// PrepareAgentRequest generates a "aws/request.Request" representing the
// client's request for the PrepareAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PrepareAgent for more information on using the PrepareAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PrepareAgentRequest method.
//	req, resp := client.PrepareAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareAgent
func (c *BedrockAgent) PrepareAgentRequest(input *PrepareAgentInput) (req *request.Request, output *PrepareAgentOutput) {
	op := &request.Operation{
		Name:       opPrepareAgent,
		HTTPMethod: "POST",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &PrepareAgentInput{}
	}

	output = &PrepareAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PrepareAgent API operation for Agents for Amazon Bedrock.
//
// Creates a DRAFT version of the agent that can be used for internal testing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation PrepareAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareAgent
func (c *BedrockAgent) PrepareAgent(input *PrepareAgentInput) (*PrepareAgentOutput, error) {
	req, out := c.PrepareAgentRequest(input)
	return out, req.Send()
}

// PrepareAgentWithContext is the same as PrepareAgent with the addition of
// the ability to pass a context and additional request options.
//
// See PrepareAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) PrepareAgentWithContext(ctx aws.Context, input *PrepareAgentInput, opts ...request.Option) (*PrepareAgentOutput, error) {
	req, out := c.PrepareAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPrepareFlow = "PrepareFlow"

// PrepareFlowRequest generates a "aws/request.Request" representing the
// client's request for the PrepareFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PrepareFlow for more information on using the PrepareFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PrepareFlowRequest method.
//	req, resp := client.PrepareFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareFlow
func (c *BedrockAgent) PrepareFlowRequest(input *PrepareFlowInput) (req *request.Request, output *PrepareFlowOutput) {
	op := &request.Operation{
		Name:       opPrepareFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/flows/{flowIdentifier}/",
	}

	if input == nil {
		input = &PrepareFlowInput{}
	}

	output = &PrepareFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PrepareFlow API operation for Agents for Amazon Bedrock.
//
// Prepares the DRAFT version of a flow so that it can be invoked. For more
// information, see Test a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation PrepareFlow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/PrepareFlow
func (c *BedrockAgent) PrepareFlow(input *PrepareFlowInput) (*PrepareFlowOutput, error) {
	req, out := c.PrepareFlowRequest(input)
	return out, req.Send()
}

// PrepareFlowWithContext is the same as PrepareFlow with the addition of
// the ability to pass a context and additional request options.
//
// See PrepareFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) PrepareFlowWithContext(ctx aws.Context, input *PrepareFlowInput, opts ...request.Option) (*PrepareFlowOutput, error) {
	req, out := c.PrepareFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartIngestionJob = "StartIngestionJob"

// StartIngestionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartIngestionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartIngestionJob for more information on using the StartIngestionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartIngestionJobRequest method.
//	req, resp := client.StartIngestionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/StartIngestionJob
func (c *BedrockAgent) StartIngestionJobRequest(input *StartIngestionJobInput) (req *request.Request, output *StartIngestionJobOutput) {
	op := &request.Operation{
		Name:       opStartIngestionJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}/ingestionjobs/",
	}

	if input == nil {
		input = &StartIngestionJobInput{}
	}

	output = &StartIngestionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartIngestionJob API operation for Agents for Amazon Bedrock.
//
// Begins an ingestion job, in which a data source is added to a knowledge base.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation StartIngestionJob for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/StartIngestionJob
func (c *BedrockAgent) StartIngestionJob(input *StartIngestionJobInput) (*StartIngestionJobOutput, error) {
	req, out := c.StartIngestionJobRequest(input)
	return out, req.Send()
}

// StartIngestionJobWithContext is the same as StartIngestionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartIngestionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) StartIngestionJobWithContext(ctx aws.Context, input *StartIngestionJobInput, opts ...request.Option) (*StartIngestionJobOutput, error) {
	req, out := c.StartIngestionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/TagResource
func (c *BedrockAgent) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Agents for Amazon Bedrock.
//
// Associate tags with a resource. For more information, see Tagging resources
// (https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/TagResource
func (c *BedrockAgent) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UntagResource
func (c *BedrockAgent) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Agents for Amazon Bedrock.
//
// Remove tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UntagResource
func (c *BedrockAgent) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgent = "UpdateAgent"

// UpdateAgentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgent for more information on using the UpdateAgent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentRequest method.
//	req, resp := client.UpdateAgentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgent
func (c *BedrockAgent) UpdateAgentRequest(input *UpdateAgentInput) (req *request.Request, output *UpdateAgentOutput) {
	op := &request.Operation{
		Name:       opUpdateAgent,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/",
	}

	if input == nil {
		input = &UpdateAgentInput{}
	}

	output = &UpdateAgentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgent API operation for Agents for Amazon Bedrock.
//
// Updates the configuration of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgent for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgent
func (c *BedrockAgent) UpdateAgent(input *UpdateAgentInput) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	return out, req.Send()
}

// UpdateAgentWithContext is the same as UpdateAgent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentWithContext(ctx aws.Context, input *UpdateAgentInput, opts ...request.Option) (*UpdateAgentOutput, error) {
	req, out := c.UpdateAgentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgentActionGroup = "UpdateAgentActionGroup"

// UpdateAgentActionGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgentActionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgentActionGroup for more information on using the UpdateAgentActionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentActionGroupRequest method.
//	req, resp := client.UpdateAgentActionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentActionGroup
func (c *BedrockAgent) UpdateAgentActionGroupRequest(input *UpdateAgentActionGroupInput) (req *request.Request, output *UpdateAgentActionGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateAgentActionGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/actiongroups/{actionGroupId}/",
	}

	if input == nil {
		input = &UpdateAgentActionGroupInput{}
	}

	output = &UpdateAgentActionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgentActionGroup API operation for Agents for Amazon Bedrock.
//
// Updates the configuration for an action group for an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgentActionGroup for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentActionGroup
func (c *BedrockAgent) UpdateAgentActionGroup(input *UpdateAgentActionGroupInput) (*UpdateAgentActionGroupOutput, error) {
	req, out := c.UpdateAgentActionGroupRequest(input)
	return out, req.Send()
}

// UpdateAgentActionGroupWithContext is the same as UpdateAgentActionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgentActionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentActionGroupWithContext(ctx aws.Context, input *UpdateAgentActionGroupInput, opts ...request.Option) (*UpdateAgentActionGroupOutput, error) {
	req, out := c.UpdateAgentActionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgentAlias = "UpdateAgentAlias"

// UpdateAgentAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgentAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgentAlias for more information on using the UpdateAgentAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentAliasRequest method.
//	req, resp := client.UpdateAgentAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentAlias
func (c *BedrockAgent) UpdateAgentAliasRequest(input *UpdateAgentAliasInput) (req *request.Request, output *UpdateAgentAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAgentAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentaliases/{agentAliasId}/",
	}

	if input == nil {
		input = &UpdateAgentAliasInput{}
	}

	output = &UpdateAgentAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgentAlias API operation for Agents for Amazon Bedrock.
//
// Updates configurations for an alias of an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgentAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentAlias
func (c *BedrockAgent) UpdateAgentAlias(input *UpdateAgentAliasInput) (*UpdateAgentAliasOutput, error) {
	req, out := c.UpdateAgentAliasRequest(input)
	return out, req.Send()
}

// UpdateAgentAliasWithContext is the same as UpdateAgentAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgentAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentAliasWithContext(ctx aws.Context, input *UpdateAgentAliasInput, opts ...request.Option) (*UpdateAgentAliasOutput, error) {
	req, out := c.UpdateAgentAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgentKnowledgeBase = "UpdateAgentKnowledgeBase"

// UpdateAgentKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgentKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgentKnowledgeBase for more information on using the UpdateAgentKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentKnowledgeBaseRequest method.
//	req, resp := client.UpdateAgentKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentKnowledgeBase
func (c *BedrockAgent) UpdateAgentKnowledgeBaseRequest(input *UpdateAgentKnowledgeBaseInput) (req *request.Request, output *UpdateAgentKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opUpdateAgentKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/agents/{agentId}/agentversions/{agentVersion}/knowledgebases/{knowledgeBaseId}/",
	}

	if input == nil {
		input = &UpdateAgentKnowledgeBaseInput{}
	}

	output = &UpdateAgentKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAgentKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Updates the configuration for a knowledge base that has been associated with
// an agent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateAgentKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateAgentKnowledgeBase
func (c *BedrockAgent) UpdateAgentKnowledgeBase(input *UpdateAgentKnowledgeBaseInput) (*UpdateAgentKnowledgeBaseOutput, error) {
	req, out := c.UpdateAgentKnowledgeBaseRequest(input)
	return out, req.Send()
}

// UpdateAgentKnowledgeBaseWithContext is the same as UpdateAgentKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgentKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateAgentKnowledgeBaseWithContext(ctx aws.Context, input *UpdateAgentKnowledgeBaseInput, opts ...request.Option) (*UpdateAgentKnowledgeBaseOutput, error) {
	req, out := c.UpdateAgentKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataSource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataSource for more information on using the UpdateDataSource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDataSourceRequest method.
//	req, resp := client.UpdateDataSourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateDataSource
func (c *BedrockAgent) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *request.Request, output *UpdateDataSourceOutput) {
	op := &request.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}/datasources/{dataSourceId}",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	output = &UpdateDataSourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDataSource API operation for Agents for Amazon Bedrock.
//
// Updates the configurations for a data source connector.
//
// You can't change the chunkingConfiguration after you create the data source
// connector. Specify the existing chunkingConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateDataSource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateDataSource
func (c *BedrockAgent) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	return out, req.Send()
}

// UpdateDataSourceWithContext is the same as UpdateDataSource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataSource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateDataSourceWithContext(ctx aws.Context, input *UpdateDataSourceInput, opts ...request.Option) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlow = "UpdateFlow"

// UpdateFlowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlow for more information on using the UpdateFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlowRequest method.
//	req, resp := client.UpdateFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateFlow
func (c *BedrockAgent) UpdateFlowRequest(input *UpdateFlowInput) (req *request.Request, output *UpdateFlowOutput) {
	op := &request.Operation{
		Name:       opUpdateFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/flows/{flowIdentifier}/",
	}

	if input == nil {
		input = &UpdateFlowInput{}
	}

	output = &UpdateFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlow API operation for Agents for Amazon Bedrock.
//
// Modifies a flow. Include both fields that you want to keep and fields that
// you want to change. For more information, see How it works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html)
// and Create a flow in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateFlow for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateFlow
func (c *BedrockAgent) UpdateFlow(input *UpdateFlowInput) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	return out, req.Send()
}

// UpdateFlowWithContext is the same as UpdateFlow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateFlowWithContext(ctx aws.Context, input *UpdateFlowInput, opts ...request.Option) (*UpdateFlowOutput, error) {
	req, out := c.UpdateFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFlowAlias = "UpdateFlowAlias"

// UpdateFlowAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFlowAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFlowAlias for more information on using the UpdateFlowAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFlowAliasRequest method.
//	req, resp := client.UpdateFlowAliasRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateFlowAlias
func (c *BedrockAgent) UpdateFlowAliasRequest(input *UpdateFlowAliasInput) (req *request.Request, output *UpdateFlowAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateFlowAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/flows/{flowIdentifier}/aliases/{aliasIdentifier}",
	}

	if input == nil {
		input = &UpdateFlowAliasInput{}
	}

	output = &UpdateFlowAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFlowAlias API operation for Agents for Amazon Bedrock.
//
// Modifies the alias of a flow. Include both fields that you want to keep and
// ones that you want to change. For more information, see Deploy a flow in
// Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateFlowAlias for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateFlowAlias
func (c *BedrockAgent) UpdateFlowAlias(input *UpdateFlowAliasInput) (*UpdateFlowAliasOutput, error) {
	req, out := c.UpdateFlowAliasRequest(input)
	return out, req.Send()
}

// UpdateFlowAliasWithContext is the same as UpdateFlowAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFlowAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateFlowAliasWithContext(ctx aws.Context, input *UpdateFlowAliasInput, opts ...request.Option) (*UpdateFlowAliasOutput, error) {
	req, out := c.UpdateFlowAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateKnowledgeBase = "UpdateKnowledgeBase"

// UpdateKnowledgeBaseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKnowledgeBase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateKnowledgeBase for more information on using the UpdateKnowledgeBase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateKnowledgeBaseRequest method.
//	req, resp := client.UpdateKnowledgeBaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateKnowledgeBase
func (c *BedrockAgent) UpdateKnowledgeBaseRequest(input *UpdateKnowledgeBaseInput) (req *request.Request, output *UpdateKnowledgeBaseOutput) {
	op := &request.Operation{
		Name:       opUpdateKnowledgeBase,
		HTTPMethod: "PUT",
		HTTPPath:   "/knowledgebases/{knowledgeBaseId}",
	}

	if input == nil {
		input = &UpdateKnowledgeBaseInput{}
	}

	output = &UpdateKnowledgeBaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateKnowledgeBase API operation for Agents for Amazon Bedrock.
//
// Updates the configuration of a knowledge base with the fields that you specify.
// Because all fields will be overwritten, you must include the same values
// for fields that you want to keep the same.
//
// You can change the following fields:
//
//   - name
//
//   - description
//
//   - roleArn
//
// You can't change the knowledgeBaseConfiguration or storageConfiguration fields,
// so you must specify the same configurations as when you created the knowledge
// base. You can send a GetKnowledgeBase (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetKnowledgeBase.html)
// request and copy the same configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdateKnowledgeBase for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdateKnowledgeBase
func (c *BedrockAgent) UpdateKnowledgeBase(input *UpdateKnowledgeBaseInput) (*UpdateKnowledgeBaseOutput, error) {
	req, out := c.UpdateKnowledgeBaseRequest(input)
	return out, req.Send()
}

// UpdateKnowledgeBaseWithContext is the same as UpdateKnowledgeBase with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateKnowledgeBase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdateKnowledgeBaseWithContext(ctx aws.Context, input *UpdateKnowledgeBaseInput, opts ...request.Option) (*UpdateKnowledgeBaseOutput, error) {
	req, out := c.UpdateKnowledgeBaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePrompt = "UpdatePrompt"

// UpdatePromptRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePrompt operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePrompt for more information on using the UpdatePrompt
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePromptRequest method.
//	req, resp := client.UpdatePromptRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdatePrompt
func (c *BedrockAgent) UpdatePromptRequest(input *UpdatePromptInput) (req *request.Request, output *UpdatePromptOutput) {
	op := &request.Operation{
		Name:       opUpdatePrompt,
		HTTPMethod: "PUT",
		HTTPPath:   "/prompts/{promptIdentifier}/",
	}

	if input == nil {
		input = &UpdatePromptInput{}
	}

	output = &UpdatePromptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePrompt API operation for Agents for Amazon Bedrock.
//
// Modifies a prompt in your prompt library. Include both fields that you want
// to keep and fields that you want to replace. For more information, see Prompt
// management in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html)
// and Edit prompts in your prompt library (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-manage.html#prompt-management-edit)
// in the Amazon Bedrock User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Agents for Amazon Bedrock's
// API operation UpdatePrompt for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The number of requests exceeds the limit. Resubmit your request later.
//
//   - AccessDeniedException
//     The request is denied because of missing access permissions.
//
//   - ValidationException
//     Input validation failed. Check your request parameters and retry the request.
//
//   - InternalServerException
//     An internal server error occurred. Retry your request.
//
//   - ResourceNotFoundException
//     The specified resource Amazon Resource Name (ARN) was not found. Check the
//     Amazon Resource Name (ARN) and try your request again.
//
//   - ConflictException
//     There was a conflict performing an operation.
//
//   - ServiceQuotaExceededException
//     The number of requests exceeds the service quota. Resubmit your request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-2023-06-05/UpdatePrompt
func (c *BedrockAgent) UpdatePrompt(input *UpdatePromptInput) (*UpdatePromptOutput, error) {
	req, out := c.UpdatePromptRequest(input)
	return out, req.Send()
}

// UpdatePromptWithContext is the same as UpdatePrompt with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePrompt for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BedrockAgent) UpdatePromptWithContext(ctx aws.Context, input *UpdatePromptInput, opts ...request.Option) (*UpdatePromptOutput, error) {
	req, out := c.UpdatePromptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains details about the OpenAPI schema for the action group. For more
// information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
// You can either include the schema directly in the payload field or you can
// upload it to an S3 bucket and specify the S3 bucket location in the s3 field.
type APISchema struct {
	_ struct{} `type:"structure"`

	// The JSON or YAML-formatted payload defining the OpenAPI schema for the action
	// group. For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	//
	// Payload is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by APISchema's
	// String and GoString methods.
	Payload *string `locationName:"payload" type:"string" sensitive:"true"`

	// Contains details about the S3 object containing the OpenAPI schema for the
	// action group. For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	S3 *S3Identifier `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APISchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s APISchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *APISchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "APISchema"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayload sets the Payload field's value.
func (s *APISchema) SetPayload(v string) *APISchema {
	s.Payload = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *APISchema) SetS3(v *S3Identifier) *APISchema {
	s.S3 = v
	return s
}

// The request is denied because of missing access permissions.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains details about the Lambda function containing the business logic
// that is carried out upon invoking the action or the custom control method
// for handling the information elicited from the user.
type ActionGroupExecutor struct {
	_ struct{} `type:"structure"`

	// To return the action group invocation results directly in the InvokeAgent
	// response, specify RETURN_CONTROL.
	CustomControl *string `locationName:"customControl" type:"string" enum:"CustomControlMethod"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action.
	Lambda *string `locationName:"lambda" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupExecutor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupExecutor) GoString() string {
	return s.String()
}

// SetCustomControl sets the CustomControl field's value.
func (s *ActionGroupExecutor) SetCustomControl(v string) *ActionGroupExecutor {
	s.CustomControl = &v
	return s
}

// SetLambda sets the Lambda field's value.
func (s *ActionGroupExecutor) SetLambda(v string) *ActionGroupExecutor {
	s.Lambda = &v
	return s
}

// Contains details about an action group.
type ActionGroupSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the action group.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `locationName:"actionGroupId" type:"string" required:"true"`

	// The name of the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// ActionGroupState is a required field
	ActionGroupState *string `locationName:"actionGroupState" type:"string" required:"true" enum:"ActionGroupState"`

	// The description of the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The time at which the action group was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionGroupSummary) GoString() string {
	return s.String()
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *ActionGroupSummary) SetActionGroupId(v string) *ActionGroupSummary {
	s.ActionGroupId = &v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *ActionGroupSummary) SetActionGroupName(v string) *ActionGroupSummary {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *ActionGroupSummary) SetActionGroupState(v string) *ActionGroupSummary {
	s.ActionGroupState = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ActionGroupSummary) SetDescription(v string) *ActionGroupSummary {
	s.Description = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *ActionGroupSummary) SetUpdatedAt(v time.Time) *ActionGroupSummary {
	s.UpdatedAt = &v
	return s
}

// Contains details about an agent.
type Agent struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent.
	//
	// AgentArn is a required field
	AgentArn *string `locationName:"agentArn" type:"string" required:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The name of the agent.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	//
	// AgentResourceRoleArn is a required field
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string" required:"true"`

	// The status of the agent and whether it is ready for use. The following statuses
	// are possible:
	//
	//    * CREATING – The agent is being created.
	//
	//    * PREPARING – The agent is being prepared.
	//
	//    * PREPARED – The agent is prepared and ready to be invoked.
	//
	//    * NOT_PREPARED – The agent has been created but not yet prepared.
	//
	//    * FAILED – The agent API operation failed.
	//
	//    * UPDATING – The agent is being updated.
	//
	//    * DELETING – The agent is being deleted.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string"`

	// The time at which the agent was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains reasons that the agent-related API that you invoked failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The foundation model used for orchestration by the agent.
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string"`

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	//
	// IdleSessionTTLInSeconds is a required field
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer" required:"true"`

	// Instructions that tell the agent what it should do and how it should interact
	// with users.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Agent's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// Contains memory configuration for the agent.
	MemoryConfiguration *MemoryConfiguration `locationName:"memoryConfiguration" type:"structure"`

	// The time at which the agent was last prepared.
	PreparedAt *time.Time `locationName:"preparedAt" type:"timestamp" timestampFormat:"iso8601"`

	// Contains configurations to override prompt templates in different parts of
	// an agent sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Agent's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`

	// Contains recommended actions to take for the agent-related API that you invoked
	// to succeed.
	RecommendedActions []*string `locationName:"recommendedActions" type:"list"`

	// The time at which the agent was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Agent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Agent) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *Agent) SetAgentArn(v string) *Agent {
	s.AgentArn = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *Agent) SetAgentId(v string) *Agent {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *Agent) SetAgentName(v string) *Agent {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *Agent) SetAgentResourceRoleArn(v string) *Agent {
	s.AgentResourceRoleArn = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *Agent) SetAgentStatus(v string) *Agent {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *Agent) SetAgentVersion(v string) *Agent {
	s.AgentVersion = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *Agent) SetClientToken(v string) *Agent {
	s.ClientToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Agent) SetCreatedAt(v time.Time) *Agent {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *Agent) SetCustomerEncryptionKeyArn(v string) *Agent {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Agent) SetDescription(v string) *Agent {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *Agent) SetFailureReasons(v []*string) *Agent {
	s.FailureReasons = v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *Agent) SetFoundationModel(v string) *Agent {
	s.FoundationModel = &v
	return s
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *Agent) SetGuardrailConfiguration(v *GuardrailConfiguration) *Agent {
	s.GuardrailConfiguration = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *Agent) SetIdleSessionTTLInSeconds(v int64) *Agent {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *Agent) SetInstruction(v string) *Agent {
	s.Instruction = &v
	return s
}

// SetMemoryConfiguration sets the MemoryConfiguration field's value.
func (s *Agent) SetMemoryConfiguration(v *MemoryConfiguration) *Agent {
	s.MemoryConfiguration = v
	return s
}

// SetPreparedAt sets the PreparedAt field's value.
func (s *Agent) SetPreparedAt(v time.Time) *Agent {
	s.PreparedAt = &v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *Agent) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *Agent {
	s.PromptOverrideConfiguration = v
	return s
}

// SetRecommendedActions sets the RecommendedActions field's value.
func (s *Agent) SetRecommendedActions(v []*string) *Agent {
	s.RecommendedActions = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *Agent) SetUpdatedAt(v time.Time) *Agent {
	s.UpdatedAt = &v
	return s
}

// Contains details about an action group.
type AgentActionGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action or the custom control
	// method for handling the information elicited from the user.
	ActionGroupExecutor *ActionGroupExecutor `locationName:"actionGroupExecutor" type:"structure"`

	// The unique identifier of the action group.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `locationName:"actionGroupId" type:"string" required:"true"`

	// The name of the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// ActionGroupState is a required field
	ActionGroupState *string `locationName:"actionGroupState" type:"string" required:"true" enum:"ActionGroupState"`

	// The unique identifier of the agent to which the action group belongs.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The version of the agent to which the action group belongs.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// Contains either details about the S3 object containing the OpenAPI schema
	// for the action group or the JSON or YAML-formatted payload defining the schema.
	// For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	ApiSchema *APISchema `locationName:"apiSchema" type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string"`

	// The time at which the action group was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Defines functions that each define parameters that the agent needs to invoke
	// from the user. Each function represents an action in an action group.
	FunctionSchema *FunctionSchema `locationName:"functionSchema" type:"structure"`

	// If this field is set as AMAZON.UserInput, the agent can request the user
	// for additional information when trying to complete a task. The description,
	// apiSchema, and actionGroupExecutor fields must be blank for this action group.
	//
	// During orchestration, if the agent determines that it needs to invoke an
	// API in an action group, but doesn't have enough information to complete the
	// API request, it will invoke this action group instead and return an Observation
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
	// reprompting the user for more information.
	ParentActionSignature *string `locationName:"parentActionSignature" type:"string" enum:"ActionGroupSignature"`

	// The time at which the action group was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentActionGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentActionGroup) GoString() string {
	return s.String()
}

// SetActionGroupExecutor sets the ActionGroupExecutor field's value.
func (s *AgentActionGroup) SetActionGroupExecutor(v *ActionGroupExecutor) *AgentActionGroup {
	s.ActionGroupExecutor = v
	return s
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *AgentActionGroup) SetActionGroupId(v string) *AgentActionGroup {
	s.ActionGroupId = &v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *AgentActionGroup) SetActionGroupName(v string) *AgentActionGroup {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *AgentActionGroup) SetActionGroupState(v string) *AgentActionGroup {
	s.ActionGroupState = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AgentActionGroup) SetAgentId(v string) *AgentActionGroup {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentActionGroup) SetAgentVersion(v string) *AgentActionGroup {
	s.AgentVersion = &v
	return s
}

// SetApiSchema sets the ApiSchema field's value.
func (s *AgentActionGroup) SetApiSchema(v *APISchema) *AgentActionGroup {
	s.ApiSchema = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AgentActionGroup) SetClientToken(v string) *AgentActionGroup {
	s.ClientToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentActionGroup) SetCreatedAt(v time.Time) *AgentActionGroup {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentActionGroup) SetDescription(v string) *AgentActionGroup {
	s.Description = &v
	return s
}

// SetFunctionSchema sets the FunctionSchema field's value.
func (s *AgentActionGroup) SetFunctionSchema(v *FunctionSchema) *AgentActionGroup {
	s.FunctionSchema = v
	return s
}

// SetParentActionSignature sets the ParentActionSignature field's value.
func (s *AgentActionGroup) SetParentActionSignature(v string) *AgentActionGroup {
	s.ParentActionSignature = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentActionGroup) SetUpdatedAt(v time.Time) *AgentActionGroup {
	s.UpdatedAt = &v
	return s
}

// Contains details about an alias of an agent.
type AgentAlias struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alias of the agent.
	//
	// AgentAliasArn is a required field
	AgentAliasArn *string `locationName:"agentAliasArn" type:"string" required:"true"`

	// Contains details about the history of the alias.
	AgentAliasHistoryEvents []*AgentAliasHistoryEvent `locationName:"agentAliasHistoryEvents" type:"list"`

	// The unique identifier of the alias of the agent.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The name of the alias of the agent.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The status of the alias of the agent and whether it is ready for use. The
	// following statuses are possible:
	//
	//    * CREATING – The agent alias is being created.
	//
	//    * PREPARED – The agent alias is finished being created or updated and
	//    is ready to be invoked.
	//
	//    * FAILED – The agent alias API operation failed.
	//
	//    * UPDATING – The agent alias is being updated.
	//
	//    * DELETING – The agent alias is being deleted.
	//
	// AgentAliasStatus is a required field
	AgentAliasStatus *string `locationName:"agentAliasStatus" type:"string" required:"true" enum:"AgentAliasStatus"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string"`

	// The time at which the alias of the agent was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the alias of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Information on the failure of Provisioned Throughput assigned to an agent
	// alias.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// Contains details about the routing configuration of the alias.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list" required:"true"`

	// The time at which the alias was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAlias) GoString() string {
	return s.String()
}

// SetAgentAliasArn sets the AgentAliasArn field's value.
func (s *AgentAlias) SetAgentAliasArn(v string) *AgentAlias {
	s.AgentAliasArn = &v
	return s
}

// SetAgentAliasHistoryEvents sets the AgentAliasHistoryEvents field's value.
func (s *AgentAlias) SetAgentAliasHistoryEvents(v []*AgentAliasHistoryEvent) *AgentAlias {
	s.AgentAliasHistoryEvents = v
	return s
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *AgentAlias) SetAgentAliasId(v string) *AgentAlias {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *AgentAlias) SetAgentAliasName(v string) *AgentAlias {
	s.AgentAliasName = &v
	return s
}

// SetAgentAliasStatus sets the AgentAliasStatus field's value.
func (s *AgentAlias) SetAgentAliasStatus(v string) *AgentAlias {
	s.AgentAliasStatus = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AgentAlias) SetAgentId(v string) *AgentAlias {
	s.AgentId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AgentAlias) SetClientToken(v string) *AgentAlias {
	s.ClientToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentAlias) SetCreatedAt(v time.Time) *AgentAlias {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentAlias) SetDescription(v string) *AgentAlias {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *AgentAlias) SetFailureReasons(v []*string) *AgentAlias {
	s.FailureReasons = v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *AgentAlias) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *AgentAlias {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentAlias) SetUpdatedAt(v time.Time) *AgentAlias {
	s.UpdatedAt = &v
	return s
}

// Contains details about the history of the alias.
type AgentAliasHistoryEvent struct {
	_ struct{} `type:"structure"`

	// The date that the alias stopped being associated to the version in the routingConfiguration
	// object
	EndDate *time.Time `locationName:"endDate" type:"timestamp" timestampFormat:"iso8601"`

	// Contains details about the version of the agent with which the alias is associated.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`

	// The date that the alias began being associated to the version in the routingConfiguration
	// object.
	StartDate *time.Time `locationName:"startDate" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasHistoryEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasHistoryEvent) GoString() string {
	return s.String()
}

// SetEndDate sets the EndDate field's value.
func (s *AgentAliasHistoryEvent) SetEndDate(v time.Time) *AgentAliasHistoryEvent {
	s.EndDate = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *AgentAliasHistoryEvent) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *AgentAliasHistoryEvent {
	s.RoutingConfiguration = v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *AgentAliasHistoryEvent) SetStartDate(v time.Time) *AgentAliasHistoryEvent {
	s.StartDate = &v
	return s
}

// Contains details about the routing configuration of the alias.
type AgentAliasRoutingConfigurationListItem struct {
	_ struct{} `type:"structure"`

	// The version of the agent with which the alias is associated.
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string"`

	// Information on the Provisioned Throughput assigned to an agent alias.
	ProvisionedThroughput *string `locationName:"provisionedThroughput" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasRoutingConfigurationListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasRoutingConfigurationListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentAliasRoutingConfigurationListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AgentAliasRoutingConfigurationListItem"}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.ProvisionedThroughput != nil && len(*s.ProvisionedThroughput) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionedThroughput", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentAliasRoutingConfigurationListItem) SetAgentVersion(v string) *AgentAliasRoutingConfigurationListItem {
	s.AgentVersion = &v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *AgentAliasRoutingConfigurationListItem) SetProvisionedThroughput(v string) *AgentAliasRoutingConfigurationListItem {
	s.ProvisionedThroughput = &v
	return s
}

// Contains details about an alias of an agent.
type AgentAliasSummary struct {
	_ struct{} `type:"structure"`

	// Contains details about
	//
	// AgentAliasId is a required field
	AgentAliasId *string `locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The name of the alias.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The status of the alias.
	//
	// AgentAliasStatus is a required field
	AgentAliasStatus *string `locationName:"agentAliasStatus" type:"string" required:"true" enum:"AgentAliasStatus"`

	// The time at which the alias of the agent was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the version of the agent with which the alias is associated.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`

	// The time at which the alias was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentAliasSummary) GoString() string {
	return s.String()
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *AgentAliasSummary) SetAgentAliasId(v string) *AgentAliasSummary {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *AgentAliasSummary) SetAgentAliasName(v string) *AgentAliasSummary {
	s.AgentAliasName = &v
	return s
}

// SetAgentAliasStatus sets the AgentAliasStatus field's value.
func (s *AgentAliasSummary) SetAgentAliasStatus(v string) *AgentAliasSummary {
	s.AgentAliasStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentAliasSummary) SetCreatedAt(v time.Time) *AgentAliasSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentAliasSummary) SetDescription(v string) *AgentAliasSummary {
	s.Description = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *AgentAliasSummary) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *AgentAliasSummary {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentAliasSummary) SetUpdatedAt(v time.Time) *AgentAliasSummary {
	s.UpdatedAt = &v
	return s
}

// Defines an agent node in your flow. You specify the agent to invoke at this
// point in the flow. For more information, see Node types in Amazon Bedrock
// works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type AgentFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alias of the agent to invoke.
	//
	// AgentAliasArn is a required field
	AgentAliasArn *string `locationName:"agentAliasArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AgentFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AgentFlowNodeConfiguration"}
	if s.AgentAliasArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasArn sets the AgentAliasArn field's value.
func (s *AgentFlowNodeConfiguration) SetAgentAliasArn(v string) *AgentFlowNodeConfiguration {
	s.AgentAliasArn = &v
	return s
}

// Contains details about a knowledge base that is associated with an agent.
type AgentKnowledgeBase struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent with which the knowledge base is associated.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The version of the agent with which the knowledge base is associated.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The time at which the association between the agent and the knowledge base
	// was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the association between the agent and the knowledge base.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The unique identifier of the association between the agent and the knowledge
	// base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether to use the knowledge base or not when sending an InvokeAgent
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// KnowledgeBaseState is a required field
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" required:"true" enum:"KnowledgeBaseState"`

	// The time at which the association between the agent and the knowledge base
	// was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBase) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentKnowledgeBase) SetAgentId(v string) *AgentKnowledgeBase {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentKnowledgeBase) SetAgentVersion(v string) *AgentKnowledgeBase {
	s.AgentVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentKnowledgeBase) SetCreatedAt(v time.Time) *AgentKnowledgeBase {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentKnowledgeBase) SetDescription(v string) *AgentKnowledgeBase {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *AgentKnowledgeBase) SetKnowledgeBaseId(v string) *AgentKnowledgeBase {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *AgentKnowledgeBase) SetKnowledgeBaseState(v string) *AgentKnowledgeBase {
	s.KnowledgeBaseState = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentKnowledgeBase) SetUpdatedAt(v time.Time) *AgentKnowledgeBase {
	s.UpdatedAt = &v
	return s
}

// Contains details about a knowledge base associated with an agent.
type AgentKnowledgeBaseSummary struct {
	_ struct{} `type:"structure"`

	// The description of the knowledge base associated with an agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base associated with an agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether the agent uses the knowledge base or not when sending an
	// InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	//
	// KnowledgeBaseState is a required field
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" required:"true" enum:"KnowledgeBaseState"`

	// The time at which the knowledge base associated with an agent was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentKnowledgeBaseSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *AgentKnowledgeBaseSummary) SetDescription(v string) *AgentKnowledgeBaseSummary {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *AgentKnowledgeBaseSummary) SetKnowledgeBaseId(v string) *AgentKnowledgeBaseSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *AgentKnowledgeBaseSummary) SetKnowledgeBaseState(v string) *AgentKnowledgeBaseSummary {
	s.KnowledgeBaseState = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentKnowledgeBaseSummary) SetUpdatedAt(v time.Time) *AgentKnowledgeBaseSummary {
	s.UpdatedAt = &v
	return s
}

// Contains details about an agent.
type AgentSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The name of the agent.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The status of the agent.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// The latest version of the agent.
	LatestAgentVersion *string `locationName:"latestAgentVersion" min:"1" type:"string"`

	// The time at which the agent was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentSummary) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *AgentSummary) SetAgentId(v string) *AgentSummary {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *AgentSummary) SetAgentName(v string) *AgentSummary {
	s.AgentName = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *AgentSummary) SetAgentStatus(v string) *AgentSummary {
	s.AgentStatus = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentSummary) SetDescription(v string) *AgentSummary {
	s.Description = &v
	return s
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *AgentSummary) SetGuardrailConfiguration(v *GuardrailConfiguration) *AgentSummary {
	s.GuardrailConfiguration = v
	return s
}

// SetLatestAgentVersion sets the LatestAgentVersion field's value.
func (s *AgentSummary) SetLatestAgentVersion(v string) *AgentSummary {
	s.LatestAgentVersion = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentSummary) SetUpdatedAt(v time.Time) *AgentSummary {
	s.UpdatedAt = &v
	return s
}

// Contains details about a version of an agent.
type AgentVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent that the version belongs to.
	//
	// AgentArn is a required field
	AgentArn *string `locationName:"agentArn" type:"string" required:"true"`

	// The unique identifier of the agent that the version belongs to.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The name of the agent that the version belongs to.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	//
	// AgentResourceRoleArn is a required field
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string" required:"true"`

	// The status of the agent that the version belongs to.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The time at which the version was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that encrypts the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The description of the version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A list of reasons that the API operation on the version failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The foundation model that the version invokes.
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string"`

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	//
	// IdleSessionTTLInSeconds is a required field
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer" required:"true"`

	// The instructions provided to the agent.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AgentVersion's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// Contains details of the memory configuration on the version of the agent.
	MemoryConfiguration *MemoryConfiguration `locationName:"memoryConfiguration" type:"structure"`

	// Contains configurations to override prompt templates in different parts of
	// an agent sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AgentVersion's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`

	// A list of recommended actions to take for the failed API operation on the
	// version to succeed.
	RecommendedActions []*string `locationName:"recommendedActions" type:"list"`

	// The time at which the version was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version number.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersion) GoString() string {
	return s.String()
}

// SetAgentArn sets the AgentArn field's value.
func (s *AgentVersion) SetAgentArn(v string) *AgentVersion {
	s.AgentArn = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *AgentVersion) SetAgentId(v string) *AgentVersion {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *AgentVersion) SetAgentName(v string) *AgentVersion {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *AgentVersion) SetAgentResourceRoleArn(v string) *AgentVersion {
	s.AgentResourceRoleArn = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *AgentVersion) SetAgentStatus(v string) *AgentVersion {
	s.AgentStatus = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentVersion) SetCreatedAt(v time.Time) *AgentVersion {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *AgentVersion) SetCustomerEncryptionKeyArn(v string) *AgentVersion {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentVersion) SetDescription(v string) *AgentVersion {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *AgentVersion) SetFailureReasons(v []*string) *AgentVersion {
	s.FailureReasons = v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *AgentVersion) SetFoundationModel(v string) *AgentVersion {
	s.FoundationModel = &v
	return s
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *AgentVersion) SetGuardrailConfiguration(v *GuardrailConfiguration) *AgentVersion {
	s.GuardrailConfiguration = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *AgentVersion) SetIdleSessionTTLInSeconds(v int64) *AgentVersion {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *AgentVersion) SetInstruction(v string) *AgentVersion {
	s.Instruction = &v
	return s
}

// SetMemoryConfiguration sets the MemoryConfiguration field's value.
func (s *AgentVersion) SetMemoryConfiguration(v *MemoryConfiguration) *AgentVersion {
	s.MemoryConfiguration = v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *AgentVersion) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *AgentVersion {
	s.PromptOverrideConfiguration = v
	return s
}

// SetRecommendedActions sets the RecommendedActions field's value.
func (s *AgentVersion) SetRecommendedActions(v []*string) *AgentVersion {
	s.RecommendedActions = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentVersion) SetUpdatedAt(v time.Time) *AgentVersion {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *AgentVersion) SetVersion(v string) *AgentVersion {
	s.Version = &v
	return s
}

// Contains details about a version of an agent.
type AgentVersionSummary struct {
	_ struct{} `type:"structure"`

	// The name of the agent to which the version belongs.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The status of the agent to which the version belongs.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The time at which the version was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the version of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Details about the guardrail associated with the agent.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// The time at which the version was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentVersionSummary) GoString() string {
	return s.String()
}

// SetAgentName sets the AgentName field's value.
func (s *AgentVersionSummary) SetAgentName(v string) *AgentVersionSummary {
	s.AgentName = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *AgentVersionSummary) SetAgentStatus(v string) *AgentVersionSummary {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AgentVersionSummary) SetAgentVersion(v string) *AgentVersionSummary {
	s.AgentVersion = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AgentVersionSummary) SetCreatedAt(v time.Time) *AgentVersionSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentVersionSummary) SetDescription(v string) *AgentVersionSummary {
	s.Description = &v
	return s
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *AgentVersionSummary) SetGuardrailConfiguration(v *GuardrailConfiguration) *AgentVersionSummary {
	s.GuardrailConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *AgentVersionSummary) SetUpdatedAt(v time.Time) *AgentVersionSummary {
	s.UpdatedAt = &v
	return s
}

type AssociateAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent with which you want to associate the knowledge
	// base.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent with which you want to associate the knowledge base.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// A description of what the agent should use the knowledge base for.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The unique identifier of the knowledge base to associate with the agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether to use the knowledge base or not when sending an InvokeAgent
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" enum:"KnowledgeBaseState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetAgentId(v string) *AssociateAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetAgentVersion(v string) *AssociateAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetDescription(v string) *AssociateAgentKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *AssociateAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *AssociateAgentKnowledgeBaseInput) SetKnowledgeBaseState(v string) *AssociateAgentKnowledgeBaseInput {
	s.KnowledgeBaseState = &v
	return s
}

type AssociateAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base that has been associated with the
	// agent.
	//
	// AgentKnowledgeBase is a required field
	AgentKnowledgeBase *AgentKnowledgeBase `locationName:"agentKnowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBase sets the AgentKnowledgeBase field's value.
func (s *AssociateAgentKnowledgeBaseOutput) SetAgentKnowledgeBase(v *AgentKnowledgeBase) *AssociateAgentKnowledgeBaseOutput {
	s.AgentKnowledgeBase = v
	return s
}

// The vector configuration details for the Bedrock embeddings model.
type BedrockEmbeddingModelConfiguration struct {
	_ struct{} `type:"structure"`

	// The dimensions details for the vector configuration used on the Bedrock embeddings
	// model.
	Dimensions *int64 `locationName:"dimensions" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockEmbeddingModelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockEmbeddingModelConfiguration) GoString() string {
	return s.String()
}

// SetDimensions sets the Dimensions field's value.
func (s *BedrockEmbeddingModelConfiguration) SetDimensions(v int64) *BedrockEmbeddingModelConfiguration {
	s.Dimensions = &v
	return s
}

// Settings for a foundation model used to parse documents for a data source.
type BedrockFoundationModelConfiguration struct {
	_ struct{} `type:"structure"`

	// The model's ARN.
	//
	// ModelArn is a required field
	ModelArn *string `locationName:"modelArn" min:"1" type:"string" required:"true"`

	// Instructions for interpreting the contents of a document.
	ParsingPrompt *ParsingPrompt `locationName:"parsingPrompt" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockFoundationModelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BedrockFoundationModelConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BedrockFoundationModelConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BedrockFoundationModelConfiguration"}
	if s.ModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelArn"))
	}
	if s.ModelArn != nil && len(*s.ModelArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelArn", 1))
	}
	if s.ParsingPrompt != nil {
		if err := s.ParsingPrompt.Validate(); err != nil {
			invalidParams.AddNested("ParsingPrompt", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelArn sets the ModelArn field's value.
func (s *BedrockFoundationModelConfiguration) SetModelArn(v string) *BedrockFoundationModelConfiguration {
	s.ModelArn = &v
	return s
}

// SetParsingPrompt sets the ParsingPrompt field's value.
func (s *BedrockFoundationModelConfiguration) SetParsingPrompt(v *ParsingPrompt) *BedrockFoundationModelConfiguration {
	s.ParsingPrompt = v
	return s
}

// Details about how to chunk the documents in the data source. A chunk refers
// to an excerpt from a data source that is returned when the knowledge base
// that it belongs to is queried.
type ChunkingConfiguration struct {
	_ struct{} `type:"structure"`

	// Knowledge base can split your source data into chunks. A chunk refers to
	// an excerpt from a data source that is returned when the knowledge base that
	// it belongs to is queried. You have the following options for chunking your
	// data. If you opt for NONE, then you may want to pre-process your files by
	// splitting them up such that each file corresponds to a chunk.
	//
	//    * FIXED_SIZE – Amazon Bedrock splits your source data into chunks of
	//    the approximate size that you set in the fixedSizeChunkingConfiguration.
	//
	//    * HIERARCHICAL – Split documents into layers of chunks where the first
	//    layer contains large chunks, and the second layer contains smaller chunks
	//    derived from the first layer.
	//
	//    * SEMANTIC – Split documents into chunks based on groups of similar
	//    content derived with natural language processing.
	//
	//    * NONE – Amazon Bedrock treats each file as one chunk. If you choose
	//    this option, you may want to pre-process your documents by splitting them
	//    into separate files.
	//
	// ChunkingStrategy is a required field
	ChunkingStrategy *string `locationName:"chunkingStrategy" type:"string" required:"true" enum:"ChunkingStrategy"`

	// Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy
	// as NONE, exclude this field.
	FixedSizeChunkingConfiguration *FixedSizeChunkingConfiguration `locationName:"fixedSizeChunkingConfiguration" type:"structure"`

	// Settings for hierarchical document chunking for a data source. Hierarchical
	// chunking splits documents into layers of chunks where the first layer contains
	// large chunks, and the second layer contains smaller chunks derived from the
	// first layer.
	HierarchicalChunkingConfiguration *HierarchicalChunkingConfiguration `locationName:"hierarchicalChunkingConfiguration" type:"structure"`

	// Settings for semantic document chunking for a data source. Semantic chunking
	// splits a document into into smaller documents based on groups of similar
	// content derived from the text with natural language processing.
	SemanticChunkingConfiguration *SemanticChunkingConfiguration `locationName:"semanticChunkingConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChunkingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChunkingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChunkingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChunkingConfiguration"}
	if s.ChunkingStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("ChunkingStrategy"))
	}
	if s.FixedSizeChunkingConfiguration != nil {
		if err := s.FixedSizeChunkingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FixedSizeChunkingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.HierarchicalChunkingConfiguration != nil {
		if err := s.HierarchicalChunkingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("HierarchicalChunkingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SemanticChunkingConfiguration != nil {
		if err := s.SemanticChunkingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SemanticChunkingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChunkingStrategy sets the ChunkingStrategy field's value.
func (s *ChunkingConfiguration) SetChunkingStrategy(v string) *ChunkingConfiguration {
	s.ChunkingStrategy = &v
	return s
}

// SetFixedSizeChunkingConfiguration sets the FixedSizeChunkingConfiguration field's value.
func (s *ChunkingConfiguration) SetFixedSizeChunkingConfiguration(v *FixedSizeChunkingConfiguration) *ChunkingConfiguration {
	s.FixedSizeChunkingConfiguration = v
	return s
}

// SetHierarchicalChunkingConfiguration sets the HierarchicalChunkingConfiguration field's value.
func (s *ChunkingConfiguration) SetHierarchicalChunkingConfiguration(v *HierarchicalChunkingConfiguration) *ChunkingConfiguration {
	s.HierarchicalChunkingConfiguration = v
	return s
}

// SetSemanticChunkingConfiguration sets the SemanticChunkingConfiguration field's value.
func (s *ChunkingConfiguration) SetSemanticChunkingConfiguration(v *SemanticChunkingConfiguration) *ChunkingConfiguration {
	s.SemanticChunkingConfiguration = v
	return s
}

// Defines a collector node in your flow. This node takes an iteration of inputs
// and consolidates them into an array in the output. For more information,
// see Node types in Amazon Bedrock works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type CollectorFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CollectorFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Defines a condition node in your flow. You can specify conditions that determine
// which node comes next in the flow. For more information, see Node types in
// Amazon Bedrock works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type ConditionFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of conditions. Each member contains the name of a condition and
	// an expression that defines the condition.
	//
	// Conditions is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConditionFlowNodeConfiguration's
	// String and GoString methods.
	//
	// Conditions is a required field
	Conditions []*FlowCondition `locationName:"conditions" min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConditionFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConditionFlowNodeConfiguration"}
	if s.Conditions == nil {
		invalidParams.Add(request.NewErrParamRequired("Conditions"))
	}
	if s.Conditions != nil && len(s.Conditions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Conditions", 1))
	}
	if s.Conditions != nil {
		for i, v := range s.Conditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Conditions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditions sets the Conditions field's value.
func (s *ConditionFlowNodeConfiguration) SetConditions(v []*FlowCondition) *ConditionFlowNodeConfiguration {
	s.Conditions = v
	return s
}

// There was a conflict performing an operation.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration of the Confluence content. For example, configuring specific
// types of Confluence content.
type ConfluenceCrawlerConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of filtering the Confluence content. For example, configuring
	// regular expression patterns to include or exclude certain content.
	FilterConfiguration *CrawlFilterConfiguration `locationName:"filterConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceCrawlerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceCrawlerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceCrawlerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceCrawlerConfiguration"}
	if s.FilterConfiguration != nil {
		if err := s.FilterConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FilterConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *ConfluenceCrawlerConfiguration) SetFilterConfiguration(v *CrawlFilterConfiguration) *ConfluenceCrawlerConfiguration {
	s.FilterConfiguration = v
	return s
}

// The configuration information to connect to Confluence as your data source.
type ConfluenceDataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of the Confluence content. For example, configuring specific
	// types of Confluence content.
	CrawlerConfiguration *ConfluenceCrawlerConfiguration `locationName:"crawlerConfiguration" type:"structure"`

	// The endpoint information to connect to your Confluence data source.
	//
	// SourceConfiguration is a required field
	SourceConfiguration *ConfluenceSourceConfiguration `locationName:"sourceConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceDataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceDataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceDataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceDataSourceConfiguration"}
	if s.SourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConfiguration"))
	}
	if s.CrawlerConfiguration != nil {
		if err := s.CrawlerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CrawlerConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerConfiguration sets the CrawlerConfiguration field's value.
func (s *ConfluenceDataSourceConfiguration) SetCrawlerConfiguration(v *ConfluenceCrawlerConfiguration) *ConfluenceDataSourceConfiguration {
	s.CrawlerConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *ConfluenceDataSourceConfiguration) SetSourceConfiguration(v *ConfluenceSourceConfiguration) *ConfluenceDataSourceConfiguration {
	s.SourceConfiguration = v
	return s
}

// The endpoint information to connect to your Confluence data source.
type ConfluenceSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The supported authentication type to authenticate and connect to your Confluence
	// instance.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"ConfluenceAuthType"`

	// The Amazon Resource Name of an Secrets Manager secret that stores your authentication
	// credentials for your SharePoint site/sites. For more information on the key-value
	// pairs that must be included in your secret, depending on your authentication
	// type, see Confluence connection configuration (https://docs.aws.amazon.com/bedrock/latest/userguide/confluence-data-source-connector.html#configuration-confluence-connector).
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The supported host type, whether online/cloud or server/on-premises.
	//
	// HostType is a required field
	HostType *string `locationName:"hostType" type:"string" required:"true" enum:"ConfluenceHostType"`

	// The Confluence host URL or instance URL.
	//
	// HostUrl is a required field
	HostUrl *string `locationName:"hostUrl" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfluenceSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfluenceSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfluenceSourceConfiguration"}
	if s.AuthType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthType"))
	}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.HostType == nil {
		invalidParams.Add(request.NewErrParamRequired("HostType"))
	}
	if s.HostUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("HostUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *ConfluenceSourceConfiguration) SetAuthType(v string) *ConfluenceSourceConfiguration {
	s.AuthType = &v
	return s
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *ConfluenceSourceConfiguration) SetCredentialsSecretArn(v string) *ConfluenceSourceConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetHostType sets the HostType field's value.
func (s *ConfluenceSourceConfiguration) SetHostType(v string) *ConfluenceSourceConfiguration {
	s.HostType = &v
	return s
}

// SetHostUrl sets the HostUrl field's value.
func (s *ConfluenceSourceConfiguration) SetHostUrl(v string) *ConfluenceSourceConfiguration {
	s.HostUrl = &v
	return s
}

// The configuration of filtering the data source content. For example, configuring
// regular expression patterns to include or exclude certain content.
type CrawlFilterConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of filtering certain objects or content types of the data
	// source.
	PatternObjectFilter *PatternObjectFilterConfiguration `locationName:"patternObjectFilter" type:"structure"`

	// The type of filtering that you want to apply to certain objects or content
	// of the data source. For example, the PATTERN type is regular expression patterns
	// you can apply to filter your content.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"CrawlFilterConfigurationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlFilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CrawlFilterConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CrawlFilterConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CrawlFilterConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.PatternObjectFilter != nil {
		if err := s.PatternObjectFilter.Validate(); err != nil {
			invalidParams.AddNested("PatternObjectFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatternObjectFilter sets the PatternObjectFilter field's value.
func (s *CrawlFilterConfiguration) SetPatternObjectFilter(v *PatternObjectFilterConfiguration) *CrawlFilterConfiguration {
	s.PatternObjectFilter = v
	return s
}

// SetType sets the Type field's value.
func (s *CrawlFilterConfiguration) SetType(v string) *CrawlFilterConfiguration {
	s.Type = &v
	return s
}

type CreateAgentActionGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action or the custom control
	// method for handling the information elicited from the user.
	ActionGroupExecutor *ActionGroupExecutor `locationName:"actionGroupExecutor" type:"structure"`

	// The name to give the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	ActionGroupState *string `locationName:"actionGroupState" type:"string" enum:"ActionGroupState"`

	// The unique identifier of the agent for which to create the action group.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent for which to create the action group.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// Contains either details about the S3 object containing the OpenAPI schema
	// for the action group or the JSON or YAML-formatted payload defining the schema.
	// For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	ApiSchema *APISchema `locationName:"apiSchema" type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description of the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the function schema for the action group or the JSON
	// or YAML-formatted payload defining the schema.
	FunctionSchema *FunctionSchema `locationName:"functionSchema" type:"structure"`

	// To allow your agent to request the user for additional information when trying
	// to complete a task, set this field to AMAZON.UserInput. You must leave the
	// description, apiSchema, and actionGroupExecutor fields blank for this action
	// group.
	//
	// To allow your agent to generate, run, and troubleshoot code when trying to
	// complete a task, set this field to AMAZON.CodeInterpreter. You must leave
	// the description, apiSchema, and actionGroupExecutor fields blank for this
	// action group.
	//
	// During orchestration, if your agent determines that it needs to invoke an
	// API in an action group, but doesn't have enough information to complete the
	// API request, it will invoke this action group instead and return an Observation
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
	// reprompting the user for more information.
	ParentActionGroupSignature *string `locationName:"parentActionGroupSignature" type:"string" enum:"ActionGroupSignature"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentActionGroupInput"}
	if s.ActionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ApiSchema != nil {
		if err := s.ApiSchema.Validate(); err != nil {
			invalidParams.AddNested("ApiSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.FunctionSchema != nil {
		if err := s.FunctionSchema.Validate(); err != nil {
			invalidParams.AddNested("FunctionSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupExecutor sets the ActionGroupExecutor field's value.
func (s *CreateAgentActionGroupInput) SetActionGroupExecutor(v *ActionGroupExecutor) *CreateAgentActionGroupInput {
	s.ActionGroupExecutor = v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *CreateAgentActionGroupInput) SetActionGroupName(v string) *CreateAgentActionGroupInput {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *CreateAgentActionGroupInput) SetActionGroupState(v string) *CreateAgentActionGroupInput {
	s.ActionGroupState = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *CreateAgentActionGroupInput) SetAgentId(v string) *CreateAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *CreateAgentActionGroupInput) SetAgentVersion(v string) *CreateAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

// SetApiSchema sets the ApiSchema field's value.
func (s *CreateAgentActionGroupInput) SetApiSchema(v *APISchema) *CreateAgentActionGroupInput {
	s.ApiSchema = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAgentActionGroupInput) SetClientToken(v string) *CreateAgentActionGroupInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAgentActionGroupInput) SetDescription(v string) *CreateAgentActionGroupInput {
	s.Description = &v
	return s
}

// SetFunctionSchema sets the FunctionSchema field's value.
func (s *CreateAgentActionGroupInput) SetFunctionSchema(v *FunctionSchema) *CreateAgentActionGroupInput {
	s.FunctionSchema = v
	return s
}

// SetParentActionGroupSignature sets the ParentActionGroupSignature field's value.
func (s *CreateAgentActionGroupInput) SetParentActionGroupSignature(v string) *CreateAgentActionGroupInput {
	s.ParentActionGroupSignature = &v
	return s
}

type CreateAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the action group that was created.
	//
	// AgentActionGroup is a required field
	AgentActionGroup *AgentActionGroup `locationName:"agentActionGroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentActionGroupOutput) GoString() string {
	return s.String()
}

// SetAgentActionGroup sets the AgentActionGroup field's value.
func (s *CreateAgentActionGroupOutput) SetAgentActionGroup(v *AgentActionGroup) *CreateAgentActionGroupOutput {
	s.AgentActionGroup = v
	return s
}

type CreateAgentAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the alias.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description of the alias of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the routing configuration of the alias.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`

	// Any tags that you want to attach to the alias of the agent.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentAliasInput"}
	if s.AgentAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoutingConfiguration != nil {
		for i, v := range s.RoutingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *CreateAgentAliasInput) SetAgentAliasName(v string) *CreateAgentAliasInput {
	s.AgentAliasName = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *CreateAgentAliasInput) SetAgentId(v string) *CreateAgentAliasInput {
	s.AgentId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAgentAliasInput) SetClientToken(v string) *CreateAgentAliasInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAgentAliasInput) SetDescription(v string) *CreateAgentAliasInput {
	s.Description = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *CreateAgentAliasInput) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *CreateAgentAliasInput {
	s.RoutingConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAgentAliasInput) SetTags(v map[string]*string) *CreateAgentAliasInput {
	s.Tags = v
	return s
}

type CreateAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the alias that was created.
	//
	// AgentAlias is a required field
	AgentAlias *AgentAlias `locationName:"agentAlias" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAlias sets the AgentAlias field's value.
func (s *CreateAgentAliasOutput) SetAgentAlias(v *AgentAlias) *CreateAgentAliasOutput {
	s.AgentAlias = v
	return s
}

type CreateAgentInput struct {
	_ struct{} `type:"structure"`

	// A name for the agent that you create.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// A description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The foundation model to be used for orchestration by the agent you create.
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string"`

	// The unique Guardrail configuration assigned to the agent when it is created.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// Instructions that tell the agent what it should do and how it should interact
	// with users.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAgentInput's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// Contains the details of the memory configured for the agent.
	MemoryConfiguration *MemoryConfiguration `locationName:"memoryConfiguration" type:"structure"`

	// Contains configurations to override prompts in different parts of an agent
	// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateAgentInput's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`

	// Any tags that you want to attach to the agent.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentInput"}
	if s.AgentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentName"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FoundationModel != nil && len(*s.FoundationModel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FoundationModel", 1))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.Instruction != nil && len(*s.Instruction) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("Instruction", 40))
	}
	if s.MemoryConfiguration != nil {
		if err := s.MemoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MemoryConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PromptOverrideConfiguration != nil {
		if err := s.PromptOverrideConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PromptOverrideConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentName sets the AgentName field's value.
func (s *CreateAgentInput) SetAgentName(v string) *CreateAgentInput {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *CreateAgentInput) SetAgentResourceRoleArn(v string) *CreateAgentInput {
	s.AgentResourceRoleArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAgentInput) SetClientToken(v string) *CreateAgentInput {
	s.ClientToken = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreateAgentInput) SetCustomerEncryptionKeyArn(v string) *CreateAgentInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAgentInput) SetDescription(v string) *CreateAgentInput {
	s.Description = &v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *CreateAgentInput) SetFoundationModel(v string) *CreateAgentInput {
	s.FoundationModel = &v
	return s
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *CreateAgentInput) SetGuardrailConfiguration(v *GuardrailConfiguration) *CreateAgentInput {
	s.GuardrailConfiguration = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *CreateAgentInput) SetIdleSessionTTLInSeconds(v int64) *CreateAgentInput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *CreateAgentInput) SetInstruction(v string) *CreateAgentInput {
	s.Instruction = &v
	return s
}

// SetMemoryConfiguration sets the MemoryConfiguration field's value.
func (s *CreateAgentInput) SetMemoryConfiguration(v *MemoryConfiguration) *CreateAgentInput {
	s.MemoryConfiguration = v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *CreateAgentInput) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *CreateAgentInput {
	s.PromptOverrideConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAgentInput) SetTags(v map[string]*string) *CreateAgentInput {
	s.Tags = v
	return s
}

type CreateAgentOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the agent created.
	//
	// Agent is a required field
	Agent *Agent `locationName:"agent" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentOutput) GoString() string {
	return s.String()
}

// SetAgent sets the Agent field's value.
func (s *CreateAgentOutput) SetAgent(v *Agent) *CreateAgentOutput {
	s.Agent = v
	return s
}

type CreateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The data deletion policy for the data source.
	//
	// You can set the data deletion policy to:
	//
	//    * DELETE: Deletes all underlying data belonging to the data source from
	//    the vector store upon deletion of a knowledge base or data source resource.
	//    Note that the vector store itself is not deleted, only the underlying
	//    data. This flag is ignored if an Amazon Web Services account is deleted.
	//
	//    * RETAIN: Retains all underlying data in your vector store upon deletion
	//    of a knowledge base or data source resource.
	DataDeletionPolicy *string `locationName:"dataDeletionPolicy" type:"string" enum:"DataDeletionPolicy"`

	// The connection configuration for the data source.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `locationName:"dataSourceConfiguration" type:"structure" required:"true"`

	// A description of the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which to add the data source.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains details about the server-side encryption for the data source.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration `locationName:"vectorIngestionConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataSourceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.DataSourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceConfiguration"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DataSourceConfiguration != nil {
		if err := s.DataSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VectorIngestionConfiguration != nil {
		if err := s.VectorIngestionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorIngestionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataSourceInput) SetClientToken(v string) *CreateDataSourceInput {
	s.ClientToken = &v
	return s
}

// SetDataDeletionPolicy sets the DataDeletionPolicy field's value.
func (s *CreateDataSourceInput) SetDataDeletionPolicy(v string) *CreateDataSourceInput {
	s.DataDeletionPolicy = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *CreateDataSourceInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *CreateDataSourceInput {
	s.DataSourceConfiguration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataSourceInput) SetDescription(v string) *CreateDataSourceInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *CreateDataSourceInput) SetKnowledgeBaseId(v string) *CreateDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataSourceInput) SetName(v string) *CreateDataSourceInput {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *CreateDataSourceInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *CreateDataSourceInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetVectorIngestionConfiguration sets the VectorIngestionConfiguration field's value.
func (s *CreateDataSourceInput) SetVectorIngestionConfiguration(v *VectorIngestionConfiguration) *CreateDataSourceInput {
	s.VectorIngestionConfiguration = v
	return s
}

type CreateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the data source.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *CreateDataSourceOutput) SetDataSource(v *DataSource) *CreateDataSourceOutput {
	s.DataSource = v
	return s
}

type CreateFlowAliasInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description for the alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow for which to create an alias.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// A name for the alias.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains information about the version to which to map the alias.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*FlowAliasRoutingConfigurationListItem `locationName:"routingConfiguration" min:"1" type:"list" required:"true"`

	// Any tags that you want to attach to the alias of the flow. For more information,
	// see Tagging resources in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowAliasInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoutingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingConfiguration"))
	}
	if s.RoutingConfiguration != nil && len(s.RoutingConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingConfiguration", 1))
	}
	if s.RoutingConfiguration != nil {
		for i, v := range s.RoutingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFlowAliasInput) SetClientToken(v string) *CreateFlowAliasInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFlowAliasInput) SetDescription(v string) *CreateFlowAliasInput {
	s.Description = &v
	return s
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *CreateFlowAliasInput) SetFlowIdentifier(v string) *CreateFlowAliasInput {
	s.FlowIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowAliasInput) SetName(v string) *CreateFlowAliasInput {
	s.Name = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *CreateFlowAliasInput) SetRoutingConfiguration(v []*FlowAliasRoutingConfigurationListItem) *CreateFlowAliasInput {
	s.RoutingConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFlowAliasInput) SetTags(v map[string]*string) *CreateFlowAliasInput {
	s.Tags = v
	return s
}

type CreateFlowAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alias.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the alias was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow that the alias belongs to.
	//
	// FlowId is a required field
	FlowId *string `locationName:"flowId" type:"string" required:"true"`

	// The unique identifier of the alias.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the alias.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains information about the version that the alias is mapped to.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*FlowAliasRoutingConfigurationListItem `locationName:"routingConfiguration" min:"1" type:"list" required:"true"`

	// The time at which the alias of the flow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowAliasOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFlowAliasOutput) SetArn(v string) *CreateFlowAliasOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateFlowAliasOutput) SetCreatedAt(v time.Time) *CreateFlowAliasOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFlowAliasOutput) SetDescription(v string) *CreateFlowAliasOutput {
	s.Description = &v
	return s
}

// SetFlowId sets the FlowId field's value.
func (s *CreateFlowAliasOutput) SetFlowId(v string) *CreateFlowAliasOutput {
	s.FlowId = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFlowAliasOutput) SetId(v string) *CreateFlowAliasOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowAliasOutput) SetName(v string) *CreateFlowAliasOutput {
	s.Name = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *CreateFlowAliasOutput) SetRoutingConfiguration(v []*FlowAliasRoutingConfigurationListItem) *CreateFlowAliasOutput {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateFlowAliasOutput) SetUpdatedAt(v time.Time) *CreateFlowAliasOutput {
	s.UpdatedAt = &v
	return s
}

type CreateFlowInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// A definition of the nodes and connections between nodes in the flow.
	Definition *FlowDefinition `locationName:"definition" type:"structure"`

	// A description for the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// and manage a flow. For more information, see Create a service role for flows
	// in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
	// in the Amazon Bedrock User Guide.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// A name for the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Any tags that you want to attach to the flow. For more information, see Tagging
	// resources in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFlowInput) SetClientToken(v string) *CreateFlowInput {
	s.ClientToken = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreateFlowInput) SetCustomerEncryptionKeyArn(v string) *CreateFlowInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateFlowInput) SetDefinition(v *FlowDefinition) *CreateFlowInput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFlowInput) SetDescription(v string) *CreateFlowInput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateFlowInput) SetExecutionRoleArn(v string) *CreateFlowInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowInput) SetName(v string) *CreateFlowInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFlowInput) SetTags(v map[string]*string) *CreateFlowInput {
	s.Tags = v
	return s
}

type CreateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that you encrypted the flow
	// with.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// A definition of the nodes and connections between nodes in the flow.
	Definition *FlowDefinition `locationName:"definition" type:"structure"`

	// The description of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// a flow. For more information, see Create a service role for flows in Amazon
	// Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
	// in the Amazon Bedrock User Guide.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the flow. When you submit this request, the status will be
	// NotPrepared. If creation fails, the status becomes Failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`

	// The time at which the flow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version of the flow. When you create a flow, the version created is the
	// DRAFT version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFlowOutput) SetArn(v string) *CreateFlowOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateFlowOutput) SetCreatedAt(v time.Time) *CreateFlowOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreateFlowOutput) SetCustomerEncryptionKeyArn(v string) *CreateFlowOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateFlowOutput) SetDefinition(v *FlowDefinition) *CreateFlowOutput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFlowOutput) SetDescription(v string) *CreateFlowOutput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateFlowOutput) SetExecutionRoleArn(v string) *CreateFlowOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFlowOutput) SetId(v string) *CreateFlowOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowOutput) SetName(v string) *CreateFlowOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateFlowOutput) SetStatus(v string) *CreateFlowOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateFlowOutput) SetUpdatedAt(v time.Time) *CreateFlowOutput {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateFlowOutput) SetVersion(v string) *CreateFlowOutput {
	s.Version = &v
	return s
}

type CreateFlowVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description of the version of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow that you want to create a version of.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFlowVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFlowVersionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFlowVersionInput) SetClientToken(v string) *CreateFlowVersionInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFlowVersionInput) SetDescription(v string) *CreateFlowVersionInput {
	s.Description = &v
	return s
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *CreateFlowVersionInput) SetFlowIdentifier(v string) *CreateFlowVersionInput {
	s.FlowIdentifier = &v
	return s
}

type CreateFlowVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The KMS key that the flow is encrypted with.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// A definition of the nodes and connections in the flow.
	Definition *FlowDefinition `locationName:"definition" type:"structure"`

	// The description of the flow version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// a flow. For more information, see Create a service role for flows in Amazon
	// Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
	// in the Amazon Bedrock User Guide.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow version.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`

	// The version of the flow that was created. Versions are numbered incrementally,
	// starting from 1.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFlowVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFlowVersionOutput) SetArn(v string) *CreateFlowVersionOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateFlowVersionOutput) SetCreatedAt(v time.Time) *CreateFlowVersionOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreateFlowVersionOutput) SetCustomerEncryptionKeyArn(v string) *CreateFlowVersionOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *CreateFlowVersionOutput) SetDefinition(v *FlowDefinition) *CreateFlowVersionOutput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFlowVersionOutput) SetDescription(v string) *CreateFlowVersionOutput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateFlowVersionOutput) SetExecutionRoleArn(v string) *CreateFlowVersionOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateFlowVersionOutput) SetId(v string) *CreateFlowVersionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFlowVersionOutput) SetName(v string) *CreateFlowVersionOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateFlowVersionOutput) SetStatus(v string) *CreateFlowVersionOutput {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateFlowVersionOutput) SetVersion(v string) *CreateFlowVersionOutput {
	s.Version = &v
	return s
}

type CreateKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description of the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the embeddings model used for the knowledge base.
	//
	// KnowledgeBaseConfiguration is a required field
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure" required:"true"`

	// A name for the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the knowledge base.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Contains details about the configuration of the vector database used for
	// the knowledge base.
	//
	// StorageConfiguration is a required field
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure" required:"true"`

	// Specify the key-value pairs for the tags that you want to attach to your
	// knowledge base in this object.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKnowledgeBaseInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseConfiguration"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StorageConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageConfiguration"))
	}
	if s.KnowledgeBaseConfiguration != nil {
		if err := s.KnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageConfiguration != nil {
		if err := s.StorageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StorageConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateKnowledgeBaseInput) SetClientToken(v string) *CreateKnowledgeBaseInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateKnowledgeBaseInput) SetDescription(v string) *CreateKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *CreateKnowledgeBaseInput) SetKnowledgeBaseConfiguration(v *KnowledgeBaseConfiguration) *CreateKnowledgeBaseInput {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateKnowledgeBaseInput) SetName(v string) *CreateKnowledgeBaseInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateKnowledgeBaseInput) SetRoleArn(v string) *CreateKnowledgeBaseInput {
	s.RoleArn = &v
	return s
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *CreateKnowledgeBaseInput) SetStorageConfiguration(v *StorageConfiguration) *CreateKnowledgeBaseInput {
	s.StorageConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateKnowledgeBaseInput) SetTags(v map[string]*string) *CreateKnowledgeBaseInput {
	s.Tags = v
	return s
}

type CreateKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base.
	//
	// KnowledgeBase is a required field
	KnowledgeBase *KnowledgeBase `locationName:"knowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *CreateKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBase) *CreateKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

type CreatePromptInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The name of the default variant for the prompt. This value must match the
	// name field in the relevant PromptVariant (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html)
	// object.
	DefaultVariant *string `locationName:"defaultVariant" type:"string"`

	// A description for the prompt.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A name for the prompt.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Any tags that you want to attach to the prompt. For more information, see
	// Tagging resources in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of objects, each containing details about a variant of the prompt.
	//
	// Variants is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePromptInput's
	// String and GoString methods.
	Variants []*PromptVariant `locationName:"variants" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePromptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePromptInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Variants != nil {
		for i, v := range s.Variants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePromptInput) SetClientToken(v string) *CreatePromptInput {
	s.ClientToken = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreatePromptInput) SetCustomerEncryptionKeyArn(v string) *CreatePromptInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefaultVariant sets the DefaultVariant field's value.
func (s *CreatePromptInput) SetDefaultVariant(v string) *CreatePromptInput {
	s.DefaultVariant = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePromptInput) SetDescription(v string) *CreatePromptInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePromptInput) SetName(v string) *CreatePromptInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePromptInput) SetTags(v map[string]*string) *CreatePromptInput {
	s.Tags = v
	return s
}

// SetVariants sets the Variants field's value.
func (s *CreatePromptInput) SetVariants(v []*PromptVariant) *CreatePromptInput {
	s.Variants = v
	return s
}

type CreatePromptOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the prompt.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the prompt was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that you encrypted the prompt
	// with.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The name of the default variant for your prompt.
	DefaultVariant *string `locationName:"defaultVariant" type:"string"`

	// The description of the prompt.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the prompt.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the prompt.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time at which the prompt was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A list of objects, each containing details about a variant of the prompt.
	//
	// Variants is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePromptOutput's
	// String and GoString methods.
	Variants []*PromptVariant `locationName:"variants" type:"list" sensitive:"true"`

	// The version of the prompt. When you create a prompt, the version created
	// is the DRAFT version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePromptOutput) SetArn(v string) *CreatePromptOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreatePromptOutput) SetCreatedAt(v time.Time) *CreatePromptOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreatePromptOutput) SetCustomerEncryptionKeyArn(v string) *CreatePromptOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefaultVariant sets the DefaultVariant field's value.
func (s *CreatePromptOutput) SetDefaultVariant(v string) *CreatePromptOutput {
	s.DefaultVariant = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePromptOutput) SetDescription(v string) *CreatePromptOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreatePromptOutput) SetId(v string) *CreatePromptOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePromptOutput) SetName(v string) *CreatePromptOutput {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreatePromptOutput) SetUpdatedAt(v time.Time) *CreatePromptOutput {
	s.UpdatedAt = &v
	return s
}

// SetVariants sets the Variants field's value.
func (s *CreatePromptOutput) SetVariants(v []*PromptVariant) *CreatePromptOutput {
	s.Variants = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreatePromptOutput) SetVersion(v string) *CreatePromptOutput {
	s.Version = &v
	return s
}

type CreatePromptVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// A description for the version of the prompt.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the prompt that you want to create a version of.
	//
	// PromptIdentifier is a required field
	PromptIdentifier *string `location:"uri" locationName:"promptIdentifier" type:"string" required:"true"`

	// Any tags that you want to attach to the version of the prompt. For more information,
	// see Tagging resources in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html).
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePromptVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePromptVersionInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.PromptIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptIdentifier"))
	}
	if s.PromptIdentifier != nil && len(*s.PromptIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PromptIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreatePromptVersionInput) SetClientToken(v string) *CreatePromptVersionInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePromptVersionInput) SetDescription(v string) *CreatePromptVersionInput {
	s.Description = &v
	return s
}

// SetPromptIdentifier sets the PromptIdentifier field's value.
func (s *CreatePromptVersionInput) SetPromptIdentifier(v string) *CreatePromptVersionInput {
	s.PromptIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePromptVersionInput) SetTags(v map[string]*string) *CreatePromptVersionInput {
	s.Tags = v
	return s
}

type CreatePromptVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the version of the prompt.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the prompt was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the version of the
	// prompt.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The name of the default variant for the prompt. This value must match the
	// name field in the relevant PromptVariant (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html)
	// object.
	DefaultVariant *string `locationName:"defaultVariant" type:"string"`

	// A description for the prompt version.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the prompt.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the prompt version.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time at which the prompt was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A list of objects, each containing details about a variant of the prompt.
	//
	// Variants is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePromptVersionOutput's
	// String and GoString methods.
	Variants []*PromptVariant `locationName:"variants" type:"list" sensitive:"true"`

	// The version of the prompt that was created. Versions are numbered incrementally,
	// starting from 1.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePromptVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePromptVersionOutput) SetArn(v string) *CreatePromptVersionOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreatePromptVersionOutput) SetCreatedAt(v time.Time) *CreatePromptVersionOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *CreatePromptVersionOutput) SetCustomerEncryptionKeyArn(v string) *CreatePromptVersionOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefaultVariant sets the DefaultVariant field's value.
func (s *CreatePromptVersionOutput) SetDefaultVariant(v string) *CreatePromptVersionOutput {
	s.DefaultVariant = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePromptVersionOutput) SetDescription(v string) *CreatePromptVersionOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreatePromptVersionOutput) SetId(v string) *CreatePromptVersionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePromptVersionOutput) SetName(v string) *CreatePromptVersionOutput {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreatePromptVersionOutput) SetUpdatedAt(v time.Time) *CreatePromptVersionOutput {
	s.UpdatedAt = &v
	return s
}

// SetVariants sets the Variants field's value.
func (s *CreatePromptVersionOutput) SetVariants(v []*PromptVariant) *CreatePromptVersionOutput {
	s.Variants = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreatePromptVersionOutput) SetVersion(v string) *CreatePromptVersionOutput {
	s.Version = &v
	return s
}

// Settings for customizing steps in the data source content ingestion pipeline.
//
// You can configure the data source to process documents with a Lambda function
// after they are parsed and converted into chunks. When you add a post-chunking
// transformation, the service stores chunked documents in an S3 bucket and
// invokes a Lambda function to process them.
//
// To process chunked documents with a Lambda function, define an S3 bucket
// path for input and output objects, and a transformation that specifies the
// Lambda function to invoke. You can use the Lambda function to customize how
// chunks are split, and the metadata for each chunk.
type CustomTransformationConfiguration struct {
	_ struct{} `type:"structure"`

	// An S3 bucket path for input and output objects.
	//
	// IntermediateStorage is a required field
	IntermediateStorage *IntermediateStorage `locationName:"intermediateStorage" type:"structure" required:"true"`

	// A Lambda function that processes documents.
	//
	// Transformations is a required field
	Transformations []*Transformation `locationName:"transformations" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomTransformationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomTransformationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomTransformationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomTransformationConfiguration"}
	if s.IntermediateStorage == nil {
		invalidParams.Add(request.NewErrParamRequired("IntermediateStorage"))
	}
	if s.Transformations == nil {
		invalidParams.Add(request.NewErrParamRequired("Transformations"))
	}
	if s.Transformations != nil && len(s.Transformations) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Transformations", 1))
	}
	if s.IntermediateStorage != nil {
		if err := s.IntermediateStorage.Validate(); err != nil {
			invalidParams.AddNested("IntermediateStorage", err.(request.ErrInvalidParams))
		}
	}
	if s.Transformations != nil {
		for i, v := range s.Transformations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Transformations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntermediateStorage sets the IntermediateStorage field's value.
func (s *CustomTransformationConfiguration) SetIntermediateStorage(v *IntermediateStorage) *CustomTransformationConfiguration {
	s.IntermediateStorage = v
	return s
}

// SetTransformations sets the Transformations field's value.
func (s *CustomTransformationConfiguration) SetTransformations(v []*Transformation) *CustomTransformationConfiguration {
	s.Transformations = v
	return s
}

// Contains details about a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The time at which the data source was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The data deletion policy for the data source.
	DataDeletionPolicy *string `locationName:"dataDeletionPolicy" type:"string" enum:"DataDeletionPolicy"`

	// The connection configuration for the data source.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `locationName:"dataSourceConfiguration" type:"structure" required:"true"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The detailed reasons on the failure to delete a data source.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains details about the configuration of the server-side encryption.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// The status of the data source. The following statuses are possible:
	//
	//    * Available – The data source has been created and is ready for ingestion
	//    into the knowledge base.
	//
	//    * Deleting – The data source is being deleted.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceStatus"`

	// The time at which the data source was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration `locationName:"vectorIngestionConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DataSource) SetCreatedAt(v time.Time) *DataSource {
	s.CreatedAt = &v
	return s
}

// SetDataDeletionPolicy sets the DataDeletionPolicy field's value.
func (s *DataSource) SetDataDeletionPolicy(v string) *DataSource {
	s.DataDeletionPolicy = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *DataSource) SetDataSourceConfiguration(v *DataSourceConfiguration) *DataSource {
	s.DataSourceConfiguration = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSource) SetDataSourceId(v string) *DataSource {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataSource) SetDescription(v string) *DataSource {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *DataSource) SetFailureReasons(v []*string) *DataSource {
	s.FailureReasons = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DataSource) SetKnowledgeBaseId(v string) *DataSource {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSource) SetName(v string) *DataSource {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *DataSource) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *DataSource {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSource) SetStatus(v string) *DataSource {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSource) SetUpdatedAt(v time.Time) *DataSource {
	s.UpdatedAt = &v
	return s
}

// SetVectorIngestionConfiguration sets the VectorIngestionConfiguration field's value.
func (s *DataSource) SetVectorIngestionConfiguration(v *VectorIngestionConfiguration) *DataSource {
	s.VectorIngestionConfiguration = v
	return s
}

// The connection configuration for the data source.
type DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration information to connect to Confluence as your data source.
	//
	// Confluence data source connector is in preview release and is subject to
	// change.
	ConfluenceConfiguration *ConfluenceDataSourceConfiguration `locationName:"confluenceConfiguration" type:"structure"`

	// The configuration information to connect to Amazon S3 as your data source.
	S3Configuration *S3DataSourceConfiguration `locationName:"s3Configuration" type:"structure"`

	// The configuration information to connect to Salesforce as your data source.
	//
	// Salesforce data source connector is in preview release and is subject to
	// change.
	SalesforceConfiguration *SalesforceDataSourceConfiguration `locationName:"salesforceConfiguration" type:"structure"`

	// The configuration information to connect to SharePoint as your data source.
	//
	// SharePoint data source connector is in preview release and is subject to
	// change.
	SharePointConfiguration *SharePointDataSourceConfiguration `locationName:"sharePointConfiguration" type:"structure"`

	// The type of data source.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DataSourceType"`

	// The configuration of web URLs to crawl for your data source. You should be
	// authorized to crawl the URLs.
	//
	// Crawling web URLs as your data source is in preview release and is subject
	// to change.
	WebConfiguration *WebDataSourceConfiguration `locationName:"webConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.ConfluenceConfiguration != nil {
		if err := s.ConfluenceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ConfluenceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.SalesforceConfiguration != nil {
		if err := s.SalesforceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SalesforceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SharePointConfiguration != nil {
		if err := s.SharePointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SharePointConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.WebConfiguration != nil {
		if err := s.WebConfiguration.Validate(); err != nil {
			invalidParams.AddNested("WebConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfluenceConfiguration sets the ConfluenceConfiguration field's value.
func (s *DataSourceConfiguration) SetConfluenceConfiguration(v *ConfluenceDataSourceConfiguration) *DataSourceConfiguration {
	s.ConfluenceConfiguration = v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *DataSourceConfiguration) SetS3Configuration(v *S3DataSourceConfiguration) *DataSourceConfiguration {
	s.S3Configuration = v
	return s
}

// SetSalesforceConfiguration sets the SalesforceConfiguration field's value.
func (s *DataSourceConfiguration) SetSalesforceConfiguration(v *SalesforceDataSourceConfiguration) *DataSourceConfiguration {
	s.SalesforceConfiguration = v
	return s
}

// SetSharePointConfiguration sets the SharePointConfiguration field's value.
func (s *DataSourceConfiguration) SetSharePointConfiguration(v *SharePointDataSourceConfiguration) *DataSourceConfiguration {
	s.SharePointConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *DataSourceConfiguration) SetType(v string) *DataSourceConfiguration {
	s.Type = &v
	return s
}

// SetWebConfiguration sets the WebConfiguration field's value.
func (s *DataSourceConfiguration) SetWebConfiguration(v *WebDataSourceConfiguration) *DataSourceConfiguration {
	s.WebConfiguration = v
	return s
}

// Contains details about a data source.
type DataSourceSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which the data source belongs.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the data source.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceStatus"`

	// The time at which the data source was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSourceSummary) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DataSourceSummary) SetDataSourceId(v string) *DataSourceSummary {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataSourceSummary) SetDescription(v string) *DataSourceSummary {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DataSourceSummary) SetKnowledgeBaseId(v string) *DataSourceSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataSourceSummary) SetName(v string) *DataSourceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataSourceSummary) SetStatus(v string) *DataSourceSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DataSourceSummary) SetUpdatedAt(v time.Time) *DataSourceSummary {
	s.UpdatedAt = &v
	return s
}

type DeleteAgentActionGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the action group to delete.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `location:"uri" locationName:"actionGroupId" type:"string" required:"true"`

	// The unique identifier of the agent that the action group belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent that the action group belongs to.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentActionGroupInput"}
	if s.ActionGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupId"))
	}
	if s.ActionGroupId != nil && len(*s.ActionGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionGroupId", 1))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *DeleteAgentActionGroupInput) SetActionGroupId(v string) *DeleteAgentActionGroupInput {
	s.ActionGroupId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentActionGroupInput) SetAgentId(v string) *DeleteAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DeleteAgentActionGroupInput) SetAgentVersion(v string) *DeleteAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteAgentActionGroupInput) SetSkipResourceInUseCheck(v bool) *DeleteAgentActionGroupInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentActionGroupOutput) GoString() string {
	return s.String()
}

type DeleteAgentAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the alias to delete.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The unique identifier of the agent that the alias belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentAliasInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 10))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *DeleteAgentAliasInput) SetAgentAliasId(v string) *DeleteAgentAliasInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentAliasInput) SetAgentId(v string) *DeleteAgentAliasInput {
	s.AgentId = &v
	return s
}

type DeleteAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the alias that was deleted.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The status of the alias.
	//
	// AgentAliasStatus is a required field
	AgentAliasStatus *string `locationName:"agentAliasStatus" type:"string" required:"true" enum:"AgentAliasStatus"`

	// The unique identifier of the agent that the alias belongs to.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *DeleteAgentAliasOutput) SetAgentAliasId(v string) *DeleteAgentAliasOutput {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasStatus sets the AgentAliasStatus field's value.
func (s *DeleteAgentAliasOutput) SetAgentAliasStatus(v string) *DeleteAgentAliasOutput {
	s.AgentAliasStatus = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentAliasOutput) SetAgentId(v string) *DeleteAgentAliasOutput {
	s.AgentId = &v
	return s
}

type DeleteAgentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent to delete.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentInput) SetAgentId(v string) *DeleteAgentInput {
	s.AgentId = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteAgentInput) SetSkipResourceInUseCheck(v bool) *DeleteAgentInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteAgentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent that was deleted.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The status of the agent.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentOutput) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentOutput) SetAgentId(v string) *DeleteAgentOutput {
	s.AgentId = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *DeleteAgentOutput) SetAgentStatus(v string) *DeleteAgentOutput {
	s.AgentStatus = &v
	return s
}

type DeleteAgentVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent that the version belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent to delete.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAgentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAgentVersionInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentVersionInput) SetAgentId(v string) *DeleteAgentVersionInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DeleteAgentVersionInput) SetAgentVersion(v string) *DeleteAgentVersionInput {
	s.AgentVersion = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteAgentVersionInput) SetSkipResourceInUseCheck(v bool) *DeleteAgentVersionInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteAgentVersionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent that the version belongs to.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The status of the agent version.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version that was deleted.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAgentVersionOutput) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *DeleteAgentVersionOutput) SetAgentId(v string) *DeleteAgentVersionOutput {
	s.AgentId = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *DeleteAgentVersionOutput) SetAgentStatus(v string) *DeleteAgentVersionOutput {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DeleteAgentVersionOutput) SetAgentVersion(v string) *DeleteAgentVersionOutput {
	s.AgentVersion = &v
	return s
}

type DeleteDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the data source to delete.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the knowledge base from which to delete the data
	// source.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataSourceInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceInput) SetDataSourceId(v string) *DeleteDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteDataSourceInput) SetKnowledgeBaseId(v string) *DeleteDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

type DeleteDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source that was deleted.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the knowledge base to which the data source that
	// was deleted belonged.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The status of the data source.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"DataSourceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *DeleteDataSourceOutput) SetDataSourceId(v string) *DeleteDataSourceOutput {
	s.DataSourceId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteDataSourceOutput) SetKnowledgeBaseId(v string) *DeleteDataSourceOutput {
	s.KnowledgeBaseId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteDataSourceOutput) SetStatus(v string) *DeleteDataSourceOutput {
	s.Status = &v
	return s
}

type DeleteFlowAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the alias to be deleted.
	//
	// AliasIdentifier is a required field
	AliasIdentifier *string `location:"uri" locationName:"aliasIdentifier" type:"string" required:"true"`

	// The unique identifier of the flow that the alias belongs to.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowAliasInput"}
	if s.AliasIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasIdentifier"))
	}
	if s.AliasIdentifier != nil && len(*s.AliasIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasIdentifier", 1))
	}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasIdentifier sets the AliasIdentifier field's value.
func (s *DeleteFlowAliasInput) SetAliasIdentifier(v string) *DeleteFlowAliasInput {
	s.AliasIdentifier = &v
	return s
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *DeleteFlowAliasInput) SetFlowIdentifier(v string) *DeleteFlowAliasInput {
	s.FlowIdentifier = &v
	return s
}

type DeleteFlowAliasOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the flow that the alias belongs to.
	//
	// FlowId is a required field
	FlowId *string `locationName:"flowId" type:"string" required:"true"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowAliasOutput) GoString() string {
	return s.String()
}

// SetFlowId sets the FlowId field's value.
func (s *DeleteFlowAliasOutput) SetFlowId(v string) *DeleteFlowAliasOutput {
	s.FlowId = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeleteFlowAliasOutput) SetId(v string) *DeleteFlowAliasOutput {
	s.Id = &v
	return s
}

type DeleteFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the flow.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowInput"}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *DeleteFlowInput) SetFlowIdentifier(v string) *DeleteFlowInput {
	s.FlowIdentifier = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteFlowInput) SetSkipResourceInUseCheck(v bool) *DeleteFlowInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteFlowOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteFlowOutput) SetId(v string) *DeleteFlowOutput {
	s.Id = &v
	return s
}

type DeleteFlowVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the flow whose version that you want to delete
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// The version of the flow that you want to delete.
	//
	// FlowVersion is a required field
	FlowVersion *string `location:"uri" locationName:"flowVersion" type:"string" required:"true"`

	// By default, this value is false and deletion is stopped if the resource is
	// in use. If you set it to true, the resource will be deleted even if the resource
	// is in use.
	SkipResourceInUseCheck *bool `location:"querystring" locationName:"skipResourceInUseCheck" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFlowVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFlowVersionInput"}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}
	if s.FlowVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowVersion"))
	}
	if s.FlowVersion != nil && len(*s.FlowVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *DeleteFlowVersionInput) SetFlowIdentifier(v string) *DeleteFlowVersionInput {
	s.FlowIdentifier = &v
	return s
}

// SetFlowVersion sets the FlowVersion field's value.
func (s *DeleteFlowVersionInput) SetFlowVersion(v string) *DeleteFlowVersionInput {
	s.FlowVersion = &v
	return s
}

// SetSkipResourceInUseCheck sets the SkipResourceInUseCheck field's value.
func (s *DeleteFlowVersionInput) SetSkipResourceInUseCheck(v bool) *DeleteFlowVersionInput {
	s.SkipResourceInUseCheck = &v
	return s
}

type DeleteFlowVersionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The version of the flow being deleted.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFlowVersionOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeleteFlowVersionOutput) SetId(v string) *DeleteFlowVersionOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeleteFlowVersionOutput) SetVersion(v string) *DeleteFlowVersionOutput {
	s.Version = &v
	return s
}

type DeleteKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the knowledge base to delete.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteKnowledgeBaseInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteKnowledgeBaseInput) SetKnowledgeBaseId(v string) *DeleteKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type DeleteKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the knowledge base that was deleted.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The status of the knowledge base and whether it has been successfully deleted.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DeleteKnowledgeBaseOutput) SetKnowledgeBaseId(v string) *DeleteKnowledgeBaseOutput {
	s.KnowledgeBaseId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeleteKnowledgeBaseOutput) SetStatus(v string) *DeleteKnowledgeBaseOutput {
	s.Status = &v
	return s
}

type DeletePromptInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the prompt.
	//
	// PromptIdentifier is a required field
	PromptIdentifier *string `location:"uri" locationName:"promptIdentifier" type:"string" required:"true"`

	// The version of the prompt to delete.
	PromptVersion *string `location:"querystring" locationName:"promptVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePromptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePromptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePromptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePromptInput"}
	if s.PromptIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptIdentifier"))
	}
	if s.PromptIdentifier != nil && len(*s.PromptIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PromptIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPromptIdentifier sets the PromptIdentifier field's value.
func (s *DeletePromptInput) SetPromptIdentifier(v string) *DeletePromptInput {
	s.PromptIdentifier = &v
	return s
}

// SetPromptVersion sets the PromptVersion field's value.
func (s *DeletePromptInput) SetPromptVersion(v string) *DeletePromptInput {
	s.PromptVersion = &v
	return s
}

type DeletePromptOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the prompt that was deleted.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The version of the prompt that was deleted.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePromptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePromptOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DeletePromptOutput) SetId(v string) *DeletePromptOutput {
	s.Id = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DeletePromptOutput) SetVersion(v string) *DeletePromptOutput {
	s.Version = &v
	return s
}

type DisassociateAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent from which to disassociate the knowledge
	// base.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent from which to disassociate the knowledge base.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// The unique identifier of the knowledge base to disassociate.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *DisassociateAgentKnowledgeBaseInput) SetAgentId(v string) *DisassociateAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *DisassociateAgentKnowledgeBaseInput) SetAgentVersion(v string) *DisassociateAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *DisassociateAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *DisassociateAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type DisassociateAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// The configuration details for the embeddings model.
type EmbeddingModelConfiguration struct {
	_ struct{} `type:"structure"`

	// The vector configuration details on the Bedrock embeddings model.
	BedrockEmbeddingModelConfiguration *BedrockEmbeddingModelConfiguration `locationName:"bedrockEmbeddingModelConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddingModelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EmbeddingModelConfiguration) GoString() string {
	return s.String()
}

// SetBedrockEmbeddingModelConfiguration sets the BedrockEmbeddingModelConfiguration field's value.
func (s *EmbeddingModelConfiguration) SetBedrockEmbeddingModelConfiguration(v *BedrockEmbeddingModelConfiguration) *EmbeddingModelConfiguration {
	s.BedrockEmbeddingModelConfiguration = v
	return s
}

// Configurations for when you choose fixed-size chunking. If you set the chunkingStrategy
// as NONE, exclude this field.
type FixedSizeChunkingConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens to include in a chunk.
	//
	// MaxTokens is a required field
	MaxTokens *int64 `locationName:"maxTokens" min:"1" type:"integer" required:"true"`

	// The percentage of overlap between adjacent chunks of a data source.
	//
	// OverlapPercentage is a required field
	OverlapPercentage *int64 `locationName:"overlapPercentage" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedSizeChunkingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedSizeChunkingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedSizeChunkingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FixedSizeChunkingConfiguration"}
	if s.MaxTokens == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxTokens"))
	}
	if s.MaxTokens != nil && *s.MaxTokens < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxTokens", 1))
	}
	if s.OverlapPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("OverlapPercentage"))
	}
	if s.OverlapPercentage != nil && *s.OverlapPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("OverlapPercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxTokens sets the MaxTokens field's value.
func (s *FixedSizeChunkingConfiguration) SetMaxTokens(v int64) *FixedSizeChunkingConfiguration {
	s.MaxTokens = &v
	return s
}

// SetOverlapPercentage sets the OverlapPercentage field's value.
func (s *FixedSizeChunkingConfiguration) SetOverlapPercentage(v int64) *FixedSizeChunkingConfiguration {
	s.OverlapPercentage = &v
	return s
}

// Contains information about a version that the alias maps to.
type FlowAliasRoutingConfigurationListItem struct {
	_ struct{} `type:"structure"`

	// The version that the alias maps to.
	FlowVersion *string `locationName:"flowVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowAliasRoutingConfigurationListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowAliasRoutingConfigurationListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowAliasRoutingConfigurationListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowAliasRoutingConfigurationListItem"}
	if s.FlowVersion != nil && len(*s.FlowVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowVersion sets the FlowVersion field's value.
func (s *FlowAliasRoutingConfigurationListItem) SetFlowVersion(v string) *FlowAliasRoutingConfigurationListItem {
	s.FlowVersion = &v
	return s
}

// Contains information about an alias of a flow.
//
// This data type is used in the following API operations:
//
//   - ListFlowAliases response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowAliases.html#API_agent_ListFlowAliases_ResponseSyntax)
type FlowAliasSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow alias.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the alias was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A description of the alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow.
	//
	// FlowId is a required field
	FlowId *string `locationName:"flowId" type:"string" required:"true"`

	// The unique identifier of the alias of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the alias.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of configurations about the versions that the alias maps to. Currently,
	// you can only specify one.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*FlowAliasRoutingConfigurationListItem `locationName:"routingConfiguration" min:"1" type:"list" required:"true"`

	// The time at which the alias was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowAliasSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowAliasSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FlowAliasSummary) SetArn(v string) *FlowAliasSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FlowAliasSummary) SetCreatedAt(v time.Time) *FlowAliasSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FlowAliasSummary) SetDescription(v string) *FlowAliasSummary {
	s.Description = &v
	return s
}

// SetFlowId sets the FlowId field's value.
func (s *FlowAliasSummary) SetFlowId(v string) *FlowAliasSummary {
	s.FlowId = &v
	return s
}

// SetId sets the Id field's value.
func (s *FlowAliasSummary) SetId(v string) *FlowAliasSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *FlowAliasSummary) SetName(v string) *FlowAliasSummary {
	s.Name = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *FlowAliasSummary) SetRoutingConfiguration(v []*FlowAliasRoutingConfigurationListItem) *FlowAliasSummary {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FlowAliasSummary) SetUpdatedAt(v time.Time) *FlowAliasSummary {
	s.UpdatedAt = &v
	return s
}

// Defines a condition in the condition node.
type FlowCondition struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Defines the condition. You must refer to at least one of the inputs in the
	// condition. For more information, expand the Condition node section in Node
	// types in prompt flows (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html#flows-nodes).
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FlowCondition's
	// String and GoString methods.
	Expression *string `locationName:"expression" min:"1" type:"string" sensitive:"true"`

	// A name for the condition that you can reference.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowCondition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowCondition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowCondition"}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *FlowCondition) SetExpression(v string) *FlowCondition {
	s.Expression = &v
	return s
}

// SetName sets the Name field's value.
func (s *FlowCondition) SetName(v string) *FlowCondition {
	s.Name = &v
	return s
}

// The configuration of a connection between a condition node and another node.
type FlowConditionalConnectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The condition that triggers this connection. For more information about how
	// to write conditions, see the Condition node type in the Node types (https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html)
	// topic in the Amazon Bedrock User Guide.
	//
	// Condition is a required field
	Condition *string `locationName:"condition" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowConditionalConnectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowConditionalConnectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowConditionalConnectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowConditionalConnectionConfiguration"}
	if s.Condition == nil {
		invalidParams.Add(request.NewErrParamRequired("Condition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *FlowConditionalConnectionConfiguration) SetCondition(v string) *FlowConditionalConnectionConfiguration {
	s.Condition = &v
	return s
}

// Contains information about a connection between two nodes in the flow.
type FlowConnection struct {
	_ struct{} `type:"structure"`

	// The configuration of the connection.
	Configuration *FlowConnectionConfiguration `locationName:"configuration" type:"structure"`

	// A name for the connection that you can reference.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The node that the connection starts at.
	//
	// Source is a required field
	Source *string `locationName:"source" type:"string" required:"true"`

	// The node that the connection ends at.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true"`

	// Whether the source node that the connection begins from is a condition node
	// (Conditional) or not (Data).
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FlowConnectionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowConnection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowConnection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowConnection"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *FlowConnection) SetConfiguration(v *FlowConnectionConfiguration) *FlowConnection {
	s.Configuration = v
	return s
}

// SetName sets the Name field's value.
func (s *FlowConnection) SetName(v string) *FlowConnection {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *FlowConnection) SetSource(v string) *FlowConnection {
	s.Source = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *FlowConnection) SetTarget(v string) *FlowConnection {
	s.Target = &v
	return s
}

// SetType sets the Type field's value.
func (s *FlowConnection) SetType(v string) *FlowConnection {
	s.Type = &v
	return s
}

// The configuration of the connection.
type FlowConnectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of a connection originating from a Condition node.
	Conditional *FlowConditionalConnectionConfiguration `locationName:"conditional" type:"structure"`

	// The configuration of a connection originating from a node that isn't a Condition
	// node.
	Data *FlowDataConnectionConfiguration `locationName:"data" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowConnectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowConnectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowConnectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowConnectionConfiguration"}
	if s.Conditional != nil {
		if err := s.Conditional.Validate(); err != nil {
			invalidParams.AddNested("Conditional", err.(request.ErrInvalidParams))
		}
	}
	if s.Data != nil {
		if err := s.Data.Validate(); err != nil {
			invalidParams.AddNested("Data", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditional sets the Conditional field's value.
func (s *FlowConnectionConfiguration) SetConditional(v *FlowConditionalConnectionConfiguration) *FlowConnectionConfiguration {
	s.Conditional = v
	return s
}

// SetData sets the Data field's value.
func (s *FlowConnectionConfiguration) SetData(v *FlowDataConnectionConfiguration) *FlowConnectionConfiguration {
	s.Data = v
	return s
}

// The configuration of a connection originating from a node that isn't a Condition
// node.
type FlowDataConnectionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the output in the source node that the connection begins from.
	//
	// SourceOutput is a required field
	SourceOutput *string `locationName:"sourceOutput" type:"string" required:"true"`

	// The name of the input in the target node that the connection ends at.
	//
	// TargetInput is a required field
	TargetInput *string `locationName:"targetInput" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowDataConnectionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowDataConnectionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowDataConnectionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowDataConnectionConfiguration"}
	if s.SourceOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceOutput"))
	}
	if s.TargetInput == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetInput"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceOutput sets the SourceOutput field's value.
func (s *FlowDataConnectionConfiguration) SetSourceOutput(v string) *FlowDataConnectionConfiguration {
	s.SourceOutput = &v
	return s
}

// SetTargetInput sets the TargetInput field's value.
func (s *FlowDataConnectionConfiguration) SetTargetInput(v string) *FlowDataConnectionConfiguration {
	s.TargetInput = &v
	return s
}

// The definition of the nodes and connections between nodes in the flow.
type FlowDefinition struct {
	_ struct{} `type:"structure"`

	// An array of connection definitions in the flow.
	Connections []*FlowConnection `locationName:"connections" type:"list"`

	// An array of node definitions in the flow.
	//
	// Nodes is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FlowDefinition's
	// String and GoString methods.
	Nodes []*FlowNode `locationName:"nodes" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowDefinition"}
	if s.Connections != nil {
		for i, v := range s.Connections {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Connections", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Nodes != nil {
		for i, v := range s.Nodes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Nodes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnections sets the Connections field's value.
func (s *FlowDefinition) SetConnections(v []*FlowConnection) *FlowDefinition {
	s.Connections = v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *FlowDefinition) SetNodes(v []*FlowNode) *FlowDefinition {
	s.Nodes = v
	return s
}

// Contains configurations about a node in the flow.
type FlowNode struct {
	_ struct{} `type:"structure"`

	// Contains configurations for the node.
	Configuration *FlowNodeConfiguration `locationName:"configuration" type:"structure"`

	// An array of objects, each of which contains information about an input into
	// the node.
	Inputs []*FlowNodeInput_ `locationName:"inputs" type:"list"`

	// A name for the node.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of objects, each of which contains information about an output from
	// the node.
	Outputs []*FlowNodeOutput_ `locationName:"outputs" type:"list"`

	// The type of node. This value must match the name of the key that you provide
	// in the configuration you provide in the FlowNodeConfiguration field.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FlowNodeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowNode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowNode"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.Inputs != nil {
		for i, v := range s.Inputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Inputs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguration sets the Configuration field's value.
func (s *FlowNode) SetConfiguration(v *FlowNodeConfiguration) *FlowNode {
	s.Configuration = v
	return s
}

// SetInputs sets the Inputs field's value.
func (s *FlowNode) SetInputs(v []*FlowNodeInput_) *FlowNode {
	s.Inputs = v
	return s
}

// SetName sets the Name field's value.
func (s *FlowNode) SetName(v string) *FlowNode {
	s.Name = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *FlowNode) SetOutputs(v []*FlowNodeOutput_) *FlowNode {
	s.Outputs = v
	return s
}

// SetType sets the Type field's value.
func (s *FlowNode) SetType(v string) *FlowNode {
	s.Type = &v
	return s
}

// Contains configurations for a node in your flow. For more information, see
// Node types in Amazon Bedrock works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type FlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for an agent node in your flow. Invokes an alias
	// of an agent and returns the response.
	Agent *AgentFlowNodeConfiguration `locationName:"agent" type:"structure"`

	// Contains configurations for a collector node in your flow. Collects an iteration
	// of inputs and consolidates them into an array of outputs.
	Collector *CollectorFlowNodeConfiguration `locationName:"collector" type:"structure"`

	// Contains configurations for a Condition node in your flow. Defines conditions
	// that lead to different branches of the flow.
	Condition *ConditionFlowNodeConfiguration `locationName:"condition" type:"structure"`

	// Contains configurations for an input flow node in your flow. The first node
	// in the flow. inputs can't be specified for this node.
	Input *InputFlowNodeConfiguration `locationName:"input" type:"structure"`

	// Contains configurations for an iterator node in your flow. Takes an input
	// that is an array and iteratively sends each item of the array as an output
	// to the following node. The size of the array is also returned in the output.
	//
	// The output flow node at the end of the flow iteration will return a response
	// for each member of the array. To return only one response, you can include
	// a collector node downstream from the iterator node.
	Iterator *IteratorFlowNodeConfiguration `locationName:"iterator" type:"structure"`

	// Contains configurations for a knowledge base node in your flow. Queries a
	// knowledge base and returns the retrieved results or generated response.
	KnowledgeBase *KnowledgeBaseFlowNodeConfiguration `locationName:"knowledgeBase" type:"structure"`

	// Contains configurations for a Lambda function node in your flow. Invokes
	// an Lambda function.
	LambdaFunction *LambdaFunctionFlowNodeConfiguration `locationName:"lambdaFunction" type:"structure"`

	// Contains configurations for a Lex node in your flow. Invokes an Amazon Lex
	// bot to identify the intent of the input and return the intent as the output.
	Lex *LexFlowNodeConfiguration `locationName:"lex" type:"structure"`

	// Contains configurations for an output flow node in your flow. The last node
	// in the flow. outputs can't be specified for this node.
	Output *OutputFlowNodeConfiguration `locationName:"output" type:"structure"`

	// Contains configurations for a prompt node in your flow. Runs a prompt and
	// generates the model response as the output. You can use a prompt from Prompt
	// management or you can configure one in this node.
	Prompt *PromptFlowNodeConfiguration `locationName:"prompt" type:"structure"`

	// Contains configurations for a Retrieval node in your flow. Retrieves data
	// from an Amazon S3 location and returns it as the output.
	Retrieval *RetrievalFlowNodeConfiguration `locationName:"retrieval" type:"structure"`

	// Contains configurations for a Storage node in your flow. Stores an input
	// in an Amazon S3 location.
	Storage *StorageFlowNodeConfiguration `locationName:"storage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowNodeConfiguration"}
	if s.Agent != nil {
		if err := s.Agent.Validate(); err != nil {
			invalidParams.AddNested("Agent", err.(request.ErrInvalidParams))
		}
	}
	if s.Condition != nil {
		if err := s.Condition.Validate(); err != nil {
			invalidParams.AddNested("Condition", err.(request.ErrInvalidParams))
		}
	}
	if s.KnowledgeBase != nil {
		if err := s.KnowledgeBase.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeBase", err.(request.ErrInvalidParams))
		}
	}
	if s.LambdaFunction != nil {
		if err := s.LambdaFunction.Validate(); err != nil {
			invalidParams.AddNested("LambdaFunction", err.(request.ErrInvalidParams))
		}
	}
	if s.Lex != nil {
		if err := s.Lex.Validate(); err != nil {
			invalidParams.AddNested("Lex", err.(request.ErrInvalidParams))
		}
	}
	if s.Prompt != nil {
		if err := s.Prompt.Validate(); err != nil {
			invalidParams.AddNested("Prompt", err.(request.ErrInvalidParams))
		}
	}
	if s.Retrieval != nil {
		if err := s.Retrieval.Validate(); err != nil {
			invalidParams.AddNested("Retrieval", err.(request.ErrInvalidParams))
		}
	}
	if s.Storage != nil {
		if err := s.Storage.Validate(); err != nil {
			invalidParams.AddNested("Storage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgent sets the Agent field's value.
func (s *FlowNodeConfiguration) SetAgent(v *AgentFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Agent = v
	return s
}

// SetCollector sets the Collector field's value.
func (s *FlowNodeConfiguration) SetCollector(v *CollectorFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Collector = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *FlowNodeConfiguration) SetCondition(v *ConditionFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Condition = v
	return s
}

// SetInput sets the Input field's value.
func (s *FlowNodeConfiguration) SetInput(v *InputFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Input = v
	return s
}

// SetIterator sets the Iterator field's value.
func (s *FlowNodeConfiguration) SetIterator(v *IteratorFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Iterator = v
	return s
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *FlowNodeConfiguration) SetKnowledgeBase(v *KnowledgeBaseFlowNodeConfiguration) *FlowNodeConfiguration {
	s.KnowledgeBase = v
	return s
}

// SetLambdaFunction sets the LambdaFunction field's value.
func (s *FlowNodeConfiguration) SetLambdaFunction(v *LambdaFunctionFlowNodeConfiguration) *FlowNodeConfiguration {
	s.LambdaFunction = v
	return s
}

// SetLex sets the Lex field's value.
func (s *FlowNodeConfiguration) SetLex(v *LexFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Lex = v
	return s
}

// SetOutput sets the Output field's value.
func (s *FlowNodeConfiguration) SetOutput(v *OutputFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Output = v
	return s
}

// SetPrompt sets the Prompt field's value.
func (s *FlowNodeConfiguration) SetPrompt(v *PromptFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Prompt = v
	return s
}

// SetRetrieval sets the Retrieval field's value.
func (s *FlowNodeConfiguration) SetRetrieval(v *RetrievalFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Retrieval = v
	return s
}

// SetStorage sets the Storage field's value.
func (s *FlowNodeConfiguration) SetStorage(v *StorageFlowNodeConfiguration) *FlowNodeConfiguration {
	s.Storage = v
	return s
}

// Contains configurations for an input to a node.
type FlowNodeInput_ struct {
	_ struct{} `type:"structure"`

	// An expression that formats the input for the node. For an explanation of
	// how to create expressions, see Expressions in Prompt flows in Amazon Bedrock
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html).
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FlowNodeInput_'s
	// String and GoString methods.
	//
	// Expression is a required field
	Expression *string `locationName:"expression" min:"1" type:"string" required:"true" sensitive:"true"`

	// A name for the input that you can reference.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The data type of the input. If the input doesn't match this type at runtime,
	// a validation error will be thrown.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FlowNodeIODataType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNodeInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNodeInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowNodeInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowNodeInput_"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExpression sets the Expression field's value.
func (s *FlowNodeInput_) SetExpression(v string) *FlowNodeInput_ {
	s.Expression = &v
	return s
}

// SetName sets the Name field's value.
func (s *FlowNodeInput_) SetName(v string) *FlowNodeInput_ {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *FlowNodeInput_) SetType(v string) *FlowNodeInput_ {
	s.Type = &v
	return s
}

// Contains configurations for an output from a node.
type FlowNodeOutput_ struct {
	_ struct{} `type:"structure"`

	// A name for the output that you can reference.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The data type of the output. If the output doesn't match this type at runtime,
	// a validation error will be thrown.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FlowNodeIODataType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNodeOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowNodeOutput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowNodeOutput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowNodeOutput_"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *FlowNodeOutput_) SetName(v string) *FlowNodeOutput_ {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *FlowNodeOutput_) SetType(v string) *FlowNodeOutput_ {
	s.Type = &v
	return s
}

// Contains the definition of a flow.
type FlowSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A description of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the flow. The following statuses are possible:
	//
	//    * NotPrepared – The flow has been created or updated, but hasn't been
	//    prepared. If you just created the flow, you can't test it. If you updated
	//    the flow, the DRAFT version won't contain the latest changes for testing.
	//    Send a PrepareFlow (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html)
	//    request to package the latest changes into the DRAFT version.
	//
	//    * Preparing – The flow is being prepared so that the DRAFT version contains
	//    the latest changes for testing.
	//
	//    * Prepared – The flow is prepared and the DRAFT version contains the
	//    latest changes for testing.
	//
	//    * Failed – The last API operation that you invoked on the flow failed.
	//    Send a GetFlow (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html)
	//    request and check the error message in the validations field.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`

	// The time at which the flow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The latest version of the flow.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FlowSummary) SetArn(v string) *FlowSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FlowSummary) SetCreatedAt(v time.Time) *FlowSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *FlowSummary) SetDescription(v string) *FlowSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *FlowSummary) SetId(v string) *FlowSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *FlowSummary) SetName(v string) *FlowSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlowSummary) SetStatus(v string) *FlowSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FlowSummary) SetUpdatedAt(v time.Time) *FlowSummary {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *FlowSummary) SetVersion(v string) *FlowSummary {
	s.Version = &v
	return s
}

// Contains information about validation of the flow.
//
// This data type is used in the following API operations:
//
//   - GetFlow response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html#API_agent_GetFlow_ResponseSyntax)
//
//   - GetFlowVersion response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowVersion.html#API_agent_GetFlowVersion_ResponseSyntax)
type FlowValidation struct {
	_ struct{} `type:"structure"`

	// A message describing the validation error.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The severity of the issue described in the message.
	//
	// Severity is a required field
	Severity *string `locationName:"severity" type:"string" required:"true" enum:"FlowValidationSeverity"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowValidation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowValidation) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *FlowValidation) SetMessage(v string) *FlowValidation {
	s.Message = &v
	return s
}

// SetSeverity sets the Severity field's value.
func (s *FlowValidation) SetSeverity(v string) *FlowValidation {
	s.Severity = &v
	return s
}

// Contains information about the flow version.
//
// This data type is used in the following API operations:
//
//   - ListFlowVersions response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListFlowVersions.html#API_agent_ListFlowVersions_ResponseSyntax)
type FlowVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow that the version belongs to.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at the flow version was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`

	// The version of the flow.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlowVersionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *FlowVersionSummary) SetArn(v string) *FlowVersionSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FlowVersionSummary) SetCreatedAt(v time.Time) *FlowVersionSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *FlowVersionSummary) SetId(v string) *FlowVersionSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FlowVersionSummary) SetStatus(v string) *FlowVersionSummary {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *FlowVersionSummary) SetVersion(v string) *FlowVersionSummary {
	s.Version = &v
	return s
}

// Defines parameters that the agent needs to invoke from the user to complete
// the function. Corresponds to an action in an action group.
//
// This data type is used in the following API operations:
//
//   - CreateAgentActionGroup request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax)
//
//   - CreateAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax)
//
//   - UpdateAgentActionGroup request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax)
//
//   - UpdateAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax)
//
//   - GetAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax)
type Function struct {
	_ struct{} `type:"structure"`

	// A description of the function and its purpose.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A name for the function.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The parameters that the agent elicits from the user to fulfill the function.
	Parameters map[string]*ParameterDetail `locationName:"parameters" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Function) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Function) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Function) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Function"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *Function) SetDescription(v string) *Function {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Function) SetName(v string) *Function {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *Function) SetParameters(v map[string]*ParameterDetail) *Function {
	s.Parameters = v
	return s
}

// Defines functions that each define parameters that the agent needs to invoke
// from the user. Each function represents an action in an action group.
//
// This data type is used in the following API operations:
//
//   - CreateAgentActionGroup request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax)
//
//   - CreateAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax)
//
//   - UpdateAgentActionGroup request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax)
//
//   - UpdateAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax)
//
//   - GetAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax)
type FunctionSchema struct {
	_ struct{} `type:"structure"`

	// A list of functions that each define an action in the action group.
	Functions []*Function `locationName:"functions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FunctionSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionSchema"}
	if s.Functions != nil {
		for i, v := range s.Functions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Functions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctions sets the Functions field's value.
func (s *FunctionSchema) SetFunctions(v []*Function) *FunctionSchema {
	s.Functions = v
	return s
}

type GetAgentActionGroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the action group for which to get information.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `location:"uri" locationName:"actionGroupId" type:"string" required:"true"`

	// The unique identifier of the agent that the action group belongs to.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent that the action group belongs to.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentActionGroupInput"}
	if s.ActionGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupId"))
	}
	if s.ActionGroupId != nil && len(*s.ActionGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionGroupId", 1))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *GetAgentActionGroupInput) SetActionGroupId(v string) *GetAgentActionGroupInput {
	s.ActionGroupId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentActionGroupInput) SetAgentId(v string) *GetAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentActionGroupInput) SetAgentVersion(v string) *GetAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

type GetAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the action group.
	//
	// AgentActionGroup is a required field
	AgentActionGroup *AgentActionGroup `locationName:"agentActionGroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentActionGroupOutput) GoString() string {
	return s.String()
}

// SetAgentActionGroup sets the AgentActionGroup field's value.
func (s *GetAgentActionGroupOutput) SetAgentActionGroup(v *AgentActionGroup) *GetAgentActionGroupOutput {
	s.AgentActionGroup = v
	return s
}

type GetAgentAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the alias for which to get information.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// The unique identifier of the agent to which the alias to get information
	// belongs.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentAliasInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 10))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *GetAgentAliasInput) SetAgentAliasId(v string) *GetAgentAliasInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentAliasInput) SetAgentId(v string) *GetAgentAliasInput {
	s.AgentId = &v
	return s
}

type GetAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the alias.
	//
	// AgentAlias is a required field
	AgentAlias *AgentAlias `locationName:"agentAlias" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAlias sets the AgentAlias field's value.
func (s *GetAgentAliasOutput) SetAgentAlias(v *AgentAlias) *GetAgentAliasOutput {
	s.AgentAlias = v
	return s
}

type GetAgentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentInput) SetAgentId(v string) *GetAgentInput {
	s.AgentId = &v
	return s
}

type GetAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent with which the knowledge base is associated.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent with which the knowledge base is associated.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The unique identifier of the knowledge base associated with the agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentKnowledgeBaseInput) SetAgentId(v string) *GetAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentKnowledgeBaseInput) SetAgentVersion(v string) *GetAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *GetAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about a knowledge base attached to an agent.
	//
	// AgentKnowledgeBase is a required field
	AgentKnowledgeBase *AgentKnowledgeBase `locationName:"agentKnowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBase sets the AgentKnowledgeBase field's value.
func (s *GetAgentKnowledgeBaseOutput) SetAgentKnowledgeBase(v *AgentKnowledgeBase) *GetAgentKnowledgeBaseOutput {
	s.AgentKnowledgeBase = v
	return s
}

type GetAgentOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the agent.
	//
	// Agent is a required field
	Agent *Agent `locationName:"agent" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentOutput) GoString() string {
	return s.String()
}

// SetAgent sets the Agent field's value.
func (s *GetAgentOutput) SetAgent(v *Agent) *GetAgentOutput {
	s.Agent = v
	return s
}

type GetAgentVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAgentVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAgentVersionInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *GetAgentVersionInput) SetAgentId(v string) *GetAgentVersionInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentVersionInput) SetAgentVersion(v string) *GetAgentVersionInput {
	s.AgentVersion = &v
	return s
}

type GetAgentVersionOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *AgentVersion `locationName:"agentVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAgentVersionOutput) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *GetAgentVersionOutput) SetAgentVersion(v *AgentVersion) *GetAgentVersionOutput {
	s.AgentVersion = v
	return s
}

type GetDataSourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the knowledge base that the data source was added
	// to.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataSourceInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetDataSourceInput) SetDataSourceId(v string) *GetDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetDataSourceInput) SetKnowledgeBaseId(v string) *GetDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the data source.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *GetDataSourceOutput) SetDataSource(v *DataSource) *GetDataSourceOutput {
	s.DataSource = v
	return s
}

type GetFlowAliasInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the alias for which to retrieve information.
	//
	// AliasIdentifier is a required field
	AliasIdentifier *string `location:"uri" locationName:"aliasIdentifier" type:"string" required:"true"`

	// The unique identifier of the flow that the alias belongs to.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFlowAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFlowAliasInput"}
	if s.AliasIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasIdentifier"))
	}
	if s.AliasIdentifier != nil && len(*s.AliasIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasIdentifier", 1))
	}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasIdentifier sets the AliasIdentifier field's value.
func (s *GetFlowAliasInput) SetAliasIdentifier(v string) *GetFlowAliasInput {
	s.AliasIdentifier = &v
	return s
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *GetFlowAliasInput) SetFlowIdentifier(v string) *GetFlowAliasInput {
	s.FlowIdentifier = &v
	return s
}

type GetFlowAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow that the alias belongs to.
	//
	// FlowId is a required field
	FlowId *string `locationName:"flowId" type:"string" required:"true"`

	// The unique identifier of the alias of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow alias.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains information about the version that the alias is mapped to.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*FlowAliasRoutingConfigurationListItem `locationName:"routingConfiguration" min:"1" type:"list" required:"true"`

	// The time at which the flow alias was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowAliasOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFlowAliasOutput) SetArn(v string) *GetFlowAliasOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetFlowAliasOutput) SetCreatedAt(v time.Time) *GetFlowAliasOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFlowAliasOutput) SetDescription(v string) *GetFlowAliasOutput {
	s.Description = &v
	return s
}

// SetFlowId sets the FlowId field's value.
func (s *GetFlowAliasOutput) SetFlowId(v string) *GetFlowAliasOutput {
	s.FlowId = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFlowAliasOutput) SetId(v string) *GetFlowAliasOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFlowAliasOutput) SetName(v string) *GetFlowAliasOutput {
	s.Name = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *GetFlowAliasOutput) SetRoutingConfiguration(v []*FlowAliasRoutingConfigurationListItem) *GetFlowAliasOutput {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetFlowAliasOutput) SetUpdatedAt(v time.Time) *GetFlowAliasOutput {
	s.UpdatedAt = &v
	return s
}

type GetFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the flow.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFlowInput"}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *GetFlowInput) SetFlowIdentifier(v string) *GetFlowInput {
	s.FlowIdentifier = &v
	return s
}

type GetFlowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted
	// with.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The definition of the nodes and connections between the nodes in the flow.
	Definition *FlowDefinition `locationName:"definition" type:"structure"`

	// The description of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// a flow. For more information, see Create a service row for flows (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
	// in the Amazon Bedrock User Guide.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the flow. The following statuses are possible:
	//
	//    * NotPrepared – The flow has been created or updated, but hasn't been
	//    prepared. If you just created the flow, you can't test it. If you updated
	//    the flow, the DRAFT version won't contain the latest changes for testing.
	//    Send a PrepareFlow (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html)
	//    request to package the latest changes into the DRAFT version.
	//
	//    * Preparing – The flow is being prepared so that the DRAFT version contains
	//    the latest changes for testing.
	//
	//    * Prepared – The flow is prepared and the DRAFT version contains the
	//    latest changes for testing.
	//
	//    * Failed – The last API operation that you invoked on the flow failed.
	//    Send a GetFlow (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html)
	//    request and check the error message in the validations field.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`

	// The time at which the flow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A list of validation error messages related to the last failed operation
	// on the flow.
	Validations []*FlowValidation `locationName:"validations" type:"list"`

	// The version of the flow for which information was retrieved.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFlowOutput) SetArn(v string) *GetFlowOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetFlowOutput) SetCreatedAt(v time.Time) *GetFlowOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *GetFlowOutput) SetCustomerEncryptionKeyArn(v string) *GetFlowOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetFlowOutput) SetDefinition(v *FlowDefinition) *GetFlowOutput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFlowOutput) SetDescription(v string) *GetFlowOutput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *GetFlowOutput) SetExecutionRoleArn(v string) *GetFlowOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFlowOutput) SetId(v string) *GetFlowOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFlowOutput) SetName(v string) *GetFlowOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetFlowOutput) SetStatus(v string) *GetFlowOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetFlowOutput) SetUpdatedAt(v time.Time) *GetFlowOutput {
	s.UpdatedAt = &v
	return s
}

// SetValidations sets the Validations field's value.
func (s *GetFlowOutput) SetValidations(v []*FlowValidation) *GetFlowOutput {
	s.Validations = v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetFlowOutput) SetVersion(v string) *GetFlowOutput {
	s.Version = &v
	return s
}

type GetFlowVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the flow for which to get information.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// The version of the flow for which to get information.
	//
	// FlowVersion is a required field
	FlowVersion *string `location:"uri" locationName:"flowVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFlowVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFlowVersionInput"}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}
	if s.FlowVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowVersion"))
	}
	if s.FlowVersion != nil && len(*s.FlowVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *GetFlowVersionInput) SetFlowIdentifier(v string) *GetFlowVersionInput {
	s.FlowIdentifier = &v
	return s
}

// SetFlowVersion sets the FlowVersion field's value.
func (s *GetFlowVersionInput) SetFlowVersion(v string) *GetFlowVersionInput {
	s.FlowVersion = &v
	return s
}

type GetFlowVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that the version of the flow
	// is encrypted with.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The definition of the nodes and connections between nodes in the flow.
	Definition *FlowDefinition `locationName:"definition" type:"structure"`

	// The description of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// a flow. For more information, see Create a service role for flows in Amazon
	// Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
	// in the Amazon Bedrock User Guide.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow version.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the flow.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`

	// The version of the flow for which information was retrieved.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFlowVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetFlowVersionOutput) SetArn(v string) *GetFlowVersionOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetFlowVersionOutput) SetCreatedAt(v time.Time) *GetFlowVersionOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *GetFlowVersionOutput) SetCustomerEncryptionKeyArn(v string) *GetFlowVersionOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *GetFlowVersionOutput) SetDefinition(v *FlowDefinition) *GetFlowVersionOutput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFlowVersionOutput) SetDescription(v string) *GetFlowVersionOutput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *GetFlowVersionOutput) SetExecutionRoleArn(v string) *GetFlowVersionOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetFlowVersionOutput) SetId(v string) *GetFlowVersionOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetFlowVersionOutput) SetName(v string) *GetFlowVersionOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetFlowVersionOutput) SetStatus(v string) *GetFlowVersionOutput {
	s.Status = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetFlowVersionOutput) SetVersion(v string) *GetFlowVersionOutput {
	s.Version = &v
	return s
}

type GetIngestionJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the data source in the ingestion job.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// The unique identifier of the ingestion job.
	//
	// IngestionJobId is a required field
	IngestionJobId *string `location:"uri" locationName:"ingestionJobId" type:"string" required:"true"`

	// The unique identifier of the knowledge base for which the ingestion job applies.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIngestionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIngestionJobInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.IngestionJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionJobId"))
	}
	if s.IngestionJobId != nil && len(*s.IngestionJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IngestionJobId", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *GetIngestionJobInput) SetDataSourceId(v string) *GetIngestionJobInput {
	s.DataSourceId = &v
	return s
}

// SetIngestionJobId sets the IngestionJobId field's value.
func (s *GetIngestionJobInput) SetIngestionJobId(v string) *GetIngestionJobInput {
	s.IngestionJobId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetIngestionJobInput) SetKnowledgeBaseId(v string) *GetIngestionJobInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetIngestionJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the ingestion job.
	//
	// IngestionJob is a required field
	IngestionJob *IngestionJob `locationName:"ingestionJob" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIngestionJobOutput) GoString() string {
	return s.String()
}

// SetIngestionJob sets the IngestionJob field's value.
func (s *GetIngestionJobOutput) SetIngestionJob(v *IngestionJob) *GetIngestionJobOutput {
	s.IngestionJob = v
	return s
}

type GetKnowledgeBaseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the knowledge base for which to get information.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKnowledgeBaseInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *GetKnowledgeBaseInput) SetKnowledgeBaseId(v string) *GetKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

type GetKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base.
	//
	// KnowledgeBase is a required field
	KnowledgeBase *KnowledgeBase `locationName:"knowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *GetKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBase) *GetKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

type GetPromptInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the prompt.
	//
	// PromptIdentifier is a required field
	PromptIdentifier *string `location:"uri" locationName:"promptIdentifier" type:"string" required:"true"`

	// The version of the prompt about which you want to retrieve information.
	PromptVersion *string `location:"querystring" locationName:"promptVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPromptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPromptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPromptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPromptInput"}
	if s.PromptIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptIdentifier"))
	}
	if s.PromptIdentifier != nil && len(*s.PromptIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PromptIdentifier", 1))
	}
	if s.PromptVersion != nil && len(*s.PromptVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PromptVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPromptIdentifier sets the PromptIdentifier field's value.
func (s *GetPromptInput) SetPromptIdentifier(v string) *GetPromptInput {
	s.PromptIdentifier = &v
	return s
}

// SetPromptVersion sets the PromptVersion field's value.
func (s *GetPromptInput) SetPromptVersion(v string) *GetPromptInput {
	s.PromptVersion = &v
	return s
}

type GetPromptOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the prompt.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the prompt was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that the prompt is encrypted
	// with.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The name of the default variant for the prompt. This value must match the
	// name field in the relevant PromptVariant (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html)
	// object.
	DefaultVariant *string `locationName:"defaultVariant" type:"string"`

	// The descriptino of the prompt.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the prompt.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the prompt.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time at which the prompt was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A list of objects, each containing details about a variant of the prompt.
	//
	// Variants is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetPromptOutput's
	// String and GoString methods.
	Variants []*PromptVariant `locationName:"variants" type:"list" sensitive:"true"`

	// The version of the prompt.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPromptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPromptOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetPromptOutput) SetArn(v string) *GetPromptOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetPromptOutput) SetCreatedAt(v time.Time) *GetPromptOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *GetPromptOutput) SetCustomerEncryptionKeyArn(v string) *GetPromptOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefaultVariant sets the DefaultVariant field's value.
func (s *GetPromptOutput) SetDefaultVariant(v string) *GetPromptOutput {
	s.DefaultVariant = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetPromptOutput) SetDescription(v string) *GetPromptOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetPromptOutput) SetId(v string) *GetPromptOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetPromptOutput) SetName(v string) *GetPromptOutput {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetPromptOutput) SetUpdatedAt(v time.Time) *GetPromptOutput {
	s.UpdatedAt = &v
	return s
}

// SetVariants sets the Variants field's value.
func (s *GetPromptOutput) SetVariants(v []*PromptVariant) *GetPromptOutput {
	s.Variants = v
	return s
}

// SetVersion sets the Version field's value.
func (s *GetPromptOutput) SetVersion(v string) *GetPromptOutput {
	s.Version = &v
	return s
}

// Details about the guardrail associated with an agent.
type GuardrailConfiguration struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the guardrail.
	GuardrailIdentifier *string `locationName:"guardrailIdentifier" type:"string"`

	// The version of the guardrail.
	GuardrailVersion *string `locationName:"guardrailVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GuardrailConfiguration) GoString() string {
	return s.String()
}

// SetGuardrailIdentifier sets the GuardrailIdentifier field's value.
func (s *GuardrailConfiguration) SetGuardrailIdentifier(v string) *GuardrailConfiguration {
	s.GuardrailIdentifier = &v
	return s
}

// SetGuardrailVersion sets the GuardrailVersion field's value.
func (s *GuardrailConfiguration) SetGuardrailVersion(v string) *GuardrailConfiguration {
	s.GuardrailVersion = &v
	return s
}

// Settings for hierarchical document chunking for a data source. Hierarchical
// chunking splits documents into layers of chunks where the first layer contains
// large chunks, and the second layer contains smaller chunks derived from the
// first layer.
//
// You configure the number of tokens to overlap, or repeat across adjacent
// chunks. For example, if you set overlap tokens to 60, the last 60 tokens
// in the first chunk are also included at the beginning of the second chunk.
// For each layer, you must also configure the maximum number of tokens in a
// chunk.
type HierarchicalChunkingConfiguration struct {
	_ struct{} `type:"structure"`

	// Token settings for each layer.
	//
	// LevelConfigurations is a required field
	LevelConfigurations []*HierarchicalChunkingLevelConfiguration `locationName:"levelConfigurations" min:"2" type:"list" required:"true"`

	// The number of tokens to repeat across chunks in the same layer.
	//
	// OverlapTokens is a required field
	OverlapTokens *int64 `locationName:"overlapTokens" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HierarchicalChunkingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HierarchicalChunkingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HierarchicalChunkingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HierarchicalChunkingConfiguration"}
	if s.LevelConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("LevelConfigurations"))
	}
	if s.LevelConfigurations != nil && len(s.LevelConfigurations) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("LevelConfigurations", 2))
	}
	if s.OverlapTokens == nil {
		invalidParams.Add(request.NewErrParamRequired("OverlapTokens"))
	}
	if s.OverlapTokens != nil && *s.OverlapTokens < 1 {
		invalidParams.Add(request.NewErrParamMinValue("OverlapTokens", 1))
	}
	if s.LevelConfigurations != nil {
		for i, v := range s.LevelConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LevelConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLevelConfigurations sets the LevelConfigurations field's value.
func (s *HierarchicalChunkingConfiguration) SetLevelConfigurations(v []*HierarchicalChunkingLevelConfiguration) *HierarchicalChunkingConfiguration {
	s.LevelConfigurations = v
	return s
}

// SetOverlapTokens sets the OverlapTokens field's value.
func (s *HierarchicalChunkingConfiguration) SetOverlapTokens(v int64) *HierarchicalChunkingConfiguration {
	s.OverlapTokens = &v
	return s
}

// Token settings for a layer in a hierarchical chunking configuration.
type HierarchicalChunkingLevelConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens that a chunk can contain in this layer.
	//
	// MaxTokens is a required field
	MaxTokens *int64 `locationName:"maxTokens" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HierarchicalChunkingLevelConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HierarchicalChunkingLevelConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HierarchicalChunkingLevelConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HierarchicalChunkingLevelConfiguration"}
	if s.MaxTokens == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxTokens"))
	}
	if s.MaxTokens != nil && *s.MaxTokens < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxTokens", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxTokens sets the MaxTokens field's value.
func (s *HierarchicalChunkingLevelConfiguration) SetMaxTokens(v int64) *HierarchicalChunkingLevelConfiguration {
	s.MaxTokens = &v
	return s
}

// Contains inference parameters to use when the agent invokes a foundation
// model in the part of the agent sequence defined by the promptType. For more
// information, see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
type InferenceConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens to allow in the generated response.
	MaximumLength *int64 `locationName:"maximumLength" type:"integer"`

	// A list of stop sequences. A stop sequence is a sequence of characters that
	// causes the model to stop generating the response.
	StopSequences []*string `locationName:"stopSequences" type:"list"`

	// The likelihood of the model selecting higher-probability options while generating
	// a response. A lower value makes the model more likely to choose higher-probability
	// options, while a higher value makes the model more likely to choose lower-probability
	// options.
	Temperature *float64 `locationName:"temperature" type:"float"`

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for topK
	// is the number of most-likely candidates from which the model chooses the
	// next token in the sequence. For example, if you set topK to 50, the model
	// selects the next token from among the top 50 most likely choices.
	TopK *int64 `locationName:"topK" type:"integer"`

	// While generating a response, the model determines the probability of the
	// following token at each point of generation. The value that you set for Top
	// P determines the number of most-likely candidates from which the model chooses
	// the next token in the sequence. For example, if you set topP to 80, the model
	// only selects the next token from the top 80% of the probability distribution
	// of next tokens.
	TopP *float64 `locationName:"topP" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InferenceConfiguration) GoString() string {
	return s.String()
}

// SetMaximumLength sets the MaximumLength field's value.
func (s *InferenceConfiguration) SetMaximumLength(v int64) *InferenceConfiguration {
	s.MaximumLength = &v
	return s
}

// SetStopSequences sets the StopSequences field's value.
func (s *InferenceConfiguration) SetStopSequences(v []*string) *InferenceConfiguration {
	s.StopSequences = v
	return s
}

// SetTemperature sets the Temperature field's value.
func (s *InferenceConfiguration) SetTemperature(v float64) *InferenceConfiguration {
	s.Temperature = &v
	return s
}

// SetTopK sets the TopK field's value.
func (s *InferenceConfiguration) SetTopK(v int64) *InferenceConfiguration {
	s.TopK = &v
	return s
}

// SetTopP sets the TopP field's value.
func (s *InferenceConfiguration) SetTopP(v float64) *InferenceConfiguration {
	s.TopP = &v
	return s
}

// Contains details about an ingestion job, which converts a data source to
// embeddings for a vector store in knowledge base.
//
// This data type is used in the following API operations:
//
//   - StartIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_StartIngestionJob.html#API_agent_StartIngestionJob_ResponseSyntax)
//
//   - GetIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetIngestionJob.html#API_agent_GetIngestionJob_ResponseSyntax)
//
//   - ListIngestionJob response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListIngestionJobs.html#API_agent_ListIngestionJobs_ResponseSyntax)
type IngestionJob struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the ingested data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the ingestion job.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A list of reasons that the ingestion job failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The unique identifier of the ingestion job.
	//
	// IngestionJobId is a required field
	IngestionJobId *string `locationName:"ingestionJobId" type:"string" required:"true"`

	// The unique identifier of the knowledge base to which the data source is being
	// added.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The time at which the ingestion job started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Contains statistics about the ingestion job.
	Statistics *IngestionJobStatistics `locationName:"statistics" type:"structure"`

	// The status of the ingestion job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"IngestionJobStatus"`

	// The time at which the ingestion job was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJob) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *IngestionJob) SetDataSourceId(v string) *IngestionJob {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IngestionJob) SetDescription(v string) *IngestionJob {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *IngestionJob) SetFailureReasons(v []*string) *IngestionJob {
	s.FailureReasons = v
	return s
}

// SetIngestionJobId sets the IngestionJobId field's value.
func (s *IngestionJob) SetIngestionJobId(v string) *IngestionJob {
	s.IngestionJobId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *IngestionJob) SetKnowledgeBaseId(v string) *IngestionJob {
	s.KnowledgeBaseId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *IngestionJob) SetStartedAt(v time.Time) *IngestionJob {
	s.StartedAt = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *IngestionJob) SetStatistics(v *IngestionJobStatistics) *IngestionJob {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *IngestionJob) SetStatus(v string) *IngestionJob {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IngestionJob) SetUpdatedAt(v time.Time) *IngestionJob {
	s.UpdatedAt = &v
	return s
}

// Defines a filter by which to filter the results.
type IngestionJobFilter struct {
	_ struct{} `type:"structure"`

	// The attribute by which to filter the results.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"IngestionJobFilterAttribute"`

	// The operation to carry out between the attribute and the values.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"IngestionJobFilterOperator"`

	// A list of values for the attribute.
	//
	// Values is a required field
	Values []*string `locationName:"values" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestionJobFilter"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *IngestionJobFilter) SetAttribute(v string) *IngestionJobFilter {
	s.Attribute = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *IngestionJobFilter) SetOperator(v string) *IngestionJobFilter {
	s.Operator = &v
	return s
}

// SetValues sets the Values field's value.
func (s *IngestionJobFilter) SetValues(v []*string) *IngestionJobFilter {
	s.Values = v
	return s
}

// Parameters by which to sort the results.
type IngestionJobSortBy struct {
	_ struct{} `type:"structure"`

	// The attribute by which to sort the results.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" type:"string" required:"true" enum:"IngestionJobSortByAttribute"`

	// The order by which to sort the results.
	//
	// Order is a required field
	Order *string `locationName:"order" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSortBy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSortBy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IngestionJobSortBy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IngestionJobSortBy"}
	if s.Attribute == nil {
		invalidParams.Add(request.NewErrParamRequired("Attribute"))
	}
	if s.Order == nil {
		invalidParams.Add(request.NewErrParamRequired("Order"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttribute sets the Attribute field's value.
func (s *IngestionJobSortBy) SetAttribute(v string) *IngestionJobSortBy {
	s.Attribute = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *IngestionJobSortBy) SetOrder(v string) *IngestionJobSortBy {
	s.Order = &v
	return s
}

// Contains the statistics for the ingestion job.
type IngestionJobStatistics struct {
	_ struct{} `type:"structure"`

	// The number of source documents that was deleted.
	NumberOfDocumentsDeleted *int64 `locationName:"numberOfDocumentsDeleted" type:"long"`

	// The number of source documents that failed to be ingested.
	NumberOfDocumentsFailed *int64 `locationName:"numberOfDocumentsFailed" type:"long"`

	// The total number of source documents that were scanned. Includes new, updated,
	// and unchanged documents.
	NumberOfDocumentsScanned *int64 `locationName:"numberOfDocumentsScanned" type:"long"`

	// The number of metadata files that were updated or deleted.
	NumberOfMetadataDocumentsModified *int64 `locationName:"numberOfMetadataDocumentsModified" type:"long"`

	// The total number of metadata files that were scanned. Includes new, updated,
	// and unchanged files.
	NumberOfMetadataDocumentsScanned *int64 `locationName:"numberOfMetadataDocumentsScanned" type:"long"`

	// The number of modified source documents in the data source that were successfully
	// indexed.
	NumberOfModifiedDocumentsIndexed *int64 `locationName:"numberOfModifiedDocumentsIndexed" type:"long"`

	// The number of new source documents in the data source that were successfully
	// indexed.
	NumberOfNewDocumentsIndexed *int64 `locationName:"numberOfNewDocumentsIndexed" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobStatistics) GoString() string {
	return s.String()
}

// SetNumberOfDocumentsDeleted sets the NumberOfDocumentsDeleted field's value.
func (s *IngestionJobStatistics) SetNumberOfDocumentsDeleted(v int64) *IngestionJobStatistics {
	s.NumberOfDocumentsDeleted = &v
	return s
}

// SetNumberOfDocumentsFailed sets the NumberOfDocumentsFailed field's value.
func (s *IngestionJobStatistics) SetNumberOfDocumentsFailed(v int64) *IngestionJobStatistics {
	s.NumberOfDocumentsFailed = &v
	return s
}

// SetNumberOfDocumentsScanned sets the NumberOfDocumentsScanned field's value.
func (s *IngestionJobStatistics) SetNumberOfDocumentsScanned(v int64) *IngestionJobStatistics {
	s.NumberOfDocumentsScanned = &v
	return s
}

// SetNumberOfMetadataDocumentsModified sets the NumberOfMetadataDocumentsModified field's value.
func (s *IngestionJobStatistics) SetNumberOfMetadataDocumentsModified(v int64) *IngestionJobStatistics {
	s.NumberOfMetadataDocumentsModified = &v
	return s
}

// SetNumberOfMetadataDocumentsScanned sets the NumberOfMetadataDocumentsScanned field's value.
func (s *IngestionJobStatistics) SetNumberOfMetadataDocumentsScanned(v int64) *IngestionJobStatistics {
	s.NumberOfMetadataDocumentsScanned = &v
	return s
}

// SetNumberOfModifiedDocumentsIndexed sets the NumberOfModifiedDocumentsIndexed field's value.
func (s *IngestionJobStatistics) SetNumberOfModifiedDocumentsIndexed(v int64) *IngestionJobStatistics {
	s.NumberOfModifiedDocumentsIndexed = &v
	return s
}

// SetNumberOfNewDocumentsIndexed sets the NumberOfNewDocumentsIndexed field's value.
func (s *IngestionJobStatistics) SetNumberOfNewDocumentsIndexed(v int64) *IngestionJobStatistics {
	s.NumberOfNewDocumentsIndexed = &v
	return s
}

// Contains details about an ingestion job.
type IngestionJobSummary struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source in the ingestion job.
	//
	// DataSourceId is a required field
	DataSourceId *string `locationName:"dataSourceId" type:"string" required:"true"`

	// The description of the ingestion job.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the ingestion job.
	//
	// IngestionJobId is a required field
	IngestionJobId *string `locationName:"ingestionJobId" type:"string" required:"true"`

	// The unique identifier of the knowledge base to which the data source is added.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The time at which the ingestion job was started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Contains statistics for the ingestion job.
	Statistics *IngestionJobStatistics `locationName:"statistics" type:"structure"`

	// The status of the ingestion job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"IngestionJobStatus"`

	// The time at which the ingestion job was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IngestionJobSummary) GoString() string {
	return s.String()
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *IngestionJobSummary) SetDataSourceId(v string) *IngestionJobSummary {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *IngestionJobSummary) SetDescription(v string) *IngestionJobSummary {
	s.Description = &v
	return s
}

// SetIngestionJobId sets the IngestionJobId field's value.
func (s *IngestionJobSummary) SetIngestionJobId(v string) *IngestionJobSummary {
	s.IngestionJobId = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *IngestionJobSummary) SetKnowledgeBaseId(v string) *IngestionJobSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *IngestionJobSummary) SetStartedAt(v time.Time) *IngestionJobSummary {
	s.StartedAt = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *IngestionJobSummary) SetStatistics(v *IngestionJobStatistics) *IngestionJobSummary {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *IngestionJobSummary) SetStatus(v string) *IngestionJobSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *IngestionJobSummary) SetUpdatedAt(v time.Time) *IngestionJobSummary {
	s.UpdatedAt = &v
	return s
}

// Contains configurations for the input flow node for a flow. This node takes
// the input from flow invocation and passes it to the next node in the data
// type that you specify.
type InputFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFlowNodeConfiguration) GoString() string {
	return s.String()
}

// A location for storing content from data sources temporarily as it is processed
// by custom components in the ingestion pipeline.
type IntermediateStorage struct {
	_ struct{} `type:"structure"`

	// An S3 bucket path.
	//
	// S3Location is a required field
	S3Location *S3Location `locationName:"s3Location" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntermediateStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntermediateStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IntermediateStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IntermediateStorage"}
	if s.S3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Location"))
	}
	if s.S3Location != nil {
		if err := s.S3Location.Validate(); err != nil {
			invalidParams.AddNested("S3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Location sets the S3Location field's value.
func (s *IntermediateStorage) SetS3Location(v *S3Location) *IntermediateStorage {
	s.S3Location = v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains configurations for an iterator node in a flow. Takes an input that
// is an array and iteratively sends each item of the array as an output to
// the following node. The size of the array is also returned in the output.
//
// The output flow node at the end of the flow iteration will return a response
// for each member of the array. To return only one response, you can include
// a collector node downstream from the iterator node.
type IteratorFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IteratorFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IteratorFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Contains information about a knowledge base.
type KnowledgeBase struct {
	_ struct{} `type:"structure"`

	// The time at which the knowledge base was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A list of reasons that the API operation on the knowledge base failed.
	FailureReasons []*string `locationName:"failureReasons" type:"list"`

	// The Amazon Resource Name (ARN) of the knowledge base.
	//
	// KnowledgeBaseArn is a required field
	KnowledgeBaseArn *string `locationName:"knowledgeBaseArn" type:"string" required:"true"`

	// Contains details about the embeddings configuration of the knowledge base.
	//
	// KnowledgeBaseConfiguration is a required field
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure" required:"true"`

	// The unique identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the knowledge base.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The status of the knowledge base. The following statuses are possible:
	//
	//    * CREATING – The knowledge base is being created.
	//
	//    * ACTIVE – The knowledge base is ready to be queried.
	//
	//    * DELETING – The knowledge base is being deleted.
	//
	//    * UPDATING – The knowledge base is being updated.
	//
	//    * FAILED – The knowledge base API operation failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`

	// Contains details about the storage configuration of the knowledge base.
	//
	// StorageConfiguration is a required field
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure" required:"true"`

	// The time at which the knowledge base was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBase) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *KnowledgeBase) SetCreatedAt(v time.Time) *KnowledgeBase {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KnowledgeBase) SetDescription(v string) *KnowledgeBase {
	s.Description = &v
	return s
}

// SetFailureReasons sets the FailureReasons field's value.
func (s *KnowledgeBase) SetFailureReasons(v []*string) *KnowledgeBase {
	s.FailureReasons = v
	return s
}

// SetKnowledgeBaseArn sets the KnowledgeBaseArn field's value.
func (s *KnowledgeBase) SetKnowledgeBaseArn(v string) *KnowledgeBase {
	s.KnowledgeBaseArn = &v
	return s
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *KnowledgeBase) SetKnowledgeBaseConfiguration(v *KnowledgeBaseConfiguration) *KnowledgeBase {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBase) SetKnowledgeBaseId(v string) *KnowledgeBase {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *KnowledgeBase) SetName(v string) *KnowledgeBase {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *KnowledgeBase) SetRoleArn(v string) *KnowledgeBase {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KnowledgeBase) SetStatus(v string) *KnowledgeBase {
	s.Status = &v
	return s
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *KnowledgeBase) SetStorageConfiguration(v *StorageConfiguration) *KnowledgeBase {
	s.StorageConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *KnowledgeBase) SetUpdatedAt(v time.Time) *KnowledgeBase {
	s.UpdatedAt = &v
	return s
}

// Contains details about the embeddings configuration of the knowledge base.
type KnowledgeBaseConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of data that the data source is converted into for the knowledge
	// base.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"KnowledgeBaseType"`

	// Contains details about the embeddings model that'sused to convert the data
	// source.
	VectorKnowledgeBaseConfiguration *VectorKnowledgeBaseConfiguration `locationName:"vectorKnowledgeBaseConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.VectorKnowledgeBaseConfiguration != nil {
		if err := s.VectorKnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorKnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *KnowledgeBaseConfiguration) SetType(v string) *KnowledgeBaseConfiguration {
	s.Type = &v
	return s
}

// SetVectorKnowledgeBaseConfiguration sets the VectorKnowledgeBaseConfiguration field's value.
func (s *KnowledgeBaseConfiguration) SetVectorKnowledgeBaseConfiguration(v *VectorKnowledgeBaseConfiguration) *KnowledgeBaseConfiguration {
	s.VectorKnowledgeBaseConfiguration = v
	return s
}

// Contains configurations for a knowledge base node in a flow. This node takes
// a query as the input and returns, as the output, the retrieved responses
// directly (as an array) or a response generated based on the retrieved responses.
// For more information, see Node types in Amazon Bedrock works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type KnowledgeBaseFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the knowledge base to query.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The unique identifier of the model to use to generate a response from the
	// query results. Omit this field if you want to return the retrieved results
	// as an array.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KnowledgeBaseFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KnowledgeBaseFlowNodeConfiguration"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseFlowNodeConfiguration) SetKnowledgeBaseId(v string) *KnowledgeBaseFlowNodeConfiguration {
	s.KnowledgeBaseId = &v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *KnowledgeBaseFlowNodeConfiguration) SetModelId(v string) *KnowledgeBaseFlowNodeConfiguration {
	s.ModelId = &v
	return s
}

// Contains details about a knowledge base.
type KnowledgeBaseSummary struct {
	_ struct{} `type:"structure"`

	// The description of the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The name of the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the knowledge base.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"KnowledgeBaseStatus"`

	// The time at which the knowledge base was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KnowledgeBaseSummary) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *KnowledgeBaseSummary) SetDescription(v string) *KnowledgeBaseSummary {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *KnowledgeBaseSummary) SetKnowledgeBaseId(v string) *KnowledgeBaseSummary {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *KnowledgeBaseSummary) SetName(v string) *KnowledgeBaseSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *KnowledgeBaseSummary) SetStatus(v string) *KnowledgeBaseSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *KnowledgeBaseSummary) SetUpdatedAt(v time.Time) *KnowledgeBaseSummary {
	s.UpdatedAt = &v
	return s
}

// Contains configurations for a Lambda function node in the flow. You specify
// the Lambda function to invoke and the inputs into the function. The output
// is the response that is defined in the Lambda function. For more information,
// see Node types in Amazon Bedrock works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type LambdaFunctionFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function to invoke.
	//
	// LambdaArn is a required field
	LambdaArn *string `locationName:"lambdaArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LambdaFunctionFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaFunctionFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LambdaFunctionFlowNodeConfiguration"}
	if s.LambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *LambdaFunctionFlowNodeConfiguration) SetLambdaArn(v string) *LambdaFunctionFlowNodeConfiguration {
	s.LambdaArn = &v
	return s
}

// Contains configurations for a Lex node in the flow. You specify a Amazon
// Lex bot to invoke. This node takes an utterance as the input and returns
// as the output the intent identified by the Amazon Lex bot. For more information,
// see Node types in Amazon Bedrock works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type LexFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
	//
	// BotAliasArn is a required field
	BotAliasArn *string `locationName:"botAliasArn" type:"string" required:"true"`

	// The Region to invoke the Amazon Lex bot in.
	//
	// LocaleId is a required field
	LocaleId *string `locationName:"localeId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LexFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LexFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LexFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LexFlowNodeConfiguration"}
	if s.BotAliasArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BotAliasArn"))
	}
	if s.LocaleId == nil {
		invalidParams.Add(request.NewErrParamRequired("LocaleId"))
	}
	if s.LocaleId != nil && len(*s.LocaleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LocaleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBotAliasArn sets the BotAliasArn field's value.
func (s *LexFlowNodeConfiguration) SetBotAliasArn(v string) *LexFlowNodeConfiguration {
	s.BotAliasArn = &v
	return s
}

// SetLocaleId sets the LocaleId field's value.
func (s *LexFlowNodeConfiguration) SetLocaleId(v string) *LexFlowNodeConfiguration {
	s.LocaleId = &v
	return s
}

type ListAgentActionGroupsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentActionGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentActionGroupsInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentActionGroupsInput) SetAgentId(v string) *ListAgentActionGroupsInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *ListAgentActionGroupsInput) SetAgentVersion(v string) *ListAgentActionGroupsInput {
	s.AgentVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentActionGroupsInput) SetMaxResults(v int64) *ListAgentActionGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentActionGroupsInput) SetNextToken(v string) *ListAgentActionGroupsInput {
	s.NextToken = &v
	return s
}

type ListAgentActionGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an action group.
	//
	// ActionGroupSummaries is a required field
	ActionGroupSummaries []*ActionGroupSummary `locationName:"actionGroupSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentActionGroupsOutput) GoString() string {
	return s.String()
}

// SetActionGroupSummaries sets the ActionGroupSummaries field's value.
func (s *ListAgentActionGroupsOutput) SetActionGroupSummaries(v []*ActionGroupSummary) *ListAgentActionGroupsOutput {
	s.ActionGroupSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentActionGroupsOutput) SetNextToken(v string) *ListAgentActionGroupsOutput {
	s.NextToken = &v
	return s
}

type ListAgentAliasesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentAliasesInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentAliasesInput) SetAgentId(v string) *ListAgentAliasesInput {
	s.AgentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentAliasesInput) SetMaxResults(v int64) *ListAgentAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentAliasesInput) SetNextToken(v string) *ListAgentAliasesInput {
	s.NextToken = &v
	return s
}

type ListAgentAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an alias of the
	// agent.
	//
	// AgentAliasSummaries is a required field
	AgentAliasSummaries []*AgentAliasSummary `locationName:"agentAliasSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentAliasesOutput) GoString() string {
	return s.String()
}

// SetAgentAliasSummaries sets the AgentAliasSummaries field's value.
func (s *ListAgentAliasesOutput) SetAgentAliasSummaries(v []*AgentAliasSummary) *ListAgentAliasesOutput {
	s.AgentAliasSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentAliasesOutput) SetNextToken(v string) *ListAgentAliasesOutput {
	s.NextToken = &v
	return s
}

type ListAgentKnowledgeBasesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent for which to return information about
	// knowledge bases associated with it.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent for which to return information about knowledge
	// bases associated with it.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentKnowledgeBasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentKnowledgeBasesInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentKnowledgeBasesInput) SetAgentId(v string) *ListAgentKnowledgeBasesInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *ListAgentKnowledgeBasesInput) SetAgentVersion(v string) *ListAgentKnowledgeBasesInput {
	s.AgentVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentKnowledgeBasesInput) SetMaxResults(v int64) *ListAgentKnowledgeBasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentKnowledgeBasesInput) SetNextToken(v string) *ListAgentKnowledgeBasesInput {
	s.NextToken = &v
	return s
}

type ListAgentKnowledgeBasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a knowledge base
	// associated with the agent.
	//
	// AgentKnowledgeBaseSummaries is a required field
	AgentKnowledgeBaseSummaries []*AgentKnowledgeBaseSummary `locationName:"agentKnowledgeBaseSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentKnowledgeBasesOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBaseSummaries sets the AgentKnowledgeBaseSummaries field's value.
func (s *ListAgentKnowledgeBasesOutput) SetAgentKnowledgeBaseSummaries(v []*AgentKnowledgeBaseSummary) *ListAgentKnowledgeBasesOutput {
	s.AgentKnowledgeBaseSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentKnowledgeBasesOutput) SetNextToken(v string) *ListAgentKnowledgeBasesOutput {
	s.NextToken = &v
	return s
}

type ListAgentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentVersionsInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *ListAgentVersionsInput) SetAgentId(v string) *ListAgentVersionsInput {
	s.AgentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentVersionsInput) SetMaxResults(v int64) *ListAgentVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentVersionsInput) SetNextToken(v string) *ListAgentVersionsInput {
	s.NextToken = &v
	return s
}

type ListAgentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a version of
	// the agent.
	//
	// AgentVersionSummaries is a required field
	AgentVersionSummaries []*AgentVersionSummary `locationName:"agentVersionSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentVersionsOutput) GoString() string {
	return s.String()
}

// SetAgentVersionSummaries sets the AgentVersionSummaries field's value.
func (s *ListAgentVersionsOutput) SetAgentVersionSummaries(v []*AgentVersionSummary) *ListAgentVersionsOutput {
	s.AgentVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentVersionsOutput) SetNextToken(v string) *ListAgentVersionsOutput {
	s.NextToken = &v
	return s
}

type ListAgentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAgentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAgentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAgentsInput) SetMaxResults(v int64) *ListAgentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsInput) SetNextToken(v string) *ListAgentsInput {
	s.NextToken = &v
	return s
}

type ListAgentsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an agent.
	//
	// AgentSummaries is a required field
	AgentSummaries []*AgentSummary `locationName:"agentSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAgentsOutput) GoString() string {
	return s.String()
}

// SetAgentSummaries sets the AgentSummaries field's value.
func (s *ListAgentsOutput) SetAgentSummaries(v []*AgentSummary) *ListAgentsOutput {
	s.AgentSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAgentsOutput) SetNextToken(v string) *ListAgentsOutput {
	s.NextToken = &v
	return s
}

type ListDataSourcesInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the knowledge base for which to return a list of
	// information.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataSourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataSourcesInput"}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ListDataSourcesInput) SetKnowledgeBaseId(v string) *ListDataSourcesInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataSourcesInput) SetMaxResults(v int64) *ListDataSourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesInput) SetNextToken(v string) *ListDataSourcesInput {
	s.NextToken = &v
	return s
}

type ListDataSourcesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a data source.
	//
	// DataSourceSummaries is a required field
	DataSourceSummaries []*DataSourceSummary `locationName:"dataSourceSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataSourcesOutput) GoString() string {
	return s.String()
}

// SetDataSourceSummaries sets the DataSourceSummaries field's value.
func (s *ListDataSourcesOutput) SetDataSourceSummaries(v []*DataSourceSummary) *ListDataSourcesOutput {
	s.DataSourceSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataSourcesOutput) SetNextToken(v string) *ListDataSourcesOutput {
	s.NextToken = &v
	return s
}

type ListFlowAliasesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the flow for which aliases are being returned.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowAliasesInput"}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *ListFlowAliasesInput) SetFlowIdentifier(v string) *ListFlowAliasesInput {
	s.FlowIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowAliasesInput) SetMaxResults(v int64) *ListFlowAliasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowAliasesInput) SetNextToken(v string) *ListFlowAliasesInput {
	s.NextToken = &v
	return s
}

type ListFlowAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list, each member of which contains information about a flow alias.
	//
	// FlowAliasSummaries is a required field
	FlowAliasSummaries []*FlowAliasSummary `locationName:"flowAliasSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowAliasesOutput) GoString() string {
	return s.String()
}

// SetFlowAliasSummaries sets the FlowAliasSummaries field's value.
func (s *ListFlowAliasesOutput) SetFlowAliasSummaries(v []*FlowAliasSummary) *ListFlowAliasesOutput {
	s.FlowAliasSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowAliasesOutput) SetNextToken(v string) *ListFlowAliasesOutput {
	s.NextToken = &v
	return s
}

type ListFlowVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the flow.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowVersionsInput"}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *ListFlowVersionsInput) SetFlowIdentifier(v string) *ListFlowVersionsInput {
	s.FlowIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowVersionsInput) SetMaxResults(v int64) *ListFlowVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowVersionsInput) SetNextToken(v string) *ListFlowVersionsInput {
	s.NextToken = &v
	return s
}

type ListFlowVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A list, each member of which contains information about a flow.
	//
	// FlowVersionSummaries is a required field
	FlowVersionSummaries []*FlowVersionSummary `locationName:"flowVersionSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowVersionsOutput) GoString() string {
	return s.String()
}

// SetFlowVersionSummaries sets the FlowVersionSummaries field's value.
func (s *ListFlowVersionsOutput) SetFlowVersionSummaries(v []*FlowVersionSummary) *ListFlowVersionsOutput {
	s.FlowVersionSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowVersionsOutput) SetNextToken(v string) *ListFlowVersionsOutput {
	s.NextToken = &v
	return s
}

type ListFlowsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFlowsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFlowsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFlowsInput) SetMaxResults(v int64) *ListFlowsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsInput) SetNextToken(v string) *ListFlowsInput {
	s.NextToken = &v
	return s
}

type ListFlowsOutput struct {
	_ struct{} `type:"structure"`

	// A list, each member of which contains information about a flow.
	//
	// FlowSummaries is a required field
	FlowSummaries []*FlowSummary `locationName:"flowSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFlowsOutput) GoString() string {
	return s.String()
}

// SetFlowSummaries sets the FlowSummaries field's value.
func (s *ListFlowsOutput) SetFlowSummaries(v []*FlowSummary) *ListFlowsOutput {
	s.FlowSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFlowsOutput) SetNextToken(v string) *ListFlowsOutput {
	s.NextToken = &v
	return s
}

type ListIngestionJobsInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the data source for which to return ingestion jobs.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// Contains a definition of a filter for which to filter the results.
	Filters []*IngestionJobFilter `locationName:"filters" min:"1" type:"list"`

	// The unique identifier of the knowledge base for which to return ingestion
	// jobs.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Contains details about how to sort the results.
	SortBy *IngestionJobSortBy `locationName:"sortBy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIngestionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIngestionJobsInput"}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SortBy != nil {
		if err := s.SortBy.Validate(); err != nil {
			invalidParams.AddNested("SortBy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *ListIngestionJobsInput) SetDataSourceId(v string) *ListIngestionJobsInput {
	s.DataSourceId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *ListIngestionJobsInput) SetFilters(v []*IngestionJobFilter) *ListIngestionJobsInput {
	s.Filters = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *ListIngestionJobsInput) SetKnowledgeBaseId(v string) *ListIngestionJobsInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIngestionJobsInput) SetMaxResults(v int64) *ListIngestionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionJobsInput) SetNextToken(v string) *ListIngestionJobsInput {
	s.NextToken = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListIngestionJobsInput) SetSortBy(v *IngestionJobSortBy) *ListIngestionJobsInput {
	s.SortBy = v
	return s
}

type ListIngestionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about an ingestion
	// job.
	//
	// IngestionJobSummaries is a required field
	IngestionJobSummaries []*IngestionJobSummary `locationName:"ingestionJobSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIngestionJobsOutput) GoString() string {
	return s.String()
}

// SetIngestionJobSummaries sets the IngestionJobSummaries field's value.
func (s *ListIngestionJobsOutput) SetIngestionJobSummaries(v []*IngestionJobSummary) *ListIngestionJobsOutput {
	s.IngestionJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIngestionJobsOutput) SetNextToken(v string) *ListIngestionJobsOutput {
	s.NextToken = &v
	return s
}

type ListKnowledgeBasesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKnowledgeBasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKnowledgeBasesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKnowledgeBasesInput) SetMaxResults(v int64) *ListKnowledgeBasesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKnowledgeBasesInput) SetNextToken(v string) *ListKnowledgeBasesInput {
	s.NextToken = &v
	return s
}

type ListKnowledgeBasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects, each of which contains information about a knowledge base.
	//
	// KnowledgeBaseSummaries is a required field
	KnowledgeBaseSummaries []*KnowledgeBaseSummary `locationName:"knowledgeBaseSummaries" type:"list" required:"true"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListKnowledgeBasesOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBaseSummaries sets the KnowledgeBaseSummaries field's value.
func (s *ListKnowledgeBasesOutput) SetKnowledgeBaseSummaries(v []*KnowledgeBaseSummary) *ListKnowledgeBasesOutput {
	s.KnowledgeBaseSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKnowledgeBasesOutput) SetNextToken(v string) *ListKnowledgeBasesOutput {
	s.NextToken = &v
	return s
}

type ListPromptsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return in the response. If the total number
	// of results is greater than this value, use the token returned in the response
	// in the nextToken field when making another request to return the next batch
	// of results.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, enter the token returned in the nextToken field in the response
	// in this field to return the next batch of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`

	// The unique identifier of the prompt.
	PromptIdentifier *string `location:"querystring" locationName:"promptIdentifier" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPromptsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPromptsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPromptsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPromptsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPromptsInput) SetMaxResults(v int64) *ListPromptsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPromptsInput) SetNextToken(v string) *ListPromptsInput {
	s.NextToken = &v
	return s
}

// SetPromptIdentifier sets the PromptIdentifier field's value.
func (s *ListPromptsInput) SetPromptIdentifier(v string) *ListPromptsInput {
	s.PromptIdentifier = &v
	return s
}

type ListPromptsOutput struct {
	_ struct{} `type:"structure"`

	// If the total number of results is greater than the maxResults value provided
	// in the request, use this token when making another request in the nextToken
	// field to return the next batch of results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list, each member of which contains information about a prompt using Prompt
	// management.
	//
	// PromptSummaries is a required field
	PromptSummaries []*PromptSummary `locationName:"promptSummaries" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPromptsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPromptsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPromptsOutput) SetNextToken(v string) *ListPromptsOutput {
	s.NextToken = &v
	return s
}

// SetPromptSummaries sets the PromptSummaries field's value.
func (s *ListPromptsOutput) SetPromptSummaries(v []*PromptSummary) *ListPromptsOutput {
	s.PromptSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource for which to list tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The key-value pairs for the tags associated with the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Details of the memory configuration.
type MemoryConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of memory that is stored.
	//
	// EnabledMemoryTypes is a required field
	EnabledMemoryTypes []*string `locationName:"enabledMemoryTypes" min:"1" type:"list" required:"true" enum:"MemoryType"`

	// The number of days the agent is configured to retain the conversational context.
	StorageDays *int64 `locationName:"storageDays" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemoryConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemoryConfiguration"}
	if s.EnabledMemoryTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EnabledMemoryTypes"))
	}
	if s.EnabledMemoryTypes != nil && len(s.EnabledMemoryTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnabledMemoryTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabledMemoryTypes sets the EnabledMemoryTypes field's value.
func (s *MemoryConfiguration) SetEnabledMemoryTypes(v []*string) *MemoryConfiguration {
	s.EnabledMemoryTypes = v
	return s
}

// SetStorageDays sets the StorageDays field's value.
func (s *MemoryConfiguration) SetStorageDays(v int64) *MemoryConfiguration {
	s.StorageDays = &v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// MongoDB Atlas.
type MongoDbAtlasConfiguration struct {
	_ struct{} `type:"structure"`

	// The collection name of the knowledge base in MongoDB Atlas.
	//
	// CollectionName is a required field
	CollectionName *string `locationName:"collectionName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that contains user credentials for your MongoDB Atlas cluster.
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The database name in your MongoDB Atlas cluster for your knowledge base.
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" type:"string" required:"true"`

	// The endpoint URL of your MongoDB Atlas cluster for your knowledge base.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`

	// The name of the VPC endpoint service in your account that is connected to
	// your MongoDB Atlas cluster.
	EndpointServiceName *string `locationName:"endpointServiceName" min:"1" type:"string"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *MongoDbAtlasFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The name of the MongoDB Atlas vector search index.
	//
	// VectorIndexName is a required field
	VectorIndexName *string `locationName:"vectorIndexName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MongoDbAtlasConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MongoDbAtlasConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MongoDbAtlasConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MongoDbAtlasConfiguration"}
	if s.CollectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionName"))
	}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.EndpointServiceName != nil && len(*s.EndpointServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointServiceName", 1))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.VectorIndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorIndexName"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionName sets the CollectionName field's value.
func (s *MongoDbAtlasConfiguration) SetCollectionName(v string) *MongoDbAtlasConfiguration {
	s.CollectionName = &v
	return s
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *MongoDbAtlasConfiguration) SetCredentialsSecretArn(v string) *MongoDbAtlasConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *MongoDbAtlasConfiguration) SetDatabaseName(v string) *MongoDbAtlasConfiguration {
	s.DatabaseName = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *MongoDbAtlasConfiguration) SetEndpoint(v string) *MongoDbAtlasConfiguration {
	s.Endpoint = &v
	return s
}

// SetEndpointServiceName sets the EndpointServiceName field's value.
func (s *MongoDbAtlasConfiguration) SetEndpointServiceName(v string) *MongoDbAtlasConfiguration {
	s.EndpointServiceName = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *MongoDbAtlasConfiguration) SetFieldMapping(v *MongoDbAtlasFieldMapping) *MongoDbAtlasConfiguration {
	s.FieldMapping = v
	return s
}

// SetVectorIndexName sets the VectorIndexName field's value.
func (s *MongoDbAtlasConfiguration) SetVectorIndexName(v string) *MongoDbAtlasConfiguration {
	s.VectorIndexName = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type MongoDbAtlasFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the vector embeddings
	// for your data sources.
	//
	// VectorField is a required field
	VectorField *string `locationName:"vectorField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MongoDbAtlasFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MongoDbAtlasFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MongoDbAtlasFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MongoDbAtlasFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}
	if s.VectorField == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *MongoDbAtlasFieldMapping) SetMetadataField(v string) *MongoDbAtlasFieldMapping {
	s.MetadataField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *MongoDbAtlasFieldMapping) SetTextField(v string) *MongoDbAtlasFieldMapping {
	s.TextField = &v
	return s
}

// SetVectorField sets the VectorField field's value.
func (s *MongoDbAtlasFieldMapping) SetVectorField(v string) *MongoDbAtlasFieldMapping {
	s.VectorField = &v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Amazon OpenSearch Service. For more information, see Create a vector index
// in Amazon OpenSearch Service (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html).
type OpenSearchServerlessConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the OpenSearch Service vector store.
	//
	// CollectionArn is a required field
	CollectionArn *string `locationName:"collectionArn" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *OpenSearchServerlessFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The name of the vector store.
	//
	// VectorIndexName is a required field
	VectorIndexName *string `locationName:"vectorIndexName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenSearchServerlessConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenSearchServerlessConfiguration"}
	if s.CollectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CollectionArn"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.VectorIndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorIndexName"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollectionArn sets the CollectionArn field's value.
func (s *OpenSearchServerlessConfiguration) SetCollectionArn(v string) *OpenSearchServerlessConfiguration {
	s.CollectionArn = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *OpenSearchServerlessConfiguration) SetFieldMapping(v *OpenSearchServerlessFieldMapping) *OpenSearchServerlessConfiguration {
	s.FieldMapping = v
	return s
}

// SetVectorIndexName sets the VectorIndexName field's value.
func (s *OpenSearchServerlessConfiguration) SetVectorIndexName(v string) *OpenSearchServerlessConfiguration {
	s.VectorIndexName = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type OpenSearchServerlessFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the vector embeddings
	// for your data sources.
	//
	// VectorField is a required field
	VectorField *string `locationName:"vectorField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenSearchServerlessFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OpenSearchServerlessFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OpenSearchServerlessFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}
	if s.VectorField == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *OpenSearchServerlessFieldMapping) SetMetadataField(v string) *OpenSearchServerlessFieldMapping {
	s.MetadataField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *OpenSearchServerlessFieldMapping) SetTextField(v string) *OpenSearchServerlessFieldMapping {
	s.TextField = &v
	return s
}

// SetVectorField sets the VectorField field's value.
func (s *OpenSearchServerlessFieldMapping) SetVectorField(v string) *OpenSearchServerlessFieldMapping {
	s.VectorField = &v
	return s
}

// Contains configurations for an output flow node in the flow. You specify
// the data type expected for the input into the node in the type field and
// how to return the final output in the expression field.
type OutputFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Contains details about a parameter in a function for an action group.
//
// This data type is used in the following API operations:
//
//   - CreateAgentActionGroup request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_RequestSyntax)
//
//   - CreateAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_CreateAgentActionGroup.html#API_agent_CreateAgentActionGroup_ResponseSyntax)
//
//   - UpdateAgentActionGroup request (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_RequestSyntax)
//
//   - UpdateAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_UpdateAgentActionGroup.html#API_agent_UpdateAgentActionGroup_ResponseSyntax)
//
//   - GetAgentActionGroup response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetAgentActionGroup.html#API_agent_GetAgentActionGroup_ResponseSyntax)
type ParameterDetail struct {
	_ struct{} `type:"structure"`

	// A description of the parameter. Helps the foundation model determine how
	// to elicit the parameters from the user.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether the parameter is required for the agent to complete the function
	// for action group invocation.
	Required *bool `locationName:"required" type:"boolean"`

	// The data type of the parameter.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterDetail) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterDetail) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterDetail"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ParameterDetail) SetDescription(v string) *ParameterDetail {
	s.Description = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *ParameterDetail) SetRequired(v bool) *ParameterDetail {
	s.Required = &v
	return s
}

// SetType sets the Type field's value.
func (s *ParameterDetail) SetType(v string) *ParameterDetail {
	s.Type = &v
	return s
}

// Settings for parsing document contents. By default, the service converts
// the contents of each document into text before splitting it into chunks.
// To improve processing of PDF files with tables and images, you can configure
// the data source to convert the pages of text into images and use a model
// to describe the contents of each page.
//
// To use a model to parse PDF documents, set the parsing strategy to BEDROCK_FOUNDATION_MODEL
// and specify the model to use by ARN. You can also override the default parsing
// prompt with instructions for how to interpret images and tables in your documents.
// The following models are supported.
//
//   - Anthropic Claude 3 Sonnet - anthropic.claude-3-sonnet-20240229-v1:0
//
//   - Anthropic Claude 3 Haiku - anthropic.claude-3-haiku-20240307-v1:0
//
// You can get the ARN of a model with the action. Standard model usage charges
// apply for the foundation model parsing strategy.
type ParsingConfiguration struct {
	_ struct{} `type:"structure"`

	// Settings for a foundation model used to parse documents for a data source.
	BedrockFoundationModelConfiguration *BedrockFoundationModelConfiguration `locationName:"bedrockFoundationModelConfiguration" type:"structure"`

	// The parsing strategy for the data source.
	//
	// ParsingStrategy is a required field
	ParsingStrategy *string `locationName:"parsingStrategy" type:"string" required:"true" enum:"ParsingStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParsingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParsingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParsingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParsingConfiguration"}
	if s.ParsingStrategy == nil {
		invalidParams.Add(request.NewErrParamRequired("ParsingStrategy"))
	}
	if s.BedrockFoundationModelConfiguration != nil {
		if err := s.BedrockFoundationModelConfiguration.Validate(); err != nil {
			invalidParams.AddNested("BedrockFoundationModelConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBedrockFoundationModelConfiguration sets the BedrockFoundationModelConfiguration field's value.
func (s *ParsingConfiguration) SetBedrockFoundationModelConfiguration(v *BedrockFoundationModelConfiguration) *ParsingConfiguration {
	s.BedrockFoundationModelConfiguration = v
	return s
}

// SetParsingStrategy sets the ParsingStrategy field's value.
func (s *ParsingConfiguration) SetParsingStrategy(v string) *ParsingConfiguration {
	s.ParsingStrategy = &v
	return s
}

// Instructions for interpreting the contents of a document.
type ParsingPrompt struct {
	_ struct{} `type:"structure"`

	// Instructions for interpreting the contents of a document.
	//
	// ParsingPromptText is a required field
	ParsingPromptText *string `locationName:"parsingPromptText" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParsingPrompt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParsingPrompt) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParsingPrompt) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParsingPrompt"}
	if s.ParsingPromptText == nil {
		invalidParams.Add(request.NewErrParamRequired("ParsingPromptText"))
	}
	if s.ParsingPromptText != nil && len(*s.ParsingPromptText) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParsingPromptText", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParsingPromptText sets the ParsingPromptText field's value.
func (s *ParsingPrompt) SetParsingPromptText(v string) *ParsingPrompt {
	s.ParsingPromptText = &v
	return s
}

// The specific filters applied to your data source content. You can filter
// out or include certain content.
type PatternObjectFilter struct {
	_ struct{} `type:"structure"`

	// A list of one or more exclusion regular expression patterns to exclude certain
	// object types that adhere to the pattern. If you specify an inclusion and
	// exclusion filter/pattern and both match a document, the exclusion filter
	// takes precedence and the document isn’t crawled.
	//
	// ExclusionFilters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PatternObjectFilter's
	// String and GoString methods.
	ExclusionFilters []*string `locationName:"exclusionFilters" min:"1" type:"list" sensitive:"true"`

	// A list of one or more inclusion regular expression patterns to include certain
	// object types that adhere to the pattern. If you specify an inclusion and
	// exclusion filter/pattern and both match a document, the exclusion filter
	// takes precedence and the document isn’t crawled.
	//
	// InclusionFilters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PatternObjectFilter's
	// String and GoString methods.
	InclusionFilters []*string `locationName:"inclusionFilters" min:"1" type:"list" sensitive:"true"`

	// The supported object type or content type of the data source.
	//
	// ObjectType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PatternObjectFilter's
	// String and GoString methods.
	//
	// ObjectType is a required field
	ObjectType *string `locationName:"objectType" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PatternObjectFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PatternObjectFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatternObjectFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PatternObjectFilter"}
	if s.ExclusionFilters != nil && len(s.ExclusionFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusionFilters", 1))
	}
	if s.InclusionFilters != nil && len(s.InclusionFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InclusionFilters", 1))
	}
	if s.ObjectType == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectType"))
	}
	if s.ObjectType != nil && len(*s.ObjectType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusionFilters sets the ExclusionFilters field's value.
func (s *PatternObjectFilter) SetExclusionFilters(v []*string) *PatternObjectFilter {
	s.ExclusionFilters = v
	return s
}

// SetInclusionFilters sets the InclusionFilters field's value.
func (s *PatternObjectFilter) SetInclusionFilters(v []*string) *PatternObjectFilter {
	s.InclusionFilters = v
	return s
}

// SetObjectType sets the ObjectType field's value.
func (s *PatternObjectFilter) SetObjectType(v string) *PatternObjectFilter {
	s.ObjectType = &v
	return s
}

// The configuration of filtering certain objects or content types of the data
// source.
type PatternObjectFilterConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of specific filters applied to your data source content.
	// You can filter out or include certain content.
	//
	// Filters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PatternObjectFilterConfiguration's
	// String and GoString methods.
	//
	// Filters is a required field
	Filters []*PatternObjectFilter `locationName:"filters" min:"1" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PatternObjectFilterConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PatternObjectFilterConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PatternObjectFilterConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PatternObjectFilterConfiguration"}
	if s.Filters == nil {
		invalidParams.Add(request.NewErrParamRequired("Filters"))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *PatternObjectFilterConfiguration) SetFilters(v []*PatternObjectFilter) *PatternObjectFilterConfiguration {
	s.Filters = v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Pinecone. For more information, see Create a vector index in Pinecone (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-pinecone.html).
type PineconeConfiguration struct {
	_ struct{} `type:"structure"`

	// The endpoint URL for your index management page.
	//
	// ConnectionString is a required field
	ConnectionString *string `locationName:"connectionString" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Pinecone API key.
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *PineconeFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The namespace to be used to write new data to your database.
	Namespace *string `locationName:"namespace" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PineconeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PineconeConfiguration"}
	if s.ConnectionString == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionString"))
	}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionString sets the ConnectionString field's value.
func (s *PineconeConfiguration) SetConnectionString(v string) *PineconeConfiguration {
	s.ConnectionString = &v
	return s
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *PineconeConfiguration) SetCredentialsSecretArn(v string) *PineconeConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *PineconeConfiguration) SetFieldMapping(v *PineconeFieldMapping) *PineconeConfiguration {
	s.FieldMapping = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PineconeConfiguration) SetNamespace(v string) *PineconeConfiguration {
	s.Namespace = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type PineconeFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PineconeFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PineconeFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PineconeFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *PineconeFieldMapping) SetMetadataField(v string) *PineconeFieldMapping {
	s.MetadataField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *PineconeFieldMapping) SetTextField(v string) *PineconeFieldMapping {
	s.TextField = &v
	return s
}

type PrepareAgentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the agent for which to create a DRAFT version.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrepareAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrepareAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *PrepareAgentInput) SetAgentId(v string) *PrepareAgentInput {
	s.AgentId = &v
	return s
}

type PrepareAgentOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent for which the DRAFT version was created.
	//
	// AgentId is a required field
	AgentId *string `locationName:"agentId" type:"string" required:"true"`

	// The status of the DRAFT version and whether it is ready for use.
	//
	// AgentStatus is a required field
	AgentStatus *string `locationName:"agentStatus" type:"string" required:"true" enum:"AgentStatus"`

	// The version of the agent.
	//
	// AgentVersion is a required field
	AgentVersion *string `locationName:"agentVersion" min:"1" type:"string" required:"true"`

	// The time at which the DRAFT version of the agent was last prepared.
	//
	// PreparedAt is a required field
	PreparedAt *time.Time `locationName:"preparedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareAgentOutput) GoString() string {
	return s.String()
}

// SetAgentId sets the AgentId field's value.
func (s *PrepareAgentOutput) SetAgentId(v string) *PrepareAgentOutput {
	s.AgentId = &v
	return s
}

// SetAgentStatus sets the AgentStatus field's value.
func (s *PrepareAgentOutput) SetAgentStatus(v string) *PrepareAgentOutput {
	s.AgentStatus = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *PrepareAgentOutput) SetAgentVersion(v string) *PrepareAgentOutput {
	s.AgentVersion = &v
	return s
}

// SetPreparedAt sets the PreparedAt field's value.
func (s *PrepareAgentOutput) SetPreparedAt(v time.Time) *PrepareAgentOutput {
	s.PreparedAt = &v
	return s
}

type PrepareFlowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the flow.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PrepareFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PrepareFlowInput"}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *PrepareFlowInput) SetFlowIdentifier(v string) *PrepareFlowInput {
	s.FlowIdentifier = &v
	return s
}

type PrepareFlowOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The status of the flow. When you submit this request, the status will be
	// NotPrepared. If preparation succeeds, the status becomes Prepared. If it
	// fails, the status becomes FAILED.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PrepareFlowOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *PrepareFlowOutput) SetId(v string) *PrepareFlowOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PrepareFlowOutput) SetStatus(v string) *PrepareFlowOutput {
	s.Status = &v
	return s
}

// Contains configurations to override a prompt template in one part of an agent
// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
type PromptConfiguration struct {
	_ struct{} `type:"structure"`

	// Defines the prompt template with which to replace the default prompt template.
	// You can use placeholder variables in the base prompt template to customize
	// the prompt. For more information, see Prompt template placeholder variables
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-placeholders.html).
	// For more information, see Configure the prompt templates (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts-configure.html).
	//
	// BasePromptTemplate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PromptConfiguration's
	// String and GoString methods.
	BasePromptTemplate *string `locationName:"basePromptTemplate" min:"1" type:"string" sensitive:"true"`

	// Contains inference parameters to use when the agent invokes a foundation
	// model in the part of the agent sequence defined by the promptType. For more
	// information, see Inference parameters for foundation models (https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
	InferenceConfiguration *InferenceConfiguration `locationName:"inferenceConfiguration" type:"structure"`

	// Specifies whether to override the default parser Lambda function when parsing
	// the raw foundation model output in the part of the agent sequence defined
	// by the promptType. If you set the field as OVERRIDEN, the overrideLambda
	// field in the PromptOverrideConfiguration (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptOverrideConfiguration.html)
	// must be specified with the ARN of a Lambda function.
	ParserMode *string `locationName:"parserMode" type:"string" enum:"CreationMode"`

	// Specifies whether to override the default prompt template for this promptType.
	// Set this value to OVERRIDDEN to use the prompt that you provide in the basePromptTemplate.
	// If you leave it as DEFAULT, the agent uses a default prompt template.
	PromptCreationMode *string `locationName:"promptCreationMode" type:"string" enum:"CreationMode"`

	// Specifies whether to allow the agent to carry out the step specified in the
	// promptType. If you set this value to DISABLED, the agent skips that step.
	// The default state for each promptType is as follows.
	//
	//    * PRE_PROCESSING – ENABLED
	//
	//    * ORCHESTRATION – ENABLED
	//
	//    * KNOWLEDGE_BASE_RESPONSE_GENERATION – ENABLED
	//
	//    * POST_PROCESSING – DISABLED
	PromptState *string `locationName:"promptState" type:"string" enum:"PromptState"`

	// The step in the agent sequence that this prompt configuration applies to.
	PromptType *string `locationName:"promptType" type:"string" enum:"PromptType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptConfiguration"}
	if s.BasePromptTemplate != nil && len(*s.BasePromptTemplate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasePromptTemplate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePromptTemplate sets the BasePromptTemplate field's value.
func (s *PromptConfiguration) SetBasePromptTemplate(v string) *PromptConfiguration {
	s.BasePromptTemplate = &v
	return s
}

// SetInferenceConfiguration sets the InferenceConfiguration field's value.
func (s *PromptConfiguration) SetInferenceConfiguration(v *InferenceConfiguration) *PromptConfiguration {
	s.InferenceConfiguration = v
	return s
}

// SetParserMode sets the ParserMode field's value.
func (s *PromptConfiguration) SetParserMode(v string) *PromptConfiguration {
	s.ParserMode = &v
	return s
}

// SetPromptCreationMode sets the PromptCreationMode field's value.
func (s *PromptConfiguration) SetPromptCreationMode(v string) *PromptConfiguration {
	s.PromptCreationMode = &v
	return s
}

// SetPromptState sets the PromptState field's value.
func (s *PromptConfiguration) SetPromptState(v string) *PromptConfiguration {
	s.PromptState = &v
	return s
}

// SetPromptType sets the PromptType field's value.
func (s *PromptConfiguration) SetPromptType(v string) *PromptConfiguration {
	s.PromptType = &v
	return s
}

// Contains configurations for a prompt node in the flow. You can use a prompt
// from Prompt management or you can define one in this node. If the prompt
// contains variables, the inputs into this node will fill in the variables.
// The output from this node is the response generated by the model. For more
// information, see Node types in Amazon Bedrock works (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html)
// in the Amazon Bedrock User Guide.
type PromptFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether the prompt is from Prompt management or defined inline.
	//
	// SourceConfiguration is a required field
	SourceConfiguration *PromptFlowNodeSourceConfiguration `locationName:"sourceConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptFlowNodeConfiguration"}
	if s.SourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConfiguration"))
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *PromptFlowNodeConfiguration) SetSourceConfiguration(v *PromptFlowNodeSourceConfiguration) *PromptFlowNodeConfiguration {
	s.SourceConfiguration = v
	return s
}

// Contains configurations for a prompt defined inline in the node.
type PromptFlowNodeInlineConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains inference configurations for the prompt.
	InferenceConfiguration *PromptInferenceConfiguration `locationName:"inferenceConfiguration" type:"structure"`

	// The unique identifier of the model to run inference with.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// Contains a prompt and variables in the prompt that can be replaced with values
	// at runtime.
	//
	// TemplateConfiguration is a required field
	TemplateConfiguration *PromptTemplateConfiguration `locationName:"templateConfiguration" type:"structure" required:"true"`

	// The type of prompt template.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"PromptTemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeInlineConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeInlineConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptFlowNodeInlineConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptFlowNodeInlineConfiguration"}
	if s.ModelId == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.TemplateConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateConfiguration"))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}
	if s.TemplateConfiguration != nil {
		if err := s.TemplateConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TemplateConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceConfiguration sets the InferenceConfiguration field's value.
func (s *PromptFlowNodeInlineConfiguration) SetInferenceConfiguration(v *PromptInferenceConfiguration) *PromptFlowNodeInlineConfiguration {
	s.InferenceConfiguration = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *PromptFlowNodeInlineConfiguration) SetModelId(v string) *PromptFlowNodeInlineConfiguration {
	s.ModelId = &v
	return s
}

// SetTemplateConfiguration sets the TemplateConfiguration field's value.
func (s *PromptFlowNodeInlineConfiguration) SetTemplateConfiguration(v *PromptTemplateConfiguration) *PromptFlowNodeInlineConfiguration {
	s.TemplateConfiguration = v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *PromptFlowNodeInlineConfiguration) SetTemplateType(v string) *PromptFlowNodeInlineConfiguration {
	s.TemplateType = &v
	return s
}

// Contains configurations for a prompt from Prompt management to use in a node.
type PromptFlowNodeResourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the prompt from Prompt management.
	//
	// PromptArn is a required field
	PromptArn *string `locationName:"promptArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeResourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeResourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptFlowNodeResourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptFlowNodeResourceConfiguration"}
	if s.PromptArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPromptArn sets the PromptArn field's value.
func (s *PromptFlowNodeResourceConfiguration) SetPromptArn(v string) *PromptFlowNodeResourceConfiguration {
	s.PromptArn = &v
	return s
}

// Contains configurations for a prompt and whether it is from Prompt management
// or defined inline.
type PromptFlowNodeSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for a prompt that is defined inline
	Inline *PromptFlowNodeInlineConfiguration `locationName:"inline" type:"structure"`

	// Contains configurations for a prompt from Prompt management.
	Resource *PromptFlowNodeResourceConfiguration `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptFlowNodeSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptFlowNodeSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptFlowNodeSourceConfiguration"}
	if s.Inline != nil {
		if err := s.Inline.Validate(); err != nil {
			invalidParams.AddNested("Inline", err.(request.ErrInvalidParams))
		}
	}
	if s.Resource != nil {
		if err := s.Resource.Validate(); err != nil {
			invalidParams.AddNested("Resource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInline sets the Inline field's value.
func (s *PromptFlowNodeSourceConfiguration) SetInline(v *PromptFlowNodeInlineConfiguration) *PromptFlowNodeSourceConfiguration {
	s.Inline = v
	return s
}

// SetResource sets the Resource field's value.
func (s *PromptFlowNodeSourceConfiguration) SetResource(v *PromptFlowNodeResourceConfiguration) *PromptFlowNodeSourceConfiguration {
	s.Resource = v
	return s
}

// Contains inference configurations for the prompt.
type PromptInferenceConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains inference configurations for a text prompt.
	Text *PromptModelInferenceConfiguration `locationName:"text" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptInferenceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptInferenceConfiguration) GoString() string {
	return s.String()
}

// SetText sets the Text field's value.
func (s *PromptInferenceConfiguration) SetText(v *PromptModelInferenceConfiguration) *PromptInferenceConfiguration {
	s.Text = v
	return s
}

// Contains information about a variable in the prompt.
type PromptInputVariable struct {
	_ struct{} `type:"structure"`

	// The name of the variable.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptInputVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptInputVariable) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *PromptInputVariable) SetName(v string) *PromptInputVariable {
	s.Name = &v
	return s
}

// Contains inference configurations related to model inference for a prompt.
// For more information, see Inference parameters (https://docs.aws.amazon.com/bedrock/latest/userguide/inference-parameters.html).
type PromptModelInferenceConfiguration struct {
	_ struct{} `type:"structure"`

	// The maximum number of tokens to return in the response.
	MaxTokens *int64 `locationName:"maxTokens" type:"integer"`

	// A list of strings that define sequences after which the model will stop generating.
	StopSequences []*string `locationName:"stopSequences" type:"list"`

	// Controls the randomness of the response. Choose a lower value for more predictable
	// outputs and a higher value for more surprising outputs.
	Temperature *float64 `locationName:"temperature" type:"float"`

	// The number of most-likely candidates that the model considers for the next
	// token during generation.
	TopK *int64 `locationName:"topK" type:"integer"`

	// The percentage of most-likely candidates that the model considers for the
	// next token.
	TopP *float64 `locationName:"topP" type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptModelInferenceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptModelInferenceConfiguration) GoString() string {
	return s.String()
}

// SetMaxTokens sets the MaxTokens field's value.
func (s *PromptModelInferenceConfiguration) SetMaxTokens(v int64) *PromptModelInferenceConfiguration {
	s.MaxTokens = &v
	return s
}

// SetStopSequences sets the StopSequences field's value.
func (s *PromptModelInferenceConfiguration) SetStopSequences(v []*string) *PromptModelInferenceConfiguration {
	s.StopSequences = v
	return s
}

// SetTemperature sets the Temperature field's value.
func (s *PromptModelInferenceConfiguration) SetTemperature(v float64) *PromptModelInferenceConfiguration {
	s.Temperature = &v
	return s
}

// SetTopK sets the TopK field's value.
func (s *PromptModelInferenceConfiguration) SetTopK(v int64) *PromptModelInferenceConfiguration {
	s.TopK = &v
	return s
}

// SetTopP sets the TopP field's value.
func (s *PromptModelInferenceConfiguration) SetTopP(v float64) *PromptModelInferenceConfiguration {
	s.TopP = &v
	return s
}

// Contains configurations to override prompts in different parts of an agent
// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
type PromptOverrideConfiguration struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The ARN of the Lambda function to use when parsing the raw foundation model
	// output in parts of the agent sequence. If you specify this field, at least
	// one of the promptConfigurations must contain a parserMode value that is set
	// to OVERRIDDEN. For more information, see Parser Lambda function in Agents
	// for Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/lambda-parser.html).
	OverrideLambda *string `locationName:"overrideLambda" type:"string"`

	// Contains configurations to override a prompt template in one part of an agent
	// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptConfigurations is a required field
	PromptConfigurations []*PromptConfiguration `locationName:"promptConfigurations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptOverrideConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptOverrideConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptOverrideConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptOverrideConfiguration"}
	if s.PromptConfigurations == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptConfigurations"))
	}
	if s.PromptConfigurations != nil {
		for i, v := range s.PromptConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PromptConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOverrideLambda sets the OverrideLambda field's value.
func (s *PromptOverrideConfiguration) SetOverrideLambda(v string) *PromptOverrideConfiguration {
	s.OverrideLambda = &v
	return s
}

// SetPromptConfigurations sets the PromptConfigurations field's value.
func (s *PromptOverrideConfiguration) SetPromptConfigurations(v []*PromptConfiguration) *PromptOverrideConfiguration {
	s.PromptConfigurations = v
	return s
}

// Contains information about a prompt in your Prompt management tool.
//
// This data type is used in the following API operations:
//
//   - ListPrompts response (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_ListPrompts.html#API_agent_ListPrompts_ResponseSyntax)
type PromptSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the prompt.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the prompt was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the prompt.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the prompt.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the prompt.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time at which the prompt was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version of the prompt that this summary applies to.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *PromptSummary) SetArn(v string) *PromptSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PromptSummary) SetCreatedAt(v time.Time) *PromptSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PromptSummary) SetDescription(v string) *PromptSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *PromptSummary) SetId(v string) *PromptSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *PromptSummary) SetName(v string) *PromptSummary {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *PromptSummary) SetUpdatedAt(v time.Time) *PromptSummary {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *PromptSummary) SetVersion(v string) *PromptSummary {
	s.Version = &v
	return s
}

// Contains the message for a prompt. For more information, see Prompt management
// in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html).
type PromptTemplateConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for the text in a message for a prompt.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PromptTemplateConfiguration's
	// String and GoString methods.
	Text *TextPromptTemplateConfiguration `locationName:"text" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptTemplateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptTemplateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptTemplateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptTemplateConfiguration"}
	if s.Text != nil {
		if err := s.Text.Validate(); err != nil {
			invalidParams.AddNested("Text", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *PromptTemplateConfiguration) SetText(v *TextPromptTemplateConfiguration) *PromptTemplateConfiguration {
	s.Text = v
	return s
}

// Contains details about a variant of the prompt.
type PromptVariant struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Contains inference configurations for the prompt variant.
	InferenceConfiguration *PromptInferenceConfiguration `locationName:"inferenceConfiguration" type:"structure"`

	// The unique identifier of the model with which to run inference on the prompt.
	ModelId *string `locationName:"modelId" min:"1" type:"string"`

	// The name of the prompt variant.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains configurations for the prompt template.
	TemplateConfiguration *PromptTemplateConfiguration `locationName:"templateConfiguration" type:"structure"`

	// The type of prompt template to use.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"PromptTemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptVariant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PromptVariant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PromptVariant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PromptVariant"}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}
	if s.TemplateConfiguration != nil {
		if err := s.TemplateConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TemplateConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInferenceConfiguration sets the InferenceConfiguration field's value.
func (s *PromptVariant) SetInferenceConfiguration(v *PromptInferenceConfiguration) *PromptVariant {
	s.InferenceConfiguration = v
	return s
}

// SetModelId sets the ModelId field's value.
func (s *PromptVariant) SetModelId(v string) *PromptVariant {
	s.ModelId = &v
	return s
}

// SetName sets the Name field's value.
func (s *PromptVariant) SetName(v string) *PromptVariant {
	s.Name = &v
	return s
}

// SetTemplateConfiguration sets the TemplateConfiguration field's value.
func (s *PromptVariant) SetTemplateConfiguration(v *PromptTemplateConfiguration) *PromptVariant {
	s.TemplateConfiguration = v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *PromptVariant) SetTemplateType(v string) *PromptVariant {
	s.TemplateType = &v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Amazon RDS. For more information, see Create a vector index in Amazon RDS
// (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html).
type RdsConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Amazon RDS database.
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The name of your Amazon RDS database.
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *RdsFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the vector store.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The name of the table in the database.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RdsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RdsConfiguration"}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *RdsConfiguration) SetCredentialsSecretArn(v string) *RdsConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RdsConfiguration) SetDatabaseName(v string) *RdsConfiguration {
	s.DatabaseName = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *RdsConfiguration) SetFieldMapping(v *RdsFieldMapping) *RdsConfiguration {
	s.FieldMapping = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RdsConfiguration) SetResourceArn(v string) *RdsConfiguration {
	s.ResourceArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *RdsConfiguration) SetTableName(v string) *RdsConfiguration {
	s.TableName = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type RdsFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the ID for each entry.
	//
	// PrimaryKeyField is a required field
	PrimaryKeyField *string `locationName:"primaryKeyField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the vector embeddings
	// for your data sources.
	//
	// VectorField is a required field
	VectorField *string `locationName:"vectorField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RdsFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RdsFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RdsFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.PrimaryKeyField == nil {
		invalidParams.Add(request.NewErrParamRequired("PrimaryKeyField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}
	if s.VectorField == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *RdsFieldMapping) SetMetadataField(v string) *RdsFieldMapping {
	s.MetadataField = &v
	return s
}

// SetPrimaryKeyField sets the PrimaryKeyField field's value.
func (s *RdsFieldMapping) SetPrimaryKeyField(v string) *RdsFieldMapping {
	s.PrimaryKeyField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *RdsFieldMapping) SetTextField(v string) *RdsFieldMapping {
	s.TextField = &v
	return s
}

// SetVectorField sets the VectorField field's value.
func (s *RdsFieldMapping) SetVectorField(v string) *RdsFieldMapping {
	s.VectorField = &v
	return s
}

// Contains details about the storage configuration of the knowledge base in
// Redis Enterprise Cloud. For more information, see Create a vector index in
// Redis Enterprise Cloud (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-oss.html).
type RedisEnterpriseCloudConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the secret that you created in Secrets
	// Manager that is linked to your Redis Enterprise Cloud database.
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The endpoint URL of the Redis Enterprise Cloud database.
	//
	// Endpoint is a required field
	Endpoint *string `locationName:"endpoint" type:"string" required:"true"`

	// Contains the names of the fields to which to map information about the vector
	// store.
	//
	// FieldMapping is a required field
	FieldMapping *RedisEnterpriseCloudFieldMapping `locationName:"fieldMapping" type:"structure" required:"true"`

	// The name of the vector index.
	//
	// VectorIndexName is a required field
	VectorIndexName *string `locationName:"vectorIndexName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedisEnterpriseCloudConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedisEnterpriseCloudConfiguration"}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.Endpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("Endpoint"))
	}
	if s.FieldMapping == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldMapping"))
	}
	if s.VectorIndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorIndexName"))
	}
	if s.FieldMapping != nil {
		if err := s.FieldMapping.Validate(); err != nil {
			invalidParams.AddNested("FieldMapping", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *RedisEnterpriseCloudConfiguration) SetCredentialsSecretArn(v string) *RedisEnterpriseCloudConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *RedisEnterpriseCloudConfiguration) SetEndpoint(v string) *RedisEnterpriseCloudConfiguration {
	s.Endpoint = &v
	return s
}

// SetFieldMapping sets the FieldMapping field's value.
func (s *RedisEnterpriseCloudConfiguration) SetFieldMapping(v *RedisEnterpriseCloudFieldMapping) *RedisEnterpriseCloudConfiguration {
	s.FieldMapping = v
	return s
}

// SetVectorIndexName sets the VectorIndexName field's value.
func (s *RedisEnterpriseCloudConfiguration) SetVectorIndexName(v string) *RedisEnterpriseCloudConfiguration {
	s.VectorIndexName = &v
	return s
}

// Contains the names of the fields to which to map information about the vector
// store.
type RedisEnterpriseCloudFieldMapping struct {
	_ struct{} `type:"structure"`

	// The name of the field in which Amazon Bedrock stores metadata about the vector
	// store.
	//
	// MetadataField is a required field
	MetadataField *string `locationName:"metadataField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the raw text from your
	// data. The text is split according to the chunking strategy you choose.
	//
	// TextField is a required field
	TextField *string `locationName:"textField" type:"string" required:"true"`

	// The name of the field in which Amazon Bedrock stores the vector embeddings
	// for your data sources.
	//
	// VectorField is a required field
	VectorField *string `locationName:"vectorField" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudFieldMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedisEnterpriseCloudFieldMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedisEnterpriseCloudFieldMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedisEnterpriseCloudFieldMapping"}
	if s.MetadataField == nil {
		invalidParams.Add(request.NewErrParamRequired("MetadataField"))
	}
	if s.TextField == nil {
		invalidParams.Add(request.NewErrParamRequired("TextField"))
	}
	if s.VectorField == nil {
		invalidParams.Add(request.NewErrParamRequired("VectorField"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMetadataField sets the MetadataField field's value.
func (s *RedisEnterpriseCloudFieldMapping) SetMetadataField(v string) *RedisEnterpriseCloudFieldMapping {
	s.MetadataField = &v
	return s
}

// SetTextField sets the TextField field's value.
func (s *RedisEnterpriseCloudFieldMapping) SetTextField(v string) *RedisEnterpriseCloudFieldMapping {
	s.TextField = &v
	return s
}

// SetVectorField sets the VectorField field's value.
func (s *RedisEnterpriseCloudFieldMapping) SetVectorField(v string) *RedisEnterpriseCloudFieldMapping {
	s.VectorField = &v
	return s
}

// The specified resource Amazon Resource Name (ARN) was not found. Check the
// Amazon Resource Name (ARN) and try your request again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains configurations for a Retrieval node in a flow. This node retrieves
// data from the Amazon S3 location that you specify and returns it as the output.
type RetrievalFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for the service to use for retrieving data to return
	// as the output from the node.
	//
	// ServiceConfiguration is a required field
	ServiceConfiguration *RetrievalFlowNodeServiceConfiguration `locationName:"serviceConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrievalFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrievalFlowNodeConfiguration"}
	if s.ServiceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceConfiguration"))
	}
	if s.ServiceConfiguration != nil {
		if err := s.ServiceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServiceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceConfiguration sets the ServiceConfiguration field's value.
func (s *RetrievalFlowNodeConfiguration) SetServiceConfiguration(v *RetrievalFlowNodeServiceConfiguration) *RetrievalFlowNodeConfiguration {
	s.ServiceConfiguration = v
	return s
}

// Contains configurations for the Amazon S3 location from which to retrieve
// data to return as the output from the node.
type RetrievalFlowNodeS3Configuration struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket from which to retrieve data.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFlowNodeS3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFlowNodeS3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrievalFlowNodeS3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrievalFlowNodeS3Configuration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *RetrievalFlowNodeS3Configuration) SetBucketName(v string) *RetrievalFlowNodeS3Configuration {
	s.BucketName = &v
	return s
}

// Contains configurations for the service to use for retrieving data to return
// as the output from the node.
type RetrievalFlowNodeServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for the Amazon S3 location from which to retrieve
	// data to return as the output from the node.
	S3 *RetrievalFlowNodeS3Configuration `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFlowNodeServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetrievalFlowNodeServiceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetrievalFlowNodeServiceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetrievalFlowNodeServiceConfiguration"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *RetrievalFlowNodeServiceConfiguration) SetS3(v *RetrievalFlowNodeS3Configuration) *RetrievalFlowNodeServiceConfiguration {
	s.S3 = v
	return s
}

// The configuration information to connect to Amazon S3 as your data source.
type S3DataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket that contains your data.
	//
	// BucketArn is a required field
	BucketArn *string `locationName:"bucketArn" min:"1" type:"string" required:"true"`

	// The account ID for the owner of the S3 bucket.
	BucketOwnerAccountId *string `locationName:"bucketOwnerAccountId" min:"12" type:"string"`

	// A list of S3 prefixes to include certain files or content. For more information,
	// see Organizing objects using prefixes (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html).
	InclusionPrefixes []*string `locationName:"inclusionPrefixes" min:"1" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DataSourceConfiguration"}
	if s.BucketArn == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketArn"))
	}
	if s.BucketArn != nil && len(*s.BucketArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketArn", 1))
	}
	if s.BucketOwnerAccountId != nil && len(*s.BucketOwnerAccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("BucketOwnerAccountId", 12))
	}
	if s.InclusionPrefixes != nil && len(s.InclusionPrefixes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InclusionPrefixes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketArn sets the BucketArn field's value.
func (s *S3DataSourceConfiguration) SetBucketArn(v string) *S3DataSourceConfiguration {
	s.BucketArn = &v
	return s
}

// SetBucketOwnerAccountId sets the BucketOwnerAccountId field's value.
func (s *S3DataSourceConfiguration) SetBucketOwnerAccountId(v string) *S3DataSourceConfiguration {
	s.BucketOwnerAccountId = &v
	return s
}

// SetInclusionPrefixes sets the InclusionPrefixes field's value.
func (s *S3DataSourceConfiguration) SetInclusionPrefixes(v []*string) *S3DataSourceConfiguration {
	s.InclusionPrefixes = v
	return s
}

// The identifier information for an Amazon S3 bucket.
type S3Identifier struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	S3BucketName *string `locationName:"s3BucketName" min:"3" type:"string"`

	// The S3 object key for the S3 resource.
	S3ObjectKey *string `locationName:"s3ObjectKey" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Identifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Identifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Identifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Identifier"}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 3))
	}
	if s.S3ObjectKey != nil && len(*s.S3ObjectKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *S3Identifier) SetS3BucketName(v string) *S3Identifier {
	s.S3BucketName = &v
	return s
}

// SetS3ObjectKey sets the S3ObjectKey field's value.
func (s *S3Identifier) SetS3ObjectKey(v string) *S3Identifier {
	s.S3ObjectKey = &v
	return s
}

// An Amazon S3 location.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The location's URI. For example, s3://my-bucket/chunk-processor/.
	//
	// Uri is a required field
	Uri *string `locationName:"uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Location) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Location"}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUri sets the Uri field's value.
func (s *S3Location) SetUri(v string) *S3Location {
	s.Uri = &v
	return s
}

// The configuration of the Salesforce content. For example, configuring specific
// types of Salesforce content.
type SalesforceCrawlerConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of filtering the Salesforce content. For example, configuring
	// regular expression patterns to include or exclude certain content.
	FilterConfiguration *CrawlFilterConfiguration `locationName:"filterConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceCrawlerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceCrawlerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceCrawlerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceCrawlerConfiguration"}
	if s.FilterConfiguration != nil {
		if err := s.FilterConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FilterConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *SalesforceCrawlerConfiguration) SetFilterConfiguration(v *CrawlFilterConfiguration) *SalesforceCrawlerConfiguration {
	s.FilterConfiguration = v
	return s
}

// The configuration information to connect to Salesforce as your data source.
type SalesforceDataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of the Salesforce content. For example, configuring specific
	// types of Salesforce content.
	CrawlerConfiguration *SalesforceCrawlerConfiguration `locationName:"crawlerConfiguration" type:"structure"`

	// The endpoint information to connect to your Salesforce data source.
	//
	// SourceConfiguration is a required field
	SourceConfiguration *SalesforceSourceConfiguration `locationName:"sourceConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceDataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceDataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceDataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceDataSourceConfiguration"}
	if s.SourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConfiguration"))
	}
	if s.CrawlerConfiguration != nil {
		if err := s.CrawlerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CrawlerConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerConfiguration sets the CrawlerConfiguration field's value.
func (s *SalesforceDataSourceConfiguration) SetCrawlerConfiguration(v *SalesforceCrawlerConfiguration) *SalesforceDataSourceConfiguration {
	s.CrawlerConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *SalesforceDataSourceConfiguration) SetSourceConfiguration(v *SalesforceSourceConfiguration) *SalesforceDataSourceConfiguration {
	s.SourceConfiguration = v
	return s
}

// The endpoint information to connect to your Salesforce data source.
type SalesforceSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The supported authentication type to authenticate and connect to your Salesforce
	// instance.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"SalesforceAuthType"`

	// The Amazon Resource Name of an Secrets Manager secret that stores your authentication
	// credentials for your SharePoint site/sites. For more information on the key-value
	// pairs that must be included in your secret, depending on your authentication
	// type, see Salesforce connection configuration (https://docs.aws.amazon.com/bedrock/latest/userguide/salesforce-data-source-connector.html#configuration-salesforce-connector).
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The Salesforce host URL or instance URL.
	//
	// HostUrl is a required field
	HostUrl *string `locationName:"hostUrl" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SalesforceSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceSourceConfiguration"}
	if s.AuthType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthType"))
	}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.HostUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("HostUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *SalesforceSourceConfiguration) SetAuthType(v string) *SalesforceSourceConfiguration {
	s.AuthType = &v
	return s
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *SalesforceSourceConfiguration) SetCredentialsSecretArn(v string) *SalesforceSourceConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetHostUrl sets the HostUrl field's value.
func (s *SalesforceSourceConfiguration) SetHostUrl(v string) *SalesforceSourceConfiguration {
	s.HostUrl = &v
	return s
}

// The seed or starting point URL. You should be authorized to crawl the URL.
type SeedUrl struct {
	_ struct{} `type:"structure"`

	// A seed or starting point URL.
	Url *string `locationName:"url" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SeedUrl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SeedUrl) GoString() string {
	return s.String()
}

// SetUrl sets the Url field's value.
func (s *SeedUrl) SetUrl(v string) *SeedUrl {
	s.Url = &v
	return s
}

// Settings for semantic document chunking for a data source. Semantic chunking
// splits a document into into smaller documents based on groups of similar
// content derived from the text with natural language processing.
//
// With semantic chunking, each sentence is compared to the next to determine
// how similar they are. You specify a threshold in the form of a percentile,
// where adjacent sentences that are less similar than that percentage of sentence
// pairs are divided into separate chunks. For example, if you set the threshold
// to 90, then the 10 percent of sentence pairs that are least similar are split.
// So if you have 101 sentences, 100 sentence pairs are compared, and the 10
// with the least similarity are split, creating 11 chunks. These chunks are
// further split if they exceed the max token size.
//
// You must also specify a buffer size, which determines whether sentences are
// compared in isolation, or within a moving context window that includes the
// previous and following sentence. For example, if you set the buffer size
// to 1, the embedding for sentence 10 is derived from sentences 9, 10, and
// 11 combined.
type SemanticChunkingConfiguration struct {
	_ struct{} `type:"structure"`

	// The dissimilarity threshold for splitting chunks.
	//
	// BreakpointPercentileThreshold is a required field
	BreakpointPercentileThreshold *int64 `locationName:"breakpointPercentileThreshold" min:"50" type:"integer" required:"true"`

	// The buffer size.
	//
	// BufferSize is a required field
	BufferSize *int64 `locationName:"bufferSize" type:"integer" required:"true"`

	// The maximum number of tokens that a chunk can contain.
	//
	// MaxTokens is a required field
	MaxTokens *int64 `locationName:"maxTokens" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SemanticChunkingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SemanticChunkingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SemanticChunkingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SemanticChunkingConfiguration"}
	if s.BreakpointPercentileThreshold == nil {
		invalidParams.Add(request.NewErrParamRequired("BreakpointPercentileThreshold"))
	}
	if s.BreakpointPercentileThreshold != nil && *s.BreakpointPercentileThreshold < 50 {
		invalidParams.Add(request.NewErrParamMinValue("BreakpointPercentileThreshold", 50))
	}
	if s.BufferSize == nil {
		invalidParams.Add(request.NewErrParamRequired("BufferSize"))
	}
	if s.MaxTokens == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxTokens"))
	}
	if s.MaxTokens != nil && *s.MaxTokens < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxTokens", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBreakpointPercentileThreshold sets the BreakpointPercentileThreshold field's value.
func (s *SemanticChunkingConfiguration) SetBreakpointPercentileThreshold(v int64) *SemanticChunkingConfiguration {
	s.BreakpointPercentileThreshold = &v
	return s
}

// SetBufferSize sets the BufferSize field's value.
func (s *SemanticChunkingConfiguration) SetBufferSize(v int64) *SemanticChunkingConfiguration {
	s.BufferSize = &v
	return s
}

// SetMaxTokens sets the MaxTokens field's value.
func (s *SemanticChunkingConfiguration) SetMaxTokens(v int64) *SemanticChunkingConfiguration {
	s.MaxTokens = &v
	return s
}

// Contains the configuration for server-side encryption.
type ServerSideEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the resource.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerSideEncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerSideEncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServerSideEncryptionConfiguration"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *ServerSideEncryptionConfiguration) SetKmsKeyArn(v string) *ServerSideEncryptionConfiguration {
	s.KmsKeyArn = &v
	return s
}

// The number of requests exceeds the service quota. Resubmit your request later.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration of the SharePoint content. For example, configuring specific
// types of SharePoint content.
type SharePointCrawlerConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of filtering the SharePoint content. For example, configuring
	// regular expression patterns to include or exclude certain content.
	FilterConfiguration *CrawlFilterConfiguration `locationName:"filterConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointCrawlerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointCrawlerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePointCrawlerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SharePointCrawlerConfiguration"}
	if s.FilterConfiguration != nil {
		if err := s.FilterConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FilterConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterConfiguration sets the FilterConfiguration field's value.
func (s *SharePointCrawlerConfiguration) SetFilterConfiguration(v *CrawlFilterConfiguration) *SharePointCrawlerConfiguration {
	s.FilterConfiguration = v
	return s
}

// The configuration information to connect to SharePoint as your data source.
type SharePointDataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of the SharePoint content. For example, configuring specific
	// types of SharePoint content.
	CrawlerConfiguration *SharePointCrawlerConfiguration `locationName:"crawlerConfiguration" type:"structure"`

	// The endpoint information to connect to your SharePoint data source.
	//
	// SourceConfiguration is a required field
	SourceConfiguration *SharePointSourceConfiguration `locationName:"sourceConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointDataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointDataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePointDataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SharePointDataSourceConfiguration"}
	if s.SourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConfiguration"))
	}
	if s.CrawlerConfiguration != nil {
		if err := s.CrawlerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CrawlerConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerConfiguration sets the CrawlerConfiguration field's value.
func (s *SharePointDataSourceConfiguration) SetCrawlerConfiguration(v *SharePointCrawlerConfiguration) *SharePointDataSourceConfiguration {
	s.CrawlerConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *SharePointDataSourceConfiguration) SetSourceConfiguration(v *SharePointSourceConfiguration) *SharePointDataSourceConfiguration {
	s.SourceConfiguration = v
	return s
}

// The endpoint information to connect to your SharePoint data source.
type SharePointSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The supported authentication type to authenticate and connect to your SharePoint
	// site/sites.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"SharePointAuthType"`

	// The Amazon Resource Name of an Secrets Manager secret that stores your authentication
	// credentials for your SharePoint site/sites. For more information on the key-value
	// pairs that must be included in your secret, depending on your authentication
	// type, see SharePoint connection configuration (https://docs.aws.amazon.com/bedrock/latest/userguide/sharepoint-data-source-connector.html#configuration-sharepoint-connector).
	//
	// CredentialsSecretArn is a required field
	CredentialsSecretArn *string `locationName:"credentialsSecretArn" type:"string" required:"true"`

	// The domain of your SharePoint instance or site URL/URLs.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The supported host type, whether online/cloud or server/on-premises.
	//
	// HostType is a required field
	HostType *string `locationName:"hostType" type:"string" required:"true" enum:"SharePointHostType"`

	// A list of one or more SharePoint site URLs.
	//
	// SiteUrls is a required field
	SiteUrls []*string `locationName:"siteUrls" min:"1" type:"list" required:"true"`

	// The identifier of your Microsoft 365 tenant.
	TenantId *string `locationName:"tenantId" min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SharePointSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SharePointSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SharePointSourceConfiguration"}
	if s.AuthType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthType"))
	}
	if s.CredentialsSecretArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CredentialsSecretArn"))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Domain", 1))
	}
	if s.HostType == nil {
		invalidParams.Add(request.NewErrParamRequired("HostType"))
	}
	if s.SiteUrls == nil {
		invalidParams.Add(request.NewErrParamRequired("SiteUrls"))
	}
	if s.SiteUrls != nil && len(s.SiteUrls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SiteUrls", 1))
	}
	if s.TenantId != nil && len(*s.TenantId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("TenantId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *SharePointSourceConfiguration) SetAuthType(v string) *SharePointSourceConfiguration {
	s.AuthType = &v
	return s
}

// SetCredentialsSecretArn sets the CredentialsSecretArn field's value.
func (s *SharePointSourceConfiguration) SetCredentialsSecretArn(v string) *SharePointSourceConfiguration {
	s.CredentialsSecretArn = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *SharePointSourceConfiguration) SetDomain(v string) *SharePointSourceConfiguration {
	s.Domain = &v
	return s
}

// SetHostType sets the HostType field's value.
func (s *SharePointSourceConfiguration) SetHostType(v string) *SharePointSourceConfiguration {
	s.HostType = &v
	return s
}

// SetSiteUrls sets the SiteUrls field's value.
func (s *SharePointSourceConfiguration) SetSiteUrls(v []*string) *SharePointSourceConfiguration {
	s.SiteUrls = v
	return s
}

// SetTenantId sets the TenantId field's value.
func (s *SharePointSourceConfiguration) SetTenantId(v string) *SharePointSourceConfiguration {
	s.TenantId = &v
	return s
}

type StartIngestionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier to ensure that the API request completes
	// no more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information,
	// see Ensuring idempotency (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
	ClientToken *string `locationName:"clientToken" min:"33" type:"string" idempotencyToken:"true"`

	// The unique identifier of the data source to ingest.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// A description of the ingestion job.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base to which to add the data source.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartIngestionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartIngestionJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 33 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 33))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *StartIngestionJobInput) SetClientToken(v string) *StartIngestionJobInput {
	s.ClientToken = &v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *StartIngestionJobInput) SetDataSourceId(v string) *StartIngestionJobInput {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartIngestionJobInput) SetDescription(v string) *StartIngestionJobInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *StartIngestionJobInput) SetKnowledgeBaseId(v string) *StartIngestionJobInput {
	s.KnowledgeBaseId = &v
	return s
}

type StartIngestionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the ingestion job.
	//
	// IngestionJob is a required field
	IngestionJob *IngestionJob `locationName:"ingestionJob" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartIngestionJobOutput) GoString() string {
	return s.String()
}

// SetIngestionJob sets the IngestionJob field's value.
func (s *StartIngestionJobOutput) SetIngestionJob(v *IngestionJob) *StartIngestionJobOutput {
	s.IngestionJob = v
	return s
}

// Contains the storage configuration of the knowledge base.
type StorageConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains the storage configuration of the knowledge base in MongoDB Atlas.
	MongoDbAtlasConfiguration *MongoDbAtlasConfiguration `locationName:"mongoDbAtlasConfiguration" type:"structure"`

	// Contains the storage configuration of the knowledge base in Amazon OpenSearch
	// Service.
	OpensearchServerlessConfiguration *OpenSearchServerlessConfiguration `locationName:"opensearchServerlessConfiguration" type:"structure"`

	// Contains the storage configuration of the knowledge base in Pinecone.
	PineconeConfiguration *PineconeConfiguration `locationName:"pineconeConfiguration" type:"structure"`

	// Contains details about the storage configuration of the knowledge base in
	// Amazon RDS. For more information, see Create a vector index in Amazon RDS
	// (https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-rds.html).
	RdsConfiguration *RdsConfiguration `locationName:"rdsConfiguration" type:"structure"`

	// Contains the storage configuration of the knowledge base in Redis Enterprise
	// Cloud.
	RedisEnterpriseCloudConfiguration *RedisEnterpriseCloudConfiguration `locationName:"redisEnterpriseCloudConfiguration" type:"structure"`

	// The vector store service in which the knowledge base is stored.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"KnowledgeBaseStorageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageConfiguration"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.MongoDbAtlasConfiguration != nil {
		if err := s.MongoDbAtlasConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MongoDbAtlasConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.OpensearchServerlessConfiguration != nil {
		if err := s.OpensearchServerlessConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OpensearchServerlessConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PineconeConfiguration != nil {
		if err := s.PineconeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PineconeConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RdsConfiguration != nil {
		if err := s.RdsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RdsConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RedisEnterpriseCloudConfiguration != nil {
		if err := s.RedisEnterpriseCloudConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RedisEnterpriseCloudConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMongoDbAtlasConfiguration sets the MongoDbAtlasConfiguration field's value.
func (s *StorageConfiguration) SetMongoDbAtlasConfiguration(v *MongoDbAtlasConfiguration) *StorageConfiguration {
	s.MongoDbAtlasConfiguration = v
	return s
}

// SetOpensearchServerlessConfiguration sets the OpensearchServerlessConfiguration field's value.
func (s *StorageConfiguration) SetOpensearchServerlessConfiguration(v *OpenSearchServerlessConfiguration) *StorageConfiguration {
	s.OpensearchServerlessConfiguration = v
	return s
}

// SetPineconeConfiguration sets the PineconeConfiguration field's value.
func (s *StorageConfiguration) SetPineconeConfiguration(v *PineconeConfiguration) *StorageConfiguration {
	s.PineconeConfiguration = v
	return s
}

// SetRdsConfiguration sets the RdsConfiguration field's value.
func (s *StorageConfiguration) SetRdsConfiguration(v *RdsConfiguration) *StorageConfiguration {
	s.RdsConfiguration = v
	return s
}

// SetRedisEnterpriseCloudConfiguration sets the RedisEnterpriseCloudConfiguration field's value.
func (s *StorageConfiguration) SetRedisEnterpriseCloudConfiguration(v *RedisEnterpriseCloudConfiguration) *StorageConfiguration {
	s.RedisEnterpriseCloudConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *StorageConfiguration) SetType(v string) *StorageConfiguration {
	s.Type = &v
	return s
}

// Contains configurations for a Storage node in a flow. This node stores the
// input in an Amazon S3 location that you specify.
type StorageFlowNodeConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for the service to use for storing the input into
	// the node.
	//
	// ServiceConfiguration is a required field
	ServiceConfiguration *StorageFlowNodeServiceConfiguration `locationName:"serviceConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageFlowNodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageFlowNodeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageFlowNodeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageFlowNodeConfiguration"}
	if s.ServiceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceConfiguration"))
	}
	if s.ServiceConfiguration != nil {
		if err := s.ServiceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServiceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceConfiguration sets the ServiceConfiguration field's value.
func (s *StorageFlowNodeConfiguration) SetServiceConfiguration(v *StorageFlowNodeServiceConfiguration) *StorageFlowNodeConfiguration {
	s.ServiceConfiguration = v
	return s
}

// Contains configurations for the Amazon S3 location in which to store the
// input into the node.
type StorageFlowNodeS3Configuration struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket in which to store the input into the node.
	//
	// BucketName is a required field
	BucketName *string `locationName:"bucketName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageFlowNodeS3Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageFlowNodeS3Configuration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageFlowNodeS3Configuration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageFlowNodeS3Configuration"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *StorageFlowNodeS3Configuration) SetBucketName(v string) *StorageFlowNodeS3Configuration {
	s.BucketName = &v
	return s
}

// Contains configurations for the service to use for storing the input into
// the node.
type StorageFlowNodeServiceConfiguration struct {
	_ struct{} `type:"structure"`

	// Contains configurations for the Amazon S3 location in which to store the
	// input into the node.
	S3 *StorageFlowNodeS3Configuration `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageFlowNodeServiceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StorageFlowNodeServiceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StorageFlowNodeServiceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StorageFlowNodeServiceConfiguration"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *StorageFlowNodeServiceConfiguration) SetS3(v *StorageFlowNodeS3Configuration) *StorageFlowNodeServiceConfiguration {
	s.S3 = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// An object containing key-value pairs that define the tags to attach to the
	// resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Contains configurations for a text prompt template. To include a variable,
// enclose a word in double curly braces as in {{variable}}.
type TextPromptTemplateConfiguration struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// An array of the variables in the prompt template.
	//
	// InputVariables is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TextPromptTemplateConfiguration's
	// String and GoString methods.
	InputVariables []*PromptInputVariable `locationName:"inputVariables" type:"list" sensitive:"true"`

	// The message for the prompt.
	//
	// Text is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TextPromptTemplateConfiguration's
	// String and GoString methods.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextPromptTemplateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TextPromptTemplateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TextPromptTemplateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TextPromptTemplateConfiguration"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputVariables sets the InputVariables field's value.
func (s *TextPromptTemplateConfiguration) SetInputVariables(v []*PromptInputVariable) *TextPromptTemplateConfiguration {
	s.InputVariables = v
	return s
}

// SetText sets the Text field's value.
func (s *TextPromptTemplateConfiguration) SetText(v string) *TextPromptTemplateConfiguration {
	s.Text = &v
	return s
}

// The number of requests exceeds the limit. Resubmit your request later.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A custom processing step for documents moving through a data source ingestion
// pipeline. To process documents after they have been converted into chunks,
// set the step to apply to POST_CHUNKING.
type Transformation struct {
	_ struct{} `type:"structure"`

	// When the service applies the transformation.
	//
	// StepToApply is a required field
	StepToApply *string `locationName:"stepToApply" type:"string" required:"true" enum:"StepType"`

	// A Lambda function that processes documents.
	//
	// TransformationFunction is a required field
	TransformationFunction *TransformationFunction `locationName:"transformationFunction" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transformation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Transformation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Transformation"}
	if s.StepToApply == nil {
		invalidParams.Add(request.NewErrParamRequired("StepToApply"))
	}
	if s.TransformationFunction == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformationFunction"))
	}
	if s.TransformationFunction != nil {
		if err := s.TransformationFunction.Validate(); err != nil {
			invalidParams.AddNested("TransformationFunction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStepToApply sets the StepToApply field's value.
func (s *Transformation) SetStepToApply(v string) *Transformation {
	s.StepToApply = &v
	return s
}

// SetTransformationFunction sets the TransformationFunction field's value.
func (s *Transformation) SetTransformationFunction(v *TransformationFunction) *Transformation {
	s.TransformationFunction = v
	return s
}

// A Lambda function that processes documents.
type TransformationFunction struct {
	_ struct{} `type:"structure"`

	// The Lambda function.
	//
	// TransformationLambdaConfiguration is a required field
	TransformationLambdaConfiguration *TransformationLambdaConfiguration `locationName:"transformationLambdaConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformationFunction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformationFunction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformationFunction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransformationFunction"}
	if s.TransformationLambdaConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TransformationLambdaConfiguration"))
	}
	if s.TransformationLambdaConfiguration != nil {
		if err := s.TransformationLambdaConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TransformationLambdaConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransformationLambdaConfiguration sets the TransformationLambdaConfiguration field's value.
func (s *TransformationFunction) SetTransformationLambdaConfiguration(v *TransformationLambdaConfiguration) *TransformationFunction {
	s.TransformationLambdaConfiguration = v
	return s
}

// A Lambda function that processes documents.
type TransformationLambdaConfiguration struct {
	_ struct{} `type:"structure"`

	// The function's ARN identifier.
	//
	// LambdaArn is a required field
	LambdaArn *string `locationName:"lambdaArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformationLambdaConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransformationLambdaConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TransformationLambdaConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TransformationLambdaConfiguration"}
	if s.LambdaArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LambdaArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLambdaArn sets the LambdaArn field's value.
func (s *TransformationLambdaConfiguration) SetLambdaArn(v string) *TransformationLambdaConfiguration {
	s.LambdaArn = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource from which to remove tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// A list of keys of the tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAgentActionGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Lambda function containing the business
	// logic that is carried out upon invoking the action.
	ActionGroupExecutor *ActionGroupExecutor `locationName:"actionGroupExecutor" type:"structure"`

	// The unique identifier of the action group.
	//
	// ActionGroupId is a required field
	ActionGroupId *string `location:"uri" locationName:"actionGroupId" type:"string" required:"true"`

	// Specifies a new name for the action group.
	//
	// ActionGroupName is a required field
	ActionGroupName *string `locationName:"actionGroupName" type:"string" required:"true"`

	// Specifies whether the action group is available for the agent to invoke or
	// not when sending an InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	ActionGroupState *string `locationName:"actionGroupState" type:"string" enum:"ActionGroupState"`

	// The unique identifier of the agent for which to update the action group.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The unique identifier of the agent version for which to update the action
	// group.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// Contains either details about the S3 object containing the OpenAPI schema
	// for the action group or the JSON or YAML-formatted payload defining the schema.
	// For more information, see Action group OpenAPI schemas (https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
	ApiSchema *APISchema `locationName:"apiSchema" type:"structure"`

	// Specifies a new name for the action group.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the function schema for the action group or the JSON
	// or YAML-formatted payload defining the schema.
	FunctionSchema *FunctionSchema `locationName:"functionSchema" type:"structure"`

	// To allow your agent to request the user for additional information when trying
	// to complete a task, set this field to AMAZON.UserInput. You must leave the
	// description, apiSchema, and actionGroupExecutor fields blank for this action
	// group.
	//
	// During orchestration, if your agent determines that it needs to invoke an
	// API in an action group, but doesn't have enough information to complete the
	// API request, it will invoke this action group instead and return an Observation
	// (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Observation.html)
	// reprompting the user for more information.
	ParentActionGroupSignature *string `locationName:"parentActionGroupSignature" type:"string" enum:"ActionGroupSignature"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentActionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentActionGroupInput"}
	if s.ActionGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupId"))
	}
	if s.ActionGroupId != nil && len(*s.ActionGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ActionGroupId", 1))
	}
	if s.ActionGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionGroupName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ApiSchema != nil {
		if err := s.ApiSchema.Validate(); err != nil {
			invalidParams.AddNested("ApiSchema", err.(request.ErrInvalidParams))
		}
	}
	if s.FunctionSchema != nil {
		if err := s.FunctionSchema.Validate(); err != nil {
			invalidParams.AddNested("FunctionSchema", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionGroupExecutor sets the ActionGroupExecutor field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupExecutor(v *ActionGroupExecutor) *UpdateAgentActionGroupInput {
	s.ActionGroupExecutor = v
	return s
}

// SetActionGroupId sets the ActionGroupId field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupId(v string) *UpdateAgentActionGroupInput {
	s.ActionGroupId = &v
	return s
}

// SetActionGroupName sets the ActionGroupName field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupName(v string) *UpdateAgentActionGroupInput {
	s.ActionGroupName = &v
	return s
}

// SetActionGroupState sets the ActionGroupState field's value.
func (s *UpdateAgentActionGroupInput) SetActionGroupState(v string) *UpdateAgentActionGroupInput {
	s.ActionGroupState = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentActionGroupInput) SetAgentId(v string) *UpdateAgentActionGroupInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *UpdateAgentActionGroupInput) SetAgentVersion(v string) *UpdateAgentActionGroupInput {
	s.AgentVersion = &v
	return s
}

// SetApiSchema sets the ApiSchema field's value.
func (s *UpdateAgentActionGroupInput) SetApiSchema(v *APISchema) *UpdateAgentActionGroupInput {
	s.ApiSchema = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentActionGroupInput) SetDescription(v string) *UpdateAgentActionGroupInput {
	s.Description = &v
	return s
}

// SetFunctionSchema sets the FunctionSchema field's value.
func (s *UpdateAgentActionGroupInput) SetFunctionSchema(v *FunctionSchema) *UpdateAgentActionGroupInput {
	s.FunctionSchema = v
	return s
}

// SetParentActionGroupSignature sets the ParentActionGroupSignature field's value.
func (s *UpdateAgentActionGroupInput) SetParentActionGroupSignature(v string) *UpdateAgentActionGroupInput {
	s.ParentActionGroupSignature = &v
	return s
}

type UpdateAgentActionGroupOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the action group that was updated.
	//
	// AgentActionGroup is a required field
	AgentActionGroup *AgentActionGroup `locationName:"agentActionGroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentActionGroupOutput) GoString() string {
	return s.String()
}

// SetAgentActionGroup sets the AgentActionGroup field's value.
func (s *UpdateAgentActionGroupOutput) SetAgentActionGroup(v *AgentActionGroup) *UpdateAgentActionGroupOutput {
	s.AgentActionGroup = v
	return s
}

type UpdateAgentAliasInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the alias.
	//
	// AgentAliasId is a required field
	AgentAliasId *string `location:"uri" locationName:"agentAliasId" min:"10" type:"string" required:"true"`

	// Specifies a new name for the alias.
	//
	// AgentAliasName is a required field
	AgentAliasName *string `locationName:"agentAliasName" type:"string" required:"true"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// Specifies a new description for the alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Contains details about the routing configuration of the alias.
	RoutingConfiguration []*AgentAliasRoutingConfigurationListItem `locationName:"routingConfiguration" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentAliasInput"}
	if s.AgentAliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasId"))
	}
	if s.AgentAliasId != nil && len(*s.AgentAliasId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("AgentAliasId", 10))
	}
	if s.AgentAliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentAliasName"))
	}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.RoutingConfiguration != nil {
		for i, v := range s.RoutingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentAliasId sets the AgentAliasId field's value.
func (s *UpdateAgentAliasInput) SetAgentAliasId(v string) *UpdateAgentAliasInput {
	s.AgentAliasId = &v
	return s
}

// SetAgentAliasName sets the AgentAliasName field's value.
func (s *UpdateAgentAliasInput) SetAgentAliasName(v string) *UpdateAgentAliasInput {
	s.AgentAliasName = &v
	return s
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentAliasInput) SetAgentId(v string) *UpdateAgentAliasInput {
	s.AgentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentAliasInput) SetDescription(v string) *UpdateAgentAliasInput {
	s.Description = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *UpdateAgentAliasInput) SetRoutingConfiguration(v []*AgentAliasRoutingConfigurationListItem) *UpdateAgentAliasInput {
	s.RoutingConfiguration = v
	return s
}

type UpdateAgentAliasOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the alias that was updated.
	//
	// AgentAlias is a required field
	AgentAlias *AgentAlias `locationName:"agentAlias" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentAliasOutput) GoString() string {
	return s.String()
}

// SetAgentAlias sets the AgentAlias field's value.
func (s *UpdateAgentAliasOutput) SetAgentAlias(v *AgentAlias) *UpdateAgentAliasOutput {
	s.AgentAlias = v
	return s
}

type UpdateAgentInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// Specifies a new name for the agent.
	//
	// AgentName is a required field
	AgentName *string `locationName:"agentName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role with permissions to invoke
	// API operations on the agent.
	//
	// AgentResourceRoleArn is a required field
	AgentResourceRoleArn *string `locationName:"agentResourceRoleArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key with which to encrypt the agent.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// Specifies a new description of the agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Specifies a new foundation model to be used for orchestration by the agent.
	//
	// FoundationModel is a required field
	FoundationModel *string `locationName:"foundationModel" min:"1" type:"string" required:"true"`

	// The unique Guardrail configuration assigned to the agent when it is updated.
	GuardrailConfiguration *GuardrailConfiguration `locationName:"guardrailConfiguration" type:"structure"`

	// The number of seconds for which Amazon Bedrock keeps information about a
	// user's conversation with the agent.
	//
	// A user interaction remains active for the amount of time specified. If no
	// conversation occurs during this time, the session expires and Amazon Bedrock
	// deletes any data provided before the timeout.
	IdleSessionTTLInSeconds *int64 `locationName:"idleSessionTTLInSeconds" min:"60" type:"integer"`

	// Specifies new instructions that tell the agent what it should do and how
	// it should interact with users.
	//
	// Instruction is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAgentInput's
	// String and GoString methods.
	Instruction *string `locationName:"instruction" min:"40" type:"string" sensitive:"true"`

	// Specifies the new memory configuration for the agent.
	MemoryConfiguration *MemoryConfiguration `locationName:"memoryConfiguration" type:"structure"`

	// Contains configurations to override prompts in different parts of an agent
	// sequence. For more information, see Advanced prompts (https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html).
	//
	// PromptOverrideConfiguration is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateAgentInput's
	// String and GoString methods.
	PromptOverrideConfiguration *PromptOverrideConfiguration `locationName:"promptOverrideConfiguration" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentName == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentName"))
	}
	if s.AgentResourceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentResourceRoleArn"))
	}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FoundationModel == nil {
		invalidParams.Add(request.NewErrParamRequired("FoundationModel"))
	}
	if s.FoundationModel != nil && len(*s.FoundationModel) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FoundationModel", 1))
	}
	if s.IdleSessionTTLInSeconds != nil && *s.IdleSessionTTLInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IdleSessionTTLInSeconds", 60))
	}
	if s.Instruction != nil && len(*s.Instruction) < 40 {
		invalidParams.Add(request.NewErrParamMinLen("Instruction", 40))
	}
	if s.MemoryConfiguration != nil {
		if err := s.MemoryConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MemoryConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.PromptOverrideConfiguration != nil {
		if err := s.PromptOverrideConfiguration.Validate(); err != nil {
			invalidParams.AddNested("PromptOverrideConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentInput) SetAgentId(v string) *UpdateAgentInput {
	s.AgentId = &v
	return s
}

// SetAgentName sets the AgentName field's value.
func (s *UpdateAgentInput) SetAgentName(v string) *UpdateAgentInput {
	s.AgentName = &v
	return s
}

// SetAgentResourceRoleArn sets the AgentResourceRoleArn field's value.
func (s *UpdateAgentInput) SetAgentResourceRoleArn(v string) *UpdateAgentInput {
	s.AgentResourceRoleArn = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *UpdateAgentInput) SetCustomerEncryptionKeyArn(v string) *UpdateAgentInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentInput) SetDescription(v string) *UpdateAgentInput {
	s.Description = &v
	return s
}

// SetFoundationModel sets the FoundationModel field's value.
func (s *UpdateAgentInput) SetFoundationModel(v string) *UpdateAgentInput {
	s.FoundationModel = &v
	return s
}

// SetGuardrailConfiguration sets the GuardrailConfiguration field's value.
func (s *UpdateAgentInput) SetGuardrailConfiguration(v *GuardrailConfiguration) *UpdateAgentInput {
	s.GuardrailConfiguration = v
	return s
}

// SetIdleSessionTTLInSeconds sets the IdleSessionTTLInSeconds field's value.
func (s *UpdateAgentInput) SetIdleSessionTTLInSeconds(v int64) *UpdateAgentInput {
	s.IdleSessionTTLInSeconds = &v
	return s
}

// SetInstruction sets the Instruction field's value.
func (s *UpdateAgentInput) SetInstruction(v string) *UpdateAgentInput {
	s.Instruction = &v
	return s
}

// SetMemoryConfiguration sets the MemoryConfiguration field's value.
func (s *UpdateAgentInput) SetMemoryConfiguration(v *MemoryConfiguration) *UpdateAgentInput {
	s.MemoryConfiguration = v
	return s
}

// SetPromptOverrideConfiguration sets the PromptOverrideConfiguration field's value.
func (s *UpdateAgentInput) SetPromptOverrideConfiguration(v *PromptOverrideConfiguration) *UpdateAgentInput {
	s.PromptOverrideConfiguration = v
	return s
}

type UpdateAgentKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the agent associated with the knowledge base that
	// you want to update.
	//
	// AgentId is a required field
	AgentId *string `location:"uri" locationName:"agentId" type:"string" required:"true"`

	// The version of the agent associated with the knowledge base that you want
	// to update.
	//
	// AgentVersion is a required field
	AgentVersion *string `location:"uri" locationName:"agentVersion" min:"5" type:"string" required:"true"`

	// Specifies a new description for the knowledge base associated with an agent.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base that has been associated with
	// an agent.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies whether the agent uses the knowledge base or not when sending an
	// InvokeAgent (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_InvokeAgent.html)
	// request.
	KnowledgeBaseState *string `locationName:"knowledgeBaseState" type:"string" enum:"KnowledgeBaseState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAgentKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAgentKnowledgeBaseInput"}
	if s.AgentId == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentId"))
	}
	if s.AgentId != nil && len(*s.AgentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AgentId", 1))
	}
	if s.AgentVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AgentVersion"))
	}
	if s.AgentVersion != nil && len(*s.AgentVersion) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("AgentVersion", 5))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentId sets the AgentId field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetAgentId(v string) *UpdateAgentKnowledgeBaseInput {
	s.AgentId = &v
	return s
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetAgentVersion(v string) *UpdateAgentKnowledgeBaseInput {
	s.AgentVersion = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetDescription(v string) *UpdateAgentKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetKnowledgeBaseId(v string) *UpdateAgentKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetKnowledgeBaseState sets the KnowledgeBaseState field's value.
func (s *UpdateAgentKnowledgeBaseInput) SetKnowledgeBaseState(v string) *UpdateAgentKnowledgeBaseInput {
	s.KnowledgeBaseState = &v
	return s
}

type UpdateAgentKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base that has been associated with an
	// agent.
	//
	// AgentKnowledgeBase is a required field
	AgentKnowledgeBase *AgentKnowledgeBase `locationName:"agentKnowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetAgentKnowledgeBase sets the AgentKnowledgeBase field's value.
func (s *UpdateAgentKnowledgeBaseOutput) SetAgentKnowledgeBase(v *AgentKnowledgeBase) *UpdateAgentKnowledgeBaseOutput {
	s.AgentKnowledgeBase = v
	return s
}

type UpdateAgentOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the agent that was updated.
	//
	// Agent is a required field
	Agent *Agent `locationName:"agent" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAgentOutput) GoString() string {
	return s.String()
}

// SetAgent sets the Agent field's value.
func (s *UpdateAgentOutput) SetAgent(v *Agent) *UpdateAgentOutput {
	s.Agent = v
	return s
}

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// The data deletion policy for the data source that you want to update.
	DataDeletionPolicy *string `locationName:"dataDeletionPolicy" type:"string" enum:"DataDeletionPolicy"`

	// The connection configuration for the data source that you want to update.
	//
	// DataSourceConfiguration is a required field
	DataSourceConfiguration *DataSourceConfiguration `locationName:"dataSourceConfiguration" type:"structure" required:"true"`

	// The unique identifier of the data source.
	//
	// DataSourceId is a required field
	DataSourceId *string `location:"uri" locationName:"dataSourceId" type:"string" required:"true"`

	// Specifies a new description for the data source.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the knowledge base for the data source.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies a new name for the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains details about server-side encryption of the data source.
	ServerSideEncryptionConfiguration *ServerSideEncryptionConfiguration `locationName:"serverSideEncryptionConfiguration" type:"structure"`

	// Contains details about how to ingest the documents in the data source.
	VectorIngestionConfiguration *VectorIngestionConfiguration `locationName:"vectorIngestionConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.DataSourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceConfiguration"))
	}
	if s.DataSourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSourceId"))
	}
	if s.DataSourceId != nil && len(*s.DataSourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSourceId", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DataSourceConfiguration != nil {
		if err := s.DataSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ServerSideEncryptionConfiguration != nil {
		if err := s.ServerSideEncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ServerSideEncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.VectorIngestionConfiguration != nil {
		if err := s.VectorIngestionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VectorIngestionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataDeletionPolicy sets the DataDeletionPolicy field's value.
func (s *UpdateDataSourceInput) SetDataDeletionPolicy(v string) *UpdateDataSourceInput {
	s.DataDeletionPolicy = &v
	return s
}

// SetDataSourceConfiguration sets the DataSourceConfiguration field's value.
func (s *UpdateDataSourceInput) SetDataSourceConfiguration(v *DataSourceConfiguration) *UpdateDataSourceInput {
	s.DataSourceConfiguration = v
	return s
}

// SetDataSourceId sets the DataSourceId field's value.
func (s *UpdateDataSourceInput) SetDataSourceId(v string) *UpdateDataSourceInput {
	s.DataSourceId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateDataSourceInput) SetDescription(v string) *UpdateDataSourceInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateDataSourceInput) SetKnowledgeBaseId(v string) *UpdateDataSourceInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataSourceInput) SetName(v string) *UpdateDataSourceInput {
	s.Name = &v
	return s
}

// SetServerSideEncryptionConfiguration sets the ServerSideEncryptionConfiguration field's value.
func (s *UpdateDataSourceInput) SetServerSideEncryptionConfiguration(v *ServerSideEncryptionConfiguration) *UpdateDataSourceInput {
	s.ServerSideEncryptionConfiguration = v
	return s
}

// SetVectorIngestionConfiguration sets the VectorIngestionConfiguration field's value.
func (s *UpdateDataSourceInput) SetVectorIngestionConfiguration(v *VectorIngestionConfiguration) *UpdateDataSourceInput {
	s.VectorIngestionConfiguration = v
	return s
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the data source.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

// SetDataSource sets the DataSource field's value.
func (s *UpdateDataSourceOutput) SetDataSource(v *DataSource) *UpdateDataSourceOutput {
	s.DataSource = v
	return s
}

type UpdateFlowAliasInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the alias.
	//
	// AliasIdentifier is a required field
	AliasIdentifier *string `location:"uri" locationName:"aliasIdentifier" type:"string" required:"true"`

	// A description for the flow alias.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// The name of the flow alias.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains information about the version to which to map the alias.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*FlowAliasRoutingConfigurationListItem `locationName:"routingConfiguration" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowAliasInput"}
	if s.AliasIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasIdentifier"))
	}
	if s.AliasIdentifier != nil && len(*s.AliasIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasIdentifier", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoutingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingConfiguration"))
	}
	if s.RoutingConfiguration != nil && len(s.RoutingConfiguration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingConfiguration", 1))
	}
	if s.RoutingConfiguration != nil {
		for i, v := range s.RoutingConfiguration {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RoutingConfiguration", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasIdentifier sets the AliasIdentifier field's value.
func (s *UpdateFlowAliasInput) SetAliasIdentifier(v string) *UpdateFlowAliasInput {
	s.AliasIdentifier = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowAliasInput) SetDescription(v string) *UpdateFlowAliasInput {
	s.Description = &v
	return s
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *UpdateFlowAliasInput) SetFlowIdentifier(v string) *UpdateFlowAliasInput {
	s.FlowIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFlowAliasInput) SetName(v string) *UpdateFlowAliasInput {
	s.Name = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *UpdateFlowAliasInput) SetRoutingConfiguration(v []*FlowAliasRoutingConfigurationListItem) *UpdateFlowAliasInput {
	s.RoutingConfiguration = v
	return s
}

type UpdateFlowAliasOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the flow.
	//
	// FlowId is a required field
	FlowId *string `locationName:"flowId" type:"string" required:"true"`

	// The unique identifier of the alias.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow alias.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contains information about the version that the alias is mapped to.
	//
	// RoutingConfiguration is a required field
	RoutingConfiguration []*FlowAliasRoutingConfigurationListItem `locationName:"routingConfiguration" min:"1" type:"list" required:"true"`

	// The time at which the flow alias was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowAliasOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateFlowAliasOutput) SetArn(v string) *UpdateFlowAliasOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateFlowAliasOutput) SetCreatedAt(v time.Time) *UpdateFlowAliasOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowAliasOutput) SetDescription(v string) *UpdateFlowAliasOutput {
	s.Description = &v
	return s
}

// SetFlowId sets the FlowId field's value.
func (s *UpdateFlowAliasOutput) SetFlowId(v string) *UpdateFlowAliasOutput {
	s.FlowId = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFlowAliasOutput) SetId(v string) *UpdateFlowAliasOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFlowAliasOutput) SetName(v string) *UpdateFlowAliasOutput {
	s.Name = &v
	return s
}

// SetRoutingConfiguration sets the RoutingConfiguration field's value.
func (s *UpdateFlowAliasOutput) SetRoutingConfiguration(v []*FlowAliasRoutingConfigurationListItem) *UpdateFlowAliasOutput {
	s.RoutingConfiguration = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateFlowAliasOutput) SetUpdatedAt(v time.Time) *UpdateFlowAliasOutput {
	s.UpdatedAt = &v
	return s
}

type UpdateFlowInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// A definition of the nodes and the connections between the nodes in the flow.
	Definition *FlowDefinition `locationName:"definition" type:"structure"`

	// A description for the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// and manage a flow. For more information, see Create a service role for flows
	// in Amazon Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
	// in the Amazon Bedrock User Guide.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// The unique identifier of the flow.
	//
	// FlowIdentifier is a required field
	FlowIdentifier *string `location:"uri" locationName:"flowIdentifier" type:"string" required:"true"`

	// A name for the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFlowInput"}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.FlowIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowIdentifier"))
	}
	if s.FlowIdentifier != nil && len(*s.FlowIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FlowIdentifier", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Definition != nil {
		if err := s.Definition.Validate(); err != nil {
			invalidParams.AddNested("Definition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *UpdateFlowInput) SetCustomerEncryptionKeyArn(v string) *UpdateFlowInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *UpdateFlowInput) SetDefinition(v *FlowDefinition) *UpdateFlowInput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowInput) SetDescription(v string) *UpdateFlowInput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *UpdateFlowInput) SetExecutionRoleArn(v string) *UpdateFlowInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetFlowIdentifier sets the FlowIdentifier field's value.
func (s *UpdateFlowInput) SetFlowIdentifier(v string) *UpdateFlowInput {
	s.FlowIdentifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFlowInput) SetName(v string) *UpdateFlowInput {
	s.Name = &v
	return s
}

type UpdateFlowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the flow was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key that the flow was encrypted
	// with.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// A definition of the nodes and the connections between nodes in the flow.
	Definition *FlowDefinition `locationName:"definition" type:"structure"`

	// The description of the flow.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// a flow. For more information, see Create a service role for flows in Amazon
	// Bedrock (https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html)
	// in the Amazon Bedrock User Guide.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" type:"string" required:"true"`

	// The unique identifier of the flow.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The status of the flow. When you submit this request, the status will be
	// NotPrepared. If updating fails, the status becomes Failed.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FlowStatus"`

	// The time at which the flow was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The version of the flow. When you update a flow, the version updated is the
	// DRAFT version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"5" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFlowOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateFlowOutput) SetArn(v string) *UpdateFlowOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateFlowOutput) SetCreatedAt(v time.Time) *UpdateFlowOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *UpdateFlowOutput) SetCustomerEncryptionKeyArn(v string) *UpdateFlowOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefinition sets the Definition field's value.
func (s *UpdateFlowOutput) SetDefinition(v *FlowDefinition) *UpdateFlowOutput {
	s.Definition = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFlowOutput) SetDescription(v string) *UpdateFlowOutput {
	s.Description = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *UpdateFlowOutput) SetExecutionRoleArn(v string) *UpdateFlowOutput {
	s.ExecutionRoleArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateFlowOutput) SetId(v string) *UpdateFlowOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFlowOutput) SetName(v string) *UpdateFlowOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateFlowOutput) SetStatus(v string) *UpdateFlowOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdateFlowOutput) SetUpdatedAt(v time.Time) *UpdateFlowOutput {
	s.UpdatedAt = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateFlowOutput) SetVersion(v string) *UpdateFlowOutput {
	s.Version = &v
	return s
}

type UpdateKnowledgeBaseInput struct {
	_ struct{} `type:"structure"`

	// Specifies a new description for the knowledge base.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Specifies the configuration for the embeddings model used for the knowledge
	// base. You must use the same configuration as when the knowledge base was
	// created.
	//
	// KnowledgeBaseConfiguration is a required field
	KnowledgeBaseConfiguration *KnowledgeBaseConfiguration `locationName:"knowledgeBaseConfiguration" type:"structure" required:"true"`

	// The unique identifier of the knowledge base to update.
	//
	// KnowledgeBaseId is a required field
	KnowledgeBaseId *string `location:"uri" locationName:"knowledgeBaseId" type:"string" required:"true"`

	// Specifies a new name for the knowledge base.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Specifies a different Amazon Resource Name (ARN) of the IAM role with permissions
	// to invoke API operations on the knowledge base.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Specifies the configuration for the vector store used for the knowledge base.
	// You must use the same configuration as when the knowledge base was created.
	//
	// StorageConfiguration is a required field
	StorageConfiguration *StorageConfiguration `locationName:"storageConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKnowledgeBaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKnowledgeBaseInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KnowledgeBaseConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseConfiguration"))
	}
	if s.KnowledgeBaseId == nil {
		invalidParams.Add(request.NewErrParamRequired("KnowledgeBaseId"))
	}
	if s.KnowledgeBaseId != nil && len(*s.KnowledgeBaseId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KnowledgeBaseId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.StorageConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageConfiguration"))
	}
	if s.KnowledgeBaseConfiguration != nil {
		if err := s.KnowledgeBaseConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.StorageConfiguration != nil {
		if err := s.StorageConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StorageConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateKnowledgeBaseInput) SetDescription(v string) *UpdateKnowledgeBaseInput {
	s.Description = &v
	return s
}

// SetKnowledgeBaseConfiguration sets the KnowledgeBaseConfiguration field's value.
func (s *UpdateKnowledgeBaseInput) SetKnowledgeBaseConfiguration(v *KnowledgeBaseConfiguration) *UpdateKnowledgeBaseInput {
	s.KnowledgeBaseConfiguration = v
	return s
}

// SetKnowledgeBaseId sets the KnowledgeBaseId field's value.
func (s *UpdateKnowledgeBaseInput) SetKnowledgeBaseId(v string) *UpdateKnowledgeBaseInput {
	s.KnowledgeBaseId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateKnowledgeBaseInput) SetName(v string) *UpdateKnowledgeBaseInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateKnowledgeBaseInput) SetRoleArn(v string) *UpdateKnowledgeBaseInput {
	s.RoleArn = &v
	return s
}

// SetStorageConfiguration sets the StorageConfiguration field's value.
func (s *UpdateKnowledgeBaseInput) SetStorageConfiguration(v *StorageConfiguration) *UpdateKnowledgeBaseInput {
	s.StorageConfiguration = v
	return s
}

type UpdateKnowledgeBaseOutput struct {
	_ struct{} `type:"structure"`

	// Contains details about the knowledge base.
	//
	// KnowledgeBase is a required field
	KnowledgeBase *KnowledgeBase `locationName:"knowledgeBase" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateKnowledgeBaseOutput) GoString() string {
	return s.String()
}

// SetKnowledgeBase sets the KnowledgeBase field's value.
func (s *UpdateKnowledgeBaseOutput) SetKnowledgeBase(v *KnowledgeBase) *UpdateKnowledgeBaseOutput {
	s.KnowledgeBase = v
	return s
}

type UpdatePromptInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The name of the default variant for the prompt. This value must match the
	// name field in the relevant PromptVariant (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html)
	// object.
	DefaultVariant *string `locationName:"defaultVariant" type:"string"`

	// A description for the prompt.
	Description *string `locationName:"description" min:"1" type:"string"`

	// A name for the prompt.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The unique identifier of the prompt.
	//
	// PromptIdentifier is a required field
	PromptIdentifier *string `location:"uri" locationName:"promptIdentifier" type:"string" required:"true"`

	// A list of objects, each containing details about a variant of the prompt.
	//
	// Variants is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePromptInput's
	// String and GoString methods.
	Variants []*PromptVariant `locationName:"variants" type:"list" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePromptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePromptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePromptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePromptInput"}
	if s.CustomerEncryptionKeyArn != nil && len(*s.CustomerEncryptionKeyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomerEncryptionKeyArn", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PromptIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("PromptIdentifier"))
	}
	if s.PromptIdentifier != nil && len(*s.PromptIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PromptIdentifier", 1))
	}
	if s.Variants != nil {
		for i, v := range s.Variants {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variants", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *UpdatePromptInput) SetCustomerEncryptionKeyArn(v string) *UpdatePromptInput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefaultVariant sets the DefaultVariant field's value.
func (s *UpdatePromptInput) SetDefaultVariant(v string) *UpdatePromptInput {
	s.DefaultVariant = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePromptInput) SetDescription(v string) *UpdatePromptInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePromptInput) SetName(v string) *UpdatePromptInput {
	s.Name = &v
	return s
}

// SetPromptIdentifier sets the PromptIdentifier field's value.
func (s *UpdatePromptInput) SetPromptIdentifier(v string) *UpdatePromptInput {
	s.PromptIdentifier = &v
	return s
}

// SetVariants sets the Variants field's value.
func (s *UpdatePromptInput) SetVariants(v []*PromptVariant) *UpdatePromptInput {
	s.Variants = v
	return s
}

type UpdatePromptOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the prompt.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time at which the prompt was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the prompt.
	CustomerEncryptionKeyArn *string `locationName:"customerEncryptionKeyArn" min:"1" type:"string"`

	// The name of the default variant for the prompt. This value must match the
	// name field in the relevant PromptVariant (https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PromptVariant.html)
	// object.
	DefaultVariant *string `locationName:"defaultVariant" type:"string"`

	// The description of the prompt.
	Description *string `locationName:"description" min:"1" type:"string"`

	// The unique identifier of the prompt.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the prompt.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The time at which the prompt was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// A list of objects, each containing details about a variant of the prompt.
	//
	// Variants is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePromptOutput's
	// String and GoString methods.
	Variants []*PromptVariant `locationName:"variants" type:"list" sensitive:"true"`

	// The version of the prompt. When you update a prompt, the version updated
	// is the DRAFT version.
	//
	// Version is a required field
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePromptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePromptOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdatePromptOutput) SetArn(v string) *UpdatePromptOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdatePromptOutput) SetCreatedAt(v time.Time) *UpdatePromptOutput {
	s.CreatedAt = &v
	return s
}

// SetCustomerEncryptionKeyArn sets the CustomerEncryptionKeyArn field's value.
func (s *UpdatePromptOutput) SetCustomerEncryptionKeyArn(v string) *UpdatePromptOutput {
	s.CustomerEncryptionKeyArn = &v
	return s
}

// SetDefaultVariant sets the DefaultVariant field's value.
func (s *UpdatePromptOutput) SetDefaultVariant(v string) *UpdatePromptOutput {
	s.DefaultVariant = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdatePromptOutput) SetDescription(v string) *UpdatePromptOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdatePromptOutput) SetId(v string) *UpdatePromptOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePromptOutput) SetName(v string) *UpdatePromptOutput {
	s.Name = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *UpdatePromptOutput) SetUpdatedAt(v time.Time) *UpdatePromptOutput {
	s.UpdatedAt = &v
	return s
}

// SetVariants sets the Variants field's value.
func (s *UpdatePromptOutput) SetVariants(v []*PromptVariant) *UpdatePromptOutput {
	s.Variants = v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdatePromptOutput) SetVersion(v string) *UpdatePromptOutput {
	s.Version = &v
	return s
}

// The configuration of web URLs that you want to crawl. You should be authorized
// to crawl the URLs.
type UrlConfiguration struct {
	_ struct{} `type:"structure"`

	// One or more seed or starting point URLs.
	SeedUrls []*SeedUrl `locationName:"seedUrls" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UrlConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UrlConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UrlConfiguration"}
	if s.SeedUrls != nil && len(s.SeedUrls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SeedUrls", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSeedUrls sets the SeedUrls field's value.
func (s *UrlConfiguration) SetSeedUrls(v []*SeedUrl) *UrlConfiguration {
	s.SeedUrls = v
	return s
}

// Input validation failed. Check your request parameters and retry the request.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of objects containing fields that caused validation errors and their
	// corresponding validation error messages.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores information about a field passed inside a request that resulted in
// an validation error.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// A message describing why this field failed validation.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Contains details about how to ingest the documents in a data source.
type VectorIngestionConfiguration struct {
	_ struct{} `type:"structure"`

	// Details about how to chunk the documents in the data source. A chunk refers
	// to an excerpt from a data source that is returned when the knowledge base
	// that it belongs to is queried.
	ChunkingConfiguration *ChunkingConfiguration `locationName:"chunkingConfiguration" type:"structure"`

	// A custom document transformer for parsed data source documents.
	CustomTransformationConfiguration *CustomTransformationConfiguration `locationName:"customTransformationConfiguration" type:"structure"`

	// A custom parser for data source documents.
	ParsingConfiguration *ParsingConfiguration `locationName:"parsingConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorIngestionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorIngestionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorIngestionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorIngestionConfiguration"}
	if s.ChunkingConfiguration != nil {
		if err := s.ChunkingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ChunkingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomTransformationConfiguration != nil {
		if err := s.CustomTransformationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CustomTransformationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ParsingConfiguration != nil {
		if err := s.ParsingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ParsingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChunkingConfiguration sets the ChunkingConfiguration field's value.
func (s *VectorIngestionConfiguration) SetChunkingConfiguration(v *ChunkingConfiguration) *VectorIngestionConfiguration {
	s.ChunkingConfiguration = v
	return s
}

// SetCustomTransformationConfiguration sets the CustomTransformationConfiguration field's value.
func (s *VectorIngestionConfiguration) SetCustomTransformationConfiguration(v *CustomTransformationConfiguration) *VectorIngestionConfiguration {
	s.CustomTransformationConfiguration = v
	return s
}

// SetParsingConfiguration sets the ParsingConfiguration field's value.
func (s *VectorIngestionConfiguration) SetParsingConfiguration(v *ParsingConfiguration) *VectorIngestionConfiguration {
	s.ParsingConfiguration = v
	return s
}

// Contains details about the model used to create vector embeddings for the
// knowledge base.
type VectorKnowledgeBaseConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the model used to create vector embeddings
	// for the knowledge base.
	//
	// EmbeddingModelArn is a required field
	EmbeddingModelArn *string `locationName:"embeddingModelArn" min:"20" type:"string" required:"true"`

	// The embeddings model configuration details for the vector model used in Knowledge
	// Base.
	EmbeddingModelConfiguration *EmbeddingModelConfiguration `locationName:"embeddingModelConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorKnowledgeBaseConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VectorKnowledgeBaseConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VectorKnowledgeBaseConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VectorKnowledgeBaseConfiguration"}
	if s.EmbeddingModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EmbeddingModelArn"))
	}
	if s.EmbeddingModelArn != nil && len(*s.EmbeddingModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("EmbeddingModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmbeddingModelArn sets the EmbeddingModelArn field's value.
func (s *VectorKnowledgeBaseConfiguration) SetEmbeddingModelArn(v string) *VectorKnowledgeBaseConfiguration {
	s.EmbeddingModelArn = &v
	return s
}

// SetEmbeddingModelConfiguration sets the EmbeddingModelConfiguration field's value.
func (s *VectorKnowledgeBaseConfiguration) SetEmbeddingModelConfiguration(v *EmbeddingModelConfiguration) *VectorKnowledgeBaseConfiguration {
	s.EmbeddingModelConfiguration = v
	return s
}

// The configuration of web URLs that you want to crawl. You should be authorized
// to crawl the URLs.
type WebCrawlerConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of crawl limits for the web URLs.
	CrawlerLimits *WebCrawlerLimits `locationName:"crawlerLimits" type:"structure"`

	// A list of one or more exclusion regular expression patterns to exclude certain
	// URLs. If you specify an inclusion and exclusion filter/pattern and both match
	// a URL, the exclusion filter takes precedence and the web content of the URL
	// isn’t crawled.
	//
	// ExclusionFilters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WebCrawlerConfiguration's
	// String and GoString methods.
	ExclusionFilters []*string `locationName:"exclusionFilters" min:"1" type:"list" sensitive:"true"`

	// A list of one or more inclusion regular expression patterns to include certain
	// URLs. If you specify an inclusion and exclusion filter/pattern and both match
	// a URL, the exclusion filter takes precedence and the web content of the URL
	// isn’t crawled.
	//
	// InclusionFilters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by WebCrawlerConfiguration's
	// String and GoString methods.
	InclusionFilters []*string `locationName:"inclusionFilters" min:"1" type:"list" sensitive:"true"`

	// The scope of what is crawled for your URLs.
	//
	// You can choose to crawl only web pages that belong to the same host or primary
	// domain. For example, only web pages that contain the seed URL "https://docs.aws.amazon.com/bedrock/latest/userguide/"
	// and no other domains. You can choose to include sub domains in addition to
	// the host or primary domain. For example, web pages that contain "aws.amazon.com"
	// can also include sub domain "docs.aws.amazon.com".
	Scope *string `locationName:"scope" type:"string" enum:"WebScopeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebCrawlerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebCrawlerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebCrawlerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebCrawlerConfiguration"}
	if s.ExclusionFilters != nil && len(s.ExclusionFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusionFilters", 1))
	}
	if s.InclusionFilters != nil && len(s.InclusionFilters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InclusionFilters", 1))
	}
	if s.CrawlerLimits != nil {
		if err := s.CrawlerLimits.Validate(); err != nil {
			invalidParams.AddNested("CrawlerLimits", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerLimits sets the CrawlerLimits field's value.
func (s *WebCrawlerConfiguration) SetCrawlerLimits(v *WebCrawlerLimits) *WebCrawlerConfiguration {
	s.CrawlerLimits = v
	return s
}

// SetExclusionFilters sets the ExclusionFilters field's value.
func (s *WebCrawlerConfiguration) SetExclusionFilters(v []*string) *WebCrawlerConfiguration {
	s.ExclusionFilters = v
	return s
}

// SetInclusionFilters sets the InclusionFilters field's value.
func (s *WebCrawlerConfiguration) SetInclusionFilters(v []*string) *WebCrawlerConfiguration {
	s.InclusionFilters = v
	return s
}

// SetScope sets the Scope field's value.
func (s *WebCrawlerConfiguration) SetScope(v string) *WebCrawlerConfiguration {
	s.Scope = &v
	return s
}

// The rate limits for the URLs that you want to crawl. You should be authorized
// to crawl the URLs.
type WebCrawlerLimits struct {
	_ struct{} `type:"structure"`

	// The max rate at which pages are crawled, up to 300 per minute per host.
	RateLimit *int64 `locationName:"rateLimit" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebCrawlerLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebCrawlerLimits) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebCrawlerLimits) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebCrawlerLimits"}
	if s.RateLimit != nil && *s.RateLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("RateLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRateLimit sets the RateLimit field's value.
func (s *WebCrawlerLimits) SetRateLimit(v int64) *WebCrawlerLimits {
	s.RateLimit = &v
	return s
}

// The configuration details for the web data source.
type WebDataSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The Web Crawler configuration details for the web data source.
	CrawlerConfiguration *WebCrawlerConfiguration `locationName:"crawlerConfiguration" type:"structure"`

	// The source configuration details for the web data source.
	//
	// SourceConfiguration is a required field
	SourceConfiguration *WebSourceConfiguration `locationName:"sourceConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebDataSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebDataSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebDataSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebDataSourceConfiguration"}
	if s.SourceConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConfiguration"))
	}
	if s.CrawlerConfiguration != nil {
		if err := s.CrawlerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CrawlerConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCrawlerConfiguration sets the CrawlerConfiguration field's value.
func (s *WebDataSourceConfiguration) SetCrawlerConfiguration(v *WebCrawlerConfiguration) *WebDataSourceConfiguration {
	s.CrawlerConfiguration = v
	return s
}

// SetSourceConfiguration sets the SourceConfiguration field's value.
func (s *WebDataSourceConfiguration) SetSourceConfiguration(v *WebSourceConfiguration) *WebDataSourceConfiguration {
	s.SourceConfiguration = v
	return s
}

// The configuration of the URL/URLs for the web content that you want to crawl.
// You should be authorized to crawl the URLs.
type WebSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The configuration of the URL/URLs.
	//
	// UrlConfiguration is a required field
	UrlConfiguration *UrlConfiguration `locationName:"urlConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WebSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebSourceConfiguration"}
	if s.UrlConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("UrlConfiguration"))
	}
	if s.UrlConfiguration != nil {
		if err := s.UrlConfiguration.Validate(); err != nil {
			invalidParams.AddNested("UrlConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUrlConfiguration sets the UrlConfiguration field's value.
func (s *WebSourceConfiguration) SetUrlConfiguration(v *UrlConfiguration) *WebSourceConfiguration {
	s.UrlConfiguration = v
	return s
}

const (
	// ActionGroupSignatureAmazonUserInput is a ActionGroupSignature enum value
	ActionGroupSignatureAmazonUserInput = "AMAZON.UserInput"

	// ActionGroupSignatureAmazonCodeInterpreter is a ActionGroupSignature enum value
	ActionGroupSignatureAmazonCodeInterpreter = "AMAZON.CodeInterpreter"
)

// ActionGroupSignature_Values returns all elements of the ActionGroupSignature enum
func ActionGroupSignature_Values() []string {
	return []string{
		ActionGroupSignatureAmazonUserInput,
		ActionGroupSignatureAmazonCodeInterpreter,
	}
}

const (
	// ActionGroupStateEnabled is a ActionGroupState enum value
	ActionGroupStateEnabled = "ENABLED"

	// ActionGroupStateDisabled is a ActionGroupState enum value
	ActionGroupStateDisabled = "DISABLED"
)

// ActionGroupState_Values returns all elements of the ActionGroupState enum
func ActionGroupState_Values() []string {
	return []string{
		ActionGroupStateEnabled,
		ActionGroupStateDisabled,
	}
}

const (
	// AgentAliasStatusCreating is a AgentAliasStatus enum value
	AgentAliasStatusCreating = "CREATING"

	// AgentAliasStatusPrepared is a AgentAliasStatus enum value
	AgentAliasStatusPrepared = "PREPARED"

	// AgentAliasStatusFailed is a AgentAliasStatus enum value
	AgentAliasStatusFailed = "FAILED"

	// AgentAliasStatusUpdating is a AgentAliasStatus enum value
	AgentAliasStatusUpdating = "UPDATING"

	// AgentAliasStatusDeleting is a AgentAliasStatus enum value
	AgentAliasStatusDeleting = "DELETING"
)

// AgentAliasStatus_Values returns all elements of the AgentAliasStatus enum
func AgentAliasStatus_Values() []string {
	return []string{
		AgentAliasStatusCreating,
		AgentAliasStatusPrepared,
		AgentAliasStatusFailed,
		AgentAliasStatusUpdating,
		AgentAliasStatusDeleting,
	}
}

const (
	// AgentStatusCreating is a AgentStatus enum value
	AgentStatusCreating = "CREATING"

	// AgentStatusPreparing is a AgentStatus enum value
	AgentStatusPreparing = "PREPARING"

	// AgentStatusPrepared is a AgentStatus enum value
	AgentStatusPrepared = "PREPARED"

	// AgentStatusNotPrepared is a AgentStatus enum value
	AgentStatusNotPrepared = "NOT_PREPARED"

	// AgentStatusDeleting is a AgentStatus enum value
	AgentStatusDeleting = "DELETING"

	// AgentStatusFailed is a AgentStatus enum value
	AgentStatusFailed = "FAILED"

	// AgentStatusVersioning is a AgentStatus enum value
	AgentStatusVersioning = "VERSIONING"

	// AgentStatusUpdating is a AgentStatus enum value
	AgentStatusUpdating = "UPDATING"
)

// AgentStatus_Values returns all elements of the AgentStatus enum
func AgentStatus_Values() []string {
	return []string{
		AgentStatusCreating,
		AgentStatusPreparing,
		AgentStatusPrepared,
		AgentStatusNotPrepared,
		AgentStatusDeleting,
		AgentStatusFailed,
		AgentStatusVersioning,
		AgentStatusUpdating,
	}
}

const (
	// ChunkingStrategyFixedSize is a ChunkingStrategy enum value
	ChunkingStrategyFixedSize = "FIXED_SIZE"

	// ChunkingStrategyNone is a ChunkingStrategy enum value
	ChunkingStrategyNone = "NONE"

	// ChunkingStrategyHierarchical is a ChunkingStrategy enum value
	ChunkingStrategyHierarchical = "HIERARCHICAL"

	// ChunkingStrategySemantic is a ChunkingStrategy enum value
	ChunkingStrategySemantic = "SEMANTIC"
)

// ChunkingStrategy_Values returns all elements of the ChunkingStrategy enum
func ChunkingStrategy_Values() []string {
	return []string{
		ChunkingStrategyFixedSize,
		ChunkingStrategyNone,
		ChunkingStrategyHierarchical,
		ChunkingStrategySemantic,
	}
}

const (
	// ConfluenceAuthTypeBasic is a ConfluenceAuthType enum value
	ConfluenceAuthTypeBasic = "BASIC"

	// ConfluenceAuthTypeOauth2ClientCredentials is a ConfluenceAuthType enum value
	ConfluenceAuthTypeOauth2ClientCredentials = "OAUTH2_CLIENT_CREDENTIALS"
)

// ConfluenceAuthType_Values returns all elements of the ConfluenceAuthType enum
func ConfluenceAuthType_Values() []string {
	return []string{
		ConfluenceAuthTypeBasic,
		ConfluenceAuthTypeOauth2ClientCredentials,
	}
}

const (
	// ConfluenceHostTypeSaas is a ConfluenceHostType enum value
	ConfluenceHostTypeSaas = "SAAS"
)

// ConfluenceHostType_Values returns all elements of the ConfluenceHostType enum
func ConfluenceHostType_Values() []string {
	return []string{
		ConfluenceHostTypeSaas,
	}
}

const (
	// CrawlFilterConfigurationTypePattern is a CrawlFilterConfigurationType enum value
	CrawlFilterConfigurationTypePattern = "PATTERN"
)

// CrawlFilterConfigurationType_Values returns all elements of the CrawlFilterConfigurationType enum
func CrawlFilterConfigurationType_Values() []string {
	return []string{
		CrawlFilterConfigurationTypePattern,
	}
}

const (
	// CreationModeDefault is a CreationMode enum value
	CreationModeDefault = "DEFAULT"

	// CreationModeOverridden is a CreationMode enum value
	CreationModeOverridden = "OVERRIDDEN"
)

// CreationMode_Values returns all elements of the CreationMode enum
func CreationMode_Values() []string {
	return []string{
		CreationModeDefault,
		CreationModeOverridden,
	}
}

const (
	// CustomControlMethodReturnControl is a CustomControlMethod enum value
	CustomControlMethodReturnControl = "RETURN_CONTROL"
)

// CustomControlMethod_Values returns all elements of the CustomControlMethod enum
func CustomControlMethod_Values() []string {
	return []string{
		CustomControlMethodReturnControl,
	}
}

const (
	// DataDeletionPolicyRetain is a DataDeletionPolicy enum value
	DataDeletionPolicyRetain = "RETAIN"

	// DataDeletionPolicyDelete is a DataDeletionPolicy enum value
	DataDeletionPolicyDelete = "DELETE"
)

// DataDeletionPolicy_Values returns all elements of the DataDeletionPolicy enum
func DataDeletionPolicy_Values() []string {
	return []string{
		DataDeletionPolicyRetain,
		DataDeletionPolicyDelete,
	}
}

const (
	// DataSourceStatusAvailable is a DataSourceStatus enum value
	DataSourceStatusAvailable = "AVAILABLE"

	// DataSourceStatusDeleting is a DataSourceStatus enum value
	DataSourceStatusDeleting = "DELETING"

	// DataSourceStatusDeleteUnsuccessful is a DataSourceStatus enum value
	DataSourceStatusDeleteUnsuccessful = "DELETE_UNSUCCESSFUL"
)

// DataSourceStatus_Values returns all elements of the DataSourceStatus enum
func DataSourceStatus_Values() []string {
	return []string{
		DataSourceStatusAvailable,
		DataSourceStatusDeleting,
		DataSourceStatusDeleteUnsuccessful,
	}
}

const (
	// DataSourceTypeS3 is a DataSourceType enum value
	DataSourceTypeS3 = "S3"

	// DataSourceTypeWeb is a DataSourceType enum value
	DataSourceTypeWeb = "WEB"

	// DataSourceTypeConfluence is a DataSourceType enum value
	DataSourceTypeConfluence = "CONFLUENCE"

	// DataSourceTypeSalesforce is a DataSourceType enum value
	DataSourceTypeSalesforce = "SALESFORCE"

	// DataSourceTypeSharepoint is a DataSourceType enum value
	DataSourceTypeSharepoint = "SHAREPOINT"
)

// DataSourceType_Values returns all elements of the DataSourceType enum
func DataSourceType_Values() []string {
	return []string{
		DataSourceTypeS3,
		DataSourceTypeWeb,
		DataSourceTypeConfluence,
		DataSourceTypeSalesforce,
		DataSourceTypeSharepoint,
	}
}

const (
	// FlowConnectionTypeData is a FlowConnectionType enum value
	FlowConnectionTypeData = "Data"

	// FlowConnectionTypeConditional is a FlowConnectionType enum value
	FlowConnectionTypeConditional = "Conditional"
)

// FlowConnectionType_Values returns all elements of the FlowConnectionType enum
func FlowConnectionType_Values() []string {
	return []string{
		FlowConnectionTypeData,
		FlowConnectionTypeConditional,
	}
}

const (
	// FlowNodeIODataTypeString is a FlowNodeIODataType enum value
	FlowNodeIODataTypeString = "String"

	// FlowNodeIODataTypeNumber is a FlowNodeIODataType enum value
	FlowNodeIODataTypeNumber = "Number"

	// FlowNodeIODataTypeBoolean is a FlowNodeIODataType enum value
	FlowNodeIODataTypeBoolean = "Boolean"

	// FlowNodeIODataTypeObject is a FlowNodeIODataType enum value
	FlowNodeIODataTypeObject = "Object"

	// FlowNodeIODataTypeArray is a FlowNodeIODataType enum value
	FlowNodeIODataTypeArray = "Array"
)

// FlowNodeIODataType_Values returns all elements of the FlowNodeIODataType enum
func FlowNodeIODataType_Values() []string {
	return []string{
		FlowNodeIODataTypeString,
		FlowNodeIODataTypeNumber,
		FlowNodeIODataTypeBoolean,
		FlowNodeIODataTypeObject,
		FlowNodeIODataTypeArray,
	}
}

const (
	// FlowNodeTypeInput is a FlowNodeType enum value
	FlowNodeTypeInput = "Input"

	// FlowNodeTypeOutput is a FlowNodeType enum value
	FlowNodeTypeOutput = "Output"

	// FlowNodeTypeKnowledgeBase is a FlowNodeType enum value
	FlowNodeTypeKnowledgeBase = "KnowledgeBase"

	// FlowNodeTypeCondition is a FlowNodeType enum value
	FlowNodeTypeCondition = "Condition"

	// FlowNodeTypeLex is a FlowNodeType enum value
	FlowNodeTypeLex = "Lex"

	// FlowNodeTypePrompt is a FlowNodeType enum value
	FlowNodeTypePrompt = "Prompt"

	// FlowNodeTypeLambdaFunction is a FlowNodeType enum value
	FlowNodeTypeLambdaFunction = "LambdaFunction"

	// FlowNodeTypeStorage is a FlowNodeType enum value
	FlowNodeTypeStorage = "Storage"

	// FlowNodeTypeAgent is a FlowNodeType enum value
	FlowNodeTypeAgent = "Agent"

	// FlowNodeTypeRetrieval is a FlowNodeType enum value
	FlowNodeTypeRetrieval = "Retrieval"

	// FlowNodeTypeIterator is a FlowNodeType enum value
	FlowNodeTypeIterator = "Iterator"

	// FlowNodeTypeCollector is a FlowNodeType enum value
	FlowNodeTypeCollector = "Collector"
)

// FlowNodeType_Values returns all elements of the FlowNodeType enum
func FlowNodeType_Values() []string {
	return []string{
		FlowNodeTypeInput,
		FlowNodeTypeOutput,
		FlowNodeTypeKnowledgeBase,
		FlowNodeTypeCondition,
		FlowNodeTypeLex,
		FlowNodeTypePrompt,
		FlowNodeTypeLambdaFunction,
		FlowNodeTypeStorage,
		FlowNodeTypeAgent,
		FlowNodeTypeRetrieval,
		FlowNodeTypeIterator,
		FlowNodeTypeCollector,
	}
}

const (
	// FlowStatusFailed is a FlowStatus enum value
	FlowStatusFailed = "Failed"

	// FlowStatusPrepared is a FlowStatus enum value
	FlowStatusPrepared = "Prepared"

	// FlowStatusPreparing is a FlowStatus enum value
	FlowStatusPreparing = "Preparing"

	// FlowStatusNotPrepared is a FlowStatus enum value
	FlowStatusNotPrepared = "NotPrepared"
)

// FlowStatus_Values returns all elements of the FlowStatus enum
func FlowStatus_Values() []string {
	return []string{
		FlowStatusFailed,
		FlowStatusPrepared,
		FlowStatusPreparing,
		FlowStatusNotPrepared,
	}
}

const (
	// FlowValidationSeverityWarning is a FlowValidationSeverity enum value
	FlowValidationSeverityWarning = "Warning"

	// FlowValidationSeverityError is a FlowValidationSeverity enum value
	FlowValidationSeverityError = "Error"
)

// FlowValidationSeverity_Values returns all elements of the FlowValidationSeverity enum
func FlowValidationSeverity_Values() []string {
	return []string{
		FlowValidationSeverityWarning,
		FlowValidationSeverityError,
	}
}

const (
	// IngestionJobFilterAttributeStatus is a IngestionJobFilterAttribute enum value
	IngestionJobFilterAttributeStatus = "STATUS"
)

// IngestionJobFilterAttribute_Values returns all elements of the IngestionJobFilterAttribute enum
func IngestionJobFilterAttribute_Values() []string {
	return []string{
		IngestionJobFilterAttributeStatus,
	}
}

const (
	// IngestionJobFilterOperatorEq is a IngestionJobFilterOperator enum value
	IngestionJobFilterOperatorEq = "EQ"
)

// IngestionJobFilterOperator_Values returns all elements of the IngestionJobFilterOperator enum
func IngestionJobFilterOperator_Values() []string {
	return []string{
		IngestionJobFilterOperatorEq,
	}
}

const (
	// IngestionJobSortByAttributeStatus is a IngestionJobSortByAttribute enum value
	IngestionJobSortByAttributeStatus = "STATUS"

	// IngestionJobSortByAttributeStartedAt is a IngestionJobSortByAttribute enum value
	IngestionJobSortByAttributeStartedAt = "STARTED_AT"
)

// IngestionJobSortByAttribute_Values returns all elements of the IngestionJobSortByAttribute enum
func IngestionJobSortByAttribute_Values() []string {
	return []string{
		IngestionJobSortByAttributeStatus,
		IngestionJobSortByAttributeStartedAt,
	}
}

const (
	// IngestionJobStatusStarting is a IngestionJobStatus enum value
	IngestionJobStatusStarting = "STARTING"

	// IngestionJobStatusInProgress is a IngestionJobStatus enum value
	IngestionJobStatusInProgress = "IN_PROGRESS"

	// IngestionJobStatusComplete is a IngestionJobStatus enum value
	IngestionJobStatusComplete = "COMPLETE"

	// IngestionJobStatusFailed is a IngestionJobStatus enum value
	IngestionJobStatusFailed = "FAILED"
)

// IngestionJobStatus_Values returns all elements of the IngestionJobStatus enum
func IngestionJobStatus_Values() []string {
	return []string{
		IngestionJobStatusStarting,
		IngestionJobStatusInProgress,
		IngestionJobStatusComplete,
		IngestionJobStatusFailed,
	}
}

const (
	// KnowledgeBaseStateEnabled is a KnowledgeBaseState enum value
	KnowledgeBaseStateEnabled = "ENABLED"

	// KnowledgeBaseStateDisabled is a KnowledgeBaseState enum value
	KnowledgeBaseStateDisabled = "DISABLED"
)

// KnowledgeBaseState_Values returns all elements of the KnowledgeBaseState enum
func KnowledgeBaseState_Values() []string {
	return []string{
		KnowledgeBaseStateEnabled,
		KnowledgeBaseStateDisabled,
	}
}

const (
	// KnowledgeBaseStatusCreating is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusCreating = "CREATING"

	// KnowledgeBaseStatusActive is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusActive = "ACTIVE"

	// KnowledgeBaseStatusDeleting is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusDeleting = "DELETING"

	// KnowledgeBaseStatusUpdating is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusUpdating = "UPDATING"

	// KnowledgeBaseStatusFailed is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusFailed = "FAILED"

	// KnowledgeBaseStatusDeleteUnsuccessful is a KnowledgeBaseStatus enum value
	KnowledgeBaseStatusDeleteUnsuccessful = "DELETE_UNSUCCESSFUL"
)

// KnowledgeBaseStatus_Values returns all elements of the KnowledgeBaseStatus enum
func KnowledgeBaseStatus_Values() []string {
	return []string{
		KnowledgeBaseStatusCreating,
		KnowledgeBaseStatusActive,
		KnowledgeBaseStatusDeleting,
		KnowledgeBaseStatusUpdating,
		KnowledgeBaseStatusFailed,
		KnowledgeBaseStatusDeleteUnsuccessful,
	}
}

const (
	// KnowledgeBaseStorageTypeOpensearchServerless is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypeOpensearchServerless = "OPENSEARCH_SERVERLESS"

	// KnowledgeBaseStorageTypePinecone is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypePinecone = "PINECONE"

	// KnowledgeBaseStorageTypeRedisEnterpriseCloud is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypeRedisEnterpriseCloud = "REDIS_ENTERPRISE_CLOUD"

	// KnowledgeBaseStorageTypeRds is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypeRds = "RDS"

	// KnowledgeBaseStorageTypeMongoDbAtlas is a KnowledgeBaseStorageType enum value
	KnowledgeBaseStorageTypeMongoDbAtlas = "MONGO_DB_ATLAS"
)

// KnowledgeBaseStorageType_Values returns all elements of the KnowledgeBaseStorageType enum
func KnowledgeBaseStorageType_Values() []string {
	return []string{
		KnowledgeBaseStorageTypeOpensearchServerless,
		KnowledgeBaseStorageTypePinecone,
		KnowledgeBaseStorageTypeRedisEnterpriseCloud,
		KnowledgeBaseStorageTypeRds,
		KnowledgeBaseStorageTypeMongoDbAtlas,
	}
}

const (
	// KnowledgeBaseTypeVector is a KnowledgeBaseType enum value
	KnowledgeBaseTypeVector = "VECTOR"
)

// KnowledgeBaseType_Values returns all elements of the KnowledgeBaseType enum
func KnowledgeBaseType_Values() []string {
	return []string{
		KnowledgeBaseTypeVector,
	}
}

const (
	// MemoryTypeSessionSummary is a MemoryType enum value
	MemoryTypeSessionSummary = "SESSION_SUMMARY"
)

// MemoryType_Values returns all elements of the MemoryType enum
func MemoryType_Values() []string {
	return []string{
		MemoryTypeSessionSummary,
	}
}

const (
	// ParsingStrategyBedrockFoundationModel is a ParsingStrategy enum value
	ParsingStrategyBedrockFoundationModel = "BEDROCK_FOUNDATION_MODEL"
)

// ParsingStrategy_Values returns all elements of the ParsingStrategy enum
func ParsingStrategy_Values() []string {
	return []string{
		ParsingStrategyBedrockFoundationModel,
	}
}

const (
	// PromptStateEnabled is a PromptState enum value
	PromptStateEnabled = "ENABLED"

	// PromptStateDisabled is a PromptState enum value
	PromptStateDisabled = "DISABLED"
)

// PromptState_Values returns all elements of the PromptState enum
func PromptState_Values() []string {
	return []string{
		PromptStateEnabled,
		PromptStateDisabled,
	}
}

const (
	// PromptTemplateTypeText is a PromptTemplateType enum value
	PromptTemplateTypeText = "TEXT"
)

// PromptTemplateType_Values returns all elements of the PromptTemplateType enum
func PromptTemplateType_Values() []string {
	return []string{
		PromptTemplateTypeText,
	}
}

const (
	// PromptTypePreProcessing is a PromptType enum value
	PromptTypePreProcessing = "PRE_PROCESSING"

	// PromptTypeOrchestration is a PromptType enum value
	PromptTypeOrchestration = "ORCHESTRATION"

	// PromptTypePostProcessing is a PromptType enum value
	PromptTypePostProcessing = "POST_PROCESSING"

	// PromptTypeKnowledgeBaseResponseGeneration is a PromptType enum value
	PromptTypeKnowledgeBaseResponseGeneration = "KNOWLEDGE_BASE_RESPONSE_GENERATION"
)

// PromptType_Values returns all elements of the PromptType enum
func PromptType_Values() []string {
	return []string{
		PromptTypePreProcessing,
		PromptTypeOrchestration,
		PromptTypePostProcessing,
		PromptTypeKnowledgeBaseResponseGeneration,
	}
}

const (
	// SalesforceAuthTypeOauth2ClientCredentials is a SalesforceAuthType enum value
	SalesforceAuthTypeOauth2ClientCredentials = "OAUTH2_CLIENT_CREDENTIALS"
)

// SalesforceAuthType_Values returns all elements of the SalesforceAuthType enum
func SalesforceAuthType_Values() []string {
	return []string{
		SalesforceAuthTypeOauth2ClientCredentials,
	}
}

const (
	// SharePointAuthTypeOauth2ClientCredentials is a SharePointAuthType enum value
	SharePointAuthTypeOauth2ClientCredentials = "OAUTH2_CLIENT_CREDENTIALS"
)

// SharePointAuthType_Values returns all elements of the SharePointAuthType enum
func SharePointAuthType_Values() []string {
	return []string{
		SharePointAuthTypeOauth2ClientCredentials,
	}
}

const (
	// SharePointHostTypeOnline is a SharePointHostType enum value
	SharePointHostTypeOnline = "ONLINE"
)

// SharePointHostType_Values returns all elements of the SharePointHostType enum
func SharePointHostType_Values() []string {
	return []string{
		SharePointHostTypeOnline,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// StepTypePostChunking is a StepType enum value
	StepTypePostChunking = "POST_CHUNKING"
)

// StepType_Values returns all elements of the StepType enum
func StepType_Values() []string {
	return []string{
		StepTypePostChunking,
	}
}

const (
	// TypeString is a Type enum value
	TypeString = "string"

	// TypeNumber is a Type enum value
	TypeNumber = "number"

	// TypeInteger is a Type enum value
	TypeInteger = "integer"

	// TypeBoolean is a Type enum value
	TypeBoolean = "boolean"

	// TypeArray is a Type enum value
	TypeArray = "array"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeString,
		TypeNumber,
		TypeInteger,
		TypeBoolean,
		TypeArray,
	}
}

const (
	// WebScopeTypeHostOnly is a WebScopeType enum value
	WebScopeTypeHostOnly = "HOST_ONLY"

	// WebScopeTypeSubdomains is a WebScopeType enum value
	WebScopeTypeSubdomains = "SUBDOMAINS"
)

// WebScopeType_Values returns all elements of the WebScopeType enum
func WebScopeType_Values() []string {
	return []string{
		WebScopeTypeHostOnly,
		WebScopeTypeSubdomains,
	}
}
