// NOTE: For now, this file is implemented by hand for convenience.
// But like `oxc_ast`, this should be generated by `tasks/ast_tools` in the future.

use oxc_span::{ContentEq, GetSpan, Span};

use crate::ast::{CharacterClassContents, Modifier, Term};

impl GetSpan for Term<'_> {
    #[inline]
    fn span(&self) -> Span {
        match self {
            Term::BoundaryAssertion(it) => it.span,
            Term::LookAroundAssertion(it) => it.span,
            Term::Quantifier(it) => it.span,
            Term::Character(it) => it.span,
            Term::Dot(it) => it.span,
            Term::CharacterClassEscape(it) => it.span,
            Term::UnicodePropertyEscape(it) => it.span,
            Term::CharacterClass(it) => it.span,
            Term::CapturingGroup(it) => it.span,
            Term::IgnoreGroup(it) => it.span,
            Term::IndexedReference(it) => it.span,
            Term::NamedReference(it) => it.span,
        }
    }
}

impl GetSpan for CharacterClassContents<'_> {
    #[inline]
    fn span(&self) -> Span {
        match self {
            CharacterClassContents::CharacterClassRange(it) => it.span,
            CharacterClassContents::CharacterClassEscape(it) => it.span,
            CharacterClassContents::UnicodePropertyEscape(it) => it.span,
            CharacterClassContents::Character(it) => it.span,
            CharacterClassContents::NestedCharacterClass(it) => it.span,
            CharacterClassContents::ClassStringDisjunction(it) => it.span,
        }
    }
}

// ---

impl ContentEq for Modifier {
    fn content_eq(&self, other: &Self) -> bool {
        self == other
    }
}
