//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern "C" {
    /// NSGlobalDomain identifies a domain shared between all applications for a given user. NSGlobalDomain is automatically included in all search lists, after the entries for the search list's domain.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsglobaldomain?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSGlobalDomain: &'static NSString;
}

extern "C" {
    /// NSArgumentDomain identifies a search list entry containing the commandline arguments the application was launched with, if any. Arguments must be formatted as '-key plistvalue'. NSArgumentDomain is automatically included in all search lists, after forced defaults, but before all other entries. This can be useful for testing purposes.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsargumentdomain?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSArgumentDomain: &'static NSString;
}

extern "C" {
    /// NSRegistrationDomain identifies a search list entry containing all defaults set with -registerDefaults:, if any. NSRegistrationDomain is automatically included as the final entry of all search lists.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsregistrationdomain?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSRegistrationDomain: &'static NSString;
}

extern_class!(
    /// NSUserDefaults is a hierarchical persistent interprocess (optionally distributed) key-value store, optimized for storing user settings.
    ///
    /// Hierarchical: NSUserDefaults has a list of places to look for data called the "search list". A search list is referred to by an arbitrary string called the "suite identifier" or "domain identifier". When queried, NSUserDefaults checks each entry of its search list until it finds one that contains the key in question, or has searched the whole list. The list is (note: "current host + current user" preferences are unimplemented on iOS, watchOS, and tvOS, and "any user" preferences are not generally useful for applications on those operating systems):
    /// - Managed ("forced") preferences, set by a configuration profile or via mcx from a network administrator
    /// - Commandline arguments
    /// - Preferences for the current domain, in the cloud
    /// - Preferences for the current domain, the current user, in the current host
    /// - Preferences for the current domain, the current user, in any host
    /// - Preferences added via -addSuiteNamed:
    /// - Preferences global to all apps for the current user, in the current host
    /// - Preferences global to all apps for the current user, in any host
    /// - Preferences for the current domain, for all users, in the current host
    /// - Preferences global to all apps for all users, in the current host
    /// - Preferences registered with -registerDefaults:
    ///
    /// Persistent: Preferences stored in NSUserDefaults persist across reboots and relaunches of apps unless otherwise specified.
    ///
    /// Interprocess: Preferences may be accessible to and modified from multiple processes simultaneously (for example between an application and an extension).
    ///
    /// Optionally distributed (Currently only supported in Shared iPad for Students mode):  Data stored in user defaults can be made "ubiqitous", i.e. synchronized between devices via the cloud.  Ubiquitous user defaults are automatically propagated to all devices logged into the same iCloud account. When reading defaults (via -*ForKey: methods on NSUserDefaults), ubiquitous defaults are searched before local defaults. All operations on ubiquitous defaults are asynchronous, so registered defaults may be returned in place of ubiquitous defaults if downloading from iCloud hasn't finished. Ubiquitous defaults are specified in the Defaults Configuration File for an application.
    ///
    /// Key-Value Store: NSUserDefaults stores Property List objects (NSString, NSData, NSNumber, NSDate, NSArray, and NSDictionary) identified by NSString keys, similar to an NSMutableDictionary.
    ///
    /// Optimized for storing user settings: NSUserDefaults is intended for relatively small amounts of data, queried very frequently, and modified occasionally. Using it in other ways may be slow or use more memory than solutions more suited to those uses.
    ///
    /// The 'App' CFPreferences functions in CoreFoundation act on the same search lists that NSUserDefaults does.
    ///
    /// NSUserDefaults can be observed using Key-Value Observing for any key stored in it. Using NSKeyValueObservingOptionPrior to observe changes from other processes or devices will behave as though NSKeyValueObservingOptionPrior was not specified.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsuserdefaults?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSUserDefaults;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSUserDefaults {}
);

impl NSUserDefaults {
    extern_methods!(
        /// +standardUserDefaults returns a global instance of NSUserDefaults configured to search the current application's search list.
        #[unsafe(method(standardUserDefaults))]
        #[unsafe(method_family = none)]
        pub fn standardUserDefaults() -> Retained<NSUserDefaults>;

        /// +resetStandardUserDefaults releases the standardUserDefaults and sets it to nil. A new standardUserDefaults will be created the next time it's accessed. The only visible effect this has is that all KVO observers of the previous standardUserDefaults will no longer be observing it.
        #[unsafe(method(resetStandardUserDefaults))]
        #[unsafe(method_family = none)]
        pub fn resetStandardUserDefaults();

        /// -init is equivalent to -initWithSuiteName:nil
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        /// -initWithSuiteName: initializes an instance of NSUserDefaults that searches the shared preferences search list for the domain 'suitename'. For example, using the identifier of an application group will cause the receiver to search the preferences for that group. Passing the current application's bundle identifier, NSGlobalDomain, or the corresponding CFPreferences constants is an error. Passing nil will search the default search list.
        #[unsafe(method(initWithSuiteName:))]
        #[unsafe(method_family = init)]
        pub fn initWithSuiteName(
            this: Allocated<Self>,
            suitename: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        /// -initWithUser: is equivalent to -init
        #[deprecated = "Use -init instead"]
        #[unsafe(method(initWithUser:))]
        #[unsafe(method_family = init)]
        pub fn initWithUser(this: Allocated<Self>, username: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        /// -objectForKey: will search the receiver's search list for a default with the key 'defaultName' and return it. If another process has changed defaults in the search list, NSUserDefaults will automatically update to the latest values. If the key in question has been marked as ubiquitous via a Defaults Configuration File, the latest value may not be immediately available, and the registered value will be returned instead.
        #[unsafe(method(objectForKey:))]
        #[unsafe(method_family = none)]
        pub fn objectForKey(&self, default_name: &NSString) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSString")]
        /// -setObject:forKey: immediately stores a value (or removes the value if nil is passed as the value) for the provided key in the search list entry for the receiver's suite name in the current user and any host, then asynchronously stores the value persistently, where it is made available to other processes.
        ///
        /// # Safety
        ///
        /// `value` should be of the correct type.
        #[unsafe(method(setObject:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setObject_forKey(&self, value: Option<&AnyObject>, default_name: &NSString);

        #[cfg(feature = "NSString")]
        /// -removeObjectForKey: is equivalent to -[... setObject:nil forKey:defaultName]
        #[unsafe(method(removeObjectForKey:))]
        #[unsafe(method_family = none)]
        pub fn removeObjectForKey(&self, default_name: &NSString);

        #[cfg(feature = "NSString")]
        /// -stringForKey: is equivalent to -objectForKey:, except that it will convert NSNumber values to their NSString representation. If a non-string non-number value is found, nil will be returned.
        #[unsafe(method(stringForKey:))]
        #[unsafe(method_family = none)]
        pub fn stringForKey(&self, default_name: &NSString) -> Option<Retained<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        /// -arrayForKey: is equivalent to -objectForKey:, except that it will return nil if the value is not an NSArray.
        #[unsafe(method(arrayForKey:))]
        #[unsafe(method_family = none)]
        pub fn arrayForKey(&self, default_name: &NSString) -> Option<Retained<NSArray>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// -dictionaryForKey: is equivalent to -objectForKey:, except that it will return nil if the value is not an NSDictionary.
        #[unsafe(method(dictionaryForKey:))]
        #[unsafe(method_family = none)]
        pub fn dictionaryForKey(
            &self,
            default_name: &NSString,
        ) -> Option<Retained<NSDictionary<NSString, AnyObject>>>;

        #[cfg(all(feature = "NSData", feature = "NSString"))]
        /// -dataForKey: is equivalent to -objectForKey:, except that it will return nil if the value is not an NSData.
        #[unsafe(method(dataForKey:))]
        #[unsafe(method_family = none)]
        pub fn dataForKey(&self, default_name: &NSString) -> Option<Retained<NSData>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        /// -stringForKey: is equivalent to -objectForKey:, except that it will return nil if the value is not an NSArray
        /// <NSString
        /// *>. Note that unlike -stringForKey:, NSNumbers are not converted to NSStrings.
        #[unsafe(method(stringArrayForKey:))]
        #[unsafe(method_family = none)]
        pub fn stringArrayForKey(
            &self,
            default_name: &NSString,
        ) -> Option<Retained<NSArray<NSString>>>;

        #[cfg(feature = "NSString")]
        /// -integerForKey: is equivalent to -objectForKey:, except that it converts the returned value to an NSInteger. If the value is an NSNumber, the result of -integerValue will be returned. If the value is an NSString, it will be converted to NSInteger if possible. If the value is a boolean, it will be converted to either 1 for YES or 0 for NO. If the value is absent or can't be converted to an integer, 0 will be returned.
        #[unsafe(method(integerForKey:))]
        #[unsafe(method_family = none)]
        pub fn integerForKey(&self, default_name: &NSString) -> NSInteger;

        #[cfg(feature = "NSString")]
        /// -floatForKey: is similar to -integerForKey:, except that it returns a float, and boolean values will not be converted.
        #[unsafe(method(floatForKey:))]
        #[unsafe(method_family = none)]
        pub fn floatForKey(&self, default_name: &NSString) -> c_float;

        #[cfg(feature = "NSString")]
        /// -doubleForKey: is similar to -integerForKey:, except that it returns a double, and boolean values will not be converted.
        #[unsafe(method(doubleForKey:))]
        #[unsafe(method_family = none)]
        pub fn doubleForKey(&self, default_name: &NSString) -> c_double;

        #[cfg(feature = "NSString")]
        /// -boolForKey: is equivalent to -objectForKey:, except that it converts the returned value to a BOOL. If the value is an NSNumber, NO will be returned if the value is 0, YES otherwise. If the value is an NSString, values of "YES" or "1" will return YES, and values of "NO", "0", or any other string will return NO. If the value is absent or can't be converted to a BOOL, NO will be returned.
        #[unsafe(method(boolForKey:))]
        #[unsafe(method_family = none)]
        pub fn boolForKey(&self, default_name: &NSString) -> bool;

        #[cfg(all(feature = "NSString", feature = "NSURL"))]
        /// -URLForKey: is equivalent to -objectForKey: except that it converts the returned value to an NSURL. If the value is an NSString path, then it will construct a file URL to that path. If the value is an archived URL from -setURL:forKey: it will be unarchived. If the value is absent or can't be converted to an NSURL, nil will be returned.
        #[unsafe(method(URLForKey:))]
        #[unsafe(method_family = none)]
        pub fn URLForKey(&self, default_name: &NSString) -> Option<Retained<NSURL>>;

        #[cfg(feature = "NSString")]
        /// -setInteger:forKey: is equivalent to -setObject:forKey: except that the value is converted from an NSInteger to an NSNumber.
        #[unsafe(method(setInteger:forKey:))]
        #[unsafe(method_family = none)]
        pub fn setInteger_forKey(&self, value: NSInteger, default_name: &NSString);

        #[cfg(feature = "NSString")]
        /// -setFloat:forKey: is equivalent to -setObject:forKey: except that the value is converted from a float to an NSNumber.
        #[unsafe(method(setFloat:forKey:))]
        #[unsafe(method_family = none)]
        pub fn setFloat_forKey(&self, value: c_float, default_name: &NSString);

        #[cfg(feature = "NSString")]
        /// -setDouble:forKey: is equivalent to -setObject:forKey: except that the value is converted from a double to an NSNumber.
        #[unsafe(method(setDouble:forKey:))]
        #[unsafe(method_family = none)]
        pub fn setDouble_forKey(&self, value: c_double, default_name: &NSString);

        #[cfg(feature = "NSString")]
        /// -setBool:forKey: is equivalent to -setObject:forKey: except that the value is converted from a BOOL to an NSNumber.
        #[unsafe(method(setBool:forKey:))]
        #[unsafe(method_family = none)]
        pub fn setBool_forKey(&self, value: bool, default_name: &NSString);

        #[cfg(all(feature = "NSString", feature = "NSURL"))]
        /// -setURL:forKey is equivalent to -setObject:forKey: except that the value is archived to an NSData. Use -URLForKey: to retrieve values set this way.
        #[unsafe(method(setURL:forKey:))]
        #[unsafe(method_family = none)]
        pub fn setURL_forKey(&self, url: Option<&NSURL>, default_name: &NSString);

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// -registerDefaults: adds the registrationDictionary to the last item in every search list. This means that after NSUserDefaults has looked for a value in every other valid location, it will look in registered defaults, making them useful as a "fallback" value. Registered defaults are never stored between runs of an application, and are visible only to the application that registers them.
        ///
        /// Default values from Defaults Configuration Files will automatically be registered.
        ///
        /// # Safety
        ///
        /// `registration_dictionary` generic should be of the correct type.
        #[unsafe(method(registerDefaults:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerDefaults(
            &self,
            registration_dictionary: &NSDictionary<NSString, AnyObject>,
        );

        #[cfg(feature = "NSString")]
        /// -addSuiteNamed: adds the full search list for 'suiteName' as a sub-search-list of the receiver's. The additional search lists are searched after the current domain, but before global defaults. Passing NSGlobalDomain or the current application's bundle identifier is unsupported.
        #[unsafe(method(addSuiteNamed:))]
        #[unsafe(method_family = none)]
        pub fn addSuiteNamed(&self, suite_name: &NSString);

        #[cfg(feature = "NSString")]
        /// -removeSuiteNamed: removes a sub-searchlist added via -addSuiteNamed:.
        #[unsafe(method(removeSuiteNamed:))]
        #[unsafe(method_family = none)]
        pub fn removeSuiteNamed(&self, suite_name: &NSString);

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// -dictionaryRepresentation returns a composite snapshot of the values in the receiver's search list, such that [[receiver dictionaryRepresentation] objectForKey:x] will return the same thing as [receiver objectForKey:x].
        #[unsafe(method(dictionaryRepresentation))]
        #[unsafe(method_family = none)]
        pub fn dictionaryRepresentation(&self) -> Retained<NSDictionary<NSString, AnyObject>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(volatileDomainNames))]
        #[unsafe(method_family = none)]
        pub fn volatileDomainNames(&self) -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(volatileDomainForName:))]
        #[unsafe(method_family = none)]
        pub fn volatileDomainForName(
            &self,
            domain_name: &NSString,
        ) -> Retained<NSDictionary<NSString, AnyObject>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// # Safety
        ///
        /// `domain` generic should be of the correct type.
        #[unsafe(method(setVolatileDomain:forName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setVolatileDomain_forName(
            &self,
            domain: &NSDictionary<NSString, AnyObject>,
            domain_name: &NSString,
        );

        #[cfg(feature = "NSString")]
        #[unsafe(method(removeVolatileDomainForName:))]
        #[unsafe(method_family = none)]
        pub fn removeVolatileDomainForName(&self, domain_name: &NSString);

        #[cfg(feature = "NSArray")]
        /// -persistentDomainNames returns an incomplete list of domains that have preferences stored in them.
        #[deprecated = "Not recommended"]
        #[unsafe(method(persistentDomainNames))]
        #[unsafe(method_family = none)]
        pub fn persistentDomainNames(&self) -> Retained<NSArray>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// -persistentDomainForName: returns a dictionary representation of the search list entry specified by 'domainName', the current user, and any host.
        #[unsafe(method(persistentDomainForName:))]
        #[unsafe(method_family = none)]
        pub fn persistentDomainForName(
            &self,
            domain_name: &NSString,
        ) -> Option<Retained<NSDictionary<NSString, AnyObject>>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// -setPersistentDomain:forName: replaces all values in the search list entry specified by 'domainName', the current user, and any host, with the values in 'domain'. The change will be persisted.
        ///
        /// # Safety
        ///
        /// `domain` generic should be of the correct type.
        #[unsafe(method(setPersistentDomain:forName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPersistentDomain_forName(
            &self,
            domain: &NSDictionary<NSString, AnyObject>,
            domain_name: &NSString,
        );

        #[cfg(feature = "NSString")]
        /// -removePersistentDomainForName: removes all values from the search list entry specified by 'domainName', the current user, and any host. The change is persistent.
        #[unsafe(method(removePersistentDomainForName:))]
        #[unsafe(method_family = none)]
        pub fn removePersistentDomainForName(&self, domain_name: &NSString);

        /// -synchronize is deprecated and will be marked with the API_DEPRECATED macro in a future release.
        ///
        /// -synchronize blocks the calling thread until all in-progress set operations have completed. This is no longer necessary. Replacements for previous uses of -synchronize depend on what the intent of calling synchronize was. If you synchronized...
        /// - ...before reading in order to fetch updated values: remove the synchronize call
        /// - ...after writing in order to notify another program to read: the other program can use KVO to observe the default without needing to notify
        /// - ...before exiting in a non-app (command line tool, agent, or daemon) process: call CFPreferencesAppSynchronize(kCFPreferencesCurrentApplication)
        /// - ...for any other reason: remove the synchronize call
        #[unsafe(method(synchronize))]
        #[unsafe(method_family = none)]
        pub fn synchronize(&self) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(objectIsForcedForKey:))]
        #[unsafe(method_family = none)]
        pub fn objectIsForcedForKey(&self, key: &NSString) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(objectIsForcedForKey:inDomain:))]
        #[unsafe(method_family = none)]
        pub fn objectIsForcedForKey_inDomain(&self, key: &NSString, domain: &NSString) -> bool;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSUserDefaults {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSUserDefaults {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern "C" {
    /// NSUserDefaultsSizeLimitExceededNotification is posted on the main queue when more data is stored in user defaults than is allowed. Currently there is no limit for local user defaults except on tvOS, where a warning notification will be posted at 512kB, and the process terminated at 1MB. For ubiquitous defaults, the limit depends on the logged in iCloud user.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsuserdefaultssizelimitexceedednotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    pub static NSUserDefaultsSizeLimitExceededNotification: &'static NSNotificationName;
}

extern "C" {
    /// NSUbiquitousUserDefaultsNoCloudAccountNotification is posted on the main queue to the default notification center when a cloud default is set, but no iCloud user is logged in.
    ///
    /// This is not necessarily an error: ubiquitous defaults set when no iCloud user is logged in will be uploaded the next time one is available if configured to do so.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsubiquitoususerdefaultsnocloudaccountnotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    #[deprecated = "Notification is never posted"]
    pub static NSUbiquitousUserDefaultsNoCloudAccountNotification: &'static NSNotificationName;
}

extern "C" {
    /// NSUbiquitousUserDefaultsDidChangeAccountsNotification is posted on the main queue to the default notification center when the user changes the primary iCloud account. The keys and values in the local key-value store have been replaced with those from the new account, regardless of the relative timestamps.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsubiquitoususerdefaultsdidchangeaccountsnotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    #[deprecated = "Notification is never posted"]
    pub static NSUbiquitousUserDefaultsDidChangeAccountsNotification: &'static NSNotificationName;
}

extern "C" {
    /// NSUbiquitousUserDefaultsCompletedInitialSyncNotification is posted on the main queue when ubiquitous defaults finish downloading the first time a device is connected to an iCloud account, and when a user switches their primary iCloud account.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsubiquitoususerdefaultscompletedinitialsyncnotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    #[deprecated = "Notification is never posted"]
    pub static NSUbiquitousUserDefaultsCompletedInitialSyncNotification:
        &'static NSNotificationName;
}

extern "C" {
    /// NSUserDefaultsDidChangeNotification is posted whenever any user defaults changed within the current process, but is not posted when ubiquitous defaults change, or when an outside process changes defaults. Using key-value observing to register observers for the specific keys of interest will inform you of all updates, regardless of where they're from.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsuserdefaultsdidchangenotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    pub static NSUserDefaultsDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsweekdaynamearray?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSWeekDayNameArray: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsshortweekdaynamearray?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSShortWeekDayNameArray: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsmonthnamearray?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSMonthNameArray: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsshortmonthnamearray?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSShortMonthNameArray: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstimeformatstring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSTimeFormatString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdateformatstring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSDateFormatString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nstimedateformatstring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSTimeDateFormatString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsshorttimedateformatstring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSShortTimeDateFormatString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nscurrencysymbol?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSCurrencySymbol: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdecimalseparator?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSDecimalSeparator: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsthousandsseparator?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSThousandsSeparator: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdecimaldigits?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSDecimalDigits: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsampmdesignation?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSAMPMDesignation: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nshournamedesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSHourNameDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsyearmonthweekdesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSYearMonthWeekDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsearliertimedesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSEarlierTimeDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslatertimedesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSLaterTimeDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsthisdaydesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSThisDayDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnextdaydesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSNextDayDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnextnextdaydesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSNextNextDayDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nspriordaydesignations?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSPriorDayDesignations: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsdatetimeordering?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSDateTimeOrdering: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsinternationalcurrencystring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSInternationalCurrencyString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsshortdateformatstring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSShortDateFormatString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nspositivecurrencyformatstring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSPositiveCurrencyFormatString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsnegativecurrencyformatstring?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSNegativeCurrencyFormatString: &'static NSString;
}
