//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
#[cfg(feature = "objc2-open-gl")]
#[cfg(target_os = "macos")]
use objc2_open_gl::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvdisplaylink?language=objc)
#[doc(alias = "CVDisplayLinkRef")]
#[repr(C)]
pub struct CVDisplayLink {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CVDisplayLink {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CVDisplayLink"> for CVDisplayLink {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvdisplaylinkoutputcallback?language=objc)
#[cfg(all(feature = "CVBase", feature = "CVReturn"))]
pub type CVDisplayLinkOutputCallback = Option<
    unsafe extern "C-unwind" fn(
        NonNull<CVDisplayLink>,
        NonNull<CVTimeStamp>,
        NonNull<CVTimeStamp>,
        CVOptionFlags,
        NonNull<CVOptionFlags>,
        *mut c_void,
    ) -> CVReturn,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvdisplaylinkoutputhandler?language=objc)
#[cfg(all(feature = "CVBase", feature = "CVReturn", feature = "block2"))]
pub type CVDisplayLinkOutputHandler = *mut block2::DynBlock<
    dyn Fn(
        NonNull<CVDisplayLink>,
        NonNull<CVTimeStamp>,
        NonNull<CVTimeStamp>,
        CVOptionFlags,
        NonNull<CVOptionFlags>,
    ) -> CVReturn,
>;

unsafe impl ConcreteType for CVDisplayLink {
    #[doc(alias = "CVDisplayLinkGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CVDisplayLinkGetTypeID() -> CFTypeID;
        }
        unsafe { CVDisplayLinkGetTypeID() }
    }
}

impl CVDisplayLink {
    /// General call to create a CVDisplayLink
    ///
    /// Use this call to create a CVDisplayLink for a set of displays indentified by the CGDirectDisplayIDs.
    ///
    /// Parameter `displayArray`: array of CGDirectDisplayIDs
    ///
    /// Parameter `count`: number of displays in the displayArray
    ///
    /// Parameter `displayLinkOut`: The new display link will be returned here
    ///
    /// Returns: returns kCVReturnSuccess on success.
    ///
    /// # Safety
    ///
    /// - `display_array` must be a valid pointer.
    /// - `display_link_out` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkCreateWithCGDisplays")]
    #[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn create_with_cg_displays(
        display_array: NonNull<CGDirectDisplayID>,
        count: CFIndex,
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkCreateWithCGDisplays(
                display_array: NonNull<CGDirectDisplayID>,
                count: CFIndex,
                display_link_out: NonNull<*mut CVDisplayLink>,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkCreateWithCGDisplays(display_array, count, display_link_out) }
    }

    /// Convenience call to create a CVDisplayLink from an OpenGL display mask.
    ///
    /// Use this call to create a CVDisplayLink for a CGOpenGLDisplayMask.
    ///
    /// Parameter `mask`: CGOpenGLDisplayMask describing the display
    ///
    /// Parameter `displayLinkOut`: The new display link will be returned here
    ///
    /// Returns: returns kCVReturnSuccess on success.
    ///
    /// # Safety
    ///
    /// `display_link_out` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkCreateWithOpenGLDisplayMask")]
    #[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn create_with_open_gl_display_mask(
        mask: CGOpenGLDisplayMask,
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkCreateWithOpenGLDisplayMask(
                mask: CGOpenGLDisplayMask,
                display_link_out: NonNull<*mut CVDisplayLink>,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkCreateWithOpenGLDisplayMask(mask, display_link_out) }
    }

    /// Convenience call to create a CVDisplayLink for a single CGDirectDisplay.
    ///
    /// Use this call to create a CVDisplayLink for a single CGDirectDisplay.
    ///
    /// Parameter `displayID`: CGDirectDisplayID of the target display
    ///
    /// Parameter `displayLinkOut`: The new display link will be returned here
    ///
    /// Returns: returns kCVReturnSuccess on success.
    ///
    /// # Safety
    ///
    /// `display_link_out` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkCreateWithCGDisplay")]
    #[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn create_with_cg_display(
        display_id: CGDirectDisplayID,
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkCreateWithCGDisplay(
                display_id: CGDirectDisplayID,
                display_link_out: NonNull<*mut CVDisplayLink>,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkCreateWithCGDisplay(display_id, display_link_out) }
    }

    /// Convenience function to create a CVDisplayLink capable of being used with all active CGDisplays
    ///
    /// Parameter `displayLinkOut`: The newly created CVDisplayLink
    ///
    /// Returns: kCVReturnSuccess if the device was created, or failure
    ///
    /// # Safety
    ///
    /// `display_link_out` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkCreateWithActiveCGDisplays")]
    #[cfg(feature = "CVReturn")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn create_with_active_cg_displays(
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkCreateWithActiveCGDisplays(
                display_link_out: NonNull<*mut CVDisplayLink>,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkCreateWithActiveCGDisplays(display_link_out) }
    }

    /// Sets the current display of a DisplayLink
    ///
    /// It is safe to call this with a running display link, but be aware that there will likely be a timestamp
    /// discontinuity in the video time stamp
    ///
    /// Parameter `displayLink`: target CVDisplayLinkRef
    ///
    /// Parameter `displayID`: target CGDirectDisplayID
    ///
    /// Returns: CVReturn. kCVReturnSuccess if successfull.
    #[doc(alias = "CVDisplayLinkSetCurrentCGDisplay")]
    #[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn set_current_cg_display(&self, display_id: CGDirectDisplayID) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkSetCurrentCGDisplay(
                display_link: &CVDisplayLink,
                display_id: CGDirectDisplayID,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkSetCurrentCGDisplay(self, display_id) }
    }

    /// Convenience function to select a CVDisplayLink most optimal for the current renderer of the passed in OpenGL context
    ///
    /// Parameter `displayLink`: The CVDisplayLink for which you want to set the current CGDisplay
    ///
    /// Parameter `cglContext`: The OpenGL context to retrieve the current renderer from.
    ///
    /// Parameter `cglPixelFormat`: The OpenGL pixel format used to create the passed in OpenGL context
    ///
    /// Returns: kCVReturnSuccess if a device was found, or failure.
    ///
    /// # Safety
    ///
    /// - `cgl_context` must be a valid pointer.
    /// - `cgl_pixel_format` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext")]
    #[cfg(all(feature = "CVReturn", feature = "objc2-open-gl"))]
    #[cfg(target_os = "macos")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn set_current_cg_display_from_open_gl_context(
        &self,
        cgl_context: CGLContextObj,
        cgl_pixel_format: CGLPixelFormatObj,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext(
                display_link: &CVDisplayLink,
                cgl_context: CGLContextObj,
                cgl_pixel_format: CGLPixelFormatObj,
            ) -> CVReturn;
        }
        unsafe {
            CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext(self, cgl_context, cgl_pixel_format)
        }
    }

    /// Gets the current display of a DisplayLink
    ///
    /// (description)
    ///
    /// Parameter `displayLink`: target CVDisplayLinkRef
    ///
    /// Returns: CGDirectDisplayID
    #[doc(alias = "CVDisplayLinkGetCurrentCGDisplay")]
    #[cfg(feature = "objc2-core-graphics")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn current_cg_display(&self) -> CGDirectDisplayID {
        extern "C-unwind" {
            fn CVDisplayLinkGetCurrentCGDisplay(display_link: &CVDisplayLink) -> CGDirectDisplayID;
        }
        unsafe { CVDisplayLinkGetCurrentCGDisplay(self) }
    }

    /// Set the renderer output callback function
    ///
    /// The DisplayLink will invoke this callback whenever it wants you to output a frame.
    ///
    /// Parameter `displayLink`: target CVDisplayLinkRef
    ///
    /// Parameter `callback`: CVDisplayLinkOutputCallback function
    ///
    /// Parameter `userInfo`: User data for the callback to identify the context.
    ///
    /// Returns: CVReturn. kCVReturnSuccess if successfull.
    ///
    /// # Safety
    ///
    /// - `callback` must be implemented correctly.
    /// - `user_info` must be a valid pointer or null.
    #[doc(alias = "CVDisplayLinkSetOutputCallback")]
    #[cfg(all(feature = "CVBase", feature = "CVReturn"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn set_output_callback(
        &self,
        callback: CVDisplayLinkOutputCallback,
        user_info: *mut c_void,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkSetOutputCallback(
                display_link: &CVDisplayLink,
                callback: CVDisplayLinkOutputCallback,
                user_info: *mut c_void,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkSetOutputCallback(self, callback, user_info) }
    }

    /// Set the renderer output callback block
    ///
    /// The DisplayLink will invoke this block whenever it wants you to output a frame. You can only have a block or a callback function; not both.
    ///
    /// Parameter `displayLink`: target CVDisplayLinkRef
    ///
    /// Parameter `handler`: CVDisplayLinkOutputHandler block
    ///
    /// Returns: CVReturn. kCVReturnSuccess if successful.
    ///
    /// # Safety
    ///
    /// `handler` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkSetOutputHandler")]
    #[cfg(all(feature = "CVBase", feature = "CVReturn", feature = "block2"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn set_output_handler(&self, handler: CVDisplayLinkOutputHandler) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkSetOutputHandler(
                display_link: &CVDisplayLink,
                handler: CVDisplayLinkOutputHandler,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkSetOutputHandler(self, handler) }
    }

    /// Start timer for DisplayLink
    ///
    /// This call should not be made from inside the CVDisplayLinkOutputCallback
    ///
    /// Parameter `displayLink`: target CVDisplayLinkRef
    ///
    /// Returns: CVReturn. kCVReturnSuccess if successfull.
    /// kCVReturnDisplayLinkCallbacksNotSet The DisplayLink cannot be started until the output callback is set.
    #[doc(alias = "CVDisplayLinkStart")]
    #[cfg(feature = "CVReturn")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn start(&self) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkStart(display_link: &CVDisplayLink) -> CVReturn;
        }
        unsafe { CVDisplayLinkStart(self) }
    }

    /// Stop timer for DisplayLink
    ///
    /// (description)
    ///
    /// Parameter `displayLink`: target CVDisplayLinkRef
    ///
    /// Returns: CVReturn. kCVReturnSuccess if successfull.
    #[doc(alias = "CVDisplayLinkStop")]
    #[cfg(feature = "CVReturn")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn stop(&self) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkStop(display_link: &CVDisplayLink) -> CVReturn;
        }
        unsafe { CVDisplayLinkStop(self) }
    }

    /// Retrieves the nominal refresh period of a CVDisplayLink.
    ///
    /// This call allows one to retrieve the device's "ideal" refresh period.   For example, an NTSC output device might report 1001/60000 to represent the exact NTSC vertial refresh rate.
    ///
    /// Parameter `displayLink`: The CVDisplayLink to get the refresh period from.
    ///
    /// Returns: A CVTime struct that holds the nominal refresh period.    This value may be indefinite.
    #[doc(alias = "CVDisplayLinkGetNominalOutputVideoRefreshPeriod")]
    #[cfg(feature = "CVBase")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn nominal_output_video_refresh_period(&self) -> CVTime {
        extern "C-unwind" {
            fn CVDisplayLinkGetNominalOutputVideoRefreshPeriod(
                display_link: &CVDisplayLink,
            ) -> CVTime;
        }
        unsafe { CVDisplayLinkGetNominalOutputVideoRefreshPeriod(self) }
    }

    /// Retrieves the nominal latency of a CVDisplayLink.
    ///
    /// This call allows one to retrieve the device's built in output latency. An NTSC device with one frame of latency might report back 1001/30000 or 2002/60000, for example.
    ///
    /// Parameter `displayLink`: The CVDisplayLink to get the latency period from.
    ///
    /// Returns: A CVTime struct that holds the latency.   This value may be indefinite.
    #[doc(alias = "CVDisplayLinkGetOutputVideoLatency")]
    #[cfg(feature = "CVBase")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn output_video_latency(&self) -> CVTime {
        extern "C-unwind" {
            fn CVDisplayLinkGetOutputVideoLatency(display_link: &CVDisplayLink) -> CVTime;
        }
        unsafe { CVDisplayLinkGetOutputVideoLatency(self) }
    }

    /// Retrieves the actual output refresh period of a display as measured by the host timebase.
    ///
    /// This call returns the actual output refresh period (in seconds) as computed relative to the host's timebase.
    ///
    /// Parameter `displayLink`: The CVDisplayLink to get the refresh period from.
    ///
    /// Returns: A double containing the actual refresh period.   This value may be zero if the device is not running, or is otherwise unavailable.
    #[doc(alias = "CVDisplayLinkGetActualOutputVideoRefreshPeriod")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn actual_output_video_refresh_period(&self) -> c_double {
        extern "C-unwind" {
            fn CVDisplayLinkGetActualOutputVideoRefreshPeriod(
                display_link: &CVDisplayLink,
            ) -> c_double;
        }
        unsafe { CVDisplayLinkGetActualOutputVideoRefreshPeriod(self) }
    }

    /// Retrieves the running state of a CVDisplayLink.
    ///
    /// This call queries the running state of the given CVDisplayLink.
    ///
    /// Parameter `displayLink`: The CVDisplayLink to get the running state from.
    ///
    /// Returns: A boolean describing the running state. It returns true if it is running and false if it is not running or the CVDisplayLink is invalid.
    #[doc(alias = "CVDisplayLinkIsRunning")]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub fn is_running(&self) -> bool {
        extern "C-unwind" {
            fn CVDisplayLinkIsRunning(display_link: &CVDisplayLink) -> Boolean;
        }
        let ret = unsafe { CVDisplayLinkIsRunning(self) };
        ret != 0
    }

    /// Retrieves the current ("now") time of a given CVDisplayLink
    ///
    /// This call may be used to get the current time of a running CVDisplayLink, outside of the output callback.
    ///
    /// Parameter `displayLink`: The CVDisplayLink to get the current time from.
    ///
    /// Parameter `outTime`: A pointer to a CVTimeStamp struct.  This struct's version field must currently be set correctly (currently 0) to indicate which version of the timestamp struct is desired.
    ///
    /// Returns: kCVReturnSuccess if the current time could be retrieved, otherwise an error indicating why the operation failed.
    ///
    /// # Safety
    ///
    /// `out_time` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkGetCurrentTime")]
    #[cfg(all(feature = "CVBase", feature = "CVReturn"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn current_time(&self, out_time: NonNull<CVTimeStamp>) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkGetCurrentTime(
                display_link: &CVDisplayLink,
                out_time: NonNull<CVTimeStamp>,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkGetCurrentTime(self, out_time) }
    }

    /// Translates the time in the CVDisplayLink's time base from one representation to
    /// another. Note that the device has to be running for this call to succeed.
    ///
    /// Parameter `displayLink`: The CVDisplayLink who's timebase should be used to do the translation.
    ///
    /// Parameter `inTime`: A CVTimeStamp containing the source time to be translated.
    ///
    /// Parameter `outTime`: A CVTimeStamp into which the target time will be written. This struct's version field must currently be set correctly
    /// (currently 0) to indicate which version of the timestamp struct is desired.  As well, the flags field should be used to specify
    /// which representations to translate to.
    ///
    /// Returns: kCVReturnSuccess if the time could be translated, otherwise an error indicating why the operation failed.
    ///
    /// # Safety
    ///
    /// - `in_time` must be a valid pointer.
    /// - `out_time` must be a valid pointer.
    #[doc(alias = "CVDisplayLinkTranslateTime")]
    #[cfg(all(feature = "CVBase", feature = "CVReturn"))]
    #[deprecated = "use NSView.displayLink(target:selector:), NSWindow.displayLink(target:selector:), or NSScreen.displayLink(target:selector:) "]
    #[inline]
    pub unsafe fn translate_time(
        &self,
        in_time: NonNull<CVTimeStamp>,
        out_time: NonNull<CVTimeStamp>,
    ) -> CVReturn {
        extern "C-unwind" {
            fn CVDisplayLinkTranslateTime(
                display_link: &CVDisplayLink,
                in_time: NonNull<CVTimeStamp>,
                out_time: NonNull<CVTimeStamp>,
            ) -> CVReturn;
        }
        unsafe { CVDisplayLinkTranslateTime(self, in_time, out_time) }
    }
}

extern "C-unwind" {
    #[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
    #[deprecated = "renamed to `CVDisplayLink::create_with_cg_displays`"]
    pub fn CVDisplayLinkCreateWithCGDisplays(
        display_array: NonNull<CGDirectDisplayID>,
        count: CFIndex,
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
    #[deprecated = "renamed to `CVDisplayLink::create_with_open_gl_display_mask`"]
    pub fn CVDisplayLinkCreateWithOpenGLDisplayMask(
        mask: CGOpenGLDisplayMask,
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
    #[deprecated = "renamed to `CVDisplayLink::create_with_cg_display`"]
    pub fn CVDisplayLinkCreateWithCGDisplay(
        display_id: CGDirectDisplayID,
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(feature = "CVReturn")]
    #[deprecated = "renamed to `CVDisplayLink::create_with_active_cg_displays`"]
    pub fn CVDisplayLinkCreateWithActiveCGDisplays(
        display_link_out: NonNull<*mut CVDisplayLink>,
    ) -> CVReturn;
}

#[cfg(all(feature = "CVReturn", feature = "objc2-core-graphics"))]
#[deprecated = "renamed to `CVDisplayLink::set_current_cg_display`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkSetCurrentCGDisplay(
    display_link: &CVDisplayLink,
    display_id: CGDirectDisplayID,
) -> CVReturn {
    extern "C-unwind" {
        fn CVDisplayLinkSetCurrentCGDisplay(
            display_link: &CVDisplayLink,
            display_id: CGDirectDisplayID,
        ) -> CVReturn;
    }
    unsafe { CVDisplayLinkSetCurrentCGDisplay(display_link, display_id) }
}

extern "C-unwind" {
    #[cfg(all(feature = "CVReturn", feature = "objc2-open-gl"))]
    #[cfg(target_os = "macos")]
    #[deprecated = "renamed to `CVDisplayLink::set_current_cg_display_from_open_gl_context`"]
    pub fn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext(
        display_link: &CVDisplayLink,
        cgl_context: CGLContextObj,
        cgl_pixel_format: CGLPixelFormatObj,
    ) -> CVReturn;
}

#[cfg(feature = "objc2-core-graphics")]
#[deprecated = "renamed to `CVDisplayLink::current_cg_display`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkGetCurrentCGDisplay(
    display_link: &CVDisplayLink,
) -> CGDirectDisplayID {
    extern "C-unwind" {
        fn CVDisplayLinkGetCurrentCGDisplay(display_link: &CVDisplayLink) -> CGDirectDisplayID;
    }
    unsafe { CVDisplayLinkGetCurrentCGDisplay(display_link) }
}

extern "C-unwind" {
    #[cfg(all(feature = "CVBase", feature = "CVReturn"))]
    #[deprecated = "renamed to `CVDisplayLink::set_output_callback`"]
    pub fn CVDisplayLinkSetOutputCallback(
        display_link: &CVDisplayLink,
        callback: CVDisplayLinkOutputCallback,
        user_info: *mut c_void,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(all(feature = "CVBase", feature = "CVReturn", feature = "block2"))]
    #[deprecated = "renamed to `CVDisplayLink::set_output_handler`"]
    pub fn CVDisplayLinkSetOutputHandler(
        display_link: &CVDisplayLink,
        handler: CVDisplayLinkOutputHandler,
    ) -> CVReturn;
}

#[cfg(feature = "CVReturn")]
#[deprecated = "renamed to `CVDisplayLink::start`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkStart(display_link: &CVDisplayLink) -> CVReturn {
    extern "C-unwind" {
        fn CVDisplayLinkStart(display_link: &CVDisplayLink) -> CVReturn;
    }
    unsafe { CVDisplayLinkStart(display_link) }
}

#[cfg(feature = "CVReturn")]
#[deprecated = "renamed to `CVDisplayLink::stop`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkStop(display_link: &CVDisplayLink) -> CVReturn {
    extern "C-unwind" {
        fn CVDisplayLinkStop(display_link: &CVDisplayLink) -> CVReturn;
    }
    unsafe { CVDisplayLinkStop(display_link) }
}

#[cfg(feature = "CVBase")]
#[deprecated = "renamed to `CVDisplayLink::nominal_output_video_refresh_period`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkGetNominalOutputVideoRefreshPeriod(
    display_link: &CVDisplayLink,
) -> CVTime {
    extern "C-unwind" {
        fn CVDisplayLinkGetNominalOutputVideoRefreshPeriod(display_link: &CVDisplayLink) -> CVTime;
    }
    unsafe { CVDisplayLinkGetNominalOutputVideoRefreshPeriod(display_link) }
}

#[cfg(feature = "CVBase")]
#[deprecated = "renamed to `CVDisplayLink::output_video_latency`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkGetOutputVideoLatency(
    display_link: &CVDisplayLink,
) -> CVTime {
    extern "C-unwind" {
        fn CVDisplayLinkGetOutputVideoLatency(display_link: &CVDisplayLink) -> CVTime;
    }
    unsafe { CVDisplayLinkGetOutputVideoLatency(display_link) }
}

#[deprecated = "renamed to `CVDisplayLink::actual_output_video_refresh_period`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkGetActualOutputVideoRefreshPeriod(
    display_link: &CVDisplayLink,
) -> c_double {
    extern "C-unwind" {
        fn CVDisplayLinkGetActualOutputVideoRefreshPeriod(display_link: &CVDisplayLink)
            -> c_double;
    }
    unsafe { CVDisplayLinkGetActualOutputVideoRefreshPeriod(display_link) }
}

#[deprecated = "renamed to `CVDisplayLink::is_running`"]
#[inline]
pub extern "C-unwind" fn CVDisplayLinkIsRunning(display_link: &CVDisplayLink) -> bool {
    extern "C-unwind" {
        fn CVDisplayLinkIsRunning(display_link: &CVDisplayLink) -> Boolean;
    }
    let ret = unsafe { CVDisplayLinkIsRunning(display_link) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(all(feature = "CVBase", feature = "CVReturn"))]
    #[deprecated = "renamed to `CVDisplayLink::current_time`"]
    pub fn CVDisplayLinkGetCurrentTime(
        display_link: &CVDisplayLink,
        out_time: NonNull<CVTimeStamp>,
    ) -> CVReturn;
}

extern "C-unwind" {
    #[cfg(all(feature = "CVBase", feature = "CVReturn"))]
    #[deprecated = "renamed to `CVDisplayLink::translate_time`"]
    pub fn CVDisplayLinkTranslateTime(
        display_link: &CVDisplayLink,
        in_time: NonNull<CVTimeStamp>,
        out_time: NonNull<CVTimeStamp>,
    ) -> CVReturn;
}
