\page ExampleTestEm12 Example TestEm12


 How to plot a depth dose profile in spherical geometry.        

	
## GEOMETRY DEFINITION
 
  The geometry consists of a single sphere of an homogenous material.
  Optionally, the sphere can be divided in thin shells.
  
  3 parameters define the geometry :
  - the material of the sphere,
  - the radius of the sphere (absorRadius),
  - the number of shells (nbOfLayers)
          
  In addition a transverse uniform magnetic field can be applied.
 
  The default geometry is constructed in DetectorConstruction class,
  but all of the above parameters can be changed interactively via
  the commands defined in the DetectorMessenger class.
 	
## PHYSICS LIST

  Physics Lists are based on modular design. Several modules are instantiated:
  1. Transportation
  2. EM physics
  3. Decays
  4. StepMax - for step limitation

  The following options for EM physics using builders from physics_lists
  sub-package are available:
  - "emstandard_opt0" recommended standard EM physics for LHC
  - "emstandard_opt1" best CPU performance standard physics for LHC
  - "emstandard_opt2" similar fast simulation
  - "emstandard_opt3" best standard EM options - analog to "local" above
  - "emstandard_opt4" best current advanced EM options standard + lowenergy
  - "emstandardWVI" standard EM physics and WentzelVI multiple scattering
  - "emstandardSS"  standard EM physics and single scattering model
  - "emstandardGS"  standard EM physics and Goudsmit-Saunderson multiple scatt.
  - "emlivermore"  low-energy EM physics using Livermore data
  - "empenelope"   low-energy EM physics implementing Penelope models
  - "emlowenergy"  low-energy EM physics implementing experimental
                   low-energy models
  - "dna"          process and models for Geant4-DNA
  - "dna_opt1"     process and models for Geant4-DNA
  - "dna_opt2"     process and models for Geant4-DNA
  - "dna_opt3"     process and models for Geant4-DNA
  - "dna_opt4"     process and models for Geant4-DNA
  - "dna_opt5"     process and models for Geant4-DNA
  - "dna_opt6"     process and models for Geant4-DNA
  - "dna_opt7"     process and models for Geant4-DNA

  A local builder, PhysListEmStandard "local" (similar to opt0) is also
  available.

  Physics lists and options can be (re)set with UI commands

## AN EVENT : THE PRIMARY GENERATOR
 
  The primary kinematic consists of a single particle randomly shot at
  the centre of the sphere. The type of the particle and its energy are set 
  in the PrimaryGeneratorAction class, and can be changed via the G4 
  built-in commands of G4ParticleGun class (see the macros provided with 
  this example).

  In addition one can deactivate the randomness of the direction of the 
  incident particle. The corresponding interactive command is built in
  PrimaryGeneratorMessenger class.
          
  A RUN is a set of events.
 					
## VISUALIZATION
 
  The Visualization Manager is set in the main().
  The initialisation of the drawing is done via the commands
  /vis/... in the macro vis.mac. To get visualisation:
```
> /control/execute vis.mac
```
 	
 The detector has a default view which is a longitudinal view of the 
 box.
 
 The tracks are drawn at the end of event, and erased at the end of run.
 Optionally one can choose to draw all particles, only the charged ones,
 or none. This command is defined in EventActionMessenger class.
 		
## HOW TO START ?
 
 - Execute TestEm12 in 'batch' mode from macro files
```
% ./TestEm12   run01.mac
```
 		
 - Execute TestEm12 in 'interactive mode' with visualization
```
% ./TestEm12
....
Idle> type your commands
....
Idle> exit
```
		
 Macros provided in this example:
  - berger.mac: e- (100 keV) on water
  - dna.mac: e- (1 keV) on water. DNA physics list
  - run01.mac: e- (4 MeV) on water. Step max from histos 1 and 8
  - run02.mac: e- (4 MeV) on water. Step max from geometry
  
  Macros to be run interactively:
  - vis.mac: To activate visualization
 		
## TRACKING and STEP MAX
 
 TestDm12 computes the total energy deposited along the trajectory of 
 the incident particle : the so-called longitudinal energy profile,
 or depth dose distribution.
 The energy deposited (edep) is randomly distributed along the step (see
 SteppingAction).
 
 In order to control the accuracy of the deposition, the maximum step size 
 of charged particles is computed automatically from the binning of 
 histograms 1 and 8 (see RunAction).
 
 As an example, this limitation is implemented as a 'full' process :
 see StepMax class and its messenger.
 The 'StepMax process' is registered in the Physics List.
 
 StepMax is evaluated in RunAction::BeginOfRun() and passed 
 to the StepMax process. 
 A boolean UI command allows to deactivate this mechanism.
 Another UI command allows to define directly a stepMax value.
      	
## HISTOGRAMS
 
 Testem12 has several predefined 1D histograms : 
 
  - 1 : energy profile dE/dr (in MeV/mm per event)
  - 2 : total energy deposited in the absorber
  - 3 : total track length of the primary track
  - 4 : step size of the primary track      
  - 5 : projected range of the primary track
  - 6 : total track length of charged secondary tracks
  - 7 : step size of charged secondary tracks      
  - 8 : normalized energy profile d(E/E0)/d(r/r0), where r0 is the range of
        the primary particle of energy E0
          
 The histograms are managed by G4AnalysisManager class and its messenger. 
 The histos can be individually activated with the command :
```
/analysis/h1/set id nbBins  valMin valMax unit 
```
  where unit is the desired unit for the histo (MeV or keV, deg or mrad, etc..)
   
  One can control the name of the histograms file with the command:
```
/analysis/setFileName  name  (default testem12)
```
    
  It is possible to choose the format of the histogram file : root (default),
  xml, csv, by changing the default file type in HistoManager.cc      
  
  It is also possible to print selected histograms on an ascii file:
```
/analysis/h1/setAscii id
```
  All selected histos will be written on a file name.ascii  (default testem12) 
  