//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpattern?language=objc)
#[doc(alias = "CGPatternRef")]
#[repr(C)]
pub struct CGPattern {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CGPattern {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"CGPattern"> for CGPattern {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpatterntiling?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGPatternTiling(pub i32);
impl CGPatternTiling {
    #[doc(alias = "kCGPatternTilingNoDistortion")]
    pub const NoDistortion: Self = Self(0);
    #[doc(alias = "kCGPatternTilingConstantSpacingMinimalDistortion")]
    pub const ConstantSpacingMinimalDistortion: Self = Self(1);
    #[doc(alias = "kCGPatternTilingConstantSpacing")]
    pub const ConstantSpacing: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGPatternTiling {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGPatternTiling {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpatterndrawpatterncallback?language=objc)
#[cfg(feature = "CGContext")]
pub type CGPatternDrawPatternCallback =
    Option<unsafe extern "C-unwind" fn(*mut c_void, *mut CGContext)>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpatternreleaseinfocallback?language=objc)
pub type CGPatternReleaseInfoCallback = Option<unsafe extern "C-unwind" fn(*mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgpatterncallbacks?language=objc)
#[cfg(feature = "CGContext")]
#[repr(C)]
#[allow(unpredictable_function_pointer_comparisons)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CGPatternCallbacks {
    pub version: c_uint,
    pub drawPattern: CGPatternDrawPatternCallback,
    pub releaseInfo: CGPatternReleaseInfoCallback,
}

#[cfg(all(feature = "CGContext", feature = "objc2"))]
unsafe impl Encode for CGPatternCallbacks {
    const ENCODING: Encoding = Encoding::Struct(
        "CGPatternCallbacks",
        &[
            <c_uint>::ENCODING,
            <CGPatternDrawPatternCallback>::ENCODING,
            <CGPatternReleaseInfoCallback>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "CGContext", feature = "objc2"))]
unsafe impl RefEncode for CGPatternCallbacks {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CGPattern {
    #[doc(alias = "CGPatternGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CGPatternGetTypeID() -> CFTypeID;
        }
        unsafe { CGPatternGetTypeID() }
    }
}

impl CGPattern {
    /// # Safety
    ///
    /// - `info` must be a valid pointer or null.
    /// - `callbacks` must be a valid pointer or null.
    #[doc(alias = "CGPatternCreate")]
    #[cfg(feature = "CGContext")]
    #[inline]
    pub unsafe fn new(
        info: *mut c_void,
        bounds: CGRect,
        matrix: CGAffineTransform,
        x_step: CGFloat,
        y_step: CGFloat,
        tiling: CGPatternTiling,
        is_colored: bool,
        callbacks: *const CGPatternCallbacks,
    ) -> Option<CFRetained<CGPattern>> {
        extern "C-unwind" {
            fn CGPatternCreate(
                info: *mut c_void,
                bounds: CGRect,
                matrix: CGAffineTransform,
                x_step: CGFloat,
                y_step: CGFloat,
                tiling: CGPatternTiling,
                is_colored: bool,
                callbacks: *const CGPatternCallbacks,
            ) -> Option<NonNull<CGPattern>>;
        }
        let ret = unsafe {
            CGPatternCreate(
                info, bounds, matrix, x_step, y_step, tiling, is_colored, callbacks,
            )
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

#[cfg(feature = "CGContext")]
#[deprecated = "renamed to `CGPattern::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CGPatternCreate(
    info: *mut c_void,
    bounds: CGRect,
    matrix: CGAffineTransform,
    x_step: CGFloat,
    y_step: CGFloat,
    tiling: CGPatternTiling,
    is_colored: bool,
    callbacks: *const CGPatternCallbacks,
) -> Option<CFRetained<CGPattern>> {
    extern "C-unwind" {
        fn CGPatternCreate(
            info: *mut c_void,
            bounds: CGRect,
            matrix: CGAffineTransform,
            x_step: CGFloat,
            y_step: CGFloat,
            tiling: CGPatternTiling,
            is_colored: bool,
            callbacks: *const CGPatternCallbacks,
        ) -> Option<NonNull<CGPattern>>;
    }
    let ret = unsafe {
        CGPatternCreate(
            info, bounds, matrix, x_step, y_step, tiling, is_colored, callbacks,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
