package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrademarkOrder invokes the trademark.CreateTrademarkOrder API synchronously
// api document: https://help.aliyun.com/api/trademark/createtrademarkorder.html
func (client *Client) CreateTrademarkOrder(request *CreateTrademarkOrderRequest) (response *CreateTrademarkOrderResponse, err error) {
	response = CreateCreateTrademarkOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrademarkOrderWithChan invokes the trademark.CreateTrademarkOrder API asynchronously
// api document: https://help.aliyun.com/api/trademark/createtrademarkorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrademarkOrderWithChan(request *CreateTrademarkOrderRequest) (<-chan *CreateTrademarkOrderResponse, <-chan error) {
	responseChan := make(chan *CreateTrademarkOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrademarkOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrademarkOrderWithCallback invokes the trademark.CreateTrademarkOrder API asynchronously
// api document: https://help.aliyun.com/api/trademark/createtrademarkorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTrademarkOrderWithCallback(request *CreateTrademarkOrderRequest, callback func(response *CreateTrademarkOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrademarkOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateTrademarkOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrademarkOrderRequest is the request struct for api CreateTrademarkOrder
type CreateTrademarkOrderRequest struct {
	*requests.RpcRequest
	TmName         string           `position:"Query" name:"TmName"`
	RealUserName   string           `position:"Query" name:"RealUserName"`
	OrderData      string           `position:"Query" name:"OrderData"`
	Channel        string           `position:"Query" name:"Channel"`
	PartnerCode    string           `position:"Query" name:"PartnerCode"`
	PhoneNum       string           `position:"Query" name:"PhoneNum"`
	Type           requests.Integer `position:"Query" name:"Type"`
	MaterialId     string           `position:"Query" name:"MaterialId"`
	UserId         requests.Integer `position:"Query" name:"UserId"`
	TmComment      string           `position:"Query" name:"TmComment"`
	RegisterName   string           `position:"Query" name:"RegisterName"`
	TmNameType     string           `position:"Query" name:"TmNameType"`
	TmIcon         string           `position:"Query" name:"TmIcon"`
	Uid            string           `position:"Query" name:"Uid"`
	IsBlackIcon    requests.Boolean `position:"Query" name:"IsBlackIcon"`
	RenewInfoId    string           `position:"Query" name:"RenewInfoId"`
	BizId          string           `position:"Query" name:"BizId"`
	RootCode       string           `position:"Query" name:"RootCode"`
	LoaOssKey      string           `position:"Query" name:"LoaOssKey"`
	RegisterNumber string           `position:"Query" name:"RegisterNumber"`
}

// CreateTrademarkOrderResponse is the response struct for api CreateTrademarkOrder
type CreateTrademarkOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   int64  `json:"OrderId" xml:"OrderId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateCreateTrademarkOrderRequest creates a request to invoke CreateTrademarkOrder API
func CreateCreateTrademarkOrderRequest() (request *CreateTrademarkOrderRequest) {
	request = &CreateTrademarkOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "CreateTrademarkOrder", "trademark", "openAPI")
	return
}

// CreateCreateTrademarkOrderResponse creates a response to parse from CreateTrademarkOrder response
func CreateCreateTrademarkOrderResponse() (response *CreateTrademarkOrderResponse) {
	response = &CreateTrademarkOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
