package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddZoneToVpcEndpoint invokes the privatelink.AddZoneToVpcEndpoint API synchronously
func (client *Client) AddZoneToVpcEndpoint(request *AddZoneToVpcEndpointRequest) (response *AddZoneToVpcEndpointResponse, err error) {
	response = CreateAddZoneToVpcEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// AddZoneToVpcEndpointWithChan invokes the privatelink.AddZoneToVpcEndpoint API asynchronously
func (client *Client) AddZoneToVpcEndpointWithChan(request *AddZoneToVpcEndpointRequest) (<-chan *AddZoneToVpcEndpointResponse, <-chan error) {
	responseChan := make(chan *AddZoneToVpcEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddZoneToVpcEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddZoneToVpcEndpointWithCallback invokes the privatelink.AddZoneToVpcEndpoint API asynchronously
func (client *Client) AddZoneToVpcEndpointWithCallback(request *AddZoneToVpcEndpointRequest, callback func(response *AddZoneToVpcEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddZoneToVpcEndpointResponse
		var err error
		defer close(result)
		response, err = client.AddZoneToVpcEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddZoneToVpcEndpointRequest is the request struct for api AddZoneToVpcEndpoint
type AddZoneToVpcEndpointRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	EndpointId  string           `position:"Query" name:"EndpointId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	Ip          string           `position:"Query" name:"ip"`
	VSwitchId   string           `position:"Query" name:"VSwitchId"`
	ZoneId      string           `position:"Query" name:"ZoneId"`
}

// AddZoneToVpcEndpointResponse is the response struct for api AddZoneToVpcEndpoint
type AddZoneToVpcEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddZoneToVpcEndpointRequest creates a request to invoke AddZoneToVpcEndpoint API
func CreateAddZoneToVpcEndpointRequest() (request *AddZoneToVpcEndpointRequest) {
	request = &AddZoneToVpcEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "AddZoneToVpcEndpoint", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddZoneToVpcEndpointResponse creates a response to parse from AddZoneToVpcEndpoint response
func CreateAddZoneToVpcEndpointResponse() (response *AddZoneToVpcEndpointResponse) {
	response = &AddZoneToVpcEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
