package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ForbidLiveCustomStream invokes the live.ForbidLiveCustomStream API synchronously
func (client *Client) ForbidLiveCustomStream(request *ForbidLiveCustomStreamRequest) (response *ForbidLiveCustomStreamResponse, err error) {
	response = CreateForbidLiveCustomStreamResponse()
	err = client.DoAction(request, response)
	return
}

// ForbidLiveCustomStreamWithChan invokes the live.ForbidLiveCustomStream API asynchronously
func (client *Client) ForbidLiveCustomStreamWithChan(request *ForbidLiveCustomStreamRequest) (<-chan *ForbidLiveCustomStreamResponse, <-chan error) {
	responseChan := make(chan *ForbidLiveCustomStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ForbidLiveCustomStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ForbidLiveCustomStreamWithCallback invokes the live.ForbidLiveCustomStream API asynchronously
func (client *Client) ForbidLiveCustomStreamWithCallback(request *ForbidLiveCustomStreamRequest, callback func(response *ForbidLiveCustomStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ForbidLiveCustomStreamResponse
		var err error
		defer close(result)
		response, err = client.ForbidLiveCustomStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ForbidLiveCustomStreamRequest is the request struct for api ForbidLiveCustomStream
type ForbidLiveCustomStreamRequest struct {
	*requests.RpcRequest
	Styp                string           `position:"Query" name:"Styp"`
	AppName             string           `position:"Query" name:"AppName"`
	StreamName          string           `position:"Query" name:"StreamName"`
	ControlStreamAction string           `position:"Query" name:"ControlStreamAction"`
	Needwm              string           `position:"Query" name:"Needwm"`
	ResumeTime          string           `position:"Query" name:"ResumeTime"`
	LiveStreamType      string           `position:"Query" name:"LiveStreamType"`
	DomainName          string           `position:"Query" name:"DomainName"`
	OwnerId             requests.Integer `position:"Query" name:"OwnerId"`
	Sphd                string           `position:"Query" name:"Sphd"`
	Oneshot             string           `position:"Query" name:"Oneshot"`
	Appid               string           `position:"Query" name:"Appid"`
	Ratio               string           `position:"Query" name:"Ratio"`
}

// ForbidLiveCustomStreamResponse is the response struct for api ForbidLiveCustomStream
type ForbidLiveCustomStreamResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateForbidLiveCustomStreamRequest creates a request to invoke ForbidLiveCustomStream API
func CreateForbidLiveCustomStreamRequest() (request *ForbidLiveCustomStreamRequest) {
	request = &ForbidLiveCustomStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ForbidLiveCustomStream", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateForbidLiveCustomStreamResponse creates a response to parse from ForbidLiveCustomStream response
func CreateForbidLiveCustomStreamResponse() (response *ForbidLiveCustomStreamResponse) {
	response = &ForbidLiveCustomStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
