package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListKeys invokes the kms.ListKeys API synchronously
func (client *Client) ListKeys(request *ListKeysRequest) (response *ListKeysResponse, err error) {
	response = CreateListKeysResponse()
	err = client.DoAction(request, response)
	return
}

// ListKeysWithChan invokes the kms.ListKeys API asynchronously
func (client *Client) ListKeysWithChan(request *ListKeysRequest) (<-chan *ListKeysResponse, <-chan error) {
	responseChan := make(chan *ListKeysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListKeys(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListKeysWithCallback invokes the kms.ListKeys API asynchronously
func (client *Client) ListKeysWithCallback(request *ListKeysRequest, callback func(response *ListKeysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListKeysResponse
		var err error
		defer close(result)
		response, err = client.ListKeys(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListKeysRequest is the request struct for api ListKeys
type ListKeysRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Filters    string           `position:"Query" name:"Filters"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListKeysResponse is the response struct for api ListKeys
type ListKeysResponse struct {
	*responses.BaseResponse
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	Keys       Keys   `json:"Keys" xml:"Keys"`
}

// CreateListKeysRequest creates a request to invoke ListKeys API
func CreateListKeysRequest() (request *ListKeysRequest) {
	request = &ListKeysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "ListKeys", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListKeysResponse creates a response to parse from ListKeys response
func CreateListKeysResponse() (response *ListKeysResponse) {
	response = &ListKeysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
