package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateDynamicImage invokes the imageenhan.GenerateDynamicImage API synchronously
func (client *Client) GenerateDynamicImage(request *GenerateDynamicImageRequest) (response *GenerateDynamicImageResponse, err error) {
	response = CreateGenerateDynamicImageResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateDynamicImageWithChan invokes the imageenhan.GenerateDynamicImage API asynchronously
func (client *Client) GenerateDynamicImageWithChan(request *GenerateDynamicImageRequest) (<-chan *GenerateDynamicImageResponse, <-chan error) {
	responseChan := make(chan *GenerateDynamicImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateDynamicImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateDynamicImageWithCallback invokes the imageenhan.GenerateDynamicImage API asynchronously
func (client *Client) GenerateDynamicImageWithCallback(request *GenerateDynamicImageRequest, callback func(response *GenerateDynamicImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateDynamicImageResponse
		var err error
		defer close(result)
		response, err = client.GenerateDynamicImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateDynamicImageRequest is the request struct for api GenerateDynamicImage
type GenerateDynamicImageRequest struct {
	*requests.RpcRequest
	Url       string `position:"Body" name:"Url"`
	Operation string `position:"Body" name:"Operation"`
}

// GenerateDynamicImageResponse is the response struct for api GenerateDynamicImage
type GenerateDynamicImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateDynamicImageRequest creates a request to invoke GenerateDynamicImage API
func CreateGenerateDynamicImageRequest() (request *GenerateDynamicImageRequest) {
	request = &GenerateDynamicImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "GenerateDynamicImage", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateDynamicImageResponse creates a response to parse from GenerateDynamicImage response
func CreateGenerateDynamicImageResponse() (response *GenerateDynamicImageResponse) {
	response = &GenerateDynamicImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
