package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FtDynamicAddressHttpVpc invokes the ft.FtDynamicAddressHttpVpc API synchronously
func (client *Client) FtDynamicAddressHttpVpc(request *FtDynamicAddressHttpVpcRequest) (response *FtDynamicAddressHttpVpcResponse, err error) {
	response = CreateFtDynamicAddressHttpVpcResponse()
	err = client.DoAction(request, response)
	return
}

// FtDynamicAddressHttpVpcWithChan invokes the ft.FtDynamicAddressHttpVpc API asynchronously
func (client *Client) FtDynamicAddressHttpVpcWithChan(request *FtDynamicAddressHttpVpcRequest) (<-chan *FtDynamicAddressHttpVpcResponse, <-chan error) {
	responseChan := make(chan *FtDynamicAddressHttpVpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FtDynamicAddressHttpVpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FtDynamicAddressHttpVpcWithCallback invokes the ft.FtDynamicAddressHttpVpc API asynchronously
func (client *Client) FtDynamicAddressHttpVpcWithCallback(request *FtDynamicAddressHttpVpcRequest, callback func(response *FtDynamicAddressHttpVpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FtDynamicAddressHttpVpcResponse
		var err error
		defer close(result)
		response, err = client.FtDynamicAddressHttpVpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FtDynamicAddressHttpVpcRequest is the request struct for api FtDynamicAddressHttpVpc
type FtDynamicAddressHttpVpcRequest struct {
	*requests.RpcRequest
	P1           string           `position:"Query" name:"P1"`
	StringValue  string           `position:"Query" name:"StringValue"`
	OtherParam   string           `position:"Query" name:"OtherParam"`
	BooleanParam requests.Boolean `position:"Query" name:"BooleanParam"`
	DefaultValue string           `position:"Query" name:"DefaultValue"`
}

// FtDynamicAddressHttpVpcResponse is the response struct for api FtDynamicAddressHttpVpc
type FtDynamicAddressHttpVpcResponse struct {
	*responses.BaseResponse
	Params         string `json:"Params" xml:"Params"`
	ServiceRpcSign string `json:"ServiceRpcSign" xml:"ServiceRpcSign"`
}

// CreateFtDynamicAddressHttpVpcRequest creates a request to invoke FtDynamicAddressHttpVpc API
func CreateFtDynamicAddressHttpVpcRequest() (request *FtDynamicAddressHttpVpcRequest) {
	request = &FtDynamicAddressHttpVpcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "FtDynamicAddressHttpVpc", "", "")
	request.Method = requests.POST
	return
}

// CreateFtDynamicAddressHttpVpcResponse creates a response to parse from FtDynamicAddressHttpVpc response
func CreateFtDynamicAddressHttpVpcResponse() (response *FtDynamicAddressHttpVpcResponse) {
	response = &FtDynamicAddressHttpVpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
