package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListWorkFlowTemplates invokes the dms_enterprise.ListWorkFlowTemplates API synchronously
// api document: https://help.aliyun.com/api/dms-enterprise/listworkflowtemplates.html
func (client *Client) ListWorkFlowTemplates(request *ListWorkFlowTemplatesRequest) (response *ListWorkFlowTemplatesResponse, err error) {
	response = CreateListWorkFlowTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// ListWorkFlowTemplatesWithChan invokes the dms_enterprise.ListWorkFlowTemplates API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/listworkflowtemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListWorkFlowTemplatesWithChan(request *ListWorkFlowTemplatesRequest) (<-chan *ListWorkFlowTemplatesResponse, <-chan error) {
	responseChan := make(chan *ListWorkFlowTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListWorkFlowTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListWorkFlowTemplatesWithCallback invokes the dms_enterprise.ListWorkFlowTemplates API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/listworkflowtemplates.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListWorkFlowTemplatesWithCallback(request *ListWorkFlowTemplatesRequest, callback func(response *ListWorkFlowTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListWorkFlowTemplatesResponse
		var err error
		defer close(result)
		response, err = client.ListWorkFlowTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListWorkFlowTemplatesRequest is the request struct for api ListWorkFlowTemplates
type ListWorkFlowTemplatesRequest struct {
	*requests.RpcRequest
	SearchName string           `position:"Query" name:"SearchName"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
}

// ListWorkFlowTemplatesResponse is the response struct for api ListWorkFlowTemplates
type ListWorkFlowTemplatesResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Success           bool              `json:"Success" xml:"Success"`
	ErrorMessage      string            `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode         string            `json:"ErrorCode" xml:"ErrorCode"`
	WorkFlowTemplates WorkFlowTemplates `json:"WorkFlowTemplates" xml:"WorkFlowTemplates"`
}

// CreateListWorkFlowTemplatesRequest creates a request to invoke ListWorkFlowTemplates API
func CreateListWorkFlowTemplatesRequest() (request *ListWorkFlowTemplatesRequest) {
	request = &ListWorkFlowTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListWorkFlowTemplates", "dmsenterprise", "openAPI")
	return
}

// CreateListWorkFlowTemplatesResponse creates a response to parse from ListWorkFlowTemplates response
func CreateListWorkFlowTemplatesResponse() (response *ListWorkFlowTemplatesResponse) {
	response = &ListWorkFlowTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
