package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainQpsWithCache invokes the ddoscoo.DescribeDomainQpsWithCache API synchronously
func (client *Client) DescribeDomainQpsWithCache(request *DescribeDomainQpsWithCacheRequest) (response *DescribeDomainQpsWithCacheResponse, err error) {
	response = CreateDescribeDomainQpsWithCacheResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainQpsWithCacheWithChan invokes the ddoscoo.DescribeDomainQpsWithCache API asynchronously
func (client *Client) DescribeDomainQpsWithCacheWithChan(request *DescribeDomainQpsWithCacheRequest) (<-chan *DescribeDomainQpsWithCacheResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainQpsWithCacheResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainQpsWithCache(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainQpsWithCacheWithCallback invokes the ddoscoo.DescribeDomainQpsWithCache API asynchronously
func (client *Client) DescribeDomainQpsWithCacheWithCallback(request *DescribeDomainQpsWithCacheRequest, callback func(response *DescribeDomainQpsWithCacheResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainQpsWithCacheResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainQpsWithCache(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainQpsWithCacheRequest is the request struct for api DescribeDomainQpsWithCache
type DescribeDomainQpsWithCacheRequest struct {
	*requests.RpcRequest
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Domain          string           `position:"Query" name:"Domain"`
}

// DescribeDomainQpsWithCacheResponse is the response struct for api DescribeDomainQpsWithCache
type DescribeDomainQpsWithCacheResponse struct {
	*responses.BaseResponse
	RequestId     string   `json:"RequestId" xml:"RequestId"`
	Interval      int      `json:"Interval" xml:"Interval"`
	StartTime     int64    `json:"StartTime" xml:"StartTime"`
	Totals        []string `json:"Totals" xml:"Totals"`
	Blocks        []string `json:"Blocks" xml:"Blocks"`
	CacheHits     []string `json:"CacheHits" xml:"CacheHits"`
	PreciseBlocks []string `json:"PreciseBlocks" xml:"PreciseBlocks"`
	RegionBlocks  []string `json:"RegionBlocks" xml:"RegionBlocks"`
	IpBlockQps    []string `json:"IpBlockQps" xml:"IpBlockQps"`
	CcJsQps       []string `json:"CcJsQps" xml:"CcJsQps"`
	PreciseJsQps  []string `json:"PreciseJsQps" xml:"PreciseJsQps"`
	CcBlockQps    []string `json:"CcBlockQps" xml:"CcBlockQps"`
}

// CreateDescribeDomainQpsWithCacheRequest creates a request to invoke DescribeDomainQpsWithCache API
func CreateDescribeDomainQpsWithCacheRequest() (request *DescribeDomainQpsWithCacheRequest) {
	request = &DescribeDomainQpsWithCacheRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DescribeDomainQpsWithCache", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainQpsWithCacheResponse creates a response to parse from DescribeDomainQpsWithCache response
func CreateDescribeDomainQpsWithCacheResponse() (response *DescribeDomainQpsWithCacheResponse) {
	response = &DescribeDomainQpsWithCacheResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
