package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainWebsocketBpsData invokes the dcdn.DescribeDcdnDomainWebsocketBpsData API synchronously
func (client *Client) DescribeDcdnDomainWebsocketBpsData(request *DescribeDcdnDomainWebsocketBpsDataRequest) (response *DescribeDcdnDomainWebsocketBpsDataResponse, err error) {
	response = CreateDescribeDcdnDomainWebsocketBpsDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainWebsocketBpsDataWithChan invokes the dcdn.DescribeDcdnDomainWebsocketBpsData API asynchronously
func (client *Client) DescribeDcdnDomainWebsocketBpsDataWithChan(request *DescribeDcdnDomainWebsocketBpsDataRequest) (<-chan *DescribeDcdnDomainWebsocketBpsDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainWebsocketBpsDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainWebsocketBpsData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainWebsocketBpsDataWithCallback invokes the dcdn.DescribeDcdnDomainWebsocketBpsData API asynchronously
func (client *Client) DescribeDcdnDomainWebsocketBpsDataWithCallback(request *DescribeDcdnDomainWebsocketBpsDataRequest, callback func(response *DescribeDcdnDomainWebsocketBpsDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainWebsocketBpsDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainWebsocketBpsData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainWebsocketBpsDataRequest is the request struct for api DescribeDcdnDomainWebsocketBpsData
type DescribeDcdnDomainWebsocketBpsDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
	Interval       string           `position:"Query" name:"Interval"`
}

// DescribeDcdnDomainWebsocketBpsDataResponse is the response struct for api DescribeDcdnDomainWebsocketBpsData
type DescribeDcdnDomainWebsocketBpsDataResponse struct {
	*responses.BaseResponse
	RequestId          string                                                 `json:"RequestId" xml:"RequestId"`
	DomainName         string                                                 `json:"DomainName" xml:"DomainName"`
	StartTime          string                                                 `json:"StartTime" xml:"StartTime"`
	EndTime            string                                                 `json:"EndTime" xml:"EndTime"`
	DataInterval       string                                                 `json:"DataInterval" xml:"DataInterval"`
	BpsDataPerInterval BpsDataPerIntervalInDescribeDcdnDomainWebsocketBpsData `json:"BpsDataPerInterval" xml:"BpsDataPerInterval"`
}

// CreateDescribeDcdnDomainWebsocketBpsDataRequest creates a request to invoke DescribeDcdnDomainWebsocketBpsData API
func CreateDescribeDcdnDomainWebsocketBpsDataRequest() (request *DescribeDcdnDomainWebsocketBpsDataRequest) {
	request = &DescribeDcdnDomainWebsocketBpsDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainWebsocketBpsData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainWebsocketBpsDataResponse creates a response to parse from DescribeDcdnDomainWebsocketBpsData response
func CreateDescribeDcdnDomainWebsocketBpsDataResponse() (response *DescribeDcdnDomainWebsocketBpsDataResponse) {
	response = &DescribeDcdnDomainWebsocketBpsDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
