package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindCredentialStatisticalData invokes the csb.FindCredentialStatisticalData API synchronously
// api document: https://help.aliyun.com/api/csb/findcredentialstatisticaldata.html
func (client *Client) FindCredentialStatisticalData(request *FindCredentialStatisticalDataRequest) (response *FindCredentialStatisticalDataResponse, err error) {
	response = CreateFindCredentialStatisticalDataResponse()
	err = client.DoAction(request, response)
	return
}

// FindCredentialStatisticalDataWithChan invokes the csb.FindCredentialStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/csb/findcredentialstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindCredentialStatisticalDataWithChan(request *FindCredentialStatisticalDataRequest) (<-chan *FindCredentialStatisticalDataResponse, <-chan error) {
	responseChan := make(chan *FindCredentialStatisticalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindCredentialStatisticalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindCredentialStatisticalDataWithCallback invokes the csb.FindCredentialStatisticalData API asynchronously
// api document: https://help.aliyun.com/api/csb/findcredentialstatisticaldata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindCredentialStatisticalDataWithCallback(request *FindCredentialStatisticalDataRequest, callback func(response *FindCredentialStatisticalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindCredentialStatisticalDataResponse
		var err error
		defer close(result)
		response, err = client.FindCredentialStatisticalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindCredentialStatisticalDataRequest is the request struct for api FindCredentialStatisticalData
type FindCredentialStatisticalDataRequest struct {
	*requests.RpcRequest
	CsbId          requests.Integer `position:"Query" name:"CsbId"`
	EndTime        requests.Integer `position:"Query" name:"EndTime"`
	StartTime      requests.Integer `position:"Query" name:"StartTime"`
	CredentialName string           `position:"Query" name:"CredentialName"`
}

// FindCredentialStatisticalDataResponse is the response struct for api FindCredentialStatisticalData
type FindCredentialStatisticalDataResponse struct {
	*responses.BaseResponse
	Code      int                                 `json:"Code" xml:"Code"`
	Message   string                              `json:"Message" xml:"Message"`
	RequestId string                              `json:"RequestId" xml:"RequestId"`
	Data      DataInFindCredentialStatisticalData `json:"Data" xml:"Data"`
}

// CreateFindCredentialStatisticalDataRequest creates a request to invoke FindCredentialStatisticalData API
func CreateFindCredentialStatisticalDataRequest() (request *FindCredentialStatisticalDataRequest) {
	request = &FindCredentialStatisticalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "FindCredentialStatisticalData", "", "")
	request.Method = requests.GET
	return
}

// CreateFindCredentialStatisticalDataResponse creates a response to parse from FindCredentialStatisticalData response
func CreateFindCredentialStatisticalDataResponse() (response *FindCredentialStatisticalDataResponse) {
	response = &FindCredentialStatisticalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
