package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLatestApStatistic invokes the cloudwf.GetLatestApStatistic API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getlatestapstatistic.html
func (client *Client) GetLatestApStatistic(request *GetLatestApStatisticRequest) (response *GetLatestApStatisticResponse, err error) {
	response = CreateGetLatestApStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// GetLatestApStatisticWithChan invokes the cloudwf.GetLatestApStatistic API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getlatestapstatistic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLatestApStatisticWithChan(request *GetLatestApStatisticRequest) (<-chan *GetLatestApStatisticResponse, <-chan error) {
	responseChan := make(chan *GetLatestApStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLatestApStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLatestApStatisticWithCallback invokes the cloudwf.GetLatestApStatistic API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getlatestapstatistic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetLatestApStatisticWithCallback(request *GetLatestApStatisticRequest, callback func(response *GetLatestApStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLatestApStatisticResponse
		var err error
		defer close(result)
		response, err = client.GetLatestApStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLatestApStatisticRequest is the request struct for api GetLatestApStatistic
type GetLatestApStatisticRequest struct {
	*requests.RpcRequest
	ApgroupId requests.Integer `position:"Query" name:"ApgroupId"`
}

// GetLatestApStatisticResponse is the response struct for api GetLatestApStatistic
type GetLatestApStatisticResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetLatestApStatisticRequest creates a request to invoke GetLatestApStatistic API
func CreateGetLatestApStatisticRequest() (request *GetLatestApStatisticRequest) {
	request = &GetLatestApStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetLatestApStatistic", "cloudwf", "openAPI")
	return
}

// CreateGetLatestApStatisticResponse creates a response to parse from GetLatestApStatistic response
func CreateGetLatestApStatisticResponse() (response *GetLatestApStatisticResponse) {
	response = &GetLatestApStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
