package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGameCcu invokes the cloudgameapi.GetGameCcu API synchronously
func (client *Client) GetGameCcu(request *GetGameCcuRequest) (response *GetGameCcuResponse, err error) {
	response = CreateGetGameCcuResponse()
	err = client.DoAction(request, response)
	return
}

// GetGameCcuWithChan invokes the cloudgameapi.GetGameCcu API asynchronously
func (client *Client) GetGameCcuWithChan(request *GetGameCcuRequest) (<-chan *GetGameCcuResponse, <-chan error) {
	responseChan := make(chan *GetGameCcuResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGameCcu(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGameCcuWithCallback invokes the cloudgameapi.GetGameCcu API asynchronously
func (client *Client) GetGameCcuWithCallback(request *GetGameCcuRequest, callback func(response *GetGameCcuResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGameCcuResponse
		var err error
		defer close(result)
		response, err = client.GetGameCcu(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGameCcuRequest is the request struct for api GetGameCcu
type GetGameCcuRequest struct {
	*requests.RpcRequest
	GameId     string `position:"Query" name:"GameId"`
	AccessKey  string `position:"Query" name:"AccessKey"`
	RegionName string `position:"Query" name:"RegionName"`
}

// GetGameCcuResponse is the response struct for api GetGameCcu
type GetGameCcuResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	DataList  []DataListItem `json:"DataList" xml:"DataList"`
}

// CreateGetGameCcuRequest creates a request to invoke GetGameCcu API
func CreateGetGameCcuRequest() (request *GetGameCcuRequest) {
	request = &GetGameCcuRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "GetGameCcu", "", "")
	request.Method = requests.POST
	return
}

// CreateGetGameCcuResponse creates a response to parse from GetGameCcu response
func CreateGetGameCcuResponse() (response *GetGameCcuResponse) {
	response = &GetGameCcuResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
