package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnUserBillHistory invokes the cdn.DescribeCdnUserBillHistory API synchronously
func (client *Client) DescribeCdnUserBillHistory(request *DescribeCdnUserBillHistoryRequest) (response *DescribeCdnUserBillHistoryResponse, err error) {
	response = CreateDescribeCdnUserBillHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnUserBillHistoryWithChan invokes the cdn.DescribeCdnUserBillHistory API asynchronously
func (client *Client) DescribeCdnUserBillHistoryWithChan(request *DescribeCdnUserBillHistoryRequest) (<-chan *DescribeCdnUserBillHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnUserBillHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnUserBillHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnUserBillHistoryWithCallback invokes the cdn.DescribeCdnUserBillHistory API asynchronously
func (client *Client) DescribeCdnUserBillHistoryWithCallback(request *DescribeCdnUserBillHistoryRequest, callback func(response *DescribeCdnUserBillHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnUserBillHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnUserBillHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnUserBillHistoryRequest is the request struct for api DescribeCdnUserBillHistory
type DescribeCdnUserBillHistoryRequest struct {
	*requests.RpcRequest
	StartTime string           `position:"Query" name:"StartTime"`
	EndTime   string           `position:"Query" name:"EndTime"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCdnUserBillHistoryResponse is the response struct for api DescribeCdnUserBillHistory
type DescribeCdnUserBillHistoryResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	BillHistoryData BillHistoryData `json:"BillHistoryData" xml:"BillHistoryData"`
}

// CreateDescribeCdnUserBillHistoryRequest creates a request to invoke DescribeCdnUserBillHistory API
func CreateDescribeCdnUserBillHistoryRequest() (request *DescribeCdnUserBillHistoryRequest) {
	request = &DescribeCdnUserBillHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnUserBillHistory", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnUserBillHistoryResponse creates a response to parse from DescribeCdnUserBillHistory response
func CreateDescribeCdnUserBillHistoryResponse() (response *DescribeCdnUserBillHistoryResponse) {
	response = &DescribeCdnUserBillHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
