package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRuleGroup invokes the aegis.DeleteRuleGroup API synchronously
// api document: https://help.aliyun.com/api/aegis/deleterulegroup.html
func (client *Client) DeleteRuleGroup(request *DeleteRuleGroupRequest) (response *DeleteRuleGroupResponse, err error) {
	response = CreateDeleteRuleGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRuleGroupWithChan invokes the aegis.DeleteRuleGroup API asynchronously
// api document: https://help.aliyun.com/api/aegis/deleterulegroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRuleGroupWithChan(request *DeleteRuleGroupRequest) (<-chan *DeleteRuleGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteRuleGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRuleGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRuleGroupWithCallback invokes the aegis.DeleteRuleGroup API asynchronously
// api document: https://help.aliyun.com/api/aegis/deleterulegroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteRuleGroupWithCallback(request *DeleteRuleGroupRequest, callback func(response *DeleteRuleGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRuleGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteRuleGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRuleGroupRequest is the request struct for api DeleteRuleGroup
type DeleteRuleGroupRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	Id       requests.Integer `position:"Query" name:"Id"`
	Lang     string           `position:"Query" name:"Lang"`
}

// DeleteRuleGroupResponse is the response struct for api DeleteRuleGroup
type DeleteRuleGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRuleGroupRequest creates a request to invoke DeleteRuleGroup API
func CreateDeleteRuleGroupRequest() (request *DeleteRuleGroupRequest) {
	request = &DeleteRuleGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DeleteRuleGroup", "vipaegis", "openAPI")
	return
}

// CreateDeleteRuleGroupResponse creates a response to parse from DeleteRuleGroup response
func CreateDeleteRuleGroupResponse() (response *DeleteRuleGroupResponse) {
	response = &DeleteRuleGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
