package attestation

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PolicyCertificatesClient is the describes the interface for the per-tenant enclave service.
type PolicyCertificatesClient struct {
	BaseClient
}

// NewPolicyCertificatesClient creates an instance of the PolicyCertificatesClient client.
func NewPolicyCertificatesClient() PolicyCertificatesClient {
	return PolicyCertificatesClient{New()}
}

// Add sends the add request.
// Parameters:
// instanceURL - the attestation instance base URI, for example https://mytenant.attest.azure.net.
// policyCertificateToAdd - an RFC7519 JSON Web Token whose body is an RFC7517 JSON Web Key object. The RFC7519
// JWT must be signed with one of the existing signing certificates
func (client PolicyCertificatesClient) Add(ctx context.Context, instanceURL string, policyCertificateToAdd string) (result PolicyCertificatesModifyResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyCertificatesClient.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: policyCertificateToAdd,
			Constraints: []validation.Constraint{{Target: "policyCertificateToAdd", Name: validation.Pattern, Rule: `[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("attestation.PolicyCertificatesClient", "Add", err.Error())
	}

	req, err := client.AddPreparer(ctx, instanceURL, policyCertificateToAdd)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Add", resp, "Failure responding to request")
		return
	}

	return
}

// AddPreparer prepares the Add request.
func (client PolicyCertificatesClient) AddPreparer(ctx context.Context, instanceURL string, policyCertificateToAdd string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"instanceUrl": instanceURL,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{instanceUrl}", urlParameters),
		autorest.WithPath("/certificates:add"),
		autorest.WithJSON(policyCertificateToAdd),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyCertificatesClient) AddSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client PolicyCertificatesClient) AddResponder(resp *http.Response) (result PolicyCertificatesModifyResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get sends the get request.
// Parameters:
// instanceURL - the attestation instance base URI, for example https://mytenant.attest.azure.net.
func (client PolicyCertificatesClient) Get(ctx context.Context, instanceURL string) (result PolicyCertificatesResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyCertificatesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, instanceURL)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client PolicyCertificatesClient) GetPreparer(ctx context.Context, instanceURL string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"instanceUrl": instanceURL,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{instanceUrl}", urlParameters),
		autorest.WithPath("/certificates"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyCertificatesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client PolicyCertificatesClient) GetResponder(resp *http.Response) (result PolicyCertificatesResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Remove sends the remove request.
// Parameters:
// instanceURL - the attestation instance base URI, for example https://mytenant.attest.azure.net.
// policyCertificateToRemove - an RFC7519 JSON Web Token whose body is an AttestationCertificateManagementBody
// object. The RFC7519 JWT must be signed with one of the existing signing certificates
func (client PolicyCertificatesClient) Remove(ctx context.Context, instanceURL string, policyCertificateToRemove string) (result PolicyCertificatesModifyResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PolicyCertificatesClient.Remove")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: policyCertificateToRemove,
			Constraints: []validation.Constraint{{Target: "policyCertificateToRemove", Name: validation.Pattern, Rule: `[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("attestation.PolicyCertificatesClient", "Remove", err.Error())
	}

	req, err := client.RemovePreparer(ctx, instanceURL, policyCertificateToRemove)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Remove", nil, "Failure preparing request")
		return
	}

	resp, err := client.RemoveSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Remove", resp, "Failure sending request")
		return
	}

	result, err = client.RemoveResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "attestation.PolicyCertificatesClient", "Remove", resp, "Failure responding to request")
		return
	}

	return
}

// RemovePreparer prepares the Remove request.
func (client PolicyCertificatesClient) RemovePreparer(ctx context.Context, instanceURL string, policyCertificateToRemove string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"instanceUrl": instanceURL,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{instanceUrl}", urlParameters),
		autorest.WithPath("/certificates:remove"),
		autorest.WithJSON(policyCertificateToRemove),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RemoveSender sends the Remove request. The method will close the
// http.Response Body if it receives an error.
func (client PolicyCertificatesClient) RemoveSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// RemoveResponder handles the response to the Remove request. The method always
// closes the http.Response Body.
func (client PolicyCertificatesClient) RemoveResponder(resp *http.Response) (result PolicyCertificatesModifyResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
