/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.AuthorTree;
import com.sun.source.doctree.CommentTree;
import com.sun.source.doctree.DeprecatedTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocRootTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.HiddenTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.IndexTree;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ProvidesTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.SerialDataTree;
import com.sun.source.doctree.SerialFieldTree;
import com.sun.source.doctree.SerialTree;
import com.sun.source.doctree.SinceTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.doctree.UnknownInlineTagTree;
import com.sun.source.doctree.UsesTree;
import com.sun.source.doctree.ValueTree;
import com.sun.source.doctree.VersionTree;
import com.sun.tools.javac.util.Convert;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class DocPretty
implements DocTreeVisitor<Void, Void> {
    final Writer out;
    int lmargin = 0;
    final String lineSep = System.getProperty("line.separator");

    public DocPretty(Writer writer) {
        this.out = writer;
    }

    public void print(DocTree docTree) throws IOException {
        try {
            if (docTree == null) {
                this.print("/*missing*/");
            } else {
                docTree.accept(this, null);
            }
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw new IOException(uncheckedIOException.getMessage(), uncheckedIOException);
        }
    }

    protected void print(Object object) throws IOException {
        this.out.write(Convert.escapeUnicode(object.toString()));
    }

    public void print(List<? extends DocTree> list) throws IOException {
        for (DocTree docTree : list) {
            this.print(docTree);
        }
    }

    protected void print(List<? extends DocTree> list, String string) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        boolean bl = true;
        for (DocTree docTree : list) {
            if (!bl) {
                this.print(string);
            }
            this.print(docTree);
            bl = false;
        }
    }

    protected void println() throws IOException {
        this.out.write(this.lineSep);
    }

    protected void printTagName(DocTree docTree) throws IOException {
        this.out.write("@");
        this.out.write(docTree.getKind().tagName);
    }

    @Override
    public Void visitAttribute(AttributeTree attributeTree, Void void_) {
        try {
            String string;
            this.print(attributeTree.getName());
            switch (attributeTree.getValueKind()) {
                case EMPTY: {
                    string = null;
                    break;
                }
                case UNQUOTED: {
                    string = "";
                    break;
                }
                case SINGLE: {
                    string = "'";
                    break;
                }
                case DOUBLE: {
                    string = "\"";
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (string != null) {
                this.print("=" + string);
                this.print(attributeTree.getValue());
                this.print(string);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitAuthor(AuthorTree authorTree, Void void_) {
        try {
            this.printTagName(authorTree);
            this.print(" ");
            this.print(authorTree.getName());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitComment(CommentTree commentTree, Void void_) {
        try {
            this.print(commentTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitDeprecated(DeprecatedTree deprecatedTree, Void void_) {
        try {
            this.printTagName(deprecatedTree);
            if (!deprecatedTree.getBody().isEmpty()) {
                this.print(" ");
                this.print(deprecatedTree.getBody());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitDocComment(DocCommentTree docCommentTree, Void void_) {
        try {
            List<? extends DocTree> list = docCommentTree.getFullBody();
            List<? extends DocTree> list2 = docCommentTree.getBlockTags();
            this.print(list);
            if (!list.isEmpty() && !list2.isEmpty()) {
                this.print("\n");
            }
            this.print(list2, "\n");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitDocRoot(DocRootTree docRootTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(docRootTree);
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitEndElement(EndElementTree endElementTree, Void void_) {
        try {
            this.print("</");
            this.print(endElementTree.getName());
            this.print(">");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitEntity(EntityTree entityTree, Void void_) {
        try {
            this.print("&");
            this.print(entityTree.getName());
            this.print(";");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitErroneous(ErroneousTree erroneousTree, Void void_) {
        try {
            this.print(erroneousTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitHidden(HiddenTree hiddenTree, Void void_) {
        try {
            this.printTagName(hiddenTree);
            if (!hiddenTree.getBody().isEmpty()) {
                this.print(" ");
                this.print(hiddenTree.getBody());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
        try {
            this.print(identifierTree.getName());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitIndex(IndexTree indexTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(indexTree);
            this.print(" ");
            this.print(indexTree.getSearchTerm());
            if (!indexTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(indexTree.getDescription());
            }
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitInheritDoc(InheritDocTree inheritDocTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(inheritDocTree);
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitLink(LinkTree linkTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(linkTree);
            this.print(" ");
            this.print(linkTree.getReference());
            if (!linkTree.getLabel().isEmpty()) {
                this.print(" ");
                this.print(linkTree.getLabel());
            }
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree literalTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(literalTree);
            String string = literalTree.getBody().getBody();
            if (!string.isEmpty() && !Character.isWhitespace(string.charAt(0))) {
                this.print(" ");
            }
            this.print(literalTree.getBody());
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitParam(ParamTree paramTree, Void void_) {
        try {
            this.printTagName(paramTree);
            this.print(" ");
            if (paramTree.isTypeParameter()) {
                this.print("<");
            }
            this.print(paramTree.getName());
            if (paramTree.isTypeParameter()) {
                this.print(">");
            }
            if (!paramTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(paramTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitProvides(ProvidesTree providesTree, Void void_) {
        try {
            this.printTagName(providesTree);
            this.print(" ");
            this.print(providesTree.getServiceType());
            if (!providesTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(providesTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitReference(ReferenceTree referenceTree, Void void_) {
        try {
            this.print(referenceTree.getSignature());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree returnTree, Void void_) {
        try {
            this.printTagName(returnTree);
            this.print(" ");
            this.print(returnTree.getDescription());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSee(SeeTree seeTree, Void void_) {
        try {
            this.printTagName(seeTree);
            boolean bl = true;
            boolean bl2 = true;
            for (DocTree docTree : seeTree.getReference()) {
                if (bl2) {
                    this.print(" ");
                }
                bl2 = bl && docTree instanceof ReferenceTree;
                bl = false;
                this.print(docTree);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSerial(SerialTree serialTree, Void void_) {
        try {
            this.printTagName(serialTree);
            if (!serialTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(serialTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSerialData(SerialDataTree serialDataTree, Void void_) {
        try {
            this.printTagName(serialDataTree);
            if (!serialDataTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(serialDataTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSerialField(SerialFieldTree serialFieldTree, Void void_) {
        try {
            this.printTagName(serialFieldTree);
            this.print(" ");
            this.print(serialFieldTree.getName());
            this.print(" ");
            this.print(serialFieldTree.getType());
            if (!serialFieldTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(serialFieldTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitSince(SinceTree sinceTree, Void void_) {
        try {
            this.printTagName(sinceTree);
            this.print(" ");
            this.print(sinceTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitStartElement(StartElementTree startElementTree, Void void_) {
        try {
            this.print("<");
            this.print(startElementTree.getName());
            List<? extends DocTree> list = startElementTree.getAttributes();
            if (!list.isEmpty()) {
                this.print(" ");
                this.print(list);
                DocTree docTree = startElementTree.getAttributes().get(list.size() - 1);
                if (startElementTree.isSelfClosing() && docTree instanceof AttributeTree && ((AttributeTree)docTree).getValueKind() == AttributeTree.ValueKind.UNQUOTED) {
                    this.print(" ");
                }
            }
            if (startElementTree.isSelfClosing()) {
                this.print("/");
            }
            this.print(">");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitText(TextTree textTree, Void void_) {
        try {
            this.print(textTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitThrows(ThrowsTree throwsTree, Void void_) {
        try {
            this.printTagName(throwsTree);
            this.print(" ");
            this.print(throwsTree.getExceptionName());
            if (!throwsTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(throwsTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitUnknownBlockTag(UnknownBlockTagTree unknownBlockTagTree, Void void_) {
        try {
            this.print("@");
            this.print(unknownBlockTagTree.getTagName());
            this.print(" ");
            this.print(unknownBlockTagTree.getContent());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitUnknownInlineTag(UnknownInlineTagTree unknownInlineTagTree, Void void_) {
        try {
            this.print("{");
            this.print("@");
            this.print(unknownInlineTagTree.getTagName());
            this.print(" ");
            this.print(unknownInlineTagTree.getContent());
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitUses(UsesTree usesTree, Void void_) {
        try {
            this.printTagName(usesTree);
            this.print(" ");
            this.print(usesTree.getServiceType());
            if (!usesTree.getDescription().isEmpty()) {
                this.print(" ");
                this.print(usesTree.getDescription());
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitValue(ValueTree valueTree, Void void_) {
        try {
            this.print("{");
            this.printTagName(valueTree);
            if (valueTree.getReference() != null) {
                this.print(" ");
                this.print(valueTree.getReference());
            }
            this.print("}");
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitVersion(VersionTree versionTree, Void void_) {
        try {
            this.printTagName(versionTree);
            this.print(" ");
            this.print(versionTree.getBody());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    @Override
    public Void visitOther(DocTree docTree, Void void_) {
        try {
            this.print("(UNKNOWN: " + docTree + ")");
            this.println();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return null;
    }

    private static class UncheckedIOException
    extends Error {
        static final long serialVersionUID = -4032692679158424751L;

        UncheckedIOException(IOException iOException) {
            super(iOException.getMessage(), iOException);
        }
    }
}

