/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.Serializable;
import java.sql.SQLException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.ScheduledEntityAction;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.persister.ClassPersister;

final class ScheduledDeletion
extends ScheduledEntityAction
implements SessionImpl.Executable {
    private final Object version;

    public ScheduledDeletion(Serializable id, Object version, Object instance, ClassPersister persister, SessionImplementor session) {
        super(session, id, instance, persister);
        this.version = version;
    }

    public void execute() throws HibernateException, SQLException {
        if (this.persister.hasCache()) {
            this.persister.getCache().lock(this.id);
        }
        this.persister.delete(this.id, this.version, this.instance, this.session);
        this.session.postDelete(this.instance);
    }

    public void afterTransactionCompletion() throws CacheException {
        if (this.persister.hasCache()) {
            this.persister.getCache().release(this.id);
        }
    }
}

