//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
#[cfg(target_vendor = "apple")]
use objc2_core_graphics::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagename?language=objc)
pub type NSImageName = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagehintctm?language=objc)
    #[cfg(feature = "NSImageRep")]
    pub static NSImageHintCTM: &'static NSImageHintKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagehintinterpolation?language=objc)
    #[cfg(feature = "NSImageRep")]
    pub static NSImageHintInterpolation: &'static NSImageHintKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagehintuserinterfacelayoutdirection?language=objc)
    #[cfg(feature = "NSImageRep")]
    pub static NSImageHintUserInterfaceLayoutDirection: &'static NSImageHintKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimageloadstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageLoadStatus(pub NSUInteger);
impl NSImageLoadStatus {
    #[doc(alias = "NSImageLoadStatusCompleted")]
    pub const Completed: Self = Self(0);
    #[doc(alias = "NSImageLoadStatusCancelled")]
    pub const Cancelled: Self = Self(1);
    #[doc(alias = "NSImageLoadStatusInvalidData")]
    pub const InvalidData: Self = Self(2);
    #[doc(alias = "NSImageLoadStatusUnexpectedEOF")]
    pub const UnexpectedEOF: Self = Self(3);
    #[doc(alias = "NSImageLoadStatusReadError")]
    pub const ReadError: Self = Self(4);
}

unsafe impl Encode for NSImageLoadStatus {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSImageLoadStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagecachemode?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageCacheMode(pub NSUInteger);
impl NSImageCacheMode {
    #[doc(alias = "NSImageCacheDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "NSImageCacheAlways")]
    pub const Always: Self = Self(1);
    #[doc(alias = "NSImageCacheBySize")]
    pub const BySize: Self = Self(2);
    #[doc(alias = "NSImageCacheNever")]
    pub const Never: Self = Self(3);
}

unsafe impl Encode for NSImageCacheMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSImageCacheMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimage?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSImage;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSImage {}
);

impl NSImage {
    extern_methods!(
        #[unsafe(method(imageNamed:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageNamed(name: &NSImageName) -> Option<Retained<NSImage>>;

        /// Creates a system symbol image with the specified name and value
        ///
        /// Parameter `name`: A name from the system’s SF Symbols catalog
        ///
        /// Parameter `description`: The image’s accessibility description. This description is used automatically by interface elements that display images. Like all accessibility descriptions, use a short localized string that does not include the name of the interface element. For instance, “delete” rather than “delete button”.
        #[unsafe(method(imageWithSystemSymbolName:accessibilityDescription:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithSystemSymbolName_accessibilityDescription(
            name: &NSString,
            description: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        /// Creates a system symbol image with the specified name and value. The
        /// `value`argument is only accommodated if the symbol supports variable rendering.
        ///
        /// Parameter `name`: A name from the system’s SF Symbols catalog
        ///
        /// Parameter `value`: The value represented by the symbol. The value should be between 0 and 1 inclusive ([0,1]).
        ///
        /// Parameter `description`: The image’s accessibility description. This description is used automatically by interface elements that display images. Like all accessibility descriptions, use a short localized string that does not include the name of the interface element. For instance, “delete” rather than “delete button”.
        ///
        /// Note: Values less than 0 or greater than 1 will be clamped to 0 and 1, respectively.
        #[unsafe(method(imageWithSystemSymbolName:variableValue:accessibilityDescription:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithSystemSymbolName_variableValue_accessibilityDescription(
            name: &NSString,
            value: c_double,
            description: Option<&NSString>,
        ) -> Option<Retained<Self>>;

        /// Creates a symbol image with the specified name and value. The
        /// `value`argument is only accommodated if the symbol supports variable rendering.
        ///
        /// Parameter `name`: A name of a symbol image file in the main bundle’s catalog
        ///
        /// Parameter `value`: The value represented by the symbol. The value should be between 0 and 1 inclusive ([0,1]).
        ///
        /// Note: Values less than 0 or greater than 1 will be clamped to 0 and 1, respectively.
        #[unsafe(method(imageWithSymbolName:variableValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithSymbolName_variableValue(
            name: &NSString,
            value: c_double,
        ) -> Option<Retained<Self>>;

        /// Creates a symbol image with the specified name and value. The
        /// `value`argument is only accommodated if the symbol supports variable rendering.
        ///
        /// Parameter `name`: A name of a symbol image file in the main bundle’s catalog
        ///
        /// Parameter `bundle`: The bundle containing the image file or asset catalog. Specify `nil` to search the app’s main bundle.
        ///
        /// Parameter `value`: The value represented by the symbol. The value should be between 0 and 1 inclusive ([0,1]).
        ///
        /// Note: Values less than 0 or greater than 1 will be clamped to 0 and 1, respectively.
        #[unsafe(method(imageWithSymbolName:bundle:variableValue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithSymbolName_bundle_variableValue(
            name: &NSString,
            bundle: Option<&NSBundle>,
            value: c_double,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithSize:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSize(this: Allocated<Self>, size: NSSize) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, coder: &NSCoder) -> Retained<Self>;

        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Option<Retained<Self>>;

        #[unsafe(method(initWithContentsOfFile:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfFile(
            this: Allocated<Self>,
            file_name: &NSString,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithContentsOfURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithContentsOfURL(
            this: Allocated<Self>,
            url: &NSURL,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initByReferencingFile:))]
        #[unsafe(method_family = init)]
        pub fn initByReferencingFile(
            this: Allocated<Self>,
            file_name: &NSString,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initByReferencingURL:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initByReferencingURL(this: Allocated<Self>, url: &NSURL) -> Retained<Self>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(initWithPasteboard:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPasteboard(
            this: Allocated<Self>,
            pasteboard: &NSPasteboard,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(initWithDataIgnoringOrientation:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithDataIgnoringOrientation(
            this: Allocated<Self>,
            data: &NSData,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(imageWithSize:flipped:drawingHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithSize_flipped_drawingHandler(
            size: NSSize,
            drawing_handler_should_be_called_with_flipped_context: bool,
            drawing_handler: &block2::DynBlock<dyn Fn(NSRect) -> Bool>,
        ) -> Retained<Self>;

        #[unsafe(method(size))]
        #[unsafe(method_family = none)]
        pub unsafe fn size(&self) -> NSSize;

        /// Setter for [`size`][Self::size].
        #[unsafe(method(setSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSize(&self, size: NSSize);

        #[unsafe(method(setName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setName(&self, string: Option<&NSImageName>) -> bool;

        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Option<Retained<NSImageName>>;

        #[cfg(feature = "NSColor")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundColor(&self) -> Retained<NSColor>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundColor(&self, background_color: &NSColor);

        #[unsafe(method(usesEPSOnResolutionMismatch))]
        #[unsafe(method_family = none)]
        pub unsafe fn usesEPSOnResolutionMismatch(&self) -> bool;

        /// Setter for [`usesEPSOnResolutionMismatch`][Self::usesEPSOnResolutionMismatch].
        #[unsafe(method(setUsesEPSOnResolutionMismatch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUsesEPSOnResolutionMismatch(&self, uses_eps_on_resolution_mismatch: bool);

        #[unsafe(method(prefersColorMatch))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersColorMatch(&self) -> bool;

        /// Setter for [`prefersColorMatch`][Self::prefersColorMatch].
        #[unsafe(method(setPrefersColorMatch:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPrefersColorMatch(&self, prefers_color_match: bool);

        #[unsafe(method(matchesOnMultipleResolution))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesOnMultipleResolution(&self) -> bool;

        /// Setter for [`matchesOnMultipleResolution`][Self::matchesOnMultipleResolution].
        #[unsafe(method(setMatchesOnMultipleResolution:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMatchesOnMultipleResolution(&self, matches_on_multiple_resolution: bool);

        #[unsafe(method(matchesOnlyOnBestFittingAxis))]
        #[unsafe(method_family = none)]
        pub unsafe fn matchesOnlyOnBestFittingAxis(&self) -> bool;

        /// Setter for [`matchesOnlyOnBestFittingAxis`][Self::matchesOnlyOnBestFittingAxis].
        #[unsafe(method(setMatchesOnlyOnBestFittingAxis:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMatchesOnlyOnBestFittingAxis(
            &self,
            matches_only_on_best_fitting_axis: bool,
        );

        #[cfg(all(feature = "NSGraphics", feature = "objc2-core-foundation"))]
        #[unsafe(method(drawAtPoint:fromRect:operation:fraction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawAtPoint_fromRect_operation_fraction(
            &self,
            point: NSPoint,
            from_rect: NSRect,
            op: NSCompositingOperation,
            delta: CGFloat,
        );

        #[cfg(all(feature = "NSGraphics", feature = "objc2-core-foundation"))]
        #[unsafe(method(drawInRect:fromRect:operation:fraction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawInRect_fromRect_operation_fraction(
            &self,
            rect: NSRect,
            from_rect: NSRect,
            op: NSCompositingOperation,
            delta: CGFloat,
        );

        #[cfg(all(
            feature = "NSGraphics",
            feature = "NSImageRep",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(drawInRect:fromRect:operation:fraction:respectFlipped:hints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawInRect_fromRect_operation_fraction_respectFlipped_hints(
            &self,
            dst_space_portion_rect: NSRect,
            src_space_portion_rect: NSRect,
            op: NSCompositingOperation,
            requested_alpha: CGFloat,
            respect_context_is_flipped: bool,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
        );

        #[cfg(feature = "NSImageRep")]
        #[unsafe(method(drawRepresentation:inRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawRepresentation_inRect(
            &self,
            image_rep: &NSImageRep,
            rect: NSRect,
        ) -> bool;

        #[unsafe(method(drawInRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn drawInRect(&self, rect: NSRect);

        #[unsafe(method(recache))]
        #[unsafe(method_family = none)]
        pub unsafe fn recache(&self);

        #[unsafe(method(TIFFRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn TIFFRepresentation(&self) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSBitmapImageRep")]
        #[unsafe(method(TIFFRepresentationUsingCompression:factor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn TIFFRepresentationUsingCompression_factor(
            &self,
            comp: NSTIFFCompression,
            factor: c_float,
        ) -> Option<Retained<NSData>>;

        #[cfg(feature = "NSImageRep")]
        #[unsafe(method(representations))]
        #[unsafe(method_family = none)]
        pub unsafe fn representations(&self) -> Retained<NSArray<NSImageRep>>;

        #[cfg(feature = "NSImageRep")]
        #[unsafe(method(addRepresentations:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addRepresentations(&self, image_reps: &NSArray<NSImageRep>);

        #[cfg(feature = "NSImageRep")]
        #[unsafe(method(addRepresentation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addRepresentation(&self, image_rep: &NSImageRep);

        #[cfg(feature = "NSImageRep")]
        #[unsafe(method(removeRepresentation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeRepresentation(&self, image_rep: &NSImageRep);

        #[unsafe(method(isValid))]
        #[unsafe(method_family = none)]
        pub unsafe fn isValid(&self) -> bool;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSImageDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSImageDelegate>>);

        #[unsafe(method(imageTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageTypes() -> Retained<NSArray<NSString>>;

        #[unsafe(method(imageUnfilteredTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageUnfilteredTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[unsafe(method(canInitWithPasteboard:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canInitWithPasteboard(pasteboard: &NSPasteboard) -> bool;

        #[unsafe(method(cacheMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn cacheMode(&self) -> NSImageCacheMode;

        /// Setter for [`cacheMode`][Self::cacheMode].
        #[unsafe(method(setCacheMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCacheMode(&self, cache_mode: NSImageCacheMode);

        #[unsafe(method(alignmentRect))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignmentRect(&self) -> NSRect;

        /// Setter for [`alignmentRect`][Self::alignmentRect].
        #[unsafe(method(setAlignmentRect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlignmentRect(&self, alignment_rect: NSRect);

        #[unsafe(method(isTemplate))]
        #[unsafe(method_family = none)]
        pub unsafe fn isTemplate(&self) -> bool;

        /// Setter for [`isTemplate`][Self::isTemplate].
        #[unsafe(method(setTemplate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTemplate(&self, template: bool);

        #[unsafe(method(accessibilityDescription))]
        #[unsafe(method_family = none)]
        pub unsafe fn accessibilityDescription(&self) -> Option<Retained<NSString>>;

        /// Setter for [`accessibilityDescription`][Self::accessibilityDescription].
        #[unsafe(method(setAccessibilityDescription:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAccessibilityDescription(
            &self,
            accessibility_description: Option<&NSString>,
        );

        #[cfg(feature = "objc2-core-graphics")]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(initWithCGImage:size:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGImage_size(
            this: Allocated<Self>,
            cg_image: &CGImage,
            size: NSSize,
        ) -> Retained<Self>;

        #[cfg(all(
            feature = "NSGraphicsContext",
            feature = "NSImageRep",
            feature = "objc2-core-graphics"
        ))]
        #[cfg(target_vendor = "apple")]
        #[unsafe(method(CGImageForProposedRect:context:hints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn CGImageForProposedRect_context_hints(
            &self,
            proposed_dest_rect: *mut NSRect,
            reference_context: Option<&NSGraphicsContext>,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
        ) -> Option<Retained<CGImage>>;

        #[cfg(all(feature = "NSGraphicsContext", feature = "NSImageRep"))]
        #[unsafe(method(bestRepresentationForRect:context:hints:))]
        #[unsafe(method_family = none)]
        pub unsafe fn bestRepresentationForRect_context_hints(
            &self,
            rect: NSRect,
            reference_context: Option<&NSGraphicsContext>,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
        ) -> Option<Retained<NSImageRep>>;

        #[cfg(all(feature = "NSGraphicsContext", feature = "NSImageRep"))]
        #[unsafe(method(hitTestRect:withImageDestinationRect:context:hints:flipped:))]
        #[unsafe(method_family = none)]
        pub unsafe fn hitTestRect_withImageDestinationRect_context_hints_flipped(
            &self,
            test_rect_dest_space: NSRect,
            image_rect_dest_space: NSRect,
            context: Option<&NSGraphicsContext>,
            hints: Option<&NSDictionary<NSImageHintKey, AnyObject>>,
            flipped: bool,
        ) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(recommendedLayerContentsScale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn recommendedLayerContentsScale(
            &self,
            preferred_contents_scale: CGFloat,
        ) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(layerContentsForContentsScale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layerContentsForContentsScale(
            &self,
            layer_contents_scale: CGFloat,
        ) -> Retained<AnyObject>;

        #[unsafe(method(capInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn capInsets(&self) -> NSEdgeInsets;

        /// Setter for [`capInsets`][Self::capInsets].
        #[unsafe(method(setCapInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCapInsets(&self, cap_insets: NSEdgeInsets);

        #[unsafe(method(resizingMode))]
        #[unsafe(method_family = none)]
        pub unsafe fn resizingMode(&self) -> NSImageResizingMode;

        /// Setter for [`resizingMode`][Self::resizingMode].
        #[unsafe(method(setResizingMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setResizingMode(&self, resizing_mode: NSImageResizingMode);

        #[unsafe(method(imageWithSymbolConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithSymbolConfiguration(
            &self,
            configuration: &NSImageSymbolConfiguration,
        ) -> Option<Retained<NSImage>>;

        #[unsafe(method(symbolConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn symbolConfiguration(&self) -> Retained<NSImageSymbolConfiguration>;

        /// Creates and returns a new image with the specified locale. If the receiver contains locale-sensitive representations, the returned image will prefer to draw using representations appropriate for the specified locale. If locale is `nil`, the returned image uses the default behavior of choosing representations appropriate for the system’s currently-configured locale.
        #[unsafe(method(imageWithLocale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageWithLocale(&self, locale: Option<&NSLocale>) -> Retained<NSImage>;

        /// The image’s preferred locale for resolving representations, if one has been specified using `-imageWithLocale:`. Otherwise, `nil`.
        #[unsafe(method(locale))]
        #[unsafe(method_family = none)]
        pub unsafe fn locale(&self) -> Option<Retained<NSLocale>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSImage {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

impl NSImage {
    extern_methods!();
}

extern_conformance!(
    unsafe impl NSCopying for NSImage {}
);

unsafe impl CopyingHelper for NSImage {
    type Result = Self;
}

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardReading for NSImage {}
);

#[cfg(feature = "NSPasteboard")]
extern_conformance!(
    unsafe impl NSPasteboardWriting for NSImage {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for NSImage {}
);

impl NSImage {
    extern_methods!();
}

extern_conformance!(
    unsafe impl NSItemProviderReading for NSImage {}
);

extern_conformance!(
    unsafe impl NSItemProviderWriting for NSImage {}
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagedelegate?language=objc)
    pub unsafe trait NSImageDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(imageDidNotDraw:inRect:))]
        #[unsafe(method_family = none)]
        unsafe fn imageDidNotDraw_inRect(
            &self,
            sender: &NSImage,
            rect: NSRect,
        ) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[unsafe(method(image:willLoadRepresentation:))]
        #[unsafe(method_family = none)]
        unsafe fn image_willLoadRepresentation(&self, image: &NSImage, rep: &NSImageRep);

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[unsafe(method(image:didLoadRepresentationHeader:))]
        #[unsafe(method_family = none)]
        unsafe fn image_didLoadRepresentationHeader(&self, image: &NSImage, rep: &NSImageRep);

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[unsafe(method(image:didLoadPartOfRepresentation:withValidRows:))]
        #[unsafe(method_family = none)]
        unsafe fn image_didLoadPartOfRepresentation_withValidRows(
            &self,
            image: &NSImage,
            rep: &NSImageRep,
            rows: NSInteger,
        );

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "This method is no longer called on 10.4 or later."]
        #[optional]
        #[unsafe(method(image:didLoadRepresentation:withStatus:))]
        #[unsafe(method_family = none)]
        unsafe fn image_didLoadRepresentation_withStatus(
            &self,
            image: &NSImage,
            rep: &NSImageRep,
            status: NSImageLoadStatus,
        );
    }
);

mod private_NSBundleImageExtension {
    pub trait Sealed {}
}

/// Category on [`NSBundle`].
pub unsafe trait NSBundleImageExtension:
    ClassType + Sized + private_NSBundleImageExtension::Sealed
{
    extern_methods!(
        #[unsafe(method(imageForResource:))]
        #[unsafe(method_family = none)]
        unsafe fn imageForResource(&self, name: &NSImageName) -> Option<Retained<NSImage>>;

        #[unsafe(method(pathForImageResource:))]
        #[unsafe(method_family = none)]
        unsafe fn pathForImageResource(&self, name: &NSImageName) -> Option<Retained<NSString>>;

        #[unsafe(method(URLForImageResource:))]
        #[unsafe(method_family = none)]
        unsafe fn URLForImageResource(&self, name: &NSImageName) -> Option<Retained<NSURL>>;
    );
}

impl private_NSBundleImageExtension::Sealed for NSBundle {}
unsafe impl NSBundleImageExtension for NSBundle {}

/// Deprecated.
impl NSImage {
    extern_methods!(
        #[deprecated = "Use +imageUnfilteredTypes instead"]
        #[unsafe(method(imageUnfilteredFileTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageUnfilteredFileTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[deprecated = "Use +imageUnfilteredTypes instead"]
        #[unsafe(method(imageUnfilteredPasteboardTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageUnfilteredPasteboardTypes() -> Retained<NSArray<NSPasteboardType>>;

        #[deprecated = "Use +imageTypes instead"]
        #[unsafe(method(imageFileTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageFileTypes() -> Retained<NSArray<NSString>>;

        #[cfg(feature = "NSPasteboard")]
        #[deprecated = "Use +imageTypes instead"]
        #[unsafe(method(imagePasteboardTypes))]
        #[unsafe(method_family = none)]
        pub unsafe fn imagePasteboardTypes() -> Retained<NSArray<NSPasteboardType>>;

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "Use -[NSImage bestRepresentationForRect:context:hints:] instead.  Any deviceDescription dictionary is also a valid hints dictionary."]
        #[unsafe(method(bestRepresentationForDevice:))]
        #[unsafe(method_family = none)]
        pub unsafe fn bestRepresentationForDevice(
            &self,
            device_description: Option<&NSDictionary>,
        ) -> Option<Retained<NSImageRep>>;

        #[deprecated = "This method is incompatible with resolution-independent drawing and should not be used. Instead, use +[NSImage imageWithSize:flipped:drawingHandler:] to create a block-based image describing the desired image drawing, or use +[NSGraphicsContext graphicsContextWithBitmapImageRep:] to manipulate specific bitmap image representations."]
        #[unsafe(method(lockFocus))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockFocus(&self);

        #[deprecated = "This method is incompatible with resolution-independent drawing and should not be used. Instead, use +[NSImage imageWithSize:flipped:drawingHandler:] to create a block-based image describing the desired image drawing, or use +[NSGraphicsContext graphicsContextWithBitmapImageRep:] to manipulate specific bitmap image representations."]
        #[unsafe(method(lockFocusFlipped:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockFocusFlipped(&self, flipped: bool);

        #[deprecated = "This method is incompatible with resolution-independent drawing and should not be used. Instead, use +[NSImage imageWithSize:flipped:drawingHandler:] to create a block-based image describing the desired image drawing, or use +[NSGraphicsContext graphicsContextWithBitmapImageRep:] to manipulate specific bitmap image representations."]
        #[unsafe(method(unlockFocus))]
        #[unsafe(method_family = none)]
        pub unsafe fn unlockFocus(&self);

        #[deprecated = "The concept of flippedness for NSImage is deprecated.  Please see the AppKit 10.6 release notes for a discussion of why and for how to replace existing usage."]
        #[unsafe(method(setFlipped:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFlipped(&self, flag: bool);

        #[deprecated = "The concept of flippedness for NSImage is deprecated.  Please see the AppKit 10.6 release notes for a discussion of why and for how to replace existing usage."]
        #[unsafe(method(isFlipped))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFlipped(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(setScalesWhenResized:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setScalesWhenResized(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(scalesWhenResized))]
        #[unsafe(method_family = none)]
        pub unsafe fn scalesWhenResized(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(setDataRetained:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDataRetained(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(isDataRetained))]
        #[unsafe(method_family = none)]
        pub unsafe fn isDataRetained(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(setCachedSeparately:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCachedSeparately(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(isCachedSeparately))]
        #[unsafe(method_family = none)]
        pub unsafe fn isCachedSeparately(&self) -> bool;

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(setCacheDepthMatchesImageDepth:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCacheDepthMatchesImageDepth(&self, flag: bool);

        #[deprecated = "You should be able to remove use of this method without any replacement.  See 10.6 AppKit release notes for details."]
        #[unsafe(method(cacheDepthMatchesImageDepth))]
        #[unsafe(method_family = none)]
        pub unsafe fn cacheDepthMatchesImageDepth(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[unsafe(method(dissolveToPoint:fraction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dissolveToPoint_fraction(&self, point: NSPoint, fraction: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[unsafe(method(dissolveToPoint:fromRect:fraction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dissolveToPoint_fromRect_fraction(
            &self,
            point: NSPoint,
            rect: NSRect,
            fraction: CGFloat,
        );

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[unsafe(method(compositeToPoint:operation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compositeToPoint_operation(
            &self,
            point: NSPoint,
            operation: NSCompositingOperation,
        );

        #[cfg(feature = "NSGraphics")]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[unsafe(method(compositeToPoint:fromRect:operation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compositeToPoint_fromRect_operation(
            &self,
            point: NSPoint,
            rect: NSRect,
            operation: NSCompositingOperation,
        );

        #[cfg(all(feature = "NSGraphics", feature = "objc2-core-foundation"))]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[unsafe(method(compositeToPoint:operation:fraction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compositeToPoint_operation_fraction(
            &self,
            point: NSPoint,
            operation: NSCompositingOperation,
            fraction: CGFloat,
        );

        #[cfg(all(feature = "NSGraphics", feature = "objc2-core-foundation"))]
        #[deprecated = "Use -drawAtPoint:... or -drawInRect:... methods instead"]
        #[unsafe(method(compositeToPoint:fromRect:operation:fraction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compositeToPoint_fromRect_operation_fraction(
            &self,
            point: NSPoint,
            rect: NSRect,
            operation: NSCompositingOperation,
            fraction: CGFloat,
        );

        #[cfg(feature = "NSImageRep")]
        #[deprecated = "Create an image using +[NSImage imageWithSize:flipped:drawingHandler:], and begin your custom drawing with -[NSImageRep drawInRect:] instead."]
        #[unsafe(method(lockFocusOnRepresentation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn lockFocusOnRepresentation(&self, image_representation: Option<&NSImageRep>);

        #[deprecated = "This method does not perform any operation on 10.4 or later."]
        #[unsafe(method(cancelIncrementalLoad))]
        #[unsafe(method_family = none)]
        pub unsafe fn cancelIncrementalLoad(&self);
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameaddtemplate?language=objc)
    pub static NSImageNameAddTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamebluetoothtemplate?language=objc)
    pub static NSImageNameBluetoothTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamebonjour?language=objc)
    pub static NSImageNameBonjour: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamebookmarkstemplate?language=objc)
    pub static NSImageNameBookmarksTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamecaution?language=objc)
    pub static NSImageNameCaution: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamecomputer?language=objc)
    pub static NSImageNameComputer: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameenterfullscreentemplate?language=objc)
    pub static NSImageNameEnterFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameexitfullscreentemplate?language=objc)
    pub static NSImageNameExitFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamefolder?language=objc)
    pub static NSImageNameFolder: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamefolderburnable?language=objc)
    pub static NSImageNameFolderBurnable: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamefoldersmart?language=objc)
    pub static NSImageNameFolderSmart: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamefollowlinkfreestandingtemplate?language=objc)
    pub static NSImageNameFollowLinkFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamehometemplate?language=objc)
    pub static NSImageNameHomeTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameichattheatertemplate?language=objc)
    pub static NSImageNameIChatTheaterTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamelocklockedtemplate?language=objc)
    pub static NSImageNameLockLockedTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamelockunlockedtemplate?language=objc)
    pub static NSImageNameLockUnlockedTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamenetwork?language=objc)
    pub static NSImageNameNetwork: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamepathtemplate?language=objc)
    pub static NSImageNamePathTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamequicklooktemplate?language=objc)
    pub static NSImageNameQuickLookTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamerefreshfreestandingtemplate?language=objc)
    pub static NSImageNameRefreshFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamerefreshtemplate?language=objc)
    pub static NSImageNameRefreshTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameremovetemplate?language=objc)
    pub static NSImageNameRemoveTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamerevealfreestandingtemplate?language=objc)
    pub static NSImageNameRevealFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamesharetemplate?language=objc)
    pub static NSImageNameShareTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameslideshowtemplate?language=objc)
    pub static NSImageNameSlideshowTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamestatusavailable?language=objc)
    pub static NSImageNameStatusAvailable: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamestatusnone?language=objc)
    pub static NSImageNameStatusNone: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamestatuspartiallyavailable?language=objc)
    pub static NSImageNameStatusPartiallyAvailable: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamestatusunavailable?language=objc)
    pub static NSImageNameStatusUnavailable: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamestopprogressfreestandingtemplate?language=objc)
    pub static NSImageNameStopProgressFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamestopprogresstemplate?language=objc)
    pub static NSImageNameStopProgressTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametrashempty?language=objc)
    pub static NSImageNameTrashEmpty: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametrashfull?language=objc)
    pub static NSImageNameTrashFull: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameactiontemplate?language=objc)
    pub static NSImageNameActionTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamesmartbadgetemplate?language=objc)
    pub static NSImageNameSmartBadgeTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameiconviewtemplate?language=objc)
    pub static NSImageNameIconViewTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamelistviewtemplate?language=objc)
    pub static NSImageNameListViewTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamecolumnviewtemplate?language=objc)
    pub static NSImageNameColumnViewTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameflowviewtemplate?language=objc)
    pub static NSImageNameFlowViewTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameinvaliddatafreestandingtemplate?language=objc)
    pub static NSImageNameInvalidDataFreestandingTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamegoforwardtemplate?language=objc)
    pub static NSImageNameGoForwardTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamegobacktemplate?language=objc)
    pub static NSImageNameGoBackTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamegorighttemplate?language=objc)
    pub static NSImageNameGoRightTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamegolefttemplate?language=objc)
    pub static NSImageNameGoLeftTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamerightfacingtriangletemplate?language=objc)
    pub static NSImageNameRightFacingTriangleTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameleftfacingtriangletemplate?language=objc)
    pub static NSImageNameLeftFacingTriangleTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamedotmac?language=objc)
    pub static NSImageNameDotMac: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamemobileme?language=objc)
    pub static NSImageNameMobileMe: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamemultipledocuments?language=objc)
    pub static NSImageNameMultipleDocuments: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameuseraccounts?language=objc)
    pub static NSImageNameUserAccounts: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamepreferencesgeneral?language=objc)
    pub static NSImageNamePreferencesGeneral: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameadvanced?language=objc)
    pub static NSImageNameAdvanced: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameinfo?language=objc)
    pub static NSImageNameInfo: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamefontpanel?language=objc)
    pub static NSImageNameFontPanel: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamecolorpanel?language=objc)
    pub static NSImageNameColorPanel: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameuser?language=objc)
    pub static NSImageNameUser: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameusergroup?language=objc)
    pub static NSImageNameUserGroup: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameeveryone?language=objc)
    pub static NSImageNameEveryone: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameuserguest?language=objc)
    pub static NSImageNameUserGuest: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamemenuonstatetemplate?language=objc)
    pub static NSImageNameMenuOnStateTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenamemenumixedstatetemplate?language=objc)
    pub static NSImageNameMenuMixedStateTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenameapplicationicon?language=objc)
    pub static NSImageNameApplicationIcon: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaradddetailtemplate?language=objc)
    pub static NSImageNameTouchBarAddDetailTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraddtemplate?language=objc)
    pub static NSImageNameTouchBarAddTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaralarmtemplate?language=objc)
    pub static NSImageNameTouchBarAlarmTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraudioinputmutetemplate?language=objc)
    pub static NSImageNameTouchBarAudioInputMuteTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraudioinputtemplate?language=objc)
    pub static NSImageNameTouchBarAudioInputTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraudiooutputmutetemplate?language=objc)
    pub static NSImageNameTouchBarAudioOutputMuteTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraudiooutputvolumehightemplate?language=objc)
    pub static NSImageNameTouchBarAudioOutputVolumeHighTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraudiooutputvolumelowtemplate?language=objc)
    pub static NSImageNameTouchBarAudioOutputVolumeLowTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraudiooutputvolumemediumtemplate?language=objc)
    pub static NSImageNameTouchBarAudioOutputVolumeMediumTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaraudiooutputvolumeofftemplate?language=objc)
    pub static NSImageNameTouchBarAudioOutputVolumeOffTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarbookmarkstemplate?language=objc)
    pub static NSImageNameTouchBarBookmarksTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarcolorpickerfill?language=objc)
    pub static NSImageNameTouchBarColorPickerFill: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarcolorpickerfont?language=objc)
    pub static NSImageNameTouchBarColorPickerFont: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarcolorpickerstroke?language=objc)
    pub static NSImageNameTouchBarColorPickerStroke: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarcommunicationaudiotemplate?language=objc)
    pub static NSImageNameTouchBarCommunicationAudioTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarcommunicationvideotemplate?language=objc)
    pub static NSImageNameTouchBarCommunicationVideoTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarcomposetemplate?language=objc)
    pub static NSImageNameTouchBarComposeTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbardeletetemplate?language=objc)
    pub static NSImageNameTouchBarDeleteTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbardownloadtemplate?language=objc)
    pub static NSImageNameTouchBarDownloadTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarenterfullscreentemplate?language=objc)
    pub static NSImageNameTouchBarEnterFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarexitfullscreentemplate?language=objc)
    pub static NSImageNameTouchBarExitFullScreenTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarfastforwardtemplate?language=objc)
    pub static NSImageNameTouchBarFastForwardTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarfoldercopytotemplate?language=objc)
    pub static NSImageNameTouchBarFolderCopyToTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarfoldermovetotemplate?language=objc)
    pub static NSImageNameTouchBarFolderMoveToTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarfoldertemplate?language=objc)
    pub static NSImageNameTouchBarFolderTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbargetinfotemplate?language=objc)
    pub static NSImageNameTouchBarGetInfoTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbargobacktemplate?language=objc)
    pub static NSImageNameTouchBarGoBackTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbargodowntemplate?language=objc)
    pub static NSImageNameTouchBarGoDownTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbargoforwardtemplate?language=objc)
    pub static NSImageNameTouchBarGoForwardTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbargouptemplate?language=objc)
    pub static NSImageNameTouchBarGoUpTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarhistorytemplate?language=objc)
    pub static NSImageNameTouchBarHistoryTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbariconviewtemplate?language=objc)
    pub static NSImageNameTouchBarIconViewTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarlistviewtemplate?language=objc)
    pub static NSImageNameTouchBarListViewTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarmailtemplate?language=objc)
    pub static NSImageNameTouchBarMailTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarnewfoldertemplate?language=objc)
    pub static NSImageNameTouchBarNewFolderTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarnewmessagetemplate?language=objc)
    pub static NSImageNameTouchBarNewMessageTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaropeninbrowsertemplate?language=objc)
    pub static NSImageNameTouchBarOpenInBrowserTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarpausetemplate?language=objc)
    pub static NSImageNameTouchBarPauseTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarplaypausetemplate?language=objc)
    pub static NSImageNameTouchBarPlayPauseTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarplaytemplate?language=objc)
    pub static NSImageNameTouchBarPlayTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarquicklooktemplate?language=objc)
    pub static NSImageNameTouchBarQuickLookTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarrecordstarttemplate?language=objc)
    pub static NSImageNameTouchBarRecordStartTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarrecordstoptemplate?language=objc)
    pub static NSImageNameTouchBarRecordStopTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarrefreshtemplate?language=objc)
    pub static NSImageNameTouchBarRefreshTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarremovetemplate?language=objc)
    pub static NSImageNameTouchBarRemoveTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarrewindtemplate?language=objc)
    pub static NSImageNameTouchBarRewindTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarrotatelefttemplate?language=objc)
    pub static NSImageNameTouchBarRotateLeftTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarrotaterighttemplate?language=objc)
    pub static NSImageNameTouchBarRotateRightTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarsearchtemplate?language=objc)
    pub static NSImageNameTouchBarSearchTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarsharetemplate?language=objc)
    pub static NSImageNameTouchBarShareTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarsidebartemplate?language=objc)
    pub static NSImageNameTouchBarSidebarTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskipahead15secondstemplate?language=objc)
    pub static NSImageNameTouchBarSkipAhead15SecondsTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskipahead30secondstemplate?language=objc)
    pub static NSImageNameTouchBarSkipAhead30SecondsTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskipaheadtemplate?language=objc)
    pub static NSImageNameTouchBarSkipAheadTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskipback15secondstemplate?language=objc)
    pub static NSImageNameTouchBarSkipBack15SecondsTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskipback30secondstemplate?language=objc)
    pub static NSImageNameTouchBarSkipBack30SecondsTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskipbacktemplate?language=objc)
    pub static NSImageNameTouchBarSkipBackTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskiptoendtemplate?language=objc)
    pub static NSImageNameTouchBarSkipToEndTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarskiptostarttemplate?language=objc)
    pub static NSImageNameTouchBarSkipToStartTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarslideshowtemplate?language=objc)
    pub static NSImageNameTouchBarSlideshowTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartagicontemplate?language=objc)
    pub static NSImageNameTouchBarTagIconTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextboldtemplate?language=objc)
    pub static NSImageNameTouchBarTextBoldTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextboxtemplate?language=objc)
    pub static NSImageNameTouchBarTextBoxTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextcenteraligntemplate?language=objc)
    pub static NSImageNameTouchBarTextCenterAlignTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextitalictemplate?language=objc)
    pub static NSImageNameTouchBarTextItalicTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextjustifiedaligntemplate?language=objc)
    pub static NSImageNameTouchBarTextJustifiedAlignTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextleftaligntemplate?language=objc)
    pub static NSImageNameTouchBarTextLeftAlignTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextlisttemplate?language=objc)
    pub static NSImageNameTouchBarTextListTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextrightaligntemplate?language=objc)
    pub static NSImageNameTouchBarTextRightAlignTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextstrikethroughtemplate?language=objc)
    pub static NSImageNameTouchBarTextStrikethroughTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbartextunderlinetemplate?language=objc)
    pub static NSImageNameTouchBarTextUnderlineTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbaruseraddtemplate?language=objc)
    pub static NSImageNameTouchBarUserAddTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarusergrouptemplate?language=objc)
    pub static NSImageNameTouchBarUserGroupTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarusertemplate?language=objc)
    pub static NSImageNameTouchBarUserTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarvolumedowntemplate?language=objc)
    pub static NSImageNameTouchBarVolumeDownTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarvolumeuptemplate?language=objc)
    pub static NSImageNameTouchBarVolumeUpTemplate: &'static NSImageName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagenametouchbarplayheadtemplate?language=objc)
    pub static NSImageNameTouchBarPlayheadTemplate: &'static NSImageName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagesymbolscale?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSImageSymbolScale(pub NSInteger);
impl NSImageSymbolScale {
    #[doc(alias = "NSImageSymbolScaleSmall")]
    pub const Small: Self = Self(1);
    #[doc(alias = "NSImageSymbolScaleMedium")]
    pub const Medium: Self = Self(2);
    #[doc(alias = "NSImageSymbolScaleLarge")]
    pub const Large: Self = Self(3);
}

unsafe impl Encode for NSImageSymbolScale {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for NSImageSymbolScale {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsimagesymbolconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSImageSymbolConfiguration;
);

extern_conformance!(
    unsafe impl NSCoding for NSImageSymbolConfiguration {}
);

extern_conformance!(
    unsafe impl NSCopying for NSImageSymbolConfiguration {}
);

unsafe impl CopyingHelper for NSImageSymbolConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSImageSymbolConfiguration {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for NSImageSymbolConfiguration {}
);

impl NSImageSymbolConfiguration {
    extern_methods!(
        #[cfg(all(feature = "NSFontDescriptor", feature = "objc2-core-foundation"))]
        #[unsafe(method(configurationWithPointSize:weight:scale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithPointSize_weight_scale(
            point_size: CGFloat,
            weight: NSFontWeight,
            scale: NSImageSymbolScale,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSFontDescriptor", feature = "objc2-core-foundation"))]
        #[unsafe(method(configurationWithPointSize:weight:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithPointSize_weight(
            point_size: CGFloat,
            weight: NSFontWeight,
        ) -> Retained<Self>;

        #[cfg(feature = "NSFontDescriptor")]
        #[unsafe(method(configurationWithTextStyle:scale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithTextStyle_scale(
            style: &NSFontTextStyle,
            scale: NSImageSymbolScale,
        ) -> Retained<Self>;

        #[cfg(feature = "NSFontDescriptor")]
        #[unsafe(method(configurationWithTextStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithTextStyle(style: &NSFontTextStyle) -> Retained<Self>;

        #[unsafe(method(configurationWithScale:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithScale(scale: NSImageSymbolScale) -> Retained<Self>;

        /// Create a configuration that specifies that the symbol should prefer its monochrome variant.
        #[unsafe(method(configurationPreferringMonochrome))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationPreferringMonochrome() -> Retained<Self>;

        /// Create a configuration that specifies that the symbol should prefer its hierarchical variant, if one exists.
        ///
        /// If the symbol doesn’t support hierarchical, the result will be a monochrome (templated) symbol.
        #[unsafe(method(configurationPreferringHierarchical))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationPreferringHierarchical() -> Retained<Self>;

        #[cfg(feature = "NSColor")]
        /// Create a color configuration with a palette derived from one color.
        ///
        /// A color scheme will be created based on the provided color, deriving secondary and tertiary colors by reducing the intensity of the base color. This is typically (but not only) accomplished by reducing opacity of the primary color.
        ///
        /// When combined with another configuration creating a palette, the last specified configuration will win, overwriting the other color configuration.
        ///
        /// If the symbol doesn’t have a palette-based variant, the configuration will have no effect and the result will be a monochrome (templated) symbol.
        #[unsafe(method(configurationWithHierarchicalColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithHierarchicalColor(
            hierarchical_color: &NSColor,
        ) -> Retained<Self>;

        #[cfg(feature = "NSColor")]
        /// Create a color configuration by specifying a palette of colors. The colors are used sequentially per layer: the first color for the first layer, the second color for the second layer etc. This is independent of the hierarchy level of the layer.
        ///
        /// When combined with another configuration creating a palette, the last specified configuration will win, overwriting the other color configuration.
        ///
        /// If the symbol doesn’t have a palette-based variant, the configuration will have no effect and the result will be a monochrome (templated) symbol.
        #[unsafe(method(configurationWithPaletteColors:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationWithPaletteColors(
            palette_colors: &NSArray<NSColor>,
        ) -> Retained<Self>;

        /// Create a configuration that specifies that the symbol should prefer its multicolor variant, if one exists.
        ///
        /// This configuration can be combined with one of the palette-based configurations; in that case, the symbol will use the multicolor variant if one exists, or the palette variant otherwise.
        ///
        /// If the symbol supports neither, the result will be a monochrome (templated) symbol.
        #[unsafe(method(configurationPreferringMulticolor))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationPreferringMulticolor() -> Retained<Self>;

        /// Returns a new configuration object whose values are defined by applying values from the provided configuration and the receiver.
        ///
        /// Values defined by both configurations will use the provided configuration’s values.
        #[unsafe(method(configurationByApplyingConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn configurationByApplyingConfiguration(
            &self,
            configuration: &NSImageSymbolConfiguration,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSImageSymbolConfiguration {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
