// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief e+e- > D*+ + X
  class ARGUS_1985_I204851 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(ARGUS_1985_I204851);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // projections
      declare(UnstableParticles(Cuts::abspid==413), "UFS");
      // histos
      for(unsigned int ix=0;ix<2;++ix)
	book(_h_sigma[ix],1,1,1+ix);
      book(_h_spect,2,1,1);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const UnstableParticles& ufs = apply<UnstableParticles>(event, "UFS");
      for (const Particle& p : ufs.particles()) {
	double xp = p.p3().mod()/sqrt(0.25*sqr(sqrtS())-sqr(p.mass()));
	_h_spect->fill(xp);
	for(unsigned int ix=0;ix<2;++ix) {
	  _h_sigma[ix]->fill(2.);
	  if(xp>0.5) _h_sigma[ix]->fill(1.);
	}
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      double br[2] = {0.03947,0.0822};
      double fact = 0.677*crossSection()/sumOfWeights()/picobarn;
      for(unsigned int ix=0;ix<2;++ix) {
	scale(_h_sigma[ix],fact*br[ix]);
      }
      scale(_h_spect,sqr(sqrtS())*crossSection()/sumOfWeights()/microbarn);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h_spect,_h_sigma[2];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(ARGUS_1985_I204851);

}
