﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/autoscaling/model/InstanceCollection.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>

#include <utility>

using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

namespace Aws {
namespace AutoScaling {
namespace Model {

InstanceCollection::InstanceCollection(const XmlNode& xmlNode) { *this = xmlNode; }

InstanceCollection& InstanceCollection::operator=(const XmlNode& xmlNode) {
  XmlNode resultNode = xmlNode;

  if (!resultNode.IsNull()) {
    XmlNode instanceTypeNode = resultNode.FirstChild("InstanceType");
    if (!instanceTypeNode.IsNull()) {
      m_instanceType = Aws::Utils::Xml::DecodeEscapedXmlText(instanceTypeNode.GetText());
      m_instanceTypeHasBeenSet = true;
    }
    XmlNode marketTypeNode = resultNode.FirstChild("MarketType");
    if (!marketTypeNode.IsNull()) {
      m_marketType = Aws::Utils::Xml::DecodeEscapedXmlText(marketTypeNode.GetText());
      m_marketTypeHasBeenSet = true;
    }
    XmlNode subnetIdNode = resultNode.FirstChild("SubnetId");
    if (!subnetIdNode.IsNull()) {
      m_subnetId = Aws::Utils::Xml::DecodeEscapedXmlText(subnetIdNode.GetText());
      m_subnetIdHasBeenSet = true;
    }
    XmlNode availabilityZoneNode = resultNode.FirstChild("AvailabilityZone");
    if (!availabilityZoneNode.IsNull()) {
      m_availabilityZone = Aws::Utils::Xml::DecodeEscapedXmlText(availabilityZoneNode.GetText());
      m_availabilityZoneHasBeenSet = true;
    }
    XmlNode availabilityZoneIdNode = resultNode.FirstChild("AvailabilityZoneId");
    if (!availabilityZoneIdNode.IsNull()) {
      m_availabilityZoneId = Aws::Utils::Xml::DecodeEscapedXmlText(availabilityZoneIdNode.GetText());
      m_availabilityZoneIdHasBeenSet = true;
    }
    XmlNode instanceIdsNode = resultNode.FirstChild("InstanceIds");
    if (!instanceIdsNode.IsNull()) {
      XmlNode instanceIdsMember = instanceIdsNode.FirstChild("member");
      m_instanceIdsHasBeenSet = !instanceIdsMember.IsNull();
      while (!instanceIdsMember.IsNull()) {
        m_instanceIds.push_back(instanceIdsMember.GetText());
        instanceIdsMember = instanceIdsMember.NextNode("member");
      }

      m_instanceIdsHasBeenSet = true;
    }
  }

  return *this;
}

void InstanceCollection::OutputToStream(Aws::OStream& oStream, const char* location, unsigned index, const char* locationValue) const {
  if (m_instanceTypeHasBeenSet) {
    oStream << location << index << locationValue << ".InstanceType=" << StringUtils::URLEncode(m_instanceType.c_str()) << "&";
  }

  if (m_marketTypeHasBeenSet) {
    oStream << location << index << locationValue << ".MarketType=" << StringUtils::URLEncode(m_marketType.c_str()) << "&";
  }

  if (m_subnetIdHasBeenSet) {
    oStream << location << index << locationValue << ".SubnetId=" << StringUtils::URLEncode(m_subnetId.c_str()) << "&";
  }

  if (m_availabilityZoneHasBeenSet) {
    oStream << location << index << locationValue << ".AvailabilityZone=" << StringUtils::URLEncode(m_availabilityZone.c_str()) << "&";
  }

  if (m_availabilityZoneIdHasBeenSet) {
    oStream << location << index << locationValue << ".AvailabilityZoneId=" << StringUtils::URLEncode(m_availabilityZoneId.c_str()) << "&";
  }

  if (m_instanceIdsHasBeenSet) {
    unsigned instanceIdsIdx = 1;
    for (auto& item : m_instanceIds) {
      oStream << location << index << locationValue << ".InstanceIds.member." << instanceIdsIdx++ << "="
              << StringUtils::URLEncode(item.c_str()) << "&";
    }
  }
}

void InstanceCollection::OutputToStream(Aws::OStream& oStream, const char* location) const {
  if (m_instanceTypeHasBeenSet) {
    oStream << location << ".InstanceType=" << StringUtils::URLEncode(m_instanceType.c_str()) << "&";
  }
  if (m_marketTypeHasBeenSet) {
    oStream << location << ".MarketType=" << StringUtils::URLEncode(m_marketType.c_str()) << "&";
  }
  if (m_subnetIdHasBeenSet) {
    oStream << location << ".SubnetId=" << StringUtils::URLEncode(m_subnetId.c_str()) << "&";
  }
  if (m_availabilityZoneHasBeenSet) {
    oStream << location << ".AvailabilityZone=" << StringUtils::URLEncode(m_availabilityZone.c_str()) << "&";
  }
  if (m_availabilityZoneIdHasBeenSet) {
    oStream << location << ".AvailabilityZoneId=" << StringUtils::URLEncode(m_availabilityZoneId.c_str()) << "&";
  }
  if (m_instanceIdsHasBeenSet) {
    unsigned instanceIdsIdx = 1;
    for (auto& item : m_instanceIds) {
      oStream << location << ".InstanceIds.member." << instanceIdsIdx++ << "=" << StringUtils::URLEncode(item.c_str()) << "&";
    }
  }
}

}  // namespace Model
}  // namespace AutoScaling
}  // namespace Aws
