/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.build;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.build.BuildContext;
import org.eclipse.xtext.build.BuildRequest;
import org.eclipse.xtext.build.ResolvedResourceDescription;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class Indexer {
    @Inject
    private CompilerPhases compilerPhases;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public IndexResult computeAndIndexAffected(BuildRequest request, BuildContext context) {
        ResourceDescriptionsData previousIndex = context.getOldState().getResourceDescriptions();
        ResourceDescriptionsData newIndex = request.getState().getResourceDescriptions();
        ArrayList<IResourceDescription.Delta> deltas = new ArrayList<IResourceDescription.Delta>();
        deltas.addAll(this.getDeltasForDeletedResources(request, previousIndex, context));
        deltas.addAll(this.getDeltasForChangedResources(request.getDirtyFiles(), previousIndex, context));
        for (IResourceDescription.Delta delta : deltas) {
            newIndex.register(delta);
        }
        HashSet<IResourceDescription.Delta> allDeltas = new HashSet<IResourceDescription.Delta>(deltas);
        allDeltas.addAll(request.getExternalDeltas());
        ImmutableSet deltaSet = FluentIterable.from(deltas).transform(IResourceDescription.Delta::getUri).toSet();
        ImmutableList allAffected = FluentIterable.from(previousIndex.getAllResourceDescriptions()).transform(IResourceDescription::getURI).filter(arg_0 -> Indexer.lambda$2((Set)deltaSet, arg_0)).filter(it -> {
            IResourceServiceProvider resourceServiceProvider = context.getResourceServiceProvider((URI)it);
            if (resourceServiceProvider != null) {
                IResourceDescription.Manager manager = resourceServiceProvider.getResourceDescriptionManager();
                IResourceDescription resourceDescription = previousIndex.getResourceDescription((URI)it);
                return this.isAffected(resourceDescription, manager, allDeltas, allDeltas, newIndex);
            }
            IResourceDescription.Delta delta = this.getDeltaForDeletedResource((URI)it, previousIndex);
            if (delta != null) {
                deltas.add(delta);
            }
            return false;
        }).toList();
        deltas.addAll(this.getDeltasForChangedResources((Iterable<URI>)allAffected, previousIndex, context));
        return new IndexResult(deltas, newIndex);
    }

    protected List<IResourceDescription.Delta> getDeltasForDeletedResources(BuildRequest request, ResourceDescriptionsData oldIndex, BuildContext context) {
        ArrayList<IResourceDescription.Delta> deltas = new ArrayList<IResourceDescription.Delta>();
        if (oldIndex != null) {
            for (URI deleted : request.getDeletedFiles()) {
                IResourceServiceProvider resourceServiceProvider = context.getResourceServiceProvider(deleted);
                if (resourceServiceProvider == null) continue;
                this.operationCanceledManager.checkCanceled(context.getCancelIndicator());
                IResourceDescription.Delta delta = this.getDeltaForDeletedResource(deleted, oldIndex);
                if (delta == null) continue;
                deltas.add(delta);
            }
        }
        return deltas;
    }

    protected IResourceDescription.Delta getDeltaForDeletedResource(URI uri, ResourceDescriptionsData oldIndex) {
        IResourceDescription oldDescription = oldIndex.getResourceDescription(uri);
        if (oldDescription != null) {
            return new DefaultResourceDescriptionDelta(oldDescription, null);
        }
        return null;
    }

    protected List<IResourceDescription.Delta> getDeltasForChangedResources(Iterable<URI> affectedUris, ResourceDescriptionsData oldIndex, BuildContext context) {
        try {
            this.compilerPhases.setIndexing((Notifier)context.getResourceSet(), true);
            List list = IterableExtensions.toList(context.executeClustered(affectedUris, it -> this.addToIndex((Resource)it, true, oldIndex, context)));
            return list;
        }
        finally {
            this.compilerPhases.setIndexing((Notifier)context.getResourceSet(), false);
        }
    }

    protected IResourceDescription getResolvedResourceDescription(IResourceDescription description) {
        return new ResolvedResourceDescription(description);
    }

    protected IResourceDescription.Delta addToIndex(Resource resource, boolean isPreIndexing, ResourceDescriptionsData oldIndex, BuildContext context) {
        this.operationCanceledManager.checkCanceled(context.getCancelIndicator());
        URI uri = resource.getURI();
        IResourceServiceProvider serviceProvider = context.getResourceServiceProvider(uri);
        IResourceDescription.Manager manager = serviceProvider.getResourceDescriptionManager();
        IResourceDescription newDescription = manager.getResourceDescription(resource);
        IResourceDescription toBeAdded = this.getResolvedResourceDescription(newDescription);
        return manager.createDelta(oldIndex != null ? oldIndex.getResourceDescription(uri) : null, toBeAdded);
    }

    protected boolean isAffected(IResourceDescription affectionCandidate, IResourceDescription.Manager manager, Collection<IResourceDescription.Delta> newDeltas, Collection<IResourceDescription.Delta> allDeltas, IResourceDescriptions resourceDescriptions) {
        if (manager instanceof IResourceDescription.Manager.AllChangeAware) {
            return ((IResourceDescription.Manager.AllChangeAware)manager).isAffectedByAny(allDeltas, affectionCandidate, resourceDescriptions);
        }
        if (newDeltas.isEmpty()) {
            return false;
        }
        return manager.isAffected(newDeltas, affectionCandidate, resourceDescriptions);
    }

    private static /* synthetic */ boolean lambda$2(Set set, URI it) {
        return !set.contains(it);
    }

    public static class IndexResult {
        private final List<IResourceDescription.Delta> resourceDeltas;
        private final ResourceDescriptionsData newIndex;

        public IndexResult(List<IResourceDescription.Delta> resourceDeltas, ResourceDescriptionsData newIndex) {
            this.resourceDeltas = resourceDeltas;
            this.newIndex = newIndex;
        }

        public List<IResourceDescription.Delta> getResourceDeltas() {
            return this.resourceDeltas;
        }

        public ResourceDescriptionsData getNewIndex() {
            return this.newIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.resourceDeltas == null ? 0 : this.resourceDeltas.hashCode());
            return prime * result + (this.newIndex == null ? 0 : this.newIndex.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IndexResult other = (IndexResult)obj;
            if (this.resourceDeltas == null ? other.resourceDeltas != null : !this.resourceDeltas.equals(other.resourceDeltas)) {
                return false;
            }
            return !(this.newIndex == null ? other.newIndex != null : !this.newIndex.equals(other.newIndex));
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resourceDeltas", this.resourceDeltas);
            b.add("newIndex", (Object)this.newIndex);
            return b.toString();
        }
    }
}

