/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mam.element.MamElementFactory;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class MamPrefsIQProvider
extends IqProvider<MamPrefsIQ> {
    public static final MamPrefsIQProvider INSTANCE = new MamPrefsIQProvider();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MamPrefsIQ parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        MamElementFactory elementFactory = MamElementFactory.forParser(parser);
        String defaultBehaviorString = parser.getAttributeValue("", "default");
        MamPrefsIQ.DefaultBehavior defaultBehavior = null;
        if (defaultBehaviorString != null) {
            defaultBehavior = MamPrefsIQ.DefaultBehavior.valueOf(defaultBehaviorString);
        }
        List<Jid> alwaysJids = null;
        List<Jid> neverJids = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "always": {
                            alwaysJids = MamPrefsIQProvider.iterateJids(parser);
                            break block0;
                        }
                        case "never": {
                            neverJids = MamPrefsIQProvider.iterateJids(parser);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return elementFactory.newPrefsIQ(alwaysJids, neverJids, defaultBehavior);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static List<Jid> iterateJids(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<Jid> jids = new ArrayList<Jid>();
        int initialDepth = parser.getDepth();
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "jid": {
                            parser.next();
                            jids.add(JidCreate.from(parser.getText()));
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return jids;
                }
            }
        }
    }
}

