/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaProxyCreator
extends RubyObject {
    private static final int[] EMPTY = new int[0];
    final Class<?> elementType;
    int[] dimensions = EMPTY;

    public static RubyClass createArrayJavaProxyCreator(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyClass arrayJavaProxyCreator = runtime2.defineClass("ArrayJavaProxyCreator", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        arrayJavaProxyCreator.defineAnnotatedMethods(ArrayJavaProxyCreator.class);
        return arrayJavaProxyCreator;
    }

    ArrayJavaProxyCreator(ThreadContext context, Class<?> elementType, IRubyObject[] sizes) {
        this(context.runtime, elementType);
        assert (sizes.length > 0);
        this.aggregateDimensions(sizes);
    }

    private ArrayJavaProxyCreator(Ruby runtime2, Class<?> elementType) {
        super(runtime2, runtime2.getJavaSupport().getArrayJavaProxyCreatorClass());
        this.elementType = elementType;
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, checkArity=false)
    public final IRubyObject op_aref(ThreadContext context, IRubyObject[] sizes) {
        Arity.checkArgumentCount(context.runtime, sizes, 1, -1);
        this.aggregateDimensions(sizes);
        return this;
    }

    @JRubyMethod(name={"new", "new_instance"})
    public final ArrayJavaProxy new_instance(ThreadContext context) {
        return ArrayJavaProxy.newArray(context.runtime, this.elementType, this.dimensions);
    }

    private void aggregateDimensions(IRubyObject[] sizes) {
        int slen = sizes.length;
        if (slen == 0) {
            return;
        }
        int dlen = this.dimensions.length;
        int[] newDimensions = new int[dlen + slen];
        if (dlen == 1) {
            newDimensions[0] = this.dimensions[0];
        } else {
            System.arraycopy(this.dimensions, 0, newDimensions, 0, dlen);
        }
        for (int i2 = 0; i2 < slen; ++i2) {
            int size2;
            newDimensions[i2 + dlen] = size2 = (int)sizes[i2].convertToInteger().getLongValue();
        }
        this.dimensions = newDimensions;
    }
}

